/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.debug;

import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBinding;
import org.jruby.RubyBoolean;
import org.jruby.RubyFile;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNil;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.RubyThread;
import org.jruby.debug.Context;
import org.jruby.debug.DebugBreakpoint;
import org.jruby.debug.DebugContext;
import org.jruby.debug.DebugFrame;
import org.jruby.debug.Debugger;
import org.jruby.debug.Util;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.EventHook;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

final class DebugEventHook
extends EventHook {
    private final Debugger debugger;
    private final Ruby runtime;
    private int hookCount;
    private int lastDebuggedThnum;
    private int lastCheck;
    private boolean inDebugger;

    public DebugEventHook(Debugger debugger, Ruby ruby) {
        this.debugger = debugger;
        this.lastDebuggedThnum = -1;
        this.runtime = ruby;
    }

    public boolean isInterestedInEvent(RubyEvent rubyEvent) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eventHandler(ThreadContext threadContext, String string, String string2, int n, String string3, IRubyObject iRubyObject) {
        RubyThread rubyThread = threadContext.getThread();
        Debugger.DebugContextPair debugContextPair = this.debugger.threadContextLookup(rubyThread, true);
        if (debugContextPair.debugContext.isIgnored()) {
            return;
        }
        if (debugContextPair.debugContext.isSkipped()) {
            this.cleanUp(debugContextPair.debugContext);
            return;
        }
        if (string2 == null) {
            return;
        }
        if (debugContextPair.debugContext.isSuspended()) {
            RubyThread.stop((ThreadContext)threadContext, (IRubyObject)rubyThread);
        }
        DebugEventHook debugEventHook = this;
        synchronized (debugEventHook) {
            if (this.isInDebugger()) {
                return;
            }
            this.setInDebugger(true);
            try {
                this.processEvent(threadContext, Util.typeForEvent(string), string2, Util.relativizeToPWD(string2, rubyThread.getRuntime()), n, string3, iRubyObject, debugContextPair);
            }
            finally {
                this.setInDebugger(false);
            }
        }
    }

    private void processEvent(ThreadContext threadContext, RubyEvent rubyEvent, String string, String string2, int n, String string3, IRubyObject iRubyObject, Debugger.DebugContextPair debugContextPair) {
        if (this.debugger.isDebug()) {
            Util.logEvent(rubyEvent, string2, n, string3, iRubyObject);
        }
        ++this.hookCount;
        Ruby ruby = threadContext.getRuntime();
        IRubyObject iRubyObject2 = this.getNil();
        IRubyObject iRubyObject3 = this.getNil();
        Context context = debugContextPair.context;
        DebugContext debugContext = debugContextPair.debugContext;
        boolean bl = false;
        if (debugContext.isThreadPaused()) {
            debugContext.setStopNext(1);
            debugContext.setDestFrame(-1);
            bl = true;
        } else if (!debugContext.isForceMove() || debugContext.getLastLine() != n || debugContext.getLastFile() == null || !Util.areSameFiles(debugContext.getLastFile(), string2)) {
            debugContext.setEnableBreakpoint(true);
            bl = true;
        }
        if (RubyEvent.LINE == rubyEvent) {
            debugContext.setStepped(true);
        }
        block0 : switch (rubyEvent) {
            case LINE: {
                if (debugContext.getStackSize() == 0) {
                    this.saveCallFrame(rubyEvent, threadContext, string2, n, string3, debugContext);
                } else {
                    this.updateTopFrame(rubyEvent, debugContext, threadContext, string2, n, string3);
                }
                if (!this.debugger.getFileFilter().isAccepted(string)) break;
                if (this.debugger.isTracing() || debugContext.isTracing()) {
                    IRubyObject[] iRubyObjectArray = new IRubyObject[]{ruby.newString(string2), ruby.newFixnum(n)};
                    context.callMethod(threadContext, "at_tracing", iRubyObjectArray);
                }
                if (debugContext.getDestFrame() == -1 || debugContext.getStackSize() == debugContext.getDestFrame()) {
                    if (bl || !debugContext.isForceMove()) {
                        debugContext.setStopNext(debugContext.getStopNext() - 1);
                    }
                    if (debugContext.getStopNext() < 0) {
                        debugContext.setStopNext(-1);
                    }
                    if (bl || debugContext.isStepped() && !debugContext.isForceMove()) {
                        debugContext.setStopLine(debugContext.getStopLine() - 1);
                        debugContext.setStepped(false);
                    }
                } else if (debugContext.getStackSize() < debugContext.getDestFrame()) {
                    debugContext.setStopNext(0);
                }
                if (debugContext.getStopNext() != 0 && debugContext.getStopLine() != 0 && (iRubyObject2 = this.checkBreakpointsByPos(debugContext, string2, n)).isNil()) break;
                iRubyObject3 = threadContext != null ? RubyBinding.newBinding((Ruby)ruby, (Binding)threadContext.currentBinding()) : this.getNil();
                this.saveTopBinding(debugContext, iRubyObject3);
                debugContext.setStopReason(DebugContext.StopReason.STEP);
                if (!iRubyObject2.isNil()) {
                    if (!this.checkBreakpointExpression(threadContext, iRubyObject2, iRubyObject3) || !this.checkBreakpointHitCondition(iRubyObject2)) break;
                    if (iRubyObject2 != debugContext.getBreakpoint()) {
                        debugContext.setStopReason(DebugContext.StopReason.BREAKPOINT);
                        context.callMethod(threadContext, "at_breakpoint", iRubyObject2);
                    } else {
                        debugContext.setBreakpoint(this.getNil());
                    }
                }
                debugContext.setDestFrame(-1);
                debugContext.setStopLine(-1);
                debugContext.setStopNext(-1);
                this.callAtLine(threadContext, (IRubyObject)context, debugContext, ruby, string2, n);
                break;
            }
            case B_CALL: 
            case CALL: {
                this.saveCallFrame(rubyEvent, threadContext, string2, n, string3, debugContext);
                iRubyObject2 = this.checkBreakpointsByMethod(debugContext, iRubyObject, string3);
                if (iRubyObject2.isNil()) break;
                DebugFrame debugFrame = this.getTopFrame(debugContext);
                if (debugFrame != null) {
                    iRubyObject3 = debugFrame.getBinding();
                }
                if (threadContext != null && iRubyObject3.isNil()) {
                    iRubyObject3 = RubyBinding.newBinding((Ruby)ruby, (Binding)threadContext.currentBinding());
                }
                this.saveTopBinding(debugContext, iRubyObject3);
                if (!this.checkBreakpointExpression(threadContext, iRubyObject2, iRubyObject3) || !this.checkBreakpointHitCondition(iRubyObject2)) break;
                if (iRubyObject2 != debugContext.getBreakpoint()) {
                    debugContext.setStopReason(DebugContext.StopReason.BREAKPOINT);
                    context.callMethod(threadContext, "at_breakpoint", iRubyObject2);
                } else {
                    debugContext.setBreakpoint(this.getNil());
                }
                this.callAtLine(threadContext, (IRubyObject)context, debugContext, ruby, string2, n);
                break;
            }
            case C_CALL: {
                if (this.cCallNewFrameP(iRubyObject)) {
                    this.saveCallFrame(rubyEvent, threadContext, string2, n, string3, debugContext);
                    break;
                }
                this.updateTopFrame(rubyEvent, debugContext, threadContext, string2, n, string3);
                break;
            }
            case C_RETURN: {
                if (!this.cCallNewFrameP(iRubyObject)) break;
            }
            case B_RETURN: 
            case RETURN: 
            case END: {
                DebugFrame debugFrame;
                String string4;
                if (debugContext.getStackSize() == debugContext.getStopFrame()) {
                    debugContext.setStopNext(1);
                    debugContext.setStopFrame(0);
                }
                while (!(debugContext.getStackSize() <= 0 || (string4 = (debugFrame = debugContext.popFrame()).getOrigMethodName()) == null && string3 == null || string4 != null && string4.equals(string3))) {
                }
                debugContext.setEnableBreakpoint(true);
                break;
            }
            case CLASS: {
                this.resetTopFrameMethodName(debugContext);
                this.saveCallFrame(rubyEvent, threadContext, string2, n, string3, debugContext);
                break;
            }
            case RAISE: {
                this.updateTopFrame(rubyEvent, debugContext, threadContext, string2, n, string3);
                IRubyObject iRubyObject4 = ruby.getGlobalVariables().get("$!");
                if (iRubyObject4.isNil() || ruby.getClass("SystemExit").isInstance(iRubyObject4) || this.debugger.getCatchpoints().isNil() || this.debugger.getCatchpoints().isEmpty() || !this.debugger.getFileFilter().isAccepted(string)) break;
                RubyArray rubyArray = iRubyObject4.getType().ancestors(threadContext);
                int n2 = rubyArray.getLength();
                for (int i = 0; i < n2; ++i) {
                    RubyModule rubyModule = (RubyModule)rubyArray.get(i);
                    IRubyObject iRubyObject5 = rubyModule.name();
                    IRubyObject iRubyObject6 = this.debugger.getCatchpoints().op_aref(threadContext, iRubyObject5);
                    if (iRubyObject6.isNil()) continue;
                    iRubyObject6 = ruby.newFixnum(RubyFixnum.fix2int((IRubyObject)iRubyObject6) + 1);
                    this.debugger.getCatchpoints().op_aset(threadContext, iRubyObject5, iRubyObject6);
                    debugContext.setStopReason(DebugContext.StopReason.CATCHPOINT);
                    context.callMethod(threadContext, "at_catchpoint", iRubyObject4);
                    DebugFrame debugFrame = this.getTopFrame(debugContext);
                    if (debugFrame != null) {
                        iRubyObject3 = debugFrame.getBinding();
                    }
                    if (threadContext != null && iRubyObject3.isNil()) {
                        iRubyObject3 = RubyBinding.newBinding((Ruby)ruby, (Binding)threadContext.currentBinding());
                    }
                    this.saveTopBinding(debugContext, iRubyObject3);
                    this.callAtLine(threadContext, (IRubyObject)context, debugContext, ruby, string2, n);
                    break block0;
                }
                break;
            }
            case THREAD_BEGIN: 
            case THREAD_END: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown event type: " + rubyEvent);
            }
        }
        this.cleanUp(debugContext);
    }

    private IRubyObject getNil() {
        return this.runtime.getNil();
    }

    private IRubyObject getBreakpoints() {
        return this.debugger.getBreakpoints();
    }

    private void cleanUp(DebugContext debugContext) {
        debugContext.setStopReason(DebugContext.StopReason.NONE);
        if (this.hookCount - this.lastCheck > 3000) {
            this.debugger.checkThreadContexts(this.runtime);
            this.lastCheck = this.hookCount;
        }
    }

    private void saveCallFrame(RubyEvent rubyEvent, ThreadContext threadContext, String string, int n, String string2, DebugContext debugContext) {
        IRubyObject iRubyObject = this.debugger.isKeepFrameBinding() ? RubyBinding.newBinding((Ruby)threadContext.getRuntime(), (Binding)threadContext.currentBinding()) : threadContext.getRuntime().getNil();
        DebugFrame debugFrame = new DebugFrame();
        debugFrame.setFile(string);
        debugFrame.setLine(n);
        debugFrame.setBinding(iRubyObject);
        debugFrame.setMethodName(string2);
        debugFrame.setOrigMethodName(string2);
        debugFrame.setDead(false);
        debugFrame.setSelf(threadContext.getFrameSelf());
        DebugFrame.Info info = debugFrame.getInfo();
        info.setFrame(threadContext.getCurrentFrame());
        info.setScope(threadContext.getCurrentScope().getStaticScope());
        info.setDynaVars(rubyEvent == RubyEvent.LINE ? threadContext.getCurrentScope() : null);
        debugContext.addFrame(debugFrame);
        if (this.debugger.isTrackFrameArgs()) {
            this.copyScalarArgs(threadContext, debugFrame);
        } else {
            debugFrame.setArgValues(this.runtime.getNil());
        }
    }

    private boolean isArgValueSmall(IRubyObject iRubyObject) {
        return iRubyObject == RubyObject.UNDEF || iRubyObject instanceof RubyFixnum || iRubyObject instanceof RubyFloat || iRubyObject instanceof RubyNil || iRubyObject instanceof RubyModule || iRubyObject instanceof RubyFile || iRubyObject instanceof RubyBoolean || iRubyObject instanceof RubySymbol;
    }

    private void copyScalarArgs(ThreadContext threadContext, DebugFrame debugFrame) {
        RubyArray rubyArray = this.runtime.newArray(threadContext.getCurrentScope().getArgValues());
        int n = rubyArray.getLength();
        for (int i = 0; i < n; ++i) {
            IRubyObject iRubyObject = rubyArray.entry(i);
            if (iRubyObject == null) {
                iRubyObject = this.runtime.getNil();
            }
            if (this.isArgValueSmall(iRubyObject)) continue;
            rubyArray.store((long)i, (IRubyObject)this.runtime.newString(iRubyObject.getType().getName()));
        }
        debugFrame.setArgValues((IRubyObject)rubyArray);
    }

    private void updateTopFrame(RubyEvent rubyEvent, DebugContext debugContext, ThreadContext threadContext, String string, int n, String string2) {
        DebugFrame debugFrame = this.getTopFrame(debugContext);
        if (debugFrame != null) {
            debugFrame.setSelf(threadContext.getFrameSelf());
            debugFrame.setFile(string);
            debugFrame.setLine(n);
            debugFrame.setMethodName(string2);
            debugFrame.getInfo().setDynaVars(threadContext.getCurrentScope());
        }
    }

    private DebugFrame getTopFrame(DebugContext debugContext) {
        if (debugContext.getStackSize() == 0) {
            return null;
        }
        return debugContext.getTopFrame();
    }

    private IRubyObject checkBreakpointsByPos(DebugContext debugContext, String string, int n) {
        if (!debugContext.isEnableBreakpoint()) {
            return this.getNil();
        }
        if (this.checkBreakpointByPos(debugContext.getBreakpoint(), string, n)) {
            return debugContext.getBreakpoint();
        }
        RubyArray rubyArray = this.getBreakpoints().convertToArray();
        if (rubyArray.isEmpty()) {
            return this.getNil();
        }
        for (int i = 0; i < rubyArray.size(); ++i) {
            IRubyObject iRubyObject = rubyArray.entry(i);
            if (!this.checkBreakpointByPos(iRubyObject, string, n)) continue;
            return iRubyObject;
        }
        return this.getNil();
    }

    private boolean checkBreakpointByPos(IRubyObject iRubyObject, String string, int n) {
        if (iRubyObject.isNil()) {
            return false;
        }
        DebugBreakpoint debugBreakpoint = (DebugBreakpoint)iRubyObject.dataGetStruct();
        if (!debugBreakpoint.isEnabled()) {
            return false;
        }
        if (debugBreakpoint.getType() != DebugBreakpoint.Type.POS) {
            return false;
        }
        if (debugBreakpoint.getPos().getLine() != n) {
            return false;
        }
        String string2 = debugBreakpoint.getSource().toString();
        if (string2.startsWith("./")) {
            string2 = string2.substring(2);
        }
        if (string.startsWith("./")) {
            string = string.substring(2);
        }
        return string2.endsWith(string) || string.endsWith(string2);
    }

    private IRubyObject checkBreakpointsByMethod(DebugContext debugContext, IRubyObject iRubyObject, String string) {
        if (!debugContext.isEnableBreakpoint()) {
            return this.getNil();
        }
        if (this.checkBreakpointByMethod(debugContext.getBreakpoint(), iRubyObject, string)) {
            return debugContext.getBreakpoint();
        }
        RubyArray rubyArray = this.getBreakpoints().convertToArray();
        if (rubyArray.isEmpty()) {
            return this.getNil();
        }
        for (int i = 0; i < rubyArray.size(); ++i) {
            IRubyObject iRubyObject2 = rubyArray.entry(i);
            if (!this.checkBreakpointByMethod(iRubyObject2, iRubyObject, string)) continue;
            return iRubyObject2;
        }
        return this.getNil();
    }

    private boolean checkBreakpointByMethod(IRubyObject iRubyObject, IRubyObject iRubyObject2, String string) {
        if (iRubyObject.isNil()) {
            return false;
        }
        DebugBreakpoint debugBreakpoint = (DebugBreakpoint)iRubyObject.dataGetStruct();
        if (!debugBreakpoint.isEnabled()) {
            return false;
        }
        if (debugBreakpoint.getType() != DebugBreakpoint.Type.METHOD) {
            return false;
        }
        if (!debugBreakpoint.getPos().getMethodName().equals(string)) {
            return false;
        }
        RubyString rubyString = debugBreakpoint.getSource().asString();
        if (rubyString.eql((IRubyObject)iRubyObject2.asString())) {
            return true;
        }
        return iRubyObject2 instanceof MetaClass && rubyString.eql((IRubyObject)((MetaClass)iRubyObject2).getAttached().asString());
    }

    private boolean checkBreakpointExpression(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        DebugBreakpoint debugBreakpoint = (DebugBreakpoint)iRubyObject.dataGetStruct();
        if (debugBreakpoint.getExpr().isNil()) {
            return true;
        }
        try {
            IRubyObject iRubyObject3 = RubyKernel.eval((ThreadContext)threadContext, (IRubyObject)iRubyObject, (IRubyObject[])new IRubyObject[]{debugBreakpoint.getExpr(), iRubyObject2}, (Block)Block.NULL_BLOCK);
            return iRubyObject3.isTrue();
        }
        catch (RaiseException raiseException) {
            return false;
        }
    }

    private boolean checkBreakpointHitCondition(IRubyObject iRubyObject) {
        DebugBreakpoint debugBreakpoint = (DebugBreakpoint)iRubyObject.dataGetStruct();
        debugBreakpoint.setHitCount(debugBreakpoint.getHitCount() + 1);
        if (debugBreakpoint.getHitCondition() == null) {
            return true;
        }
        switch (debugBreakpoint.getHitCondition()) {
            case NONE: {
                return true;
            }
            case GE: {
                if (debugBreakpoint.getHitCount() < debugBreakpoint.getHitValue()) break;
                return true;
            }
            case EQ: {
                if (debugBreakpoint.getHitCount() != debugBreakpoint.getHitValue()) break;
                return true;
            }
            case MOD: {
                if (debugBreakpoint.getHitCount() % debugBreakpoint.getHitValue() != 0) break;
                return true;
            }
            default: {
                throw new IllegalArgumentException("unknown hit condition: " + (Object)((Object)debugBreakpoint.getHitCondition()));
            }
        }
        return false;
    }

    private void saveTopBinding(DebugContext debugContext, IRubyObject iRubyObject) {
        DebugFrame debugFrame = this.getTopFrame(debugContext);
        if (debugFrame != null) {
            debugFrame.setBinding(iRubyObject);
        }
    }

    private IRubyObject callAtLine(ThreadContext threadContext, IRubyObject iRubyObject, DebugContext debugContext, Ruby ruby, String string, int n) {
        return this.callAtLine(threadContext, iRubyObject, debugContext, (IRubyObject)ruby.newString(string), (IRubyObject)ruby.newFixnum(n));
    }

    private IRubyObject callAtLine(ThreadContext threadContext, IRubyObject iRubyObject, DebugContext debugContext, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        this.lastDebuggedThnum = debugContext.getThnum();
        this.saveCurrentPosition(debugContext);
        this.debugger.removePauseFlag(iRubyObject);
        IRubyObject[] iRubyObjectArray = new IRubyObject[]{iRubyObject2, iRubyObject3};
        return iRubyObject.callMethod(threadContext, "at_line", iRubyObjectArray);
    }

    private void saveCurrentPosition(DebugContext debugContext) {
        DebugFrame debugFrame = this.getTopFrame(debugContext);
        if (debugFrame == null) {
            return;
        }
        debugContext.setLastFile(debugFrame.getFile());
        debugContext.setLastLine(debugFrame.getLine());
        debugContext.setEnableBreakpoint(false);
        debugContext.setStepped(false);
        debugContext.setForceMove(false);
    }

    private boolean cCallNewFrameP(IRubyObject iRubyObject) {
        String string = (iRubyObject = this.realClass(iRubyObject)).getType().getName();
        return "Proc".equals(string) || "RubyKernel".equals(string) || "Module".equals(string);
    }

    private IRubyObject realClass(IRubyObject iRubyObject) {
        if (iRubyObject instanceof MetaClass) {
            return ((MetaClass)iRubyObject).getRealClass();
        }
        return iRubyObject;
    }

    private void resetTopFrameMethodName(DebugContext debugContext) {
        DebugFrame debugFrame = this.getTopFrame(debugContext);
        if (debugFrame != null) {
            debugFrame.setMethodName("");
        }
    }

    private boolean isInDebugger() {
        return this.inDebugger;
    }

    private void setInDebugger(boolean bl) {
        this.inDebugger = bl;
    }

    int getLastDebuggedThnum() {
        return this.lastDebuggedThnum;
    }
}

