/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.debug;

import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyString;
import org.jruby.RubyThread;
import org.jruby.debug.Context;
import org.jruby.debug.DebugBreakpoint;
import org.jruby.debug.DebugContext;
import org.jruby.debug.DebugEventHook;
import org.jruby.debug.FileFilter;
import org.jruby.debug.Util;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.EventHook;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Debugger {
    private DebugEventHook debugEventHook;
    private Map<RubyThread, Context> threadsTable;
    private IRubyObject breakpoints;
    private IRubyObject catchpoints;
    private FileFilter fileFilter;
    private boolean tracing;
    private boolean postMortem;
    private boolean keepFrameBinding;
    private boolean debug;
    private boolean trackFrameArgs;
    private IRubyObject lastThread;
    private IRubyObject lastContext;
    private DebugContext lastDebugContext;
    private boolean started;
    private int startCount;
    private int lastBreakpointID;

    Debugger() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IRubyObject start(IRubyObject iRubyObject, Block block) {
        IRubyObject iRubyObject2;
        RubyBoolean rubyBoolean;
        Ruby ruby = iRubyObject.getRuntime();
        ++this.startCount;
        if (this.started) {
            rubyBoolean = ruby.getFalse();
        } else {
            this.lastThread = iRubyObject2 = ruby.getNil();
            this.lastContext = iRubyObject2;
            this.lastDebugContext = null;
            this.started = true;
            this.debugEventHook = new DebugEventHook(this, ruby);
            this.breakpoints = ruby.newArray();
            RubyClass rubyClass = ruby.getModule("Debugger").getClass("FileFilter");
            this.fileFilter = (FileFilter)rubyClass.allocate();
            this.catchpoints = RubyHash.newHash((Ruby)ruby);
            this.threadsTable = new IdentityHashMap<RubyThread, Context>();
            ruby.addEventHook((EventHook)this.debugEventHook);
            rubyBoolean = ruby.getTrue();
        }
        if (block.isGiven()) {
            try {
                iRubyObject2 = block.yield(ruby.getCurrentContext(), iRubyObject);
                return iRubyObject2;
            }
            finally {
                this.stop(ruby);
            }
        }
        return rubyBoolean;
    }

    boolean stop(Ruby ruby) {
        IRubyObject iRubyObject;
        this.checkStarted(ruby);
        --this.startCount;
        if (this.startCount > 0) {
            return false;
        }
        ruby.removeEventHook((EventHook)this.debugEventHook);
        this.breakpoints = null;
        this.catchpoints = null;
        this.debugEventHook = null;
        this.started = false;
        this.threadsTable = null;
        this.lastThread = iRubyObject = ruby.getNil();
        this.lastContext = iRubyObject;
        this.lastDebugContext = null;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IRubyObject load(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        Ruby ruby = iRubyObject.getRuntime();
        Arity.checkArgumentCount((Ruby)ruby, (IRubyObject[])iRubyObjectArray, (int)1, (int)3);
        IRubyObject[] iRubyObjectArray2 = Arity.scanArgs((Ruby)ruby, (IRubyObject[])iRubyObjectArray, (int)1, (int)2);
        IRubyObject iRubyObject2 = iRubyObjectArray[0];
        IRubyObject iRubyObject3 = iRubyObjectArray2[1];
        IRubyObject iRubyObject4 = iRubyObjectArray2[2];
        this.start(iRubyObject, Block.NULL_BLOCK);
        if (!iRubyObject4.isTrue()) {
            --this.startCount;
        }
        IRubyObject iRubyObject5 = this.getCurrentContext(iRubyObject);
        DebugContext debugContext = (DebugContext)iRubyObject5.dataGetStruct();
        debugContext.clearFrames();
        if (iRubyObject3.isTrue()) {
            debugContext.setStopNext(1);
        }
        ruby.getGlobalVariables().set("$0", iRubyObject2);
        try {
            RubyString rubyString = iRubyObject2.convertToString();
            ruby.getLoadService().load(rubyString.getByteList().toString(), false);
            IRubyObject iRubyObject6 = ruby.getNil();
            return iRubyObject6;
        }
        catch (RaiseException raiseException) {
            this.suspend(iRubyObject);
            RubyException rubyException = raiseException.getException();
            return rubyException;
        }
        finally {
            debugContext.resetSteppingStopPoints();
        }
    }

    IRubyObject getCurrentContext(IRubyObject iRubyObject) {
        this.checkStarted(iRubyObject);
        RubyThread rubyThread = iRubyObject.getRuntime().getCurrentContext().getThread();
        return this.contextForThread(rubyThread);
    }

    DebugContext getCurrentDebugContext(IRubyObject iRubyObject) {
        this.checkStarted(iRubyObject);
        RubyThread rubyThread = iRubyObject.getRuntime().getCurrentContext().getThread();
        return this.threadContextLookup((RubyThread)rubyThread, (boolean)true).debugContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DebugContextPair threadContextLookup(RubyThread rubyThread, boolean bl) {
        this.checkStarted((IRubyObject)rubyThread);
        DebugContextPair debugContextPair = new DebugContextPair();
        Map<RubyThread, Context> map = this.threadsTable;
        synchronized (map) {
            if (this.lastThread == rubyThread && !this.lastContext.isNil()) {
                debugContextPair.context = (Context)this.lastContext;
                if (bl) {
                    debugContextPair.debugContext = this.lastDebugContext;
                }
                return debugContextPair;
            }
            debugContextPair.context = this.threadsTable.get(rubyThread);
            if (debugContextPair.context == null) {
                debugContextPair.context = this.debugContextCreate(rubyThread);
                this.threadsTable.put(rubyThread, debugContextPair.context);
            }
            DebugContext debugContext = (DebugContext)debugContextPair.context.dataGetStruct();
            if (bl) {
                debugContextPair.debugContext = debugContext;
            }
            this.lastThread = rubyThread;
            this.lastContext = debugContextPair.context;
            this.lastDebugContext = debugContext;
        }
        return debugContextPair;
    }

    private Context contextForThread(RubyThread rubyThread) {
        return this.threadContextLookup((RubyThread)rubyThread, (boolean)false).context;
    }

    void checkStarted(IRubyObject iRubyObject) {
        this.checkStarted(iRubyObject.getRuntime());
    }

    void checkStarted(Ruby ruby) {
        if (!this.started) {
            throw ruby.newRuntimeError("Debugger.start is not called yet.");
        }
    }

    private Context debugContextCreate(RubyThread rubyThread) {
        DebugContext debugContext = new DebugContext(rubyThread);
        if (rubyThread.getType().getName().equals("Debugger::DebugThread")) {
            debugContext.setIgnored(true);
        }
        RubyClass rubyClass = rubyThread.getRuntime().getModule("Debugger").getClass("Context");
        Context context = (Context)rubyClass.allocate();
        context.dataWrapStruct(debugContext);
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IRubyObject getDebugContexts(IRubyObject iRubyObject) {
        this.checkStarted(iRubyObject);
        RubyArray rubyArray = iRubyObject.getRuntime().newArray();
        RubyArray rubyArray2 = RubyThread.list((IRubyObject)iRubyObject);
        Map<RubyThread, Context> map = this.threadsTable;
        synchronized (map) {
            Object object;
            Object object2;
            int n;
            for (n = 0; n < rubyArray2.size(); ++n) {
                object2 = (RubyThread)rubyArray2.entry(n);
                object = this.contextForThread((RubyThread)object2);
                rubyArray.add(object);
            }
            for (n = 0; n < rubyArray.size(); ++n) {
                object2 = (Context)rubyArray.entry(n);
                object = (DebugContext)object2.dataGetStruct();
                this.threadsTable.put(((DebugContext)object).getThread(), (Context)((Object)object2));
            }
        }
        return rubyArray;
    }

    void suspend(IRubyObject iRubyObject) {
        this.checkStarted(iRubyObject);
        for (Context context : this.getNonCurrentContexts(iRubyObject)) {
            context.suspend0();
        }
    }

    void resume(IRubyObject iRubyObject) {
        this.checkStarted(iRubyObject);
        for (Context context : this.getNonCurrentContexts(iRubyObject)) {
            context.resume0();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterable<Context> getNonCurrentContexts(IRubyObject iRubyObject) {
        Context context;
        RubyArray rubyArray;
        Map<RubyThread, Context> map = this.threadsTable;
        synchronized (map) {
            rubyArray = (RubyArray)this.getDebugContexts(iRubyObject);
            RubyThread rubyThread = iRubyObject.getRuntime().getCurrentContext().getThread();
            context = this.contextForThread(rubyThread);
        }
        int n = rubyArray.getLength();
        for (int i = 0; i < n; ++i) {
            IRubyObject iRubyObject2 = rubyArray.entry(i);
            if (iRubyObject2 != context) continue;
            rubyArray.remove(i);
        }
        return rubyArray;
    }

    boolean isStarted() {
        return this.started;
    }

    void setTracing(boolean bl) {
        this.tracing = bl;
    }

    boolean isTracing() {
        return this.tracing;
    }

    void setKeepFrameBinding(boolean bl) {
        this.keepFrameBinding = bl;
    }

    boolean isKeepFrameBinding() {
        return this.keepFrameBinding;
    }

    boolean isTrackFrameArgs() {
        return this.trackFrameArgs;
    }

    IRubyObject getBreakpoints() {
        return this.breakpoints;
    }

    IRubyObject addBreakpoint(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        this.checkStarted(iRubyObject);
        IRubyObject iRubyObject2 = this.createBreakpointFromArgs(iRubyObject, iRubyObjectArray, ++this.lastBreakpointID);
        ((RubyArray)this.breakpoints).add((Object)iRubyObject2);
        return iRubyObject2;
    }

    IRubyObject removeBreakpoint(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        this.checkStarted(iRubyObject);
        int n = RubyFixnum.fix2int((IRubyObject)iRubyObject2);
        RubyArray rubyArray = (RubyArray)this.breakpoints;
        for (int i = 0; i < rubyArray.size(); ++i) {
            IRubyObject iRubyObject3 = rubyArray.entry(i);
            DebugBreakpoint debugBreakpoint = (DebugBreakpoint)iRubyObject3.dataGetStruct();
            if (debugBreakpoint.getId() != n) continue;
            rubyArray.remove(i);
            return iRubyObject3;
        }
        return Util.nil(iRubyObject);
    }

    IRubyObject createBreakpointFromArgs(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        return this.createBreakpointFromArgs(iRubyObject, iRubyObjectArray, ++this.lastBreakpointID);
    }

    IRubyObject createBreakpointFromArgs(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, int n) {
        DebugBreakpoint.Type type;
        Ruby ruby = iRubyObject.getRuntime();
        IRubyObject iRubyObject2 = Arity.checkArgumentCount((Ruby)ruby, (IRubyObject[])iRubyObjectArray, (int)2, (int)3) == 3 ? iRubyObjectArray[2] : ruby.getNil();
        IRubyObject iRubyObject3 = iRubyObjectArray[0];
        IRubyObject iRubyObject4 = iRubyObjectArray[1];
        DebugBreakpoint.Type type2 = type = iRubyObject4 instanceof RubyFixnum ? DebugBreakpoint.Type.POS : DebugBreakpoint.Type.METHOD;
        if (type == DebugBreakpoint.Type.POS) {
            iRubyObject3 = iRubyObject3.asString();
        } else {
            iRubyObject4 = iRubyObject4.asString();
        }
        DebugBreakpoint debugBreakpoint = new DebugBreakpoint();
        debugBreakpoint.setId(n);
        debugBreakpoint.setSource(iRubyObject3);
        debugBreakpoint.setType(type);
        if (type == DebugBreakpoint.Type.POS) {
            debugBreakpoint.getPos().setLine(RubyFixnum.num2int((IRubyObject)iRubyObject4));
        } else {
            debugBreakpoint.getPos().setMethodName(((RubyString)iRubyObject4).toString());
        }
        debugBreakpoint.setExpr((IRubyObject)(iRubyObject2.isNil() ? iRubyObject2 : (RubyString)iRubyObject2));
        debugBreakpoint.setHitCount(0);
        debugBreakpoint.setHitValue(0);
        debugBreakpoint.setHitCondition(DebugBreakpoint.HitCondition.NONE);
        RubyClass rubyClass = ruby.getModule("Debugger").getClass("Breakpoint");
        IRubyObject iRubyObject5 = rubyClass.allocate();
        iRubyObject5.dataWrapStruct((Object)debugBreakpoint);
        return iRubyObject5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IRubyObject lastInterrupted(IRubyObject iRubyObject) {
        this.checkStarted(iRubyObject);
        IRubyObject iRubyObject2 = Util.nil(iRubyObject);
        Map<RubyThread, Context> map = this.threadsTable;
        synchronized (map) {
            for (Map.Entry<RubyThread, Context> entry : this.threadsTable.entrySet()) {
                IRubyObject iRubyObject3 = (IRubyObject)entry.getValue();
                DebugContext debugContext = (DebugContext)iRubyObject3.dataGetStruct();
                if (debugContext.getThnum() != this.debugEventHook.getLastDebuggedThnum()) continue;
                iRubyObject2 = iRubyObject3;
                break;
            }
        }
        return iRubyObject2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkThreadContexts(Ruby ruby) {
        Map<RubyThread, Context> map = this.threadsTable;
        synchronized (map) {
            Iterator<Map.Entry<RubyThread, Context>> iterator = this.threadsTable.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<RubyThread, Context> entry = iterator.next();
                if (!entry.getKey().alive_p().isFalse()) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removePauseFlag(IRubyObject iRubyObject) {
        RubyArray rubyArray;
        Map<RubyThread, Context> map = this.threadsTable;
        synchronized (map) {
            rubyArray = (RubyArray)this.getDebugContexts(iRubyObject);
        }
        int n = rubyArray.getLength();
        for (int i = 0; i < n; ++i) {
            Context context = (Context)rubyArray.entry(i);
            context.debugContext().setThreadPaused(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IRubyObject skip(IRubyObject iRubyObject, Block block) {
        if (!block.isGiven()) {
            throw iRubyObject.getRuntime().newArgumentError("called without a block");
        }
        DebugContext debugContext = this.getCurrentDebugContext(iRubyObject);
        try {
            debugContext.setSkipped(true);
            IRubyObject iRubyObject2 = block.yield(iRubyObject.getRuntime().getCurrentContext(), iRubyObject.getRuntime().getNil());
            return iRubyObject2;
        }
        finally {
            debugContext.setSkipped(false);
        }
    }

    boolean isPostMortem() {
        return this.postMortem;
    }

    void setPostMortem(boolean bl) {
        this.postMortem = bl;
    }

    boolean isDebug() {
        return this.debug;
    }

    void setDebug(boolean bl) {
        this.debug = bl;
    }

    void setTrackFrameArgs(boolean bl) {
        this.trackFrameArgs = bl;
    }

    RubyHash getCatchpoints() {
        return (RubyHash)this.catchpoints;
    }

    void addCatchpoint(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Ruby ruby = iRubyObject.getRuntime();
        this.checkStarted(iRubyObject);
        if (iRubyObject2.isNil()) {
            this.catchpoints = ruby.getNil();
        } else {
            if (!ruby.getString().isInstance(iRubyObject2)) {
                throw ruby.newTypeError("value of checkpoint must be String");
            }
            this.getCatchpoints().op_aset(ruby.getCurrentContext(), iRubyObject2.dup(), (IRubyObject)RubyFixnum.zero((Ruby)ruby));
        }
    }

    FileFilter getFileFilter() {
        return this.fileFilter;
    }

    static final class DebugContextPair {
        Context context;
        DebugContext debugContext;

        DebugContextPair() {
        }
    }
}

