/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.debug;

import java.util.HashSet;
import java.util.Set;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileFilter
extends RubyObject {
    private final Set<String> includedPaths = new HashSet<String>();
    private final Set<String> excludedPaths = new HashSet<String>();
    private boolean isEnabled = false;

    FileFilter(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    @JRubyMethod(name={"include"}, required=1)
    public synchronized IRubyObject include(IRubyObject iRubyObject, Block block) {
        if (iRubyObject == null || iRubyObject.isNil()) {
            return iRubyObject;
        }
        String string = iRubyObject.convertToString().toString();
        if (!this.excludedPaths.remove(string)) {
            this.includedPaths.add(string);
        }
        return iRubyObject;
    }

    @JRubyMethod(name={"exclude"}, required=1)
    public synchronized IRubyObject exclude(IRubyObject iRubyObject, Block block) {
        if (iRubyObject == null || iRubyObject.isNil()) {
            return iRubyObject;
        }
        String string = iRubyObject.convertToString().toString();
        if (!this.includedPaths.remove(string)) {
            this.excludedPaths.add(string);
        }
        return iRubyObject;
    }

    @JRubyMethod(name={"enable"}, required=0)
    public synchronized IRubyObject enable(Block block) {
        this.isEnabled = true;
        return this.getRuntime().newBoolean(this.isEnabled);
    }

    @JRubyMethod(name={"disable"}, required=0)
    public synchronized IRubyObject disable(Block block) {
        this.isEnabled = false;
        return this.getRuntime().newBoolean(this.isEnabled);
    }

    public synchronized boolean isAccepted(String string) {
        if (!this.isEnabled) {
            return true;
        }
        if (string == null) {
            return false;
        }
        return FileFilter.isUnder(this.includedPaths, string) && !FileFilter.isUnder(this.excludedPaths, string);
    }

    private static boolean isUnder(Set<String> set, String string) {
        for (String string2 : set) {
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }
}

