/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.debug;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.anno.JRubyMethod;
import org.jruby.debug.Breakpoint;
import org.jruby.debug.Context;
import org.jruby.debug.Debugger;
import org.jruby.debug.FileFilter;
import org.jruby.debug.RubyDebugBaseLibrary;
import org.jruby.debug.Util;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public final class RubyDebugger {
    static final String DEBUG_THREAD_NAME = "DebugThread";
    static final String CONTEXT_NAME = "Context";
    static final String FILE_FILTER_NAME = "FileFilter";
    private static Debugger debugger;
    private static final ObjectAllocator BREAKPOINT_ALLOCATOR;
    private static final ObjectAllocator CONTEXT_ALLOCATOR;
    private static final ObjectAllocator FILE_FILTER_ALLOCATOR;

    private RubyDebugger() {
    }

    public static RubyModule createDebuggerModule(Ruby ruby) {
        RubyModule rubyModule = ruby.defineModule("Debugger");
        rubyModule.defineAnnotatedMethods(RubyDebugger.class);
        rubyModule.defineClassUnder("ThreadsTable", ruby.getObject(), ruby.getObject().getAllocator());
        RubyClass rubyClass = rubyModule.defineClassUnder(DEBUG_THREAD_NAME, ruby.getClass("Thread"), ruby.getClass("Thread").getAllocator());
        rubyClass.defineAnnotatedMethods(RubyDebugBaseLibrary.DebugThread.class);
        RubyClass rubyClass2 = rubyModule.defineClassUnder("Breakpoint", ruby.getObject(), BREAKPOINT_ALLOCATOR);
        rubyClass2.defineAnnotatedMethods(Breakpoint.class);
        RubyClass rubyClass3 = rubyModule.defineClassUnder(CONTEXT_NAME, ruby.getObject(), CONTEXT_ALLOCATOR);
        rubyClass3.defineAnnotatedMethods(Context.class);
        RubyClass rubyClass4 = rubyModule.defineClassUnder(FILE_FILTER_NAME, ruby.getObject(), FILE_FILTER_ALLOCATOR);
        rubyClass4.defineAnnotatedMethods(FileFilter.class);
        return rubyModule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Debugger debugger() {
        Class<RubyDebugger> clazz = RubyDebugger.class;
        synchronized (RubyDebugger.class) {
            if (debugger == null) {
                debugger = new Debugger();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return debugger;
        }
    }

    @JRubyMethod(name={"start_"}, module=true)
    public static IRubyObject start(IRubyObject iRubyObject, Block block) {
        return RubyDebugger.debugger().start(iRubyObject, block);
    }

    @JRubyMethod(name={"stop"}, module=true)
    public static IRubyObject stop(IRubyObject iRubyObject, Block block) {
        boolean bl = RubyDebugger.debugger().stop(iRubyObject.getRuntime());
        return Util.toRBoolean(iRubyObject, bl);
    }

    @JRubyMethod(name={"started?"}, module=true)
    public static IRubyObject started_p(IRubyObject iRubyObject, Block block) {
        return Util.toRBoolean(iRubyObject, RubyDebugger.debugger().isStarted());
    }

    @JRubyMethod(name={"breakpoints"}, module=true)
    public static IRubyObject breakpoints(IRubyObject iRubyObject, Block block) {
        RubyDebugger.debugger().checkStarted(iRubyObject);
        return RubyDebugger.debugger().getBreakpoints();
    }

    @JRubyMethod(name={"add_breakpoint"}, module=true, required=2, optional=1)
    public static IRubyObject add_breakpoint(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        return RubyDebugger.debugger().addBreakpoint(iRubyObject, iRubyObjectArray);
    }

    @JRubyMethod(name={"remove_breakpoint"}, module=true, required=1)
    public static IRubyObject remove_breakpoint(IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        return RubyDebugger.debugger().removeBreakpoint(iRubyObject, iRubyObject2);
    }

    @JRubyMethod(name={"catchpoints"}, module=true)
    public static IRubyObject catchpoint(IRubyObject iRubyObject, Block block) {
        RubyDebugger.debugger().checkStarted(iRubyObject);
        return RubyDebugger.debugger().getCatchpoints();
    }

    @JRubyMethod(name={"add_catchpoint"}, module=true, required=1)
    public static IRubyObject addCatchpoint(IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        RubyDebugger.debugger().addCatchpoint(iRubyObject, iRubyObject2);
        return iRubyObject2;
    }

    @JRubyMethod(name={"last_context"}, module=true)
    public static IRubyObject last_context(IRubyObject iRubyObject, Block block) {
        return RubyDebugger.debugger().lastInterrupted(iRubyObject);
    }

    @JRubyMethod(name={"contexts"}, module=true)
    public static IRubyObject contexts(IRubyObject iRubyObject, Block block) {
        return RubyDebugger.debugger().getDebugContexts(iRubyObject);
    }

    @JRubyMethod(name={"current_context"}, module=true)
    public static IRubyObject current_context(IRubyObject iRubyObject, Block block) {
        return RubyDebugger.debugger().getCurrentContext(iRubyObject);
    }

    @JRubyMethod(name={"thread_context"}, module=true, required=1)
    public static IRubyObject thread_context(IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        return RubyDebugger.debugger().getCurrentContext(iRubyObject);
    }

    @JRubyMethod(name={"suspend"}, module=true)
    public static IRubyObject suspend(IRubyObject iRubyObject, Block block) {
        RubyDebugger.debugger().suspend(iRubyObject);
        return iRubyObject;
    }

    @JRubyMethod(name={"resume"}, module=true)
    public static IRubyObject resume(IRubyObject iRubyObject, Block block) {
        RubyDebugger.debugger().resume(iRubyObject);
        return iRubyObject;
    }

    @JRubyMethod(name={"tracing"}, module=true)
    public static IRubyObject tracing(IRubyObject iRubyObject, Block block) {
        return iRubyObject.getRuntime().newBoolean(RubyDebugger.debugger().isTracing());
    }

    @JRubyMethod(name={"tracing="}, module=true, required=1)
    public static IRubyObject tracing_set(IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        RubyDebugger.debugger().setTracing(iRubyObject2.isTrue());
        return iRubyObject2;
    }

    @JRubyMethod(name={"debug_load"}, module=true, required=1, optional=2)
    public static IRubyObject debug_load(IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        return RubyDebugger.debugger().load(iRubyObject, iRubyObjectArray);
    }

    @JRubyMethod(name={"skip"}, module=true)
    public static IRubyObject skip(IRubyObject iRubyObject, Block block) {
        return RubyDebugger.debugger().skip(iRubyObject, block);
    }

    @JRubyMethod(name={"debug_at_exit"}, module=true)
    public static IRubyObject debug_at_exit(IRubyObject iRubyObject, Block block) {
        RubyProc rubyProc = RubyKernel.proc((ThreadContext)iRubyObject.getRuntime().getCurrentContext(), (IRubyObject)iRubyObject, (Block)block);
        iRubyObject.getRuntime().pushExitBlock(rubyProc);
        return rubyProc;
    }

    @JRubyMethod(name={"post_mortem?"}, module=true)
    public static IRubyObject post_mortem_p(IRubyObject iRubyObject, Block block) {
        return Util.toRBoolean(iRubyObject, RubyDebugger.debugger().isPostMortem());
    }

    @JRubyMethod(name={"post_mortem="}, module=true, required=1)
    public static IRubyObject post_mortem_set(IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        throw iRubyObject.getRuntime().newRuntimeError("Post mortem debugging is not (yet) supported");
    }

    @JRubyMethod(name={"keep_frame_binding?"}, module=true)
    public static IRubyObject keep_frame_binding_p(IRubyObject iRubyObject, Block block) {
        return iRubyObject.getRuntime().newBoolean(RubyDebugger.debugger().isKeepFrameBinding());
    }

    @JRubyMethod(name={"keep_frame_binding="}, module=true, required=1)
    public static IRubyObject keep_frame_binding_set(IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        RubyDebugger.debugger().setKeepFrameBinding(iRubyObject2.isTrue());
        return iRubyObject2;
    }

    @JRubyMethod(name={"track_frame_args?"}, module=true)
    public static IRubyObject track_frame_args_p(IRubyObject iRubyObject, Block block) {
        return iRubyObject.getRuntime().newBoolean(RubyDebugger.debugger().isTrackFrameArgs());
    }

    @JRubyMethod(name={"track_frame_args="}, module=true, required=1)
    public static IRubyObject track_frame_args_set(IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        RubyDebugger.debugger().setTrackFrameArgs(iRubyObject2.isTrue());
        return iRubyObject2;
    }

    @JRubyMethod(name={"debug"}, module=true)
    public static IRubyObject debug(IRubyObject iRubyObject, Block block) {
        return Util.toRBoolean(iRubyObject, RubyDebugger.debugger().isDebug());
    }

    @JRubyMethod(name={"debug="}, module=true, required=1)
    public static IRubyObject debug_set(IRubyObject iRubyObject, IRubyObject iRubyObject2, Block block) {
        RubyDebugger.debugger().setDebug(iRubyObject2.isTrue());
        return iRubyObject2;
    }

    @JRubyMethod(name={"file_filter"}, module=true)
    public static IRubyObject file_filter(IRubyObject iRubyObject, Block block) {
        return RubyDebugger.debugger().getFileFilter();
    }

    static {
        BREAKPOINT_ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
                return new Breakpoint(ruby, rubyClass);
            }
        };
        CONTEXT_ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
                return new Context(ruby, rubyClass, RubyDebugger.debugger());
            }
        };
        FILE_FILTER_ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
                return new FileFilter(ruby, rubyClass);
            }
        };
    }
}

