/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.debug;

import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.builtin.IRubyObject;

final class Util {
    private static final Logger LOGGER = Logger.getLogger(Util.class.getName());
    private static final CharSequence JRUBY_BUILTIN_PATH_PART = "builtin" + File.separator + "javasupport";
    private static final CharSequence JRUBY_JAR_PART = "lib" + File.separator + "jruby.jar!" + File.separator;

    private Util() {
    }

    static RubyBoolean toRBoolean(IRubyObject iRubyObject, boolean bl) {
        return RubyBoolean.newBoolean((Ruby)iRubyObject.getRuntime(), (boolean)bl);
    }

    static IRubyObject nil(IRubyObject iRubyObject) {
        return iRubyObject.getRuntime().getNil();
    }

    static String relativizeToPWD(String string, Ruby ruby) {
        return Util.relativizeFile(ruby.getCurrentDirectory(), string);
    }

    static String relativizeFile(String string, String string2) {
        String string3 = string2;
        if (string2.startsWith(string)) {
            string3 = string2.substring(string.length() + 1);
        }
        return string3;
    }

    static boolean areSameFiles(String string, String string2) {
        try {
            String string3 = new File(string).getCanonicalPath();
            String string4 = new File(string2).getCanonicalPath();
            return string3.equals(string4);
        }
        catch (IOException iOException) {
            LOGGER.fine("Cannot resolve cannocical path (falling back to String comparison):\n  first: " + string + "\n  second: " + string2 + "\n  ioe:" + iOException);
            return string.equals(string2);
        }
    }

    static void logEvent(RubyEvent rubyEvent, String string, int n, String string2, IRubyObject iRubyObject) {
        LOGGER.info(string + ":" + n + "[" + rubyEvent + "]" + iRubyObject + "#" + string2 + "\n");
    }

    static boolean isJRubyCore(String string) {
        return string == null || string.contains(JRUBY_BUILTIN_PATH_PART) || string.contains(JRUBY_JAR_PART);
    }

    static boolean isLineEvent(String string) {
        return RubyEvent.LINE.getName().equals(string);
    }

    static RubyEvent typeForEvent(String string) {
        if ("line".equals(string)) {
            return RubyEvent.LINE;
        }
        if ("class".equals(string)) {
            return RubyEvent.CLASS;
        }
        if ("end".equals(string)) {
            return RubyEvent.END;
        }
        if ("call".equals(string)) {
            return RubyEvent.CALL;
        }
        if ("return".equals(string)) {
            return RubyEvent.RETURN;
        }
        if ("c-call".equals(string)) {
            return RubyEvent.C_CALL;
        }
        if ("c-return".equals(string)) {
            return RubyEvent.C_RETURN;
        }
        if ("b-call".equals(string)) {
            return RubyEvent.B_CALL;
        }
        if ("b-return".equals(string)) {
            return RubyEvent.B_RETURN;
        }
        if ("thread-begin".equals(string)) {
            return RubyEvent.THREAD_BEGIN;
        }
        if ("thread-end".equals(string)) {
            return RubyEvent.THREAD_END;
        }
        if ("raise".equals(string)) {
            return RubyEvent.RAISE;
        }
        throw new IllegalArgumentException("unknown event type: " + string);
    }
}

