/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.go.plugin.activation;

import com.thoughtworks.go.plugin.activation.GoPluginActivator;
import com.thoughtworks.go.plugin.api.GoPluginApiMarker;
import com.thoughtworks.go.plugin.api.annotation.Extension;
import com.thoughtworks.go.plugin.api.annotation.Load;
import com.thoughtworks.go.plugin.api.annotation.UnLoad;
import com.thoughtworks.go.plugin.api.info.PluginContext;
import com.thoughtworks.go.plugin.api.logging.Logger;
import com.thoughtworks.go.plugin.internal.api.LoggingService;
import com.thoughtworks.go.plugin.internal.api.PluginHealthService;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class DefaultGoPluginActivator
implements GoPluginActivator {
    private List<String> errors = new ArrayList<String>();
    private List<UnloadMethodInvoker> unloadMethodInvokers = new ArrayList<UnloadMethodInvoker>();
    private PluginHealthService pluginHealthService;
    private static String pluginId;
    private static PluginContext DUMMY_PLUGIN_CONTEXT;
    private Logger logger = null;

    public void start(BundleContext bundleContext) throws Exception {
        Bundle bundle = bundleContext.getBundle();
        pluginId = bundle.getSymbolicName();
        this.pluginHealthService = (PluginHealthService)bundleContext.getService(bundleContext.getServiceReference(PluginHealthService.class));
        LoggingService loggingService = (LoggingService)bundleContext.getService(bundleContext.getServiceReference(LoggingService.class));
        Logger.initialize((LoggingService)loggingService);
        this.logger = Logger.getLoggerFor(DefaultGoPluginActivator.class);
        this.getImplementersAndRegister(bundleContext, bundle);
        this.reportErrorsToHealthService();
    }

    private void reportErrorsToHealthService() {
        if (!this.errors.isEmpty()) {
            this.pluginHealthService.reportErrorAndInvalidate(pluginId, this.errors);
        }
    }

    private void reportWarningToHealthService(String string) {
        this.pluginHealthService.warning(pluginId, string);
    }

    boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        for (UnloadMethodInvoker unloadMethodInvoker : this.unloadMethodInvokers) {
            try {
                unloadMethodInvoker.invokeUnloadMethod();
            }
            catch (InvocationTargetException invocationTargetException) {
                this.errors.add(String.format("Invocation of unload method [%s]. Reason: %s.", unloadMethodInvoker.unloadMethod, invocationTargetException.getTargetException().toString()));
            }
            catch (Throwable throwable) {
                this.errors.add(String.format("Invocation of unload method [%s]. Reason: [%s].", unloadMethodInvoker.unloadMethod, throwable.toString()));
            }
            this.reportErrorsToHealthService();
        }
    }

    void getImplementersAndRegister(BundleContext bundleContext, Bundle bundle) throws ClassNotFoundException {
        ArrayList<HashMap<Class, List<Object>>> arrayList = new ArrayList<HashMap<Class, List<Object>>>();
        for (Class clazz : this.getCandidateGoExtensionClasses(bundle)) {
            HashMap<Class, List<Object>> hashMap = this.getAllInterfaceToImplementationsMap(clazz);
            if (hashMap.isEmpty()) continue;
            arrayList.add(hashMap);
        }
        this.informIfNoExtensionFound(arrayList);
        this.registerAllServicesImplementedBy(bundleContext, arrayList);
    }

    private void informIfNoExtensionFound(List<HashMap<Class, List<Object>>> list) {
        if (list.isEmpty()) {
            String string = "No extensions found in this plugin.Please check for @Extension annotations";
            this.reportWarningToHealthService(string);
            if (this.logger != null) {
                this.logger.warn(string);
            }
        }
    }

    private void registerAllServicesImplementedBy(BundleContext bundleContext, List<HashMap<Class, List<Object>>> list) {
        for (HashMap<Class, List<Object>> hashMap : list) {
            for (Map.Entry<Class, List<Object>> entry : hashMap.entrySet()) {
                Class clazz = entry.getKey();
                for (Object object : entry.getValue()) {
                    Hashtable<String, String> hashtable = new Hashtable<String, String>();
                    hashtable.put("Bundle-SymbolicName", pluginId);
                    bundleContext.registerService(clazz, object, hashtable);
                }
            }
        }
    }

    private HashMap<Class, List<Object>> getAllInterfaceToImplementationsMap(Class clazz) {
        HashMap<Class, List<Object>> hashMap = new HashMap<Class, List<Object>>();
        Set<Class> set = this.findAllInterfacesInHierarchy(clazz);
        Object object = this.createImplementationOf(clazz);
        if (object == null) {
            return hashMap;
        }
        for (Class clazz2 : set) {
            if (!this.isGoExtensionPointInterface(clazz2)) continue;
            List<Object> list = hashMap.get(clazz2);
            if (list == null) {
                list = new ArrayList<Object>();
                hashMap.put(clazz2, list);
            }
            list.add(object);
        }
        return hashMap;
    }

    private Object createImplementationOf(Class clazz) {
        Object object = null;
        try {
            object = this.createInstance(clazz);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.errors.add(String.format("Class [%s] is annotated with @Extension but cannot be constructed. Reason: %s.", clazz.getSimpleName(), invocationTargetException.getTargetException().toString()));
        }
        catch (Throwable throwable) {
            this.errors.add(String.format("Class [%s] is annotated with @Extension but cannot be constructed. Reason: [%s].", clazz.getSimpleName(), throwable.getCause()));
        }
        if (object != null) {
            this.validateAndLoad(clazz, object);
        }
        return object;
    }

    private void validateAndLoad(Class clazz, Object object) {
        try {
            this.processLoadAndUnloadAnnotatedMethods(object);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.errors.add(String.format("Class [%s] is annotated with @Extension but cannot be registered. Reason: %s.", clazz.getSimpleName(), invocationTargetException.getTargetException().toString()));
        }
        catch (IllegalAccessException illegalAccessException) {
            this.errors.add(String.format("Class [%s] is annotated with @Extension will not be registered. Reason: %s.", clazz.getSimpleName(), illegalAccessException.toString()));
        }
        catch (RuntimeException runtimeException) {
            this.errors.add(String.format("Class [%s] is annotated with @Extension will not be registered. Reason: %s.", clazz.getSimpleName(), runtimeException.toString()));
        }
        catch (Throwable throwable) {
            this.errors.add(String.format("Class [%s] is annotated with @Extension but cannot be constructed or registered. Reason: [%s].", clazz.getSimpleName(), throwable.getCause()));
        }
    }

    private void processLoadAndUnloadAnnotatedMethods(Object object) throws InvocationTargetException, IllegalAccessException {
        Method method = this.getAnnotatedMethod(object, Load.class);
        Method method2 = this.getAnnotatedMethod(object, UnLoad.class);
        if (method != null) {
            method.invoke(object, DUMMY_PLUGIN_CONTEXT);
        }
        if (method2 != null) {
            this.unloadMethodInvokers.add(new UnloadMethodInvoker(object, method2));
        }
    }

    private Method getAnnotatedMethod(Object object, Class<? extends Annotation> clazz) {
        Object[] objectArray = this.getMethodsWithAnnotation(object, clazz);
        if (objectArray.length == 0) {
            return null;
        }
        if (objectArray.length > 1) {
            throw new RuntimeException("More than one method with @" + clazz.getSimpleName() + " annotation not allowed. Methods Found: " + Arrays.toString(objectArray));
        }
        return objectArray[0];
    }

    private Method[] getMethodsWithAnnotation(Object object, Class<? extends Annotation> clazz) {
        Class<?> clazz2 = object.getClass();
        ArrayList<Method> arrayList = new ArrayList<Method>();
        for (Method method : clazz2.getDeclaredMethods()) {
            boolean bl = this.hasAnnotation(clazz, method);
            if (bl && this.isPublic(method) && this.isNonStatic(method) && this.hasOneArgOfPluginContextType(method)) {
                arrayList.add(method);
                continue;
            }
            if (!bl) continue;
            this.reportWarningsForAnnotatedMethod(method, clazz);
        }
        return arrayList.toArray(new Method[arrayList.size()]);
    }

    private void reportWarningsForAnnotatedMethod(Method method, Class<? extends Annotation> clazz) {
        if (!this.isPublic(method)) {
            this.reportWarningToHealthService(String.format("Ignoring method [%s] tagged with @%s since its not 'public'", method, clazz.getSimpleName()));
            return;
        }
        if (!this.isNonStatic(method)) {
            this.reportWarningToHealthService(String.format("Ignoring method [%s] tagged with @%s since its 'static' method", method, clazz.getSimpleName()));
            return;
        }
        if (!this.hasOneArgOfPluginContextType(method)) {
            this.reportWarningToHealthService(String.format("Ignoring method [%s] tagged with @%s since it does not have one argument of type PluginContext. Argument Type: []", method, clazz.getSimpleName(), Arrays.toString(method.getParameterTypes())));
            return;
        }
    }

    private boolean hasOneArgOfPluginContextType(Method method) {
        return method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == PluginContext.class;
    }

    private boolean isNonStatic(Method method) {
        return !Modifier.isStatic(method.getModifiers());
    }

    private boolean isPublic(Method method) {
        return Modifier.isPublic(method.getModifiers());
    }

    private boolean hasAnnotation(Class<? extends Annotation> clazz, Method method) {
        return method.getAnnotation(clazz) != null;
    }

    private List<Class> getCandidateGoExtensionClasses(Bundle bundle) throws ClassNotFoundException {
        ArrayList<Class> arrayList = new ArrayList<Class>();
        Enumeration enumeration = bundle.findEntries("/", "*.class", true);
        while (enumeration.hasMoreElements()) {
            Class<?> clazz;
            String string = ((URL)enumeration.nextElement()).getFile();
            if (this.isInvalidPath(string) || (clazz = this.loadClass(bundle, string)) == null || !this.isValidClass(clazz)) continue;
            arrayList.add(clazz);
        }
        return arrayList;
    }

    Class<?> loadClass(Bundle bundle, String string) throws ClassNotFoundException {
        String string2 = string.replaceFirst("^/", "").replace('/', '.').replaceFirst(".class$", "");
        try {
            return bundle.loadClass(string2);
        }
        catch (Throwable throwable) {
            this.errors.add(String.format("Class [%s] could not be loaded. Message: [%s].", string2, throwable.getMessage()));
            return null;
        }
    }

    private boolean isInvalidPath(String string) {
        return string.startsWith("/lib/") || string.startsWith("/META-INF/");
    }

    private boolean isValidClass(Class<?> clazz) {
        try {
            boolean bl;
            boolean bl2;
            boolean bl3 = bl2 = clazz.getAnnotation(Extension.class) == null;
            if (bl2) {
                return false;
            }
            boolean bl4 = Modifier.isAbstract(clazz.getModifiers());
            if (bl4) {
                this.errors.add(String.format("Class [%s] is annotated with @Extension but is abstract.", clazz.getSimpleName()));
                return false;
            }
            boolean bl5 = bl = !Modifier.isPublic(clazz.getModifiers());
            if (bl) {
                this.errors.add(String.format("Class [%s] is annotated with @Extension but is not public.", clazz.getSimpleName()));
                return false;
            }
            return this.isInstantiable(clazz);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.errors.add(String.format("Class [%s] is annotated with @Extension but cannot be constructed. Make sure it and all of its parent classes have a default constructor.", clazz.getSimpleName()));
            return false;
        }
    }

    private boolean isInstantiable(Class<?> clazz) throws NoSuchMethodException {
        if (!this.isANonStaticInnerClass(clazz)) {
            boolean bl = clazz.getConstructor(new Class[0]) != null;
            return bl;
        }
        boolean bl = clazz.getConstructor(clazz.getDeclaringClass()) != null;
        return bl && this.isInstantiable(clazz.getDeclaringClass());
    }

    private boolean isANonStaticInnerClass(Class<?> clazz) {
        return clazz.isMemberClass() && !Modifier.isStatic(clazz.getModifiers());
    }

    private Set<Class> findAllInterfacesInHierarchy(Class clazz) {
        Stack stack = new Stack();
        stack.add(clazz);
        HashSet<Class> hashSet = new HashSet<Class>();
        while (!stack.empty()) {
            Class clazz2 = (Class)stack.pop();
            if (clazz2.isInterface()) {
                hashSet.add(clazz2);
            }
            stack.addAll(Arrays.asList(clazz2.getInterfaces()));
            if (clazz2.getSuperclass() == null) continue;
            stack.add(clazz2.getSuperclass());
        }
        return hashSet;
    }

    private Object createInstance(Class clazz) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        if (this.isANonStaticInnerClass(clazz)) {
            Class<?> clazz2 = clazz.getDeclaringClass();
            Object object = this.createInstance(clazz.getDeclaringClass());
            return clazz.getConstructor(clazz2).newInstance(object);
        }
        Constructor constructor = clazz.getConstructor(new Class[0]);
        return constructor.newInstance(new Object[0]);
    }

    private boolean isGoExtensionPointInterface(Class clazz) {
        boolean bl = clazz.getAnnotation(GoPluginApiMarker.class) != null;
        boolean bl2 = GoPluginApiMarker.class.getClassLoader() == clazz.getClassLoader();
        return bl2 && bl;
    }

    static {
        DUMMY_PLUGIN_CONTEXT = new PluginContext(){};
    }

    private static class UnloadMethodInvoker {
        private final Object object;
        private final Method unloadMethod;

        UnloadMethodInvoker(Object object, Method method) {
            this.object = object;
            this.unloadMethod = method;
        }

        void invokeUnloadMethod() throws InvocationTargetException, IllegalAccessException {
            this.unloadMethod.invoke(this.object, DUMMY_PLUGIN_CONTEXT);
        }
    }
}

