/*
 * Decompiled with CFR 0.152.
 */
package com.tw.go.testplugin;

import com.thoughtworks.go.plugin.api.annotation.Extension;
import com.thoughtworks.go.plugin.api.annotation.Load;
import com.thoughtworks.go.plugin.api.annotation.UnLoad;
import com.thoughtworks.go.plugin.api.info.PluginContext;
import com.thoughtworks.go.plugin.api.info.PluginDescriptor;
import com.thoughtworks.go.plugin.api.info.PluginDescriptorAware;
import com.thoughtworks.go.plugin.api.logging.Logger;
import com.tw.go.dependency.Console;

@Extension
public class DescriptorValidatorPlugin
implements PluginDescriptorAware {
    public int loadCalled = 0;
    public int unloadCalled = 0;
    Console console = new Console();
    Logger logger = Logger.getLoggerFor(DescriptorValidatorPlugin.class);

    @Load
    public void onLoad(PluginContext pluginContext) {
        this.logger.info("Boo");
        System.out.println("Plugin loaded");
        ++this.loadCalled;
    }

    public void setPluginDescriptor(PluginDescriptor pluginDescriptor) {
        if (this.loadCalled == 0) {
            throw new RuntimeException("Load callback has not been called for this plugin");
        }
        System.out.println("Got the descriptor: " + pluginDescriptor);
        System.setProperty("testplugin.descriptorValidator.setPluginDescriptor.invoked", pluginDescriptor.toString());
    }

    @UnLoad
    public void onUnload(PluginContext pluginContext) {
        ++this.unloadCalled;
        System.out.println("Plugin unloaded");
    }

    static {
        Logger.getLoggerFor(DescriptorValidatorPlugin.class).info("Boo");
    }
}

