/*************************GO-LICENSE-START*********************************
 * Copyright 2014 ThoughtWorks, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *************************GO-LICENSE-END***********************************/

package com.thoughtworks.go.server.messaging;

import com.thoughtworks.go.server.service.AgentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JobResultListener implements GoMessageListener<JobResultMessage> {
    private final JobResultTopic jobResultTopic;
    private final AgentService agentService;

    @Autowired
    public JobResultListener(JobResultTopic jobResultTopic, AgentService agentService) {
        this.jobResultTopic = jobResultTopic;
        this.agentService = agentService;
    }

    public void init() {
        jobResultTopic.addListener(this);
    }

    public void onMessage(JobResultMessage message) {
        // TODO - #2511 - this only works for cancelling a job.
        agentService.notifyJobCancelledEvent(message.getAgentUuid());
    }
}
