/*************************GO-LICENSE-START*********************************
 * Copyright 2014 ThoughtWorks, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *************************GO-LICENSE-END***********************************/

package com.thoughtworks.go.server.web;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

/**
 * @understands loading flash object from session
 */
public class FlashLoadingFilter implements Filter {
    public static final String FLASH_SESSION_KEY = "flash_session_key";

    public void init(FilterConfig filterConfig) throws ServletException {

    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        try {
            HttpServletRequest req = (HttpServletRequest) servletRequest;
            FlashMessageService.useFlash(loadFlash(req));
            filterChain.doFilter(req, servletResponse);
        } finally {
            FlashMessageService.useFlash(null);
        }
    }

    private FlashMessageService.Flash loadFlash(HttpServletRequest req) {
        HttpSession session = req.getSession();
        FlashMessageService.Flash flash = (FlashMessageService.Flash) session.getAttribute(FLASH_SESSION_KEY);
        if (flash == null) {
            flash = new FlashMessageService.Flash();
            session.setAttribute(FLASH_SESSION_KEY, flash);
        }
        return flash;
    }

    public void destroy() {

    }
}
