/*************************GO-LICENSE-START*********************************
 * Copyright 2014 ThoughtWorks, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *************************GO-LICENSE-END***********************************/

package com.thoughtworks.go.helper;

import com.thoughtworks.go.domain.materials.Material;
import com.thoughtworks.go.server.materials.MaterialUpdateMessage;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;

import static org.mockito.Matchers.argThat;

public class MaterialUpdateMessageMatcher {
    public static MaterialUpdateMessage matchMaterialUpdateMessage(final Material expectedMaterial) {
        return argThat(new BaseMatcher<MaterialUpdateMessage>() {
            @Override
            public boolean matches(Object o) {
                MaterialUpdateMessage message = (MaterialUpdateMessage) o;
                return expectedMaterial.equals(message.getMaterial());
            }

            @Override
            public void describeTo(Description description) {
                description.appendText("Expected material to be: " + expectedMaterial);
            }
        });
    }

}
