/*************************GO-LICENSE-START*********************************
 * Copyright 2014 ThoughtWorks, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *************************GO-LICENSE-END***********************************/

package com.thoughtworks.go.server.materials;

import java.io.IOException;

import com.thoughtworks.go.domain.materials.Material;
import com.thoughtworks.go.config.materials.perforce.P4Material;
import com.thoughtworks.go.helper.P4TestRepo;
import com.thoughtworks.go.helper.TestRepo;

public class MaterialDatabaseP4UpdaterTest extends TestBaseForDatabaseUpdater {
    protected Material material() {
        return new P4Material(testRepo.projectRepositoryUrl(), "//depot/... //something/...");
    }

    protected TestRepo repo() throws IOException {
        return P4TestRepo.createP4TestRepo();
    }

}