# Jasmine Gem 2.0 Release Notes

These notes cover version 2.0.0

## Summary

This release is focused on support for Jasmine 2.0, gem configuration simplification, and improvement of Rails support (including Rails 4).

The `Jasmine.configure` block now allows for fine-tuned configuration of how a project's suite is run. There are two new/refined concepts: Runners and Formatters.

Formatters are responsible for taking the results from the Jasmine suite and presenting the data in a specific format. Runners take a URL and a Formatter and are responsible for running the Jasmine suite and passing results to the given formatter.

The default Runner uses PhantomJS to run the suite. The default Formatter sends results to the console. There are Ruby gems for a [Selenium/Webdriver Runner][selenium] and a [JUnit XML Formatter][junit]. These projects are great examples for writing a Runner or Formatter for your environment.

## Dropped Support

* _Most_ ENV variables removed - use `Jasmine.configure` to set browser, ports, etc.
* Dropped support for 1.8.x Rubies, Rails 2, RSpec 1, 1.9 rbx - please continue to use Jasmine gem 1.3.2
* "self-test" is gone as [Jasmine core now tests itself](http://travis-ci.org/pivotal/jasmine)

## Changes

* Support for changes in Jasmine 2.0
    * Hooks in `jasmine.yml` and configuration for `boot_dir` and `boot_files`
    * Support for changes to results interface
* Results Formatters:
    * New console results formatter for CI tasks - Jasmine Gem no longer depend on RSpec for console output
    * Optional JUnit XML results formatter for CI tasks
    * Projects can provide custom formatters
* Rails 4 support
* Better support for non-Rails Ruby projects
* Loosely pinning to the `jasmine-core` gem, allowing for Jasmine Core's build to work on release for Jasmine build to work.
    * SHA: 42021e3a86e57f6b7b23dfbe921867d7560f4e4f
* Add warning to `jasmine init`
    * SHA: e071474b014e7d6909d69f86988b84eacb801201
* Globbing should now return files in a consistent, predictable order across systems
* Improved integration tests with Rails
* Added the configuration option to specify your own Webdriver instance
* Brought back the Jasmine Favicon
* Better re-work of Runners and Formatters
* User can copy `boot.js` into their project for customization - usage: `jasmine copy_boot_js`

### Fixes

* Update template jasmine.yml to include boot_dir and boot_files
* `jasmine:ci` rake task doesn't call exit and stop other rake tasks
* Respect source js files outside the asset pipeline
* In Rails 4, turn off turbolink processing of jasmine runner spec links so spec links work
* Allow user to configure path to `jasmine.yml` via an ENV variable.
* More data printed out to console when starting the Jasmine server
* Support for specs to be written in CoffeeScript when used with Rails
* Fix stylesheet asset expansion for Rails 4
* Remove RSpec dependency - Jasmine gem builds its own output
* Remove Selenium dependency - builds run against PhantomJS by default
* Remove accidental sqllite development dependency
* Jasmine example code no longer installed when `jasmine init` is run. Examples are now installed explicitly with `jasmine examples`
* Extraction to separate gems for:
    * JUnit XML formatter
    * Selenium/Webdriver integration
* Use IE=edge for IE compatibility because this will put IE into the highest available mode for each version of IE - see [Question on StackOverflow](http://stackoverflow.com/questions/3449286/force-ie-compatibility-mode-off-in-ie-using-tags) - #[168](http://github.com/pivotal/jasmine-gem/pull/168) from @iwz


## Accepted Pull Requests

* Fix README.markdown and add config example #[144](http://github.com/pivotal/jasmine-gem/pull/144) from @enrapt-mochizuki
* Use a relative path to jasmine repo in Gemfile #[161](http://github.com/pivotal/jasmine-gem/pull/161) from @zephyr-dev
* Problem when using a asset prefix other than '/assets' #[155](http://github.com/pivotal/jasmine-gem/pull/155) from @janv
* Remove unused code - #[154](http://github.com/pivotal/jasmine-gem/pull/154) from @daytonn
* Fix default path for :spec_helper in template #[147](http://github.com/pivotal/jasmine-gem/pull/147) from @kmayer
* Improve Gemfile installation instructions #[141](http://github.com/pivotal/jasmine-gem/pull/141)
* Fix issue when using Rails 4 without the asset pipeline from @lukeasrodgers

------

_Release Notes generated with [Anchorman](http://github.com/infews/anchorman)_

[selenium]: https://github.com/jasmine/jasmine_selenium_runner
[junit]: https://github.com/jasmine/jasmine_junitxml_formatter
