/*************************GO-LICENSE-START*********************************
 * Copyright 2014 ThoughtWorks, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *************************GO-LICENSE-END***********************************/

package com.thoughtworks.go.matchers;

import java.io.File;

public class UploadEntry {
    public final File file;
    public final String destiname;

    public UploadEntry(File file, String destiname) {
        this.file = file;
        this.destiname = destiname;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        UploadEntry that = (UploadEntry) o;

        if (destiname != null ? !destiname.equals(that.destiname) : that.destiname != null) {
            return false;
        }
        if (file != null ? !file.equals(that.file) : that.file != null) {
            return false;
        }

        return true;
    }

    public int hashCode() {
        int result;
        result = (file != null ? file.hashCode() : 0);
        result = 31 * result + (destiname != null ? destiname.hashCode() : 0);
        return result;
    }

    public String toString() {
        return file.toString() + " ---> " + destiname;
    }
}
