/* nice.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Nice", gir_namespace = "Nice", gir_version = "0.1", lower_case_cprefix = "nice_")]
namespace Nice {
	[CCode (cheader_filename = "nice.h", type_id = "nice_agent_get_type ()")]
	public class Agent : GLib.Object {
		[CCode (has_construct_function = false)]
		public Agent (GLib.MainContext ctx, Nice.Compatibility compat);
		public bool add_local_address (Nice.Address addr);
		public uint add_stream (uint n_components);
		public bool attach_recv (uint stream_id, uint component_id, GLib.MainContext ctx, Nice.AgentRecvFunc func);
		[Version (since = "0.1.16")]
		public async void close_async ();
		[Version (since = "0.1.20")]
		public bool consent_lost (uint stream_id, uint component_id);
		[Version (since = "0.1.6")]
		public bool forget_relays (uint stream_id, uint component_id);
		[CCode (has_construct_function = false)]
		[Version (since = "0.1.15")]
		public Agent.full (GLib.MainContext ctx, Nice.Compatibility compat, Nice.AgentOption flags);
		public bool gather_candidates (uint stream_id);
		[Version (since = "0.1.4")]
		public string generate_local_candidate_sdp (Nice.Candidate candidate);
		[Version (since = "0.1.4")]
		public string generate_local_sdp ();
		[Version (since = "0.1.4")]
		public string generate_local_stream_sdp (uint stream_id, bool include_non_ice);
		[Version (since = "0.1.8")]
		public Nice.ComponentState get_component_state (uint stream_id, uint component_id);
		public Nice.Candidate get_default_local_candidate (uint stream_id, uint component_id);
		[Version (since = "0.1.5")]
		public GLib.IOStream get_io_stream (uint stream_id, uint component_id);
		public GLib.SList<Nice.Candidate> get_local_candidates (uint stream_id, uint component_id);
		public bool get_local_credentials (uint stream_id, out string ufrag, out string pwd);
		public GLib.SList<Nice.Candidate> get_remote_candidates (uint stream_id, uint component_id);
		public bool get_selected_pair (uint stream_id, uint component_id, Nice.Candidate local, Nice.Candidate remote);
		[Version (since = "0.1.5")]
		public GLib.Socket? get_selected_socket (uint stream_id, uint component_id);
		[Version (since = "0.1.17")]
		public GLib.GenericArray<GLib.Socket> get_sockets (uint stream_id, uint component_id);
		[Version (since = "0.1.4")]
		public unowned string get_stream_name (uint stream_id);
		[CCode (cname = "nice_agent_new_reliable", has_construct_function = false)]
		[Version (since = "0.0.11")]
		public Agent.in_reliable_mode (GLib.MainContext ctx, Nice.Compatibility compat);
		[Version (since = "0.1.4")]
		public Nice.Candidate parse_remote_candidate_sdp (uint stream_id, string sdp);
		[Version (since = "0.1.4")]
		public int parse_remote_sdp (string sdp);
		[Version (since = "0.1.4")]
		public GLib.SList<Nice.Candidate> parse_remote_stream_sdp (uint stream_id, string sdp, string ufrag, string pwd);
		[Version (since = "0.1.16")]
		public bool peer_candidate_gathering_done (uint stream_id);
		[Version (since = "0.1.5")]
		public ssize_t recv (uint stream_id, uint component_id, [CCode (array_length_cname = "buf_len", array_length_pos = 3.5, array_length_type = "gsize")] out unowned uint8[] buf, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "0.1.5")]
		public int recv_messages (uint stream_id, uint component_id, [CCode (array_length_cname = "n_messages", array_length_pos = 3.5, array_length_type = "guint")] out unowned Nice.InputMessage[] messages, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "0.1.5")]
		public int recv_messages_nonblocking (uint stream_id, uint component_id, [CCode (array_length_cname = "n_messages", array_length_pos = 3.5, array_length_type = "guint")] out unowned Nice.InputMessage[] messages, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "0.1.5")]
		public ssize_t recv_nonblocking (uint stream_id, uint component_id, [CCode (array_length_cname = "buf_len", array_length_pos = 3.5, array_length_type = "gsize")] out unowned uint8[] buf, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public void remove_stream (uint stream_id);
		public bool restart ();
		[Version (since = "0.1.6")]
		public bool restart_stream (uint stream_id);
		public int send (uint stream_id, uint component_id, uint len, string buf);
		[Version (since = "0.1.5")]
		public int send_messages_nonblocking (uint stream_id, uint component_id, [CCode (array_length_cname = "n_messages", array_length_pos = 3.5, array_length_type = "guint")] Nice.OutputMessage[] messages, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public bool set_local_credentials (uint stream_id, string ufrag, string pwd);
		public void set_port_range (uint stream_id, uint component_id, uint min_port, uint max_port);
		public bool set_relay_info (uint stream_id, uint component_id, string server_ip, uint server_port, string username, string password, Nice.RelayType type);
		public int set_remote_candidates (uint stream_id, uint component_id, GLib.SList<Nice.Candidate> candidates);
		public bool set_remote_credentials (uint stream_id, string ufrag, string pwd);
		public bool set_selected_pair (uint stream_id, uint component_id, string lfoundation, string rfoundation);
		public bool set_selected_remote_candidate (uint stream_id, uint component_id, Nice.Candidate candidate);
		[Version (since = "0.0.10")]
		public void set_software (string software);
		[Version (since = "0.1.4")]
		public bool set_stream_name (uint stream_id, string name);
		[Version (since = "0.0.9")]
		public void set_stream_tos (uint stream_id, int tos);
		[NoAccessorMethod]
		[Version (since = "0.1.8")]
		public bool bytestream_tcp { get; }
		[NoAccessorMethod]
		public uint compatibility { get; construct; }
		[NoAccessorMethod]
		[Version (since = "0.1.20")]
		public bool consent_freshness { get; construct; }
		[NoAccessorMethod]
		public bool controlling_mode { get; set; }
		[NoAccessorMethod]
		[Version (since = "0.1.14")]
		public bool force_relay { get; set; }
		[NoAccessorMethod]
		public bool full_mode { get; construct; }
		[NoAccessorMethod]
		[Version (since = "0.1.8")]
		public bool ice_tcp { get; set; }
		[NoAccessorMethod]
		[Version (since = "0.1.16")]
		public bool ice_trickle { get; set; }
		[NoAccessorMethod]
		[Version (since = "0.1.8")]
		public bool ice_udp { get; set; }
		[NoAccessorMethod]
		[Version (since = "0.1.17")]
		public uint idle_timeout { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "0.1.8")]
		public bool keepalive_conncheck { get; set; }
		[NoAccessorMethod]
		public void* main_context { get; construct; }
		[NoAccessorMethod]
		public uint max_connectivity_checks { get; set; }
		[NoAccessorMethod]
		[Version (since = "0.0.4")]
		public string proxy_ip { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "0.0.4")]
		public string proxy_password { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "0.0.4")]
		public uint proxy_port { get; set; }
		[NoAccessorMethod]
		[Version (since = "0.0.4")]
		public uint proxy_type { get; set; }
		[NoAccessorMethod]
		[Version (since = "0.0.4")]
		public string proxy_username { owned get; set; }
		[NoAccessorMethod]
		[Version (since = "0.0.11")]
		public bool reliable { get; construct; }
		[NoAccessorMethod]
		[Version (since = "0.1.15")]
		public uint stun_initial_timeout { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "0.1.15")]
		public uint stun_max_retransmissions { get; set construct; }
		[NoAccessorMethod]
		public uint stun_pacing_timer { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "0.1.15")]
		public uint stun_reliable_timeout { get; set construct; }
		[NoAccessorMethod]
		public string stun_server { owned get; set; }
		[NoAccessorMethod]
		public uint stun_server_port { get; set; }
		[NoAccessorMethod]
		public bool support_renomination { get; set; }
		[NoAccessorMethod]
		[Version (since = "0.0.7")]
		public bool upnp { get; set construct; }
		[NoAccessorMethod]
		[Version (since = "0.0.7")]
		public uint upnp_timeout { get; set construct; }
		public signal void candidate_gathering_done (uint stream_id);
		public signal void component_state_changed (uint stream_id, uint component_id, Nice.ComponentState state);
		public signal void initial_binding_request_received (uint stream_id);
		[Version (deprecated = true, deprecated_since = "0.1.8")]
		public signal void new_candidate (uint stream_id, uint component_id, string foundation);
		[Version (since = "0.1.8")]
		public signal void new_candidate_full (Nice.Candidate candidate);
		[Version (deprecated = true, deprecated_since = "0.1.8")]
		public signal void new_remote_candidate (uint stream_id, uint component_id, string foundation);
		[Version (since = "0.1.8")]
		public signal void new_remote_candidate_full (Nice.Candidate candidate);
		[Version (deprecated = true, deprecated_since = "0.1.8")]
		public signal void new_selected_pair (uint stream_id, uint component_id, string lfoundation, string rfoundation);
		[Version (since = "0.1.8")]
		public signal void new_selected_pair_full (uint stream_id, uint component_id, Nice.Candidate lcandidate, Nice.Candidate rcandidate);
		[Version (since = "0.0.11")]
		public signal void reliable_transport_writable (uint stream_id, uint component_id);
		[Version (since = "0.1.5")]
		public signal void streams_removed ([CCode (array_length = false, array_null_terminated = true)] uint[] stream_ids);
	}
	[CCode (cheader_filename = "nice.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "nice_candidate_get_type ()")]
	[Compact]
	public class Candidate {
		public Nice.Address addr;
		public Nice.Address base_addr;
		public uint component_id;
		[CCode (array_length = false)]
		public weak char foundation[33];
		public weak string password;
		public uint32 priority;
		public uint stream_id;
		public Nice.CandidateTransport transport;
		public Nice.CandidateType type;
		public weak string username;
		[CCode (has_construct_function = false)]
		public Candidate (Nice.CandidateType type);
		public Nice.Candidate copy ();
		[Version (since = "0.1.15")]
		public bool equal_target (Nice.Candidate candidate2);
		public void free ();
	}
	[CCode (cheader_filename = "nice.h", cname = "PseudoTcpSocket", type_id = "pseudo_tcp_socket_get_type ()")]
	[Version (since = "0.0.11")]
	public class PseudoTcpSocket : GLib.Object {
		[CCode (cname = "pseudo_tcp_socket_new", has_construct_function = false)]
		public PseudoTcpSocket (uint32 conversation, Nice.PseudoTcpCallbacks callbacks);
		[CCode (cname = "pseudo_tcp_socket_can_send")]
		[Version (since = "0.1.5")]
		public bool can_send ();
		[CCode (cname = "pseudo_tcp_socket_close")]
		public void close (bool force);
		[CCode (cname = "pseudo_tcp_socket_connect")]
		public bool connect ();
		[CCode (cname = "pseudo_tcp_socket_get_available_bytes")]
		[Version (since = "0.1.5")]
		public int get_available_bytes ();
		[CCode (cname = "pseudo_tcp_socket_get_available_send_space")]
		[Version (since = "0.1.5")]
		public size_t get_available_send_space ();
		[CCode (cname = "pseudo_tcp_socket_get_error")]
		public int get_error ();
		[CCode (cname = "pseudo_tcp_socket_get_next_clock")]
		public bool get_next_clock (uint64 timeout);
		[CCode (cname = "pseudo_tcp_socket_is_closed")]
		[Version (since = "0.1.8")]
		public bool is_closed ();
		[CCode (cname = "pseudo_tcp_socket_is_closed_remotely")]
		[Version (since = "0.1.8")]
		public bool is_closed_remotely ();
		[CCode (cname = "pseudo_tcp_socket_notify_clock")]
		public void notify_clock ();
		[CCode (cname = "pseudo_tcp_socket_notify_message")]
		[Version (since = "0.1.5")]
		public bool notify_message (Nice.InputMessage message);
		[CCode (cname = "pseudo_tcp_socket_notify_mtu")]
		public void notify_mtu (uint16 mtu);
		[CCode (cname = "pseudo_tcp_socket_notify_packet")]
		public bool notify_packet (string buffer, uint32 len);
		[CCode (cname = "pseudo_tcp_socket_recv")]
		public int recv (string buffer, size_t len);
		[CCode (cname = "pseudo_tcp_socket_send")]
		public int send (string buffer, uint32 len);
		[CCode (cname = "pseudo_tcp_socket_set_time")]
		[Version (since = "0.1.8")]
		public void set_time (uint32 current_time);
		[CCode (cname = "pseudo_tcp_socket_shutdown")]
		[Version (since = "0.1.8")]
		public void shutdown (Nice.PseudoTcpShutdown how);
		[NoAccessorMethod]
		public uint ack_delay { get; set; }
		[NoAccessorMethod]
		public void* callbacks { get; set; }
		[NoAccessorMethod]
		public uint conversation { get; construct; }
		[NoAccessorMethod]
		public bool no_delay { get; set; }
		[NoAccessorMethod]
		public uint rcv_buf { get; set; }
		[NoAccessorMethod]
		public uint snd_buf { get; set; }
		[NoAccessorMethod]
		public uint state { get; }
		[NoAccessorMethod]
		[Version (since = "0.1.8")]
		public bool support_fin_ack { get; construct; }
	}
	[CCode (cheader_filename = "nice.h", has_type_id = false)]
	public struct Address {
		[CCode (cname = "s.addr")]
		public void* s_addr;
		[CCode (cname = "s.ip4")]
		public void* s_ip4;
		[CCode (cname = "s.ip6")]
		public void* s_ip6;
		public void copy_to_sockaddr (void* sin);
		public bool equal (Nice.Address b);
		[Version (since = "0.1.8")]
		public bool equal_no_port (Nice.Address b);
		public void free ();
		public uint get_port ();
		public void init ();
		public int ip_version ();
		public bool is_private ();
		public bool is_valid ();
		public void set_from_sockaddr (void* sin);
		public bool set_from_string (string str);
		public void set_ipv4 (uint32 addr_ipv4);
		public void set_ipv6 (uint8 addr_ipv6);
		public void set_port (uint port);
		public void to_string (string dst);
	}
	[CCode (cheader_filename = "nice.h", has_type_id = false)]
	[Version (since = "0.1.5")]
	public struct InputMessage {
		[CCode (array_length_cname = "n_buffers")]
		public weak GLib.InputVector[] buffers;
		public int n_buffers;
		public Nice.Address from;
		public size_t length;
	}
	[CCode (cheader_filename = "nice.h", has_type_id = false)]
	[Version (since = "0.1.5")]
	public struct OutputMessage {
		[CCode (array_length_cname = "n_buffers")]
		public weak GLib.OutputVector[] buffers;
		public int n_buffers;
	}
	[CCode (cheader_filename = "nice.h", cname = "PseudoTcpCallbacks", has_type_id = false)]
	[Version (since = "0.0.11")]
	public struct PseudoTcpCallbacks {
		public void* user_data;
		public PseudoTcpOpenedFunc PseudoTcpOpened;
		public PseudoTcpReadableFunc PseudoTcpReadable;
		public PseudoTcpWritableFunc PseudoTcpWritable;
		public PseudoTcpClosedFunc PseudoTcpClosed;
		public WritePacketFunc WritePacket;
	}
	public delegate void PseudoTcpOpenedFunc (PseudoTcpSocket tcp, void* data);
	public delegate void PseudoTcpReadableFunc (PseudoTcpSocket tcp, void* data);
	public delegate void PseudoTcpWritableFunc (PseudoTcpSocket tcp, void* data);
	public delegate void PseudoTcpClosedFunc (PseudoTcpSocket tcp, uint32 error, void* data);
	public delegate void WritePacketFunc (PseudoTcpSocket tcp, uint8[] buffer, void* data);
	[CCode (cheader_filename = "nice.h", cprefix = "NICE_AGENT_OPTION_", has_type_id = false)]
	[Flags]
	[Version (since = "0.1.15")]
	public enum AgentOption {
		REGULAR_NOMINATION,
		RELIABLE,
		LITE_MODE,
		ICE_TRICKLE,
		SUPPORT_RENOMINATION,
		CONSENT_FRESHNESS,
		BYTESTREAM_TCP
	}
	[CCode (cheader_filename = "nice.h", cprefix = "NICE_CANDIDATE_TRANSPORT_", has_type_id = false)]
	public enum CandidateTransport {
		UDP,
		TCP_ACTIVE,
		TCP_PASSIVE,
		TCP_SO;
		[Version (since = "0.1.18")]
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "nice.h", cprefix = "NICE_CANDIDATE_TYPE_", has_type_id = false)]
	public enum CandidateType {
		HOST,
		SERVER_REFLEXIVE,
		PEER_REFLEXIVE,
		RELAYED;
		[Version (since = "0.1.18")]
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "nice.h", cprefix = "NICE_COMPATIBILITY_", has_type_id = false)]
	public enum Compatibility {
		RFC5245,
		DRAFT19,
		GOOGLE,
		MSN,
		WLM2009,
		OC2007,
		OC2007R2,
		LAST
	}
	[CCode (cheader_filename = "nice.h", cprefix = "NICE_COMPONENT_STATE_", has_type_id = false)]
	public enum ComponentState {
		DISCONNECTED,
		GATHERING,
		CONNECTING,
		CONNECTED,
		READY,
		FAILED,
		LAST;
		[Version (since = "0.1.6")]
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "nice.h", cprefix = "NICE_COMPONENT_TYPE_", has_type_id = false)]
	public enum ComponentType {
		RTP,
		RTCP
	}
	[CCode (cheader_filename = "nice.h", cprefix = "NICE_NOMINATION_MODE_", has_type_id = false)]
	[Version (since = "0.1.15")]
	public enum NominationMode {
		REGULAR,
		AGGRESSIVE
	}
	[CCode (cheader_filename = "nice.h", cprefix = "NICE_PROXY_TYPE_", has_type_id = false)]
	[Version (since = "0.0.4")]
	public enum ProxyType {
		NONE,
		SOCKS5,
		HTTP,
		LAST
	}
	[CCode (cheader_filename = "nice.h", cname = "PseudoTcpDebugLevel", cprefix = "PSEUDO_TCP_DEBUG_", has_type_id = false)]
	[Version (since = "0.0.11")]
	public enum PseudoTcpDebugLevel {
		NONE,
		NORMAL,
		VERBOSE
	}
	[CCode (cheader_filename = "nice.h", cname = "PseudoTcpShutdown", cprefix = "PSEUDO_TCP_SHUTDOWN_", has_type_id = false)]
	[Version (since = "0.1.8")]
	public enum PseudoTcpShutdown {
		RD,
		WR,
		RDWR
	}
	[CCode (cheader_filename = "nice.h", cname = "PseudoTcpState", cprefix = "PSEUDO_TCP_", has_type_id = false)]
	[Version (since = "0.0.11")]
	public enum PseudoTcpState {
		LISTEN,
		SYN_SENT,
		SYN_RECEIVED,
		ESTABLISHED,
		CLOSED,
		FIN_WAIT_1,
		FIN_WAIT_2,
		CLOSING,
		TIME_WAIT,
		CLOSE_WAIT,
		LAST_ACK
	}
	[CCode (cheader_filename = "nice.h", cname = "PseudoTcpWriteResult", cprefix = "WR_", has_type_id = false)]
	[Version (since = "0.0.11")]
	public enum PseudoTcpWriteResult {
		SUCCESS,
		TOO_LARGE,
		FAIL
	}
	[CCode (cheader_filename = "nice.h", cprefix = "NICE_RELAY_TYPE_", has_type_id = false)]
	public enum RelayType {
		TURN_UDP,
		TURN_TCP,
		TURN_TLS
	}
	[CCode (cheader_filename = "nice.h", instance_pos = 5.9)]
	public delegate void AgentRecvFunc (Nice.Agent agent, uint stream_id, uint component_id, [CCode (array_length_pos = 3.1, array_length_type = "guint")] uint8[] data);
	[CCode (cheader_filename = "nice.h", cname = "NICE_AGENT_MAX_REMOTE_CANDIDATES")]
	public const int AGENT_MAX_REMOTE_CANDIDATES;
	[CCode (cheader_filename = "nice.h", cname = "NICE_CANDIDATE_MAX_FOUNDATION")]
	public const int CANDIDATE_MAX_FOUNDATION;
	[CCode (cheader_filename = "nice.h", cname = "NICE_CANDIDATE_MAX_LOCAL_ADDRESSES")]
	public const int CANDIDATE_MAX_LOCAL_ADDRESSES;
	[CCode (cheader_filename = "nice.h", cname = "NICE_CANDIDATE_MAX_TURN_SERVERS")]
	public const int CANDIDATE_MAX_TURN_SERVERS;
	[CCode (cheader_filename = "nice.h")]
	public static void debug_disable (bool with_stun);
	[CCode (cheader_filename = "nice.h")]
	public static void debug_enable (bool with_stun);
	[CCode (cheader_filename = "nice.h")]
	public static string? interfaces_get_ip_for_interface (string interface_name);
	[CCode (cheader_filename = "nice.h")]
	public static GLib.List<string> interfaces_get_local_interfaces ();
	[CCode (cheader_filename = "nice.h")]
	public static GLib.List<string> interfaces_get_local_ips (bool include_loopback);
	[CCode (cheader_filename = "nice.h", cname = "pseudo_tcp_set_debug_level")]
	[Version (since = "0.0.11")]
	public static void pseudo_tcp_set_debug_level (Nice.PseudoTcpDebugLevel level);
}
