package oriedita.editor.swing.dialog;

import oriedita.editor.canvas.MouseMode;
import oriedita.editor.canvas.CreasePattern_Worker;
import oriedita.editor.databinding.CanvasModel;
import oriedita.editor.service.ButtonService;

import javax.swing.*;
import java.awt.*;
import java.beans.PropertyChangeEvent;

public class OpenFrame extends JDialog {
    private JCheckBox selectAnd3ClickCheckBox;
    private JButton o_F_checkButton;
    private JButton foldableLinePlusGridInputButton;
    private JButton select_polygonButton;
    private JButton unselect_polygonButton;
    private JButton select_lXButton;
    private JButton unselect_lXButton;
    private JButton del_lButton;
    private JButton del_l_XButton;
    private JPanel panel;

    public OpenFrame(String name, Frame owner, CanvasModel canvasModel, CreasePattern_Worker mainCreasePatternWorker, ButtonService buttonService) {
        super(owner, name);

        setContentPane($$$getRootComponent$$$());

        setDefaultCloseOperation(HIDE_ON_CLOSE);

        buttonService.registerButton(o_F_checkButton, "o_F_checkAction");
        buttonService.registerButton(foldableLinePlusGridInputButton, "foldableLinePlusGridInputAction");
        buttonService.registerButton(select_polygonButton, "select_polygonAction");
        buttonService.registerButton(unselect_polygonButton, "unselect_polygonAction");
        buttonService.registerButton(select_lXButton, "select_lXAction");
        buttonService.registerButton(unselect_lXButton, "unselect_lXAction");
        buttonService.registerButton(del_lButton, "del_lAction");
        buttonService.registerButton(del_l_XButton, "del_l_XAction");
        buttonService.registerButton(selectAnd3ClickCheckBox, "selectAnd3ClickAction");

        o_F_checkButton.addActionListener(e -> canvasModel.setMouseMode(MouseMode.FLAT_FOLDABLE_CHECK_63));
        foldableLinePlusGridInputButton.addActionListener(e -> {
            canvasModel.setMouseMode(MouseMode.FOLDABLE_LINE_INPUT_39);
            canvasModel.setMouseModeAfterColorSelection(MouseMode.FOLDABLE_LINE_INPUT_39);

            mainCreasePatternWorker.unselect_all();
        });
        select_polygonButton.addActionListener(e -> canvasModel.setMouseMode(MouseMode.SELECT_POLYGON_66));
        unselect_polygonButton.addActionListener(e -> canvasModel.setMouseMode(MouseMode.UNSELECT_POLYGON_67));
        select_lXButton.addActionListener(e -> canvasModel.setMouseMode(MouseMode.SELECT_LINE_INTERSECTING_68));
        unselect_lXButton.addActionListener(e -> canvasModel.setMouseMode(MouseMode.UNSELECT_LINE_INTERSECTING_69));
        del_lButton.addActionListener(e -> canvasModel.setMouseMode(MouseMode.CREASE_DELETE_OVERLAPPING_64));
        del_l_XButton.addActionListener(e -> canvasModel.setMouseMode(MouseMode.CREASE_DELETE_INTERSECTING_65));

        selectAnd3ClickCheckBox.addActionListener(e -> canvasModel.setCkbox_add_frame_SelectAnd3click_isSelected(selectAnd3ClickCheckBox.isSelected()));

        pack();
        setResizable(false);
    }

    public void setData(PropertyChangeEvent e, CanvasModel data) {
        if (e == null || e.getPropertyName() == null || e.getPropertyName().equals("mouseMode")) {
            MouseMode m = data.getMouseMode();

            o_F_checkButton.setSelected(m == MouseMode.FLAT_FOLDABLE_CHECK_63);
            foldableLinePlusGridInputButton.setSelected(m == MouseMode.FOLDABLE_LINE_INPUT_39);
            select_polygonButton.setSelected(m == MouseMode.SELECT_POLYGON_66);
            unselect_polygonButton.setSelected(m == MouseMode.UNSELECT_POLYGON_67);
            unselect_lXButton.setSelected(m == MouseMode.UNSELECT_LINE_INTERSECTING_69);
            select_lXButton.setSelected(m == MouseMode.SELECT_LINE_INTERSECTING_68);
            unselect_lXButton.setSelected(m == MouseMode.UNSELECT_LINE_INTERSECTING_69);
            del_lButton.setSelected(m == MouseMode.CREASE_DELETE_OVERLAPPING_64);
            del_l_XButton.setSelected(m == MouseMode.CREASE_DELETE_INTERSECTING_65);
        }

        selectAnd3ClickCheckBox.setSelected(data.isCkbox_add_frame_SelectAnd3click_isSelected());
    }

    {
// GUI initializer generated by IntelliJ IDEA GUI Designer
// >>> IMPORTANT!! <<<
// DO NOT EDIT OR ADD ANY CODE HERE!
        $$$setupUI$$$();
    }

    /**
     * Method generated by IntelliJ IDEA GUI Designer
     * >>> IMPORTANT!! <<<
     * DO NOT edit this method OR call it in your code!
     *
     * @noinspection ALL
     */
    private void $$$setupUI$$$() {
        panel = new JPanel();
        panel.setLayout(new FlowLayout(FlowLayout.CENTER, 5, 5));
        final JPanel panel1 = new JPanel();
        panel1.setLayout(new GridBagLayout());
        panel.add(panel1);
        selectAnd3ClickCheckBox = new JCheckBox();
        selectAnd3ClickCheckBox.setText("sel<=>mcm");
        GridBagConstraints gbc;
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = GridBagConstraints.WEST;
        panel1.add(selectAnd3ClickCheckBox, gbc);
        o_F_checkButton = new JButton();
        o_F_checkButton.setText("O_F_check");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        panel1.add(o_F_checkButton, gbc);
        foldableLinePlusGridInputButton = new JButton();
        foldableLinePlusGridInputButton.setIcon(new ImageIcon(getClass().getResource("/ppp/oritatami_kanousen_and_kousitenkei.png")));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        panel1.add(foldableLinePlusGridInputButton, gbc);
        select_polygonButton = new JButton();
        select_polygonButton.setBackground(new Color(-16711936));
        select_polygonButton.setText("select_polygon");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        panel1.add(select_polygonButton, gbc);
        unselect_polygonButton = new JButton();
        unselect_polygonButton.setBackground(new Color(-16711936));
        unselect_polygonButton.setText("unselect_polygon");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        panel1.add(unselect_polygonButton, gbc);
        select_lXButton = new JButton();
        select_lXButton.setBackground(new Color(-16711936));
        select_lXButton.setText("select_lX");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        panel1.add(select_lXButton, gbc);
        unselect_lXButton = new JButton();
        unselect_lXButton.setBackground(new Color(-16711936));
        unselect_lXButton.setText("unselect_lX");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        panel1.add(unselect_lXButton, gbc);
        del_lButton = new JButton();
        del_lButton.setText("Del_l");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        panel1.add(del_lButton, gbc);
        del_l_XButton = new JButton();
        del_l_XButton.setText("Del_l_X");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        panel1.add(del_l_XButton, gbc);
    }

    /**
     * @noinspection ALL
     */
    public JComponent $$$getRootComponent$$$() {
        return panel;
    }

}
