package oriedita.editor.swing.dialog;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;

import javax.swing.*;
import java.awt.*;
import java.awt.event.KeyEvent;

public class SaveTypeDialog extends JDialog {
    private JPanel contentPane;
    private JButton creasePatternCpSavesButton;
    private JButton completeOriAlsoSavesButton;

    private String saveType = null;

    public SaveTypeDialog(Frame owner) {
        super(owner, "Save type", ModalityType.APPLICATION_MODAL);
        setContentPane(contentPane);

        creasePatternCpSavesButton.addActionListener(e -> {
            saveType = ".cp";
            dispose();
        });
        completeOriAlsoSavesButton.addActionListener(e -> {
            saveType = ".ori";
            dispose();
        });

        // call onCancel() on ESCAPE
        contentPane.registerKeyboardAction(
                e -> dispose(),
                KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0),
                JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT
        );

        pack();

        setLocationRelativeTo(owner);
    }

    public static String showSaveTypeDialog(Frame owner) {
        SaveTypeDialog saveTypeDialog = new SaveTypeDialog(owner);
        saveTypeDialog.setVisible(true);

        String saveType = saveTypeDialog.saveType;

        saveTypeDialog.dispose();

        return saveType;
    }

    {
// GUI initializer generated by IntelliJ IDEA GUI Designer
// >>> IMPORTANT!! <<<
// DO NOT EDIT OR ADD ANY CODE HERE!
        $$$setupUI$$$();
    }

    /**
     * Method generated by IntelliJ IDEA GUI Designer
     * >>> IMPORTANT!! <<<
     * DO NOT edit this method OR call it in your code!
     *
     * @noinspection ALL
     */
    private void $$$setupUI$$$() {
        contentPane = new JPanel();
        contentPane.setLayout(new GridLayoutManager(1, 1, new Insets(10, 10, 10, 10), -1, -1));
        final JPanel panel1 = new JPanel();
        panel1.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        contentPane.add(panel1, new GridConstraints(0, 0, 1, 1, GridConstraints.ANCHOR_CENTER, GridConstraints.FILL_BOTH, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_CAN_GROW, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_CAN_GROW, null, null, null, 0, false));
        creasePatternCpSavesButton = new JButton();
        creasePatternCpSavesButton.setHorizontalAlignment(2);
        creasePatternCpSavesButton.setText("<html><b>Crease Pattern (.cp)</b><br/>\nSaves only crease pattern <br/>lines.<br/><br/>\n\n<i>Use this format to share <br/>crease patterns with other <br/>people.</i>");
        panel1.add(creasePatternCpSavesButton, new GridConstraints(0, 0, 1, 1, GridConstraints.ANCHOR_CENTER, GridConstraints.FILL_BOTH, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_CAN_GROW, GridConstraints.SIZEPOLICY_FIXED, null, null, null, 0, false));
        completeOriAlsoSavesButton = new JButton();
        completeOriAlsoSavesButton.setHorizontalAlignment(2);
        completeOriAlsoSavesButton.setText("<html><b>Complete (.ori)</b><br/>\nAlso saves circles, yellow <br/>aux lines and the grid.<br/>\n<br/>\n<i>Use this format when <br/>saving to your local <br/>computer.</i>");
        panel1.add(completeOriAlsoSavesButton, new GridConstraints(0, 1, 1, 1, GridConstraints.ANCHOR_CENTER, GridConstraints.FILL_BOTH, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_CAN_GROW, GridConstraints.SIZEPOLICY_FIXED, null, null, null, 0, false));
    }

    /**
     * @noinspection ALL
     */
    public JComponent $$$getRootComponent$$$() {
        return contentPane;
    }

}
