package cats.tests

import org.scalacheck.Arbitrary
import org.scalacheck.Arbitrary.arbitrary

import scala.collection.immutable.BitSet

class BitSetTests extends CatsSuite {
  implicit val arbitraryBitSet: Arbitrary[BitSet] =
    Arbitrary(arbitrary[List[Short]].map(ns => BitSet(ns.map(_ & 0xffff): _*)))

  test("show BitSet"){
    BitSet(1, 1, 2, 3).show should === ("BitSet(1, 2, 3)")
    BitSet.empty.show should === ("BitSet()")

    forAll { fs: BitSet =>
      fs.show should === (fs.toString)
    }
  }

}
