package model

import (
	"time"
)

type User struct {
	Id          int64      `json:"id"`
	Ux          string     `json:"ux" gorm:"not null"`
	StorageUsed uint64     `json:"storage_used" gorm:"not null"`
	StorageMax  uint64     `json:"storage_max" gorm:"not null"`
	Created     time.Time  `json:"created" gorm:"column:created_at;not null"`
	Updated     time.Time  `json:"updated" gorm:"column:updated_at;not null"`
	Deleted     *time.Time `json:"-" gorm:"column:deleted_at"`
}

func (User) TableName() string {
	return "zp_user"
}

func (u *User) StorageOverflowed(addonSize int64) bool {
	if u.StorageUsed+uint64(addonSize) >= u.StorageMax {
		return true
	}

	return false
}

type UserFormats struct {
	User

	Email    string `json:"email"`
	Username string `json:"username"`
	RoleName string `json:"role"`
	Status   string `json:"status"`
	Nickname string `json:"nickname"`
	Avatar   string `json:"avatar"`
	Bio      string `json:"bio"`
}
