--------------------------------------------------------------------------
-- Moonshine - a Lua virtual machine.
--
-- Copyright (C) 2013 Gamesys Limited,
-- 10 Piccadilly, London W1J 0DD
-- Email: moonshine@gamesys.co.uk
-- http://moonshinejs.org
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.
--


local datetest = function ()

	--[[
	local dates = {{1, 1}, {1, 2}, {28, 2}, {29, 2}, {1, 3}, {31, 12}}
	local years = {1999, 2000, 2011}
	local symbols = {'%a', '%A', '%b', '%B', '%d', '%H', '%I', '%j', '%m', '%M', '%p', '%S', '%U', '%w', '%W', '%x', '%X', '%y', '%Y', '%Z', '%%', '!%a', '!%A', '!%b', '!%B', '!%d', '!%H', '!%I', '!%j', '!%m', '!%M', '!%p', '!%S', '!%U', '!%w', '!%W', '!%x', '!%X', '!%y', '!%Y', '!%Z'}
	local index = 0

	for _, year in pairs (years) do
		for _, date in pairs (dates) do
			local time = os.time {
				year = year,
				month = date[2],
				day = date[1],
				hour = date[2]
			}

			print ('\nlocal time = '..time..'\n')
		
			for _, symbol in pairs (symbols) do
				index = index + 1			
				print ("assertTrue (os.date ('"..symbol.."', time) == '"..os.date (symbol, time).."', 'os.date() did not return expected value when passed \""..symbol.."\" ["..index.."]')")
			end
		
			local data = os.date ('*t', time)
			for key, value in pairs (data) do
				index = index + 1
			
				local val = tostring (value)
				if type (value) == 'string' then val = "'"..val.."'" end
				
				print ("assertTrue (os.date ('*t', time)."..key.." == "..val..", 'os.date() did not return expected value when passed \"*t\" ["..index.."]')")
			end
		
			local data = os.date ('!*t', time)
			for key, value in pairs (data) do
				index = index + 1
			
				local val = tostring (value)
				if type (value) == 'string' then val = "'"..val.."'" end
				
				print ("assertTrue (os.date ('!*t', time)."..key.." == "..val..", 'os.date() did not return expected value when passed \"!*t\" ["..index.."]')")
			end
		
		
		end
	end
	--]]


	local time = 915152400

	assertTrue (os.date ('%a', time) == 'Fri', 'os.date() did not return expected value when passed "%a" [1]')
	assertTrue (os.date ('%A', time) == 'Friday', 'os.date() did not return expected value when passed "%A" [2]')
	assertTrue (os.date ('%b', time) == 'Jan', 'os.date() did not return expected value when passed "%b" [3]')
	assertTrue (os.date ('%B', time) == 'January', 'os.date() did not return expected value when passed "%B" [4]')
	assertTrue (os.date ('%d', time) == '01', 'os.date() did not return expected value when passed "%d" [5]')
	assertTrue (os.date ('%H', time) == '01', 'os.date() did not return expected value when passed "%H" [6]')
	assertTrue (os.date ('%I', time) == '01', 'os.date() did not return expected value when passed "%I" [7]')
	assertTrue (os.date ('%j', time) == '001', 'os.date() did not return expected value when passed "%j" [8]')
	assertTrue (os.date ('%m', time) == '01', 'os.date() did not return expected value when passed "%m" [9]')
	assertTrue (os.date ('%M', time) == '00', 'os.date() did not return expected value when passed "%M" [10]')
	assertTrue (os.date ('%p', time) == 'AM', 'os.date() did not return expected value when passed "%p" [11]')
	assertTrue (os.date ('%S', time) == '00', 'os.date() did not return expected value when passed "%S" [12]')
	assertTrue (os.date ('%U', time) == '00', 'os.date() did not return expected value when passed "%U" [13]')
	assertTrue (os.date ('%w', time) == '5', 'os.date() did not return expected value when passed "%w" [14]')
	assertTrue (os.date ('%W', time) == '00', 'os.date() did not return expected value when passed "%W" [15]')
	assertTrue (os.date ('%x', time) == '01/01/99', 'os.date() did not return expected value when passed "%x" [16]')
	assertTrue (os.date ('%X', time) == '01:00:00', 'os.date() did not return expected value when passed "%X" [17]')
	assertTrue (os.date ('%y', time) == '99', 'os.date() did not return expected value when passed "%y" [18]')
	assertTrue (os.date ('%Y', time) == '1999', 'os.date() did not return expected value when passed "%Y" [19]')
	assertTrue (os.date ('%Z', time) == 'GMT', 'os.date() did not return expected value when passed "%Z" [20]')
	assertTrue (os.date ('%%', time) == '%', 'os.date() did not return expected value when passed "%%" [21]')
	assertTrue (os.date ('!%a', time) == 'Fri', 'os.date() did not return expected value when passed "!%a" [22]')
	assertTrue (os.date ('!%A', time) == 'Friday', 'os.date() did not return expected value when passed "!%A" [23]')
	assertTrue (os.date ('!%b', time) == 'Jan', 'os.date() did not return expected value when passed "!%b" [24]')
	assertTrue (os.date ('!%B', time) == 'January', 'os.date() did not return expected value when passed "!%B" [25]')
	assertTrue (os.date ('!%d', time) == '01', 'os.date() did not return expected value when passed "!%d" [26]')
	assertTrue (os.date ('!%H', time) == '01', 'os.date() did not return expected value when passed "!%H" [27]')
	assertTrue (os.date ('!%I', time) == '01', 'os.date() did not return expected value when passed "!%I" [28]')
	assertTrue (os.date ('!%j', time) == '001', 'os.date() did not return expected value when passed "!%j" [29]')
	assertTrue (os.date ('!%m', time) == '01', 'os.date() did not return expected value when passed "!%m" [30]')
	assertTrue (os.date ('!%M', time) == '00', 'os.date() did not return expected value when passed "!%M" [31]')
	assertTrue (os.date ('!%p', time) == 'AM', 'os.date() did not return expected value when passed "!%p" [32]')
	assertTrue (os.date ('!%S', time) == '00', 'os.date() did not return expected value when passed "!%S" [33]')
	assertTrue (os.date ('!%U', time) == '00', 'os.date() did not return expected value when passed "!%U" [34]')
	assertTrue (os.date ('!%w', time) == '5', 'os.date() did not return expected value when passed "!%w" [35]')
	assertTrue (os.date ('!%W', time) == '00', 'os.date() did not return expected value when passed "!%W" [36]')
	assertTrue (os.date ('!%x', time) == '01/01/99', 'os.date() did not return expected value when passed "!%x" [37]')
	assertTrue (os.date ('!%X', time) == '01:00:00', 'os.date() did not return expected value when passed "!%X" [38]')
	assertTrue (os.date ('!%y', time) == '99', 'os.date() did not return expected value when passed "!%y" [39]')
	assertTrue (os.date ('!%Y', time) == '1999', 'os.date() did not return expected value when passed "!%Y" [40]')
	assertTrue (os.date ('!%Z', time) == 'UTC', 'os.date() did not return expected value when passed "!%Z" [41]')
	assertTrue (os.date ('*t', time).hour == 1, 'os.date() did not return expected value when passed "*t" [42]')
	assertTrue (os.date ('*t', time).min == 0, 'os.date() did not return expected value when passed "*t" [43]')
	assertTrue (os.date ('*t', time).wday == 6, 'os.date() did not return expected value when passed "*t" [44]')
	assertTrue (os.date ('*t', time).day == 1, 'os.date() did not return expected value when passed "*t" [45]')
	assertTrue (os.date ('*t', time).month == 1, 'os.date() did not return expected value when passed "*t" [46]')
	assertTrue (os.date ('*t', time).year == 1999, 'os.date() did not return expected value when passed "*t" [47]')
	assertTrue (os.date ('*t', time).sec == 0, 'os.date() did not return expected value when passed "*t" [48]')
	assertTrue (os.date ('*t', time).yday == 1, 'os.date() did not return expected value when passed "*t" [49]')
	assertTrue (os.date ('*t', time).isdst == false, 'os.date() did not return expected value when passed "*t" [50]')
	assertTrue (os.date ('!*t', time).hour == 1, 'os.date() did not return expected value when passed "!*t" [51]')
	assertTrue (os.date ('!*t', time).min == 0, 'os.date() did not return expected value when passed "!*t" [52]')
	assertTrue (os.date ('!*t', time).wday == 6, 'os.date() did not return expected value when passed "!*t" [53]')
	assertTrue (os.date ('!*t', time).day == 1, 'os.date() did not return expected value when passed "!*t" [54]')
	assertTrue (os.date ('!*t', time).month == 1, 'os.date() did not return expected value when passed "!*t" [55]')
	assertTrue (os.date ('!*t', time).year == 1999, 'os.date() did not return expected value when passed "!*t" [56]')
	assertTrue (os.date ('!*t', time).sec == 0, 'os.date() did not return expected value when passed "!*t" [57]')
	assertTrue (os.date ('!*t', time).yday == 1, 'os.date() did not return expected value when passed "!*t" [58]')
	assertTrue (os.date ('!*t', time).isdst == false, 'os.date() did not return expected value when passed "!*t" [59]')

	local time = 917834400

	assertTrue (os.date ('%a', time) == 'Mon', 'os.date() did not return expected value when passed "%a" [60]')
	assertTrue (os.date ('%A', time) == 'Monday', 'os.date() did not return expected value when passed "%A" [61]')
	assertTrue (os.date ('%b', time) == 'Feb', 'os.date() did not return expected value when passed "%b" [62]')
	assertTrue (os.date ('%B', time) == 'February', 'os.date() did not return expected value when passed "%B" [63]')
	assertTrue (os.date ('%d', time) == '01', 'os.date() did not return expected value when passed "%d" [64]')
	assertTrue (os.date ('%H', time) == '02', 'os.date() did not return expected value when passed "%H" [65]')
	assertTrue (os.date ('%I', time) == '02', 'os.date() did not return expected value when passed "%I" [66]')
	assertTrue (os.date ('%j', time) == '032', 'os.date() did not return expected value when passed "%j" [67]')
	assertTrue (os.date ('%m', time) == '02', 'os.date() did not return expected value when passed "%m" [68]')
	assertTrue (os.date ('%M', time) == '00', 'os.date() did not return expected value when passed "%M" [69]')
	assertTrue (os.date ('%p', time) == 'AM', 'os.date() did not return expected value when passed "%p" [70]')
	assertTrue (os.date ('%S', time) == '00', 'os.date() did not return expected value when passed "%S" [71]')
	assertTrue (os.date ('%U', time) == '05', 'os.date() did not return expected value when passed "%U" [72]')
	assertTrue (os.date ('%w', time) == '1', 'os.date() did not return expected value when passed "%w" [73]')
	assertTrue (os.date ('%W', time) == '05', 'os.date() did not return expected value when passed "%W" [74]')
	assertTrue (os.date ('%x', time) == '02/01/99', 'os.date() did not return expected value when passed "%x" [75]')
	assertTrue (os.date ('%X', time) == '02:00:00', 'os.date() did not return expected value when passed "%X" [76]')
	assertTrue (os.date ('%y', time) == '99', 'os.date() did not return expected value when passed "%y" [77]')
	assertTrue (os.date ('%Y', time) == '1999', 'os.date() did not return expected value when passed "%Y" [78]')
	assertTrue (os.date ('%Z', time) == 'GMT', 'os.date() did not return expected value when passed "%Z" [79]')
	assertTrue (os.date ('%%', time) == '%', 'os.date() did not return expected value when passed "%%" [80]')
	assertTrue (os.date ('!%a', time) == 'Mon', 'os.date() did not return expected value when passed "!%a" [81]')
	assertTrue (os.date ('!%A', time) == 'Monday', 'os.date() did not return expected value when passed "!%A" [82]')
	assertTrue (os.date ('!%b', time) == 'Feb', 'os.date() did not return expected value when passed "!%b" [83]')
	assertTrue (os.date ('!%B', time) == 'February', 'os.date() did not return expected value when passed "!%B" [84]')
	assertTrue (os.date ('!%d', time) == '01', 'os.date() did not return expected value when passed "!%d" [85]')
	assertTrue (os.date ('!%H', time) == '02', 'os.date() did not return expected value when passed "!%H" [86]')
	assertTrue (os.date ('!%I', time) == '02', 'os.date() did not return expected value when passed "!%I" [87]')
	assertTrue (os.date ('!%j', time) == '032', 'os.date() did not return expected value when passed "!%j" [88]')
	assertTrue (os.date ('!%m', time) == '02', 'os.date() did not return expected value when passed "!%m" [89]')
	assertTrue (os.date ('!%M', time) == '00', 'os.date() did not return expected value when passed "!%M" [90]')
	assertTrue (os.date ('!%p', time) == 'AM', 'os.date() did not return expected value when passed "!%p" [91]')
	assertTrue (os.date ('!%S', time) == '00', 'os.date() did not return expected value when passed "!%S" [92]')
	assertTrue (os.date ('!%U', time) == '05', 'os.date() did not return expected value when passed "!%U" [93]')
	assertTrue (os.date ('!%w', time) == '1', 'os.date() did not return expected value when passed "!%w" [94]')
	assertTrue (os.date ('!%W', time) == '05', 'os.date() did not return expected value when passed "!%W" [95]')
	assertTrue (os.date ('!%x', time) == '02/01/99', 'os.date() did not return expected value when passed "!%x" [96]')
	assertTrue (os.date ('!%X', time) == '02:00:00', 'os.date() did not return expected value when passed "!%X" [97]')
	assertTrue (os.date ('!%y', time) == '99', 'os.date() did not return expected value when passed "!%y" [98]')
	assertTrue (os.date ('!%Y', time) == '1999', 'os.date() did not return expected value when passed "!%Y" [99]')
	assertTrue (os.date ('!%Z', time) == 'UTC', 'os.date() did not return expected value when passed "!%Z" [100]')
	assertTrue (os.date ('*t', time).hour == 2, 'os.date() did not return expected value when passed "*t" [101]')
	assertTrue (os.date ('*t', time).min == 0, 'os.date() did not return expected value when passed "*t" [102]')
	assertTrue (os.date ('*t', time).wday == 2, 'os.date() did not return expected value when passed "*t" [103]')
	assertTrue (os.date ('*t', time).day == 1, 'os.date() did not return expected value when passed "*t" [104]')
	assertTrue (os.date ('*t', time).month == 2, 'os.date() did not return expected value when passed "*t" [105]')
	assertTrue (os.date ('*t', time).year == 1999, 'os.date() did not return expected value when passed "*t" [106]')
	assertTrue (os.date ('*t', time).sec == 0, 'os.date() did not return expected value when passed "*t" [107]')
	assertTrue (os.date ('*t', time).yday == 32, 'os.date() did not return expected value when passed "*t" [108]')
	assertTrue (os.date ('*t', time).isdst == false, 'os.date() did not return expected value when passed "*t" [109]')
	assertTrue (os.date ('!*t', time).hour == 2, 'os.date() did not return expected value when passed "!*t" [110]')
	assertTrue (os.date ('!*t', time).min == 0, 'os.date() did not return expected value when passed "!*t" [111]')
	assertTrue (os.date ('!*t', time).wday == 2, 'os.date() did not return expected value when passed "!*t" [112]')
	assertTrue (os.date ('!*t', time).day == 1, 'os.date() did not return expected value when passed "!*t" [113]')
	assertTrue (os.date ('!*t', time).month == 2, 'os.date() did not return expected value when passed "!*t" [114]')
	assertTrue (os.date ('!*t', time).year == 1999, 'os.date() did not return expected value when passed "!*t" [115]')
	assertTrue (os.date ('!*t', time).sec == 0, 'os.date() did not return expected value when passed "!*t" [116]')
	assertTrue (os.date ('!*t', time).yday == 32, 'os.date() did not return expected value when passed "!*t" [117]')
	assertTrue (os.date ('!*t', time).isdst == false, 'os.date() did not return expected value when passed "!*t" [118]')

	local time = 920167200

	assertTrue (os.date ('%a', time) == 'Sun', 'os.date() did not return expected value when passed "%a" [119]')
	assertTrue (os.date ('%A', time) == 'Sunday', 'os.date() did not return expected value when passed "%A" [120]')
	assertTrue (os.date ('%b', time) == 'Feb', 'os.date() did not return expected value when passed "%b" [121]')
	assertTrue (os.date ('%B', time) == 'February', 'os.date() did not return expected value when passed "%B" [122]')
	assertTrue (os.date ('%d', time) == '28', 'os.date() did not return expected value when passed "%d" [123]')
	assertTrue (os.date ('%H', time) == '02', 'os.date() did not return expected value when passed "%H" [124]')
	assertTrue (os.date ('%I', time) == '02', 'os.date() did not return expected value when passed "%I" [125]')
	assertTrue (os.date ('%j', time) == '059', 'os.date() did not return expected value when passed "%j" [126]')
	assertTrue (os.date ('%m', time) == '02', 'os.date() did not return expected value when passed "%m" [127]')
	assertTrue (os.date ('%M', time) == '00', 'os.date() did not return expected value when passed "%M" [128]')
	assertTrue (os.date ('%p', time) == 'AM', 'os.date() did not return expected value when passed "%p" [129]')
	assertTrue (os.date ('%S', time) == '00', 'os.date() did not return expected value when passed "%S" [130]')
	assertTrue (os.date ('%U', time) == '09', 'os.date() did not return expected value when passed "%U" [131]')
	assertTrue (os.date ('%w', time) == '0', 'os.date() did not return expected value when passed "%w" [132]')
	assertTrue (os.date ('%W', time) == '08', 'os.date() did not return expected value when passed "%W" [133]')
	assertTrue (os.date ('%x', time) == '02/28/99', 'os.date() did not return expected value when passed "%x" [134]')
	assertTrue (os.date ('%X', time) == '02:00:00', 'os.date() did not return expected value when passed "%X" [135]')
	assertTrue (os.date ('%y', time) == '99', 'os.date() did not return expected value when passed "%y" [136]')
	assertTrue (os.date ('%Y', time) == '1999', 'os.date() did not return expected value when passed "%Y" [137]')
	assertTrue (os.date ('%Z', time) == 'GMT', 'os.date() did not return expected value when passed "%Z" [138]')
	assertTrue (os.date ('%%', time) == '%', 'os.date() did not return expected value when passed "%%" [139]')
	assertTrue (os.date ('!%a', time) == 'Sun', 'os.date() did not return expected value when passed "!%a" [140]')
	assertTrue (os.date ('!%A', time) == 'Sunday', 'os.date() did not return expected value when passed "!%A" [141]')
	assertTrue (os.date ('!%b', time) == 'Feb', 'os.date() did not return expected value when passed "!%b" [142]')
	assertTrue (os.date ('!%B', time) == 'February', 'os.date() did not return expected value when passed "!%B" [143]')
	assertTrue (os.date ('!%d', time) == '28', 'os.date() did not return expected value when passed "!%d" [144]')
	assertTrue (os.date ('!%H', time) == '02', 'os.date() did not return expected value when passed "!%H" [145]')
	assertTrue (os.date ('!%I', time) == '02', 'os.date() did not return expected value when passed "!%I" [146]')
	assertTrue (os.date ('!%j', time) == '059', 'os.date() did not return expected value when passed "!%j" [147]')
	assertTrue (os.date ('!%m', time) == '02', 'os.date() did not return expected value when passed "!%m" [148]')
	assertTrue (os.date ('!%M', time) == '00', 'os.date() did not return expected value when passed "!%M" [149]')
	assertTrue (os.date ('!%p', time) == 'AM', 'os.date() did not return expected value when passed "!%p" [150]')
	assertTrue (os.date ('!%S', time) == '00', 'os.date() did not return expected value when passed "!%S" [151]')
	assertTrue (os.date ('!%U', time) == '09', 'os.date() did not return expected value when passed "!%U" [152]')
	assertTrue (os.date ('!%w', time) == '0', 'os.date() did not return expected value when passed "!%w" [153]')
	assertTrue (os.date ('!%W', time) == '08', 'os.date() did not return expected value when passed "!%W" [154]')
	assertTrue (os.date ('!%x', time) == '02/28/99', 'os.date() did not return expected value when passed "!%x" [155]')
	assertTrue (os.date ('!%X', time) == '02:00:00', 'os.date() did not return expected value when passed "!%X" [156]')
	assertTrue (os.date ('!%y', time) == '99', 'os.date() did not return expected value when passed "!%y" [157]')
	assertTrue (os.date ('!%Y', time) == '1999', 'os.date() did not return expected value when passed "!%Y" [158]')
	assertTrue (os.date ('!%Z', time) == 'UTC', 'os.date() did not return expected value when passed "!%Z" [159]')
	assertTrue (os.date ('*t', time).hour == 2, 'os.date() did not return expected value when passed "*t" [160]')
	assertTrue (os.date ('*t', time).min == 0, 'os.date() did not return expected value when passed "*t" [161]')
	assertTrue (os.date ('*t', time).wday == 1, 'os.date() did not return expected value when passed "*t" [162]')
	assertTrue (os.date ('*t', time).day == 28, 'os.date() did not return expected value when passed "*t" [163]')
	assertTrue (os.date ('*t', time).month == 2, 'os.date() did not return expected value when passed "*t" [164]')
	assertTrue (os.date ('*t', time).year == 1999, 'os.date() did not return expected value when passed "*t" [165]')
	assertTrue (os.date ('*t', time).sec == 0, 'os.date() did not return expected value when passed "*t" [166]')
	assertTrue (os.date ('*t', time).yday == 59, 'os.date() did not return expected value when passed "*t" [167]')
	assertTrue (os.date ('*t', time).isdst == false, 'os.date() did not return expected value when passed "*t" [168]')
	assertTrue (os.date ('!*t', time).hour == 2, 'os.date() did not return expected value when passed "!*t" [169]')
	assertTrue (os.date ('!*t', time).min == 0, 'os.date() did not return expected value when passed "!*t" [170]')
	assertTrue (os.date ('!*t', time).wday == 1, 'os.date() did not return expected value when passed "!*t" [171]')
	assertTrue (os.date ('!*t', time).day == 28, 'os.date() did not return expected value when passed "!*t" [172]')
	assertTrue (os.date ('!*t', time).month == 2, 'os.date() did not return expected value when passed "!*t" [173]')
	assertTrue (os.date ('!*t', time).year == 1999, 'os.date() did not return expected value when passed "!*t" [174]')
	assertTrue (os.date ('!*t', time).sec == 0, 'os.date() did not return expected value when passed "!*t" [175]')
	assertTrue (os.date ('!*t', time).yday == 59, 'os.date() did not return expected value when passed "!*t" [176]')
	assertTrue (os.date ('!*t', time).isdst == false, 'os.date() did not return expected value when passed "!*t" [177]')

	local time = 920253600

	assertTrue (os.date ('%a', time) == 'Mon', 'os.date() did not return expected value when passed "%a" [178]')
	assertTrue (os.date ('%A', time) == 'Monday', 'os.date() did not return expected value when passed "%A" [179]')
	assertTrue (os.date ('%b', time) == 'Mar', 'os.date() did not return expected value when passed "%b" [180]')
	assertTrue (os.date ('%B', time) == 'March', 'os.date() did not return expected value when passed "%B" [181]')
	assertTrue (os.date ('%d', time) == '01', 'os.date() did not return expected value when passed "%d" [182]')
	assertTrue (os.date ('%H', time) == '02', 'os.date() did not return expected value when passed "%H" [183]')
	assertTrue (os.date ('%I', time) == '02', 'os.date() did not return expected value when passed "%I" [184]')
	assertTrue (os.date ('%j', time) == '060', 'os.date() did not return expected value when passed "%j" [185]')
	assertTrue (os.date ('%m', time) == '03', 'os.date() did not return expected value when passed "%m" [186]')
	assertTrue (os.date ('%M', time) == '00', 'os.date() did not return expected value when passed "%M" [187]')
	assertTrue (os.date ('%p', time) == 'AM', 'os.date() did not return expected value when passed "%p" [188]')
	assertTrue (os.date ('%S', time) == '00', 'os.date() did not return expected value when passed "%S" [189]')
	assertTrue (os.date ('%U', time) == '09', 'os.date() did not return expected value when passed "%U" [190]')
	assertTrue (os.date ('%w', time) == '1', 'os.date() did not return expected value when passed "%w" [191]')
	assertTrue (os.date ('%W', time) == '09', 'os.date() did not return expected value when passed "%W" [192]')
	assertTrue (os.date ('%x', time) == '03/01/99', 'os.date() did not return expected value when passed "%x" [193]')
	assertTrue (os.date ('%X', time) == '02:00:00', 'os.date() did not return expected value when passed "%X" [194]')
	assertTrue (os.date ('%y', time) == '99', 'os.date() did not return expected value when passed "%y" [195]')
	assertTrue (os.date ('%Y', time) == '1999', 'os.date() did not return expected value when passed "%Y" [196]')
	assertTrue (os.date ('%Z', time) == 'GMT', 'os.date() did not return expected value when passed "%Z" [197]')
	assertTrue (os.date ('%%', time) == '%', 'os.date() did not return expected value when passed "%%" [198]')
	assertTrue (os.date ('!%a', time) == 'Mon', 'os.date() did not return expected value when passed "!%a" [199]')
	assertTrue (os.date ('!%A', time) == 'Monday', 'os.date() did not return expected value when passed "!%A" [200]')
	assertTrue (os.date ('!%b', time) == 'Mar', 'os.date() did not return expected value when passed "!%b" [201]')
	assertTrue (os.date ('!%B', time) == 'March', 'os.date() did not return expected value when passed "!%B" [202]')
	assertTrue (os.date ('!%d', time) == '01', 'os.date() did not return expected value when passed "!%d" [203]')
	assertTrue (os.date ('!%H', time) == '02', 'os.date() did not return expected value when passed "!%H" [204]')
	assertTrue (os.date ('!%I', time) == '02', 'os.date() did not return expected value when passed "!%I" [205]')
	assertTrue (os.date ('!%j', time) == '060', 'os.date() did not return expected value when passed "!%j" [206]')
	assertTrue (os.date ('!%m', time) == '03', 'os.date() did not return expected value when passed "!%m" [207]')
	assertTrue (os.date ('!%M', time) == '00', 'os.date() did not return expected value when passed "!%M" [208]')
	assertTrue (os.date ('!%p', time) == 'AM', 'os.date() did not return expected value when passed "!%p" [209]')
	assertTrue (os.date ('!%S', time) == '00', 'os.date() did not return expected value when passed "!%S" [210]')
	assertTrue (os.date ('!%U', time) == '09', 'os.date() did not return expected value when passed "!%U" [211]')
	assertTrue (os.date ('!%w', time) == '1', 'os.date() did not return expected value when passed "!%w" [212]')
	assertTrue (os.date ('!%W', time) == '09', 'os.date() did not return expected value when passed "!%W" [213]')
	assertTrue (os.date ('!%x', time) == '03/01/99', 'os.date() did not return expected value when passed "!%x" [214]')
	assertTrue (os.date ('!%X', time) == '02:00:00', 'os.date() did not return expected value when passed "!%X" [215]')
	assertTrue (os.date ('!%y', time) == '99', 'os.date() did not return expected value when passed "!%y" [216]')
	assertTrue (os.date ('!%Y', time) == '1999', 'os.date() did not return expected value when passed "!%Y" [217]')
	assertTrue (os.date ('!%Z', time) == 'UTC', 'os.date() did not return expected value when passed "!%Z" [218]')
	assertTrue (os.date ('*t', time).hour == 2, 'os.date() did not return expected value when passed "*t" [219]')
	assertTrue (os.date ('*t', time).min == 0, 'os.date() did not return expected value when passed "*t" [220]')
	assertTrue (os.date ('*t', time).wday == 2, 'os.date() did not return expected value when passed "*t" [221]')
	assertTrue (os.date ('*t', time).day == 1, 'os.date() did not return expected value when passed "*t" [222]')
	assertTrue (os.date ('*t', time).month == 3, 'os.date() did not return expected value when passed "*t" [223]')
	assertTrue (os.date ('*t', time).year == 1999, 'os.date() did not return expected value when passed "*t" [224]')
	assertTrue (os.date ('*t', time).sec == 0, 'os.date() did not return expected value when passed "*t" [225]')
	assertTrue (os.date ('*t', time).yday == 60, 'os.date() did not return expected value when passed "*t" [226]')
	assertTrue (os.date ('*t', time).isdst == false, 'os.date() did not return expected value when passed "*t" [227]')
	assertTrue (os.date ('!*t', time).hour == 2, 'os.date() did not return expected value when passed "!*t" [228]')
	assertTrue (os.date ('!*t', time).min == 0, 'os.date() did not return expected value when passed "!*t" [229]')
	assertTrue (os.date ('!*t', time).wday == 2, 'os.date() did not return expected value when passed "!*t" [230]')
	assertTrue (os.date ('!*t', time).day == 1, 'os.date() did not return expected value when passed "!*t" [231]')
	assertTrue (os.date ('!*t', time).month == 3, 'os.date() did not return expected value when passed "!*t" [232]')
	assertTrue (os.date ('!*t', time).year == 1999, 'os.date() did not return expected value when passed "!*t" [233]')
	assertTrue (os.date ('!*t', time).sec == 0, 'os.date() did not return expected value when passed "!*t" [234]')
	assertTrue (os.date ('!*t', time).yday == 60, 'os.date() did not return expected value when passed "!*t" [235]')
	assertTrue (os.date ('!*t', time).isdst == false, 'os.date() did not return expected value when passed "!*t" [236]')

	local time = 920257200

	assertTrue (os.date ('%a', time) == 'Mon', 'os.date() did not return expected value when passed "%a" [237]')
	assertTrue (os.date ('%A', time) == 'Monday', 'os.date() did not return expected value when passed "%A" [238]')
	assertTrue (os.date ('%b', time) == 'Mar', 'os.date() did not return expected value when passed "%b" [239]')
	assertTrue (os.date ('%B', time) == 'March', 'os.date() did not return expected value when passed "%B" [240]')
	assertTrue (os.date ('%d', time) == '01', 'os.date() did not return expected value when passed "%d" [241]')
	assertTrue (os.date ('%H', time) == '03', 'os.date() did not return expected value when passed "%H" [242]')
	assertTrue (os.date ('%I', time) == '03', 'os.date() did not return expected value when passed "%I" [243]')
	assertTrue (os.date ('%j', time) == '060', 'os.date() did not return expected value when passed "%j" [244]')
	assertTrue (os.date ('%m', time) == '03', 'os.date() did not return expected value when passed "%m" [245]')
	assertTrue (os.date ('%M', time) == '00', 'os.date() did not return expected value when passed "%M" [246]')
	assertTrue (os.date ('%p', time) == 'AM', 'os.date() did not return expected value when passed "%p" [247]')
	assertTrue (os.date ('%S', time) == '00', 'os.date() did not return expected value when passed "%S" [248]')
	assertTrue (os.date ('%U', time) == '09', 'os.date() did not return expected value when passed "%U" [249]')
	assertTrue (os.date ('%w', time) == '1', 'os.date() did not return expected value when passed "%w" [250]')
	assertTrue (os.date ('%W', time) == '09', 'os.date() did not return expected value when passed "%W" [251]')
	assertTrue (os.date ('%x', time) == '03/01/99', 'os.date() did not return expected value when passed "%x" [252]')
	assertTrue (os.date ('%X', time) == '03:00:00', 'os.date() did not return expected value when passed "%X" [253]')
	assertTrue (os.date ('%y', time) == '99', 'os.date() did not return expected value when passed "%y" [254]')
	assertTrue (os.date ('%Y', time) == '1999', 'os.date() did not return expected value when passed "%Y" [255]')
	assertTrue (os.date ('%Z', time) == 'GMT', 'os.date() did not return expected value when passed "%Z" [256]')
	assertTrue (os.date ('%%', time) == '%', 'os.date() did not return expected value when passed "%%" [257]')
	assertTrue (os.date ('!%a', time) == 'Mon', 'os.date() did not return expected value when passed "!%a" [258]')
	assertTrue (os.date ('!%A', time) == 'Monday', 'os.date() did not return expected value when passed "!%A" [259]')
	assertTrue (os.date ('!%b', time) == 'Mar', 'os.date() did not return expected value when passed "!%b" [260]')
	assertTrue (os.date ('!%B', time) == 'March', 'os.date() did not return expected value when passed "!%B" [261]')
	assertTrue (os.date ('!%d', time) == '01', 'os.date() did not return expected value when passed "!%d" [262]')
	assertTrue (os.date ('!%H', time) == '03', 'os.date() did not return expected value when passed "!%H" [263]')
	assertTrue (os.date ('!%I', time) == '03', 'os.date() did not return expected value when passed "!%I" [264]')
	assertTrue (os.date ('!%j', time) == '060', 'os.date() did not return expected value when passed "!%j" [265]')
	assertTrue (os.date ('!%m', time) == '03', 'os.date() did not return expected value when passed "!%m" [266]')
	assertTrue (os.date ('!%M', time) == '00', 'os.date() did not return expected value when passed "!%M" [267]')
	assertTrue (os.date ('!%p', time) == 'AM', 'os.date() did not return expected value when passed "!%p" [268]')
	assertTrue (os.date ('!%S', time) == '00', 'os.date() did not return expected value when passed "!%S" [269]')
	assertTrue (os.date ('!%U', time) == '09', 'os.date() did not return expected value when passed "!%U" [270]')
	assertTrue (os.date ('!%w', time) == '1', 'os.date() did not return expected value when passed "!%w" [271]')
	assertTrue (os.date ('!%W', time) == '09', 'os.date() did not return expected value when passed "!%W" [272]')
	assertTrue (os.date ('!%x', time) == '03/01/99', 'os.date() did not return expected value when passed "!%x" [273]')
	assertTrue (os.date ('!%X', time) == '03:00:00', 'os.date() did not return expected value when passed "!%X" [274]')
	assertTrue (os.date ('!%y', time) == '99', 'os.date() did not return expected value when passed "!%y" [275]')
	assertTrue (os.date ('!%Y', time) == '1999', 'os.date() did not return expected value when passed "!%Y" [276]')
	assertTrue (os.date ('!%Z', time) == 'UTC', 'os.date() did not return expected value when passed "!%Z" [277]')
	assertTrue (os.date ('*t', time).hour == 3, 'os.date() did not return expected value when passed "*t" [278]')
	assertTrue (os.date ('*t', time).min == 0, 'os.date() did not return expected value when passed "*t" [279]')
	assertTrue (os.date ('*t', time).wday == 2, 'os.date() did not return expected value when passed "*t" [280]')
	assertTrue (os.date ('*t', time).day == 1, 'os.date() did not return expected value when passed "*t" [281]')
	assertTrue (os.date ('*t', time).month == 3, 'os.date() did not return expected value when passed "*t" [282]')
	assertTrue (os.date ('*t', time).year == 1999, 'os.date() did not return expected value when passed "*t" [283]')
	assertTrue (os.date ('*t', time).sec == 0, 'os.date() did not return expected value when passed "*t" [284]')
	assertTrue (os.date ('*t', time).yday == 60, 'os.date() did not return expected value when passed "*t" [285]')
	assertTrue (os.date ('*t', time).isdst == false, 'os.date() did not return expected value when passed "*t" [286]')
	assertTrue (os.date ('!*t', time).hour == 3, 'os.date() did not return expected value when passed "!*t" [287]')
	assertTrue (os.date ('!*t', time).min == 0, 'os.date() did not return expected value when passed "!*t" [288]')
	assertTrue (os.date ('!*t', time).wday == 2, 'os.date() did not return expected value when passed "!*t" [289]')
	assertTrue (os.date ('!*t', time).day == 1, 'os.date() did not return expected value when passed "!*t" [290]')
	assertTrue (os.date ('!*t', time).month == 3, 'os.date() did not return expected value when passed "!*t" [291]')
	assertTrue (os.date ('!*t', time).year == 1999, 'os.date() did not return expected value when passed "!*t" [292]')
	assertTrue (os.date ('!*t', time).sec == 0, 'os.date() did not return expected value when passed "!*t" [293]')
	assertTrue (os.date ('!*t', time).yday == 60, 'os.date() did not return expected value when passed "!*t" [294]')
	assertTrue (os.date ('!*t', time).isdst == false, 'os.date() did not return expected value when passed "!*t" [295]')

	local time = 946641600

	assertTrue (os.date ('%a', time) == 'Fri', 'os.date() did not return expected value when passed "%a" [296]')
	assertTrue (os.date ('%A', time) == 'Friday', 'os.date() did not return expected value when passed "%A" [297]')
	assertTrue (os.date ('%b', time) == 'Dec', 'os.date() did not return expected value when passed "%b" [298]')
	assertTrue (os.date ('%B', time) == 'December', 'os.date() did not return expected value when passed "%B" [299]')
	assertTrue (os.date ('%d', time) == '31', 'os.date() did not return expected value when passed "%d" [300]')
	assertTrue (os.date ('%H', time) == '12', 'os.date() did not return expected value when passed "%H" [301]')
	assertTrue (os.date ('%I', time) == '12', 'os.date() did not return expected value when passed "%I" [302]')
	assertTrue (os.date ('%j', time) == '365', 'os.date() did not return expected value when passed "%j" [303]')
	assertTrue (os.date ('%m', time) == '12', 'os.date() did not return expected value when passed "%m" [304]')
	assertTrue (os.date ('%M', time) == '00', 'os.date() did not return expected value when passed "%M" [305]')
	assertTrue (os.date ('%p', time) == 'PM', 'os.date() did not return expected value when passed "%p" [306]')
	assertTrue (os.date ('%S', time) == '00', 'os.date() did not return expected value when passed "%S" [307]')
	assertTrue (os.date ('%U', time) == '52', 'os.date() did not return expected value when passed "%U" [308]')
	assertTrue (os.date ('%w', time) == '5', 'os.date() did not return expected value when passed "%w" [309]')
	assertTrue (os.date ('%W', time) == '52', 'os.date() did not return expected value when passed "%W" [310]')
	assertTrue (os.date ('%x', time) == '12/31/99', 'os.date() did not return expected value when passed "%x" [311]')
	assertTrue (os.date ('%X', time) == '12:00:00', 'os.date() did not return expected value when passed "%X" [312]')
	assertTrue (os.date ('%y', time) == '99', 'os.date() did not return expected value when passed "%y" [313]')
	assertTrue (os.date ('%Y', time) == '1999', 'os.date() did not return expected value when passed "%Y" [314]')
	assertTrue (os.date ('%Z', time) == 'GMT', 'os.date() did not return expected value when passed "%Z" [315]')
	assertTrue (os.date ('%%', time) == '%', 'os.date() did not return expected value when passed "%%" [316]')
	assertTrue (os.date ('!%a', time) == 'Fri', 'os.date() did not return expected value when passed "!%a" [317]')
	assertTrue (os.date ('!%A', time) == 'Friday', 'os.date() did not return expected value when passed "!%A" [318]')
	assertTrue (os.date ('!%b', time) == 'Dec', 'os.date() did not return expected value when passed "!%b" [319]')
	assertTrue (os.date ('!%B', time) == 'December', 'os.date() did not return expected value when passed "!%B" [320]')
	assertTrue (os.date ('!%d', time) == '31', 'os.date() did not return expected value when passed "!%d" [321]')
	assertTrue (os.date ('!%H', time) == '12', 'os.date() did not return expected value when passed "!%H" [322]')
	assertTrue (os.date ('!%I', time) == '12', 'os.date() did not return expected value when passed "!%I" [323]')
	assertTrue (os.date ('!%j', time) == '365', 'os.date() did not return expected value when passed "!%j" [324]')
	assertTrue (os.date ('!%m', time) == '12', 'os.date() did not return expected value when passed "!%m" [325]')
	assertTrue (os.date ('!%M', time) == '00', 'os.date() did not return expected value when passed "!%M" [326]')
	assertTrue (os.date ('!%p', time) == 'PM', 'os.date() did not return expected value when passed "!%p" [327]')
	assertTrue (os.date ('!%S', time) == '00', 'os.date() did not return expected value when passed "!%S" [328]')
	assertTrue (os.date ('!%U', time) == '52', 'os.date() did not return expected value when passed "!%U" [329]')
	assertTrue (os.date ('!%w', time) == '5', 'os.date() did not return expected value when passed "!%w" [330]')
	assertTrue (os.date ('!%W', time) == '52', 'os.date() did not return expected value when passed "!%W" [331]')
	assertTrue (os.date ('!%x', time) == '12/31/99', 'os.date() did not return expected value when passed "!%x" [332]')
	assertTrue (os.date ('!%X', time) == '12:00:00', 'os.date() did not return expected value when passed "!%X" [333]')
	assertTrue (os.date ('!%y', time) == '99', 'os.date() did not return expected value when passed "!%y" [334]')
	assertTrue (os.date ('!%Y', time) == '1999', 'os.date() did not return expected value when passed "!%Y" [335]')
	assertTrue (os.date ('!%Z', time) == 'UTC', 'os.date() did not return expected value when passed "!%Z" [336]')
	assertTrue (os.date ('*t', time).hour == 12, 'os.date() did not return expected value when passed "*t" [337]')
	assertTrue (os.date ('*t', time).min == 0, 'os.date() did not return expected value when passed "*t" [338]')
	assertTrue (os.date ('*t', time).wday == 6, 'os.date() did not return expected value when passed "*t" [339]')
	assertTrue (os.date ('*t', time).day == 31, 'os.date() did not return expected value when passed "*t" [340]')
	assertTrue (os.date ('*t', time).month == 12, 'os.date() did not return expected value when passed "*t" [341]')
	assertTrue (os.date ('*t', time).year == 1999, 'os.date() did not return expected value when passed "*t" [342]')
	assertTrue (os.date ('*t', time).sec == 0, 'os.date() did not return expected value when passed "*t" [343]')
	assertTrue (os.date ('*t', time).yday == 365, 'os.date() did not return expected value when passed "*t" [344]')
	assertTrue (os.date ('*t', time).isdst == false, 'os.date() did not return expected value when passed "*t" [345]')
	assertTrue (os.date ('!*t', time).hour == 12, 'os.date() did not return expected value when passed "!*t" [346]')
	assertTrue (os.date ('!*t', time).min == 0, 'os.date() did not return expected value when passed "!*t" [347]')
	assertTrue (os.date ('!*t', time).wday == 6, 'os.date() did not return expected value when passed "!*t" [348]')
	assertTrue (os.date ('!*t', time).day == 31, 'os.date() did not return expected value when passed "!*t" [349]')
	assertTrue (os.date ('!*t', time).month == 12, 'os.date() did not return expected value when passed "!*t" [350]')
	assertTrue (os.date ('!*t', time).year == 1999, 'os.date() did not return expected value when passed "!*t" [351]')
	assertTrue (os.date ('!*t', time).sec == 0, 'os.date() did not return expected value when passed "!*t" [352]')
	assertTrue (os.date ('!*t', time).yday == 365, 'os.date() did not return expected value when passed "!*t" [353]')
	assertTrue (os.date ('!*t', time).isdst == false, 'os.date() did not return expected value when passed "!*t" [354]')

	local time = 946688400

	assertTrue (os.date ('%a', time) == 'Sat', 'os.date() did not return expected value when passed "%a" [355]')
	assertTrue (os.date ('%A', time) == 'Saturday', 'os.date() did not return expected value when passed "%A" [356]')
	assertTrue (os.date ('%b', time) == 'Jan', 'os.date() did not return expected value when passed "%b" [357]')
	assertTrue (os.date ('%B', time) == 'January', 'os.date() did not return expected value when passed "%B" [358]')
	assertTrue (os.date ('%d', time) == '01', 'os.date() did not return expected value when passed "%d" [359]')
	assertTrue (os.date ('%H', time) == '01', 'os.date() did not return expected value when passed "%H" [360]')
	assertTrue (os.date ('%I', time) == '01', 'os.date() did not return expected value when passed "%I" [361]')
	assertTrue (os.date ('%j', time) == '001', 'os.date() did not return expected value when passed "%j" [362]')
	assertTrue (os.date ('%m', time) == '01', 'os.date() did not return expected value when passed "%m" [363]')
	assertTrue (os.date ('%M', time) == '00', 'os.date() did not return expected value when passed "%M" [364]')
	assertTrue (os.date ('%p', time) == 'AM', 'os.date() did not return expected value when passed "%p" [365]')
	assertTrue (os.date ('%S', time) == '00', 'os.date() did not return expected value when passed "%S" [366]')
	assertTrue (os.date ('%U', time) == '00', 'os.date() did not return expected value when passed "%U" [367]')
	assertTrue (os.date ('%w', time) == '6', 'os.date() did not return expected value when passed "%w" [368]')
	assertTrue (os.date ('%W', time) == '00', 'os.date() did not return expected value when passed "%W" [369]')
	assertTrue (os.date ('%x', time) == '01/01/00', 'os.date() did not return expected value when passed "%x" [370]')
	assertTrue (os.date ('%X', time) == '01:00:00', 'os.date() did not return expected value when passed "%X" [371]')
	assertTrue (os.date ('%y', time) == '00', 'os.date() did not return expected value when passed "%y" [372]')
	assertTrue (os.date ('%Y', time) == '2000', 'os.date() did not return expected value when passed "%Y" [373]')
	assertTrue (os.date ('%Z', time) == 'GMT', 'os.date() did not return expected value when passed "%Z" [374]')
	assertTrue (os.date ('%%', time) == '%', 'os.date() did not return expected value when passed "%%" [375]')
	assertTrue (os.date ('!%a', time) == 'Sat', 'os.date() did not return expected value when passed "!%a" [376]')
	assertTrue (os.date ('!%A', time) == 'Saturday', 'os.date() did not return expected value when passed "!%A" [377]')
	assertTrue (os.date ('!%b', time) == 'Jan', 'os.date() did not return expected value when passed "!%b" [378]')
	assertTrue (os.date ('!%B', time) == 'January', 'os.date() did not return expected value when passed "!%B" [379]')
	assertTrue (os.date ('!%d', time) == '01', 'os.date() did not return expected value when passed "!%d" [380]')
	assertTrue (os.date ('!%H', time) == '01', 'os.date() did not return expected value when passed "!%H" [381]')
	assertTrue (os.date ('!%I', time) == '01', 'os.date() did not return expected value when passed "!%I" [382]')
	assertTrue (os.date ('!%j', time) == '001', 'os.date() did not return expected value when passed "!%j" [383]')
	assertTrue (os.date ('!%m', time) == '01', 'os.date() did not return expected value when passed "!%m" [384]')
	assertTrue (os.date ('!%M', time) == '00', 'os.date() did not return expected value when passed "!%M" [385]')
	assertTrue (os.date ('!%p', time) == 'AM', 'os.date() did not return expected value when passed "!%p" [386]')
	assertTrue (os.date ('!%S', time) == '00', 'os.date() did not return expected value when passed "!%S" [387]')
	assertTrue (os.date ('!%U', time) == '00', 'os.date() did not return expected value when passed "!%U" [388]')
	assertTrue (os.date ('!%w', time) == '6', 'os.date() did not return expected value when passed "!%w" [389]')
	assertTrue (os.date ('!%W', time) == '00', 'os.date() did not return expected value when passed "!%W" [390]')
	assertTrue (os.date ('!%x', time) == '01/01/00', 'os.date() did not return expected value when passed "!%x" [391]')
	assertTrue (os.date ('!%X', time) == '01:00:00', 'os.date() did not return expected value when passed "!%X" [392]')
	assertTrue (os.date ('!%y', time) == '00', 'os.date() did not return expected value when passed "!%y" [393]')
	assertTrue (os.date ('!%Y', time) == '2000', 'os.date() did not return expected value when passed "!%Y" [394]')
	assertTrue (os.date ('!%Z', time) == 'UTC', 'os.date() did not return expected value when passed "!%Z" [395]')
	assertTrue (os.date ('*t', time).hour == 1, 'os.date() did not return expected value when passed "*t" [396]')
	assertTrue (os.date ('*t', time).min == 0, 'os.date() did not return expected value when passed "*t" [397]')
	assertTrue (os.date ('*t', time).wday == 7, 'os.date() did not return expected value when passed "*t" [398]')
	assertTrue (os.date ('*t', time).day == 1, 'os.date() did not return expected value when passed "*t" [399]')
	assertTrue (os.date ('*t', time).month == 1, 'os.date() did not return expected value when passed "*t" [400]')
	assertTrue (os.date ('*t', time).year == 2000, 'os.date() did not return expected value when passed "*t" [401]')
	assertTrue (os.date ('*t', time).sec == 0, 'os.date() did not return expected value when passed "*t" [402]')
	assertTrue (os.date ('*t', time).yday == 1, 'os.date() did not return expected value when passed "*t" [403]')
	assertTrue (os.date ('*t', time).isdst == false, 'os.date() did not return expected value when passed "*t" [404]')
	assertTrue (os.date ('!*t', time).hour == 1, 'os.date() did not return expected value when passed "!*t" [405]')
	assertTrue (os.date ('!*t', time).min == 0, 'os.date() did not return expected value when passed "!*t" [406]')
	assertTrue (os.date ('!*t', time).wday == 7, 'os.date() did not return expected value when passed "!*t" [407]')
	assertTrue (os.date ('!*t', time).day == 1, 'os.date() did not return expected value when passed "!*t" [408]')
	assertTrue (os.date ('!*t', time).month == 1, 'os.date() did not return expected value when passed "!*t" [409]')
	assertTrue (os.date ('!*t', time).year == 2000, 'os.date() did not return expected value when passed "!*t" [410]')
	assertTrue (os.date ('!*t', time).sec == 0, 'os.date() did not return expected value when passed "!*t" [411]')
	assertTrue (os.date ('!*t', time).yday == 1, 'os.date() did not return expected value when passed "!*t" [412]')
	assertTrue (os.date ('!*t', time).isdst == false, 'os.date() did not return expected value when passed "!*t" [413]')

	local time = 949370400

	assertTrue (os.date ('%a', time) == 'Tue', 'os.date() did not return expected value when passed "%a" [414]')
	assertTrue (os.date ('%A', time) == 'Tuesday', 'os.date() did not return expected value when passed "%A" [415]')
	assertTrue (os.date ('%b', time) == 'Feb', 'os.date() did not return expected value when passed "%b" [416]')
	assertTrue (os.date ('%B', time) == 'February', 'os.date() did not return expected value when passed "%B" [417]')
	assertTrue (os.date ('%d', time) == '01', 'os.date() did not return expected value when passed "%d" [418]')
	assertTrue (os.date ('%H', time) == '02', 'os.date() did not return expected value when passed "%H" [419]')
	assertTrue (os.date ('%I', time) == '02', 'os.date() did not return expected value when passed "%I" [420]')
	assertTrue (os.date ('%j', time) == '032', 'os.date() did not return expected value when passed "%j" [421]')
	assertTrue (os.date ('%m', time) == '02', 'os.date() did not return expected value when passed "%m" [422]')
	assertTrue (os.date ('%M', time) == '00', 'os.date() did not return expected value when passed "%M" [423]')
	assertTrue (os.date ('%p', time) == 'AM', 'os.date() did not return expected value when passed "%p" [424]')
	assertTrue (os.date ('%S', time) == '00', 'os.date() did not return expected value when passed "%S" [425]')
	assertTrue (os.date ('%U', time) == '05', 'os.date() did not return expected value when passed "%U" [426]')
	assertTrue (os.date ('%w', time) == '2', 'os.date() did not return expected value when passed "%w" [427]')
	assertTrue (os.date ('%W', time) == '05', 'os.date() did not return expected value when passed "%W" [428]')
	assertTrue (os.date ('%x', time) == '02/01/00', 'os.date() did not return expected value when passed "%x" [429]')
	assertTrue (os.date ('%X', time) == '02:00:00', 'os.date() did not return expected value when passed "%X" [430]')
	assertTrue (os.date ('%y', time) == '00', 'os.date() did not return expected value when passed "%y" [431]')
	assertTrue (os.date ('%Y', time) == '2000', 'os.date() did not return expected value when passed "%Y" [432]')
	assertTrue (os.date ('%Z', time) == 'GMT', 'os.date() did not return expected value when passed "%Z" [433]')
	assertTrue (os.date ('%%', time) == '%', 'os.date() did not return expected value when passed "%%" [434]')
	assertTrue (os.date ('!%a', time) == 'Tue', 'os.date() did not return expected value when passed "!%a" [435]')
	assertTrue (os.date ('!%A', time) == 'Tuesday', 'os.date() did not return expected value when passed "!%A" [436]')
	assertTrue (os.date ('!%b', time) == 'Feb', 'os.date() did not return expected value when passed "!%b" [437]')
	assertTrue (os.date ('!%B', time) == 'February', 'os.date() did not return expected value when passed "!%B" [438]')
	assertTrue (os.date ('!%d', time) == '01', 'os.date() did not return expected value when passed "!%d" [439]')
	assertTrue (os.date ('!%H', time) == '02', 'os.date() did not return expected value when passed "!%H" [440]')
	assertTrue (os.date ('!%I', time) == '02', 'os.date() did not return expected value when passed "!%I" [441]')
	assertTrue (os.date ('!%j', time) == '032', 'os.date() did not return expected value when passed "!%j" [442]')
	assertTrue (os.date ('!%m', time) == '02', 'os.date() did not return expected value when passed "!%m" [443]')
	assertTrue (os.date ('!%M', time) == '00', 'os.date() did not return expected value when passed "!%M" [444]')
	assertTrue (os.date ('!%p', time) == 'AM', 'os.date() did not return expected value when passed "!%p" [445]')
	assertTrue (os.date ('!%S', time) == '00', 'os.date() did not return expected value when passed "!%S" [446]')
	assertTrue (os.date ('!%U', time) == '05', 'os.date() did not return expected value when passed "!%U" [447]')
	assertTrue (os.date ('!%w', time) == '2', 'os.date() did not return expected value when passed "!%w" [448]')
	assertTrue (os.date ('!%W', time) == '05', 'os.date() did not return expected value when passed "!%W" [449]')
	assertTrue (os.date ('!%x', time) == '02/01/00', 'os.date() did not return expected value when passed "!%x" [450]')
	assertTrue (os.date ('!%X', time) == '02:00:00', 'os.date() did not return expected value when passed "!%X" [451]')
	assertTrue (os.date ('!%y', time) == '00', 'os.date() did not return expected value when passed "!%y" [452]')
	assertTrue (os.date ('!%Y', time) == '2000', 'os.date() did not return expected value when passed "!%Y" [453]')
	assertTrue (os.date ('!%Z', time) == 'UTC', 'os.date() did not return expected value when passed "!%Z" [454]')
	assertTrue (os.date ('*t', time).hour == 2, 'os.date() did not return expected value when passed "*t" [455]')
	assertTrue (os.date ('*t', time).min == 0, 'os.date() did not return expected value when passed "*t" [456]')
	assertTrue (os.date ('*t', time).wday == 3, 'os.date() did not return expected value when passed "*t" [457]')
	assertTrue (os.date ('*t', time).day == 1, 'os.date() did not return expected value when passed "*t" [458]')
	assertTrue (os.date ('*t', time).month == 2, 'os.date() did not return expected value when passed "*t" [459]')
	assertTrue (os.date ('*t', time).year == 2000, 'os.date() did not return expected value when passed "*t" [460]')
	assertTrue (os.date ('*t', time).sec == 0, 'os.date() did not return expected value when passed "*t" [461]')
	assertTrue (os.date ('*t', time).yday == 32, 'os.date() did not return expected value when passed "*t" [462]')
	assertTrue (os.date ('*t', time).isdst == false, 'os.date() did not return expected value when passed "*t" [463]')
	assertTrue (os.date ('!*t', time).hour == 2, 'os.date() did not return expected value when passed "!*t" [464]')
	assertTrue (os.date ('!*t', time).min == 0, 'os.date() did not return expected value when passed "!*t" [465]')
	assertTrue (os.date ('!*t', time).wday == 3, 'os.date() did not return expected value when passed "!*t" [466]')
	assertTrue (os.date ('!*t', time).day == 1, 'os.date() did not return expected value when passed "!*t" [467]')
	assertTrue (os.date ('!*t', time).month == 2, 'os.date() did not return expected value when passed "!*t" [468]')
	assertTrue (os.date ('!*t', time).year == 2000, 'os.date() did not return expected value when passed "!*t" [469]')
	assertTrue (os.date ('!*t', time).sec == 0, 'os.date() did not return expected value when passed "!*t" [470]')
	assertTrue (os.date ('!*t', time).yday == 32, 'os.date() did not return expected value when passed "!*t" [471]')
	assertTrue (os.date ('!*t', time).isdst == false, 'os.date() did not return expected value when passed "!*t" [472]')

	local time = 951703200

	assertTrue (os.date ('%a', time) == 'Mon', 'os.date() did not return expected value when passed "%a" [473]')
	assertTrue (os.date ('%A', time) == 'Monday', 'os.date() did not return expected value when passed "%A" [474]')
	assertTrue (os.date ('%b', time) == 'Feb', 'os.date() did not return expected value when passed "%b" [475]')
	assertTrue (os.date ('%B', time) == 'February', 'os.date() did not return expected value when passed "%B" [476]')
	assertTrue (os.date ('%d', time) == '28', 'os.date() did not return expected value when passed "%d" [477]')
	assertTrue (os.date ('%H', time) == '02', 'os.date() did not return expected value when passed "%H" [478]')
	assertTrue (os.date ('%I', time) == '02', 'os.date() did not return expected value when passed "%I" [479]')
	assertTrue (os.date ('%j', time) == '059', 'os.date() did not return expected value when passed "%j" [480]')
	assertTrue (os.date ('%m', time) == '02', 'os.date() did not return expected value when passed "%m" [481]')
	assertTrue (os.date ('%M', time) == '00', 'os.date() did not return expected value when passed "%M" [482]')
	assertTrue (os.date ('%p', time) == 'AM', 'os.date() did not return expected value when passed "%p" [483]')
	assertTrue (os.date ('%S', time) == '00', 'os.date() did not return expected value when passed "%S" [484]')
	assertTrue (os.date ('%U', time) == '09', 'os.date() did not return expected value when passed "%U" [485]')
	assertTrue (os.date ('%w', time) == '1', 'os.date() did not return expected value when passed "%w" [486]')
	assertTrue (os.date ('%W', time) == '09', 'os.date() did not return expected value when passed "%W" [487]')
	assertTrue (os.date ('%x', time) == '02/28/00', 'os.date() did not return expected value when passed "%x" [488]')
	assertTrue (os.date ('%X', time) == '02:00:00', 'os.date() did not return expected value when passed "%X" [489]')
	assertTrue (os.date ('%y', time) == '00', 'os.date() did not return expected value when passed "%y" [490]')
	assertTrue (os.date ('%Y', time) == '2000', 'os.date() did not return expected value when passed "%Y" [491]')
	assertTrue (os.date ('%Z', time) == 'GMT', 'os.date() did not return expected value when passed "%Z" [492]')
	assertTrue (os.date ('%%', time) == '%', 'os.date() did not return expected value when passed "%%" [493]')
	assertTrue (os.date ('!%a', time) == 'Mon', 'os.date() did not return expected value when passed "!%a" [494]')
	assertTrue (os.date ('!%A', time) == 'Monday', 'os.date() did not return expected value when passed "!%A" [495]')
	assertTrue (os.date ('!%b', time) == 'Feb', 'os.date() did not return expected value when passed "!%b" [496]')
	assertTrue (os.date ('!%B', time) == 'February', 'os.date() did not return expected value when passed "!%B" [497]')
	assertTrue (os.date ('!%d', time) == '28', 'os.date() did not return expected value when passed "!%d" [498]')
	assertTrue (os.date ('!%H', time) == '02', 'os.date() did not return expected value when passed "!%H" [499]')
	assertTrue (os.date ('!%I', time) == '02', 'os.date() did not return expected value when passed "!%I" [500]')
	assertTrue (os.date ('!%j', time) == '059', 'os.date() did not return expected value when passed "!%j" [501]')
	assertTrue (os.date ('!%m', time) == '02', 'os.date() did not return expected value when passed "!%m" [502]')
	assertTrue (os.date ('!%M', time) == '00', 'os.date() did not return expected value when passed "!%M" [503]')
	assertTrue (os.date ('!%p', time) == 'AM', 'os.date() did not return expected value when passed "!%p" [504]')
	assertTrue (os.date ('!%S', time) == '00', 'os.date() did not return expected value when passed "!%S" [505]')
	assertTrue (os.date ('!%U', time) == '09', 'os.date() did not return expected value when passed "!%U" [506]')
	assertTrue (os.date ('!%w', time) == '1', 'os.date() did not return expected value when passed "!%w" [507]')
	assertTrue (os.date ('!%W', time) == '09', 'os.date() did not return expected value when passed "!%W" [508]')
	assertTrue (os.date ('!%x', time) == '02/28/00', 'os.date() did not return expected value when passed "!%x" [509]')
	assertTrue (os.date ('!%X', time) == '02:00:00', 'os.date() did not return expected value when passed "!%X" [510]')
	assertTrue (os.date ('!%y', time) == '00', 'os.date() did not return expected value when passed "!%y" [511]')
	assertTrue (os.date ('!%Y', time) == '2000', 'os.date() did not return expected value when passed "!%Y" [512]')
	assertTrue (os.date ('!%Z', time) == 'UTC', 'os.date() did not return expected value when passed "!%Z" [513]')
	assertTrue (os.date ('*t', time).hour == 2, 'os.date() did not return expected value when passed "*t" [514]')
	assertTrue (os.date ('*t', time).min == 0, 'os.date() did not return expected value when passed "*t" [515]')
	assertTrue (os.date ('*t', time).wday == 2, 'os.date() did not return expected value when passed "*t" [516]')
	assertTrue (os.date ('*t', time).day == 28, 'os.date() did not return expected value when passed "*t" [517]')
	assertTrue (os.date ('*t', time).month == 2, 'os.date() did not return expected value when passed "*t" [518]')
	assertTrue (os.date ('*t', time).year == 2000, 'os.date() did not return expected value when passed "*t" [519]')
	assertTrue (os.date ('*t', time).sec == 0, 'os.date() did not return expected value when passed "*t" [520]')
	assertTrue (os.date ('*t', time).yday == 59, 'os.date() did not return expected value when passed "*t" [521]')
	assertTrue (os.date ('*t', time).isdst == false, 'os.date() did not return expected value when passed "*t" [522]')
	assertTrue (os.date ('!*t', time).hour == 2, 'os.date() did not return expected value when passed "!*t" [523]')
	assertTrue (os.date ('!*t', time).min == 0, 'os.date() did not return expected value when passed "!*t" [524]')
	assertTrue (os.date ('!*t', time).wday == 2, 'os.date() did not return expected value when passed "!*t" [525]')
	assertTrue (os.date ('!*t', time).day == 28, 'os.date() did not return expected value when passed "!*t" [526]')
	assertTrue (os.date ('!*t', time).month == 2, 'os.date() did not return expected value when passed "!*t" [527]')
	assertTrue (os.date ('!*t', time).year == 2000, 'os.date() did not return expected value when passed "!*t" [528]')
	assertTrue (os.date ('!*t', time).sec == 0, 'os.date() did not return expected value when passed "!*t" [529]')
	assertTrue (os.date ('!*t', time).yday == 59, 'os.date() did not return expected value when passed "!*t" [530]')
	assertTrue (os.date ('!*t', time).isdst == false, 'os.date() did not return expected value when passed "!*t" [531]')

	local time = 951789600

	assertTrue (os.date ('%a', time) == 'Tue', 'os.date() did not return expected value when passed "%a" [532]')
	assertTrue (os.date ('%A', time) == 'Tuesday', 'os.date() did not return expected value when passed "%A" [533]')
	assertTrue (os.date ('%b', time) == 'Feb', 'os.date() did not return expected value when passed "%b" [534]')
	assertTrue (os.date ('%B', time) == 'February', 'os.date() did not return expected value when passed "%B" [535]')
	assertTrue (os.date ('%d', time) == '29', 'os.date() did not return expected value when passed "%d" [536]')
	assertTrue (os.date ('%H', time) == '02', 'os.date() did not return expected value when passed "%H" [537]')
	assertTrue (os.date ('%I', time) == '02', 'os.date() did not return expected value when passed "%I" [538]')
	assertTrue (os.date ('%j', time) == '060', 'os.date() did not return expected value when passed "%j" [539]')
	assertTrue (os.date ('%m', time) == '02', 'os.date() did not return expected value when passed "%m" [540]')
	assertTrue (os.date ('%M', time) == '00', 'os.date() did not return expected value when passed "%M" [541]')
	assertTrue (os.date ('%p', time) == 'AM', 'os.date() did not return expected value when passed "%p" [542]')
	assertTrue (os.date ('%S', time) == '00', 'os.date() did not return expected value when passed "%S" [543]')
	assertTrue (os.date ('%U', time) == '09', 'os.date() did not return expected value when passed "%U" [544]')
	assertTrue (os.date ('%w', time) == '2', 'os.date() did not return expected value when passed "%w" [545]')
	assertTrue (os.date ('%W', time) == '09', 'os.date() did not return expected value when passed "%W" [546]')
	assertTrue (os.date ('%x', time) == '02/29/00', 'os.date() did not return expected value when passed "%x" [547]')
	assertTrue (os.date ('%X', time) == '02:00:00', 'os.date() did not return expected value when passed "%X" [548]')
	assertTrue (os.date ('%y', time) == '00', 'os.date() did not return expected value when passed "%y" [549]')
	assertTrue (os.date ('%Y', time) == '2000', 'os.date() did not return expected value when passed "%Y" [550]')
	assertTrue (os.date ('%Z', time) == 'GMT', 'os.date() did not return expected value when passed "%Z" [551]')
	assertTrue (os.date ('%%', time) == '%', 'os.date() did not return expected value when passed "%%" [552]')
	assertTrue (os.date ('!%a', time) == 'Tue', 'os.date() did not return expected value when passed "!%a" [553]')
	assertTrue (os.date ('!%A', time) == 'Tuesday', 'os.date() did not return expected value when passed "!%A" [554]')
	assertTrue (os.date ('!%b', time) == 'Feb', 'os.date() did not return expected value when passed "!%b" [555]')
	assertTrue (os.date ('!%B', time) == 'February', 'os.date() did not return expected value when passed "!%B" [556]')
	assertTrue (os.date ('!%d', time) == '29', 'os.date() did not return expected value when passed "!%d" [557]')
	assertTrue (os.date ('!%H', time) == '02', 'os.date() did not return expected value when passed "!%H" [558]')
	assertTrue (os.date ('!%I', time) == '02', 'os.date() did not return expected value when passed "!%I" [559]')
	assertTrue (os.date ('!%j', time) == '060', 'os.date() did not return expected value when passed "!%j" [560]')
	assertTrue (os.date ('!%m', time) == '02', 'os.date() did not return expected value when passed "!%m" [561]')
	assertTrue (os.date ('!%M', time) == '00', 'os.date() did not return expected value when passed "!%M" [562]')
	assertTrue (os.date ('!%p', time) == 'AM', 'os.date() did not return expected value when passed "!%p" [563]')
	assertTrue (os.date ('!%S', time) == '00', 'os.date() did not return expected value when passed "!%S" [564]')
	assertTrue (os.date ('!%U', time) == '09', 'os.date() did not return expected value when passed "!%U" [565]')
	assertTrue (os.date ('!%w', time) == '2', 'os.date() did not return expected value when passed "!%w" [566]')
	assertTrue (os.date ('!%W', time) == '09', 'os.date() did not return expected value when passed "!%W" [567]')
	assertTrue (os.date ('!%x', time) == '02/29/00', 'os.date() did not return expected value when passed "!%x" [568]')
	assertTrue (os.date ('!%X', time) == '02:00:00', 'os.date() did not return expected value when passed "!%X" [569]')
	assertTrue (os.date ('!%y', time) == '00', 'os.date() did not return expected value when passed "!%y" [570]')
	assertTrue (os.date ('!%Y', time) == '2000', 'os.date() did not return expected value when passed "!%Y" [571]')
	assertTrue (os.date ('!%Z', time) == 'UTC', 'os.date() did not return expected value when passed "!%Z" [572]')
	assertTrue (os.date ('*t', time).hour == 2, 'os.date() did not return expected value when passed "*t" [573]')
	assertTrue (os.date ('*t', time).min == 0, 'os.date() did not return expected value when passed "*t" [574]')
	assertTrue (os.date ('*t', time).wday == 3, 'os.date() did not return expected value when passed "*t" [575]')
	assertTrue (os.date ('*t', time).day == 29, 'os.date() did not return expected value when passed "*t" [576]')
	assertTrue (os.date ('*t', time).month == 2, 'os.date() did not return expected value when passed "*t" [577]')
	assertTrue (os.date ('*t', time).year == 2000, 'os.date() did not return expected value when passed "*t" [578]')
	assertTrue (os.date ('*t', time).sec == 0, 'os.date() did not return expected value when passed "*t" [579]')
	assertTrue (os.date ('*t', time).yday == 60, 'os.date() did not return expected value when passed "*t" [580]')
	assertTrue (os.date ('*t', time).isdst == false, 'os.date() did not return expected value when passed "*t" [581]')
	assertTrue (os.date ('!*t', time).hour == 2, 'os.date() did not return expected value when passed "!*t" [582]')
	assertTrue (os.date ('!*t', time).min == 0, 'os.date() did not return expected value when passed "!*t" [583]')
	assertTrue (os.date ('!*t', time).wday == 3, 'os.date() did not return expected value when passed "!*t" [584]')
	assertTrue (os.date ('!*t', time).day == 29, 'os.date() did not return expected value when passed "!*t" [585]')
	assertTrue (os.date ('!*t', time).month == 2, 'os.date() did not return expected value when passed "!*t" [586]')
	assertTrue (os.date ('!*t', time).year == 2000, 'os.date() did not return expected value when passed "!*t" [587]')
	assertTrue (os.date ('!*t', time).sec == 0, 'os.date() did not return expected value when passed "!*t" [588]')
	assertTrue (os.date ('!*t', time).yday == 60, 'os.date() did not return expected value when passed "!*t" [589]')
	assertTrue (os.date ('!*t', time).isdst == false, 'os.date() did not return expected value when passed "!*t" [590]')

	local time = 951879600

	assertTrue (os.date ('%a', time) == 'Wed', 'os.date() did not return expected value when passed "%a" [591]')
	assertTrue (os.date ('%A', time) == 'Wednesday', 'os.date() did not return expected value when passed "%A" [592]')
	assertTrue (os.date ('%b', time) == 'Mar', 'os.date() did not return expected value when passed "%b" [593]')
	assertTrue (os.date ('%B', time) == 'March', 'os.date() did not return expected value when passed "%B" [594]')
	assertTrue (os.date ('%d', time) == '01', 'os.date() did not return expected value when passed "%d" [595]')
	assertTrue (os.date ('%H', time) == '03', 'os.date() did not return expected value when passed "%H" [596]')
	assertTrue (os.date ('%I', time) == '03', 'os.date() did not return expected value when passed "%I" [597]')
	assertTrue (os.date ('%j', time) == '061', 'os.date() did not return expected value when passed "%j" [598]')
	assertTrue (os.date ('%m', time) == '03', 'os.date() did not return expected value when passed "%m" [599]')
	assertTrue (os.date ('%M', time) == '00', 'os.date() did not return expected value when passed "%M" [600]')
	assertTrue (os.date ('%p', time) == 'AM', 'os.date() did not return expected value when passed "%p" [601]')
	assertTrue (os.date ('%S', time) == '00', 'os.date() did not return expected value when passed "%S" [602]')
	assertTrue (os.date ('%U', time) == '09', 'os.date() did not return expected value when passed "%U" [603]')
	assertTrue (os.date ('%w', time) == '3', 'os.date() did not return expected value when passed "%w" [604]')
	assertTrue (os.date ('%W', time) == '09', 'os.date() did not return expected value when passed "%W" [605]')
	assertTrue (os.date ('%x', time) == '03/01/00', 'os.date() did not return expected value when passed "%x" [606]')
	assertTrue (os.date ('%X', time) == '03:00:00', 'os.date() did not return expected value when passed "%X" [607]')
	assertTrue (os.date ('%y', time) == '00', 'os.date() did not return expected value when passed "%y" [608]')
	assertTrue (os.date ('%Y', time) == '2000', 'os.date() did not return expected value when passed "%Y" [609]')
	assertTrue (os.date ('%Z', time) == 'GMT', 'os.date() did not return expected value when passed "%Z" [610]')
	assertTrue (os.date ('%%', time) == '%', 'os.date() did not return expected value when passed "%%" [611]')
	assertTrue (os.date ('!%a', time) == 'Wed', 'os.date() did not return expected value when passed "!%a" [612]')
	assertTrue (os.date ('!%A', time) == 'Wednesday', 'os.date() did not return expected value when passed "!%A" [613]')
	assertTrue (os.date ('!%b', time) == 'Mar', 'os.date() did not return expected value when passed "!%b" [614]')
	assertTrue (os.date ('!%B', time) == 'March', 'os.date() did not return expected value when passed "!%B" [615]')
	assertTrue (os.date ('!%d', time) == '01', 'os.date() did not return expected value when passed "!%d" [616]')
	assertTrue (os.date ('!%H', time) == '03', 'os.date() did not return expected value when passed "!%H" [617]')
	assertTrue (os.date ('!%I', time) == '03', 'os.date() did not return expected value when passed "!%I" [618]')
	assertTrue (os.date ('!%j', time) == '061', 'os.date() did not return expected value when passed "!%j" [619]')
	assertTrue (os.date ('!%m', time) == '03', 'os.date() did not return expected value when passed "!%m" [620]')
	assertTrue (os.date ('!%M', time) == '00', 'os.date() did not return expected value when passed "!%M" [621]')
	assertTrue (os.date ('!%p', time) == 'AM', 'os.date() did not return expected value when passed "!%p" [622]')
	assertTrue (os.date ('!%S', time) == '00', 'os.date() did not return expected value when passed "!%S" [623]')
	assertTrue (os.date ('!%U', time) == '09', 'os.date() did not return expected value when passed "!%U" [624]')
	assertTrue (os.date ('!%w', time) == '3', 'os.date() did not return expected value when passed "!%w" [625]')
	assertTrue (os.date ('!%W', time) == '09', 'os.date() did not return expected value when passed "!%W" [626]')
	assertTrue (os.date ('!%x', time) == '03/01/00', 'os.date() did not return expected value when passed "!%x" [627]')
	assertTrue (os.date ('!%X', time) == '03:00:00', 'os.date() did not return expected value when passed "!%X" [628]')
	assertTrue (os.date ('!%y', time) == '00', 'os.date() did not return expected value when passed "!%y" [629]')
	assertTrue (os.date ('!%Y', time) == '2000', 'os.date() did not return expected value when passed "!%Y" [630]')
	assertTrue (os.date ('!%Z', time) == 'UTC', 'os.date() did not return expected value when passed "!%Z" [631]')
	assertTrue (os.date ('*t', time).hour == 3, 'os.date() did not return expected value when passed "*t" [632]')
	assertTrue (os.date ('*t', time).min == 0, 'os.date() did not return expected value when passed "*t" [633]')
	assertTrue (os.date ('*t', time).wday == 4, 'os.date() did not return expected value when passed "*t" [634]')
	assertTrue (os.date ('*t', time).day == 1, 'os.date() did not return expected value when passed "*t" [635]')
	assertTrue (os.date ('*t', time).month == 3, 'os.date() did not return expected value when passed "*t" [636]')
	assertTrue (os.date ('*t', time).year == 2000, 'os.date() did not return expected value when passed "*t" [637]')
	assertTrue (os.date ('*t', time).sec == 0, 'os.date() did not return expected value when passed "*t" [638]')
	assertTrue (os.date ('*t', time).yday == 61, 'os.date() did not return expected value when passed "*t" [639]')
	assertTrue (os.date ('*t', time).isdst == false, 'os.date() did not return expected value when passed "*t" [640]')
	assertTrue (os.date ('!*t', time).hour == 3, 'os.date() did not return expected value when passed "!*t" [641]')
	assertTrue (os.date ('!*t', time).min == 0, 'os.date() did not return expected value when passed "!*t" [642]')
	assertTrue (os.date ('!*t', time).wday == 4, 'os.date() did not return expected value when passed "!*t" [643]')
	assertTrue (os.date ('!*t', time).day == 1, 'os.date() did not return expected value when passed "!*t" [644]')
	assertTrue (os.date ('!*t', time).month == 3, 'os.date() did not return expected value when passed "!*t" [645]')
	assertTrue (os.date ('!*t', time).year == 2000, 'os.date() did not return expected value when passed "!*t" [646]')
	assertTrue (os.date ('!*t', time).sec == 0, 'os.date() did not return expected value when passed "!*t" [647]')
	assertTrue (os.date ('!*t', time).yday == 61, 'os.date() did not return expected value when passed "!*t" [648]')
	assertTrue (os.date ('!*t', time).isdst == false, 'os.date() did not return expected value when passed "!*t" [649]')

	local time = 978264000

	assertTrue (os.date ('%a', time) == 'Sun', 'os.date() did not return expected value when passed "%a" [650]')
	assertTrue (os.date ('%A', time) == 'Sunday', 'os.date() did not return expected value when passed "%A" [651]')
	assertTrue (os.date ('%b', time) == 'Dec', 'os.date() did not return expected value when passed "%b" [652]')
	assertTrue (os.date ('%B', time) == 'December', 'os.date() did not return expected value when passed "%B" [653]')
	assertTrue (os.date ('%d', time) == '31', 'os.date() did not return expected value when passed "%d" [654]')
	assertTrue (os.date ('%H', time) == '12', 'os.date() did not return expected value when passed "%H" [655]')
	assertTrue (os.date ('%I', time) == '12', 'os.date() did not return expected value when passed "%I" [656]')
	assertTrue (os.date ('%j', time) == '366', 'os.date() did not return expected value when passed "%j" [657]')
	assertTrue (os.date ('%m', time) == '12', 'os.date() did not return expected value when passed "%m" [658]')
	assertTrue (os.date ('%M', time) == '00', 'os.date() did not return expected value when passed "%M" [659]')
	assertTrue (os.date ('%p', time) == 'PM', 'os.date() did not return expected value when passed "%p" [660]')
	assertTrue (os.date ('%S', time) == '00', 'os.date() did not return expected value when passed "%S" [661]')
	assertTrue (os.date ('%U', time) == '53', 'os.date() did not return expected value when passed "%U" [662]')
	assertTrue (os.date ('%w', time) == '0', 'os.date() did not return expected value when passed "%w" [663]')
	assertTrue (os.date ('%W', time) == '52', 'os.date() did not return expected value when passed "%W" [664]')
	assertTrue (os.date ('%x', time) == '12/31/00', 'os.date() did not return expected value when passed "%x" [665]')
	assertTrue (os.date ('%X', time) == '12:00:00', 'os.date() did not return expected value when passed "%X" [666]')
	assertTrue (os.date ('%y', time) == '00', 'os.date() did not return expected value when passed "%y" [667]')
	assertTrue (os.date ('%Y', time) == '2000', 'os.date() did not return expected value when passed "%Y" [668]')
	assertTrue (os.date ('%Z', time) == 'GMT', 'os.date() did not return expected value when passed "%Z" [669]')
	assertTrue (os.date ('%%', time) == '%', 'os.date() did not return expected value when passed "%%" [670]')
	assertTrue (os.date ('!%a', time) == 'Sun', 'os.date() did not return expected value when passed "!%a" [671]')
	assertTrue (os.date ('!%A', time) == 'Sunday', 'os.date() did not return expected value when passed "!%A" [672]')
	assertTrue (os.date ('!%b', time) == 'Dec', 'os.date() did not return expected value when passed "!%b" [673]')
	assertTrue (os.date ('!%B', time) == 'December', 'os.date() did not return expected value when passed "!%B" [674]')
	assertTrue (os.date ('!%d', time) == '31', 'os.date() did not return expected value when passed "!%d" [675]')
	assertTrue (os.date ('!%H', time) == '12', 'os.date() did not return expected value when passed "!%H" [676]')
	assertTrue (os.date ('!%I', time) == '12', 'os.date() did not return expected value when passed "!%I" [677]')
	assertTrue (os.date ('!%j', time) == '366', 'os.date() did not return expected value when passed "!%j" [678]')
	assertTrue (os.date ('!%m', time) == '12', 'os.date() did not return expected value when passed "!%m" [679]')
	assertTrue (os.date ('!%M', time) == '00', 'os.date() did not return expected value when passed "!%M" [680]')
	assertTrue (os.date ('!%p', time) == 'PM', 'os.date() did not return expected value when passed "!%p" [681]')
	assertTrue (os.date ('!%S', time) == '00', 'os.date() did not return expected value when passed "!%S" [682]')
	assertTrue (os.date ('!%U', time) == '53', 'os.date() did not return expected value when passed "!%U" [683]')
	assertTrue (os.date ('!%w', time) == '0', 'os.date() did not return expected value when passed "!%w" [684]')
	assertTrue (os.date ('!%W', time) == '52', 'os.date() did not return expected value when passed "!%W" [685]')
	assertTrue (os.date ('!%x', time) == '12/31/00', 'os.date() did not return expected value when passed "!%x" [686]')
	assertTrue (os.date ('!%X', time) == '12:00:00', 'os.date() did not return expected value when passed "!%X" [687]')
	assertTrue (os.date ('!%y', time) == '00', 'os.date() did not return expected value when passed "!%y" [688]')
	assertTrue (os.date ('!%Y', time) == '2000', 'os.date() did not return expected value when passed "!%Y" [689]')
	assertTrue (os.date ('!%Z', time) == 'UTC', 'os.date() did not return expected value when passed "!%Z" [690]')
	assertTrue (os.date ('*t', time).hour == 12, 'os.date() did not return expected value when passed "*t" [691]')
	assertTrue (os.date ('*t', time).min == 0, 'os.date() did not return expected value when passed "*t" [692]')
	assertTrue (os.date ('*t', time).wday == 1, 'os.date() did not return expected value when passed "*t" [693]')
	assertTrue (os.date ('*t', time).day == 31, 'os.date() did not return expected value when passed "*t" [694]')
	assertTrue (os.date ('*t', time).month == 12, 'os.date() did not return expected value when passed "*t" [695]')
	assertTrue (os.date ('*t', time).year == 2000, 'os.date() did not return expected value when passed "*t" [696]')
	assertTrue (os.date ('*t', time).sec == 0, 'os.date() did not return expected value when passed "*t" [697]')
	assertTrue (os.date ('*t', time).yday == 366, 'os.date() did not return expected value when passed "*t" [698]')
	assertTrue (os.date ('*t', time).isdst == false, 'os.date() did not return expected value when passed "*t" [699]')
	assertTrue (os.date ('!*t', time).hour == 12, 'os.date() did not return expected value when passed "!*t" [700]')
	assertTrue (os.date ('!*t', time).min == 0, 'os.date() did not return expected value when passed "!*t" [701]')
	assertTrue (os.date ('!*t', time).wday == 1, 'os.date() did not return expected value when passed "!*t" [702]')
	assertTrue (os.date ('!*t', time).day == 31, 'os.date() did not return expected value when passed "!*t" [703]')
	assertTrue (os.date ('!*t', time).month == 12, 'os.date() did not return expected value when passed "!*t" [704]')
	assertTrue (os.date ('!*t', time).year == 2000, 'os.date() did not return expected value when passed "!*t" [705]')
	assertTrue (os.date ('!*t', time).sec == 0, 'os.date() did not return expected value when passed "!*t" [706]')
	assertTrue (os.date ('!*t', time).yday == 366, 'os.date() did not return expected value when passed "!*t" [707]')
	assertTrue (os.date ('!*t', time).isdst == false, 'os.date() did not return expected value when passed "!*t" [708]')

	local time = 1293843600

	assertTrue (os.date ('%a', time) == 'Sat', 'os.date() did not return expected value when passed "%a" [709]')
	assertTrue (os.date ('%A', time) == 'Saturday', 'os.date() did not return expected value when passed "%A" [710]')
	assertTrue (os.date ('%b', time) == 'Jan', 'os.date() did not return expected value when passed "%b" [711]')
	assertTrue (os.date ('%B', time) == 'January', 'os.date() did not return expected value when passed "%B" [712]')
	assertTrue (os.date ('%d', time) == '01', 'os.date() did not return expected value when passed "%d" [713]')
	assertTrue (os.date ('%H', time) == '01', 'os.date() did not return expected value when passed "%H" [714]')
	assertTrue (os.date ('%I', time) == '01', 'os.date() did not return expected value when passed "%I" [715]')
	assertTrue (os.date ('%j', time) == '001', 'os.date() did not return expected value when passed "%j" [716]')
	assertTrue (os.date ('%m', time) == '01', 'os.date() did not return expected value when passed "%m" [717]')
	assertTrue (os.date ('%M', time) == '00', 'os.date() did not return expected value when passed "%M" [718]')
	assertTrue (os.date ('%p', time) == 'AM', 'os.date() did not return expected value when passed "%p" [719]')
	assertTrue (os.date ('%S', time) == '00', 'os.date() did not return expected value when passed "%S" [720]')
	assertTrue (os.date ('%U', time) == '00', 'os.date() did not return expected value when passed "%U" [721]')
	assertTrue (os.date ('%w', time) == '6', 'os.date() did not return expected value when passed "%w" [722]')
	assertTrue (os.date ('%W', time) == '00', 'os.date() did not return expected value when passed "%W" [723]')
	assertTrue (os.date ('%x', time) == '01/01/11', 'os.date() did not return expected value when passed "%x" [724]')
	assertTrue (os.date ('%X', time) == '01:00:00', 'os.date() did not return expected value when passed "%X" [725]')
	assertTrue (os.date ('%y', time) == '11', 'os.date() did not return expected value when passed "%y" [726]')
	assertTrue (os.date ('%Y', time) == '2011', 'os.date() did not return expected value when passed "%Y" [727]')
	assertTrue (os.date ('%Z', time) == 'GMT', 'os.date() did not return expected value when passed "%Z" [728]')
	assertTrue (os.date ('%%', time) == '%', 'os.date() did not return expected value when passed "%%" [729]')
	assertTrue (os.date ('!%a', time) == 'Sat', 'os.date() did not return expected value when passed "!%a" [730]')
	assertTrue (os.date ('!%A', time) == 'Saturday', 'os.date() did not return expected value when passed "!%A" [731]')
	assertTrue (os.date ('!%b', time) == 'Jan', 'os.date() did not return expected value when passed "!%b" [732]')
	assertTrue (os.date ('!%B', time) == 'January', 'os.date() did not return expected value when passed "!%B" [733]')
	assertTrue (os.date ('!%d', time) == '01', 'os.date() did not return expected value when passed "!%d" [734]')
	assertTrue (os.date ('!%H', time) == '01', 'os.date() did not return expected value when passed "!%H" [735]')
	assertTrue (os.date ('!%I', time) == '01', 'os.date() did not return expected value when passed "!%I" [736]')
	assertTrue (os.date ('!%j', time) == '001', 'os.date() did not return expected value when passed "!%j" [737]')
	assertTrue (os.date ('!%m', time) == '01', 'os.date() did not return expected value when passed "!%m" [738]')
	assertTrue (os.date ('!%M', time) == '00', 'os.date() did not return expected value when passed "!%M" [739]')
	assertTrue (os.date ('!%p', time) == 'AM', 'os.date() did not return expected value when passed "!%p" [740]')
	assertTrue (os.date ('!%S', time) == '00', 'os.date() did not return expected value when passed "!%S" [741]')
	assertTrue (os.date ('!%U', time) == '00', 'os.date() did not return expected value when passed "!%U" [742]')
	assertTrue (os.date ('!%w', time) == '6', 'os.date() did not return expected value when passed "!%w" [743]')
	assertTrue (os.date ('!%W', time) == '00', 'os.date() did not return expected value when passed "!%W" [744]')
	assertTrue (os.date ('!%x', time) == '01/01/11', 'os.date() did not return expected value when passed "!%x" [745]')
	assertTrue (os.date ('!%X', time) == '01:00:00', 'os.date() did not return expected value when passed "!%X" [746]')
	assertTrue (os.date ('!%y', time) == '11', 'os.date() did not return expected value when passed "!%y" [747]')
	assertTrue (os.date ('!%Y', time) == '2011', 'os.date() did not return expected value when passed "!%Y" [748]')
	assertTrue (os.date ('!%Z', time) == 'UTC', 'os.date() did not return expected value when passed "!%Z" [749]')
	assertTrue (os.date ('*t', time).hour == 1, 'os.date() did not return expected value when passed "*t" [750]')
	assertTrue (os.date ('*t', time).min == 0, 'os.date() did not return expected value when passed "*t" [751]')
	assertTrue (os.date ('*t', time).wday == 7, 'os.date() did not return expected value when passed "*t" [752]')
	assertTrue (os.date ('*t', time).day == 1, 'os.date() did not return expected value when passed "*t" [753]')
	assertTrue (os.date ('*t', time).month == 1, 'os.date() did not return expected value when passed "*t" [754]')
	assertTrue (os.date ('*t', time).year == 2011, 'os.date() did not return expected value when passed "*t" [755]')
	assertTrue (os.date ('*t', time).sec == 0, 'os.date() did not return expected value when passed "*t" [756]')
	assertTrue (os.date ('*t', time).yday == 1, 'os.date() did not return expected value when passed "*t" [757]')
	assertTrue (os.date ('*t', time).isdst == false, 'os.date() did not return expected value when passed "*t" [758]')
	assertTrue (os.date ('!*t', time).hour == 1, 'os.date() did not return expected value when passed "!*t" [759]')
	assertTrue (os.date ('!*t', time).min == 0, 'os.date() did not return expected value when passed "!*t" [760]')
	assertTrue (os.date ('!*t', time).wday == 7, 'os.date() did not return expected value when passed "!*t" [761]')
	assertTrue (os.date ('!*t', time).day == 1, 'os.date() did not return expected value when passed "!*t" [762]')
	assertTrue (os.date ('!*t', time).month == 1, 'os.date() did not return expected value when passed "!*t" [763]')
	assertTrue (os.date ('!*t', time).year == 2011, 'os.date() did not return expected value when passed "!*t" [764]')
	assertTrue (os.date ('!*t', time).sec == 0, 'os.date() did not return expected value when passed "!*t" [765]')
	assertTrue (os.date ('!*t', time).yday == 1, 'os.date() did not return expected value when passed "!*t" [766]')
	assertTrue (os.date ('!*t', time).isdst == false, 'os.date() did not return expected value when passed "!*t" [767]')

	local time = 1296525600

	assertTrue (os.date ('%a', time) == 'Tue', 'os.date() did not return expected value when passed "%a" [768]')
	assertTrue (os.date ('%A', time) == 'Tuesday', 'os.date() did not return expected value when passed "%A" [769]')
	assertTrue (os.date ('%b', time) == 'Feb', 'os.date() did not return expected value when passed "%b" [770]')
	assertTrue (os.date ('%B', time) == 'February', 'os.date() did not return expected value when passed "%B" [771]')
	assertTrue (os.date ('%d', time) == '01', 'os.date() did not return expected value when passed "%d" [772]')
	assertTrue (os.date ('%H', time) == '02', 'os.date() did not return expected value when passed "%H" [773]')
	assertTrue (os.date ('%I', time) == '02', 'os.date() did not return expected value when passed "%I" [774]')
	assertTrue (os.date ('%j', time) == '032', 'os.date() did not return expected value when passed "%j" [775]')
	assertTrue (os.date ('%m', time) == '02', 'os.date() did not return expected value when passed "%m" [776]')
	assertTrue (os.date ('%M', time) == '00', 'os.date() did not return expected value when passed "%M" [777]')
	assertTrue (os.date ('%p', time) == 'AM', 'os.date() did not return expected value when passed "%p" [778]')
	assertTrue (os.date ('%S', time) == '00', 'os.date() did not return expected value when passed "%S" [779]')
	assertTrue (os.date ('%U', time) == '05', 'os.date() did not return expected value when passed "%U" [780]')
	assertTrue (os.date ('%w', time) == '2', 'os.date() did not return expected value when passed "%w" [781]')
	assertTrue (os.date ('%W', time) == '05', 'os.date() did not return expected value when passed "%W" [782]')
	assertTrue (os.date ('%x', time) == '02/01/11', 'os.date() did not return expected value when passed "%x" [783]')
	assertTrue (os.date ('%X', time) == '02:00:00', 'os.date() did not return expected value when passed "%X" [784]')
	assertTrue (os.date ('%y', time) == '11', 'os.date() did not return expected value when passed "%y" [785]')
	assertTrue (os.date ('%Y', time) == '2011', 'os.date() did not return expected value when passed "%Y" [786]')
	assertTrue (os.date ('%Z', time) == 'GMT', 'os.date() did not return expected value when passed "%Z" [787]')
	assertTrue (os.date ('%%', time) == '%', 'os.date() did not return expected value when passed "%%" [788]')
	assertTrue (os.date ('!%a', time) == 'Tue', 'os.date() did not return expected value when passed "!%a" [789]')
	assertTrue (os.date ('!%A', time) == 'Tuesday', 'os.date() did not return expected value when passed "!%A" [790]')
	assertTrue (os.date ('!%b', time) == 'Feb', 'os.date() did not return expected value when passed "!%b" [791]')
	assertTrue (os.date ('!%B', time) == 'February', 'os.date() did not return expected value when passed "!%B" [792]')
	assertTrue (os.date ('!%d', time) == '01', 'os.date() did not return expected value when passed "!%d" [793]')
	assertTrue (os.date ('!%H', time) == '02', 'os.date() did not return expected value when passed "!%H" [794]')
	assertTrue (os.date ('!%I', time) == '02', 'os.date() did not return expected value when passed "!%I" [795]')
	assertTrue (os.date ('!%j', time) == '032', 'os.date() did not return expected value when passed "!%j" [796]')
	assertTrue (os.date ('!%m', time) == '02', 'os.date() did not return expected value when passed "!%m" [797]')
	assertTrue (os.date ('!%M', time) == '00', 'os.date() did not return expected value when passed "!%M" [798]')
	assertTrue (os.date ('!%p', time) == 'AM', 'os.date() did not return expected value when passed "!%p" [799]')
	assertTrue (os.date ('!%S', time) == '00', 'os.date() did not return expected value when passed "!%S" [800]')
	assertTrue (os.date ('!%U', time) == '05', 'os.date() did not return expected value when passed "!%U" [801]')
	assertTrue (os.date ('!%w', time) == '2', 'os.date() did not return expected value when passed "!%w" [802]')
	assertTrue (os.date ('!%W', time) == '05', 'os.date() did not return expected value when passed "!%W" [803]')
	assertTrue (os.date ('!%x', time) == '02/01/11', 'os.date() did not return expected value when passed "!%x" [804]')
	assertTrue (os.date ('!%X', time) == '02:00:00', 'os.date() did not return expected value when passed "!%X" [805]')
	assertTrue (os.date ('!%y', time) == '11', 'os.date() did not return expected value when passed "!%y" [806]')
	assertTrue (os.date ('!%Y', time) == '2011', 'os.date() did not return expected value when passed "!%Y" [807]')
	assertTrue (os.date ('!%Z', time) == 'UTC', 'os.date() did not return expected value when passed "!%Z" [808]')
	assertTrue (os.date ('*t', time).hour == 2, 'os.date() did not return expected value when passed "*t" [809]')
	assertTrue (os.date ('*t', time).min == 0, 'os.date() did not return expected value when passed "*t" [810]')
	assertTrue (os.date ('*t', time).wday == 3, 'os.date() did not return expected value when passed "*t" [811]')
	assertTrue (os.date ('*t', time).day == 1, 'os.date() did not return expected value when passed "*t" [812]')
	assertTrue (os.date ('*t', time).month == 2, 'os.date() did not return expected value when passed "*t" [813]')
	assertTrue (os.date ('*t', time).year == 2011, 'os.date() did not return expected value when passed "*t" [814]')
	assertTrue (os.date ('*t', time).sec == 0, 'os.date() did not return expected value when passed "*t" [815]')
	assertTrue (os.date ('*t', time).yday == 32, 'os.date() did not return expected value when passed "*t" [816]')
	assertTrue (os.date ('*t', time).isdst == false, 'os.date() did not return expected value when passed "*t" [817]')
	assertTrue (os.date ('!*t', time).hour == 2, 'os.date() did not return expected value when passed "!*t" [818]')
	assertTrue (os.date ('!*t', time).min == 0, 'os.date() did not return expected value when passed "!*t" [819]')
	assertTrue (os.date ('!*t', time).wday == 3, 'os.date() did not return expected value when passed "!*t" [820]')
	assertTrue (os.date ('!*t', time).day == 1, 'os.date() did not return expected value when passed "!*t" [821]')
	assertTrue (os.date ('!*t', time).month == 2, 'os.date() did not return expected value when passed "!*t" [822]')
	assertTrue (os.date ('!*t', time).year == 2011, 'os.date() did not return expected value when passed "!*t" [823]')
	assertTrue (os.date ('!*t', time).sec == 0, 'os.date() did not return expected value when passed "!*t" [824]')
	assertTrue (os.date ('!*t', time).yday == 32, 'os.date() did not return expected value when passed "!*t" [825]')
	assertTrue (os.date ('!*t', time).isdst == false, 'os.date() did not return expected value when passed "!*t" [826]')

	local time = 1298858400

	assertTrue (os.date ('%a', time) == 'Mon', 'os.date() did not return expected value when passed "%a" [827]')
	assertTrue (os.date ('%A', time) == 'Monday', 'os.date() did not return expected value when passed "%A" [828]')
	assertTrue (os.date ('%b', time) == 'Feb', 'os.date() did not return expected value when passed "%b" [829]')
	assertTrue (os.date ('%B', time) == 'February', 'os.date() did not return expected value when passed "%B" [830]')
	assertTrue (os.date ('%d', time) == '28', 'os.date() did not return expected value when passed "%d" [831]')
	assertTrue (os.date ('%H', time) == '02', 'os.date() did not return expected value when passed "%H" [832]')
	assertTrue (os.date ('%I', time) == '02', 'os.date() did not return expected value when passed "%I" [833]')
	assertTrue (os.date ('%j', time) == '059', 'os.date() did not return expected value when passed "%j" [834]')
	assertTrue (os.date ('%m', time) == '02', 'os.date() did not return expected value when passed "%m" [835]')
	assertTrue (os.date ('%M', time) == '00', 'os.date() did not return expected value when passed "%M" [836]')
	assertTrue (os.date ('%p', time) == 'AM', 'os.date() did not return expected value when passed "%p" [837]')
	assertTrue (os.date ('%S', time) == '00', 'os.date() did not return expected value when passed "%S" [838]')
	assertTrue (os.date ('%U', time) == '09', 'os.date() did not return expected value when passed "%U" [839]')
	assertTrue (os.date ('%w', time) == '1', 'os.date() did not return expected value when passed "%w" [840]')
	assertTrue (os.date ('%W', time) == '09', 'os.date() did not return expected value when passed "%W" [841]')
	assertTrue (os.date ('%x', time) == '02/28/11', 'os.date() did not return expected value when passed "%x" [842]')
	assertTrue (os.date ('%X', time) == '02:00:00', 'os.date() did not return expected value when passed "%X" [843]')
	assertTrue (os.date ('%y', time) == '11', 'os.date() did not return expected value when passed "%y" [844]')
	assertTrue (os.date ('%Y', time) == '2011', 'os.date() did not return expected value when passed "%Y" [845]')
	assertTrue (os.date ('%Z', time) == 'GMT', 'os.date() did not return expected value when passed "%Z" [846]')
	assertTrue (os.date ('%%', time) == '%', 'os.date() did not return expected value when passed "%%" [847]')
	assertTrue (os.date ('!%a', time) == 'Mon', 'os.date() did not return expected value when passed "!%a" [848]')
	assertTrue (os.date ('!%A', time) == 'Monday', 'os.date() did not return expected value when passed "!%A" [849]')
	assertTrue (os.date ('!%b', time) == 'Feb', 'os.date() did not return expected value when passed "!%b" [850]')
	assertTrue (os.date ('!%B', time) == 'February', 'os.date() did not return expected value when passed "!%B" [851]')
	assertTrue (os.date ('!%d', time) == '28', 'os.date() did not return expected value when passed "!%d" [852]')
	assertTrue (os.date ('!%H', time) == '02', 'os.date() did not return expected value when passed "!%H" [853]')
	assertTrue (os.date ('!%I', time) == '02', 'os.date() did not return expected value when passed "!%I" [854]')
	assertTrue (os.date ('!%j', time) == '059', 'os.date() did not return expected value when passed "!%j" [855]')
	assertTrue (os.date ('!%m', time) == '02', 'os.date() did not return expected value when passed "!%m" [856]')
	assertTrue (os.date ('!%M', time) == '00', 'os.date() did not return expected value when passed "!%M" [857]')
	assertTrue (os.date ('!%p', time) == 'AM', 'os.date() did not return expected value when passed "!%p" [858]')
	assertTrue (os.date ('!%S', time) == '00', 'os.date() did not return expected value when passed "!%S" [859]')
	assertTrue (os.date ('!%U', time) == '09', 'os.date() did not return expected value when passed "!%U" [860]')
	assertTrue (os.date ('!%w', time) == '1', 'os.date() did not return expected value when passed "!%w" [861]')
	assertTrue (os.date ('!%W', time) == '09', 'os.date() did not return expected value when passed "!%W" [862]')
	assertTrue (os.date ('!%x', time) == '02/28/11', 'os.date() did not return expected value when passed "!%x" [863]')
	assertTrue (os.date ('!%X', time) == '02:00:00', 'os.date() did not return expected value when passed "!%X" [864]')
	assertTrue (os.date ('!%y', time) == '11', 'os.date() did not return expected value when passed "!%y" [865]')
	assertTrue (os.date ('!%Y', time) == '2011', 'os.date() did not return expected value when passed "!%Y" [866]')
	assertTrue (os.date ('!%Z', time) == 'UTC', 'os.date() did not return expected value when passed "!%Z" [867]')
	assertTrue (os.date ('*t', time).hour == 2, 'os.date() did not return expected value when passed "*t" [868]')
	assertTrue (os.date ('*t', time).min == 0, 'os.date() did not return expected value when passed "*t" [869]')
	assertTrue (os.date ('*t', time).wday == 2, 'os.date() did not return expected value when passed "*t" [870]')
	assertTrue (os.date ('*t', time).day == 28, 'os.date() did not return expected value when passed "*t" [871]')
	assertTrue (os.date ('*t', time).month == 2, 'os.date() did not return expected value when passed "*t" [872]')
	assertTrue (os.date ('*t', time).year == 2011, 'os.date() did not return expected value when passed "*t" [873]')
	assertTrue (os.date ('*t', time).sec == 0, 'os.date() did not return expected value when passed "*t" [874]')
	assertTrue (os.date ('*t', time).yday == 59, 'os.date() did not return expected value when passed "*t" [875]')
	assertTrue (os.date ('*t', time).isdst == false, 'os.date() did not return expected value when passed "*t" [876]')
	assertTrue (os.date ('!*t', time).hour == 2, 'os.date() did not return expected value when passed "!*t" [877]')
	assertTrue (os.date ('!*t', time).min == 0, 'os.date() did not return expected value when passed "!*t" [878]')
	assertTrue (os.date ('!*t', time).wday == 2, 'os.date() did not return expected value when passed "!*t" [879]')
	assertTrue (os.date ('!*t', time).day == 28, 'os.date() did not return expected value when passed "!*t" [880]')
	assertTrue (os.date ('!*t', time).month == 2, 'os.date() did not return expected value when passed "!*t" [881]')
	assertTrue (os.date ('!*t', time).year == 2011, 'os.date() did not return expected value when passed "!*t" [882]')
	assertTrue (os.date ('!*t', time).sec == 0, 'os.date() did not return expected value when passed "!*t" [883]')
	assertTrue (os.date ('!*t', time).yday == 59, 'os.date() did not return expected value when passed "!*t" [884]')
	assertTrue (os.date ('!*t', time).isdst == false, 'os.date() did not return expected value when passed "!*t" [885]')

	local time = 1298944800

	assertTrue (os.date ('%a', time) == 'Tue', 'os.date() did not return expected value when passed "%a" [886]')
	assertTrue (os.date ('%A', time) == 'Tuesday', 'os.date() did not return expected value when passed "%A" [887]')
	assertTrue (os.date ('%b', time) == 'Mar', 'os.date() did not return expected value when passed "%b" [888]')
	assertTrue (os.date ('%B', time) == 'March', 'os.date() did not return expected value when passed "%B" [889]')
	assertTrue (os.date ('%d', time) == '01', 'os.date() did not return expected value when passed "%d" [890]')
	assertTrue (os.date ('%H', time) == '02', 'os.date() did not return expected value when passed "%H" [891]')
	assertTrue (os.date ('%I', time) == '02', 'os.date() did not return expected value when passed "%I" [892]')
	assertTrue (os.date ('%j', time) == '060', 'os.date() did not return expected value when passed "%j" [893]')
	assertTrue (os.date ('%m', time) == '03', 'os.date() did not return expected value when passed "%m" [894]')
	assertTrue (os.date ('%M', time) == '00', 'os.date() did not return expected value when passed "%M" [895]')
	assertTrue (os.date ('%p', time) == 'AM', 'os.date() did not return expected value when passed "%p" [896]')
	assertTrue (os.date ('%S', time) == '00', 'os.date() did not return expected value when passed "%S" [897]')
	assertTrue (os.date ('%U', time) == '09', 'os.date() did not return expected value when passed "%U" [898]')
	assertTrue (os.date ('%w', time) == '2', 'os.date() did not return expected value when passed "%w" [899]')
	assertTrue (os.date ('%W', time) == '09', 'os.date() did not return expected value when passed "%W" [900]')
	assertTrue (os.date ('%x', time) == '03/01/11', 'os.date() did not return expected value when passed "%x" [901]')
	assertTrue (os.date ('%X', time) == '02:00:00', 'os.date() did not return expected value when passed "%X" [902]')
	assertTrue (os.date ('%y', time) == '11', 'os.date() did not return expected value when passed "%y" [903]')
	assertTrue (os.date ('%Y', time) == '2011', 'os.date() did not return expected value when passed "%Y" [904]')
	assertTrue (os.date ('%Z', time) == 'GMT', 'os.date() did not return expected value when passed "%Z" [905]')
	assertTrue (os.date ('%%', time) == '%', 'os.date() did not return expected value when passed "%%" [906]')
	assertTrue (os.date ('!%a', time) == 'Tue', 'os.date() did not return expected value when passed "!%a" [907]')
	assertTrue (os.date ('!%A', time) == 'Tuesday', 'os.date() did not return expected value when passed "!%A" [908]')
	assertTrue (os.date ('!%b', time) == 'Mar', 'os.date() did not return expected value when passed "!%b" [909]')
	assertTrue (os.date ('!%B', time) == 'March', 'os.date() did not return expected value when passed "!%B" [910]')
	assertTrue (os.date ('!%d', time) == '01', 'os.date() did not return expected value when passed "!%d" [911]')
	assertTrue (os.date ('!%H', time) == '02', 'os.date() did not return expected value when passed "!%H" [912]')
	assertTrue (os.date ('!%I', time) == '02', 'os.date() did not return expected value when passed "!%I" [913]')
	assertTrue (os.date ('!%j', time) == '060', 'os.date() did not return expected value when passed "!%j" [914]')
	assertTrue (os.date ('!%m', time) == '03', 'os.date() did not return expected value when passed "!%m" [915]')
	assertTrue (os.date ('!%M', time) == '00', 'os.date() did not return expected value when passed "!%M" [916]')
	assertTrue (os.date ('!%p', time) == 'AM', 'os.date() did not return expected value when passed "!%p" [917]')
	assertTrue (os.date ('!%S', time) == '00', 'os.date() did not return expected value when passed "!%S" [918]')
	assertTrue (os.date ('!%U', time) == '09', 'os.date() did not return expected value when passed "!%U" [919]')
	assertTrue (os.date ('!%w', time) == '2', 'os.date() did not return expected value when passed "!%w" [920]')
	assertTrue (os.date ('!%W', time) == '09', 'os.date() did not return expected value when passed "!%W" [921]')
	assertTrue (os.date ('!%x', time) == '03/01/11', 'os.date() did not return expected value when passed "!%x" [922]')
	assertTrue (os.date ('!%X', time) == '02:00:00', 'os.date() did not return expected value when passed "!%X" [923]')
	assertTrue (os.date ('!%y', time) == '11', 'os.date() did not return expected value when passed "!%y" [924]')
	assertTrue (os.date ('!%Y', time) == '2011', 'os.date() did not return expected value when passed "!%Y" [925]')
	assertTrue (os.date ('!%Z', time) == 'UTC', 'os.date() did not return expected value when passed "!%Z" [926]')
	assertTrue (os.date ('*t', time).hour == 2, 'os.date() did not return expected value when passed "*t" [927]')
	assertTrue (os.date ('*t', time).min == 0, 'os.date() did not return expected value when passed "*t" [928]')
	assertTrue (os.date ('*t', time).wday == 3, 'os.date() did not return expected value when passed "*t" [929]')
	assertTrue (os.date ('*t', time).day == 1, 'os.date() did not return expected value when passed "*t" [930]')
	assertTrue (os.date ('*t', time).month == 3, 'os.date() did not return expected value when passed "*t" [931]')
	assertTrue (os.date ('*t', time).year == 2011, 'os.date() did not return expected value when passed "*t" [932]')
	assertTrue (os.date ('*t', time).sec == 0, 'os.date() did not return expected value when passed "*t" [933]')
	assertTrue (os.date ('*t', time).yday == 60, 'os.date() did not return expected value when passed "*t" [934]')
	assertTrue (os.date ('*t', time).isdst == false, 'os.date() did not return expected value when passed "*t" [935]')
	assertTrue (os.date ('!*t', time).hour == 2, 'os.date() did not return expected value when passed "!*t" [936]')
	assertTrue (os.date ('!*t', time).min == 0, 'os.date() did not return expected value when passed "!*t" [937]')
	assertTrue (os.date ('!*t', time).wday == 3, 'os.date() did not return expected value when passed "!*t" [938]')
	assertTrue (os.date ('!*t', time).day == 1, 'os.date() did not return expected value when passed "!*t" [939]')
	assertTrue (os.date ('!*t', time).month == 3, 'os.date() did not return expected value when passed "!*t" [940]')
	assertTrue (os.date ('!*t', time).year == 2011, 'os.date() did not return expected value when passed "!*t" [941]')
	assertTrue (os.date ('!*t', time).sec == 0, 'os.date() did not return expected value when passed "!*t" [942]')
	assertTrue (os.date ('!*t', time).yday == 60, 'os.date() did not return expected value when passed "!*t" [943]')
	assertTrue (os.date ('!*t', time).isdst == false, 'os.date() did not return expected value when passed "!*t" [944]')

	local time = 1298948400

	assertTrue (os.date ('%a', time) == 'Tue', 'os.date() did not return expected value when passed "%a" [945]')
	assertTrue (os.date ('%A', time) == 'Tuesday', 'os.date() did not return expected value when passed "%A" [946]')
	assertTrue (os.date ('%b', time) == 'Mar', 'os.date() did not return expected value when passed "%b" [947]')
	assertTrue (os.date ('%B', time) == 'March', 'os.date() did not return expected value when passed "%B" [948]')
	assertTrue (os.date ('%d', time) == '01', 'os.date() did not return expected value when passed "%d" [949]')
	assertTrue (os.date ('%H', time) == '03', 'os.date() did not return expected value when passed "%H" [950]')
	assertTrue (os.date ('%I', time) == '03', 'os.date() did not return expected value when passed "%I" [951]')
	assertTrue (os.date ('%j', time) == '060', 'os.date() did not return expected value when passed "%j" [952]')
	assertTrue (os.date ('%m', time) == '03', 'os.date() did not return expected value when passed "%m" [953]')
	assertTrue (os.date ('%M', time) == '00', 'os.date() did not return expected value when passed "%M" [954]')
	assertTrue (os.date ('%p', time) == 'AM', 'os.date() did not return expected value when passed "%p" [955]')
	assertTrue (os.date ('%S', time) == '00', 'os.date() did not return expected value when passed "%S" [956]')
	assertTrue (os.date ('%U', time) == '09', 'os.date() did not return expected value when passed "%U" [957]')
	assertTrue (os.date ('%w', time) == '2', 'os.date() did not return expected value when passed "%w" [958]')
	assertTrue (os.date ('%W', time) == '09', 'os.date() did not return expected value when passed "%W" [959]')
	assertTrue (os.date ('%x', time) == '03/01/11', 'os.date() did not return expected value when passed "%x" [960]')
	assertTrue (os.date ('%X', time) == '03:00:00', 'os.date() did not return expected value when passed "%X" [961]')
	assertTrue (os.date ('%y', time) == '11', 'os.date() did not return expected value when passed "%y" [962]')
	assertTrue (os.date ('%Y', time) == '2011', 'os.date() did not return expected value when passed "%Y" [963]')
	assertTrue (os.date ('%Z', time) == 'GMT', 'os.date() did not return expected value when passed "%Z" [964]')
	assertTrue (os.date ('%%', time) == '%', 'os.date() did not return expected value when passed "%%" [965]')
	assertTrue (os.date ('!%a', time) == 'Tue', 'os.date() did not return expected value when passed "!%a" [966]')
	assertTrue (os.date ('!%A', time) == 'Tuesday', 'os.date() did not return expected value when passed "!%A" [967]')
	assertTrue (os.date ('!%b', time) == 'Mar', 'os.date() did not return expected value when passed "!%b" [968]')
	assertTrue (os.date ('!%B', time) == 'March', 'os.date() did not return expected value when passed "!%B" [969]')
	assertTrue (os.date ('!%d', time) == '01', 'os.date() did not return expected value when passed "!%d" [970]')
	assertTrue (os.date ('!%H', time) == '03', 'os.date() did not return expected value when passed "!%H" [971]')
	assertTrue (os.date ('!%I', time) == '03', 'os.date() did not return expected value when passed "!%I" [972]')
	assertTrue (os.date ('!%j', time) == '060', 'os.date() did not return expected value when passed "!%j" [973]')
	assertTrue (os.date ('!%m', time) == '03', 'os.date() did not return expected value when passed "!%m" [974]')
	assertTrue (os.date ('!%M', time) == '00', 'os.date() did not return expected value when passed "!%M" [975]')
	assertTrue (os.date ('!%p', time) == 'AM', 'os.date() did not return expected value when passed "!%p" [976]')
	assertTrue (os.date ('!%S', time) == '00', 'os.date() did not return expected value when passed "!%S" [977]')
	assertTrue (os.date ('!%U', time) == '09', 'os.date() did not return expected value when passed "!%U" [978]')
	assertTrue (os.date ('!%w', time) == '2', 'os.date() did not return expected value when passed "!%w" [979]')
	assertTrue (os.date ('!%W', time) == '09', 'os.date() did not return expected value when passed "!%W" [980]')
	assertTrue (os.date ('!%x', time) == '03/01/11', 'os.date() did not return expected value when passed "!%x" [981]')
	assertTrue (os.date ('!%X', time) == '03:00:00', 'os.date() did not return expected value when passed "!%X" [982]')
	assertTrue (os.date ('!%y', time) == '11', 'os.date() did not return expected value when passed "!%y" [983]')
	assertTrue (os.date ('!%Y', time) == '2011', 'os.date() did not return expected value when passed "!%Y" [984]')
	assertTrue (os.date ('!%Z', time) == 'UTC', 'os.date() did not return expected value when passed "!%Z" [985]')
	assertTrue (os.date ('*t', time).hour == 3, 'os.date() did not return expected value when passed "*t" [986]')
	assertTrue (os.date ('*t', time).min == 0, 'os.date() did not return expected value when passed "*t" [987]')
	assertTrue (os.date ('*t', time).wday == 3, 'os.date() did not return expected value when passed "*t" [988]')
	assertTrue (os.date ('*t', time).day == 1, 'os.date() did not return expected value when passed "*t" [989]')
	assertTrue (os.date ('*t', time).month == 3, 'os.date() did not return expected value when passed "*t" [990]')
	assertTrue (os.date ('*t', time).year == 2011, 'os.date() did not return expected value when passed "*t" [991]')
	assertTrue (os.date ('*t', time).sec == 0, 'os.date() did not return expected value when passed "*t" [992]')
	assertTrue (os.date ('*t', time).yday == 60, 'os.date() did not return expected value when passed "*t" [993]')
	assertTrue (os.date ('*t', time).isdst == false, 'os.date() did not return expected value when passed "*t" [994]')
	assertTrue (os.date ('!*t', time).hour == 3, 'os.date() did not return expected value when passed "!*t" [995]')
	assertTrue (os.date ('!*t', time).min == 0, 'os.date() did not return expected value when passed "!*t" [996]')
	assertTrue (os.date ('!*t', time).wday == 3, 'os.date() did not return expected value when passed "!*t" [997]')
	assertTrue (os.date ('!*t', time).day == 1, 'os.date() did not return expected value when passed "!*t" [998]')
	assertTrue (os.date ('!*t', time).month == 3, 'os.date() did not return expected value when passed "!*t" [999]')
	assertTrue (os.date ('!*t', time).year == 2011, 'os.date() did not return expected value when passed "!*t" [1000]')
	assertTrue (os.date ('!*t', time).sec == 0, 'os.date() did not return expected value when passed "!*t" [1001]')
	assertTrue (os.date ('!*t', time).yday == 60, 'os.date() did not return expected value when passed "!*t" [1002]')
	assertTrue (os.date ('!*t', time).isdst == false, 'os.date() did not return expected value when passed "!*t" [1003]')

	local time = 1325332800

	assertTrue (os.date ('%a', time) == 'Sat', 'os.date() did not return expected value when passed "%a" [1004]')
	assertTrue (os.date ('%A', time) == 'Saturday', 'os.date() did not return expected value when passed "%A" [1005]')
	assertTrue (os.date ('%b', time) == 'Dec', 'os.date() did not return expected value when passed "%b" [1006]')
	assertTrue (os.date ('%B', time) == 'December', 'os.date() did not return expected value when passed "%B" [1007]')
	assertTrue (os.date ('%d', time) == '31', 'os.date() did not return expected value when passed "%d" [1008]')
	assertTrue (os.date ('%H', time) == '12', 'os.date() did not return expected value when passed "%H" [1009]')
	assertTrue (os.date ('%I', time) == '12', 'os.date() did not return expected value when passed "%I" [1010]')
	assertTrue (os.date ('%j', time) == '365', 'os.date() did not return expected value when passed "%j" [1011]')
	assertTrue (os.date ('%m', time) == '12', 'os.date() did not return expected value when passed "%m" [1012]')
	assertTrue (os.date ('%M', time) == '00', 'os.date() did not return expected value when passed "%M" [1013]')
	assertTrue (os.date ('%p', time) == 'PM', 'os.date() did not return expected value when passed "%p" [1014]')
	assertTrue (os.date ('%S', time) == '00', 'os.date() did not return expected value when passed "%S" [1015]')
	assertTrue (os.date ('%U', time) == '52', 'os.date() did not return expected value when passed "%U" [1016]')
	assertTrue (os.date ('%w', time) == '6', 'os.date() did not return expected value when passed "%w" [1017]')
	assertTrue (os.date ('%W', time) == '52', 'os.date() did not return expected value when passed "%W" [1018]')
	assertTrue (os.date ('%x', time) == '12/31/11', 'os.date() did not return expected value when passed "%x" [1019]')
	assertTrue (os.date ('%X', time) == '12:00:00', 'os.date() did not return expected value when passed "%X" [1020]')
	assertTrue (os.date ('%y', time) == '11', 'os.date() did not return expected value when passed "%y" [1021]')
	assertTrue (os.date ('%Y', time) == '2011', 'os.date() did not return expected value when passed "%Y" [1022]')
	assertTrue (os.date ('%Z', time) == 'GMT', 'os.date() did not return expected value when passed "%Z" [1023]')
	assertTrue (os.date ('%%', time) == '%', 'os.date() did not return expected value when passed "%%" [1024]')
	assertTrue (os.date ('!%a', time) == 'Sat', 'os.date() did not return expected value when passed "!%a" [1025]')
	assertTrue (os.date ('!%A', time) == 'Saturday', 'os.date() did not return expected value when passed "!%A" [1026]')
	assertTrue (os.date ('!%b', time) == 'Dec', 'os.date() did not return expected value when passed "!%b" [1027]')
	assertTrue (os.date ('!%B', time) == 'December', 'os.date() did not return expected value when passed "!%B" [1028]')
	assertTrue (os.date ('!%d', time) == '31', 'os.date() did not return expected value when passed "!%d" [1029]')
	assertTrue (os.date ('!%H', time) == '12', 'os.date() did not return expected value when passed "!%H" [1030]')
	assertTrue (os.date ('!%I', time) == '12', 'os.date() did not return expected value when passed "!%I" [1031]')
	assertTrue (os.date ('!%j', time) == '365', 'os.date() did not return expected value when passed "!%j" [1032]')
	assertTrue (os.date ('!%m', time) == '12', 'os.date() did not return expected value when passed "!%m" [1033]')
	assertTrue (os.date ('!%M', time) == '00', 'os.date() did not return expected value when passed "!%M" [1034]')
	assertTrue (os.date ('!%p', time) == 'PM', 'os.date() did not return expected value when passed "!%p" [1035]')
	assertTrue (os.date ('!%S', time) == '00', 'os.date() did not return expected value when passed "!%S" [1036]')
	assertTrue (os.date ('!%U', time) == '52', 'os.date() did not return expected value when passed "!%U" [1037]')
	assertTrue (os.date ('!%w', time) == '6', 'os.date() did not return expected value when passed "!%w" [1038]')
	assertTrue (os.date ('!%W', time) == '52', 'os.date() did not return expected value when passed "!%W" [1039]')
	assertTrue (os.date ('!%x', time) == '12/31/11', 'os.date() did not return expected value when passed "!%x" [1040]')
	assertTrue (os.date ('!%X', time) == '12:00:00', 'os.date() did not return expected value when passed "!%X" [1041]')
	assertTrue (os.date ('!%y', time) == '11', 'os.date() did not return expected value when passed "!%y" [1042]')
	assertTrue (os.date ('!%Y', time) == '2011', 'os.date() did not return expected value when passed "!%Y" [1043]')
	assertTrue (os.date ('!%Z', time) == 'UTC', 'os.date() did not return expected value when passed "!%Z" [1044]')
	assertTrue (os.date ('*t', time).hour == 12, 'os.date() did not return expected value when passed "*t" [1045]')
	assertTrue (os.date ('*t', time).min == 0, 'os.date() did not return expected value when passed "*t" [1046]')
	assertTrue (os.date ('*t', time).wday == 7, 'os.date() did not return expected value when passed "*t" [1047]')
	assertTrue (os.date ('*t', time).day == 31, 'os.date() did not return expected value when passed "*t" [1048]')
	assertTrue (os.date ('*t', time).month == 12, 'os.date() did not return expected value when passed "*t" [1049]')
	assertTrue (os.date ('*t', time).year == 2011, 'os.date() did not return expected value when passed "*t" [1050]')
	assertTrue (os.date ('*t', time).sec == 0, 'os.date() did not return expected value when passed "*t" [1051]')
	assertTrue (os.date ('*t', time).yday == 365, 'os.date() did not return expected value when passed "*t" [1052]')
	assertTrue (os.date ('*t', time).isdst == false, 'os.date() did not return expected value when passed "*t" [1053]')
	assertTrue (os.date ('!*t', time).hour == 12, 'os.date() did not return expected value when passed "!*t" [1054]')
	assertTrue (os.date ('!*t', time).min == 0, 'os.date() did not return expected value when passed "!*t" [1055]')
	assertTrue (os.date ('!*t', time).wday == 7, 'os.date() did not return expected value when passed "!*t" [1056]')
	assertTrue (os.date ('!*t', time).day == 31, 'os.date() did not return expected value when passed "!*t" [1057]')
	assertTrue (os.date ('!*t', time).month == 12, 'os.date() did not return expected value when passed "!*t" [1058]')
	assertTrue (os.date ('!*t', time).year == 2011, 'os.date() did not return expected value when passed "!*t" [1059]')
	assertTrue (os.date ('!*t', time).sec == 0, 'os.date() did not return expected value when passed "!*t" [1060]')
	assertTrue (os.date ('!*t', time).yday == 365, 'os.date() did not return expected value when passed "!*t" [1061]')
	assertTrue (os.date ('!*t', time).isdst == false, 'os.date() did not return expected value when passed "!*t" [1062]')



end 

datetest ()


