/*
 * Moonshine - a Lua virtual machine.
 *
 * Copyright (C) 2013 Gamesys Limited,
 * 10 Piccadilly, London W1J 0DD
 * Email: moonshine@gamesys.co.uk
 * http://moonshinejs.org
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
var shine=shine||{};shine.EMPTY_OBJ={};shine.EMPTY_ARR=[];
shine.gc={objects:[],arrays:[],collected:0,reused:0,cacheArray:function(a){a.length=0;this.arrays.push(a);this.collected++},cacheObject:function(a){for(var d in a)a.hasOwnProperty(d)&&delete a[d];this.objects.push(a);this.collected++},createArray:function(){this.arrays.length&&this.reused++;return this.arrays.pop()||[]},createObject:function(){this.objects.length&&this.reused++;return this.objects.pop()||{}},decrRef:function(a){a&&a instanceof shine.Table&&void 0!==a.__shine.refCount&&0==--a.__shine.refCount&&
this.collect(a)},incrRef:function(a){a&&a instanceof shine.Table&&void 0!==a.__shine.refCount&&a.__shine.refCount++},collect:function(a){if(void 0!==a&&null!==a){if(a instanceof Array)return this.cacheArray(a);if("object"==typeof a&&a.constructor==Object)return this.cacheObject(a);if(a instanceof shine.Table&&void 0!==a.__shine.refCount){var d,e,b=a.__shine;d=0;for(e=b.keys.length;d<e;d++)this.decrRef(b.keys[d]);d=0;for(e=b.values.length;d<e;d++)this.decrRef(b.values[d]);d=0;for(e=b.numValues.length;d<
e;d++)this.decrRef(b.numValues[d]);this.cacheArray(b.keys);this.cacheArray(b.values);delete b.keys;delete b.values;this.cacheObject(b);delete a.__shine;for(d in a)a.hasOwnProperty(d)&&this.decrRef(a[d])}}}};"use strict";shine=shine||{};shine.EventEmitter=function(){this._listeners={}};shine.EventEmitter.prototype._trigger=function(a,d){var e=this._listeners[a],b,c;if(e)for(c in(d||shine.EMPTY_OBJ)instanceof Array||(d=[d]),e)if(e.hasOwnProperty(c)&&(b=e[c].apply(this,d),void 0!==b&&!b))break};
shine.EventEmitter.prototype.on=function(a,d){this._listeners[a]||(this._listeners[a]=[]);this._listeners[a].push(d)};shine.EventEmitter.prototype.unbind=function(a,d){for(var e in this._listeners[a])this._listeners[a].hasOwnProperty(e)&&this._listeners[a][e]===d&&this._listeners[a].splice(e,1)};"object"==typeof module&&module.exports&&(module.exports.EventEmitter=shine.EventEmitter);"use strict";shine=shine||{};shine.FileManager=function(){shine.EventEmitter.call(this);this._cache={}};
shine.FileManager.prototype=new shine.EventEmitter;shine.FileManager.prototype.constructor=shine.FileManager;
shine.FileManager.prototype.load=function(a,d){function e(b,c){var a;k.constructor._isJson(b)?a=JSON.parse(b):k.constructor._isLuac(b)&&(a=k.constructor._parseLuac(b));a&&window.setTimeout(function(){c&&(k._cache[c]=a);k._onSuccess(c||"",a,d)},1);return!!a}function b(b){if(!e(b,a))throw Error("File contains non-parsable content: "+a);}function c(b){k._onError(b,d)}var k=this,f;switch(typeof a){case "string":e(a)||((f=this._cache[a])?window.setTimeout(function(){k._onSuccess(a,f,d)},1):shine.utils.get(a,
b,c));break;case "object":this._onSuccess("",a,d);break;default:throw new TypeError("Can't load object of unknown type");}};
shine.FileManager.prototype._onSuccess=function(a,d,e){var b,c;if("moonshine.package"==d.format){for(c in d.files)this._cache[c]=d.files[c];this._trigger("loaded-package",d);if(!(a=d.main))return;if(!(d=d.files[a]))throw new ReferenceError("The package's main reference does not point to a filename within the package");}b=new shine.File(a,d);this._onFileLoaded(b,function(){e(null,b)})};shine.FileManager.prototype._onFileLoaded=function(a,d){d()};shine.FileManager.prototype._onError=function(a,d){d(a)};
shine.FileManager._isJson=function(a){return/^({.*}|\[.*\])$/.test(a)};shine.FileManager._isLuac=function(a){return a.substr(0,5)==String.fromCharCode(27,76,117,97,81)};shine.FileManager._parseLuac=function(a){if(!shine.distillery)throw Error('Moonshine needs the distillery to parse Lua byte code. Please include "distillery.moonshine.js" in the page.');"ArrayBuffer"in window||console.warn("Browser does not support ArrayBuffers, this could cause unexpected results when loading binary files.");return(new shine.distillery.Parser).parse(a)};
shine.FileManager.prototype.dispose=function(){delete this._cache};"use strict";shine=shine||{};shine.VM=function(a){shine.EventEmitter.call(this);this.fileManager=new shine.FileManager;this._env=a||{};this._coroutineStack=[];this._status=shine.RUNNING;this._resumeStack=[];this._callbackQueue=[];this._coroutineStack=[];this._resetGlobals()};shine.VM.prototype=new shine.EventEmitter;shine.VM.prototype.constructor=shine.VM;shine.RUNNING=0;shine.SUSPENDING=1;shine.SUSPENDED=2;shine.RESUMING=3;
shine.DEAD=4;shine.VM.prototype._resetGlobals=function(){var a=new shine.Table;a.setMember(-1,"moonshine");this._globals=this._bindLib(shine.lib);this._globals.arg=a;for(var d in this._globals)this._globals.hasOwnProperty(d)&&this._globals[d]instanceof shine.Table&&(this._globals["package"].loaded[d]=this._globals[d]);this._globals["package"].loaded._G=this._globals;for(d in this._env)this._env.hasOwnProperty(d)&&(this._globals[d]=this._env[d])};
shine.VM.prototype._bindLib=function(a){var d=shine.gc.createObject(),e;for(e in a)a.hasOwnProperty(e)&&(d[e]=a[e]);return new shine.Table(d)};shine.VM.prototype.load=function(a,d,e){var b=this;this.fileManager.load(a,function(c,k){if(c)throw new URIError("Failed to load file: "+a+" ("+c+")");b._trigger("file-loaded",k);(d||void 0===d)&&b.execute(e,k)})};
shine.VM.prototype.execute=function(a,d){var e=d?[d]:this._files,b,c;if(!e.length)throw Error("No files loaded.");for(b in e)if(e.hasOwnProperty(b)){d=e[b];if(!d.data)throw Error("Tried to execute file before data loaded.");c=this._thread=new shine.Function(this,d,d.data,this._globals);this._trigger("executing",[c,a]);try{if(a){var k=shine.lib.coroutine.wrap.call(this,c),f=function(){k();a.uiOnly&&k._coroutine.status!=shine.DEAD&&window.setTimeout(f,1)};f()}else c.call()}catch(g){shine.Error.catchExecutionError(g)}}};
shine.VM.prototype.setGlobal=function(a,d){this._globals[a]=d};shine.VM.prototype.getGlobal=function(a){return this._globals[a]};shine.VM.prototype.suspend=function(){if(this._status!==shine.RUNNING)throw Error("attempt to suspend a non-running VM");var a=this;this._status=shine.SUSPENDING;this._resumeVars=void 0;window.setTimeout(function(){a._status==shine.SUSPENDING&&(a._status=shine.SUSPENDED)},1)};
shine.VM.prototype.resume=function(a){if(this._status!==shine.SUSPENDED&&this._status!==shine.SUSPENDING)throw Error("attempt to resume a non-suspended VM");arguments.length&&void 0===a||(a=a||this._resumeVars);if(a&&!(a instanceof Array)){var d=shine.gc.createArray();d.push(a);a=d}this._status=shine.RESUMING;this._resumeVars=a;if(d=this._resumeStack.pop())try{d instanceof shine.Coroutine?d.resume():d instanceof shine.Closure?d._run():d()}catch(e){if(!((e||shine.EMPTY_OBJ)instanceof shine.Error)){var b=
e.stack||"",e=new shine.Error("Error in host call: "+e.message);e.stack=b;e.luaStack=b.split("\n")}e.luaStack||(e.luaStack=shine.gc.createArray());e.luaStack.push([d,d._pc-1]);shine.Error.catchExecutionError(e)}if(this._status==shine.RUNNING)for(;this._callbackQueue[0];)this._callbackQueue.shift()()};
shine.VM.prototype.dispose=function(){var a,d;for(d in this._files)this._files.hasOwnProperty(d)&&this._files[d].dispose();(a=this._thread)&&a.dispose();delete this._files;delete this._thread;delete this._globals;delete this._env;delete this._coroutineStack;this.fileManager.dispose();delete this.fileManager;shine.Closure._graveyard.length=0;shine.Closure._current=void 0;shine.Coroutine._graveyard.length=0};shine.getCurrentVM=function(){var a;return(a=this.Closure._current)&&a._vm};"use strict";
shine=shine||{};shine.Register=function(){this._items=shine.gc.createArray()};shine.Register._graveyard=[];shine.Register.create=function(){return shine.Register._graveyard.pop()||new shine.Register(arguments)};shine.Register.prototype.getLength=function(){return this._items.length};shine.Register.prototype.getItem=function(a){return this._items[a]};shine.Register.prototype.setItem=function(a,d){var e=this._items[a];shine.gc.incrRef(d);shine.gc.decrRef(e);this._items[a]=d};
shine.Register.prototype.set=function(a){var d,e=Math.max(a.length,this._items.length);for(d=0;d<e;d++)this.setItem(d,a[d])};shine.Register.prototype.push=function(){this._items.push.apply(this._items,arguments)};shine.Register.prototype.clearItem=function(a){delete this._items[a]};shine.Register.prototype.splice=function(a,d){this._items.splice.apply(this._items,arguments)};
shine.Register.prototype.reset=function(){for(var a=0,d=this._items.length;a<d;a++)shine.gc.decrRef(this._items[a]);this._items.length=0};shine.Register.prototype.dispose=function(){this._items.reset();this.constructor._graveyard.push(this)};"use strict";shine=shine||{};
shine.Closure=function(a,d,e,b,c){var k=this;this._vm=a;this._globals=b;this._file=d;this._data=e;this._upvalues=c||shine.gc.createObject();this._constants=e.constants;this._functions=e.functions;this._instructions=e.instructions;this._register=this._register||shine.Register.create();this._pc=0;this._localsUsedAsUpvalues=this._localsUsedAsUpvalues||shine.gc.createArray();this._funcInstances=this._funcInstances||shine.gc.createArray();this._localFunctions=shine.gc.createObject();k=this;a=function(){for(var b=
shine.gc.createArray(),c=0,a=arguments.length;c<a;c++)b.push(arguments[c]);return k.execute(b)};a._instance=this;a.dispose=function(){k.dispose.apply(k,arguments);delete this.dispose};return a};shine.Closure.prototype={};shine.Closure.prototype.constructor=shine.Closure;shine.Closure._graveyard=[];shine.Closure._current=void 0;shine.Closure.create=function(a,d,e,b,c){var k=shine.Closure._graveyard.pop();return k?shine.Closure.apply(k,arguments):new shine.Closure(a,d,e,b,c)};
shine.Closure.prototype.execute=function(a){var d=this;if(this._vm._status!=shine.RUNNING)this._vm._callbackQueue.push(function(){d.execute.call(d,a)});else{this._pc=0;this._params=shine.gc.createArray().concat(a);this._register.set(a.splice(0,this._data.paramCount));if(7==this._data.is_vararg){var e=shine.gc.createArray().concat(a),b=e.length,e=new shine.Table(e);e.setMember("n",b);this._register.push(e)}try{return this._run()}catch(c){throw(c||shine.EMPTY_OBJ)instanceof shine.Error||(e=c.stack||
"",c=new shine.Error("Error in host call: "+c.message),c.stack=e,c.luaStack=e.split("\n")),c.luaStack||(c.luaStack=shine.gc.createArray()),c.luaStack.push([this,this._pc-1]),c;}}};
shine.Closure.prototype._run=function(){var a,d;this.terminated=!1;this._vm._status==shine.RESUMING?this._vm._resumeStack.length?this._pc--:(this._vm._status=shine.RUNNING,a=this._vm._resumeVars,delete this._vm._resumeVars):shine.debug&&shine.debug._status==shine.RESUMING?shine.debug._resumeStack.length?this._pc--:shine.debug._setStatus(shine.RUNNING):(d=this._vm._coroutineRunning)&&d.status==shine.RESUMING&&(d._resumeStack.length?this._pc--:(d.status=shine.RUNNING,a=d._yieldVars));if(a){for(var e=
4*(this._pc-1),b=this._instructions[e+1],e=this._instructions[e+3],c=shine.gc.createArray(),k=0,f=a.length;k<f;k++)c.push(a[k]);if(0===e){f=c.length;for(k=0;k<f;k++)this._register.setItem(b+k,c[k]);this._register.splice(b+f)}else for(k=0;k<e-1;k++)this._register.setItem(b+k,c[k]);shine.gc.collect(c)}for(;void 0!==this._instructions[4*this._pc];){a=this._data.linePositions&&this._data.linePositions[this._pc];a=this._executeInstruction(this._pc++,a);if((d=this._vm._coroutineRunning)&&d.status==shine.SUSPENDING){d._resumeStack.push(this);
if(d._func._instance==this)return a=d._yieldVars,d.status=shine.SUSPENDED,shine.Coroutine._remove(),a;return}if(this._vm._status==shine.SUSPENDING&&!a){this._vm._resumeStack.push(this);return}if(shine.debug&&shine.debug._status==shine.SUSPENDING&&!a){shine.debug._resumeStack.push(this);return}if(void 0!==a)return this.terminated=!0,this.dispose(),a}this.terminated=!0;this.dispose()};
shine.Closure.prototype._executeInstruction=function(a,d){this.constructor._current=this;var e=4*a;return this.constructor.OPERATIONS[this._instructions[e]].call(this,this._instructions[e+1],this._instructions[e+2],this._instructions[e+3])};shine.Closure.prototype._getConstant=function(a){if(null!==this._constants[a])return this._constants[a]};
shine.Closure.prototype.hasRetainedScope=function(){if(this._localsUsedAsUpvalues.length||this._upvalues.length)return!0;for(var a in this._funcInstances)if(this._funcInstances.hasOwnProperty(a)&&this._funcInstances[a].isRetained())return!0;return!1};
shine.Closure.prototype.dispose=function(a){if(a||!this.hasRetainedScope())delete this._vm,delete this._globals,delete this._file,delete this._data,delete this._functions,delete this._instructions,delete this._pc,shine.gc.collect(this._params),shine.gc.collect(this._localFunctions),delete this._params,delete this._constants,delete this._upvalues,this._register.reset(),this._funcInstances.length=0,this._localsUsedAsUpvalues.length=0,shine.Closure._graveyard.push(this)};
(function(){function a(a,b,c){var d=shine.gc.createArray(),f,g,m,n,s,l,q;this._vm._status==shine.RESUMING?m=this._vm._resumeStack.pop():shine.debug&&shine.debug._status==shine.RESUMING&&(m=shine.debug._resumeStack.pop());if(m)m instanceof shine.Coroutine?(g=m.resume())&&g.shift():g=m instanceof shine.Closure?m._run():m();else if((n=this._vm._coroutineRunning)&&n.status==shine.RESUMING)m=n._resumeStack.pop(),g=m._run();else if(0===b)for(b=this._register.getLength(),f=a+1;f<b;f++)d.push(this._register.getItem(f));
else for(f=0;f<b-1;f++)d.push(this._register.getItem(a+f+1));if(!m)if(l=this._register.getItem(a),(l||shine.EMPTY_OBJ)instanceof shine.Function)g=l.apply(null,d,!0);else if(l&&l.apply)g=l.apply(null,d);else if(l&&(l||shine.EMPTY_OBJ)instanceof shine.Table&&(q=l.__shine.metatable)&&(s=q.getMember("__call"))&&s.apply)d.unshift(l),g=s.apply(null,d,!0);else throw new shine.Error("Attempt to call non-function");shine.gc.collect(d);if(this._vm._status==shine.SUSPENDING)void 0!==g&&void 0===this._vm._resumeVars&&
(this._vm._resumeVars=g instanceof Array?g:[g]);else if(g&&g instanceof Array||(g=[g]),!(n=this._vm._coroutineRunning)||n.status!=shine.SUSPENDING)if(0===c){b=g.length;for(f=0;f<b;f++)this._register.setItem(a+f,null==(l=g[f])?void 0:l);this._register.splice(a+b)}else for(f=0;f<c-1;f++)this._register.setItem(a+f,null==(l=g[f])?void 0:l)}function d(a,b,c){b=0;for(c=this._localsUsedAsUpvalues.length;b<c;b++){var d=this._localsUsedAsUpvalues[b];d&&d.registerIndex>=a&&(d.upvalue.value=this._register.getItem(d.registerIndex),
d.upvalue.open=!1,this._localsUsedAsUpvalues.splice(b--,1),c--,this._register.clearItem(d.registerIndex))}}shine.Closure.OPERATIONS=[function(a,b){var c=this._register.getItem(b),d,f;this._register.setItem(a,c);if(this._data.locals&&c&&c instanceof shine.Function)for(f=this._data.locals.length-1;0<=f;f--)d=this._data.locals[f],d.startpc==this._pc-1&&(this._localFunctions[d.varname]=c)},function(a,b){this._register.setItem(a,this._getConstant(b))},function(a,b,c){this._register.setItem(a,!!b);c&&this._pc++},
function(a,b){for(var c=a;c<=b;c++)this._register.setItem(c,void 0)},function(a,b){void 0!==this._upvalues[b]&&this._register.setItem(a,this._upvalues[b].getValue())},function(a,b){var c;"_G"==this._getConstant(b)?c=this._globals:void 0!==this._globals[this._getConstant(b)]&&(c=this._globals[this._getConstant(b)]);this._register.setItem(a,c)},function(a,b,c){b=this._register.getItem(b);c=256<=c?this._getConstant(c-256):this._register.getItem(c);if(void 0===b)throw new shine.Error("Attempt to index a nil value ("+
c+" not present in nil)");b=b instanceof shine.Table?b.getMember(c):"string"==typeof b&&shine.lib.string[c]?shine.lib.string[c]:b[c];this._register.setItem(a,b);b&&b instanceof shine.Function&&(this._localFunctions[c]=b)},function(a,b){var c=this._getConstant(b),d=this._globals[c],f=this._register.getItem(a);shine.gc.incrRef(f);shine.gc.decrRef(d);this._globals[c]=f},function(a,b){this._upvalues[b].setValue(this._register.getItem(a))},function(a,b,c){a=this._register.getItem(a);b=256<=b?this._getConstant(b-
256):this._register.getItem(b);c=256<=c?this._getConstant(c-256):this._register.getItem(c);if(void 0===a)throw new shine.Error("Attempt to index a missing field (can't set \""+b+'" on a nil value)');a instanceof shine.Table?a.setMember(b,c):a[b]=c},function(a,b,c){b=new shine.Table;b.__shine.refCount=0;this._register.setItem(a,b)},function(a,b,c){b=this._register.getItem(b);c=256<=c?this._getConstant(c-256):this._register.getItem(c);this._register.setItem(a+1,b);if(void 0===b)throw new shine.Error("Attempt to index a nil value ("+
c+" not present in nil)");b=b instanceof shine.Table?b.getMember(c):"string"==typeof b&&shine.lib.string[c]?shine.lib.string[c]:b[c];this._register.setItem(a,b)},function(a,b,c){b=256<=b?this._getConstant(b-256):this._register.getItem(b);c=256<=c?this._getConstant(c-256):this._register.getItem(c);var d=shine.utils.coerce,f,g;(b||shine.EMPTY_OBJ)instanceof shine.Table&&(f=b.__shine.metatable)&&(g=f.getMember("__add"))||(c||shine.EMPTY_OBJ)instanceof shine.Table&&(f=c.__shine.metatable)&&(g=f.getMember("__add"))?
this._register.setItem(a,g.apply(null,[b,c],!0)[0]):(b=d(b,"number","attempt to perform arithmetic on a %type value"),c=d(c,"number","attempt to perform arithmetic on a %type value"),this._register.setItem(a,b+c))},function(a,b,c){b=256<=b?this._getConstant(b-256):this._register.getItem(b);c=256<=c?this._getConstant(c-256):this._register.getItem(c);var d=shine.utils.coerce,f,g;(b||shine.EMPTY_OBJ)instanceof shine.Table&&(f=b.__shine.metatable)&&(g=f.getMember("__sub"))||(c||shine.EMPTY_OBJ)instanceof
shine.Table&&(f=c.__shine.metatable)&&(g=f.getMember("__sub"))?this._register.setItem(a,g.apply(null,[b,c],!0)[0]):(b=d(b,"number","attempt to perform arithmetic on a %type value"),c=d(c,"number","attempt to perform arithmetic on a %type value"),this._register.setItem(a,b-c))},function(a,b,c){b=256<=b?this._getConstant(b-256):this._register.getItem(b);c=256<=c?this._getConstant(c-256):this._register.getItem(c);var d=shine.utils.coerce,f,g;(b||shine.EMPTY_OBJ)instanceof shine.Table&&(f=b.__shine.metatable)&&
(g=f.getMember("__mul"))||(c||shine.EMPTY_OBJ)instanceof shine.Table&&(f=c.__shine.metatable)&&(g=f.getMember("__mul"))?this._register.setItem(a,g.apply(null,[b,c],!0)[0]):(b=d(b,"number","attempt to perform arithmetic on a %type value"),c=d(c,"number","attempt to perform arithmetic on a %type value"),this._register.setItem(a,b*c))},function(a,b,c){b=256<=b?this._getConstant(b-256):this._register.getItem(b);c=256<=c?this._getConstant(c-256):this._register.getItem(c);var d=shine.utils.coerce,f,g;(b||
shine.EMPTY_OBJ)instanceof shine.Table&&(f=b.__shine.metatable)&&(g=f.getMember("__div"))||(c||shine.EMPTY_OBJ)instanceof shine.Table&&(f=c.__shine.metatable)&&(g=f.getMember("__div"))?this._register.setItem(a,g.apply(null,[b,c],!0)[0]):(b=d(b,"number","attempt to perform arithmetic on a %type value"),c=d(c,"number","attempt to perform arithmetic on a %type value"),this._register.setItem(a,b/c))},function(a,b,c){b=256<=b?this._getConstant(b-256):this._register.getItem(b);c=256<=c?this._getConstant(c-
256):this._register.getItem(c);var d=shine.utils.coerce,f,g;(b||shine.EMPTY_OBJ)instanceof shine.Table&&(f=b.__shine.metatable)&&(g=f.getMember("__mod"))||(c||shine.EMPTY_OBJ)instanceof shine.Table&&(f=c.__shine.metatable)&&(g=f.getMember("__mod"))?this._register.setItem(a,g.apply(null,[b,c],!0)[0]):(b=d(b,"number","attempt to perform arithmetic on a %type value"),c=d(c,"number","attempt to perform arithmetic on a %type value"),0===c||-Infinity===c||Infinity===c||window.isNaN(b)||window.isNaN(c)?
d=NaN:(d=Math.abs(b)%(f=Math.abs(c)),0>b*c&&(d=f-d),0>c&&(d*=-1)),this._register.setItem(a,d))},function(a,b,c){b=256<=b?this._getConstant(b-256):this._register.getItem(b);c=256<=c?this._getConstant(c-256):this._register.getItem(c);var d=shine.utils.coerce,f,g;(b||shine.EMPTY_OBJ)instanceof shine.Table&&(f=b.__shine.metatable)&&(g=f.getMember("__pow"))||(c||shine.EMPTY_OBJ)instanceof shine.Table&&(f=c.__shine.metatable)&&(g=f.getMember("__pow"))?this._register.setItem(a,g.apply(null,[b,c],!0)[0]):
(b=d(b,"number","attempt to perform arithmetic on a %type value"),c=d(c,"number","attempt to perform arithmetic on a %type value"),this._register.setItem(a,Math.pow(b,c)))},function(a,b){var c,d;b=this._register.getItem(b);(b||shine.EMPTY_OBJ)instanceof shine.Table&&(c=b.__shine.metatable)&&(d=c.getMember("__unm"))?(c=shine.gc.createArray(),c.push(b),c=d.apply(null,[b],!0)[0]):(b=shine.utils.coerce(b,"number","attempt to perform arithmetic on a %type value"),c=-b);this._register.setItem(a,c)},function(a,
b){this._register.setItem(a,!this._register.getItem(b))},function(a,b){var c,d;b=this._register.getItem(b);if((b||shine.EMPTY_OBJ)instanceof shine.Table)c=shine.lib.table.getn(b);else if("object"==typeof b)for(d in c=0,b)b.hasOwnProperty(d)&&c++;else{if(void 0==b)throw new shine.Error("attempt to get length of a nil value");c=b.length}this._register.setItem(a,c)},function(a,b,c){var d=this._register.getItem(c),f,g,m,n;for(c-=1;c>=b;c--)if(f=this._register.getItem(c),void 0!==f&&f instanceof shine.Table&&
(g=f.__shine.metatable)&&(m=g.getMember("__concat"))||void 0!==d&&d instanceof shine.Table&&(g=d.__shine.metatable)&&(m=g.getMember("__concat")))n=shine.gc.createArray(),n.push(f,d),d=m.apply(null,n,!0)[0];else{if("string"!==typeof f&&"number"!==typeof f||"string"!==typeof d&&"number"!==typeof d)throw new shine.Error("Attempt to concatenate a non-string or non-numeric value");d=f+d}this._register.setItem(a,d)},function(a,b){this._pc+=b},function(a,b,c){b=256<=b?this._getConstant(b-256):this._register.getItem(b);
c=256<=c?this._getConstant(c-256):this._register.getItem(c);var d,f,g;(b!==c&&(b||shine.EMPTY_OBJ)instanceof shine.Table&&(c||shine.EMPTY_OBJ)instanceof shine.Table&&(d=b.__shine.metatable)&&(f=c.__shine.metatable)&&d===f&&(g=d.getMember("__eq"))?!!g.apply(null,[b,c],!0)[0]:b===c)!=a&&this._pc++},function(a,b,c){b=256<=b?this._getConstant(b-256):this._register.getItem(b);c=256<=c?this._getConstant(c-256):this._register.getItem(c);var d="object"!=typeof b&&typeof b||(b||shine.EMPTY_OBJ)instanceof shine.Table&&
"table"||"userdata",f="object"!=typeof c&&typeof b||(c||shine.EMPTY_OBJ)instanceof shine.Table&&"table"||"userdata",g,m,n;if(d!==f)throw new shine.Error("attempt to compare "+d+" with "+f);if("table"==d)if((m=b.__shine.metatable)&&(n=c.__shine.metatable)&&m===n&&(g=m.getMember("__lt")))b=g.apply(null,[b,c],!0)[0];else throw new shine.Error("attempt to compare two table values");else b=b<c;b!=a&&this._pc++},function(a,b,c){b=256<=b?this._getConstant(b-256):this._register.getItem(b);c=256<=c?this._getConstant(c-
256):this._register.getItem(c);var d="object"!=typeof b&&typeof b||(b||shine.EMPTY_OBJ)instanceof shine.Table&&"table"||"userdata",f="object"!=typeof c&&typeof b||(c||shine.EMPTY_OBJ)instanceof shine.Table&&"table"||"userdata",g,m,n;if(d!==f)throw new shine.Error("attempt to compare "+d+" with "+f);if("table"==d)if((m=b.__shine.metatable)&&(n=c.__shine.metatable)&&m===n&&(g=m.getMember("__le")))b=g.apply(null,[b,c],!0)[0];else throw new shine.Error("attempt to compare two table values");else b=b<=
c;b!=a&&this._pc++},function(a,b,c){a=this._register.getItem(a);shine.utils.coerce(a,"boolean")!==!!c&&this._pc++},function(a,b,c){b=this._register.getItem(b);shine.utils.coerce(b,"boolean")===!!c?this._register.setItem(a,b):this._pc++},a,function(d,b){return a.call(this,d,b,0)},function(a,b){var c=shine.gc.createArray(),k,f;if(0===b)for(k=this._register.getLength(),f=a;f<k;f++)c.push(this._register.getItem(f));else for(f=0;f<b-1;f++)c.push(k=this._register.getItem(a+f)),shine.gc.incrRef(k);d.call(this,
0);this.dead=!0;return c},function(a,b){var c=this._register.getItem(a+2),d=this._register.getItem(a+1),f=this._register.getItem(a)+c,c=c/Math.abs(c);this._register.setItem(a,f);if(1===c&&f<=d||1!==c&&f>=d)this._register.setItem(a+3,f),this._pc+=b},function(a,b){this._register.setItem(a,this._register.getItem(a)-this._register.getItem(a+2));this._pc+=b},function(a,b,c){b=shine.gc.createArray();var d;b.push(this._register.getItem(a+1),this._register.getItem(a+2));b=this._register.getItem(a).apply(void 0,
b);(b||shine.EMPTY_OBJ)instanceof Array||(d=shine.gc.createArray(),d.push(b),b=d);for(var f=0;f<c;f++)this._register.setItem(a+f+3,b[f]);void 0!==(d=this._register.getItem(a+3))?this._register.setItem(a+2,d):this._pc++},function(a,b,c){b=b||this._register.getLength()-a-1;var d;for(d=0;d<b;d++)this._register.getItem(a).setMember(50*(c-1)+d+1,this._register.getItem(a+d+1))},d,function(a,b){for(var c=this,d=shine.gc.createArray(),f;void 0!==(f=this._instructions[4*this._pc])&&(0===f||4===f)&&0===this._instructions[4*
this._pc+1];)(function(){var a=c._instructions[4*c._pc+2],e;if(0===f){for(var g=0,l=c._localsUsedAsUpvalues.length;g<l;g++){var q=c._localsUsedAsUpvalues[g];if(q.registerIndex===a){e=q.upvalue;break}}e||(e={open:!0,getValue:function(){return this.open?c._register.getItem(a):this.value},setValue:function(b){this.open?c._register.setItem(a,b):(shine.gc.incrRef(b),shine.gc.decrRef(this.value),this.value=b)},name:c._functions[b].upvalues?c._functions[b].upvalues[d.length]:"(upvalue)"},c._localsUsedAsUpvalues.push({registerIndex:a,
upvalue:e}));d.push(e)}else d.push({getValue:function(){return c._upvalues[a].getValue()},setValue:function(b){c._upvalues[a].setValue(b)},name:c._upvalues[a].name})})(),this._pc++;var g=new shine.Function(this._vm,this._file,this._functions[b],this._globals,d);this._register.setItem(a,g)},function(a,b){var c,d;d=0===b?Math.max(0,this._params.length-this._data.paramCount):b-1;for(c=0;c<d;c++)this._register.setItem(a+c,this._params[this._data.paramCount+c]);c=a+d;for(d=this._register.getLength();c<
d;c++)this._register.clearItem(c)}];shine.Closure.OPERATION_NAMES="move loadk loadbool loadnil getupval getglobal gettable setglobal setupval settable newtable self add sub mul div mod pow unm not len concat jmp eq lt le test testset call tailcall return forloop forprep tforloop setlist close closure vararg".split(" ")})();"use strict";shine=shine||{};
shine.Function=function(a,d,e,b,c){this._vm=a;this._file=d;this._data=e||shine.gc.createObject();this._globals=b;this._upvalues=c||shine.gc.createObject();this._index=shine.Function._index++;this.instances=shine.gc.createArray();this._retainCount=0;this._convertInstructions()};shine.Function.prototype={};shine.Function.prototype.constructor=shine.Function;shine.Function._index=0;
shine.Function.prototype.getInstance=function(){return shine.Closure.create(this._vm,this._file,this._data,this._globals,this._upvalues)};
shine.Function.prototype._convertInstructions=function(){var a=this._data.instructions||shine.gc.createArray(),d,e,b,c,k;if("ArrayBuffer"in window){if(a instanceof Int32Array)return;if(0==a.length||void 0===a[0].op){d=new ArrayBuffer(4*a.length);d=new Int32Array(d);d.set(a);this._data.instructions=d;return}d=new ArrayBuffer(16*a.length);d=new Int32Array(d)}else{if(0==a.length||"number"==typeof a[0])return;d=[]}e=0;for(b=a.length;e<b;e++)c=a[e],k=4*e,d[k]=c.op,d[k+1]=c.A,d[k+2]=c.B,d[k+3]=c.C;this._data.instructions=
d};shine.Function.prototype.call=function(){var a=shine.gc.createArray(),d=arguments.length,e;for(e=1;e<d;e++)a.push(arguments[e]);return this.apply(a)};shine.Function.prototype.apply=function(a,d,e){(a||shine.EMPTY_OBJ)instanceof Array&&!d&&(d=a,a=void 0);try{return this.getInstance().apply(a,d)}catch(b){shine.Error.catchExecutionError(b)}};shine.Function.prototype.toString=function(){return"function: 0x"+this._index.toString(16)};shine.Function.prototype.retain=function(){this._retainCount++};
shine.Function.prototype.release=function(){!--this._retainCount&&this._readyToDispose&&this.dispose()};shine.Function.prototype.isRetained=function(){if(this._retainCount)return!0;for(var a in this.instances)if(this.instances.hasOwnProperty(a)&&this.instances[a].hasRetainedScope())return!0;return!1};
shine.Function.prototype.dispose=function(a){this._readyToDispose=!0;if(a){a=0;for(var d=this.instances.length;a<d;a++)this.instances[a].dispose(!0)}else if(this.isRetained())return!1;delete this._vm;delete this._file;delete this._data;delete this._globals;delete this._upvalues;delete this.instances;delete this._readyToDispose;return!0};"use strict";shine=shine||{};
shine.Coroutine=function(a){shine.EventEmitter.call(this);this._func=a.getInstance();this._index=shine.Coroutine._index++;this._started=!1;this._yieldVars=void 0;this._resumeStack=this._resumeStack||shine.gc.createArray();this.status=shine.SUSPENDED;shine.stddebug.write("[coroutine created]\n")};shine.Coroutine.prototype=new shine.EventEmitter;shine.Coroutine.prototype.constructor=shine.Function;shine.Coroutine._index=0;shine.Coroutine._graveyard=[];
shine.Coroutine.create=function(a){var d=shine.Coroutine._graveyard.pop();return d?(shine.Coroutine.apply(d,arguments),d):new shine.Coroutine(a)};shine.Coroutine._add=function(a){var d=shine.getCurrentVM();d._coroutineStack.push(d._coroutineRunning);d._coroutineRunning=a};shine.Coroutine._remove=function(){var a=shine.getCurrentVM();a._coroutineRunning=a._coroutineStack.pop()};
shine.Coroutine.prototype.resume=function(){var a,d,e=this._func._instance._vm;try{if(this.status==shine.DEAD)throw new shine.Error("cannot resume dead coroutine");shine.Coroutine._add(this);e&&e._status==shine.RESUMING?d=e._resumeStack.pop():shine.debug&&shine.debug._status==shine.RESUMING&&(d=shine.debug._resumeStack.pop());if(d)a=d instanceof shine.Coroutine?d.resume():d instanceof Function?d():this._func._instance._run();else if(this._started){this.status=shine.RESUMING;shine.stddebug.write("[coroutine resuming]\n");
if(arguments.length){var b=shine.gc.createArray();d=0;for(var c=arguments.length;d<c;d++)b.push(arguments[d]);this._yieldVars=b}else this._yieldVars=void 0;a=this._resumeStack.pop()._run()}else this.status=shine.RUNNING,shine.stddebug.write("[coroutine started]\n"),this._started=!0,a=this._func.apply(null,arguments);if(shine.debug&&shine.debug._status==shine.SUSPENDING){shine.debug._resumeStack.push(this);return}this.status=this._func._instance.terminated?shine.DEAD:shine.SUSPENDED;a&&a.unshift(!0)}catch(k){k.luaStack||
(k.luaStack=shine.gc.createArray()),k.luaStack.push([this._func._instance,this._func._instance._pc-1]),a=[!1,k],this.status=shine.DEAD}this.status==shine.DEAD&&(shine.Coroutine._remove(),shine.stddebug.write("[coroutine terminated]\n"),this._dispose());return a};shine.Coroutine.prototype.toString=function(){return"thread:"+(this._index?"0x"+this._index.toString(16):"[dead]")};
shine.Coroutine.prototype._dispose=function(){delete this._func;delete this._index;delete this._listeners;delete this._started;delete this._yieldVars;delete this.status;this._resumeStack.length=0;shine.Coroutine._graveyard.push(this)};"use strict";shine=shine||{};
shine.Table=function(a){var d=(a||shine.EMPTY_OBJ)instanceof Array,e,b,c;a=a||shine.gc.createObject();this.__shine=e=shine.gc.createObject();e.type="table";e.index=++shine.Table.count;e.keys=shine.gc.createArray();e.values=shine.gc.createArray();e.numValues=[void 0];for(c in a)if(a.hasOwnProperty(c)){var k;e=d?parseInt(c,10)+1:c;b=a[c];null===b&&(b=void 0);k="undefined"!==typeof getQualifiedClassName?"Object"==getQualifiedClassName(b)&&!(b instanceof shine.Table)&&!(b instanceof shine.Coroutine)&&
!(b instanceof shine.Function)&&!(b instanceof shine.Closure)||"Array"==getQualifiedClassName(b):"object"==typeof b&&b.constructor===Object||b instanceof Array;this.setMember(e,k?new shine.Table(b):b)}};shine.Table.count=0;
shine.Table.prototype.getMember=function(a){var d=typeof a,e,b;"string"!=d||"getMember"!=a&&"setMember"!=a||(d="object");switch(d){case "string":if(this.hasOwnProperty(a)&&void 0!==this[a])return this[a];break;case "number":d=this.__shine.numValues[a];if(void 0!==d)return d;break;default:if(d=this.__shine.keys.indexOf(a),0<=d)return this.__shine.values[d]}if((e=this.__shine.metatable)&&(b=e.__index))switch(b.constructor){case shine.Table:return b.getMember(a);case Function:return b(this,a);case shine.Function:return b.apply(this,
[this,a])[0]}};
shine.Table.prototype.setMember=function(a,d){var e=this.__shine.metatable,b=typeof a,c,k,f;"string"!=b||"getMember"!=a&&"setMember"!=a||(b="object");switch(b){case "string":c=this[a];break;case "number":c=this.__shine.numValues[a];break;default:k=this.__shine.keys,f=k.indexOf(a),c=-1==f?void 0:this.__shine.values[f],void 0===c&&shine.gc.incrRef(a)}if(void 0===c&&e&&e.__newindex)switch(e.__newindex.constructor){case shine.Table:return e.__newindex.setMember(a,d);case Function:return e.__newindex(this,a,
d);case shine.Function:return e.__newindex.apply(this,[this,a,d])[0]}switch(b){case "string":this[a]=d;break;case "number":this.__shine.numValues[a]=d;break;default:0>f&&(f=k.length,k[f]=a),this.__shine.values[f]=d}shine.gc.incrRef(d);shine.gc.decrRef(c)};shine.Table.prototype.toString=function(){var a;return this.constructor!=shine.Table?"userdata":this.__shine&&(a=this.__shine.metatable)&&a.__tostring?a.__tostring.call(void 0,this)[0]:"table: 0x"+this.__shine.index.toString(16)};"use strict";
shine=shine||{};shine.Error=function(a){this.message=a};shine.Error.prototype=Object.create?Object.create(Error.prototype):Error();shine.Error.prototype.constructor=shine.Error;shine.Error.catchExecutionError=function(a){if(a)throw(a||shine.EMPTY_OBJ)instanceof shine.Error&&(a.luaMessage||(a.luaMessage=a.message),a.message=a.luaMessage+"\n    "+a._stackToString()),a;};
shine.Error.prototype._stackToString=function(){var a=[],d,e,b,c,k,f,g,m;this.luaStack=this.luaStack||[];f=0;for(m=this.luaStack.length;f<m;f++)if(!this.luaStack[f-1]||this.luaStack[f][0]!==this.luaStack[f-1][0]||this.luaStack[f][1]!==this.luaStack[f-1][1])if("string"==typeof this.luaStack[f])a.push(this.luaStack[f]);else{d=this.luaStack[f][0];e=this.luaStack[f][1];if(!(b=d._data.sourceName)){if(c=this.luaStack[f+1]&&this.luaStack[f+1][0]){for(g in c._localFunctions)if(c._localFunctions[g]._data===
d._data){b=g;break}if(!b)for(g in c._upvalues)if(k=c._upvalues[g].getValue(),(k||shine.EMPTY_OBJ)instanceof shine.Function&&k._data===d._data){b=c._upvalues[g].name;break}}if(!b)for(g in d._globals)if((d._globals[g]||shine.EMPTY_OBJ)instanceof shine.Function&&d._globals[g]._data===d._data){b=g;break}}d._file.data.sourcePath?(c=d._file.url.match("^(.*)/.*?$"),c=(null===c?".":c[1]||"")+"/"+c,c=c.replace(/\/\.\//g,"/").replace(/\/.*?\/\.\.\//g,"/")):c=d._file.url;a.push((b||"function")+" ["+(c||"file")+
":"+(d._data.linePositions?d._data.linePositions[e]:"?")+"]")}return a.join("\n    ")};shine.Error.prototype.toString=function(){return"Moonshine run-time error: "+this.message};"use strict";shine=shine||{};shine.File=function(a,d){this.url=a;this.data=d};shine.File.prototype.dispose=function(){delete this.url;delete this.data};"use strict";shine=shine||{};
(function(){function a(){q=k*q%f;return q/f}function d(h){if(h&&h instanceof shine.VM)return h;h=shine.getCurrentVM();if(!h)throw new shine.Error("Can't call library function without passing a VM object as the context");return h}function e(h,a,b){var c=parseInt(l["%j"](h),10);h=(8-(new Date(h.getFullYear(),0,1,12))["get"+(b?"UTC":"")+"Day"]()+a)%7;return("0"+(Math.floor((c-h)/7)+1)).substr(-2)}function b(h){h=""+h;var a=0,b,c,d,e;for(b in g)g.hasOwnProperty(b)&&(h=h.replace(RegExp(b,"g"),g[b]));c=
h.length;for(b=0;b<c;b++)d=h.substr(b,1),e=!1,"["==d?(a&&(e=!0),a++):"]"==d&&(a--,a&&(e=!0)),e&&(h=h.substr(0,b)+h.substr(b++ +1),c++);return h}function c(h,a){var b=d(this);b.fileManager.load(h,function(d,e){if(d)b._trigger("module-load-error",[e,d]),404==d&&/\.lua$/.test(h)?c.call(b,h+".json",a):a();else{var f=new shine.Function(b,e,e.data,b._globals);b._trigger("module-loaded",[e,f]);a(f)}});b._trigger("loading-module",h)}var k=16807,f=2147483647,g={"([^a-zA-Z0-9%(])-":"$1*?","(.)-([^a-zA-Z0-9?])":"$1*?$2",
"(.)-$":"$1*?","%a":"[a-zA-Z]","%A":"[^a-zA-Z]","%c":"[\x00-\u001f]","%C":"[^\x00-\u001f]","%d":"\\d","%D":"[^d]","%l":"[a-z]","%L":"[^a-z]","%p":"[.,\"'?!;:#$%&()*+-/<>=@[]\\^_{}|~]","%P":"[^.,\"'?!;:#$%&()*+-/<>=@[]\\^_{}|~]","%s":"[ \\t\\n\\f\\v\\r]","%S":"[^ \t\n\f\v\r]","%u":"[A-Z]","%U":"[^A-Z]","%w":"[a-zA-Z0-9]","%W":"[^a-zA-Z0-9]","%x":"[a-fA-F0-9]","%X":"[^a-fA-F0-9]","%([^a-zA-Z])":"\\$1"},m="Sunday Monday Tuesday Wednesday Thursday Friday Saturday".split(" "),n="January February March April May June July August September October November December".split(" "),
s=[31,28,31,30,31,30,31,31,30,31,30,31],l={"%a":function(h,a){return m[h["get"+(a?"UTC":"")+"Day"]()].substr(0,3)},"%A":function(h,a){return m[h["get"+(a?"UTC":"")+"Day"]()]},"%b":function(h,a){return n[h["get"+(a?"UTC":"")+"Month"]()].substr(0,3)},"%B":function(h,a){return n[h["get"+(a?"UTC":"")+"Month"]()]},"%c":function(h,a){return h["to"+(a?"UTC":"")+"LocaleString"]()},"%d":function(h,a){return("0"+h["get"+(a?"UTC":"")+"Date"]()).substr(-2)},"%H":function(h,a){return("0"+h["get"+(a?"UTC":"")+
"Hours"]()).substr(-2)},"%I":function(h,a){return("0"+((h["get"+(a?"UTC":"")+"Hours"]()+11)%12+1)).substr(-2)},"%j":function(h,a){for(var b=h["get"+(a?"UTC":"")+"Date"](),c=h["get"+(a?"UTC":"")+"Month"](),d=0;d<c;d++)b+=s[d];1<c&&0===h["get"+(a?"UTC":"")+"FullYear"]()%4&&(b+=1);return("00"+b).substr(-3)},"%m":function(h,a){return("0"+(h["get"+(a?"UTC":"")+"Month"]()+1)).substr(-2)},"%M":function(h,a){return("0"+h["get"+(a?"UTC":"")+"Minutes"]()).substr(-2)},"%p":function(h,a){return 12>h["get"+(a?
"UTC":"")+"Hours"]()?"AM":"PM"},"%S":function(h,a){return("0"+h["get"+(a?"UTC":"")+"Seconds"]()).substr(-2)},"%U":function(h,a){return e(h,0,a)},"%w":function(h,a){return""+h["get"+(a?"UTC":"")+"Day"]()},"%W":function(h,a){return e(h,1,a)},"%x":function(h,a){return l["%m"](h,a)+"/"+l["%d"](h,a)+"/"+l["%y"](h,a)},"%X":function(h,a){return l["%H"](h,a)+":"+l["%M"](h,a)+":"+l["%S"](h,a)},"%y":function(h,a){return l["%Y"](h,a).substr(-2)},"%Y":function(h,a){return""+h["get"+(a?"UTC":"")+"FullYear"]()},
"%Z":function(h,a){var b;return a&&"UTC"||(b=h.toString().match(/[A-Z][A-Z][A-Z]/))&&b[0]},"%%":function(){return"%"}},q=1,z;shine.lib={assert:function(a,b){if(!1===a||void 0===a)throw new shine.Error(b||"Assertion failed!");return[a,b]},collectgarbage:function(a,b){},dofile:function(a){},error:function(a){throw new shine.Error(a);},getfenv:function(a){},getmetatable:function(a){var b;if(a instanceof shine.Table)return(b=a.__shine.metatable)&&(b=b.__metatable)?b:a.__shine.metatable;if("string"==typeof a)return z},
ipairs:function(a){if(!((a||shine.EMPTY_OBJ)instanceof shine.Table))throw new shine.Error("Bad argument #1 in ipairs(). Table expected");return[function(a,h){if(void 0===h)throw new shine.Error("Bad argument #2 to ipairs() iterator");var b=h+1;return a.__shine.numValues.hasOwnProperty(b)?[b,a.__shine.numValues[b]]:void 0},a,0]},load:function(a,b){for(var c=d(this),e="",f;(f=a.apply(a))&&(f=f[0]);)e+=f;return shine.lib.loadstring.call(c,e)},loadfile:function(a){var b=d(this);b.suspend();c.call(b,a,
function(a){b.resume(a||[])})},loadstring:function(a,b){var c=d(this);if("string"!=typeof a)throw new shine.Error("bad argument #1 to 'loadstring' (string expected, got "+shine.utils.coerce(a,"string")+")");if(!a)return new shine.Function(c);c.suspend();c.fileManager.load(a,function(a,h){if(a)c.resume([]);else{var b=new shine.Function(c,h,h.data,c._globals,shine.gc.createArray());c.resume([b])}})},next:function(a,b){var c=void 0===b,d=a.__shine.numValues,e,f;if(c||"number"==typeof b)for(e=1,f=d.length;e<
f;e++)if(!c)e===b&&(c=!0);else if(d.hasOwnProperty(e)&&void 0!==d[e])return[e,d[e]];for(e in a)if(a.hasOwnProperty(e)&&!(e in shine.Table.prototype)&&"__shine"!==e)if(!c)e==b&&(c=!0);else if(a.hasOwnProperty(e)&&void 0!==a[e]&&"__"!=(""+e).substr(0,2))return[e,a[e]];for(e in a.__shine.keys)if(a.__shine.keys.hasOwnProperty(e))if(d=a.__shine.keys[e],!c)d===b&&(c=!0);else if(void 0!==a.__shine.values[e])return[d,a.__shine.values[e]];return shine.gc.createArray()},pairs:function(a){if(!((a||shine.EMPTY_OBJ)instanceof
shine.Table))throw new shine.Error("Bad argument #1 in pairs(). Table expected");return[shine.lib.next,a]},pcall:function(a){for(var b=shine.gc.createArray(),c,d=1,e=arguments.length;d<e;d++)b.push(arguments[d]);try{if("function"==typeof a)c=a.apply(null,b);else if((a||shine.EMPTY_OBJ)instanceof shine.Function)c=a.apply(null,b,!0);else throw new shine.Error("Attempt to call non-function");}catch(f){return[!1,f&&f.message||f]}(c||shine.EMPTY_OBJ)instanceof Array||(c=[c]);c.unshift(!0);return c},print:function(){for(var a=
shine.gc.createArray(),b=0,c=arguments.length;b<c;b++)a.push(shine.lib.tostring(arguments[b]));return shine.stdout.write(a.join("\t"))},rawequal:function(a,b){return a===b},rawget:function(a,b){if(!((a||shine.EMPTY_OBJ)instanceof shine.Table))throw new shine.Error("Bad argument #1 in rawget(). Table expected");return a[b]},rawset:function(a,b,c){if(!((a||shine.EMPTY_OBJ)instanceof shine.Table))throw new shine.Error("Bad argument #1 in rawset(). Table expected");if(void 0==b)throw new shine.Error("Bad argument #2 in rawset(). Nil not allowed");
a[b]=c;return a},require:function(a){function b(a){return function(){return e(a)}}function e(c){var d;k._resumeStack.length?d=k._resumeStack.pop()._run():shine.debug&&shine.debug._resumeStack.length?d=shine.debug._resumeStack.pop()._run():(g.loaded[a]=!0,d=c.call(null,a));if(k._status==shine.SUSPENDING&&!d)m._pc--,k._resumeStack.push(b(c));else if(shine.debug&&shine.debug._status==shine.SUSPENDING&&!d)m._pc--,shine.debug._resumeStack.push(b(c));else if(d)return l=d[0],void 0!==l&&g.loaded.setMember(a,
l),g.loaded[a]}function f(){if(v=q.shift())v=v.replace(/\?/g,a.replace(/\./g,"/")),c.call(k,v,function(b){b?(g.preload[a]=b,shine.Closure._current._pc--,k.resume()):(s.push("\tno file '"+v+"'"),f())});else throw new shine.Error("module '"+a+"' not found:\n\tno field package.preload['"+a+"']\n"+s.join("\n"));}var k=d(this),g=k._globals["package"],m=shine.Closure._current,l,n,q,v,s=shine.gc.createArray();a=shine.utils.coerce(a,"string");if(l=g.loaded[a])return l;if(n=g.preload[a])return e(n);q=g.path.replace(/;;/g,
";").split(";");k.suspend();f()},select:function(a){shine.gc.createArray();if("#"==a)return arguments.length-1;if(a=parseInt(a,10))return Array.prototype.slice.call(arguments,a);throw new shine.Error('bad argument #1 in select(). Number or "#" expected');},setmetatable:function(a,b){var c;if(!((a||shine.EMPTY_OBJ)instanceof shine.Table))throw new shine.Error("Bad argument #1 in setmetatable(). Table expected");if(!(void 0===b||(b||shine.EMPTY_OBJ)instanceof shine.Table))throw new shine.Error("Bad argument #2 in setmetatable(). Nil or table expected");
if((c=a.__shine.metatable)&&c.__metatable)throw new shine.Error("cannot change a protected metatable");shine.gc.incrRef(b);shine.gc.decrRef(a.__shine.metatable);a.__shine.metatable=b;return a},tonumber:function(a,b){var c;if(""!==a){b=b||10;if(2>b||36<b)throw new shine.Error("bad argument #2 to tonumber() (base out of range)");if(10==b&&(Infinity===a||-Infinity===a||"number"==typeof a&&window.isNaN(a)))return a;if(10!=b&&void 0==a)throw new shine.Error("bad argument #1 to 'tonumber' (string expected, got nil)");
a=(""+a).replace(/^\s+|\s+$/g,"");if(10==b)return shine.utils.coerce(a,"number");a=shine.utils.coerce(a,"string");16==b&&(c=a.match(/^(\-)?0[xX](.+)$/))&&(a=(c[1]||"")+c[2]);c=RegExp("^["+"0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".substr(0,b)+"]*$","gi");if(c.test(a))return parseInt(a,b)}},tostring:function(a){var b,c;return void 0!==a&&a instanceof shine.Table&&(b=a.__shine.metatable)&&(c=b.getMember("__tostring"))?c.call(c,a):a instanceof shine.Table||a instanceof shine.Function?a.toString():"function"==
typeof a?"function: [host code]":shine.utils.coerce(a,"string")||"userdata"},type:function(a){var b=typeof a;switch(b){case "undefined":return"nil";case "number":case "string":case "boolean":case "function":return b;case "object":return a.constructor===shine.Table?"table":(a||shine.EMPTY_OBJ)instanceof shine.Function?"function":"userdata"}},unpack:function(a,b,c){return shine.lib.table.unpack(a,b,c)},_VERSION:"Lua 5.1",xpcall:function(a,b){var c,d,e;try{"function"==typeof a?c=a.apply():(a||shine.EMPTY_OBJ)instanceof
shine.Function?c=a.apply(null,void 0,!0):e=!0,d=!0}catch(f){c=b.apply(null,void 0,!0),(c||shine.EMPTY_OBJ)instanceof Array&&(c=c[0]),d=!1}if(e)throw new shine.Error("Attempt to call non-function");(c||shine.EMPTY_OBJ)instanceof Array||(c=[c]);c.unshift(d);return c}};shine.lib.coroutine=new shine.Table({create:function(a){return shine.Coroutine.create(a)},resume:function(a){if(2>arguments.length)return a.resume.call(a);for(var b=shine.gc.createArray(),c=1,d=arguments.length;c<d;c++)b.push(arguments[c]);
return a.resume.apply(a,b)},running:function(){return d(this)._coroutineRunning},status:function(a){switch(a.status){case shine.RUNNING:return a===d()._coroutineRunning?"running":"normal";case shine.SUSPENDED:return"suspended";case shine.DEAD:return"dead"}},wrap:function(a){var b=shine.lib.coroutine.create(a),c=d(this);a=function(){for(var a=[b],d=0,h=arguments.length;d<h;d++)a.push(arguments[d]);if((a=shine.lib.coroutine.resume.apply(null,a))||!(c._status==shine.SUSPENDING||shine.debug&&shine.debug._status==
shine.SUSPENDING)){if(d=a.shift())return a;throw a[0];}};a._coroutine=b;return a},yield:function(){var a=d()._coroutineRunning,b;if(!a)throw new shine.Error("attempt to yield across metamethod/C-call boundary (not in coroutine)");if(a.status!=shine.RUNNING)throw new shine.Error("attempt to yield non-running coroutine in host");b=shine.gc.createArray();for(var c=0,e=arguments.length;c<e;c++)b.push(arguments[c]);a._yieldVars=b;a.status=shine.SUSPENDING;return{resume:function(){var b=[a],c,d=arguments.length,
e=function(){shine.lib.coroutine.resume.apply(void 0,b)};1==arguments.length&&void 0===arguments[0]&&(d=0);for(c=0;c<d;c++)b.push(arguments[c]);a.status==shine.SUSPENDING?window.setTimeout(e,1):e()}}}});shine.lib.debug=new shine.Table({debug:function(){},getfenv:function(a){},gethook:function(a){},getinfo:function(a,b,c){},getlocal:function(a,b,c){},getmetatable:function(a){},getregistry:function(){},getupvalue:function(a,b){},setfenv:function(a,b){},sethook:function(a,b,c,d){},setlocal:function(a,
b,c,d){},setmetatable:function(a,b){},setupvalue:function(a,b,c){},traceback:function(a,b,c){}});shine.lib.io=new shine.Table({close:function(a){if(a)throw new shine.Error("File operations currently not supported.");},flush:function(){},input:function(a){throw new shine.Error("File operations currently not supported.");},lines:function(a){throw new shine.Error("File operations currently not supported.");},open:function(a){throw new shine.Error("File operations currently not supported.");},output:function(a){throw new shine.Error("File operations currently not supported.");
},popen:function(a,b){throw new shine.Error("File operations currently not supported.");},read:function(){throw new shine.Error("File operations currently not supported.");},stderr:{},stdin:{},stdout:{},tmpfile:function(){throw new shine.Error("File operations currently not supported.");},type:function(){},write:function(){var a,b="";for(a in arguments)arguments.hasOwnProperty(a)&&(b+=shine.utils.coerce(arguments[a],"string","bad argument #"+a+" to 'write' (string expected, got %type)"));shine.stdout.write(b)}});
shine.lib.math=new shine.Table({abs:function(a){return Math.abs(a)},acos:function(a){return Math.acos(a)},asin:function(a){return Math.asin(a)},atan:function(a){return Math.atan(a)},atan2:function(a,b){return Math.atan2(a,b)},ceil:function(a){return Math.ceil(a)},cos:function(a){return Math.cos(a)},cosh:function(a){var b=shine.lib.math.exp;return(b(a)+b(-a))/2},deg:function(a){return 180*a/Math.PI},exp:function(a){return Math.exp(a)},floor:function(a){return Math.floor(a)},fmod:function(a,b){return a%
b},frexp:function(a){var b,c;if(0==a)return[0,0];b=0<a?1:-1;a*=b;c=Math.floor(Math.log(a)/Math.log(2))+1;return[a/Math.pow(2,c)*b,c]},huge:Infinity,ldexp:function(a,b){return a*Math.pow(2,b)},log:function(a,b){var c=Math.log(a);return void 0!==b?c/Math.log(b):c},log10:function(a){return Math.log(a)/Math.log(10)},max:function(){return Math.max.apply(Math,arguments)},min:function(){return Math.min.apply(Math,arguments)},modf:function(a){var b=Math.floor(a);return[b,a-b]},pi:Math.PI,pow:function(a,b){var c=
shine.utils.coerce;a=c(a,"number","bad argument #1 to 'pow' (number expected)");b=c(b,"number","bad argument #2 to 'pow' (number expected)");return Math.pow(a,b)},rad:function(a){a=shine.utils.coerce(a,"number","bad argument #1 to 'rad' (number expected)");return Math.PI/180*a},random:function(b,c){if(void 0===b&&void 0===c)return a();if("number"!==typeof b)throw new shine.Error("bad argument #1 to 'random' (number expected)");if(void 0===c)c=b,b=1;else if("number"!==typeof c)throw new shine.Error("bad argument #2 to 'random' (number expected)");
if(b>c)throw new shine.Error("bad argument #2 to 'random' (interval is empty)");return Math.floor(a()*(c-b+1)+b)},randomseed:function(a){if("number"!==typeof a)throw new shine.Error("bad argument #1 to 'randomseed' (number expected)");q=a},sin:function(a){return Math.sin(a)},sinh:function(a){var b=shine.lib.math.exp;return(b(a)-b(-a))/2},sqrt:function(a){return Math.sqrt(a)},tan:function(a){return Math.tan(a)},tanh:function(a){var b=shine.lib.math.exp;return(b(a)-b(-a))/(b(a)+b(-a))}});shine.lib.os=
new shine.Table({clock:function(){},date:function(a,b){void 0===a&&(a="%c");var c,d=new Date;b&&d.setTime(1E3*b);"!"===a.substr(0,1)&&(a=a.substr(1),c=!0);if("*t"===a){var e=shine.Table,f=parseInt(l["%Y"](d,c),10),k=parseInt(l["%m"](d,c),10),g=parseInt(l["%d"](d,c),10),m=parseInt(l["%H"](d,c),10),n=parseInt(l["%M"](d,c),10),q=parseInt(l["%S"](d,c),10),s=parseInt(l["%w"](d,c),10)+1;c=parseInt(l["%j"](d,c),10);var x=d.getFullYear(),x=new Date(x,0),d=d.getTimezoneOffset()!==x.getTimezoneOffset();return new e({year:f,
month:k,day:g,hour:m,min:n,sec:q,wday:s,yday:c,isdst:d})}for(e in l)l.hasOwnProperty(e)&&0<=a.indexOf(e)&&(a=a.replace(e,l[e](d,c)));return a},difftime:function(a,b){return a-b},execute:function(){if(arguments.length)throw new shine.Error("shell is not available. You should always check first by calling os.execute with no parameters");return 0},exit:function(a){throw new shine.Error("Execution terminated ["+(a||0)+"]");},getenv:function(){},remove:function(){},rename:function(){},setlocale:function(){},
time:function(a){if(a){var b,c,d,e,f,k;if(!(b=a.getMember("day")))throw new shine.Error("Field 'day' missing in date table");if(!(c=a.getMember("month")))throw new shine.Error("Field 'month' missing in date table");if(!(d=a.getMember("year")))throw new shine.Error("Field 'year' missing in date table");e=a.getMember("hour")||12;f=a.getMember("min")||0;k=a.getMember("sec")||0;a.getMember("isdst")&&e--;a=(new Date(d,c-1,b,e,f,k)).getTime()}else a=Date.now?Date.now():(new Date).getTime();return Math.floor(a/
1E3)},tmpname:function(){}});shine.lib["package"]=new shine.Table({cpath:void 0,loaded:new shine.Table,loadlib:function(a,b){},path:"?.lua.json;?.json;modules/?.lua.json;modules/?.json;modules/?/?.lua.json;modules/?/index.lua.json",preload:{},seeall:function(a){var b=d(this),c=new shine.Table;c.setMember("__index",b._globals);shine.lib.setmetatable(a,c)}});shine.lib.string=new shine.Table({"byte":function(a,b,c){b=b||1;c=c||b;for(var d=shine.gc.createArray(),e=a.length;b<=e&&b<=c;b++)d.push(a.charCodeAt(b-
1)||void 0);return d},"char":function(){for(var a="",b=0,c=arguments.length;b<c;b++)a+=String.fromCharCode(arguments[b]);return a},dump:function(a){return JSON.stringify(a._data)},find:function(a,c,d,e){if("string"!=typeof a&&"number"!=typeof a)throw new shine.Error("bad argument #1 to 'find' (string expected, got "+typeof a+")");if("string"!=typeof c&&"number"!=typeof c)throw new shine.Error("bad argument #2 to 'find' (string expected, got "+typeof c+")");a=""+a;d=d||1;if(void 0===e||!e){c=b(c);
c=RegExp(c);e=a.substr(d-1).search(c);if(0>e)return;a=a.substr(d-1).match(c);d=[e+d,e+d+a[0].length-1];a.shift();return d.concat(a)}e=a.indexOf(c,d-1);return-1===e?void 0:[e+1,e+c.length]},format:function(a){function b(a){var c=a[2],d=parseInt(a[5]);if(5<(""+c).length)throw new shine.Error("invalid format (repeated flags)");d||0===d||(d=Infinity);return{showSign:0<=c.indexOf("+"),prefix:0<=c.indexOf(" "),leftAlign:0<=c.indexOf("-"),alternateForm:0<=c.indexOf("#"),zeroPad:0<=c.indexOf("0"),minWidth:parseInt(a[3])||
0,hasPrecision:!!a[4],precision:d}}function c(a,b){return Array(b+1).join(a)}function d(a,b,e){var f;e.zeroPad&&!e.leftAlign&&0<(f=e.minWidth-a.length)&&((b||e.showSign||e.prefix)&&f--,a=c("0",f)+a);b?a="-"+a:e.showSign?a="+"+a:e.prefix&&(a=" "+a);return 0<(f=e.minWidth-a.length)?e.leftAlign?a+c(" ",f):c(" ",f)+a:a}function e(a){a=shine.utils.coerce(a,"number","bad argument #"+u+" to 'format' (number expected)");return String.fromCharCode(a)}function f(a){a=shine.utils.coerce(a,"number","bad argument #"+
u+" to 'format' (number expected)");var e=b(r),h=0>a,k;a=""+Math.floor(Math.abs(a));e.hasPrecision&&(Infinity!==e.precision&&0<(k=e.precision-a.length)&&(a=c("0",k)+a),e.zeroPad=!1);return d(a,h,e)}function k(a){a=shine.utils.coerce(a,"number","bad argument #"+u+" to 'format' (number expected)");var c=b(r),e=0>a,f=a-Math.floor(a),h=Infinity===c.precision?6:c.precision;a=""+Math.floor(Math.abs(a));0<h&&(a+="."+Math.round(f*Math.pow(10,h)));return d(a,e,c)}function g(a,d){a=shine.utils.coerce(a,"number",
"bad argument #"+u+" to 'format' (number expected)");var e=0>a;d=Math.pow(2,32);var f=b(r),h;a=Math.floor(a);e&&(a=d+a);a=a.toString(16);f.hasPrecision&&Infinity!==f.precision&&0<(h=f.precision-a.length)&&(a=c("0",h)+a);return 0<(h=f.minWidth-a.length)?f.leftAlign?a+c(" ",h):c(" ",h)+a:a}function l(a){a=shine.utils.coerce(a,"string");return'"'+a.replace(/([\n"])/g,"\\$1")+'"'}function m(a){var d=b(r),e;a=shine.utils.coerce(a,"string");a=a.substr(0,d.precision);return 0<(e=d.minWidth-a.length)?d.leftAlign?
a+c(" ",e):c(d.zeroPad?"0":" ",e)+a:a}function n(a){a=shine.utils.coerce(a,"number","bad argument #"+u+" to 'format' (number expected)");var e=0>a,f=Math.pow(2,32),h=b(r),k;a=Math.floor(a);e&&(a=f+a);a=a.toString(16);e&&(a=c("f",8)+a);h.hasPrecision&&Infinity!==h.precision&&0<(k=h.precision-a.length)&&(a=c("0",k)+a);h.alternateForm&&(a="0x"+a);h.showSign=h.prefix=!1;h.zeroPad=h.zeroPad&&h.hasPrecision;return a=d(a,!1,h)}var q=/^((.|\s)*?)(%)((.|\s)*)$/,s=/^(%?)([+\-#\ 0]*)(\d*)(\.(\d*))?([cdeEfgGiouqsxX])((.|\s)*)$/,
w,p="",r,t=[].splice.call(arguments,0),u=2,y=2;for(t.shift();w=(""+a).match(q);){for(p+=w[1];"%"!=w[y];)y++;r=(""+w[y+1]).match(s);if(r[1])p+="%"+r[2]+r[3]+(r[4]||"")+r[6];else switch(r[6]){case "c":p+=e(t.shift());break;case "d":p+=f(t.shift());break;case "f":p+=k(t.shift());break;case "q":p+=l(t.shift());break;case "o":p+=g(t.shift());break;case "s":p+=m(t.shift());break;case "x":p+=n(t.shift());break;case "X":p+=n(t.shift()).toUpperCase()}a=r[7];u++}return p+a},gmatch:function(a,c){c=b(c);var d=
(""+a).match(RegExp(c,"g"));return function(){var a=d.shift(),b=RegExp(c).exec(a);if(void 0!==a)return b.shift(),b.length?b:a}},gsub:function(a,c,d,e){if("string"!=typeof a&&"number"!=typeof a)throw new shine.Error("bad argument #1 to 'gsub' (string expected, got "+typeof a+")");if("string"!=typeof c&&"number"!=typeof c)throw new shine.Error("bad argument #2 to 'gsub' (string expected, got "+typeof c+")");if(void 0!==e&&void 0===(e=shine.utils.coerce(e,"number")))throw new shine.Error("bad argument #4 to 'gsub' (number expected, got "+
typeof e+")");a=""+a;c=b(""+c);for(var f=0,k="",g,l,m,n;(void 0===e||f<e)&&a&&(m=a.match(c));)"function"==typeof d||(d||shine.EMPTY_OBJ)instanceof shine.Function?(g=d.apply(null,[m[0]],!0),g instanceof Array&&(g=g[0]),void 0===g&&(g=m[0])):g=(d||shine.EMPTY_OBJ)instanceof shine.Table?d.getMember(m[0]):"object"==typeof d?d[m]:(""+d).replace(/%([0-9])/g,function(a,b){return m[b]}),l=0==m[0].length&&void 0===n?"":a.split(m[0],1)[0],n=m[0],k+=l+g,a=a.substr((l+n).length),f++;return[k+a,f]},len:function(a){a=
shine.utils.coerce(a,"string","bad argument #1 to 'len' (string expected, got %type)");return a.length},lower:function(a){if("string"!=typeof a&&"number"!=typeof a)throw new shine.Error("bad argument #1 to 'lower' (string expected, got "+typeof a+")");return(""+a).toLowerCase()},match:function(a,c,d){if("string"!=typeof a&&"number"!=typeof a)throw new shine.Error("bad argument #1 to 'match' (string expected, got "+typeof a+")");if("string"!=typeof c&&"number"!=typeof c)throw new shine.Error("bad argument #2 to 'match' (string expected, got "+
typeof c+")");a=(""+a).substr(d?d-1:0);if(a=a.match(RegExp(b(c)))){if(!a[1])return a[0];a.shift();return a}},rep:function(a,b){var c="",d;for(d=0;d<b;d++)c+=a;return c},reverse:function(a){var b="",c;for(c=a.length;0<=c;c--)b+=a.charAt(c);return b},sub:function(a,b,c){if("string"!=typeof a&&"number"!=typeof a)throw new shine.Error("Bad argument #1 to 'sub' (string expected, got "+typeof a+")");a=""+a;b=b||1;c=c||a.length;0<b?b-=1:0>b&&(b=a.length+b);0>c&&(c=a.length+c+1);return a.substring(b,c)},
upper:function(a){return a.toUpperCase()}});z=new shine.Table({__index:shine.lib.string});shine.lib.table=new shine.Table({concat:function(a,b,c,d){if(!((a||shine.EMPTY_OBJ)instanceof shine.Table))throw new shine.Error("Bad argument #1 to 'concat' (table expected)");b=b||"";c=c||1;d=d||shine.lib.table.maxn(a);return shine.gc.createArray().concat(a.__shine.numValues).splice(c,d-c+1).join(b)},getn:function(a){if(!((a||shine.EMPTY_OBJ)instanceof shine.Table))throw new shine.Error("Bad argument #1 in 'getn' (table expected)");
a=a.__shine.numValues;var b=shine.gc.createArray(),c,d=0;for(c in a)a.hasOwnProperty(c)&&(b[c]=!0);for(;b[d+1];)d++;if(0<d&&void 0===a[d]){for(c=0;1<d-c;)b=Math.floor((c+d)/2),void 0===a[b]?d=b:c=b;return c}return d},insert:function(a,b,c){if(!((a||shine.EMPTY_OBJ)instanceof shine.Table))throw new shine.Error("Bad argument #1 in table.insert(). Table expected");void 0==c?(c=b,b=a.__shine.numValues.length):b=shine.utils.coerce(b,"number","Bad argument #2 to 'insert' (number expected)");a.__shine.numValues.splice(b,
0,void 0);a.setMember(b,c)},maxn:function(a){if(!((a||shine.EMPTY_OBJ)instanceof shine.Table))throw new shine.Error("Bad argument #1 to 'maxn' (table expected)");return a.__shine.numValues.length-1},remove:function(a,b){if(!((a||shine.EMPTY_OBJ)instanceof shine.Table))throw new shine.Error("Bad argument #1 in table.remove(). Table expected");var c=shine.lib.table.getn(a),d=a.__shine.numValues,e;if(!(b>c)){void 0==b&&(b=c);for(e=d.splice(b,1);b<c&&void 0===d[b];)delete d[b++];return e}},sort:function(a,
b){if(!((a||shine.EMPTY_OBJ)instanceof shine.Table))throw new shine.Error("Bad argument #1 to 'sort' (table expected)");var c,d=a.__shine.numValues;if(b){if(!((b||shine.EMPTY_OBJ)instanceof shine.Function))throw new shine.Error("Bad argument #2 to 'sort' (function expected)");c=function(a,c){return b.apply(null,[a,c],!0)[0]?-1:1}}else c=function(a,b){return a<b?-1:1};d.shift();d.sort(c).unshift(void 0)},unpack:function(a,b,c){if(!((a||shine.EMPTY_OBJ)instanceof shine.Table))throw new shine.Error("Bad argument #1 to 'unpack' (table expected)");
b=b||1;void 0===c&&(c=shine.lib.table.getn(a));for(var d=shine.gc.createArray();b<=c;b++)d.push(a.getMember(b));return d}})})();"use strict";shine=shine||{};
(function(){var a=/^[-+]?[0-9]*\.?([0-9]+([eE][-+]?[0-9]+)?)?$/,d=/^(\-)?0x([0-9a-fA-F]*)\.?([0-9a-fA-F]*)$/;shine.utils={coerce:function(e,b,c){function k(){if(c)throw c=(""+c).replace(/\%type/gi,shine.lib.type(e)),new shine.Error(c);}var f,g;switch(b){case "boolean":return!(!1===e||void 0===e);case "string":switch(!0){case "string"==typeof e:return e;case void 0===e:case null===e:return"nil";case Infinity===e:return"inf";case -Infinity===e:return"-inf";case "number"==typeof e:case "boolean"==typeof e:return window.isNaN(e)?
"nan":""+e;default:return k()||""}case "number":switch(!0){case "number"==typeof e:return e;case void 0===e:return;case "inf"===e:return Infinity;case "-inf"===e:return-Infinity;case "nan"===e:return NaN;default:if((""+e).match(a))f=parseFloat(e);else if(b=(""+e).match(d))if(g=b[3],(f=b[2])||g)f=parseInt(f,16)||0,g&&(f+=parseInt(g,16)/Math.pow(16,g.length)),b[1]&&(f*=-1);void 0===f&&k();return f}default:throw new ReferenceError("Can not coerce to type: "+b);}},toObject:function(a){var b=0<shine.lib.table.getn(a),
b=shine.gc["create"+(b?"Array":"Object")](),c=a.__shine.numValues,d,f=c.length;for(d=1;d<f;d++)b[d-1]=(c[d]||shine.EMPTY_OBJ)instanceof shine.Table?shine.utils.toObject(c[d]):c[d];for(d in a)!a.hasOwnProperty(d)||d in shine.Table.prototype||"__shine"===d||(b[d]=(a[d]||shine.EMPTY_OBJ)instanceof shine.Table?shine.utils.toObject(a[d]):a[d]);return b},parseJSON:function(a){var b=function(a){for(var d in a)a.hasOwnProperty(d)&&("object"===typeof a[d]?a[d]=b(a[d]):null===a[d]&&(a[d]=void 0));return new shine.Table(a)};
return b(JSON.parse(a))},get:function(a,b,c){var d=new XMLHttpRequest,f;d.open("GET",a,!0);"ArrayBuffer"in window?(d.responseType="arraybuffer",f=function(a){if(1E4>=a.byteLength)return String.fromCharCode.apply(String,Array.prototype.slice.call(new Uint8Array(a)));var b,c=new Uint8Array(a),d="";b=0;for(a=a.byteLength;b<a;b+=1E4)d+=String.fromCharCode.apply(String,Array.prototype.slice.call(c.subarray(b,Math.min(b+1E4,a))));return d}):(d.responseType="text",f=function(a){return a});d.onload=function(a){200==
this.status?b&&b(f(this.response)):c&&c(this.status)};d.send(shine.EMPTY_OBJ)}}})();"use strict";shine=shine||{};shine.stdout={};shine.stdout.write=function(a){console&&console.log?console.log(a):trace&&trace(a)};shine.stddebug={};shine.stddebug.write=function(a){};shine.stderr={};shine.stderr.write=function(a,d){d=d||"error";if(console&&console[d])console[d](a)};var module=module;"undefined"!=typeof module&&(module.exports=shine);
