// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

using System.Collections.Generic;
using Xunit;

namespace System.Globalization.Tests
{
    public class NumberFormatInfoReadOnly
    {
        public static IEnumerable<object[]> ReadOnly_TestData()
        {
            yield return new object[] { new NumberFormatInfo(), false };
            yield return new object[] { new CultureInfo("en-US").NumberFormat, false };
            yield return new object[] { NumberFormatInfo.InvariantInfo, true };
        }

        [Theory]
        [MemberData(nameof(ReadOnly_TestData))]
        public void ReadOnly(NumberFormatInfo format, bool expected)
        {
            Assert.Equal(expected, format.IsReadOnly);

            NumberFormatInfo readOnlyFormat = NumberFormatInfo.ReadOnly(format);
            Assert.True(readOnlyFormat.IsReadOnly);
        }

        [Fact]
        public void ReadOnly_Null_ThrowsArgumentNullException()
        {
            Assert.Throws<ArgumentNullException>("nfi", () => NumberFormatInfo.ReadOnly(null));
        }
    }
}
