/*
 * Stroom Auth API
 * Various APIs for interacting with authentication, users, and tokens.
 *
 * OpenAPI spec version: v1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package stroom.auth.service.api.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

/**
 * A request to exchange an access code with an id token. This is the final step in the OpenID authentication flow and must be a back-channel call, i.e. the client secret should never be sent to a browser.
 */
@ApiModel(description = "A request to exchange an access code with an id token. This is the final step in the OpenID authentication flow and must be a back-channel call, i.e. the client secret should never be sent to a browser.")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-11-22T11:58:22.499Z")
public class IdTokenRequest {
  @SerializedName("clientId")
  private String clientId = null;

  @SerializedName("clientSecret")
  private String clientSecret = null;

  @SerializedName("accessCode")
  private String accessCode = null;

  public IdTokenRequest clientId(String clientId) {
    this.clientId = clientId;
    return this;
  }

   /**
   * The client id. This is a string that uniquely identifies the client.
   * @return clientId
  **/
  @ApiModelProperty(example = "null", required = true, value = "The client id. This is a string that uniquely identifies the client.")
  public String getClientId() {
    return clientId;
  }

  public void setClientId(String clientId) {
    this.clientId = clientId;
  }

  public IdTokenRequest clientSecret(String clientSecret) {
    this.clientSecret = clientSecret;
    return this;
  }

   /**
   * The client's secret. This is a cryptographically random string that authenticates the client.
   * @return clientSecret
  **/
  @ApiModelProperty(example = "null", required = true, value = "The client's secret. This is a cryptographically random string that authenticates the client.")
  public String getClientSecret() {
    return clientSecret;
  }

  public void setClientSecret(String clientSecret) {
    this.clientSecret = clientSecret;
  }

  public IdTokenRequest accessCode(String accessCode) {
    this.accessCode = accessCode;
    return this;
  }

   /**
   * The access code to exchange for an id token. This will have been provided to the RP after successfully authenticating, or if they were already authenticated
   * @return accessCode
  **/
  @ApiModelProperty(example = "null", required = true, value = "The access code to exchange for an id token. This will have been provided to the RP after successfully authenticating, or if they were already authenticated")
  public String getAccessCode() {
    return accessCode;
  }

  public void setAccessCode(String accessCode) {
    this.accessCode = accessCode;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    IdTokenRequest idTokenRequest = (IdTokenRequest) o;
    return Objects.equals(this.clientId, idTokenRequest.clientId) &&
        Objects.equals(this.clientSecret, idTokenRequest.clientSecret) &&
        Objects.equals(this.accessCode, idTokenRequest.accessCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(clientId, clientSecret, accessCode);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class IdTokenRequest {\n");
    
    sb.append("    clientId: ").append(toIndentedString(clientId)).append("\n");
    sb.append("    clientSecret: ").append(toIndentedString(clientSecret)).append("\n");
    sb.append("    accessCode: ").append(toIndentedString(accessCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

