/*
 *
 *   Copyright 2017 Crown Copyright
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
 */

package stroom.auth.resources.authentication.v1;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

@ApiModel(description = "A request to change a user's password.")
public class ChangePasswordRequest extends ResetPasswordRequest {

    @NotNull
    @ApiModelProperty(value = "The old password.", required = true)
    private String oldPassword;

    @NotNull
    @ApiModelProperty(value = "The email address of the user we're changing the password for.", required = true)
    private String email;

    public String getEmail() {
        return email;
    }

    public String getOldPassword() {
        return oldPassword;
    }
}
