package archive

import (
	"github.com/pydio/services/common/proto/jobs"
	. "github.com/smartystreets/goconvey/convey"
	"testing"
)

func TestExtractAction_GetName(t *testing.T) {
	Convey("Test GetName", t, func() {
		metaAction := &ExtractAction{}
		So(metaAction.GetName(), ShouldEqual, extractActionName)
	})
}

func TestExtractAction_Init(t *testing.T) {

	Convey("", t, func() {

		action := &ExtractAction{}
		job := &jobs.Job{}
		// Missing Parameters
		e := action.Init(job, nil, &jobs.Action{})
		So(action.Format, ShouldEqual, "zip")

		// Valid Cmd
		e = action.Init(job, nil, &jobs.Action{
			Parameters: map[string]string{
				"format": "tar.gz",
				"target": "path",
			},
		})
		So(e, ShouldBeNil)
		So(action.Format, ShouldEqual, "tar.gz")
		So(action.TargetName, ShouldEqual, "path")

	})
}
