package cmd

import (
	"github.com/pydio/services/common/proto/jobs"
	. "github.com/smartystreets/goconvey/convey"
	"golang.org/x/net/context"
	"testing"
)

func TestShellAction_GetName(t *testing.T) {
	Convey("Test GetName", t, func() {
		metaAction := &ShellAction{}
		So(metaAction.GetName(), ShouldEqual, shellActionName)
	})
}

func TestShellAction_Init(t *testing.T) {

	Convey("", t, func() {

		action := &ShellAction{}
		job := &jobs.Job{}
		// Missing Parameters
		e := action.Init(job, nil, &jobs.Action{})
		So(e, ShouldNotBeNil)

		// Valid Cmd
		e = action.Init(job, nil, &jobs.Action{
			Parameters: map[string]string{
				"cmd":           "pwd",
				"parameters":    "--param value --other",
				"inputTempFile": "true",
			},
		})
		So(e, ShouldBeNil)
		So(action.CmdBin, ShouldEqual, "pwd")
		So(action.CmdParameters, ShouldResemble, []string{"--param", "value", "--other"})
		So(action.UseTemporaryFolder, ShouldBeTrue)

	})
}

func TestShellAction_Run(t *testing.T) {

	Convey("", t, func() {

		action := &ShellAction{}
		job := &jobs.Job{}
		action.Init(job, nil, &jobs.Action{
			Parameters: map[string]string{
				"cmd":        "echo",
				"parameters": "HelloWorld",
			},
		})

		outputMessage, err := action.Run(context.Background(), jobs.ActionMessage{})
		So(err, ShouldBeNil)
		output := outputMessage.GetLastOutput()
		So(output, ShouldResemble, &jobs.ActionOutput{Success: true, StringBody: "HelloWorld\n"})

	})

}
