package cmd

import (
	"github.com/pborman/uuid"
	"github.com/pydio/services/common"
	"github.com/pydio/services/common/proto/jobs"
	"github.com/pydio/services/common/proto/tree"
	. "github.com/smartystreets/goconvey/convey"
	"golang.org/x/net/context"
	"net/url"
	"os"
	"path/filepath"
	"testing"
)

func TestWGetAction_GetName(t *testing.T) {
	Convey("Test GetName", t, func() {
		metaAction := &WGetAction{}
		So(metaAction.GetName(), ShouldEqual, wgetActionName)
	})
}

func TestWGetAction_Init(t *testing.T) {

	Convey("", t, func() {

		action := &WGetAction{}
		job := &jobs.Job{}
		// Missing Parameters
		e := action.Init(job, nil, &jobs.Action{})
		So(e, ShouldNotBeNil)

		// Invalid URL
		e = action.Init(job, nil, &jobs.Action{
			Parameters: map[string]string{
				"url": "htétp://",
			},
		})
		So(e, ShouldNotBeNil)

		// Valid URL
		e = action.Init(job, nil, &jobs.Action{
			Parameters: map[string]string{
				"url": "http://google.com",
			},
		})
		So(e, ShouldBeNil)
		So(action.SourceUrl, ShouldResemble, &url.URL{Scheme: "http", Host: "google.com"})

	})
}

func TestWGetAction_Run(t *testing.T) {

	Convey("", t, func() {

		action := &WGetAction{}
		job := &jobs.Job{}
		action.Init(job, nil, &jobs.Action{
			Parameters: map[string]string{
				"url": "http://pydio.com/sites/default/files/styles/desktop/public/Architecture.jpg",
			},
		})

		tmpDir := os.TempDir()
		uuidNode := uuid.NewUUID().String()

		node := &tree.Node{
			Path: "path/to/local/Architecture.jpg",
			Type: tree.NodeType_LEAF,
			Uuid: uuidNode,
		}
		node.SetMeta(common.META_NAMESPACE_NODE_TEST_LOCAL_FOLDER, tmpDir)

		action.Run(context.Background(), jobs.ActionMessage{
			Nodes: []*tree.Node{node},
		})

		savedFile := filepath.Join(tmpDir, uuidNode)
		fileInfo, err := os.Stat(savedFile)
		So(err, ShouldBeNil)
		defer os.Remove(savedFile)
		So(fileInfo.Size(), ShouldEqual, 29526)

	})

}
