package images

import (
	"encoding/json"
	"github.com/pborman/uuid"
	"github.com/pydio/services/common"
	"github.com/pydio/services/common/proto/jobs"
	"github.com/pydio/services/common/proto/tree"
	"github.com/pydio/services/common/views"
	. "github.com/smartystreets/goconvey/convey"
	"golang.org/x/net/context"
	"io/ioutil"
	"log"
	"os"
	"path/filepath"
	"testing"
)

func TestExifProcessor_GetName(t *testing.T) {
	Convey("Test GetName", t, func() {
		metaAction := &ExifProcessor{}
		So(metaAction.GetName(), ShouldEqual, exifTaskName)
	})
}

func TestExifProcessor_Init(t *testing.T) {

	Convey("", t, func() {

		action := &ExifProcessor{}
		job := &jobs.Job{}
		e := action.Init(job, nil, &jobs.Action{})
		So(e, ShouldBeNil)

	})
}

func TestExifProcessor_Run(t *testing.T) {

	Convey("", t, func() {

		action := &ExifProcessor{}
		job := &jobs.Job{}
		// Test action without parameters
		e := action.Init(job, nil, &jobs.Action{})
		So(e, ShouldBeNil)
		action.metaClient = views.NewHandlerMock()

		tmpDir := os.TempDir()
		uuidNode := uuid.NewUUID().String()
		testDir := filepath.Join(os.Getenv("GOPATH"), "src", "github.com", "pydio", "services", "scheduler", "actions", "images", "testdata")

		data, err := ioutil.ReadFile(filepath.Join(testDir, "exif.jpg"))
		So(err, ShouldBeNil)
		target := filepath.Join(tmpDir, uuidNode+".jpg")
		err = ioutil.WriteFile(target, data, 0755)
		log.Println(target)
		So(err, ShouldBeNil)
		defer os.Remove(target)

		node := &tree.Node{
			Path: "path/to/local/" + uuidNode + ".jpg",
			Type: tree.NodeType_LEAF,
			Uuid: uuidNode,
		}
		node.SetMeta("name", uuidNode+".jpg")
		node.SetMeta(common.META_NAMESPACE_DATASOURCE_NAME, "dsname")
		node.SetMeta(common.META_NAMESPACE_OBJECT_SERVICE, "fake")
		node.SetMeta(common.META_NAMESPACE_NODE_TEST_LOCAL_FOLDER, tmpDir)

		output, e := action.Run(context.Background(), jobs.ActionMessage{
			Nodes: []*tree.Node{node},
		})

		So(e, ShouldBeNil)
		So(output.Nodes, ShouldHaveLength, 1)
		outNode := output.Nodes[0]
		var exifMeta interface{}
		outNode.GetMeta(METADATA_EXIF, &exifMeta)
		//jsonData, _ := json.Marshal(exifMeta)

		referenceFile := filepath.Join(testDir, "exif.json")
		refData, refE := ioutil.ReadFile(referenceFile)
		So(refE, ShouldBeNil)

		var refStruct interface{}
		json.Unmarshal(refData, &refStruct)

		So(exifMeta, ShouldResemble, refStruct)

	})

}
