package tree

import (
	"github.com/pydio/services/common/proto/jobs"
	"github.com/pydio/services/common/proto/tree"
	"github.com/pydio/services/common/views"
	. "github.com/smartystreets/goconvey/convey"
	"golang.org/x/net/context"
	"testing"
)

func TestDeleteAction_GetName(t *testing.T) {
	Convey("Test GetName", t, func() {
		metaAction := &DeleteAction{}
		So(metaAction.GetName(), ShouldEqual, deleteActionName)
	})
}

func TestDeleteAction_Init(t *testing.T) {
	Convey("", t, func() {
		action := &DeleteAction{}
		job := &jobs.Job{}
		action.Init(job, nil, &jobs.Action{})
		So(action.Client, ShouldNotBeNil)
	})
}

func TestDeleteAction_Run(t *testing.T) {

	Convey("", t, func() {

		action := &DeleteAction{}
		job := &jobs.Job{}
		action.Init(job, nil, &jobs.Action{})
		mock := &views.HandlerMock{
			Nodes: map[string]*tree.Node{},
		}
		action.Client = mock
		ignored, err := action.Run(context.Background(), jobs.ActionMessage{
			Nodes: []*tree.Node{},
		})
		So(ignored.GetLastOutput(), ShouldResemble, &jobs.ActionOutput{Ignored: true})

		output, err := action.Run(context.Background(), jobs.ActionMessage{
			Nodes: []*tree.Node{&tree.Node{
				Path: "test",
			}},
		})
		So(err, ShouldBeNil)
		So(output.Nodes, ShouldHaveLength, 0)

		So(mock.Nodes, ShouldHaveLength, 1)
		So(mock.Nodes["in"], ShouldResemble, &tree.Node{
			Path: "test",
		})

	})
}
