package stan

import (
	"context"

	"github.com/micro/go-micro/broker"
)

// setSubscribeOption returns a function to setup a context with given value
func setSubscribeOption(k, v interface{}) broker.SubscribeOption {
	return func(o *broker.SubscribeOptions) {
		if o.Context == nil {
			o.Context = context.Background()
		}
		o.Context = context.WithValue(o.Context, k, v)
	}
}

// setBrokerOption returns a function to setup a context with given value
func setBrokerOption(k, v interface{}) broker.Option {
	return func(o *broker.Options) {
		if o.Context == nil {
			o.Context = context.Background()
		}
		o.Context = context.WithValue(o.Context, k, v)
	}
}

// // setBrokerOption returns a function to setup a context with given value
// func setServerSubscriberOption(k, v interface{}) server.SubscriberOption {
// 	return func(o *server.SubscriberOptions) {
// 		if o.Context == nil {
// 			o.Context = context.Background()
// 		}
// 		o.Context = context.WithValue(o.Context, k, v)
// 	}
// }

// setPublishOption returns a function to setup a context with given value
func setPublishOption(k, v interface{}) broker.PublishOption {
	return func(o *broker.PublishOptions) {
		if o.Context == nil {
			o.Context = context.Background()
		}
		o.Context = context.WithValue(o.Context, k, v)
	}
}
