// Code generated by protoc-gen-go. DO NOT EDIT.
// source: activitystream.proto

/*
Package activity is a generated protocol buffer package.

It is generated from these files:
	activitystream.proto

It has these top-level messages:
	Object
	PostActivityRequest
	PostActivityResponse
	PostActivityEvent
	StreamActivitiesRequest
	StreamActivitiesResponse
	Subscription
	SubscribeRequest
	SubscribeResponse
	SearchSubscriptionsRequest
	SearchSubscriptionsResponse
	UnreadActivitiesRequest
	UnreadActivitiesResponse
	UserLastActivityRequest
	UserLastActivityResponse
	PurgeActivitiesRequest
	PurgeActivitiesResponse
*/
package activity

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import google_protobuf "github.com/golang/protobuf/ptypes/timestamp"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type ObjectType int32

const (
	ObjectType_BaseObject ObjectType = 0
	ObjectType_Activity   ObjectType = 1
	ObjectType_Link       ObjectType = 47
	ObjectType_Mention    ObjectType = 48
	// CollectionTypes
	ObjectType_Collection            ObjectType = 49
	ObjectType_OrderedCollection     ObjectType = 50
	ObjectType_CollectionPage        ObjectType = 51
	ObjectType_OrderedCollectionPage ObjectType = 52
	// Actor Types
	ObjectType_Application  ObjectType = 2
	ObjectType_Group        ObjectType = 3
	ObjectType_Organization ObjectType = 4
	ObjectType_Person       ObjectType = 5
	ObjectType_Service      ObjectType = 6
	// Objects Types
	ObjectType_Article      ObjectType = 7
	ObjectType_Audio        ObjectType = 8
	ObjectType_Document     ObjectType = 9
	ObjectType_Event        ObjectType = 10
	ObjectType_Image        ObjectType = 11
	ObjectType_Note         ObjectType = 12
	ObjectType_Page         ObjectType = 13
	ObjectType_Place        ObjectType = 14
	ObjectType_Profile      ObjectType = 15
	ObjectType_Relationship ObjectType = 16
	ObjectType_Tombstone    ObjectType = 17
	ObjectType_Video        ObjectType = 18
	// Activity Types
	ObjectType_Accept          ObjectType = 19
	ObjectType_Add             ObjectType = 20
	ObjectType_Announce        ObjectType = 21
	ObjectType_Arrive          ObjectType = 22
	ObjectType_Block           ObjectType = 23
	ObjectType_Create          ObjectType = 24
	ObjectType_Delete          ObjectType = 25
	ObjectType_Dislike         ObjectType = 26
	ObjectType_Flag            ObjectType = 27
	ObjectType_Follow          ObjectType = 28
	ObjectType_Ignore          ObjectType = 29
	ObjectType_Invite          ObjectType = 30
	ObjectType_Join            ObjectType = 31
	ObjectType_Leave           ObjectType = 32
	ObjectType_Like            ObjectType = 33
	ObjectType_Listen          ObjectType = 34
	ObjectType_Move            ObjectType = 35
	ObjectType_Offer           ObjectType = 36
	ObjectType_Question        ObjectType = 37
	ObjectType_Reject          ObjectType = 38
	ObjectType_Read            ObjectType = 39
	ObjectType_Remove          ObjectType = 40
	ObjectType_TentativeReject ObjectType = 41
	ObjectType_TentativeAccept ObjectType = 42
	ObjectType_Travel          ObjectType = 43
	ObjectType_Undo            ObjectType = 44
	ObjectType_Update          ObjectType = 45
	ObjectType_UpdateComment   ObjectType = 58
	ObjectType_UpdateMeta      ObjectType = 59
	ObjectType_View            ObjectType = 46
	// Pydio Types
	ObjectType_Workspace ObjectType = 53
	ObjectType_Digest    ObjectType = 54
	ObjectType_Folder    ObjectType = 55
	ObjectType_Cell      ObjectType = 56
	ObjectType_Share     ObjectType = 57
)

var ObjectType_name = map[int32]string{
	0:  "BaseObject",
	1:  "Activity",
	47: "Link",
	48: "Mention",
	49: "Collection",
	50: "OrderedCollection",
	51: "CollectionPage",
	52: "OrderedCollectionPage",
	2:  "Application",
	3:  "Group",
	4:  "Organization",
	5:  "Person",
	6:  "Service",
	7:  "Article",
	8:  "Audio",
	9:  "Document",
	10: "Event",
	11: "Image",
	12: "Note",
	13: "Page",
	14: "Place",
	15: "Profile",
	16: "Relationship",
	17: "Tombstone",
	18: "Video",
	19: "Accept",
	20: "Add",
	21: "Announce",
	22: "Arrive",
	23: "Block",
	24: "Create",
	25: "Delete",
	26: "Dislike",
	27: "Flag",
	28: "Follow",
	29: "Ignore",
	30: "Invite",
	31: "Join",
	32: "Leave",
	33: "Like",
	34: "Listen",
	35: "Move",
	36: "Offer",
	37: "Question",
	38: "Reject",
	39: "Read",
	40: "Remove",
	41: "TentativeReject",
	42: "TentativeAccept",
	43: "Travel",
	44: "Undo",
	45: "Update",
	58: "UpdateComment",
	59: "UpdateMeta",
	46: "View",
	53: "Workspace",
	54: "Digest",
	55: "Folder",
	56: "Cell",
	57: "Share",
}
var ObjectType_value = map[string]int32{
	"BaseObject":            0,
	"Activity":              1,
	"Link":                  47,
	"Mention":               48,
	"Collection":            49,
	"OrderedCollection":     50,
	"CollectionPage":        51,
	"OrderedCollectionPage": 52,
	"Application":           2,
	"Group":                 3,
	"Organization":          4,
	"Person":                5,
	"Service":               6,
	"Article":               7,
	"Audio":                 8,
	"Document":              9,
	"Event":                 10,
	"Image":                 11,
	"Note":                  12,
	"Page":                  13,
	"Place":                 14,
	"Profile":               15,
	"Relationship":          16,
	"Tombstone":             17,
	"Video":                 18,
	"Accept":                19,
	"Add":                   20,
	"Announce":              21,
	"Arrive":                22,
	"Block":                 23,
	"Create":                24,
	"Delete":                25,
	"Dislike":               26,
	"Flag":                  27,
	"Follow":                28,
	"Ignore":                29,
	"Invite":                30,
	"Join":                  31,
	"Leave":                 32,
	"Like":                  33,
	"Listen":                34,
	"Move":                  35,
	"Offer":                 36,
	"Question":              37,
	"Reject":                38,
	"Read":                  39,
	"Remove":                40,
	"TentativeReject":       41,
	"TentativeAccept":       42,
	"Travel":                43,
	"Undo":                  44,
	"Update":                45,
	"UpdateComment":         58,
	"UpdateMeta":            59,
	"View":                  46,
	"Workspace":             53,
	"Digest":                54,
	"Folder":                55,
	"Cell":                  56,
	"Share":                 57,
}

func (x ObjectType) String() string {
	return proto.EnumName(ObjectType_name, int32(x))
}
func (ObjectType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

type StreamContext int32

const (
	StreamContext_MYFEED  StreamContext = 0
	StreamContext_USER_ID StreamContext = 1
	StreamContext_NODE_ID StreamContext = 2
)

var StreamContext_name = map[int32]string{
	0: "MYFEED",
	1: "USER_ID",
	2: "NODE_ID",
}
var StreamContext_value = map[string]int32{
	"MYFEED":  0,
	"USER_ID": 1,
	"NODE_ID": 2,
}

func (x StreamContext) String() string {
	return proto.EnumName(StreamContext_name, int32(x))
}
func (StreamContext) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

type SummaryPointOfView int32

const (
	SummaryPointOfView_GENERIC SummaryPointOfView = 0
	SummaryPointOfView_ACTOR   SummaryPointOfView = 1
	SummaryPointOfView_SUBJECT SummaryPointOfView = 2
)

var SummaryPointOfView_name = map[int32]string{
	0: "GENERIC",
	1: "ACTOR",
	2: "SUBJECT",
}
var SummaryPointOfView_value = map[string]int32{
	"GENERIC": 0,
	"ACTOR":   1,
	"SUBJECT": 2,
}

func (x SummaryPointOfView) String() string {
	return proto.EnumName(SummaryPointOfView_name, int32(x))
}
func (SummaryPointOfView) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

type OwnerType int32

const (
	OwnerType_NODE OwnerType = 0
	OwnerType_USER OwnerType = 1
)

var OwnerType_name = map[int32]string{
	0: "NODE",
	1: "USER",
}
var OwnerType_value = map[string]int32{
	"NODE": 0,
	"USER": 1,
}

func (x OwnerType) String() string {
	return proto.EnumName(OwnerType_name, int32(x))
}
func (OwnerType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

type Object struct {
	JsonLdContext string                     `protobuf:"bytes,53,opt,name=jsonLdContext,json=@context" json:"jsonLdContext,omitempty"`
	Type          ObjectType                 `protobuf:"varint,1,opt,name=type,enum=activity.ObjectType" json:"type,omitempty"`
	Id            string                     `protobuf:"bytes,2,opt,name=id" json:"id,omitempty"`
	Name          string                     `protobuf:"bytes,3,opt,name=name" json:"name,omitempty"`
	Summary       string                     `protobuf:"bytes,4,opt,name=summary" json:"summary,omitempty"`
	Markdown      string                     `protobuf:"bytes,62,opt,name=markdown" json:"markdown,omitempty"`
	Context       *Object                    `protobuf:"bytes,5,opt,name=context" json:"context,omitempty"`
	Attachment    *Object                    `protobuf:"bytes,6,opt,name=attachment" json:"attachment,omitempty"`
	AttributedTo  *Object                    `protobuf:"bytes,7,opt,name=attributedTo" json:"attributedTo,omitempty"`
	Audience      *Object                    `protobuf:"bytes,8,opt,name=audience" json:"audience,omitempty"`
	Content       *Object                    `protobuf:"bytes,9,opt,name=content" json:"content,omitempty"`
	StartTime     *google_protobuf.Timestamp `protobuf:"bytes,10,opt,name=startTime" json:"startTime,omitempty"`
	EndTime       *google_protobuf.Timestamp `protobuf:"bytes,11,opt,name=endTime" json:"endTime,omitempty"`
	Published     *google_protobuf.Timestamp `protobuf:"bytes,12,opt,name=published" json:"published,omitempty"`
	Updated       *google_protobuf.Timestamp `protobuf:"bytes,13,opt,name=updated" json:"updated,omitempty"`
	Duration      *google_protobuf.Timestamp `protobuf:"bytes,14,opt,name=duration" json:"duration,omitempty"`
	Url           *Object                    `protobuf:"bytes,15,opt,name=url" json:"url,omitempty"`
	MediaType     string                     `protobuf:"bytes,16,opt,name=mediaType" json:"mediaType,omitempty"`
	Icon          *Object                    `protobuf:"bytes,17,opt,name=icon" json:"icon,omitempty"`
	Image         *Object                    `protobuf:"bytes,18,opt,name=image" json:"image,omitempty"`
	Preview       *Object                    `protobuf:"bytes,19,opt,name=preview" json:"preview,omitempty"`
	Location      *Object                    `protobuf:"bytes,20,opt,name=location" json:"location,omitempty"`
	InReplyTo     *Object                    `protobuf:"bytes,21,opt,name=inReplyTo" json:"inReplyTo,omitempty"`
	Replies       *Object                    `protobuf:"bytes,22,opt,name=replies" json:"replies,omitempty"`
	Tag           *Object                    `protobuf:"bytes,23,opt,name=tag" json:"tag,omitempty"`
	Generator     *Object                    `protobuf:"bytes,24,opt,name=generator" json:"generator,omitempty"`
	To            *Object                    `protobuf:"bytes,25,opt,name=to" json:"to,omitempty"`
	Bto           *Object                    `protobuf:"bytes,26,opt,name=bto" json:"bto,omitempty"`
	Cc            *Object                    `protobuf:"bytes,27,opt,name=cc" json:"cc,omitempty"`
	Bcc           *Object                    `protobuf:"bytes,28,opt,name=bcc" json:"bcc,omitempty"`
	// Activity Properties
	Actor      *Object `protobuf:"bytes,29,opt,name=actor" json:"actor,omitempty"`
	Object     *Object `protobuf:"bytes,30,opt,name=object" json:"object,omitempty"`
	Target     *Object `protobuf:"bytes,31,opt,name=target" json:"target,omitempty"`
	Result     *Object `protobuf:"bytes,32,opt,name=result" json:"result,omitempty"`
	Origin     *Object `protobuf:"bytes,33,opt,name=origin" json:"origin,omitempty"`
	Instrument *Object `protobuf:"bytes,34,opt,name=instrument" json:"instrument,omitempty"`
	// Link Properties
	Href     string `protobuf:"bytes,35,opt,name=href" json:"href,omitempty"`
	Rel      string `protobuf:"bytes,36,opt,name=rel" json:"rel,omitempty"`
	Hreflang string `protobuf:"bytes,37,opt,name=hreflang" json:"hreflang,omitempty"`
	Height   int32  `protobuf:"varint,38,opt,name=height" json:"height,omitempty"`
	Width    int32  `protobuf:"varint,39,opt,name=width" json:"width,omitempty"`
	// Question Properties
	OneOf  *Object                    `protobuf:"bytes,40,opt,name=oneOf" json:"oneOf,omitempty"`
	AnyOf  *Object                    `protobuf:"bytes,41,opt,name=anyOf" json:"anyOf,omitempty"`
	Closed *google_protobuf.Timestamp `protobuf:"bytes,42,opt,name=closed" json:"closed,omitempty"`
	// Relationship Properties
	Subject      *Object `protobuf:"bytes,43,opt,name=subject" json:"subject,omitempty"`
	Relationship *Object `protobuf:"bytes,44,opt,name=relationship" json:"relationship,omitempty"`
	// Tombstone Properties
	FormerType ObjectType                 `protobuf:"varint,45,opt,name=formerType,enum=activity.ObjectType" json:"formerType,omitempty"`
	Deleted    *google_protobuf.Timestamp `protobuf:"bytes,46,opt,name=deleted" json:"deleted,omitempty"`
	// Place Properties
	Accuracy  float32 `protobuf:"fixed32,47,opt,name=accuracy" json:"accuracy,omitempty"`
	Altitude  float32 `protobuf:"fixed32,48,opt,name=altitude" json:"altitude,omitempty"`
	Latitude  float32 `protobuf:"fixed32,49,opt,name=latitude" json:"latitude,omitempty"`
	Longitude float32 `protobuf:"fixed32,50,opt,name=longitude" json:"longitude,omitempty"`
	Radius    float32 `protobuf:"fixed32,51,opt,name=radius" json:"radius,omitempty"`
	Units     string  `protobuf:"bytes,52,opt,name=units" json:"units,omitempty"`
	// Collection Properties
	Items      []*Object `protobuf:"bytes,54,rep,name=items" json:"items,omitempty"`
	TotalItems int32     `protobuf:"varint,55,opt,name=totalItems" json:"totalItems,omitempty"`
	Current    *Object   `protobuf:"bytes,56,opt,name=current" json:"current,omitempty"`
	First      *Object   `protobuf:"bytes,57,opt,name=first" json:"first,omitempty"`
	Last       *Object   `protobuf:"bytes,58,opt,name=last" json:"last,omitempty"`
	PartOf     *Object   `protobuf:"bytes,59,opt,name=partOf" json:"partOf,omitempty"`
	Next       *Object   `protobuf:"bytes,60,opt,name=next" json:"next,omitempty"`
	Prev       *Object   `protobuf:"bytes,61,opt,name=prev" json:"prev,omitempty"`
}

func (m *Object) Reset()                    { *m = Object{} }
func (m *Object) String() string            { return proto.CompactTextString(m) }
func (*Object) ProtoMessage()               {}
func (*Object) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *Object) GetJsonLdContext() string {
	if m != nil {
		return m.JsonLdContext
	}
	return ""
}

func (m *Object) GetType() ObjectType {
	if m != nil {
		return m.Type
	}
	return ObjectType_BaseObject
}

func (m *Object) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Object) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Object) GetSummary() string {
	if m != nil {
		return m.Summary
	}
	return ""
}

func (m *Object) GetMarkdown() string {
	if m != nil {
		return m.Markdown
	}
	return ""
}

func (m *Object) GetContext() *Object {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *Object) GetAttachment() *Object {
	if m != nil {
		return m.Attachment
	}
	return nil
}

func (m *Object) GetAttributedTo() *Object {
	if m != nil {
		return m.AttributedTo
	}
	return nil
}

func (m *Object) GetAudience() *Object {
	if m != nil {
		return m.Audience
	}
	return nil
}

func (m *Object) GetContent() *Object {
	if m != nil {
		return m.Content
	}
	return nil
}

func (m *Object) GetStartTime() *google_protobuf.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *Object) GetEndTime() *google_protobuf.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func (m *Object) GetPublished() *google_protobuf.Timestamp {
	if m != nil {
		return m.Published
	}
	return nil
}

func (m *Object) GetUpdated() *google_protobuf.Timestamp {
	if m != nil {
		return m.Updated
	}
	return nil
}

func (m *Object) GetDuration() *google_protobuf.Timestamp {
	if m != nil {
		return m.Duration
	}
	return nil
}

func (m *Object) GetUrl() *Object {
	if m != nil {
		return m.Url
	}
	return nil
}

func (m *Object) GetMediaType() string {
	if m != nil {
		return m.MediaType
	}
	return ""
}

func (m *Object) GetIcon() *Object {
	if m != nil {
		return m.Icon
	}
	return nil
}

func (m *Object) GetImage() *Object {
	if m != nil {
		return m.Image
	}
	return nil
}

func (m *Object) GetPreview() *Object {
	if m != nil {
		return m.Preview
	}
	return nil
}

func (m *Object) GetLocation() *Object {
	if m != nil {
		return m.Location
	}
	return nil
}

func (m *Object) GetInReplyTo() *Object {
	if m != nil {
		return m.InReplyTo
	}
	return nil
}

func (m *Object) GetReplies() *Object {
	if m != nil {
		return m.Replies
	}
	return nil
}

func (m *Object) GetTag() *Object {
	if m != nil {
		return m.Tag
	}
	return nil
}

func (m *Object) GetGenerator() *Object {
	if m != nil {
		return m.Generator
	}
	return nil
}

func (m *Object) GetTo() *Object {
	if m != nil {
		return m.To
	}
	return nil
}

func (m *Object) GetBto() *Object {
	if m != nil {
		return m.Bto
	}
	return nil
}

func (m *Object) GetCc() *Object {
	if m != nil {
		return m.Cc
	}
	return nil
}

func (m *Object) GetBcc() *Object {
	if m != nil {
		return m.Bcc
	}
	return nil
}

func (m *Object) GetActor() *Object {
	if m != nil {
		return m.Actor
	}
	return nil
}

func (m *Object) GetObject() *Object {
	if m != nil {
		return m.Object
	}
	return nil
}

func (m *Object) GetTarget() *Object {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *Object) GetResult() *Object {
	if m != nil {
		return m.Result
	}
	return nil
}

func (m *Object) GetOrigin() *Object {
	if m != nil {
		return m.Origin
	}
	return nil
}

func (m *Object) GetInstrument() *Object {
	if m != nil {
		return m.Instrument
	}
	return nil
}

func (m *Object) GetHref() string {
	if m != nil {
		return m.Href
	}
	return ""
}

func (m *Object) GetRel() string {
	if m != nil {
		return m.Rel
	}
	return ""
}

func (m *Object) GetHreflang() string {
	if m != nil {
		return m.Hreflang
	}
	return ""
}

func (m *Object) GetHeight() int32 {
	if m != nil {
		return m.Height
	}
	return 0
}

func (m *Object) GetWidth() int32 {
	if m != nil {
		return m.Width
	}
	return 0
}

func (m *Object) GetOneOf() *Object {
	if m != nil {
		return m.OneOf
	}
	return nil
}

func (m *Object) GetAnyOf() *Object {
	if m != nil {
		return m.AnyOf
	}
	return nil
}

func (m *Object) GetClosed() *google_protobuf.Timestamp {
	if m != nil {
		return m.Closed
	}
	return nil
}

func (m *Object) GetSubject() *Object {
	if m != nil {
		return m.Subject
	}
	return nil
}

func (m *Object) GetRelationship() *Object {
	if m != nil {
		return m.Relationship
	}
	return nil
}

func (m *Object) GetFormerType() ObjectType {
	if m != nil {
		return m.FormerType
	}
	return ObjectType_BaseObject
}

func (m *Object) GetDeleted() *google_protobuf.Timestamp {
	if m != nil {
		return m.Deleted
	}
	return nil
}

func (m *Object) GetAccuracy() float32 {
	if m != nil {
		return m.Accuracy
	}
	return 0
}

func (m *Object) GetAltitude() float32 {
	if m != nil {
		return m.Altitude
	}
	return 0
}

func (m *Object) GetLatitude() float32 {
	if m != nil {
		return m.Latitude
	}
	return 0
}

func (m *Object) GetLongitude() float32 {
	if m != nil {
		return m.Longitude
	}
	return 0
}

func (m *Object) GetRadius() float32 {
	if m != nil {
		return m.Radius
	}
	return 0
}

func (m *Object) GetUnits() string {
	if m != nil {
		return m.Units
	}
	return ""
}

func (m *Object) GetItems() []*Object {
	if m != nil {
		return m.Items
	}
	return nil
}

func (m *Object) GetTotalItems() int32 {
	if m != nil {
		return m.TotalItems
	}
	return 0
}

func (m *Object) GetCurrent() *Object {
	if m != nil {
		return m.Current
	}
	return nil
}

func (m *Object) GetFirst() *Object {
	if m != nil {
		return m.First
	}
	return nil
}

func (m *Object) GetLast() *Object {
	if m != nil {
		return m.Last
	}
	return nil
}

func (m *Object) GetPartOf() *Object {
	if m != nil {
		return m.PartOf
	}
	return nil
}

func (m *Object) GetNext() *Object {
	if m != nil {
		return m.Next
	}
	return nil
}

func (m *Object) GetPrev() *Object {
	if m != nil {
		return m.Prev
	}
	return nil
}

type PostActivityRequest struct {
	OwnerType OwnerType `protobuf:"varint,1,opt,name=OwnerType,enum=activity.OwnerType" json:"OwnerType,omitempty"`
	OwnerId   string    `protobuf:"bytes,2,opt,name=OwnerId" json:"OwnerId,omitempty"`
	BoxName   string    `protobuf:"bytes,3,opt,name=BoxName" json:"BoxName,omitempty"`
	Activity  *Object   `protobuf:"bytes,4,opt,name=Activity" json:"Activity,omitempty"`
}

func (m *PostActivityRequest) Reset()                    { *m = PostActivityRequest{} }
func (m *PostActivityRequest) String() string            { return proto.CompactTextString(m) }
func (*PostActivityRequest) ProtoMessage()               {}
func (*PostActivityRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *PostActivityRequest) GetOwnerType() OwnerType {
	if m != nil {
		return m.OwnerType
	}
	return OwnerType_NODE
}

func (m *PostActivityRequest) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *PostActivityRequest) GetBoxName() string {
	if m != nil {
		return m.BoxName
	}
	return ""
}

func (m *PostActivityRequest) GetActivity() *Object {
	if m != nil {
		return m.Activity
	}
	return nil
}

type PostActivityResponse struct {
	Success bool `protobuf:"varint,1,opt,name=Success" json:"Success,omitempty"`
}

func (m *PostActivityResponse) Reset()                    { *m = PostActivityResponse{} }
func (m *PostActivityResponse) String() string            { return proto.CompactTextString(m) }
func (*PostActivityResponse) ProtoMessage()               {}
func (*PostActivityResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *PostActivityResponse) GetSuccess() bool {
	if m != nil {
		return m.Success
	}
	return false
}

type PostActivityEvent struct {
	JsonType  string    `protobuf:"bytes,1,opt,name=jsonType,json=@type" json:"jsonType,omitempty"`
	OwnerType OwnerType `protobuf:"varint,2,opt,name=OwnerType,enum=activity.OwnerType" json:"OwnerType,omitempty"`
	OwnerId   string    `protobuf:"bytes,3,opt,name=OwnerId" json:"OwnerId,omitempty"`
	BoxName   string    `protobuf:"bytes,4,opt,name=BoxName" json:"BoxName,omitempty"`
	Activity  *Object   `protobuf:"bytes,5,opt,name=Activity" json:"Activity,omitempty"`
}

func (m *PostActivityEvent) Reset()                    { *m = PostActivityEvent{} }
func (m *PostActivityEvent) String() string            { return proto.CompactTextString(m) }
func (*PostActivityEvent) ProtoMessage()               {}
func (*PostActivityEvent) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *PostActivityEvent) GetJsonType() string {
	if m != nil {
		return m.JsonType
	}
	return ""
}

func (m *PostActivityEvent) GetOwnerType() OwnerType {
	if m != nil {
		return m.OwnerType
	}
	return OwnerType_NODE
}

func (m *PostActivityEvent) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *PostActivityEvent) GetBoxName() string {
	if m != nil {
		return m.BoxName
	}
	return ""
}

func (m *PostActivityEvent) GetActivity() *Object {
	if m != nil {
		return m.Activity
	}
	return nil
}

type StreamActivitiesRequest struct {
	// Define the context of the stream
	Context StreamContext `protobuf:"varint,1,opt,name=Context,enum=activity.StreamContext" json:"Context,omitempty"`
	// Value for the context (e.g. User Id, Node Id)
	ContextData string `protobuf:"bytes,2,opt,name=ContextData" json:"ContextData,omitempty"`
	// Json-encoded filter
	StreamFilter string `protobuf:"bytes,3,opt,name=StreamFilter" json:"StreamFilter,omitempty"`
	// Target inbox or outbox for the given object
	BoxName string `protobuf:"bytes,4,opt,name=BoxName" json:"BoxName,omitempty"`
	// Count last activities that were not loaded yet
	UnreadCountOnly bool `protobuf:"varint,5,opt,name=UnreadCountOnly" json:"UnreadCountOnly,omitempty"`
	// Start listing at a given position
	Offset int64 `protobuf:"varint,6,opt,name=Offset" json:"Offset,omitempty"`
	// Limit the number of results
	Limit int64 `protobuf:"varint,7,opt,name=Limit" json:"Limit,omitempty"`
	// Compute a digest of all unread activities
	AsDigest bool `protobuf:"varint,8,opt,name=AsDigest" json:"AsDigest,omitempty"`
	// Provide context for building the human-readable strings of each activity
	PointOfView SummaryPointOfView `protobuf:"varint,9,opt,name=PointOfView,enum=activity.SummaryPointOfView" json:"PointOfView,omitempty"`
	// Provide language information for building the human-readable strings.
	Language string `protobuf:"bytes,10,opt,name=Language" json:"Language,omitempty"`
}

func (m *StreamActivitiesRequest) Reset()                    { *m = StreamActivitiesRequest{} }
func (m *StreamActivitiesRequest) String() string            { return proto.CompactTextString(m) }
func (*StreamActivitiesRequest) ProtoMessage()               {}
func (*StreamActivitiesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *StreamActivitiesRequest) GetContext() StreamContext {
	if m != nil {
		return m.Context
	}
	return StreamContext_MYFEED
}

func (m *StreamActivitiesRequest) GetContextData() string {
	if m != nil {
		return m.ContextData
	}
	return ""
}

func (m *StreamActivitiesRequest) GetStreamFilter() string {
	if m != nil {
		return m.StreamFilter
	}
	return ""
}

func (m *StreamActivitiesRequest) GetBoxName() string {
	if m != nil {
		return m.BoxName
	}
	return ""
}

func (m *StreamActivitiesRequest) GetUnreadCountOnly() bool {
	if m != nil {
		return m.UnreadCountOnly
	}
	return false
}

func (m *StreamActivitiesRequest) GetOffset() int64 {
	if m != nil {
		return m.Offset
	}
	return 0
}

func (m *StreamActivitiesRequest) GetLimit() int64 {
	if m != nil {
		return m.Limit
	}
	return 0
}

func (m *StreamActivitiesRequest) GetAsDigest() bool {
	if m != nil {
		return m.AsDigest
	}
	return false
}

func (m *StreamActivitiesRequest) GetPointOfView() SummaryPointOfView {
	if m != nil {
		return m.PointOfView
	}
	return SummaryPointOfView_GENERIC
}

func (m *StreamActivitiesRequest) GetLanguage() string {
	if m != nil {
		return m.Language
	}
	return ""
}

type StreamActivitiesResponse struct {
	Activity *Object `protobuf:"bytes,1,opt,name=activity" json:"activity,omitempty"`
}

func (m *StreamActivitiesResponse) Reset()                    { *m = StreamActivitiesResponse{} }
func (m *StreamActivitiesResponse) String() string            { return proto.CompactTextString(m) }
func (*StreamActivitiesResponse) ProtoMessage()               {}
func (*StreamActivitiesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *StreamActivitiesResponse) GetActivity() *Object {
	if m != nil {
		return m.Activity
	}
	return nil
}

type Subscription struct {
	// Id of the user for this subscription
	UserId string `protobuf:"bytes,1,opt,name=UserId" json:"UserId,omitempty"`
	// Type of owner
	ObjectType OwnerType `protobuf:"varint,2,opt,name=ObjectType,enum=activity.OwnerType" json:"ObjectType,omitempty"`
	// If of the owner
	ObjectId string `protobuf:"bytes,3,opt,name=ObjectId" json:"ObjectId,omitempty"`
	// List of events to listen to
	Events []string `protobuf:"bytes,4,rep,name=Events" json:"Events,omitempty"`
}

func (m *Subscription) Reset()                    { *m = Subscription{} }
func (m *Subscription) String() string            { return proto.CompactTextString(m) }
func (*Subscription) ProtoMessage()               {}
func (*Subscription) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *Subscription) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *Subscription) GetObjectType() OwnerType {
	if m != nil {
		return m.ObjectType
	}
	return OwnerType_NODE
}

func (m *Subscription) GetObjectId() string {
	if m != nil {
		return m.ObjectId
	}
	return ""
}

func (m *Subscription) GetEvents() []string {
	if m != nil {
		return m.Events
	}
	return nil
}

type SubscribeRequest struct {
	// Place a new subscription
	Subscription *Subscription `protobuf:"bytes,1,opt,name=Subscription" json:"Subscription,omitempty"`
}

func (m *SubscribeRequest) Reset()                    { *m = SubscribeRequest{} }
func (m *SubscribeRequest) String() string            { return proto.CompactTextString(m) }
func (*SubscribeRequest) ProtoMessage()               {}
func (*SubscribeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *SubscribeRequest) GetSubscription() *Subscription {
	if m != nil {
		return m.Subscription
	}
	return nil
}

type SubscribeResponse struct {
	Subscription *Subscription `protobuf:"bytes,1,opt,name=Subscription" json:"Subscription,omitempty"`
}

func (m *SubscribeResponse) Reset()                    { *m = SubscribeResponse{} }
func (m *SubscribeResponse) String() string            { return proto.CompactTextString(m) }
func (*SubscribeResponse) ProtoMessage()               {}
func (*SubscribeResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *SubscribeResponse) GetSubscription() *Subscription {
	if m != nil {
		return m.Subscription
	}
	return nil
}

type SearchSubscriptionsRequest struct {
	// List of UserIds for which we want to list
	UserIds []string `protobuf:"bytes,1,rep,name=UserIds" json:"UserIds,omitempty"`
	// Filter by type of objects
	ObjectTypes []OwnerType `protobuf:"varint,2,rep,packed,name=ObjectTypes,enum=activity.OwnerType" json:"ObjectTypes,omitempty"`
	// Filter by object Ids
	ObjectIds []string `protobuf:"bytes,3,rep,name=ObjectIds" json:"ObjectIds,omitempty"`
}

func (m *SearchSubscriptionsRequest) Reset()                    { *m = SearchSubscriptionsRequest{} }
func (m *SearchSubscriptionsRequest) String() string            { return proto.CompactTextString(m) }
func (*SearchSubscriptionsRequest) ProtoMessage()               {}
func (*SearchSubscriptionsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *SearchSubscriptionsRequest) GetUserIds() []string {
	if m != nil {
		return m.UserIds
	}
	return nil
}

func (m *SearchSubscriptionsRequest) GetObjectTypes() []OwnerType {
	if m != nil {
		return m.ObjectTypes
	}
	return nil
}

func (m *SearchSubscriptionsRequest) GetObjectIds() []string {
	if m != nil {
		return m.ObjectIds
	}
	return nil
}

type SearchSubscriptionsResponse struct {
	Subscription *Subscription `protobuf:"bytes,1,opt,name=Subscription" json:"Subscription,omitempty"`
}

func (m *SearchSubscriptionsResponse) Reset()                    { *m = SearchSubscriptionsResponse{} }
func (m *SearchSubscriptionsResponse) String() string            { return proto.CompactTextString(m) }
func (*SearchSubscriptionsResponse) ProtoMessage()               {}
func (*SearchSubscriptionsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *SearchSubscriptionsResponse) GetSubscription() *Subscription {
	if m != nil {
		return m.Subscription
	}
	return nil
}

type UnreadActivitiesRequest struct {
	// Get the number of unread activities for this user
	UserId string `protobuf:"bytes,1,opt,name=UserId" json:"UserId,omitempty"`
}

func (m *UnreadActivitiesRequest) Reset()                    { *m = UnreadActivitiesRequest{} }
func (m *UnreadActivitiesRequest) String() string            { return proto.CompactTextString(m) }
func (*UnreadActivitiesRequest) ProtoMessage()               {}
func (*UnreadActivitiesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *UnreadActivitiesRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

type UnreadActivitiesResponse struct {
	Number int32 `protobuf:"varint,1,opt,name=number" json:"number,omitempty"`
}

func (m *UnreadActivitiesResponse) Reset()                    { *m = UnreadActivitiesResponse{} }
func (m *UnreadActivitiesResponse) String() string            { return proto.CompactTextString(m) }
func (*UnreadActivitiesResponse) ProtoMessage()               {}
func (*UnreadActivitiesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *UnreadActivitiesResponse) GetNumber() int32 {
	if m != nil {
		return m.Number
	}
	return 0
}

type UserLastActivityRequest struct {
	// Current user Id
	UserId string `protobuf:"bytes,1,opt,name=UserId" json:"UserId,omitempty"`
	// Inbox or Outbox
	BoxName string `protobuf:"bytes,2,opt,name=BoxName" json:"BoxName,omitempty"`
	// Id of the last known activity
	ActivityId string `protobuf:"bytes,3,opt,name=ActivityId" json:"ActivityId,omitempty"`
}

func (m *UserLastActivityRequest) Reset()                    { *m = UserLastActivityRequest{} }
func (m *UserLastActivityRequest) String() string            { return proto.CompactTextString(m) }
func (*UserLastActivityRequest) ProtoMessage()               {}
func (*UserLastActivityRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *UserLastActivityRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *UserLastActivityRequest) GetBoxName() string {
	if m != nil {
		return m.BoxName
	}
	return ""
}

func (m *UserLastActivityRequest) GetActivityId() string {
	if m != nil {
		return m.ActivityId
	}
	return ""
}

type UserLastActivityResponse struct {
	Success bool `protobuf:"varint,1,opt,name=Success" json:"Success,omitempty"`
}

func (m *UserLastActivityResponse) Reset()                    { *m = UserLastActivityResponse{} }
func (m *UserLastActivityResponse) String() string            { return proto.CompactTextString(m) }
func (*UserLastActivityResponse) ProtoMessage()               {}
func (*UserLastActivityResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *UserLastActivityResponse) GetSuccess() bool {
	if m != nil {
		return m.Success
	}
	return false
}

type PurgeActivitiesRequest struct {
	// ObjectType
	OwnerType OwnerType `protobuf:"varint,1,opt,name=OwnerType,enum=activity.OwnerType" json:"OwnerType,omitempty"`
	// Object Id, use * to browse all
	OwnerID string `protobuf:"bytes,2,opt,name=OwnerID" json:"OwnerID,omitempty"`
	// Box Name
	BoxName string `protobuf:"bytes,3,opt,name=BoxName" json:"BoxName,omitempty"`
	// Keep at least this number of records
	MinCount int32 `protobuf:"varint,4,opt,name=minCount" json:"minCount,omitempty"`
	// Keep max number of records
	MaxCount int32 `protobuf:"varint,5,opt,name=maxCount" json:"maxCount,omitempty"`
	// Remove records updated before...
	UpdatedBeforeTimestamp int32 `protobuf:"varint,6,opt,name=updatedBeforeTimestamp" json:"updatedBeforeTimestamp,omitempty"`
	// Trigger DB compaction after purge
	CompactDB bool `protobuf:"varint,8,opt,name=CompactDB" json:"CompactDB,omitempty"`
	// Clear original DB after compaction
	ClearBackups bool `protobuf:"varint,7,opt,name=ClearBackups" json:"ClearBackups,omitempty"`
}

func (m *PurgeActivitiesRequest) Reset()                    { *m = PurgeActivitiesRequest{} }
func (m *PurgeActivitiesRequest) String() string            { return proto.CompactTextString(m) }
func (*PurgeActivitiesRequest) ProtoMessage()               {}
func (*PurgeActivitiesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *PurgeActivitiesRequest) GetOwnerType() OwnerType {
	if m != nil {
		return m.OwnerType
	}
	return OwnerType_NODE
}

func (m *PurgeActivitiesRequest) GetOwnerID() string {
	if m != nil {
		return m.OwnerID
	}
	return ""
}

func (m *PurgeActivitiesRequest) GetBoxName() string {
	if m != nil {
		return m.BoxName
	}
	return ""
}

func (m *PurgeActivitiesRequest) GetMinCount() int32 {
	if m != nil {
		return m.MinCount
	}
	return 0
}

func (m *PurgeActivitiesRequest) GetMaxCount() int32 {
	if m != nil {
		return m.MaxCount
	}
	return 0
}

func (m *PurgeActivitiesRequest) GetUpdatedBeforeTimestamp() int32 {
	if m != nil {
		return m.UpdatedBeforeTimestamp
	}
	return 0
}

func (m *PurgeActivitiesRequest) GetCompactDB() bool {
	if m != nil {
		return m.CompactDB
	}
	return false
}

func (m *PurgeActivitiesRequest) GetClearBackups() bool {
	if m != nil {
		return m.ClearBackups
	}
	return false
}

type PurgeActivitiesResponse struct {
	// If request succeeded
	Success bool `protobuf:"varint,1,opt,name=Success" json:"Success,omitempty"`
	// Number of rows deleted
	DeletedCount int32 `protobuf:"varint,2,opt,name=DeletedCount" json:"DeletedCount,omitempty"`
}

func (m *PurgeActivitiesResponse) Reset()                    { *m = PurgeActivitiesResponse{} }
func (m *PurgeActivitiesResponse) String() string            { return proto.CompactTextString(m) }
func (*PurgeActivitiesResponse) ProtoMessage()               {}
func (*PurgeActivitiesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *PurgeActivitiesResponse) GetSuccess() bool {
	if m != nil {
		return m.Success
	}
	return false
}

func (m *PurgeActivitiesResponse) GetDeletedCount() int32 {
	if m != nil {
		return m.DeletedCount
	}
	return 0
}

func init() {
	proto.RegisterType((*Object)(nil), "activity.Object")
	proto.RegisterType((*PostActivityRequest)(nil), "activity.PostActivityRequest")
	proto.RegisterType((*PostActivityResponse)(nil), "activity.PostActivityResponse")
	proto.RegisterType((*PostActivityEvent)(nil), "activity.PostActivityEvent")
	proto.RegisterType((*StreamActivitiesRequest)(nil), "activity.StreamActivitiesRequest")
	proto.RegisterType((*StreamActivitiesResponse)(nil), "activity.StreamActivitiesResponse")
	proto.RegisterType((*Subscription)(nil), "activity.Subscription")
	proto.RegisterType((*SubscribeRequest)(nil), "activity.SubscribeRequest")
	proto.RegisterType((*SubscribeResponse)(nil), "activity.SubscribeResponse")
	proto.RegisterType((*SearchSubscriptionsRequest)(nil), "activity.SearchSubscriptionsRequest")
	proto.RegisterType((*SearchSubscriptionsResponse)(nil), "activity.SearchSubscriptionsResponse")
	proto.RegisterType((*UnreadActivitiesRequest)(nil), "activity.UnreadActivitiesRequest")
	proto.RegisterType((*UnreadActivitiesResponse)(nil), "activity.UnreadActivitiesResponse")
	proto.RegisterType((*UserLastActivityRequest)(nil), "activity.UserLastActivityRequest")
	proto.RegisterType((*UserLastActivityResponse)(nil), "activity.UserLastActivityResponse")
	proto.RegisterType((*PurgeActivitiesRequest)(nil), "activity.PurgeActivitiesRequest")
	proto.RegisterType((*PurgeActivitiesResponse)(nil), "activity.PurgeActivitiesResponse")
	proto.RegisterEnum("activity.ObjectType", ObjectType_name, ObjectType_value)
	proto.RegisterEnum("activity.StreamContext", StreamContext_name, StreamContext_value)
	proto.RegisterEnum("activity.SummaryPointOfView", SummaryPointOfView_name, SummaryPointOfView_value)
	proto.RegisterEnum("activity.OwnerType", OwnerType_name, OwnerType_value)
}

func init() { proto.RegisterFile("activitystream.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 2246 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x58, 0xdd, 0x56, 0x1b, 0xc9,
	0xf1, 0x47, 0x12, 0x02, 0xa9, 0xf9, 0x6a, 0x1a, 0x0c, 0xbd, 0xf2, 0x97, 0xac, 0xb5, 0xbd, 0x2c,
	0xeb, 0xc5, 0x36, 0xc6, 0x5e, 0xdb, 0xfb, 0xff, 0xef, 0x59, 0x40, 0x78, 0xc3, 0x1e, 0x8c, 0xd8,
	0x01, 0x76, 0xb3, 0x17, 0x49, 0x4e, 0x33, 0x53, 0x12, 0xbd, 0x8c, 0xa6, 0x95, 0x9e, 0x1e, 0x6c,
	0xf2, 0x0a, 0xb9, 0x48, 0x1e, 0x22, 0x57, 0xb9, 0xcb, 0x23, 0xe4, 0xa1, 0x72, 0x97, 0x8b, 0x9c,
	0xea, 0x99, 0x91, 0x46, 0x88, 0x81, 0x93, 0x8f, 0xbb, 0xa9, 0xaa, 0x5f, 0x55, 0xd7, 0x57, 0x57,
	0x97, 0x44, 0x16, 0x85, 0x6b, 0xe4, 0xb9, 0x34, 0x17, 0xa1, 0xd1, 0x20, 0xba, 0x6b, 0x3d, 0xad,
	0x8c, 0x62, 0x95, 0x94, 0x5b, 0xbb, 0xdf, 0x51, 0xaa, 0xe3, 0xc3, 0x53, 0xcb, 0x3f, 0x89, 0xda,
	0x4f, 0x8d, 0xec, 0x42, 0x68, 0x44, 0xb7, 0x17, 0x43, 0x1b, 0xff, 0x60, 0x64, 0xa2, 0x75, 0xf2,
	0x0b, 0xb8, 0x86, 0xdd, 0x27, 0x33, 0xbf, 0x84, 0x2a, 0xd8, 0xf3, 0xb6, 0x55, 0x60, 0xe0, 0xa3,
	0xe1, 0x2f, 0xeb, 0x85, 0x95, 0xaa, 0x53, 0xf9, 0xd6, 0x8d, 0x69, 0xb6, 0x42, 0xc6, 0xcd, 0x45,
	0x0f, 0x78, 0xa1, 0x5e, 0x58, 0x99, 0x5d, 0x5f, 0x5c, 0x4b, 0x4f, 0x59, 0x8b, 0x0d, 0x1c, 0x5d,
	0xf4, 0xc0, 0xb1, 0x08, 0x36, 0x4b, 0x8a, 0xd2, 0xe3, 0x45, 0xab, 0x5f, 0x94, 0x1e, 0x63, 0x64,
	0x3c, 0x10, 0x5d, 0xe0, 0x25, 0xcb, 0xb1, 0xdf, 0x8c, 0x93, 0xc9, 0x30, 0xea, 0x76, 0x85, 0xbe,
	0xe0, 0xe3, 0x96, 0x9d, 0x92, 0xac, 0x46, 0x2a, 0x5d, 0xa1, 0xcf, 0x3c, 0xf5, 0x21, 0xe0, 0xdf,
	0xc4, 0x3e, 0xa4, 0x34, 0x5b, 0x25, 0x93, 0x89, 0x3b, 0xbc, 0x5c, 0x2f, 0xac, 0x4c, 0xad, 0xd3,
	0xcb, 0x6e, 0x38, 0x29, 0x80, 0x3d, 0x23, 0x44, 0x18, 0x23, 0xdc, 0xd3, 0x2e, 0x04, 0x86, 0x4f,
	0xe4, 0xc0, 0x33, 0x18, 0xb6, 0x41, 0xa6, 0x85, 0x31, 0x5a, 0x9e, 0x44, 0x06, 0xbc, 0x23, 0xc5,
	0x27, 0x73, 0x74, 0x86, 0x50, 0xec, 0x09, 0xa9, 0x88, 0xc8, 0x93, 0x10, 0xb8, 0xc0, 0x2b, 0x39,
	0x1a, 0x7d, 0x44, 0x3f, 0x82, 0xc0, 0xf0, 0xea, 0xb5, 0x11, 0x04, 0x86, 0xbd, 0x26, 0xd5, 0xd0,
	0x08, 0x6d, 0x8e, 0x64, 0x17, 0x38, 0xb1, 0xe8, 0xda, 0x5a, 0x5c, 0xd2, 0xb5, 0xb4, 0xa4, 0x6b,
	0x47, 0x69, 0x49, 0x9d, 0x01, 0x98, 0x6d, 0x90, 0x49, 0x08, 0x3c, 0xab, 0x37, 0x75, 0xa3, 0x5e,
	0x0a, 0xc5, 0xf3, 0x7a, 0xd1, 0x89, 0x2f, 0xc3, 0x53, 0xf0, 0xf8, 0xf4, 0xcd, 0xe7, 0xf5, 0xc1,
	0x78, 0x5e, 0xd4, 0xf3, 0x84, 0x01, 0x8f, 0xcf, 0xdc, 0x7c, 0x5e, 0x02, 0x65, 0xaf, 0x48, 0xc5,
	0x8b, 0xb4, 0x30, 0x52, 0x05, 0x7c, 0xf6, 0x46, 0xb5, 0x3e, 0x96, 0x35, 0x48, 0x29, 0xd2, 0x3e,
	0x9f, 0xcb, 0xc9, 0x1f, 0x0a, 0xd9, 0x1d, 0x52, 0xed, 0x82, 0x27, 0x05, 0xb6, 0x25, 0xa7, 0xb6,
	0x8d, 0x06, 0x0c, 0xf6, 0x90, 0x8c, 0x4b, 0x57, 0x05, 0x7c, 0x3e, 0xc7, 0x84, 0x95, 0xb2, 0xc7,
	0xa4, 0x2c, 0xbb, 0xa2, 0x03, 0x9c, 0xe5, 0xc0, 0x62, 0x31, 0xd6, 0xb4, 0xa7, 0xe1, 0x5c, 0xc2,
	0x07, 0xbe, 0x90, 0x57, 0xd3, 0x04, 0x80, 0xdd, 0xe2, 0x2b, 0x37, 0x8e, 0x79, 0x31, 0xaf, 0x5b,
	0x52, 0x04, 0x5b, 0x23, 0x55, 0x19, 0x38, 0xd0, 0xf3, 0x2f, 0x8e, 0x14, 0xbf, 0x95, 0x03, 0x1f,
	0x40, 0xd0, 0x13, 0x0d, 0x3d, 0x5f, 0x42, 0xc8, 0x97, 0xf2, 0x3c, 0x49, 0x00, 0x98, 0x45, 0x23,
	0x3a, 0x7c, 0x39, 0x2f, 0x8b, 0x46, 0x74, 0xf0, 0xfc, 0x0e, 0x04, 0xa0, 0x85, 0x51, 0x9a, 0xf3,
	0xbc, 0xf3, 0xfb, 0x10, 0x56, 0x27, 0x45, 0xa3, 0xf8, 0x27, 0x39, 0xc0, 0xa2, 0x51, 0x78, 0xea,
	0x89, 0x51, 0xbc, 0x96, 0x77, 0xea, 0x89, 0x51, 0x68, 0xc5, 0x75, 0xf9, 0xed, 0x3c, 0x2b, 0xae,
	0x6b, 0xad, 0xb8, 0x2e, 0xbf, 0x93, 0x6b, 0xc5, 0x75, 0xb1, 0x7a, 0xc2, 0x45, 0xbf, 0xef, 0xe6,
	0x55, 0xcf, 0x8a, 0xd9, 0x0a, 0x99, 0x50, 0x96, 0xc1, 0xef, 0xe5, 0x00, 0x13, 0x39, 0x22, 0x8d,
	0xd0, 0x1d, 0x30, 0xfc, 0x7e, 0x1e, 0x32, 0x96, 0x23, 0x52, 0x43, 0x18, 0xf9, 0x86, 0xd7, 0xf3,
	0x90, 0xb1, 0xdc, 0x9e, 0xae, 0x65, 0x47, 0x06, 0xfc, 0x41, 0xee, 0xe9, 0x56, 0x8e, 0xf3, 0x4c,
	0x06, 0xa1, 0xd1, 0x91, 0x9d, 0x67, 0x8d, 0xbc, 0x79, 0x36, 0xc0, 0xe0, 0xdc, 0x3d, 0xd5, 0xd0,
	0xe6, 0x9f, 0xc6, 0x73, 0x17, 0xbf, 0x19, 0x25, 0x25, 0x0d, 0x3e, 0x7f, 0x68, 0x59, 0xf8, 0x89,
	0xf3, 0x16, 0x25, 0xbe, 0x08, 0x3a, 0xfc, 0x51, 0x3c, 0x6f, 0x53, 0x9a, 0x2d, 0x91, 0x89, 0x53,
	0x90, 0x9d, 0x53, 0xc3, 0x1f, 0xd7, 0x0b, 0x2b, 0x65, 0x27, 0xa1, 0xd8, 0x22, 0x29, 0x7f, 0x90,
	0x9e, 0x39, 0xe5, 0x9f, 0x59, 0x76, 0x4c, 0x60, 0xc6, 0x55, 0x00, 0xad, 0x36, 0x5f, 0xc9, 0xcb,
	0xb8, 0x15, 0xdb, 0xca, 0x04, 0x17, 0xad, 0x36, 0xff, 0x3c, 0xb7, 0x32, 0x28, 0x66, 0xeb, 0x64,
	0xc2, 0xf5, 0x55, 0x08, 0x1e, 0x5f, 0xbd, 0x71, 0x3a, 0x24, 0x48, 0xbc, 0x01, 0x61, 0x14, 0x97,
	0xf3, 0x8b, 0xbc, 0x1b, 0x90, 0x00, 0x70, 0xde, 0x6b, 0xf0, 0xed, 0x4d, 0x0b, 0x4f, 0x65, 0x8f,
	0x3f, 0xc9, 0x9b, 0xf7, 0x59, 0x14, 0xdb, 0x20, 0xa4, 0xad, 0x74, 0x17, 0xb4, 0x1d, 0x2d, 0x5f,
	0x5e, 0xf3, 0x1a, 0x66, 0x70, 0x38, 0x21, 0x3d, 0xf0, 0x01, 0x27, 0xe4, 0xda, 0xcd, 0x13, 0x32,
	0x81, 0x62, 0x6d, 0x84, 0xeb, 0x46, 0x5a, 0xb8, 0x17, 0xfc, 0x69, 0xbd, 0xb0, 0x52, 0x74, 0xfa,
	0xb4, 0x95, 0xf9, 0x46, 0x9a, 0xc8, 0x03, 0xfe, 0x2c, 0x91, 0x25, 0x34, 0xca, 0xd0, 0x63, 0x2b,
	0x7b, 0x1e, 0xcb, 0x52, 0x1a, 0x27, 0xa3, 0xaf, 0x82, 0x4e, 0x2c, 0x5c, 0xb7, 0xc2, 0x01, 0x03,
	0x2b, 0xae, 0x85, 0x27, 0xa3, 0x90, 0xbf, 0xb0, 0xa2, 0x84, 0xc2, 0x8a, 0x47, 0x81, 0x34, 0x21,
	0xdf, 0xb0, 0x2d, 0x12, 0x13, 0x76, 0x42, 0x1a, 0xe8, 0x86, 0xfc, 0x55, 0xbd, 0x94, 0x33, 0x21,
	0x51, 0xcc, 0xee, 0x11, 0x62, 0x94, 0x11, 0xfe, 0xae, 0x05, 0x7f, 0x65, 0x9b, 0x26, 0xc3, 0xb1,
	0xaf, 0x62, 0xa4, 0x35, 0x36, 0xf6, 0xeb, 0xdc, 0x57, 0x31, 0x06, 0xe0, 0x99, 0x6d, 0xa9, 0x43,
	0xc3, 0xdf, 0xe4, 0x75, 0x8f, 0x15, 0xe3, 0x8c, 0xf7, 0x45, 0x68, 0xf8, 0xdb, 0xbc, 0x19, 0x8f,
	0x52, 0xbc, 0x7f, 0x3d, 0xa1, 0x4d, 0xab, 0xcd, 0xbf, 0xce, 0xbb, 0x7f, 0xb1, 0x1c, 0xed, 0x05,
	0xb8, 0x78, 0xfc, 0x5f, 0x9e, 0x3d, 0x94, 0x22, 0x0a, 0x47, 0x3d, 0xff, 0xff, 0x3c, 0x14, 0x4a,
	0x1b, 0x7f, 0x2d, 0x90, 0x85, 0x03, 0x15, 0x9a, 0xcd, 0x44, 0xea, 0xc0, 0xef, 0x23, 0x08, 0x0d,
	0x7b, 0x4e, 0xaa, 0xad, 0x0f, 0x41, 0xd2, 0x5a, 0xf1, 0xa2, 0xb5, 0x90, 0x31, 0x91, 0x8a, 0x9c,
	0x01, 0x0a, 0x17, 0x29, 0x4b, 0xec, 0xa6, 0x1b, 0x57, 0x4a, 0xa2, 0x64, 0x4b, 0x7d, 0xdc, 0x1f,
	0x6c, 0x5e, 0x29, 0x89, 0x8f, 0x50, 0x7a, 0xb2, 0xdd, 0xbe, 0xae, 0x7c, 0x84, 0x52, 0x44, 0xe3,
	0x19, 0x59, 0x1c, 0xf6, 0x35, 0xec, 0xa9, 0x20, 0xb4, 0x27, 0x1f, 0x46, 0xae, 0x0b, 0x61, 0x68,
	0x5d, 0xad, 0x38, 0x29, 0xd9, 0xf8, 0x7b, 0x81, 0xcc, 0x67, 0x55, 0x76, 0xce, 0xb1, 0x70, 0xcb,
	0xa4, 0x82, 0x1b, 0x66, 0x3f, 0xb6, 0xaa, 0x53, 0xfe, 0xd6, 0xee, 0x8b, 0x43, 0x51, 0x17, 0xff,
	0xdd, 0xa8, 0x4b, 0xb9, 0x51, 0x8f, 0xe7, 0x47, 0x5d, 0xbe, 0x31, 0xea, 0x7f, 0x16, 0xc9, 0xf2,
	0xa1, 0x5d, 0xab, 0x13, 0x96, 0x84, 0x70, 0x50, 0xa6, 0xc9, 0x74, 0x4b, 0x8e, 0x8b, 0xb4, 0x3c,
	0x30, 0x14, 0xeb, 0x24, 0x62, 0x27, 0xc5, 0xb1, 0x3a, 0x99, 0x4a, 0x3e, 0x9b, 0xc2, 0x88, 0xa4,
	0x54, 0x59, 0x16, 0x6b, 0x90, 0xe9, 0x58, 0xf7, 0x9d, 0xf4, 0x0d, 0xe8, 0x24, 0xae, 0x21, 0xde,
	0x35, 0xc1, 0xad, 0x90, 0xb9, 0xe3, 0x40, 0x83, 0xf0, 0xb6, 0x55, 0x14, 0x98, 0x56, 0xe0, 0xc7,
	0x31, 0x56, 0x9c, 0xcb, 0x6c, 0xbc, 0xe1, 0xad, 0x76, 0x3b, 0x84, 0x78, 0x27, 0x2e, 0x39, 0x09,
	0x85, 0x37, 0x7c, 0x4f, 0x76, 0xa5, 0xb1, 0x6b, 0x6f, 0xc9, 0x89, 0x09, 0x9c, 0x24, 0x9b, 0x61,
	0x53, 0x76, 0x20, 0x34, 0x76, 0xbb, 0xad, 0x38, 0x7d, 0x9a, 0x7d, 0x43, 0xa6, 0x0e, 0x94, 0x0c,
	0x4c, 0xab, 0xfd, 0x23, 0xee, 0x3e, 0x55, 0x9b, 0x8a, 0x3b, 0x99, 0x54, 0xc4, 0x1b, 0x7d, 0x06,
	0xe3, 0x64, 0x15, 0xd0, 0xf6, 0x9e, 0x08, 0x3a, 0x11, 0xae, 0x58, 0x24, 0x7e, 0x79, 0x52, 0xba,
	0xf1, 0x2b, 0xc2, 0x47, 0xb3, 0x9f, 0x34, 0x1e, 0x6e, 0xdc, 0x69, 0x21, 0x0b, 0xb9, 0x1b, 0x77,
	0x5a, 0xc8, 0x3f, 0x15, 0xc8, 0xf4, 0x61, 0x74, 0x12, 0xba, 0x5a, 0xf6, 0xec, 0x52, 0xb5, 0x44,
	0x26, 0x8e, 0x43, 0xdb, 0x3a, 0x71, 0x17, 0x26, 0x14, 0x7b, 0x41, 0xc8, 0x60, 0x78, 0x5f, 0xd7,
	0x87, 0x19, 0x18, 0xc6, 0x10, 0x53, 0xfd, 0x4e, 0xec, 0xd3, 0x78, 0x90, 0xed, 0xfc, 0x90, 0x8f,
	0xd7, 0x4b, 0x78, 0x50, 0x4c, 0x35, 0xf6, 0x09, 0x4d, 0x1c, 0x3a, 0x81, 0xb4, 0xa5, 0xde, 0x0e,
	0x3b, 0x99, 0xc4, 0xb5, 0x94, 0x4d, 0xe6, 0x40, 0xea, 0x0c, 0x61, 0x1b, 0x2d, 0x32, 0x9f, 0xb1,
	0x97, 0x24, 0xe9, 0xbf, 0x31, 0xf8, 0xc7, 0x02, 0xa9, 0x1d, 0x82, 0xd0, 0xee, 0x69, 0x96, 0xdd,
	0x6f, 0x7f, 0x4e, 0x26, 0xe3, 0x94, 0xe1, 0xc5, 0xc7, 0xc0, 0x52, 0x92, 0xbd, 0x24, 0x53, 0x83,
	0xdc, 0x84, 0xbc, 0x58, 0x2f, 0xe5, 0xe5, 0x30, 0x8b, 0xc3, 0x27, 0x29, 0x4d, 0x5a, 0xc8, 0x4b,
	0xd6, 0xe4, 0x80, 0xd1, 0xf8, 0x99, 0xdc, 0xbe, 0xd2, 0x99, 0xff, 0x41, 0xa0, 0xcf, 0xc9, 0x72,
	0x7c, 0x3d, 0x46, 0xef, 0x78, 0x4e, 0x97, 0x34, 0xd6, 0x09, 0x1f, 0x55, 0x49, 0x5c, 0x59, 0x22,
	0x13, 0x41, 0xd4, 0x3d, 0x01, 0x6d, 0x75, 0xca, 0x4e, 0x42, 0x35, 0xce, 0xc8, 0x32, 0x6a, 0xef,
	0x89, 0xd1, 0x89, 0x9f, 0xd7, 0x8c, 0x99, 0x9b, 0x5e, 0x1c, 0xbe, 0xe9, 0xf7, 0x08, 0x49, 0x8d,
	0xf4, 0x7b, 0x2e, 0xc3, 0x69, 0x6c, 0x10, 0x3e, 0x7a, 0xd8, 0x8d, 0x23, 0xfb, 0x6f, 0x45, 0xb2,
	0x74, 0x10, 0xe9, 0x0e, 0x5c, 0x35, 0xed, 0xfe, 0xf3, 0x47, 0xa9, 0x39, 0xfc, 0x28, 0x35, 0xaf,
	0x79, 0x94, 0xf0, 0x77, 0xbf, 0x0c, 0xec, 0x9c, 0xb2, 0xc3, 0xad, 0xec, 0xf4, 0xe9, 0xf8, 0x3f,
	0x81, 0x8f, 0xb1, 0xac, 0x9c, 0xc8, 0x12, 0x9a, 0xbd, 0x22, 0x4b, 0xc9, 0x0f, 0xca, 0x2d, 0x68,
	0x2b, 0x0d, 0xfd, 0x35, 0xca, 0xce, 0xb7, 0xb2, 0x93, 0x23, 0xc5, 0xa6, 0xdb, 0x56, 0xdd, 0x9e,
	0x70, 0x4d, 0x73, 0x2b, 0x19, 0x6d, 0x03, 0x06, 0x4e, 0xe3, 0x6d, 0x1f, 0x84, 0xde, 0x12, 0xee,
	0x59, 0xd4, 0x0b, 0xed, 0x50, 0xac, 0x38, 0x43, 0xbc, 0xc6, 0x4f, 0x64, 0x79, 0x24, 0x65, 0x37,
	0x25, 0x1a, 0x0d, 0x37, 0xe3, 0xed, 0x2e, 0x0e, 0xa7, 0x68, 0x9d, 0x1c, 0xe2, 0xad, 0xfe, 0x65,
	0x22, 0x3b, 0x8a, 0xd8, 0x2c, 0x21, 0x5b, 0x22, 0x84, 0x98, 0x43, 0xc7, 0xd8, 0xf4, 0xe0, 0x21,
	0xa3, 0x05, 0x56, 0x21, 0xe3, 0x7b, 0x32, 0x38, 0xa3, 0x4f, 0xd9, 0x14, 0x99, 0x7c, 0x0f, 0x01,
	0x36, 0x36, 0x7d, 0x86, 0x4a, 0xdb, 0xca, 0xf7, 0xc1, 0xb5, 0xf4, 0x73, 0x76, 0x8b, 0xcc, 0xb7,
	0xb4, 0x07, 0x1a, 0xcf, 0xe8, 0xb3, 0xd7, 0x19, 0x23, 0xb3, 0x03, 0xfa, 0x40, 0x74, 0x80, 0xbe,
	0x60, 0x9f, 0x90, 0x5b, 0x23, 0x50, 0x2b, 0xda, 0x60, 0x73, 0x64, 0x6a, 0xb3, 0xd7, 0xf3, 0x65,
	0xfc, 0xfb, 0x94, 0x16, 0x59, 0x95, 0x94, 0xbf, 0xd3, 0x2a, 0xea, 0xd1, 0x12, 0xa3, 0x64, 0xba,
	0xa5, 0x3b, 0x22, 0x90, 0x7f, 0x88, 0x85, 0xe3, 0x8c, 0x90, 0x89, 0x03, 0xd0, 0xa1, 0x0a, 0x68,
	0x19, 0x9d, 0x3b, 0x04, 0x7d, 0x2e, 0x5d, 0xa0, 0x13, 0x48, 0x6c, 0x6a, 0x23, 0x5d, 0x1f, 0xe8,
	0x24, 0x9a, 0xd8, 0x8c, 0x3c, 0xa9, 0x68, 0x05, 0x23, 0x6b, 0x2a, 0xd7, 0xfe, 0x7a, 0xa1, 0x55,
	0x14, 0xd8, 0x89, 0x49, 0x09, 0x7e, 0xee, 0xe2, 0x6f, 0x6d, 0x3a, 0x85, 0xf1, 0xee, 0x2b, 0x03,
	0x74, 0x1a, 0xbf, 0xac, 0x5b, 0x33, 0x28, 0x3e, 0xf0, 0x85, 0x0b, 0x74, 0x16, 0x4d, 0x1f, 0x68,
	0xd5, 0x96, 0x3e, 0xd0, 0x39, 0x74, 0xc9, 0xc9, 0xec, 0xee, 0x94, 0xb2, 0x19, 0x52, 0x3d, 0x52,
	0xdd, 0x93, 0xd0, 0xa8, 0x00, 0xe8, 0x3c, 0x2a, 0xfe, 0x28, 0x3d, 0x50, 0x94, 0xa1, 0xb3, 0x9b,
	0xae, 0x0b, 0x3d, 0x43, 0x17, 0xd8, 0x24, 0x29, 0x6d, 0x7a, 0x1e, 0x5d, 0xb4, 0xa9, 0x0e, 0x02,
	0x15, 0x05, 0x2e, 0xd0, 0x5b, 0x16, 0xa2, 0xb5, 0x3c, 0x07, 0xba, 0x84, 0x9a, 0x5b, 0xbe, 0x72,
	0xcf, 0xe8, 0x32, 0xb2, 0xb7, 0x35, 0x08, 0x03, 0x94, 0xe3, 0x77, 0x5c, 0x4a, 0xfa, 0x09, 0xba,
	0xd2, 0x94, 0xa1, 0x2f, 0xcf, 0x80, 0xd6, 0xd0, 0xd9, 0x77, 0xbe, 0xe8, 0xd0, 0xdb, 0x08, 0x79,
	0xa7, 0x7c, 0x5f, 0x7d, 0xa0, 0x77, 0xf0, 0x7b, 0xb7, 0x13, 0x28, 0x0d, 0xf4, 0xae, 0xfd, 0x0e,
	0xce, 0xa5, 0x01, 0x7a, 0x0f, 0xd1, 0xdf, 0x2b, 0x19, 0xd0, 0xfb, 0x78, 0xce, 0x1e, 0x88, 0x73,
	0xa0, 0xf5, 0xb8, 0xd2, 0x67, 0x40, 0x1f, 0x20, 0x74, 0x4f, 0x86, 0x06, 0x02, 0xda, 0x40, 0xee,
	0x7b, 0x75, 0x0e, 0xf4, 0x53, 0x84, 0xb6, 0xda, 0x6d, 0xd0, 0xf4, 0x21, 0xfa, 0xfd, 0x03, 0x5e,
	0x5e, 0xac, 0xc3, 0x23, 0x84, 0x3b, 0x60, 0x9b, 0xe7, 0x31, 0xc2, 0x1d, 0x10, 0x1e, 0xfd, 0x2c,
	0xe6, 0x76, 0x51, 0x75, 0x85, 0x2d, 0x90, 0xb9, 0x23, 0x08, 0x8c, 0x30, 0xf2, 0x1c, 0x12, 0xe8,
	0xe7, 0x43, 0xcc, 0x24, 0x35, 0xab, 0xa8, 0x75, 0xa4, 0xc5, 0x39, 0xf8, 0xf4, 0x0b, 0xb4, 0x75,
	0x1c, 0x78, 0x8a, 0x3e, 0x41, 0xee, 0xb1, 0xbd, 0x66, 0xf4, 0x4b, 0x36, 0x4f, 0x66, 0xe2, 0xef,
	0x6d, 0xd5, 0xb5, 0x95, 0x7c, 0x8b, 0xcd, 0x18, 0xb3, 0xde, 0x83, 0x11, 0xf4, 0x6b, 0x54, 0xc4,
	0x0d, 0x80, 0xae, 0x61, 0x3d, 0x7e, 0x52, 0xfa, 0x2c, 0xec, 0x61, 0xf5, 0x5e, 0xda, 0xf4, 0xd9,
	0xe5, 0x82, 0xbe, 0x4a, 0xf2, 0xe4, 0x81, 0xa6, 0x5f, 0xa1, 0xc2, 0x36, 0xf8, 0x3e, 0x7d, 0x8d,
	0x41, 0x1e, 0x9e, 0x0a, 0x0d, 0xf4, 0xcd, 0xea, 0x4b, 0x32, 0x33, 0xb4, 0x6d, 0xa1, 0xc6, 0xfb,
	0x9f, 0xdf, 0xed, 0xec, 0x34, 0xe9, 0x18, 0x26, 0xff, 0xf8, 0x70, 0xc7, 0xf9, 0xdd, 0x6e, 0x93,
	0x16, 0x90, 0xd8, 0x6f, 0x35, 0x77, 0x90, 0x28, 0xae, 0xbe, 0x21, 0x6c, 0x74, 0x33, 0x41, 0xc8,
	0x77, 0x3b, 0xfb, 0x3b, 0xce, 0xee, 0x36, 0x1d, 0xb3, 0x2d, 0xb9, 0x7d, 0xd4, 0x72, 0x62, 0xd5,
	0xc3, 0xe3, 0xad, 0xef, 0x77, 0xb6, 0x8f, 0x68, 0x71, 0xf5, 0x7e, 0x66, 0x14, 0xda, 0x46, 0x6c,
	0x35, 0x77, 0xe8, 0x98, 0xcd, 0xc3, 0xe1, 0x8e, 0x43, 0x0b, 0xeb, 0x7f, 0x2e, 0x93, 0xb9, 0xf4,
	0x6e, 0x26, 0xed, 0xce, 0x7e, 0x20, 0xd3, 0xd9, 0x65, 0x98, 0xdd, 0x1d, 0x0c, 0xcf, 0x2b, 0x7e,
	0x03, 0xd4, 0xee, 0xe5, 0x89, 0xe3, 0xd1, 0xd2, 0x18, 0x5b, 0x29, 0xb0, 0xdf, 0x10, 0x7a, 0x79,
	0x3b, 0x62, 0x0f, 0x2e, 0xef, 0xa0, 0x23, 0x93, 0xbc, 0xd6, 0xb8, 0x0e, 0x92, 0x9a, 0x7f, 0x56,
	0x60, 0x82, 0x2c, 0x5d, 0x7e, 0xe3, 0xf6, 0xed, 0x4b, 0x96, 0x3d, 0x24, 0xe7, 0xe1, 0xcc, 0x1e,
	0x92, 0xf7, 0x50, 0x36, 0xc6, 0xd8, 0xaf, 0xc9, 0xdc, 0xa5, 0xd9, 0xc9, 0xea, 0x99, 0xc0, 0xaf,
	0x7c, 0x89, 0x6a, 0x0f, 0xae, 0x41, 0xf4, 0x2d, 0xff, 0x96, 0x2c, 0x1c, 0x82, 0xb9, 0xfc, 0x04,
	0x0e, 0x79, 0x7e, 0xf5, 0x5b, 0x3c, 0xe4, 0x79, 0xce, 0x0b, 0xda, 0x18, 0x63, 0xef, 0x48, 0xb5,
	0xbf, 0x6d, 0xb1, 0xda, 0xc8, 0x9a, 0xd1, 0x5f, 0xe9, 0x6a, 0xb7, 0xaf, 0x94, 0xf5, 0xed, 0xb4,
	0xd1, 0xcf, 0x91, 0xb5, 0x86, 0x3d, 0xcc, 0x68, 0xe5, 0xae, 0x60, 0xb5, 0x47, 0x37, 0xa0, 0x06,
	0xc5, 0x3c, 0x99, 0xb0, 0x7f, 0x30, 0xbc, 0xf8, 0x57, 0x00, 0x00, 0x00, 0xff, 0xff, 0x3a, 0x28,
	0xd7, 0x90, 0x2d, 0x18, 0x00, 0x00,
}
