// Code generated by protoc-gen-go. DO NOT EDIT.
// source: auth.proto

/*
Package auth is a generated protocol buffer package.

It is generated from these files:
	auth.proto

It has these top-level messages:
	Token
	RevokeTokenRequest
	RevokeTokenResponse
	PruneTokensRequest
	PruneTokensResponse
	ID
	GetLoginRequest
	GetLoginResponse
	CreateLoginRequest
	CreateLoginResponse
	AcceptLoginRequest
	AcceptLoginResponse
	GetConsentRequest
	GetConsentResponse
	CreateConsentRequest
	CreateConsentResponse
	AcceptConsentRequest
	AcceptConsentResponse
	CreateLogoutRequest
	CreateLogoutResponse
	AcceptLogoutRequest
	AcceptLogoutResponse
	CreateAuthCodeRequest
	CreateAuthCodeResponse
	VerifyTokenRequest
	VerifyTokenResponse
	ExchangeRequest
	ExchangeResponse
	PasswordCredentialsTokenRequest
	PasswordCredentialsTokenResponse
	RefreshTokenRequest
	RefreshTokenResponse
	PersonalAccessToken
	PatGenerateRequest
	PatGenerateResponse
	PatListRequest
	PatListResponse
	PatRevokeRequest
	PatRevokeResponse
*/
package auth

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type PatType int32

const (
	PatType_ANY      PatType = 0
	PatType_PERSONAL PatType = 1
	PatType_DOCUMENT PatType = 2
)

var PatType_name = map[int32]string{
	0: "ANY",
	1: "PERSONAL",
	2: "DOCUMENT",
}
var PatType_value = map[string]int32{
	"ANY":      0,
	"PERSONAL": 1,
	"DOCUMENT": 2,
}

func (x PatType) String() string {
	return proto.EnumName(PatType_name, int32(x))
}
func (PatType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

type Token struct {
	AccessToken  string `protobuf:"bytes,1,opt,name=AccessToken" json:"AccessToken,omitempty"`
	IDToken      string `protobuf:"bytes,2,opt,name=IDToken" json:"IDToken,omitempty"`
	RefreshToken string `protobuf:"bytes,3,opt,name=RefreshToken" json:"RefreshToken,omitempty"`
	ExpiresAt    string `protobuf:"bytes,4,opt,name=ExpiresAt" json:"ExpiresAt,omitempty"`
}

func (m *Token) Reset()                    { *m = Token{} }
func (m *Token) String() string            { return proto.CompactTextString(m) }
func (*Token) ProtoMessage()               {}
func (*Token) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *Token) GetAccessToken() string {
	if m != nil {
		return m.AccessToken
	}
	return ""
}

func (m *Token) GetIDToken() string {
	if m != nil {
		return m.IDToken
	}
	return ""
}

func (m *Token) GetRefreshToken() string {
	if m != nil {
		return m.RefreshToken
	}
	return ""
}

func (m *Token) GetExpiresAt() string {
	if m != nil {
		return m.ExpiresAt
	}
	return ""
}

type RevokeTokenRequest struct {
	Token *Token `protobuf:"bytes,1,opt,name=Token" json:"Token,omitempty"`
}

func (m *RevokeTokenRequest) Reset()                    { *m = RevokeTokenRequest{} }
func (m *RevokeTokenRequest) String() string            { return proto.CompactTextString(m) }
func (*RevokeTokenRequest) ProtoMessage()               {}
func (*RevokeTokenRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *RevokeTokenRequest) GetToken() *Token {
	if m != nil {
		return m.Token
	}
	return nil
}

type RevokeTokenResponse struct {
	Success bool `protobuf:"varint,1,opt,name=Success" json:"Success,omitempty"`
}

func (m *RevokeTokenResponse) Reset()                    { *m = RevokeTokenResponse{} }
func (m *RevokeTokenResponse) String() string            { return proto.CompactTextString(m) }
func (*RevokeTokenResponse) ProtoMessage()               {}
func (*RevokeTokenResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *RevokeTokenResponse) GetSuccess() bool {
	if m != nil {
		return m.Success
	}
	return false
}

type PruneTokensRequest struct {
}

func (m *PruneTokensRequest) Reset()                    { *m = PruneTokensRequest{} }
func (m *PruneTokensRequest) String() string            { return proto.CompactTextString(m) }
func (*PruneTokensRequest) ProtoMessage()               {}
func (*PruneTokensRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

type PruneTokensResponse struct {
	Tokens []string `protobuf:"bytes,1,rep,name=tokens" json:"tokens,omitempty"`
	Count  int32    `protobuf:"varint,2,opt,name=Count" json:"Count,omitempty"`
}

func (m *PruneTokensResponse) Reset()                    { *m = PruneTokensResponse{} }
func (m *PruneTokensResponse) String() string            { return proto.CompactTextString(m) }
func (*PruneTokensResponse) ProtoMessage()               {}
func (*PruneTokensResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *PruneTokensResponse) GetTokens() []string {
	if m != nil {
		return m.Tokens
	}
	return nil
}

func (m *PruneTokensResponse) GetCount() int32 {
	if m != nil {
		return m.Count
	}
	return 0
}

type ID struct {
	Challenge string `protobuf:"bytes,1,opt,name=Challenge" json:"Challenge,omitempty"`
	Verifier  string `protobuf:"bytes,2,opt,name=Verifier" json:"Verifier,omitempty"`
	CSRF      string `protobuf:"bytes,3,opt,name=CSRF" json:"CSRF,omitempty"`
}

func (m *ID) Reset()                    { *m = ID{} }
func (m *ID) String() string            { return proto.CompactTextString(m) }
func (*ID) ProtoMessage()               {}
func (*ID) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *ID) GetChallenge() string {
	if m != nil {
		return m.Challenge
	}
	return ""
}

func (m *ID) GetVerifier() string {
	if m != nil {
		return m.Verifier
	}
	return ""
}

func (m *ID) GetCSRF() string {
	if m != nil {
		return m.CSRF
	}
	return ""
}

type GetLoginRequest struct {
	Challenge string `protobuf:"bytes,1,opt,name=Challenge" json:"Challenge,omitempty"`
}

func (m *GetLoginRequest) Reset()                    { *m = GetLoginRequest{} }
func (m *GetLoginRequest) String() string            { return proto.CompactTextString(m) }
func (*GetLoginRequest) ProtoMessage()               {}
func (*GetLoginRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *GetLoginRequest) GetChallenge() string {
	if m != nil {
		return m.Challenge
	}
	return ""
}

type GetLoginResponse struct {
	Challenge         string   `protobuf:"bytes,1,opt,name=Challenge" json:"Challenge,omitempty"`
	Subject           string   `protobuf:"bytes,2,opt,name=Subject" json:"Subject,omitempty"`
	SessionID         string   `protobuf:"bytes,3,opt,name=SessionID" json:"SessionID,omitempty"`
	RequestURL        string   `protobuf:"bytes,4,opt,name=RequestURL" json:"RequestURL,omitempty"`
	RequestedScope    []string `protobuf:"bytes,5,rep,name=RequestedScope" json:"RequestedScope,omitempty"`
	RequestedAudience []string `protobuf:"bytes,6,rep,name=RequestedAudience" json:"RequestedAudience,omitempty"`
	ClientID          string   `protobuf:"bytes,7,opt,name=ClientID" json:"ClientID,omitempty"`
}

func (m *GetLoginResponse) Reset()                    { *m = GetLoginResponse{} }
func (m *GetLoginResponse) String() string            { return proto.CompactTextString(m) }
func (*GetLoginResponse) ProtoMessage()               {}
func (*GetLoginResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *GetLoginResponse) GetChallenge() string {
	if m != nil {
		return m.Challenge
	}
	return ""
}

func (m *GetLoginResponse) GetSubject() string {
	if m != nil {
		return m.Subject
	}
	return ""
}

func (m *GetLoginResponse) GetSessionID() string {
	if m != nil {
		return m.SessionID
	}
	return ""
}

func (m *GetLoginResponse) GetRequestURL() string {
	if m != nil {
		return m.RequestURL
	}
	return ""
}

func (m *GetLoginResponse) GetRequestedScope() []string {
	if m != nil {
		return m.RequestedScope
	}
	return nil
}

func (m *GetLoginResponse) GetRequestedAudience() []string {
	if m != nil {
		return m.RequestedAudience
	}
	return nil
}

func (m *GetLoginResponse) GetClientID() string {
	if m != nil {
		return m.ClientID
	}
	return ""
}

type CreateLoginRequest struct {
	ClientID  string   `protobuf:"bytes,1,opt,name=ClientID" json:"ClientID,omitempty"`
	Scopes    []string `protobuf:"bytes,2,rep,name=Scopes" json:"Scopes,omitempty"`
	Audiences []string `protobuf:"bytes,3,rep,name=Audiences" json:"Audiences,omitempty"`
}

func (m *CreateLoginRequest) Reset()                    { *m = CreateLoginRequest{} }
func (m *CreateLoginRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateLoginRequest) ProtoMessage()               {}
func (*CreateLoginRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *CreateLoginRequest) GetClientID() string {
	if m != nil {
		return m.ClientID
	}
	return ""
}

func (m *CreateLoginRequest) GetScopes() []string {
	if m != nil {
		return m.Scopes
	}
	return nil
}

func (m *CreateLoginRequest) GetAudiences() []string {
	if m != nil {
		return m.Audiences
	}
	return nil
}

type CreateLoginResponse struct {
	Login *ID `protobuf:"bytes,1,opt,name=Login" json:"Login,omitempty"`
}

func (m *CreateLoginResponse) Reset()                    { *m = CreateLoginResponse{} }
func (m *CreateLoginResponse) String() string            { return proto.CompactTextString(m) }
func (*CreateLoginResponse) ProtoMessage()               {}
func (*CreateLoginResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *CreateLoginResponse) GetLogin() *ID {
	if m != nil {
		return m.Login
	}
	return nil
}

type AcceptLoginRequest struct {
	Challenge string `protobuf:"bytes,1,opt,name=Challenge" json:"Challenge,omitempty"`
	Verifier  string `protobuf:"bytes,2,opt,name=Verifier" json:"Verifier,omitempty"`
	Subject   string `protobuf:"bytes,3,opt,name=Subject" json:"Subject,omitempty"`
}

func (m *AcceptLoginRequest) Reset()                    { *m = AcceptLoginRequest{} }
func (m *AcceptLoginRequest) String() string            { return proto.CompactTextString(m) }
func (*AcceptLoginRequest) ProtoMessage()               {}
func (*AcceptLoginRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *AcceptLoginRequest) GetChallenge() string {
	if m != nil {
		return m.Challenge
	}
	return ""
}

func (m *AcceptLoginRequest) GetVerifier() string {
	if m != nil {
		return m.Verifier
	}
	return ""
}

func (m *AcceptLoginRequest) GetSubject() string {
	if m != nil {
		return m.Subject
	}
	return ""
}

type AcceptLoginResponse struct {
}

func (m *AcceptLoginResponse) Reset()                    { *m = AcceptLoginResponse{} }
func (m *AcceptLoginResponse) String() string            { return proto.CompactTextString(m) }
func (*AcceptLoginResponse) ProtoMessage()               {}
func (*AcceptLoginResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

type GetConsentRequest struct {
	Challenge string `protobuf:"bytes,1,opt,name=Challenge" json:"Challenge,omitempty"`
}

func (m *GetConsentRequest) Reset()                    { *m = GetConsentRequest{} }
func (m *GetConsentRequest) String() string            { return proto.CompactTextString(m) }
func (*GetConsentRequest) ProtoMessage()               {}
func (*GetConsentRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *GetConsentRequest) GetChallenge() string {
	if m != nil {
		return m.Challenge
	}
	return ""
}

type GetConsentResponse struct {
	Challenge         string `protobuf:"bytes,1,opt,name=Challenge" json:"Challenge,omitempty"`
	LoginSessionID    string `protobuf:"bytes,2,opt,name=LoginSessionID" json:"LoginSessionID,omitempty"`
	SubjectIdentifier string `protobuf:"bytes,3,opt,name=SubjectIdentifier" json:"SubjectIdentifier,omitempty"`
	Subject           string `protobuf:"bytes,4,opt,name=Subject" json:"Subject,omitempty"`
	ClientID          string `protobuf:"bytes,5,opt,name=ClientID" json:"ClientID,omitempty"`
}

func (m *GetConsentResponse) Reset()                    { *m = GetConsentResponse{} }
func (m *GetConsentResponse) String() string            { return proto.CompactTextString(m) }
func (*GetConsentResponse) ProtoMessage()               {}
func (*GetConsentResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *GetConsentResponse) GetChallenge() string {
	if m != nil {
		return m.Challenge
	}
	return ""
}

func (m *GetConsentResponse) GetLoginSessionID() string {
	if m != nil {
		return m.LoginSessionID
	}
	return ""
}

func (m *GetConsentResponse) GetSubjectIdentifier() string {
	if m != nil {
		return m.SubjectIdentifier
	}
	return ""
}

func (m *GetConsentResponse) GetSubject() string {
	if m != nil {
		return m.Subject
	}
	return ""
}

func (m *GetConsentResponse) GetClientID() string {
	if m != nil {
		return m.ClientID
	}
	return ""
}

type CreateConsentRequest struct {
	LoginChallenge string `protobuf:"bytes,1,opt,name=LoginChallenge" json:"LoginChallenge,omitempty"`
}

func (m *CreateConsentRequest) Reset()                    { *m = CreateConsentRequest{} }
func (m *CreateConsentRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateConsentRequest) ProtoMessage()               {}
func (*CreateConsentRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *CreateConsentRequest) GetLoginChallenge() string {
	if m != nil {
		return m.LoginChallenge
	}
	return ""
}

type CreateConsentResponse struct {
	Consent *ID `protobuf:"bytes,1,opt,name=Consent" json:"Consent,omitempty"`
}

func (m *CreateConsentResponse) Reset()                    { *m = CreateConsentResponse{} }
func (m *CreateConsentResponse) String() string            { return proto.CompactTextString(m) }
func (*CreateConsentResponse) ProtoMessage()               {}
func (*CreateConsentResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *CreateConsentResponse) GetConsent() *ID {
	if m != nil {
		return m.Consent
	}
	return nil
}

type AcceptConsentRequest struct {
	Challenge   string            `protobuf:"bytes,1,opt,name=Challenge" json:"Challenge,omitempty"`
	Scopes      []string          `protobuf:"bytes,2,rep,name=Scopes" json:"Scopes,omitempty"`
	Audiences   []string          `protobuf:"bytes,3,rep,name=Audiences" json:"Audiences,omitempty"`
	AccessToken map[string]string `protobuf:"bytes,4,rep,name=AccessToken" json:"AccessToken,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	IDToken     map[string]string `protobuf:"bytes,5,rep,name=IDToken" json:"IDToken,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *AcceptConsentRequest) Reset()                    { *m = AcceptConsentRequest{} }
func (m *AcceptConsentRequest) String() string            { return proto.CompactTextString(m) }
func (*AcceptConsentRequest) ProtoMessage()               {}
func (*AcceptConsentRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *AcceptConsentRequest) GetChallenge() string {
	if m != nil {
		return m.Challenge
	}
	return ""
}

func (m *AcceptConsentRequest) GetScopes() []string {
	if m != nil {
		return m.Scopes
	}
	return nil
}

func (m *AcceptConsentRequest) GetAudiences() []string {
	if m != nil {
		return m.Audiences
	}
	return nil
}

func (m *AcceptConsentRequest) GetAccessToken() map[string]string {
	if m != nil {
		return m.AccessToken
	}
	return nil
}

func (m *AcceptConsentRequest) GetIDToken() map[string]string {
	if m != nil {
		return m.IDToken
	}
	return nil
}

type AcceptConsentResponse struct {
}

func (m *AcceptConsentResponse) Reset()                    { *m = AcceptConsentResponse{} }
func (m *AcceptConsentResponse) String() string            { return proto.CompactTextString(m) }
func (*AcceptConsentResponse) ProtoMessage()               {}
func (*AcceptConsentResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

type CreateLogoutRequest struct {
	RequestURL string `protobuf:"bytes,1,opt,name=RequestURL" json:"RequestURL,omitempty"`
	Subject    string `protobuf:"bytes,2,opt,name=Subject" json:"Subject,omitempty"`
	SessionID  string `protobuf:"bytes,3,opt,name=SessionID" json:"SessionID,omitempty"`
}

func (m *CreateLogoutRequest) Reset()                    { *m = CreateLogoutRequest{} }
func (m *CreateLogoutRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateLogoutRequest) ProtoMessage()               {}
func (*CreateLogoutRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func (m *CreateLogoutRequest) GetRequestURL() string {
	if m != nil {
		return m.RequestURL
	}
	return ""
}

func (m *CreateLogoutRequest) GetSubject() string {
	if m != nil {
		return m.Subject
	}
	return ""
}

func (m *CreateLogoutRequest) GetSessionID() string {
	if m != nil {
		return m.SessionID
	}
	return ""
}

type CreateLogoutResponse struct {
	Logout *ID `protobuf:"bytes,1,opt,name=Logout" json:"Logout,omitempty"`
}

func (m *CreateLogoutResponse) Reset()                    { *m = CreateLogoutResponse{} }
func (m *CreateLogoutResponse) String() string            { return proto.CompactTextString(m) }
func (*CreateLogoutResponse) ProtoMessage()               {}
func (*CreateLogoutResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{19} }

func (m *CreateLogoutResponse) GetLogout() *ID {
	if m != nil {
		return m.Logout
	}
	return nil
}

type AcceptLogoutRequest struct {
	Challenge    string `protobuf:"bytes,1,opt,name=Challenge" json:"Challenge,omitempty"`
	AccessToken  string `protobuf:"bytes,2,opt,name=AccessToken" json:"AccessToken,omitempty"`
	RefreshToken string `protobuf:"bytes,3,opt,name=RefreshToken" json:"RefreshToken,omitempty"`
}

func (m *AcceptLogoutRequest) Reset()                    { *m = AcceptLogoutRequest{} }
func (m *AcceptLogoutRequest) String() string            { return proto.CompactTextString(m) }
func (*AcceptLogoutRequest) ProtoMessage()               {}
func (*AcceptLogoutRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{20} }

func (m *AcceptLogoutRequest) GetChallenge() string {
	if m != nil {
		return m.Challenge
	}
	return ""
}

func (m *AcceptLogoutRequest) GetAccessToken() string {
	if m != nil {
		return m.AccessToken
	}
	return ""
}

func (m *AcceptLogoutRequest) GetRefreshToken() string {
	if m != nil {
		return m.RefreshToken
	}
	return ""
}

type AcceptLogoutResponse struct {
}

func (m *AcceptLogoutResponse) Reset()                    { *m = AcceptLogoutResponse{} }
func (m *AcceptLogoutResponse) String() string            { return proto.CompactTextString(m) }
func (*AcceptLogoutResponse) ProtoMessage()               {}
func (*AcceptLogoutResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{21} }

type CreateAuthCodeRequest struct {
	Consent     *ID    `protobuf:"bytes,1,opt,name=Consent" json:"Consent,omitempty"`
	ClientID    string `protobuf:"bytes,2,opt,name=ClientID" json:"ClientID,omitempty"`
	RedirectURI string `protobuf:"bytes,3,opt,name=RedirectURI" json:"RedirectURI,omitempty"`
}

func (m *CreateAuthCodeRequest) Reset()                    { *m = CreateAuthCodeRequest{} }
func (m *CreateAuthCodeRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateAuthCodeRequest) ProtoMessage()               {}
func (*CreateAuthCodeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{22} }

func (m *CreateAuthCodeRequest) GetConsent() *ID {
	if m != nil {
		return m.Consent
	}
	return nil
}

func (m *CreateAuthCodeRequest) GetClientID() string {
	if m != nil {
		return m.ClientID
	}
	return ""
}

func (m *CreateAuthCodeRequest) GetRedirectURI() string {
	if m != nil {
		return m.RedirectURI
	}
	return ""
}

type CreateAuthCodeResponse struct {
	Code string `protobuf:"bytes,1,opt,name=Code" json:"Code,omitempty"`
}

func (m *CreateAuthCodeResponse) Reset()                    { *m = CreateAuthCodeResponse{} }
func (m *CreateAuthCodeResponse) String() string            { return proto.CompactTextString(m) }
func (*CreateAuthCodeResponse) ProtoMessage()               {}
func (*CreateAuthCodeResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{23} }

func (m *CreateAuthCodeResponse) GetCode() string {
	if m != nil {
		return m.Code
	}
	return ""
}

type VerifyTokenRequest struct {
	Token string `protobuf:"bytes,1,opt,name=Token" json:"Token,omitempty"`
}

func (m *VerifyTokenRequest) Reset()                    { *m = VerifyTokenRequest{} }
func (m *VerifyTokenRequest) String() string            { return proto.CompactTextString(m) }
func (*VerifyTokenRequest) ProtoMessage()               {}
func (*VerifyTokenRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{24} }

func (m *VerifyTokenRequest) GetToken() string {
	if m != nil {
		return m.Token
	}
	return ""
}

type VerifyTokenResponse struct {
	Success bool   `protobuf:"varint,1,opt,name=Success" json:"Success,omitempty"`
	Data    []byte `protobuf:"bytes,2,opt,name=Data,proto3" json:"Data,omitempty"`
}

func (m *VerifyTokenResponse) Reset()                    { *m = VerifyTokenResponse{} }
func (m *VerifyTokenResponse) String() string            { return proto.CompactTextString(m) }
func (*VerifyTokenResponse) ProtoMessage()               {}
func (*VerifyTokenResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{25} }

func (m *VerifyTokenResponse) GetSuccess() bool {
	if m != nil {
		return m.Success
	}
	return false
}

func (m *VerifyTokenResponse) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

type ExchangeRequest struct {
	Code         string `protobuf:"bytes,1,opt,name=Code,json=code" json:"Code,omitempty"`
	CodeVerifier string `protobuf:"bytes,2,opt,name=CodeVerifier,json=code_verifier" json:"CodeVerifier,omitempty"`
}

func (m *ExchangeRequest) Reset()                    { *m = ExchangeRequest{} }
func (m *ExchangeRequest) String() string            { return proto.CompactTextString(m) }
func (*ExchangeRequest) ProtoMessage()               {}
func (*ExchangeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{26} }

func (m *ExchangeRequest) GetCode() string {
	if m != nil {
		return m.Code
	}
	return ""
}

func (m *ExchangeRequest) GetCodeVerifier() string {
	if m != nil {
		return m.CodeVerifier
	}
	return ""
}

type ExchangeResponse struct {
	AccessToken  string `protobuf:"bytes,1,opt,name=AccessToken,json=access_token" json:"AccessToken,omitempty"`
	IDToken      string `protobuf:"bytes,2,opt,name=IDToken,json=id_token" json:"IDToken,omitempty"`
	RefreshToken string `protobuf:"bytes,3,opt,name=RefreshToken,json=refresh_token" json:"RefreshToken,omitempty"`
	Expiry       int64  `protobuf:"varint,4,opt,name=Expiry,json=expiry" json:"Expiry,omitempty"`
}

func (m *ExchangeResponse) Reset()                    { *m = ExchangeResponse{} }
func (m *ExchangeResponse) String() string            { return proto.CompactTextString(m) }
func (*ExchangeResponse) ProtoMessage()               {}
func (*ExchangeResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{27} }

func (m *ExchangeResponse) GetAccessToken() string {
	if m != nil {
		return m.AccessToken
	}
	return ""
}

func (m *ExchangeResponse) GetIDToken() string {
	if m != nil {
		return m.IDToken
	}
	return ""
}

func (m *ExchangeResponse) GetRefreshToken() string {
	if m != nil {
		return m.RefreshToken
	}
	return ""
}

func (m *ExchangeResponse) GetExpiry() int64 {
	if m != nil {
		return m.Expiry
	}
	return 0
}

type PasswordCredentialsTokenRequest struct {
	Username string `protobuf:"bytes,1,opt,name=Username,json=username" json:"Username,omitempty"`
	Password string `protobuf:"bytes,2,opt,name=Password,json=password" json:"Password,omitempty"`
}

func (m *PasswordCredentialsTokenRequest) Reset()         { *m = PasswordCredentialsTokenRequest{} }
func (m *PasswordCredentialsTokenRequest) String() string { return proto.CompactTextString(m) }
func (*PasswordCredentialsTokenRequest) ProtoMessage()    {}
func (*PasswordCredentialsTokenRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{28}
}

func (m *PasswordCredentialsTokenRequest) GetUsername() string {
	if m != nil {
		return m.Username
	}
	return ""
}

func (m *PasswordCredentialsTokenRequest) GetPassword() string {
	if m != nil {
		return m.Password
	}
	return ""
}

type PasswordCredentialsTokenResponse struct {
	AccessToken  string `protobuf:"bytes,1,opt,name=AccessToken,json=access_token" json:"AccessToken,omitempty"`
	IDToken      string `protobuf:"bytes,2,opt,name=IDToken,json=id_token" json:"IDToken,omitempty"`
	RefreshToken string `protobuf:"bytes,3,opt,name=RefreshToken,json=refresh_token" json:"RefreshToken,omitempty"`
	Expiry       int64  `protobuf:"varint,4,opt,name=Expiry,json=expiry" json:"Expiry,omitempty"`
}

func (m *PasswordCredentialsTokenResponse) Reset()         { *m = PasswordCredentialsTokenResponse{} }
func (m *PasswordCredentialsTokenResponse) String() string { return proto.CompactTextString(m) }
func (*PasswordCredentialsTokenResponse) ProtoMessage()    {}
func (*PasswordCredentialsTokenResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{29}
}

func (m *PasswordCredentialsTokenResponse) GetAccessToken() string {
	if m != nil {
		return m.AccessToken
	}
	return ""
}

func (m *PasswordCredentialsTokenResponse) GetIDToken() string {
	if m != nil {
		return m.IDToken
	}
	return ""
}

func (m *PasswordCredentialsTokenResponse) GetRefreshToken() string {
	if m != nil {
		return m.RefreshToken
	}
	return ""
}

func (m *PasswordCredentialsTokenResponse) GetExpiry() int64 {
	if m != nil {
		return m.Expiry
	}
	return 0
}

type RefreshTokenRequest struct {
	RefreshToken string `protobuf:"bytes,1,opt,name=RefreshToken" json:"RefreshToken,omitempty"`
}

func (m *RefreshTokenRequest) Reset()                    { *m = RefreshTokenRequest{} }
func (m *RefreshTokenRequest) String() string            { return proto.CompactTextString(m) }
func (*RefreshTokenRequest) ProtoMessage()               {}
func (*RefreshTokenRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{30} }

func (m *RefreshTokenRequest) GetRefreshToken() string {
	if m != nil {
		return m.RefreshToken
	}
	return ""
}

type RefreshTokenResponse struct {
	AccessToken  string `protobuf:"bytes,1,opt,name=AccessToken,json=access_token" json:"AccessToken,omitempty"`
	IDToken      string `protobuf:"bytes,2,opt,name=IDToken,json=id_token" json:"IDToken,omitempty"`
	RefreshToken string `protobuf:"bytes,3,opt,name=RefreshToken,json=refresh_token" json:"RefreshToken,omitempty"`
	Expiry       int64  `protobuf:"varint,4,opt,name=Expiry,json=expiry" json:"Expiry,omitempty"`
}

func (m *RefreshTokenResponse) Reset()                    { *m = RefreshTokenResponse{} }
func (m *RefreshTokenResponse) String() string            { return proto.CompactTextString(m) }
func (*RefreshTokenResponse) ProtoMessage()               {}
func (*RefreshTokenResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{31} }

func (m *RefreshTokenResponse) GetAccessToken() string {
	if m != nil {
		return m.AccessToken
	}
	return ""
}

func (m *RefreshTokenResponse) GetIDToken() string {
	if m != nil {
		return m.IDToken
	}
	return ""
}

func (m *RefreshTokenResponse) GetRefreshToken() string {
	if m != nil {
		return m.RefreshToken
	}
	return ""
}

func (m *RefreshTokenResponse) GetExpiry() int64 {
	if m != nil {
		return m.Expiry
	}
	return 0
}

type PersonalAccessToken struct {
	Uuid              string   `protobuf:"bytes,1,opt,name=Uuid" json:"Uuid,omitempty"`
	Type              PatType  `protobuf:"varint,2,opt,name=Type,enum=auth.PatType" json:"Type,omitempty"`
	Label             string   `protobuf:"bytes,3,opt,name=Label" json:"Label,omitempty"`
	UserUuid          string   `protobuf:"bytes,4,opt,name=UserUuid" json:"UserUuid,omitempty"`
	UserLogin         string   `protobuf:"bytes,5,opt,name=UserLogin" json:"UserLogin,omitempty"`
	Scopes            []string `protobuf:"bytes,6,rep,name=Scopes" json:"Scopes,omitempty"`
	AutoRefreshWindow int32    `protobuf:"varint,7,opt,name=AutoRefreshWindow" json:"AutoRefreshWindow,omitempty"`
	ExpiresAt         int64    `protobuf:"varint,8,opt,name=ExpiresAt" json:"ExpiresAt,omitempty"`
	CreatedBy         string   `protobuf:"bytes,9,opt,name=CreatedBy" json:"CreatedBy,omitempty"`
	CreatedAt         int64    `protobuf:"varint,10,opt,name=CreatedAt" json:"CreatedAt,omitempty"`
	UpdatedAt         int64    `protobuf:"varint,11,opt,name=UpdatedAt" json:"UpdatedAt,omitempty"`
}

func (m *PersonalAccessToken) Reset()                    { *m = PersonalAccessToken{} }
func (m *PersonalAccessToken) String() string            { return proto.CompactTextString(m) }
func (*PersonalAccessToken) ProtoMessage()               {}
func (*PersonalAccessToken) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{32} }

func (m *PersonalAccessToken) GetUuid() string {
	if m != nil {
		return m.Uuid
	}
	return ""
}

func (m *PersonalAccessToken) GetType() PatType {
	if m != nil {
		return m.Type
	}
	return PatType_ANY
}

func (m *PersonalAccessToken) GetLabel() string {
	if m != nil {
		return m.Label
	}
	return ""
}

func (m *PersonalAccessToken) GetUserUuid() string {
	if m != nil {
		return m.UserUuid
	}
	return ""
}

func (m *PersonalAccessToken) GetUserLogin() string {
	if m != nil {
		return m.UserLogin
	}
	return ""
}

func (m *PersonalAccessToken) GetScopes() []string {
	if m != nil {
		return m.Scopes
	}
	return nil
}

func (m *PersonalAccessToken) GetAutoRefreshWindow() int32 {
	if m != nil {
		return m.AutoRefreshWindow
	}
	return 0
}

func (m *PersonalAccessToken) GetExpiresAt() int64 {
	if m != nil {
		return m.ExpiresAt
	}
	return 0
}

func (m *PersonalAccessToken) GetCreatedBy() string {
	if m != nil {
		return m.CreatedBy
	}
	return ""
}

func (m *PersonalAccessToken) GetCreatedAt() int64 {
	if m != nil {
		return m.CreatedAt
	}
	return 0
}

func (m *PersonalAccessToken) GetUpdatedAt() int64 {
	if m != nil {
		return m.UpdatedAt
	}
	return 0
}

type PatGenerateRequest struct {
	Type              PatType  `protobuf:"varint,1,opt,name=Type,enum=auth.PatType" json:"Type,omitempty"`
	UserUuid          string   `protobuf:"bytes,2,opt,name=UserUuid" json:"UserUuid,omitempty"`
	UserLogin         string   `protobuf:"bytes,3,opt,name=UserLogin" json:"UserLogin,omitempty"`
	Label             string   `protobuf:"bytes,4,opt,name=Label" json:"Label,omitempty"`
	AutoRefreshWindow int32    `protobuf:"varint,5,opt,name=AutoRefreshWindow" json:"AutoRefreshWindow,omitempty"`
	ExpiresAt         int64    `protobuf:"varint,6,opt,name=ExpiresAt" json:"ExpiresAt,omitempty"`
	Issuer            string   `protobuf:"bytes,7,opt,name=Issuer" json:"Issuer,omitempty"`
	Scopes            []string `protobuf:"bytes,8,rep,name=Scopes" json:"Scopes,omitempty"`
}

func (m *PatGenerateRequest) Reset()                    { *m = PatGenerateRequest{} }
func (m *PatGenerateRequest) String() string            { return proto.CompactTextString(m) }
func (*PatGenerateRequest) ProtoMessage()               {}
func (*PatGenerateRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{33} }

func (m *PatGenerateRequest) GetType() PatType {
	if m != nil {
		return m.Type
	}
	return PatType_ANY
}

func (m *PatGenerateRequest) GetUserUuid() string {
	if m != nil {
		return m.UserUuid
	}
	return ""
}

func (m *PatGenerateRequest) GetUserLogin() string {
	if m != nil {
		return m.UserLogin
	}
	return ""
}

func (m *PatGenerateRequest) GetLabel() string {
	if m != nil {
		return m.Label
	}
	return ""
}

func (m *PatGenerateRequest) GetAutoRefreshWindow() int32 {
	if m != nil {
		return m.AutoRefreshWindow
	}
	return 0
}

func (m *PatGenerateRequest) GetExpiresAt() int64 {
	if m != nil {
		return m.ExpiresAt
	}
	return 0
}

func (m *PatGenerateRequest) GetIssuer() string {
	if m != nil {
		return m.Issuer
	}
	return ""
}

func (m *PatGenerateRequest) GetScopes() []string {
	if m != nil {
		return m.Scopes
	}
	return nil
}

type PatGenerateResponse struct {
	AccessToken string `protobuf:"bytes,1,opt,name=AccessToken" json:"AccessToken,omitempty"`
	TokenUuid   string `protobuf:"bytes,2,opt,name=TokenUuid" json:"TokenUuid,omitempty"`
}

func (m *PatGenerateResponse) Reset()                    { *m = PatGenerateResponse{} }
func (m *PatGenerateResponse) String() string            { return proto.CompactTextString(m) }
func (*PatGenerateResponse) ProtoMessage()               {}
func (*PatGenerateResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{34} }

func (m *PatGenerateResponse) GetAccessToken() string {
	if m != nil {
		return m.AccessToken
	}
	return ""
}

func (m *PatGenerateResponse) GetTokenUuid() string {
	if m != nil {
		return m.TokenUuid
	}
	return ""
}

type PatListRequest struct {
	Type        PatType `protobuf:"varint,1,opt,name=Type,enum=auth.PatType" json:"Type,omitempty"`
	ByUserLogin string  `protobuf:"bytes,2,opt,name=ByUserLogin" json:"ByUserLogin,omitempty"`
}

func (m *PatListRequest) Reset()                    { *m = PatListRequest{} }
func (m *PatListRequest) String() string            { return proto.CompactTextString(m) }
func (*PatListRequest) ProtoMessage()               {}
func (*PatListRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{35} }

func (m *PatListRequest) GetType() PatType {
	if m != nil {
		return m.Type
	}
	return PatType_ANY
}

func (m *PatListRequest) GetByUserLogin() string {
	if m != nil {
		return m.ByUserLogin
	}
	return ""
}

type PatListResponse struct {
	Tokens []*PersonalAccessToken `protobuf:"bytes,1,rep,name=Tokens" json:"Tokens,omitempty"`
}

func (m *PatListResponse) Reset()                    { *m = PatListResponse{} }
func (m *PatListResponse) String() string            { return proto.CompactTextString(m) }
func (*PatListResponse) ProtoMessage()               {}
func (*PatListResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{36} }

func (m *PatListResponse) GetTokens() []*PersonalAccessToken {
	if m != nil {
		return m.Tokens
	}
	return nil
}

type PatRevokeRequest struct {
	Uuid string `protobuf:"bytes,1,opt,name=Uuid" json:"Uuid,omitempty"`
}

func (m *PatRevokeRequest) Reset()                    { *m = PatRevokeRequest{} }
func (m *PatRevokeRequest) String() string            { return proto.CompactTextString(m) }
func (*PatRevokeRequest) ProtoMessage()               {}
func (*PatRevokeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{37} }

func (m *PatRevokeRequest) GetUuid() string {
	if m != nil {
		return m.Uuid
	}
	return ""
}

type PatRevokeResponse struct {
	Success bool `protobuf:"varint,1,opt,name=Success" json:"Success,omitempty"`
}

func (m *PatRevokeResponse) Reset()                    { *m = PatRevokeResponse{} }
func (m *PatRevokeResponse) String() string            { return proto.CompactTextString(m) }
func (*PatRevokeResponse) ProtoMessage()               {}
func (*PatRevokeResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{38} }

func (m *PatRevokeResponse) GetSuccess() bool {
	if m != nil {
		return m.Success
	}
	return false
}

func init() {
	proto.RegisterType((*Token)(nil), "auth.Token")
	proto.RegisterType((*RevokeTokenRequest)(nil), "auth.RevokeTokenRequest")
	proto.RegisterType((*RevokeTokenResponse)(nil), "auth.RevokeTokenResponse")
	proto.RegisterType((*PruneTokensRequest)(nil), "auth.PruneTokensRequest")
	proto.RegisterType((*PruneTokensResponse)(nil), "auth.PruneTokensResponse")
	proto.RegisterType((*ID)(nil), "auth.ID")
	proto.RegisterType((*GetLoginRequest)(nil), "auth.GetLoginRequest")
	proto.RegisterType((*GetLoginResponse)(nil), "auth.GetLoginResponse")
	proto.RegisterType((*CreateLoginRequest)(nil), "auth.CreateLoginRequest")
	proto.RegisterType((*CreateLoginResponse)(nil), "auth.CreateLoginResponse")
	proto.RegisterType((*AcceptLoginRequest)(nil), "auth.AcceptLoginRequest")
	proto.RegisterType((*AcceptLoginResponse)(nil), "auth.AcceptLoginResponse")
	proto.RegisterType((*GetConsentRequest)(nil), "auth.GetConsentRequest")
	proto.RegisterType((*GetConsentResponse)(nil), "auth.GetConsentResponse")
	proto.RegisterType((*CreateConsentRequest)(nil), "auth.CreateConsentRequest")
	proto.RegisterType((*CreateConsentResponse)(nil), "auth.CreateConsentResponse")
	proto.RegisterType((*AcceptConsentRequest)(nil), "auth.AcceptConsentRequest")
	proto.RegisterType((*AcceptConsentResponse)(nil), "auth.AcceptConsentResponse")
	proto.RegisterType((*CreateLogoutRequest)(nil), "auth.CreateLogoutRequest")
	proto.RegisterType((*CreateLogoutResponse)(nil), "auth.CreateLogoutResponse")
	proto.RegisterType((*AcceptLogoutRequest)(nil), "auth.AcceptLogoutRequest")
	proto.RegisterType((*AcceptLogoutResponse)(nil), "auth.AcceptLogoutResponse")
	proto.RegisterType((*CreateAuthCodeRequest)(nil), "auth.CreateAuthCodeRequest")
	proto.RegisterType((*CreateAuthCodeResponse)(nil), "auth.CreateAuthCodeResponse")
	proto.RegisterType((*VerifyTokenRequest)(nil), "auth.VerifyTokenRequest")
	proto.RegisterType((*VerifyTokenResponse)(nil), "auth.VerifyTokenResponse")
	proto.RegisterType((*ExchangeRequest)(nil), "auth.ExchangeRequest")
	proto.RegisterType((*ExchangeResponse)(nil), "auth.ExchangeResponse")
	proto.RegisterType((*PasswordCredentialsTokenRequest)(nil), "auth.PasswordCredentialsTokenRequest")
	proto.RegisterType((*PasswordCredentialsTokenResponse)(nil), "auth.PasswordCredentialsTokenResponse")
	proto.RegisterType((*RefreshTokenRequest)(nil), "auth.RefreshTokenRequest")
	proto.RegisterType((*RefreshTokenResponse)(nil), "auth.RefreshTokenResponse")
	proto.RegisterType((*PersonalAccessToken)(nil), "auth.PersonalAccessToken")
	proto.RegisterType((*PatGenerateRequest)(nil), "auth.PatGenerateRequest")
	proto.RegisterType((*PatGenerateResponse)(nil), "auth.PatGenerateResponse")
	proto.RegisterType((*PatListRequest)(nil), "auth.PatListRequest")
	proto.RegisterType((*PatListResponse)(nil), "auth.PatListResponse")
	proto.RegisterType((*PatRevokeRequest)(nil), "auth.PatRevokeRequest")
	proto.RegisterType((*PatRevokeResponse)(nil), "auth.PatRevokeResponse")
	proto.RegisterEnum("auth.PatType", PatType_name, PatType_value)
}

func init() { proto.RegisterFile("auth.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 1651 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x18, 0x4b, 0x6f, 0x13, 0x57,
	0xd7, 0xe3, 0x57, 0x9c, 0x63, 0x27, 0x71, 0x6e, 0x1e, 0x98, 0xf9, 0x10, 0x9f, 0xb9, 0xa8, 0x29,
	0xa2, 0x34, 0x08, 0x57, 0xa8, 0x14, 0x24, 0x90, 0xb1, 0xd3, 0xc8, 0x28, 0x80, 0x35, 0x49, 0x4a,
	0x59, 0xa1, 0xc1, 0xbe, 0x90, 0x69, 0xcc, 0x8c, 0x3b, 0x8f, 0x80, 0xd7, 0x55, 0xd5, 0x55, 0x17,
	0xfd, 0x01, 0xdd, 0xf4, 0x87, 0xf4, 0x4f, 0x74, 0x53, 0xf5, 0x37, 0xf4, 0x07, 0x54, 0x5d, 0x55,
	0xf7, 0x35, 0x73, 0xef, 0xcc, 0xe0, 0x24, 0x6c, 0xd8, 0xcd, 0x39, 0xe7, 0xde, 0x73, 0xcf, 0xfb,
	0x31, 0x00, 0x76, 0x14, 0x1e, 0x6d, 0x4f, 0x7d, 0x2f, 0xf4, 0x50, 0x99, 0x7e, 0xe3, 0x1f, 0x0d,
	0xa8, 0x1c, 0x78, 0xc7, 0xc4, 0x45, 0x6d, 0xa8, 0x77, 0x47, 0x23, 0x12, 0x04, 0x0c, 0x6c, 0x19,
	0x6d, 0xe3, 0xda, 0xa2, 0xa5, 0xa2, 0x50, 0x0b, 0x16, 0x06, 0x7d, 0x4e, 0x2d, 0x32, 0xaa, 0x04,
	0x11, 0x86, 0x86, 0x45, 0x5e, 0xf9, 0x24, 0x38, 0xe2, 0xe4, 0x12, 0x23, 0x6b, 0x38, 0x74, 0x09,
	0x16, 0x77, 0xde, 0x4d, 0x1d, 0x9f, 0x04, 0xdd, 0xb0, 0x55, 0x66, 0x07, 0x12, 0x04, 0xfe, 0x12,
	0x90, 0x45, 0x4e, 0xbc, 0x63, 0xc2, 0x0e, 0x5b, 0xe4, 0xfb, 0x88, 0x04, 0x21, 0xba, 0x22, 0x84,
	0x63, 0xd2, 0xd4, 0x3b, 0xf5, 0x6d, 0x26, 0x3f, 0x3f, 0xc2, 0x29, 0xf8, 0x26, 0xac, 0x69, 0x17,
	0x83, 0xa9, 0xe7, 0x06, 0x84, 0xca, 0xba, 0x1f, 0x31, 0xd9, 0xd9, 0xdd, 0x9a, 0x25, 0x41, 0xbc,
	0x0e, 0x68, 0xe8, 0x47, 0x2e, 0x3f, 0x1f, 0x88, 0x97, 0x70, 0x0f, 0xd6, 0x34, 0xac, 0x60, 0xb3,
	0x09, 0xd5, 0x90, 0x61, 0x5a, 0x46, 0xbb, 0x74, 0x6d, 0xd1, 0x12, 0x10, 0x5a, 0x87, 0x4a, 0xcf,
	0x8b, 0xdc, 0x90, 0x19, 0xa2, 0x62, 0x71, 0x00, 0x5b, 0x50, 0x1c, 0xf4, 0xa9, 0xa2, 0xbd, 0x23,
	0x7b, 0x32, 0x21, 0xee, 0x6b, 0x22, 0xcc, 0x98, 0x20, 0x90, 0x09, 0xb5, 0x6f, 0x88, 0xef, 0xbc,
	0x72, 0x88, 0x2f, 0xac, 0x18, 0xc3, 0x08, 0x41, 0xb9, 0xb7, 0x6f, 0x7d, 0x2d, 0xcc, 0xc7, 0xbe,
	0xf1, 0x4d, 0x58, 0xd9, 0x25, 0xe1, 0x9e, 0xf7, 0xda, 0x89, 0xad, 0x32, 0xf7, 0x01, 0xfc, 0xaf,
	0x01, 0xcd, 0xe4, 0x86, 0xd0, 0x63, 0xbe, 0x4c, 0xcc, 0x58, 0x2f, 0xbf, 0x23, 0xa3, 0x50, 0x3a,
	0x56, 0x80, 0xf4, 0xde, 0x3e, 0x09, 0x02, 0xc7, 0x73, 0x07, 0x7d, 0x21, 0x56, 0x82, 0x40, 0x97,
	0x01, 0x84, 0x4c, 0x87, 0xd6, 0x9e, 0xf0, 0xa9, 0x82, 0x41, 0x5b, 0xb0, 0x2c, 0x20, 0x32, 0xde,
	0x1f, 0x79, 0x53, 0xd2, 0xaa, 0x30, 0x2b, 0xa6, 0xb0, 0xe8, 0x06, 0xac, 0xc6, 0x98, 0x6e, 0x34,
	0x76, 0x88, 0x3b, 0x22, 0xad, 0x2a, 0x3b, 0x9a, 0x25, 0x50, 0x0b, 0xf6, 0x26, 0x0e, 0x71, 0xc3,
	0x41, 0xbf, 0xb5, 0xc0, 0x2d, 0x28, 0x61, 0xfc, 0x0a, 0x50, 0xcf, 0x27, 0x76, 0x48, 0x34, 0x83,
	0xa9, 0x37, 0x0c, 0xfd, 0x06, 0xf5, 0x30, 0x13, 0x22, 0x68, 0x15, 0xb9, 0x87, 0x39, 0x44, 0x35,
	0x97, 0x2f, 0x06, 0xad, 0x12, 0x23, 0x25, 0x08, 0x7c, 0x1b, 0xd6, 0xb4, 0x77, 0x84, 0x99, 0x2f,
	0x43, 0x85, 0x21, 0x44, 0xbc, 0xd6, 0x78, 0xbc, 0x0e, 0xfa, 0x16, 0x47, 0xe3, 0x23, 0x40, 0x34,
	0xa1, 0xa6, 0xe7, 0xf0, 0xe7, 0xdc, 0x80, 0x51, 0x1c, 0x57, 0xd2, 0x1c, 0x87, 0x37, 0x60, 0x4d,
	0x7b, 0x89, 0x0b, 0x88, 0x6f, 0xc1, 0xea, 0x2e, 0x09, 0x7b, 0xf4, 0xdb, 0x0d, 0xcf, 0x16, 0x4f,
	0xbf, 0x1b, 0x80, 0xd4, 0x3b, 0x67, 0x8a, 0xa8, 0x2d, 0x58, 0x66, 0x0f, 0x27, 0xc1, 0xc3, 0x45,
	0x4f, 0x61, 0xa9, 0xe7, 0x85, 0xc4, 0x83, 0x31, 0x71, 0x43, 0xae, 0x25, 0x57, 0x25, 0x4b, 0x50,
	0xd5, 0x2d, 0xeb, 0x71, 0xaa, 0x7a, 0xb8, 0x92, 0x8a, 0x89, 0xfb, 0xb0, 0xce, 0x7d, 0x95, 0x52,
	0x5b, 0xca, 0x98, 0x56, 0x23, 0x85, 0xc5, 0xf7, 0x60, 0x23, 0x75, 0x5f, 0x98, 0x00, 0xc3, 0x82,
	0x40, 0x65, 0xfc, 0x2d, 0x09, 0xf8, 0x9f, 0x22, 0xac, 0x73, 0x47, 0x9c, 0xc7, 0xe8, 0x1f, 0x16,
	0x95, 0xe8, 0xb1, 0x5e, 0xc2, 0xcb, 0xed, 0xd2, 0xb5, 0x7a, 0xe7, 0x33, 0x2e, 0x54, 0x9e, 0x10,
	0xdb, 0xca, 0xe9, 0x1d, 0x37, 0xf4, 0x67, 0x7a, 0xbd, 0xef, 0x26, 0xf5, 0xbe, 0xc2, 0x58, 0x7d,
	0x3a, 0x87, 0x95, 0x38, 0xc9, 0xd9, 0xc8, 0x7b, 0xe6, 0x7d, 0x68, 0xa6, 0xdf, 0x40, 0x4d, 0x28,
	0x1d, 0x93, 0x99, 0xd0, 0x99, 0x7e, 0xd2, 0x6a, 0x7a, 0x62, 0x4f, 0x22, 0x22, 0x82, 0x84, 0x03,
	0x77, 0x8b, 0x77, 0x0c, 0xf3, 0x2e, 0x34, 0x54, 0xc6, 0xe7, 0xb9, 0x8b, 0x2f, 0xc0, 0x46, 0x4a,
	0x52, 0x91, 0x04, 0x6f, 0x94, 0xe4, 0xf5, 0xa2, 0xd8, 0x23, 0x7a, 0x35, 0x33, 0x32, 0xd5, 0xec,
	0x03, 0xab, 0x24, 0xbe, 0x23, 0xe3, 0x4f, 0x3e, 0x27, 0xc2, 0xa7, 0x0d, 0x55, 0x8e, 0xc9, 0x44,
	0x8f, 0xc0, 0xe3, 0x99, 0x92, 0xc4, 0x8a, 0xa0, 0xf3, 0x43, 0x27, 0xd5, 0xc7, 0x8b, 0xd9, 0x3e,
	0x7e, 0x86, 0x6e, 0x8d, 0x37, 0x65, 0xd8, 0xea, 0x42, 0xe3, 0x99, 0x4c, 0x86, 0x6e, 0x14, 0x1e,
	0xf5, 0xbc, 0x31, 0x91, 0x42, 0x9d, 0x21, 0x19, 0xb4, 0x2c, 0x2d, 0xa6, 0xea, 0x70, 0x1b, 0xea,
	0x16, 0x19, 0x3b, 0x3e, 0x19, 0x85, 0x87, 0xd6, 0x40, 0xc8, 0xa4, 0xa2, 0xf0, 0x0d, 0xd8, 0x4c,
	0x3f, 0x2d, 0x2c, 0x49, 0xfb, 0xa6, 0x37, 0x96, 0xb6, 0x60, 0xdf, 0xf8, 0x3a, 0x20, 0x56, 0x26,
	0x67, 0xda, 0x40, 0xb1, 0xae, 0x0e, 0x14, 0x8b, 0x72, 0x86, 0xe8, 0xc1, 0x9a, 0x76, 0xf6, 0xb4,
	0x19, 0x82, 0x3e, 0xd8, 0xb7, 0x43, 0x9b, 0x29, 0xd1, 0xb0, 0xd8, 0x37, 0x7e, 0x04, 0x2b, 0x3b,
	0xef, 0x46, 0x47, 0xb6, 0xfb, 0x3a, 0xb6, 0x49, 0x4a, 0xae, 0x91, 0x37, 0x26, 0xe8, 0x2a, 0x34,
	0x28, 0x2e, 0x55, 0xd2, 0x97, 0x28, 0xed, 0xc5, 0x89, 0x40, 0xe2, 0x9f, 0x0d, 0x68, 0x26, 0xcc,
	0x84, 0x38, 0x57, 0xf2, 0x06, 0xb4, 0x86, 0xcd, 0x50, 0x2f, 0xd8, 0x5c, 0x82, 0x2e, 0xa6, 0x27,
	0xb4, 0x9a, 0x33, 0x16, 0xa4, 0xab, 0xb9, 0x4e, 0x5f, 0xf2, 0x39, 0x4e, 0x1c, 0xda, 0x84, 0x2a,
	0x1b, 0xc9, 0x66, 0xac, 0xbe, 0x96, 0xac, 0x2a, 0x61, 0x10, 0x7e, 0x0e, 0xff, 0x1f, 0xda, 0x41,
	0xf0, 0xd6, 0xf3, 0xc7, 0x3d, 0x9f, 0xb0, 0x82, 0x6c, 0x4f, 0x02, 0xcd, 0xb2, 0x26, 0xd4, 0x0e,
	0x03, 0xe2, 0xbb, 0xf6, 0x1b, 0xa9, 0x6f, 0x2d, 0x12, 0x30, 0xa5, 0xc9, 0xeb, 0x52, 0xae, 0xa9,
	0x80, 0xf1, 0xaf, 0x06, 0xb4, 0xdf, 0xcf, 0xfb, 0xe3, 0xab, 0xfe, 0x15, 0x9d, 0x2f, 0x93, 0xcb,
	0x49, 0xb8, 0xeb, 0x3c, 0x8d, 0x9c, 0x1c, 0xfa, 0xc5, 0x80, 0x75, 0xfd, 0xee, 0xc7, 0x57, 0xe7,
	0xaf, 0x22, 0xac, 0x0d, 0x89, 0x1f, 0x78, 0xae, 0x3d, 0x51, 0x6b, 0x02, 0x82, 0xf2, 0x61, 0xe4,
	0x8c, 0x65, 0xa8, 0xd2, 0x6f, 0x74, 0x05, 0xca, 0x07, 0xb3, 0x29, 0xaf, 0xac, 0xcb, 0x9d, 0x25,
	0x9e, 0xcf, 0x43, 0x3b, 0xa4, 0x48, 0x8b, 0x91, 0x68, 0x3e, 0xed, 0xd9, 0x2f, 0xc9, 0x44, 0x08,
	0xc1, 0x01, 0x19, 0x0b, 0x8c, 0x21, 0x6f, 0xd4, 0x31, 0x4c, 0x8b, 0x17, 0xfd, 0xe6, 0x63, 0x12,
	0x6f, 0xd5, 0x09, 0x42, 0xe9, 0x7b, 0x55, 0xad, 0xef, 0xdd, 0x80, 0xd5, 0x6e, 0x14, 0x7a, 0x42,
	0xef, 0x67, 0x8e, 0x3b, 0xf6, 0xde, 0xb2, 0xe1, 0xaf, 0x62, 0x65, 0x09, 0xfa, 0xaa, 0x51, 0x63,
	0xfa, 0x27, 0x08, 0x56, 0x3e, 0x59, 0x1d, 0x19, 0x3f, 0x9c, 0xb5, 0x16, 0x45, 0xf9, 0x94, 0x08,
	0x85, 0xda, 0x0d, 0x5b, 0xc0, 0xef, 0xc6, 0x08, 0x26, 0xfd, 0x74, 0x2c, 0xa8, 0x75, 0x4e, 0x8d,
	0x11, 0xf8, 0x87, 0x22, 0xa0, 0xa1, 0x1d, 0xee, 0x12, 0x97, 0xf8, 0x76, 0x48, 0x92, 0x2d, 0x86,
	0xdb, 0xd1, 0x78, 0xbf, 0x1d, 0x55, 0x8b, 0x15, 0xe7, 0x59, 0xac, 0x94, 0xb6, 0x58, 0xec, 0x81,
	0xb2, 0xea, 0x81, 0x5c, 0x7b, 0x55, 0xce, 0x64, 0xaf, 0x6a, 0xda, 0x5e, 0x9b, 0x50, 0x1d, 0x04,
	0x41, 0x44, 0x7c, 0x31, 0x6d, 0x0b, 0x48, 0xf1, 0x55, 0x4d, 0xf5, 0x15, 0x3e, 0x84, 0x35, 0xcd,
	0x08, 0x71, 0xbb, 0x3b, 0x6d, 0xbf, 0xbc, 0x04, 0x8b, 0xec, 0x43, 0xb1, 0x42, 0x82, 0xc0, 0x87,
	0xb0, 0x3c, 0xb4, 0xc3, 0x3d, 0x27, 0x08, 0xcf, 0x61, 0xd7, 0x36, 0xd4, 0x1f, 0xce, 0x12, 0xeb,
	0x89, 0x66, 0xa8, 0xa0, 0x70, 0x1f, 0x56, 0x62, 0xb6, 0x42, 0xd2, 0x5b, 0x50, 0x3d, 0x48, 0x96,
	0xbe, 0x7a, 0xe7, 0xa2, 0xe0, 0x9c, 0x4d, 0x1b, 0x4b, 0x1c, 0xc4, 0x5b, 0xd0, 0x1c, 0xda, 0x21,
	0x5f, 0x44, 0x95, 0xea, 0x9f, 0x4e, 0x29, 0xfc, 0x39, 0xac, 0x2a, 0xe7, 0x4e, 0xeb, 0x33, 0xd7,
	0xb7, 0x61, 0x41, 0xe8, 0x83, 0x16, 0xa0, 0xd4, 0x7d, 0xf2, 0xbc, 0x59, 0x40, 0x0d, 0xa8, 0x0d,
	0x77, 0xac, 0xfd, 0xa7, 0x4f, 0xba, 0x7b, 0x4d, 0x83, 0x42, 0xfd, 0xa7, 0xbd, 0xc3, 0xc7, 0x3b,
	0x4f, 0x0e, 0x9a, 0xc5, 0xce, 0x3e, 0x34, 0x69, 0x73, 0x14, 0xd5, 0x86, 0x3e, 0xe2, 0xa3, 0x07,
	0x50, 0xe5, 0x9f, 0xa8, 0xc5, 0xf5, 0xc8, 0xee, 0xd9, 0xe6, 0xc5, 0x1c, 0x8a, 0x68, 0xf8, 0x85,
	0xce, 0x33, 0x58, 0x89, 0x99, 0xb2, 0x1d, 0xd9, 0x47, 0x7d, 0xa8, 0x2b, 0xdb, 0xb2, 0x64, 0x9c,
	0x5d, 0xab, 0x25, 0xe3, 0x9c, 0xd5, 0x1a, 0x17, 0x3a, 0x7f, 0x1a, 0xb0, 0xc4, 0x9c, 0x30, 0xf4,
	0xbd, 0x13, 0x67, 0x4c, 0x7c, 0x74, 0x0f, 0x6a, 0x72, 0x75, 0x45, 0x1b, 0xfc, 0x6a, 0x6a, 0xf9,
	0x35, 0x37, 0xd3, 0x68, 0xc9, 0x8e, 0x0a, 0xa5, 0xec, 0x64, 0x52, 0xa8, 0xec, 0x3a, 0x28, 0x85,
	0xca, 0x59, 0xe0, 0x38, 0x17, 0x65, 0x71, 0x92, 0x5c, 0xb2, 0x5b, 0x9b, 0xe4, 0x92, 0xb7, 0x65,
	0x15, 0x3a, 0x7f, 0x1b, 0xb0, 0x22, 0xa6, 0x9e, 0x58, 0xb9, 0x2e, 0x40, 0xb2, 0x47, 0xa1, 0x0b,
	0xb1, 0x1e, 0xfa, 0x20, 0x6d, 0xb6, 0xb2, 0x84, 0x58, 0xb8, 0x47, 0xb0, 0xa4, 0xad, 0x22, 0xc8,
	0x54, 0x55, 0x49, 0x31, 0xfa, 0x5f, 0x2e, 0x4d, 0xe5, 0xa5, 0x8d, 0xc7, 0x92, 0x57, 0xde, 0x74,
	0x2f, 0x79, 0xe5, 0xcf, 0xd3, 0x85, 0xce, 0x6f, 0x06, 0xdb, 0xa5, 0xbc, 0x28, 0xd1, 0x76, 0x17,
	0x1a, 0xea, 0xd4, 0x8b, 0xd2, 0x46, 0x4f, 0xe6, 0x59, 0xd3, 0xcc, 0x23, 0xc5, 0x72, 0xee, 0x42,
	0x43, 0x9d, 0x44, 0x51, 0xda, 0xee, 0x59, 0x46, 0xb9, 0x83, 0x6b, 0xa1, 0x63, 0xf3, 0xe4, 0xa0,
	0xd3, 0x57, 0x2c, 0xe5, 0x63, 0x58, 0xd6, 0x67, 0x4a, 0xa4, 0x59, 0x2d, 0x35, 0xe4, 0x9a, 0x97,
	0xf2, 0x89, 0xf1, 0x13, 0x07, 0xac, 0xec, 0xf2, 0x54, 0x89, 0x97, 0xf4, 0x07, 0x50, 0xe5, 0xd3,
	0xa5, 0x0c, 0xa6, 0xec, 0x5c, 0x2a, 0x83, 0x29, 0x67, 0x0a, 0xc5, 0x85, 0xce, 0x90, 0x73, 0xa5,
	0x6f, 0xc9, 0xa1, 0x90, 0xa5, 0x8a, 0x04, 0x64, 0xaa, 0xa4, 0xc6, 0x4f, 0x99, 0x2a, 0xe9, 0x41,
	0x12, 0x17, 0x3a, 0x3f, 0x19, 0xd0, 0x7a, 0xdf, 0xd0, 0x85, 0x8e, 0xe7, 0xd0, 0x3e, 0x91, 0x45,
	0x76, 0xee, 0x30, 0x68, 0x6e, 0x9d, 0x76, 0x2c, 0x96, 0xe4, 0x5b, 0x40, 0x4a, 0xc5, 0x62, 0x4d,
	0x89, 0xf8, 0xe8, 0x21, 0x2c, 0x08, 0x00, 0xc5, 0xa5, 0x29, 0x33, 0x83, 0x49, 0x77, 0xe7, 0x8d,
	0x58, 0xb8, 0xd0, 0xf9, 0xc3, 0x00, 0x33, 0xa7, 0x64, 0xef, 0x13, 0xff, 0xc4, 0x19, 0x11, 0xd4,
	0xa5, 0xa5, 0x86, 0xb7, 0xa8, 0xb8, 0x7e, 0x65, 0x5a, 0x77, 0x5c, 0xbf, 0xb2, 0xfd, 0x0c, 0x17,
	0xd0, 0xbd, 0xb8, 0xb2, 0x6e, 0xc6, 0xc7, 0xb4, 0x16, 0x60, 0x5e, 0xc8, 0xe0, 0xe3, 0xcb, 0xb7,
	0xa1, 0x4c, 0x9b, 0x0e, 0x5a, 0x8f, 0x8f, 0x28, 0xad, 0xcd, 0xdc, 0x48, 0x61, 0xe5, 0xb5, 0x97,
	0x55, 0xf6, 0xf3, 0xf6, 0x8b, 0xff, 0x02, 0x00, 0x00, 0xff, 0xff, 0xb7, 0x7b, 0x09, 0x8e, 0xca,
	0x15, 0x00, 0x00,
}
