// Code generated by protoc-gen-go. DO NOT EDIT.
// source: encryption.proto

/*
Package encryption is a generated protocol buffer package.

It is generated from these files:
	encryption.proto

It has these top-level messages:
	Export
	Import
	KeyInfo
	Key
	AddKeyRequest
	AddKeyResponse
	GetKeyRequest
	GetKeyResponse
	AdminListKeysRequest
	AdminListKeysResponse
	AdminDeleteKeyRequest
	AdminDeleteKeyResponse
	AdminExportKeyRequest
	AdminExportKeyResponse
	AdminImportKeyRequest
	AdminImportKeyResponse
	AdminCreateKeyRequest
	AdminCreateKeyResponse
	NodeKey
	Node
	NodeInfo
	Block
	RangedBlock
	GetNodeInfoRequest
	GetNodeInfoResponse
	GetNodePlainSizeRequest
	GetNodePlainSizeResponse
	SetNodeInfoRequest
	SetNodeInfoResponse
	DeleteNodeRequest
	DeleteNodeResponse
	DeleteNodeKeyRequest
	DeleteNodeKeyResponse
	DeleteNodeSharedKeyRequest
	DeleteNodeSharedKeyResponse
	SetNodeKeyRequest
	SetNodeKeyResponse
	SetNodeBlockRequest
	SetNodeBlockResponse
	CopyNodeInfoRequest
	CopyNodeInfoResponse
*/
package encryption

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type Export struct {
	// Name of exporter
	By string `protobuf:"bytes,1,opt,name=By" json:"By,omitempty"`
	// Date of export
	Date int32 `protobuf:"varint,2,opt,name=Date" json:"Date,omitempty"`
}

func (m *Export) Reset()                    { *m = Export{} }
func (m *Export) String() string            { return proto.CompactTextString(m) }
func (*Export) ProtoMessage()               {}
func (*Export) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *Export) GetBy() string {
	if m != nil {
		return m.By
	}
	return ""
}

func (m *Export) GetDate() int32 {
	if m != nil {
		return m.Date
	}
	return 0
}

type Import struct {
	// Name of importer
	By string `protobuf:"bytes,1,opt,name=By" json:"By,omitempty"`
	// Date of import
	Date int32 `protobuf:"varint,3,opt,name=Date" json:"Date,omitempty"`
}

func (m *Import) Reset()                    { *m = Import{} }
func (m *Import) String() string            { return proto.CompactTextString(m) }
func (*Import) ProtoMessage()               {}
func (*Import) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *Import) GetBy() string {
	if m != nil {
		return m.By
	}
	return ""
}

func (m *Import) GetDate() int32 {
	if m != nil {
		return m.Date
	}
	return 0
}

type KeyInfo struct {
	Exports []*Export `protobuf:"bytes,1,rep,name=Exports" json:"Exports,omitempty"`
	Imports []*Import `protobuf:"bytes,2,rep,name=Imports" json:"Imports,omitempty"`
}

func (m *KeyInfo) Reset()                    { *m = KeyInfo{} }
func (m *KeyInfo) String() string            { return proto.CompactTextString(m) }
func (*KeyInfo) ProtoMessage()               {}
func (*KeyInfo) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *KeyInfo) GetExports() []*Export {
	if m != nil {
		return m.Exports
	}
	return nil
}

func (m *KeyInfo) GetImports() []*Import {
	if m != nil {
		return m.Imports
	}
	return nil
}

type Key struct {
	// Key owner
	Owner string `protobuf:"bytes,1,opt,name=Owner" json:"Owner,omitempty"`
	// Key ID
	ID string `protobuf:"bytes,2,opt,name=ID" json:"ID,omitempty"`
	// Key label
	Label string `protobuf:"bytes,3,opt,name=Label" json:"Label,omitempty"`
	// Key content
	Content string `protobuf:"bytes,4,opt,name=Content" json:"Content,omitempty"`
	// Key creation date
	CreationDate int32 `protobuf:"varint,5,opt,name=CreationDate" json:"CreationDate,omitempty"`
	// Additional key info
	Info *KeyInfo `protobuf:"bytes,6,opt,name=Info" json:"Info,omitempty"`
}

func (m *Key) Reset()                    { *m = Key{} }
func (m *Key) String() string            { return proto.CompactTextString(m) }
func (*Key) ProtoMessage()               {}
func (*Key) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *Key) GetOwner() string {
	if m != nil {
		return m.Owner
	}
	return ""
}

func (m *Key) GetID() string {
	if m != nil {
		return m.ID
	}
	return ""
}

func (m *Key) GetLabel() string {
	if m != nil {
		return m.Label
	}
	return ""
}

func (m *Key) GetContent() string {
	if m != nil {
		return m.Content
	}
	return ""
}

func (m *Key) GetCreationDate() int32 {
	if m != nil {
		return m.CreationDate
	}
	return 0
}

func (m *Key) GetInfo() *KeyInfo {
	if m != nil {
		return m.Info
	}
	return nil
}

type AddKeyRequest struct {
	// Key to add
	Key *Key `protobuf:"bytes,1,opt,name=Key" json:"Key,omitempty"`
	// Key password as string
	StrPassword string `protobuf:"bytes,2,opt,name=StrPassword" json:"StrPassword,omitempty"`
}

func (m *AddKeyRequest) Reset()                    { *m = AddKeyRequest{} }
func (m *AddKeyRequest) String() string            { return proto.CompactTextString(m) }
func (*AddKeyRequest) ProtoMessage()               {}
func (*AddKeyRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *AddKeyRequest) GetKey() *Key {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *AddKeyRequest) GetStrPassword() string {
	if m != nil {
		return m.StrPassword
	}
	return ""
}

type AddKeyResponse struct {
	Success bool `protobuf:"varint,1,opt,name=Success" json:"Success,omitempty"`
}

func (m *AddKeyResponse) Reset()                    { *m = AddKeyResponse{} }
func (m *AddKeyResponse) String() string            { return proto.CompactTextString(m) }
func (*AddKeyResponse) ProtoMessage()               {}
func (*AddKeyResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *AddKeyResponse) GetSuccess() bool {
	if m != nil {
		return m.Success
	}
	return false
}

type GetKeyRequest struct {
	Owner       string `protobuf:"bytes,1,opt,name=Owner" json:"Owner,omitempty"`
	KeyID       string `protobuf:"bytes,2,opt,name=KeyID" json:"KeyID,omitempty"`
	StrPassword string `protobuf:"bytes,3,opt,name=StrPassword" json:"StrPassword,omitempty"`
}

func (m *GetKeyRequest) Reset()                    { *m = GetKeyRequest{} }
func (m *GetKeyRequest) String() string            { return proto.CompactTextString(m) }
func (*GetKeyRequest) ProtoMessage()               {}
func (*GetKeyRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *GetKeyRequest) GetOwner() string {
	if m != nil {
		return m.Owner
	}
	return ""
}

func (m *GetKeyRequest) GetKeyID() string {
	if m != nil {
		return m.KeyID
	}
	return ""
}

func (m *GetKeyRequest) GetStrPassword() string {
	if m != nil {
		return m.StrPassword
	}
	return ""
}

type GetKeyResponse struct {
	Key *Key `protobuf:"bytes,1,opt,name=Key" json:"Key,omitempty"`
}

func (m *GetKeyResponse) Reset()                    { *m = GetKeyResponse{} }
func (m *GetKeyResponse) String() string            { return proto.CompactTextString(m) }
func (*GetKeyResponse) ProtoMessage()               {}
func (*GetKeyResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *GetKeyResponse) GetKey() *Key {
	if m != nil {
		return m.Key
	}
	return nil
}

type AdminListKeysRequest struct {
}

func (m *AdminListKeysRequest) Reset()                    { *m = AdminListKeysRequest{} }
func (m *AdminListKeysRequest) String() string            { return proto.CompactTextString(m) }
func (*AdminListKeysRequest) ProtoMessage()               {}
func (*AdminListKeysRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

type AdminListKeysResponse struct {
	Keys []*Key `protobuf:"bytes,1,rep,name=Keys" json:"Keys,omitempty"`
}

func (m *AdminListKeysResponse) Reset()                    { *m = AdminListKeysResponse{} }
func (m *AdminListKeysResponse) String() string            { return proto.CompactTextString(m) }
func (*AdminListKeysResponse) ProtoMessage()               {}
func (*AdminListKeysResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *AdminListKeysResponse) GetKeys() []*Key {
	if m != nil {
		return m.Keys
	}
	return nil
}

type AdminDeleteKeyRequest struct {
	// Id of the key to delete
	KeyID string `protobuf:"bytes,1,opt,name=KeyID" json:"KeyID,omitempty"`
}

func (m *AdminDeleteKeyRequest) Reset()                    { *m = AdminDeleteKeyRequest{} }
func (m *AdminDeleteKeyRequest) String() string            { return proto.CompactTextString(m) }
func (*AdminDeleteKeyRequest) ProtoMessage()               {}
func (*AdminDeleteKeyRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *AdminDeleteKeyRequest) GetKeyID() string {
	if m != nil {
		return m.KeyID
	}
	return ""
}

type AdminDeleteKeyResponse struct {
	Success bool `protobuf:"varint,1,opt,name=Success" json:"Success,omitempty"`
}

func (m *AdminDeleteKeyResponse) Reset()                    { *m = AdminDeleteKeyResponse{} }
func (m *AdminDeleteKeyResponse) String() string            { return proto.CompactTextString(m) }
func (*AdminDeleteKeyResponse) ProtoMessage()               {}
func (*AdminDeleteKeyResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *AdminDeleteKeyResponse) GetSuccess() bool {
	if m != nil {
		return m.Success
	}
	return false
}

type AdminExportKeyRequest struct {
	// Id of the key to export
	KeyID string `protobuf:"bytes,1,opt,name=KeyID" json:"KeyID,omitempty"`
	// Associated password as string
	StrPassword string `protobuf:"bytes,2,opt,name=StrPassword" json:"StrPassword,omitempty"`
}

func (m *AdminExportKeyRequest) Reset()                    { *m = AdminExportKeyRequest{} }
func (m *AdminExportKeyRequest) String() string            { return proto.CompactTextString(m) }
func (*AdminExportKeyRequest) ProtoMessage()               {}
func (*AdminExportKeyRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *AdminExportKeyRequest) GetKeyID() string {
	if m != nil {
		return m.KeyID
	}
	return ""
}

func (m *AdminExportKeyRequest) GetStrPassword() string {
	if m != nil {
		return m.StrPassword
	}
	return ""
}

type AdminExportKeyResponse struct {
	Key *Key `protobuf:"bytes,1,opt,name=Key" json:"Key,omitempty"`
}

func (m *AdminExportKeyResponse) Reset()                    { *m = AdminExportKeyResponse{} }
func (m *AdminExportKeyResponse) String() string            { return proto.CompactTextString(m) }
func (*AdminExportKeyResponse) ProtoMessage()               {}
func (*AdminExportKeyResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *AdminExportKeyResponse) GetKey() *Key {
	if m != nil {
		return m.Key
	}
	return nil
}

type AdminImportKeyRequest struct {
	// Imported key data
	Key *Key `protobuf:"bytes,1,opt,name=Key" json:"Key,omitempty"`
	// Key password
	StrPassword string `protobuf:"bytes,2,opt,name=StrPassword" json:"StrPassword,omitempty"`
	// Whether to override if a key with same ID already exists
	Override bool `protobuf:"varint,3,opt,name=Override" json:"Override,omitempty"`
}

func (m *AdminImportKeyRequest) Reset()                    { *m = AdminImportKeyRequest{} }
func (m *AdminImportKeyRequest) String() string            { return proto.CompactTextString(m) }
func (*AdminImportKeyRequest) ProtoMessage()               {}
func (*AdminImportKeyRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *AdminImportKeyRequest) GetKey() *Key {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *AdminImportKeyRequest) GetStrPassword() string {
	if m != nil {
		return m.StrPassword
	}
	return ""
}

func (m *AdminImportKeyRequest) GetOverride() bool {
	if m != nil {
		return m.Override
	}
	return false
}

type AdminImportKeyResponse struct {
	Success bool `protobuf:"varint,1,opt,name=Success" json:"Success,omitempty"`
}

func (m *AdminImportKeyResponse) Reset()                    { *m = AdminImportKeyResponse{} }
func (m *AdminImportKeyResponse) String() string            { return proto.CompactTextString(m) }
func (*AdminImportKeyResponse) ProtoMessage()               {}
func (*AdminImportKeyResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *AdminImportKeyResponse) GetSuccess() bool {
	if m != nil {
		return m.Success
	}
	return false
}

type AdminCreateKeyRequest struct {
	// Create a key with this ID
	KeyID string `protobuf:"bytes,1,opt,name=KeyID" json:"KeyID,omitempty"`
	// Provide label for the newly created key
	Label string `protobuf:"bytes,2,opt,name=Label" json:"Label,omitempty"`
}

func (m *AdminCreateKeyRequest) Reset()                    { *m = AdminCreateKeyRequest{} }
func (m *AdminCreateKeyRequest) String() string            { return proto.CompactTextString(m) }
func (*AdminCreateKeyRequest) ProtoMessage()               {}
func (*AdminCreateKeyRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *AdminCreateKeyRequest) GetKeyID() string {
	if m != nil {
		return m.KeyID
	}
	return ""
}

func (m *AdminCreateKeyRequest) GetLabel() string {
	if m != nil {
		return m.Label
	}
	return ""
}

type AdminCreateKeyResponse struct {
	Success bool `protobuf:"varint,1,opt,name=Success" json:"Success,omitempty"`
}

func (m *AdminCreateKeyResponse) Reset()                    { *m = AdminCreateKeyResponse{} }
func (m *AdminCreateKeyResponse) String() string            { return proto.CompactTextString(m) }
func (*AdminCreateKeyResponse) ProtoMessage()               {}
func (*AdminCreateKeyResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func (m *AdminCreateKeyResponse) GetSuccess() bool {
	if m != nil {
		return m.Success
	}
	return false
}

type NodeKey struct {
	NodeId  string `protobuf:"bytes,1,opt,name=NodeId" json:"NodeId,omitempty"`
	UserId  string `protobuf:"bytes,2,opt,name=UserId" json:"UserId,omitempty"`
	OwnerId string `protobuf:"bytes,3,opt,name=OwnerId" json:"OwnerId,omitempty"`
	KeyData []byte `protobuf:"bytes,6,opt,name=KeyData,proto3" json:"KeyData,omitempty"`
}

func (m *NodeKey) Reset()                    { *m = NodeKey{} }
func (m *NodeKey) String() string            { return proto.CompactTextString(m) }
func (*NodeKey) ProtoMessage()               {}
func (*NodeKey) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func (m *NodeKey) GetNodeId() string {
	if m != nil {
		return m.NodeId
	}
	return ""
}

func (m *NodeKey) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *NodeKey) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *NodeKey) GetKeyData() []byte {
	if m != nil {
		return m.KeyData
	}
	return nil
}

type Node struct {
	NodeId string `protobuf:"bytes,1,opt,name=NodeId" json:"NodeId,omitempty"`
	Legacy bool   `protobuf:"varint,2,opt,name=Legacy" json:"Legacy,omitempty"`
}

func (m *Node) Reset()                    { *m = Node{} }
func (m *Node) String() string            { return proto.CompactTextString(m) }
func (*Node) ProtoMessage()               {}
func (*Node) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{19} }

func (m *Node) GetNodeId() string {
	if m != nil {
		return m.NodeId
	}
	return ""
}

func (m *Node) GetLegacy() bool {
	if m != nil {
		return m.Legacy
	}
	return false
}

type NodeInfo struct {
	Node    *Node    `protobuf:"bytes,1,opt,name=Node" json:"Node,omitempty"`
	NodeKey *NodeKey `protobuf:"bytes,2,opt,name=NodeKey" json:"NodeKey,omitempty"`
	Block   *Block   `protobuf:"bytes,3,opt,name=Block" json:"Block,omitempty"`
}

func (m *NodeInfo) Reset()                    { *m = NodeInfo{} }
func (m *NodeInfo) String() string            { return proto.CompactTextString(m) }
func (*NodeInfo) ProtoMessage()               {}
func (*NodeInfo) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{20} }

func (m *NodeInfo) GetNode() *Node {
	if m != nil {
		return m.Node
	}
	return nil
}

func (m *NodeInfo) GetNodeKey() *NodeKey {
	if m != nil {
		return m.NodeKey
	}
	return nil
}

func (m *NodeInfo) GetBlock() *Block {
	if m != nil {
		return m.Block
	}
	return nil
}

type Block struct {
	OwnerId    string `protobuf:"bytes,1,opt,name=OwnerId" json:"OwnerId,omitempty"`
	PartId     uint32 `protobuf:"varint,2,opt,name=PartId" json:"PartId,omitempty"`
	Position   uint32 `protobuf:"varint,3,opt,name=Position" json:"Position,omitempty"`
	HeaderSize uint32 `protobuf:"varint,4,opt,name=HeaderSize" json:"HeaderSize,omitempty"`
	BlockSize  uint32 `protobuf:"varint,5,opt,name=BlockSize" json:"BlockSize,omitempty"`
	Nonce      []byte `protobuf:"bytes,6,opt,name=Nonce,proto3" json:"Nonce,omitempty"`
}

func (m *Block) Reset()                    { *m = Block{} }
func (m *Block) String() string            { return proto.CompactTextString(m) }
func (*Block) ProtoMessage()               {}
func (*Block) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{21} }

func (m *Block) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *Block) GetPartId() uint32 {
	if m != nil {
		return m.PartId
	}
	return 0
}

func (m *Block) GetPosition() uint32 {
	if m != nil {
		return m.Position
	}
	return 0
}

func (m *Block) GetHeaderSize() uint32 {
	if m != nil {
		return m.HeaderSize
	}
	return 0
}

func (m *Block) GetBlockSize() uint32 {
	if m != nil {
		return m.BlockSize
	}
	return 0
}

func (m *Block) GetNonce() []byte {
	if m != nil {
		return m.Nonce
	}
	return nil
}

type RangedBlock struct {
	OwnerId    string `protobuf:"bytes,1,opt,name=OwnerId" json:"OwnerId,omitempty"`
	PartId     uint32 `protobuf:"varint,2,opt,name=PartId" json:"PartId,omitempty"`
	SeqStart   uint32 `protobuf:"varint,3,opt,name=SeqStart" json:"SeqStart,omitempty"`
	SeqEnd     uint32 `protobuf:"varint,4,opt,name=SeqEnd" json:"SeqEnd,omitempty"`
	HeaderSize uint32 `protobuf:"varint,5,opt,name=HeaderSize" json:"HeaderSize,omitempty"`
	BlockSize  uint32 `protobuf:"varint,6,opt,name=BlockSize" json:"BlockSize,omitempty"`
}

func (m *RangedBlock) Reset()                    { *m = RangedBlock{} }
func (m *RangedBlock) String() string            { return proto.CompactTextString(m) }
func (*RangedBlock) ProtoMessage()               {}
func (*RangedBlock) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{22} }

func (m *RangedBlock) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *RangedBlock) GetPartId() uint32 {
	if m != nil {
		return m.PartId
	}
	return 0
}

func (m *RangedBlock) GetSeqStart() uint32 {
	if m != nil {
		return m.SeqStart
	}
	return 0
}

func (m *RangedBlock) GetSeqEnd() uint32 {
	if m != nil {
		return m.SeqEnd
	}
	return 0
}

func (m *RangedBlock) GetHeaderSize() uint32 {
	if m != nil {
		return m.HeaderSize
	}
	return 0
}

func (m *RangedBlock) GetBlockSize() uint32 {
	if m != nil {
		return m.BlockSize
	}
	return 0
}

type GetNodeInfoRequest struct {
	UserId      string `protobuf:"bytes,1,opt,name=UserId" json:"UserId,omitempty"`
	NodeId      string `protobuf:"bytes,2,opt,name=NodeId" json:"NodeId,omitempty"`
	WithRange   bool   `protobuf:"varint,3,opt,name=WithRange" json:"WithRange,omitempty"`
	PlainOffset int64  `protobuf:"varint,4,opt,name=PlainOffset" json:"PlainOffset,omitempty"`
	PlainLength int64  `protobuf:"varint,5,opt,name=PlainLength" json:"PlainLength,omitempty"`
}

func (m *GetNodeInfoRequest) Reset()                    { *m = GetNodeInfoRequest{} }
func (m *GetNodeInfoRequest) String() string            { return proto.CompactTextString(m) }
func (*GetNodeInfoRequest) ProtoMessage()               {}
func (*GetNodeInfoRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{23} }

func (m *GetNodeInfoRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *GetNodeInfoRequest) GetNodeId() string {
	if m != nil {
		return m.NodeId
	}
	return ""
}

func (m *GetNodeInfoRequest) GetWithRange() bool {
	if m != nil {
		return m.WithRange
	}
	return false
}

func (m *GetNodeInfoRequest) GetPlainOffset() int64 {
	if m != nil {
		return m.PlainOffset
	}
	return 0
}

func (m *GetNodeInfoRequest) GetPlainLength() int64 {
	if m != nil {
		return m.PlainLength
	}
	return 0
}

type GetNodeInfoResponse struct {
	NodeInfo                   *NodeInfo `protobuf:"bytes,1,opt,name=NodeInfo" json:"NodeInfo,omitempty"`
	HeadSKippedPlainBytesCount int64     `protobuf:"varint,2,opt,name=HeadSKippedPlainBytesCount" json:"HeadSKippedPlainBytesCount,omitempty"`
	WithRange                  bool      `protobuf:"varint,3,opt,name=WithRange" json:"WithRange,omitempty"`
	EncryptedOffset            int64     `protobuf:"varint,4,opt,name=EncryptedOffset" json:"EncryptedOffset,omitempty"`
	EncryptedCount             int64     `protobuf:"varint,5,opt,name=EncryptedCount" json:"EncryptedCount,omitempty"`
}

func (m *GetNodeInfoResponse) Reset()                    { *m = GetNodeInfoResponse{} }
func (m *GetNodeInfoResponse) String() string            { return proto.CompactTextString(m) }
func (*GetNodeInfoResponse) ProtoMessage()               {}
func (*GetNodeInfoResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{24} }

func (m *GetNodeInfoResponse) GetNodeInfo() *NodeInfo {
	if m != nil {
		return m.NodeInfo
	}
	return nil
}

func (m *GetNodeInfoResponse) GetHeadSKippedPlainBytesCount() int64 {
	if m != nil {
		return m.HeadSKippedPlainBytesCount
	}
	return 0
}

func (m *GetNodeInfoResponse) GetWithRange() bool {
	if m != nil {
		return m.WithRange
	}
	return false
}

func (m *GetNodeInfoResponse) GetEncryptedOffset() int64 {
	if m != nil {
		return m.EncryptedOffset
	}
	return 0
}

func (m *GetNodeInfoResponse) GetEncryptedCount() int64 {
	if m != nil {
		return m.EncryptedCount
	}
	return 0
}

type GetNodePlainSizeRequest struct {
	UserId string `protobuf:"bytes,1,opt,name=UserId" json:"UserId,omitempty"`
	NodeId string `protobuf:"bytes,2,opt,name=NodeId" json:"NodeId,omitempty"`
}

func (m *GetNodePlainSizeRequest) Reset()                    { *m = GetNodePlainSizeRequest{} }
func (m *GetNodePlainSizeRequest) String() string            { return proto.CompactTextString(m) }
func (*GetNodePlainSizeRequest) ProtoMessage()               {}
func (*GetNodePlainSizeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{25} }

func (m *GetNodePlainSizeRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *GetNodePlainSizeRequest) GetNodeId() string {
	if m != nil {
		return m.NodeId
	}
	return ""
}

type GetNodePlainSizeResponse struct {
	Size int64 `protobuf:"varint,1,opt,name=Size" json:"Size,omitempty"`
}

func (m *GetNodePlainSizeResponse) Reset()                    { *m = GetNodePlainSizeResponse{} }
func (m *GetNodePlainSizeResponse) String() string            { return proto.CompactTextString(m) }
func (*GetNodePlainSizeResponse) ProtoMessage()               {}
func (*GetNodePlainSizeResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{26} }

func (m *GetNodePlainSizeResponse) GetSize() int64 {
	if m != nil {
		return m.Size
	}
	return 0
}

type SetNodeInfoRequest struct {
	Action     string               `protobuf:"bytes,1,opt,name=Action" json:"Action,omitempty"`
	SetNodeKey *SetNodeKeyRequest   `protobuf:"bytes,2,opt,name=SetNodeKey" json:"SetNodeKey,omitempty"`
	SetBlock   *SetNodeBlockRequest `protobuf:"bytes,3,opt,name=SetBlock" json:"SetBlock,omitempty"`
}

func (m *SetNodeInfoRequest) Reset()                    { *m = SetNodeInfoRequest{} }
func (m *SetNodeInfoRequest) String() string            { return proto.CompactTextString(m) }
func (*SetNodeInfoRequest) ProtoMessage()               {}
func (*SetNodeInfoRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{27} }

func (m *SetNodeInfoRequest) GetAction() string {
	if m != nil {
		return m.Action
	}
	return ""
}

func (m *SetNodeInfoRequest) GetSetNodeKey() *SetNodeKeyRequest {
	if m != nil {
		return m.SetNodeKey
	}
	return nil
}

func (m *SetNodeInfoRequest) GetSetBlock() *SetNodeBlockRequest {
	if m != nil {
		return m.SetBlock
	}
	return nil
}

type SetNodeInfoResponse struct {
	ErrorText  string                `protobuf:"bytes,1,opt,name=ErrorText" json:"ErrorText,omitempty"`
	SetNodeKey *SetNodeKeyResponse   `protobuf:"bytes,2,opt,name=SetNodeKey" json:"SetNodeKey,omitempty"`
	SetBlock   *SetNodeBlockResponse `protobuf:"bytes,3,opt,name=SetBlock" json:"SetBlock,omitempty"`
}

func (m *SetNodeInfoResponse) Reset()                    { *m = SetNodeInfoResponse{} }
func (m *SetNodeInfoResponse) String() string            { return proto.CompactTextString(m) }
func (*SetNodeInfoResponse) ProtoMessage()               {}
func (*SetNodeInfoResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{28} }

func (m *SetNodeInfoResponse) GetErrorText() string {
	if m != nil {
		return m.ErrorText
	}
	return ""
}

func (m *SetNodeInfoResponse) GetSetNodeKey() *SetNodeKeyResponse {
	if m != nil {
		return m.SetNodeKey
	}
	return nil
}

func (m *SetNodeInfoResponse) GetSetBlock() *SetNodeBlockResponse {
	if m != nil {
		return m.SetBlock
	}
	return nil
}

type DeleteNodeRequest struct {
	NodeId string `protobuf:"bytes,1,opt,name=NodeId" json:"NodeId,omitempty"`
}

func (m *DeleteNodeRequest) Reset()                    { *m = DeleteNodeRequest{} }
func (m *DeleteNodeRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteNodeRequest) ProtoMessage()               {}
func (*DeleteNodeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{29} }

func (m *DeleteNodeRequest) GetNodeId() string {
	if m != nil {
		return m.NodeId
	}
	return ""
}

type DeleteNodeResponse struct {
}

func (m *DeleteNodeResponse) Reset()                    { *m = DeleteNodeResponse{} }
func (m *DeleteNodeResponse) String() string            { return proto.CompactTextString(m) }
func (*DeleteNodeResponse) ProtoMessage()               {}
func (*DeleteNodeResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{30} }

type DeleteNodeKeyRequest struct {
	UserId string `protobuf:"bytes,1,opt,name=UserId" json:"UserId,omitempty"`
	NodeId string `protobuf:"bytes,2,opt,name=NodeId" json:"NodeId,omitempty"`
}

func (m *DeleteNodeKeyRequest) Reset()                    { *m = DeleteNodeKeyRequest{} }
func (m *DeleteNodeKeyRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteNodeKeyRequest) ProtoMessage()               {}
func (*DeleteNodeKeyRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{31} }

func (m *DeleteNodeKeyRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *DeleteNodeKeyRequest) GetNodeId() string {
	if m != nil {
		return m.NodeId
	}
	return ""
}

type DeleteNodeKeyResponse struct {
}

func (m *DeleteNodeKeyResponse) Reset()                    { *m = DeleteNodeKeyResponse{} }
func (m *DeleteNodeKeyResponse) String() string            { return proto.CompactTextString(m) }
func (*DeleteNodeKeyResponse) ProtoMessage()               {}
func (*DeleteNodeKeyResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{32} }

type DeleteNodeSharedKeyRequest struct {
	UserId  string `protobuf:"bytes,1,opt,name=UserId" json:"UserId,omitempty"`
	OwnerId string `protobuf:"bytes,2,opt,name=OwnerId" json:"OwnerId,omitempty"`
	NodeId  string `protobuf:"bytes,3,opt,name=NodeId" json:"NodeId,omitempty"`
}

func (m *DeleteNodeSharedKeyRequest) Reset()                    { *m = DeleteNodeSharedKeyRequest{} }
func (m *DeleteNodeSharedKeyRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteNodeSharedKeyRequest) ProtoMessage()               {}
func (*DeleteNodeSharedKeyRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{33} }

func (m *DeleteNodeSharedKeyRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *DeleteNodeSharedKeyRequest) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *DeleteNodeSharedKeyRequest) GetNodeId() string {
	if m != nil {
		return m.NodeId
	}
	return ""
}

type DeleteNodeSharedKeyResponse struct {
}

func (m *DeleteNodeSharedKeyResponse) Reset()                    { *m = DeleteNodeSharedKeyResponse{} }
func (m *DeleteNodeSharedKeyResponse) String() string            { return proto.CompactTextString(m) }
func (*DeleteNodeSharedKeyResponse) ProtoMessage()               {}
func (*DeleteNodeSharedKeyResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{34} }

type SetNodeKeyRequest struct {
	NodeKey *NodeKey `protobuf:"bytes,1,opt,name=NodeKey" json:"NodeKey,omitempty"`
}

func (m *SetNodeKeyRequest) Reset()                    { *m = SetNodeKeyRequest{} }
func (m *SetNodeKeyRequest) String() string            { return proto.CompactTextString(m) }
func (*SetNodeKeyRequest) ProtoMessage()               {}
func (*SetNodeKeyRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{35} }

func (m *SetNodeKeyRequest) GetNodeKey() *NodeKey {
	if m != nil {
		return m.NodeKey
	}
	return nil
}

type SetNodeKeyResponse struct {
}

func (m *SetNodeKeyResponse) Reset()                    { *m = SetNodeKeyResponse{} }
func (m *SetNodeKeyResponse) String() string            { return proto.CompactTextString(m) }
func (*SetNodeKeyResponse) ProtoMessage()               {}
func (*SetNodeKeyResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{36} }

type SetNodeBlockRequest struct {
	NodeUuid string `protobuf:"bytes,1,opt,name=NodeUuid" json:"NodeUuid,omitempty"`
	Block    *Block `protobuf:"bytes,2,opt,name=Block" json:"Block,omitempty"`
}

func (m *SetNodeBlockRequest) Reset()                    { *m = SetNodeBlockRequest{} }
func (m *SetNodeBlockRequest) String() string            { return proto.CompactTextString(m) }
func (*SetNodeBlockRequest) ProtoMessage()               {}
func (*SetNodeBlockRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{37} }

func (m *SetNodeBlockRequest) GetNodeUuid() string {
	if m != nil {
		return m.NodeUuid
	}
	return ""
}

func (m *SetNodeBlockRequest) GetBlock() *Block {
	if m != nil {
		return m.Block
	}
	return nil
}

type SetNodeBlockResponse struct {
}

func (m *SetNodeBlockResponse) Reset()                    { *m = SetNodeBlockResponse{} }
func (m *SetNodeBlockResponse) String() string            { return proto.CompactTextString(m) }
func (*SetNodeBlockResponse) ProtoMessage()               {}
func (*SetNodeBlockResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{38} }

type CopyNodeInfoRequest struct {
	NodeUuid     string `protobuf:"bytes,1,opt,name=NodeUuid" json:"NodeUuid,omitempty"`
	NodeCopyUuid string `protobuf:"bytes,2,opt,name=NodeCopyUuid" json:"NodeCopyUuid,omitempty"`
}

func (m *CopyNodeInfoRequest) Reset()                    { *m = CopyNodeInfoRequest{} }
func (m *CopyNodeInfoRequest) String() string            { return proto.CompactTextString(m) }
func (*CopyNodeInfoRequest) ProtoMessage()               {}
func (*CopyNodeInfoRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{39} }

func (m *CopyNodeInfoRequest) GetNodeUuid() string {
	if m != nil {
		return m.NodeUuid
	}
	return ""
}

func (m *CopyNodeInfoRequest) GetNodeCopyUuid() string {
	if m != nil {
		return m.NodeCopyUuid
	}
	return ""
}

type CopyNodeInfoResponse struct {
}

func (m *CopyNodeInfoResponse) Reset()                    { *m = CopyNodeInfoResponse{} }
func (m *CopyNodeInfoResponse) String() string            { return proto.CompactTextString(m) }
func (*CopyNodeInfoResponse) ProtoMessage()               {}
func (*CopyNodeInfoResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{40} }

func init() {
	proto.RegisterType((*Export)(nil), "encryption.Export")
	proto.RegisterType((*Import)(nil), "encryption.Import")
	proto.RegisterType((*KeyInfo)(nil), "encryption.KeyInfo")
	proto.RegisterType((*Key)(nil), "encryption.Key")
	proto.RegisterType((*AddKeyRequest)(nil), "encryption.AddKeyRequest")
	proto.RegisterType((*AddKeyResponse)(nil), "encryption.AddKeyResponse")
	proto.RegisterType((*GetKeyRequest)(nil), "encryption.GetKeyRequest")
	proto.RegisterType((*GetKeyResponse)(nil), "encryption.GetKeyResponse")
	proto.RegisterType((*AdminListKeysRequest)(nil), "encryption.AdminListKeysRequest")
	proto.RegisterType((*AdminListKeysResponse)(nil), "encryption.AdminListKeysResponse")
	proto.RegisterType((*AdminDeleteKeyRequest)(nil), "encryption.AdminDeleteKeyRequest")
	proto.RegisterType((*AdminDeleteKeyResponse)(nil), "encryption.AdminDeleteKeyResponse")
	proto.RegisterType((*AdminExportKeyRequest)(nil), "encryption.AdminExportKeyRequest")
	proto.RegisterType((*AdminExportKeyResponse)(nil), "encryption.AdminExportKeyResponse")
	proto.RegisterType((*AdminImportKeyRequest)(nil), "encryption.AdminImportKeyRequest")
	proto.RegisterType((*AdminImportKeyResponse)(nil), "encryption.AdminImportKeyResponse")
	proto.RegisterType((*AdminCreateKeyRequest)(nil), "encryption.AdminCreateKeyRequest")
	proto.RegisterType((*AdminCreateKeyResponse)(nil), "encryption.AdminCreateKeyResponse")
	proto.RegisterType((*NodeKey)(nil), "encryption.NodeKey")
	proto.RegisterType((*Node)(nil), "encryption.Node")
	proto.RegisterType((*NodeInfo)(nil), "encryption.NodeInfo")
	proto.RegisterType((*Block)(nil), "encryption.Block")
	proto.RegisterType((*RangedBlock)(nil), "encryption.RangedBlock")
	proto.RegisterType((*GetNodeInfoRequest)(nil), "encryption.GetNodeInfoRequest")
	proto.RegisterType((*GetNodeInfoResponse)(nil), "encryption.GetNodeInfoResponse")
	proto.RegisterType((*GetNodePlainSizeRequest)(nil), "encryption.GetNodePlainSizeRequest")
	proto.RegisterType((*GetNodePlainSizeResponse)(nil), "encryption.GetNodePlainSizeResponse")
	proto.RegisterType((*SetNodeInfoRequest)(nil), "encryption.SetNodeInfoRequest")
	proto.RegisterType((*SetNodeInfoResponse)(nil), "encryption.SetNodeInfoResponse")
	proto.RegisterType((*DeleteNodeRequest)(nil), "encryption.DeleteNodeRequest")
	proto.RegisterType((*DeleteNodeResponse)(nil), "encryption.DeleteNodeResponse")
	proto.RegisterType((*DeleteNodeKeyRequest)(nil), "encryption.DeleteNodeKeyRequest")
	proto.RegisterType((*DeleteNodeKeyResponse)(nil), "encryption.DeleteNodeKeyResponse")
	proto.RegisterType((*DeleteNodeSharedKeyRequest)(nil), "encryption.DeleteNodeSharedKeyRequest")
	proto.RegisterType((*DeleteNodeSharedKeyResponse)(nil), "encryption.DeleteNodeSharedKeyResponse")
	proto.RegisterType((*SetNodeKeyRequest)(nil), "encryption.SetNodeKeyRequest")
	proto.RegisterType((*SetNodeKeyResponse)(nil), "encryption.SetNodeKeyResponse")
	proto.RegisterType((*SetNodeBlockRequest)(nil), "encryption.SetNodeBlockRequest")
	proto.RegisterType((*SetNodeBlockResponse)(nil), "encryption.SetNodeBlockResponse")
	proto.RegisterType((*CopyNodeInfoRequest)(nil), "encryption.CopyNodeInfoRequest")
	proto.RegisterType((*CopyNodeInfoResponse)(nil), "encryption.CopyNodeInfoResponse")
}

func init() { proto.RegisterFile("encryption.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 1349 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x58, 0xdb, 0x6e, 0xdb, 0x46,
	0x13, 0x36, 0x75, 0xb2, 0x35, 0xb2, 0x1c, 0x7b, 0xad, 0x38, 0xfa, 0xf9, 0x3b, 0x8e, 0xb2, 0x09,
	0x62, 0xa1, 0x4d, 0x8c, 0x42, 0x01, 0x7a, 0x93, 0x34, 0x80, 0x4f, 0x4d, 0x05, 0xb9, 0xb6, 0xbb,
	0xb4, 0x5b, 0xb4, 0x40, 0x2e, 0x18, 0x71, 0x6d, 0x0b, 0xb5, 0x49, 0x99, 0xa4, 0x1b, 0xab, 0x4f,
	0xd0, 0x27, 0x29, 0xda, 0xcb, 0xbe, 0x4d, 0xdf, 0xa2, 0x97, 0xbd, 0x2d, 0xf6, 0x40, 0x72, 0x49,
	0xae, 0x44, 0xf7, 0x70, 0xc7, 0x99, 0x9d, 0xfd, 0xe6, 0x9b, 0xd9, 0x99, 0xdd, 0x91, 0x60, 0x99,
	0xba, 0x43, 0x7f, 0x32, 0x0e, 0x47, 0x9e, 0xbb, 0x35, 0xf6, 0xbd, 0xd0, 0x43, 0x90, 0x68, 0xf0,
	0x73, 0xa8, 0xed, 0xdf, 0x8e, 0x3d, 0x3f, 0x44, 0x4b, 0x50, 0xda, 0x99, 0xb4, 0x8d, 0x8e, 0xd1,
	0xad, 0x93, 0xd2, 0xce, 0x04, 0x21, 0xa8, 0xec, 0xd9, 0x21, 0x6d, 0x97, 0x3a, 0x46, 0xb7, 0x4a,
	0xf8, 0x37, 0xb3, 0xee, 0x5f, 0xcd, 0xb4, 0x2e, 0x2b, 0xd6, 0x14, 0xe6, 0x07, 0x74, 0xd2, 0x77,
	0xcf, 0x3c, 0xf4, 0x1c, 0xe6, 0x85, 0x9b, 0xa0, 0x6d, 0x74, 0xca, 0xdd, 0x46, 0x0f, 0x6d, 0x29,
	0xb4, 0xc4, 0x12, 0x89, 0x4c, 0x98, 0xb5, 0x70, 0x13, 0xb4, 0x4b, 0x79, 0x6b, 0xb1, 0x44, 0x22,
	0x13, 0xfc, 0x8b, 0x01, 0xe5, 0x01, 0x9d, 0xa0, 0x16, 0x54, 0x8f, 0x3e, 0xb8, 0xd4, 0x97, 0xac,
	0x84, 0xc0, 0x88, 0xf6, 0xf7, 0x78, 0x10, 0x75, 0x52, 0xea, 0xef, 0x31, 0xab, 0x03, 0xfb, 0x3d,
	0xbd, 0xe4, 0x4c, 0xeb, 0x44, 0x08, 0xa8, 0x0d, 0xf3, 0xbb, 0x9e, 0x1b, 0x52, 0x37, 0x6c, 0x57,
	0xb8, 0x3e, 0x12, 0x11, 0x86, 0xc5, 0x5d, 0x9f, 0xda, 0xcc, 0x33, 0x0f, 0xb0, 0xca, 0x03, 0x4c,
	0xe9, 0xd0, 0x26, 0x54, 0x58, 0x94, 0xed, 0x5a, 0xc7, 0xe8, 0x36, 0x7a, 0xab, 0x2a, 0x59, 0x99,
	0x00, 0xc2, 0x0d, 0xf0, 0x09, 0x34, 0xb7, 0x1d, 0x67, 0x40, 0x27, 0x84, 0x5e, 0xdf, 0xd0, 0x20,
	0x44, 0x8f, 0x39, 0x75, 0xce, 0xb8, 0xd1, 0xbb, 0x97, 0xd9, 0x48, 0x78, 0x58, 0x1d, 0x68, 0x58,
	0xa1, 0x7f, 0x6c, 0x07, 0xc1, 0x07, 0xcf, 0x77, 0x64, 0x24, 0xaa, 0x0a, 0x7f, 0x04, 0x4b, 0x11,
	0x6a, 0x30, 0xf6, 0xdc, 0x80, 0xb2, 0x70, 0xac, 0x9b, 0xe1, 0x90, 0x06, 0x01, 0x87, 0x5e, 0x20,
	0x91, 0x88, 0xdf, 0x41, 0xf3, 0x2d, 0x0d, 0x15, 0x06, 0xfa, 0xac, 0xb5, 0xa0, 0xca, 0x98, 0x47,
	0x89, 0x13, 0x42, 0x96, 0x4a, 0x39, 0x4f, 0xe5, 0x25, 0x2c, 0x45, 0xf0, 0x92, 0x4a, 0x71, 0x84,
	0x78, 0x0d, 0x5a, 0xdb, 0xce, 0xd5, 0xc8, 0x3d, 0x18, 0x05, 0x6c, 0x6b, 0x20, 0xa9, 0xe1, 0xd7,
	0x70, 0x3f, 0xa3, 0x97, 0x98, 0x4f, 0xa0, 0xc2, 0x64, 0x59, 0x4a, 0x39, 0x50, 0xbe, 0x88, 0x5f,
	0xc8, 0xdd, 0x7b, 0xf4, 0x92, 0x86, 0x34, 0x1d, 0xb1, 0x88, 0xcd, 0x50, 0x62, 0xc3, 0x3d, 0x58,
	0xcb, 0x9a, 0x17, 0x26, 0xf3, 0x48, 0xba, 0x10, 0x75, 0x5b, 0xe4, 0xe2, 0x0e, 0x27, 0xf9, 0x4a,
	0x92, 0x50, 0x00, 0xef, 0x9e, 0xc6, 0x5b, 0xc9, 0x46, 0xf4, 0xc5, 0x7f, 0x5c, 0x64, 0xc8, 0x84,
	0x85, 0xa3, 0x1f, 0xa8, 0xef, 0x8f, 0x1c, 0xd1, 0xe4, 0x0b, 0x24, 0x96, 0xe3, 0xdc, 0x29, 0x9e,
	0x0b, 0x73, 0xb7, 0x2b, 0xd9, 0xf2, 0x46, 0x2a, 0x3c, 0x9e, 0xa4, 0x6d, 0x4b, 0x4a, 0xdb, 0xc6,
	0x8e, 0x15, 0x90, 0x42, 0xc7, 0x57, 0x30, 0x7f, 0xe8, 0x39, 0xcc, 0x18, 0xad, 0x41, 0x8d, 0x7d,
	0xf6, 0x1d, 0xe9, 0x4b, 0x4a, 0x4c, 0x7f, 0x1a, 0x50, 0xbf, 0x1f, 0x25, 0x42, 0x4a, 0x0c, 0x94,
	0xb7, 0x47, 0x3f, 0xaa, 0xfd, 0x48, 0x64, 0x2b, 0x03, 0x3a, 0xd9, 0xb3, 0x43, 0x9b, 0x5f, 0x02,
	0x8b, 0x24, 0x12, 0xf1, 0xa7, 0x50, 0x61, 0xa8, 0xb3, 0x7c, 0x1d, 0xd0, 0x73, 0x7b, 0x38, 0xe1,
	0xbe, 0x16, 0x88, 0x94, 0xf0, 0x4f, 0x06, 0x2c, 0x70, 0x13, 0x76, 0x7d, 0x3e, 0x15, 0x20, 0xf2,
	0x08, 0x97, 0xd5, 0x23, 0x64, 0x7a, 0x22, 0x5c, 0xbc, 0x88, 0x23, 0xe3, 0x58, 0x99, 0x9b, 0x48,
	0x2e, 0x91, 0x38, 0xfa, 0x4d, 0xa8, 0xee, 0x5c, 0x7a, 0xc3, 0xef, 0x79, 0x2c, 0x8d, 0xde, 0x8a,
	0x6a, 0xcc, 0x17, 0x88, 0x58, 0xc7, 0xbf, 0x1a, 0xd2, 0x52, 0x4d, 0x80, 0x91, 0x4e, 0xc0, 0x1a,
	0xd4, 0x8e, 0x6d, 0x3f, 0x94, 0x29, 0x6b, 0x12, 0x29, 0xb1, 0xb2, 0x39, 0xf6, 0x82, 0x11, 0x03,
	0xe5, 0x7e, 0x9a, 0x24, 0x96, 0xd1, 0x06, 0xc0, 0x17, 0xd4, 0x76, 0xa8, 0x6f, 0x8d, 0x7e, 0xa4,
	0xfc, 0xde, 0x6d, 0x12, 0x45, 0x83, 0xd6, 0xa1, 0xce, 0xdd, 0xf2, 0xe5, 0x2a, 0x5f, 0x4e, 0x14,
	0xac, 0x22, 0x0e, 0x3d, 0x77, 0x48, 0x65, 0xc2, 0x85, 0x80, 0x7f, 0x33, 0xa0, 0x41, 0x6c, 0xf7,
	0x9c, 0x3a, 0xff, 0x82, 0xb1, 0x45, 0xaf, 0xad, 0xd0, 0xf6, 0xc3, 0x88, 0x71, 0x24, 0xb3, 0x3d,
	0x16, 0xbd, 0xde, 0x77, 0x1d, 0xc9, 0x56, 0x4a, 0x99, 0x48, 0xaa, 0xb3, 0x23, 0xa9, 0x65, 0x22,
	0xc1, 0x3f, 0x1b, 0x80, 0xde, 0xd2, 0x30, 0x3a, 0xed, 0xa8, 0x11, 0x92, 0x2a, 0x34, 0x52, 0x55,
	0x98, 0x54, 0x52, 0x29, 0x55, 0x49, 0xeb, 0x50, 0xff, 0x66, 0x14, 0x5e, 0xf0, 0xe8, 0x65, 0x8b,
	0x26, 0x0a, 0xd6, 0xe1, 0xc7, 0x97, 0xf6, 0xc8, 0x3d, 0x3a, 0x3b, 0x0b, 0xa8, 0x78, 0xe5, 0xca,
	0x44, 0x55, 0xc5, 0x16, 0x07, 0xd4, 0x3d, 0x0f, 0x2f, 0x78, 0x14, 0x91, 0x85, 0x50, 0xe1, 0x3f,
	0x0d, 0x58, 0x4d, 0x11, 0x95, 0xcd, 0xf6, 0x49, 0x52, 0xaa, 0xb2, 0x44, 0x5b, 0xd9, 0xca, 0xe3,
	0xf6, 0x49, 0x41, 0xbf, 0x01, 0x93, 0xa5, 0xc7, 0x1a, 0x8c, 0xc6, 0x63, 0xea, 0x70, 0x1f, 0x3b,
	0x93, 0x90, 0x06, 0xbb, 0xde, 0x8d, 0x1b, 0xf2, 0xb8, 0xca, 0x64, 0x86, 0x45, 0x41, 0xac, 0x5d,
	0xb8, 0xb7, 0x2f, 0xdc, 0x53, 0x27, 0x15, 0x6f, 0x56, 0x8d, 0x9e, 0xc1, 0x52, 0xac, 0x12, 0xbe,
	0x45, 0xd8, 0x19, 0x2d, 0xee, 0xc3, 0x03, 0x19, 0x38, 0x67, 0xc2, 0x8e, 0xed, 0x1f, 0x1e, 0x13,
	0xde, 0x82, 0x76, 0x1e, 0x4a, 0x26, 0x12, 0x41, 0x85, 0x97, 0x88, 0xc1, 0x49, 0xf0, 0x6f, 0x36,
	0xde, 0x20, 0x4b, 0x5b, 0x1d, 0xdb, 0x43, 0xde, 0x56, 0xd2, 0xad, 0x90, 0xd0, 0x67, 0x00, 0xd2,
	0x3a, 0xb9, 0x07, 0x1e, 0xaa, 0xa7, 0x91, 0xac, 0x4a, 0x28, 0xa2, 0x6c, 0x40, 0xaf, 0x58, 0xf5,
	0x87, 0xea, 0xbd, 0xf0, 0x48, 0xb3, 0x59, 0x5c, 0x0f, 0x72, 0x7b, 0xbc, 0x81, 0x35, 0xdf, 0xaa,
	0xa5, 0xa9, 0x8f, 0x75, 0xa8, 0xef, 0xfb, 0xbe, 0xe7, 0x9f, 0xd0, 0xdb, 0x50, 0xd2, 0x4d, 0x14,
	0xe8, 0x8d, 0x86, 0xf1, 0xc6, 0x34, 0xc6, 0x02, 0x31, 0x45, 0xf9, 0x75, 0x8e, 0x72, 0x67, 0x3a,
	0x65, 0xb9, 0x3f, 0xe1, 0xfc, 0x31, 0xac, 0x88, 0x27, 0x9f, 0x5f, 0xa4, 0x49, 0x72, 0x75, 0x97,
	0x35, 0x6e, 0x01, 0x52, 0x8d, 0x05, 0x18, 0xfe, 0x1c, 0x5a, 0x89, 0x56, 0x79, 0xc9, 0xfe, 0x6e,
	0x65, 0x3c, 0x80, 0xfb, 0x19, 0x1c, 0xe9, 0xe0, 0x0c, 0xcc, 0x64, 0xc1, 0xba, 0xb0, 0x7d, 0xea,
	0xdc, 0xc1, 0x8d, 0x72, 0xf5, 0x95, 0x72, 0x57, 0x9f, 0x24, 0x50, 0x4e, 0x11, 0x78, 0x08, 0xff,
	0xd7, 0xfa, 0x91, 0x34, 0x76, 0x60, 0x25, 0x57, 0x3c, 0xea, 0xa3, 0x63, 0x14, 0x3f, 0x3a, 0x2c,
	0x83, 0xf9, 0xe3, 0xc4, 0xdf, 0xc5, 0x75, 0xa3, 0x56, 0x16, 0xbb, 0x8a, 0x99, 0xee, 0xf4, 0x66,
	0x14, 0xc5, 0x16, 0xcb, 0xc9, 0xeb, 0x55, 0x2a, 0x78, 0xbd, 0xd6, 0xa0, 0xa5, 0x2b, 0x01, 0x7c,
	0x0a, 0xab, 0xbb, 0xde, 0x78, 0x92, 0xed, 0xab, 0x59, 0x3e, 0x31, 0x2c, 0xb2, 0x6f, 0xb6, 0x8d,
	0xaf, 0x8b, 0xb4, 0xa6, 0x74, 0xcc, 0x5d, 0x1a, 0x56, 0xb8, 0xeb, 0xfd, 0x5e, 0x81, 0x45, 0x76,
	0x30, 0x03, 0x3a, 0xb1, 0x42, 0xcf, 0xa7, 0x68, 0x1b, 0x6a, 0x62, 0x6a, 0x47, 0xff, 0x53, 0xb9,
	0xa7, 0x7e, 0x1f, 0x98, 0xa6, 0x6e, 0x49, 0x06, 0x30, 0xc7, 0x20, 0xc4, 0xb4, 0x9d, 0x86, 0x48,
	0x0d, 0xf8, 0x69, 0x88, 0xf4, 0x70, 0x8e, 0xe7, 0xd0, 0xd7, 0xec, 0x17, 0x89, 0x32, 0x63, 0xa3,
	0x4e, 0xda, 0x63, 0x7e, 0x2c, 0x37, 0x1f, 0xcf, 0xb0, 0x88, 0x71, 0xbf, 0x65, 0xbf, 0x49, 0xd4,
	0xc9, 0x0c, 0xe5, 0xb7, 0x65, 0x47, 0x3f, 0x13, 0xcf, 0x32, 0xc9, 0x41, 0xc7, 0x93, 0xba, 0x06,
	0x3a, 0x3b, 0xf4, 0x6b, 0xa0, 0x73, 0x83, 0xbe, 0x02, 0x1d, 0xcf, 0xdf, 0x1a, 0xe8, 0xec, 0xb0,
	0xaf, 0x81, 0xce, 0x8d, 0xef, 0x0a, 0x74, 0x3c, 0x23, 0x6b, 0xa0, 0xb3, 0x93, 0xbb, 0x06, 0x3a,
	0x37, 0x62, 0xe3, 0xb9, 0xde, 0x1f, 0x15, 0x58, 0x92, 0x1d, 0xf5, 0xa5, 0xed, 0xda, 0xe7, 0xd4,
	0x47, 0x87, 0xd0, 0x50, 0x1e, 0x6a, 0xb4, 0x91, 0xa9, 0x81, 0x4c, 0xd1, 0x9b, 0x8f, 0xa6, 0xae,
	0xcb, 0x1b, 0xfc, 0x1d, 0x2c, 0x67, 0x1f, 0x2d, 0xf4, 0x44, 0xb3, 0x29, 0xfb, 0x3a, 0x9a, 0x4f,
	0x67, 0x1b, 0x49, 0xf8, 0x63, 0x68, 0x58, 0xd3, 0xe8, 0x5a, 0x05, 0x74, 0x35, 0x0f, 0x4e, 0xd7,
	0x40, 0x5f, 0xc1, 0xa2, 0xda, 0x86, 0x28, 0xb5, 0x45, 0xd3, 0xf7, 0x66, 0x67, 0xba, 0x81, 0x24,
	0x39, 0x00, 0x48, 0x6e, 0x47, 0x94, 0x7a, 0x53, 0x73, 0x2f, 0x88, 0xb9, 0x31, 0x6d, 0x59, 0x82,
	0x9d, 0x40, 0x33, 0x75, 0xd7, 0xa7, 0xfb, 0x4e, 0xf7, 0x9c, 0xa4, 0xfb, 0x4e, 0xfb, 0x50, 0xa0,
	0x33, 0x58, 0xd5, 0x5c, 0xe0, 0xe8, 0x99, 0x7e, 0x67, 0xf6, 0x25, 0x31, 0x37, 0x0b, 0xed, 0x84,
	0x9f, 0xf7, 0x35, 0xfe, 0x47, 0xd2, 0xcb, 0xbf, 0x02, 0x00, 0x00, 0xff, 0xff, 0x22, 0x60, 0x66,
	0x48, 0x5c, 0x12, 0x00, 0x00,
}
