// Code generated by protoc-gen-micro. DO NOT EDIT.
// source: idm.proto

/*
Package idm is a generated protocol buffer package.

It is generated from these files:
	idm.proto

It has these top-level messages:
	CreateRoleRequest
	CreateRoleResponse
	DeleteRoleRequest
	DeleteRoleResponse
	SearchRoleRequest
	SearchRoleResponse
	CountRoleResponse
	Role
	RoleSingleQuery
	CreateUserRequest
	CreateUserResponse
	BindUserRequest
	BindUserResponse
	DeleteUserRequest
	DeleteUserResponse
	SearchUserRequest
	SearchUserResponse
	CountUserResponse
	User
	UserSingleQuery
	CreateWorkspaceRequest
	CreateWorkspaceResponse
	DeleteWorkspaceRequest
	DeleteWorkspaceResponse
	SearchWorkspaceRequest
	SearchWorkspaceResponse
	Workspace
	WorkspaceSingleQuery
	CreateACLRequest
	CreateACLResponse
	ExpireACLRequest
	ExpireACLResponse
	DeleteACLRequest
	DeleteACLResponse
	SearchACLRequest
	SearchACLResponse
	ACLAction
	ACL
	ACLSingleQuery
	UserMeta
	UserMetaNamespace
	UpdateUserMetaRequest
	UpdateUserMetaResponse
	SearchUserMetaRequest
	SearchUserMetaResponse
	UpdateUserMetaNamespaceRequest
	UpdateUserMetaNamespaceResponse
	ListUserMetaNamespaceRequest
	ListUserMetaNamespaceResponse
	ChangeEvent
	PolicyEngineRequest
	PolicyEngineResponse
	PolicyCondition
	Policy
	PolicyGroup
	StorePolicyGroupRequest
	StorePolicyGroupResponse
	DeletePolicyGroupRequest
	DeletePolicyGroupResponse
	ListPolicyGroupsRequest
	ListPolicyGroupsResponse
*/
package idm

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/pydio/cells/common/service/proto"
import _ "github.com/pydio/cells/common/proto/tree"
import _ "github.com/mwitkow/go-proto-validators"

import (
	client "github.com/micro/go-micro/client"
	server "github.com/micro/go-micro/server"
	context "context"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ client.Option
var _ server.Option

// Client API for RoleService service

type RoleServiceClient interface {
	CreateRole(ctx context.Context, in *CreateRoleRequest, opts ...client.CallOption) (*CreateRoleResponse, error)
	DeleteRole(ctx context.Context, in *DeleteRoleRequest, opts ...client.CallOption) (*DeleteRoleResponse, error)
	SearchRole(ctx context.Context, in *SearchRoleRequest, opts ...client.CallOption) (RoleService_SearchRoleClient, error)
	StreamRole(ctx context.Context, opts ...client.CallOption) (RoleService_StreamRoleClient, error)
	CountRole(ctx context.Context, in *SearchRoleRequest, opts ...client.CallOption) (*CountRoleResponse, error)
}

type roleServiceClient struct {
	c           client.Client
	serviceName string
}

func NewRoleServiceClient(serviceName string, c client.Client) RoleServiceClient {
	if c == nil {
		c = client.NewClient()
	}
	if len(serviceName) == 0 {
		serviceName = "idm"
	}
	return &roleServiceClient{
		c:           c,
		serviceName: serviceName,
	}
}

func (c *roleServiceClient) CreateRole(ctx context.Context, in *CreateRoleRequest, opts ...client.CallOption) (*CreateRoleResponse, error) {
	req := c.c.NewRequest(c.serviceName, "RoleService.CreateRole", in)
	out := new(CreateRoleResponse)
	err := c.c.Call(ctx, req, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *roleServiceClient) DeleteRole(ctx context.Context, in *DeleteRoleRequest, opts ...client.CallOption) (*DeleteRoleResponse, error) {
	req := c.c.NewRequest(c.serviceName, "RoleService.DeleteRole", in)
	out := new(DeleteRoleResponse)
	err := c.c.Call(ctx, req, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *roleServiceClient) SearchRole(ctx context.Context, in *SearchRoleRequest, opts ...client.CallOption) (RoleService_SearchRoleClient, error) {
	req := c.c.NewRequest(c.serviceName, "RoleService.SearchRole", &SearchRoleRequest{})
	stream, err := c.c.Stream(ctx, req, opts...)
	if err != nil {
		return nil, err
	}
	if err := stream.Send(in); err != nil {
		return nil, err
	}
	return &roleServiceSearchRoleClient{stream}, nil
}

type RoleService_SearchRoleClient interface {
	SendMsg(interface{}) error
	RecvMsg(interface{}) error
	Close() error
	Recv() (*SearchRoleResponse, error)
}

type roleServiceSearchRoleClient struct {
	stream client.Streamer
}

func (x *roleServiceSearchRoleClient) Close() error {
	return x.stream.Close()
}

func (x *roleServiceSearchRoleClient) SendMsg(m interface{}) error {
	return x.stream.Send(m)
}

func (x *roleServiceSearchRoleClient) RecvMsg(m interface{}) error {
	return x.stream.Recv(m)
}

func (x *roleServiceSearchRoleClient) Recv() (*SearchRoleResponse, error) {
	m := new(SearchRoleResponse)
	err := x.stream.Recv(m)
	if err != nil {
		return nil, err
	}
	return m, nil
}

func (c *roleServiceClient) StreamRole(ctx context.Context, opts ...client.CallOption) (RoleService_StreamRoleClient, error) {
	req := c.c.NewRequest(c.serviceName, "RoleService.StreamRole", &SearchRoleRequest{})
	stream, err := c.c.Stream(ctx, req, opts...)
	if err != nil {
		return nil, err
	}
	return &roleServiceStreamRoleClient{stream}, nil
}

type RoleService_StreamRoleClient interface {
	SendMsg(interface{}) error
	RecvMsg(interface{}) error
	Close() error
	Send(*SearchRoleRequest) error
	Recv() (*SearchRoleResponse, error)
}

type roleServiceStreamRoleClient struct {
	stream client.Streamer
}

func (x *roleServiceStreamRoleClient) Close() error {
	return x.stream.Close()
}

func (x *roleServiceStreamRoleClient) SendMsg(m interface{}) error {
	return x.stream.Send(m)
}

func (x *roleServiceStreamRoleClient) RecvMsg(m interface{}) error {
	return x.stream.Recv(m)
}

func (x *roleServiceStreamRoleClient) Send(m *SearchRoleRequest) error {
	return x.stream.Send(m)
}

func (x *roleServiceStreamRoleClient) Recv() (*SearchRoleResponse, error) {
	m := new(SearchRoleResponse)
	err := x.stream.Recv(m)
	if err != nil {
		return nil, err
	}
	return m, nil
}

func (c *roleServiceClient) CountRole(ctx context.Context, in *SearchRoleRequest, opts ...client.CallOption) (*CountRoleResponse, error) {
	req := c.c.NewRequest(c.serviceName, "RoleService.CountRole", in)
	out := new(CountRoleResponse)
	err := c.c.Call(ctx, req, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for RoleService service

type RoleServiceHandler interface {
	CreateRole(context.Context, *CreateRoleRequest, *CreateRoleResponse) error
	DeleteRole(context.Context, *DeleteRoleRequest, *DeleteRoleResponse) error
	SearchRole(context.Context, *SearchRoleRequest, RoleService_SearchRoleStream) error
	StreamRole(context.Context, RoleService_StreamRoleStream) error
	CountRole(context.Context, *SearchRoleRequest, *CountRoleResponse) error
}

func RegisterRoleServiceHandler(s server.Server, hdlr RoleServiceHandler, opts ...server.HandlerOption) {
	s.Handle(s.NewHandler(&RoleService{hdlr}, opts...))
}

type RoleService struct {
	RoleServiceHandler
}

func (h *RoleService) CreateRole(ctx context.Context, in *CreateRoleRequest, out *CreateRoleResponse) error {
	return h.RoleServiceHandler.CreateRole(ctx, in, out)
}

func (h *RoleService) DeleteRole(ctx context.Context, in *DeleteRoleRequest, out *DeleteRoleResponse) error {
	return h.RoleServiceHandler.DeleteRole(ctx, in, out)
}

func (h *RoleService) SearchRole(ctx context.Context, stream server.Streamer) error {
	m := new(SearchRoleRequest)
	if err := stream.Recv(m); err != nil {
		return err
	}
	return h.RoleServiceHandler.SearchRole(ctx, m, &roleServiceSearchRoleStream{stream})
}

type RoleService_SearchRoleStream interface {
	SendMsg(interface{}) error
	RecvMsg(interface{}) error
	Close() error
	Send(*SearchRoleResponse) error
}

type roleServiceSearchRoleStream struct {
	stream server.Streamer
}

func (x *roleServiceSearchRoleStream) Close() error {
	return x.stream.Close()
}

func (x *roleServiceSearchRoleStream) SendMsg(m interface{}) error {
	return x.stream.Send(m)
}

func (x *roleServiceSearchRoleStream) RecvMsg(m interface{}) error {
	return x.stream.Recv(m)
}

func (x *roleServiceSearchRoleStream) Send(m *SearchRoleResponse) error {
	return x.stream.Send(m)
}

func (h *RoleService) StreamRole(ctx context.Context, stream server.Streamer) error {
	return h.RoleServiceHandler.StreamRole(ctx, &roleServiceStreamRoleStream{stream})
}

type RoleService_StreamRoleStream interface {
	SendMsg(interface{}) error
	RecvMsg(interface{}) error
	Close() error
	Send(*SearchRoleResponse) error
	Recv() (*SearchRoleRequest, error)
}

type roleServiceStreamRoleStream struct {
	stream server.Streamer
}

func (x *roleServiceStreamRoleStream) Close() error {
	return x.stream.Close()
}

func (x *roleServiceStreamRoleStream) SendMsg(m interface{}) error {
	return x.stream.Send(m)
}

func (x *roleServiceStreamRoleStream) RecvMsg(m interface{}) error {
	return x.stream.Recv(m)
}

func (x *roleServiceStreamRoleStream) Send(m *SearchRoleResponse) error {
	return x.stream.Send(m)
}

func (x *roleServiceStreamRoleStream) Recv() (*SearchRoleRequest, error) {
	m := new(SearchRoleRequest)
	if err := x.stream.Recv(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (h *RoleService) CountRole(ctx context.Context, in *SearchRoleRequest, out *CountRoleResponse) error {
	return h.RoleServiceHandler.CountRole(ctx, in, out)
}

// Client API for UserService service

type UserServiceClient interface {
	CreateUser(ctx context.Context, in *CreateUserRequest, opts ...client.CallOption) (*CreateUserResponse, error)
	DeleteUser(ctx context.Context, in *DeleteUserRequest, opts ...client.CallOption) (*DeleteUserResponse, error)
	BindUser(ctx context.Context, in *BindUserRequest, opts ...client.CallOption) (*BindUserResponse, error)
	CountUser(ctx context.Context, in *SearchUserRequest, opts ...client.CallOption) (*CountUserResponse, error)
	SearchUser(ctx context.Context, in *SearchUserRequest, opts ...client.CallOption) (UserService_SearchUserClient, error)
	StreamUser(ctx context.Context, opts ...client.CallOption) (UserService_StreamUserClient, error)
}

type userServiceClient struct {
	c           client.Client
	serviceName string
}

func NewUserServiceClient(serviceName string, c client.Client) UserServiceClient {
	if c == nil {
		c = client.NewClient()
	}
	if len(serviceName) == 0 {
		serviceName = "idm"
	}
	return &userServiceClient{
		c:           c,
		serviceName: serviceName,
	}
}

func (c *userServiceClient) CreateUser(ctx context.Context, in *CreateUserRequest, opts ...client.CallOption) (*CreateUserResponse, error) {
	req := c.c.NewRequest(c.serviceName, "UserService.CreateUser", in)
	out := new(CreateUserResponse)
	err := c.c.Call(ctx, req, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userServiceClient) DeleteUser(ctx context.Context, in *DeleteUserRequest, opts ...client.CallOption) (*DeleteUserResponse, error) {
	req := c.c.NewRequest(c.serviceName, "UserService.DeleteUser", in)
	out := new(DeleteUserResponse)
	err := c.c.Call(ctx, req, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userServiceClient) BindUser(ctx context.Context, in *BindUserRequest, opts ...client.CallOption) (*BindUserResponse, error) {
	req := c.c.NewRequest(c.serviceName, "UserService.BindUser", in)
	out := new(BindUserResponse)
	err := c.c.Call(ctx, req, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userServiceClient) CountUser(ctx context.Context, in *SearchUserRequest, opts ...client.CallOption) (*CountUserResponse, error) {
	req := c.c.NewRequest(c.serviceName, "UserService.CountUser", in)
	out := new(CountUserResponse)
	err := c.c.Call(ctx, req, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userServiceClient) SearchUser(ctx context.Context, in *SearchUserRequest, opts ...client.CallOption) (UserService_SearchUserClient, error) {
	req := c.c.NewRequest(c.serviceName, "UserService.SearchUser", &SearchUserRequest{})
	stream, err := c.c.Stream(ctx, req, opts...)
	if err != nil {
		return nil, err
	}
	if err := stream.Send(in); err != nil {
		return nil, err
	}
	return &userServiceSearchUserClient{stream}, nil
}

type UserService_SearchUserClient interface {
	SendMsg(interface{}) error
	RecvMsg(interface{}) error
	Close() error
	Recv() (*SearchUserResponse, error)
}

type userServiceSearchUserClient struct {
	stream client.Streamer
}

func (x *userServiceSearchUserClient) Close() error {
	return x.stream.Close()
}

func (x *userServiceSearchUserClient) SendMsg(m interface{}) error {
	return x.stream.Send(m)
}

func (x *userServiceSearchUserClient) RecvMsg(m interface{}) error {
	return x.stream.Recv(m)
}

func (x *userServiceSearchUserClient) Recv() (*SearchUserResponse, error) {
	m := new(SearchUserResponse)
	err := x.stream.Recv(m)
	if err != nil {
		return nil, err
	}
	return m, nil
}

func (c *userServiceClient) StreamUser(ctx context.Context, opts ...client.CallOption) (UserService_StreamUserClient, error) {
	req := c.c.NewRequest(c.serviceName, "UserService.StreamUser", &SearchUserRequest{})
	stream, err := c.c.Stream(ctx, req, opts...)
	if err != nil {
		return nil, err
	}
	return &userServiceStreamUserClient{stream}, nil
}

type UserService_StreamUserClient interface {
	SendMsg(interface{}) error
	RecvMsg(interface{}) error
	Close() error
	Send(*SearchUserRequest) error
	Recv() (*SearchUserResponse, error)
}

type userServiceStreamUserClient struct {
	stream client.Streamer
}

func (x *userServiceStreamUserClient) Close() error {
	return x.stream.Close()
}

func (x *userServiceStreamUserClient) SendMsg(m interface{}) error {
	return x.stream.Send(m)
}

func (x *userServiceStreamUserClient) RecvMsg(m interface{}) error {
	return x.stream.Recv(m)
}

func (x *userServiceStreamUserClient) Send(m *SearchUserRequest) error {
	return x.stream.Send(m)
}

func (x *userServiceStreamUserClient) Recv() (*SearchUserResponse, error) {
	m := new(SearchUserResponse)
	err := x.stream.Recv(m)
	if err != nil {
		return nil, err
	}
	return m, nil
}

// Server API for UserService service

type UserServiceHandler interface {
	CreateUser(context.Context, *CreateUserRequest, *CreateUserResponse) error
	DeleteUser(context.Context, *DeleteUserRequest, *DeleteUserResponse) error
	BindUser(context.Context, *BindUserRequest, *BindUserResponse) error
	CountUser(context.Context, *SearchUserRequest, *CountUserResponse) error
	SearchUser(context.Context, *SearchUserRequest, UserService_SearchUserStream) error
	StreamUser(context.Context, UserService_StreamUserStream) error
}

func RegisterUserServiceHandler(s server.Server, hdlr UserServiceHandler, opts ...server.HandlerOption) {
	s.Handle(s.NewHandler(&UserService{hdlr}, opts...))
}

type UserService struct {
	UserServiceHandler
}

func (h *UserService) CreateUser(ctx context.Context, in *CreateUserRequest, out *CreateUserResponse) error {
	return h.UserServiceHandler.CreateUser(ctx, in, out)
}

func (h *UserService) DeleteUser(ctx context.Context, in *DeleteUserRequest, out *DeleteUserResponse) error {
	return h.UserServiceHandler.DeleteUser(ctx, in, out)
}

func (h *UserService) BindUser(ctx context.Context, in *BindUserRequest, out *BindUserResponse) error {
	return h.UserServiceHandler.BindUser(ctx, in, out)
}

func (h *UserService) CountUser(ctx context.Context, in *SearchUserRequest, out *CountUserResponse) error {
	return h.UserServiceHandler.CountUser(ctx, in, out)
}

func (h *UserService) SearchUser(ctx context.Context, stream server.Streamer) error {
	m := new(SearchUserRequest)
	if err := stream.Recv(m); err != nil {
		return err
	}
	return h.UserServiceHandler.SearchUser(ctx, m, &userServiceSearchUserStream{stream})
}

type UserService_SearchUserStream interface {
	SendMsg(interface{}) error
	RecvMsg(interface{}) error
	Close() error
	Send(*SearchUserResponse) error
}

type userServiceSearchUserStream struct {
	stream server.Streamer
}

func (x *userServiceSearchUserStream) Close() error {
	return x.stream.Close()
}

func (x *userServiceSearchUserStream) SendMsg(m interface{}) error {
	return x.stream.Send(m)
}

func (x *userServiceSearchUserStream) RecvMsg(m interface{}) error {
	return x.stream.Recv(m)
}

func (x *userServiceSearchUserStream) Send(m *SearchUserResponse) error {
	return x.stream.Send(m)
}

func (h *UserService) StreamUser(ctx context.Context, stream server.Streamer) error {
	return h.UserServiceHandler.StreamUser(ctx, &userServiceStreamUserStream{stream})
}

type UserService_StreamUserStream interface {
	SendMsg(interface{}) error
	RecvMsg(interface{}) error
	Close() error
	Send(*SearchUserResponse) error
	Recv() (*SearchUserRequest, error)
}

type userServiceStreamUserStream struct {
	stream server.Streamer
}

func (x *userServiceStreamUserStream) Close() error {
	return x.stream.Close()
}

func (x *userServiceStreamUserStream) SendMsg(m interface{}) error {
	return x.stream.Send(m)
}

func (x *userServiceStreamUserStream) RecvMsg(m interface{}) error {
	return x.stream.Recv(m)
}

func (x *userServiceStreamUserStream) Send(m *SearchUserResponse) error {
	return x.stream.Send(m)
}

func (x *userServiceStreamUserStream) Recv() (*SearchUserRequest, error) {
	m := new(SearchUserRequest)
	if err := x.stream.Recv(m); err != nil {
		return nil, err
	}
	return m, nil
}

// Client API for WorkspaceService service

type WorkspaceServiceClient interface {
	CreateWorkspace(ctx context.Context, in *CreateWorkspaceRequest, opts ...client.CallOption) (*CreateWorkspaceResponse, error)
	DeleteWorkspace(ctx context.Context, in *DeleteWorkspaceRequest, opts ...client.CallOption) (*DeleteWorkspaceResponse, error)
	SearchWorkspace(ctx context.Context, in *SearchWorkspaceRequest, opts ...client.CallOption) (WorkspaceService_SearchWorkspaceClient, error)
	StreamWorkspace(ctx context.Context, opts ...client.CallOption) (WorkspaceService_StreamWorkspaceClient, error)
}

type workspaceServiceClient struct {
	c           client.Client
	serviceName string
}

func NewWorkspaceServiceClient(serviceName string, c client.Client) WorkspaceServiceClient {
	if c == nil {
		c = client.NewClient()
	}
	if len(serviceName) == 0 {
		serviceName = "idm"
	}
	return &workspaceServiceClient{
		c:           c,
		serviceName: serviceName,
	}
}

func (c *workspaceServiceClient) CreateWorkspace(ctx context.Context, in *CreateWorkspaceRequest, opts ...client.CallOption) (*CreateWorkspaceResponse, error) {
	req := c.c.NewRequest(c.serviceName, "WorkspaceService.CreateWorkspace", in)
	out := new(CreateWorkspaceResponse)
	err := c.c.Call(ctx, req, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workspaceServiceClient) DeleteWorkspace(ctx context.Context, in *DeleteWorkspaceRequest, opts ...client.CallOption) (*DeleteWorkspaceResponse, error) {
	req := c.c.NewRequest(c.serviceName, "WorkspaceService.DeleteWorkspace", in)
	out := new(DeleteWorkspaceResponse)
	err := c.c.Call(ctx, req, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workspaceServiceClient) SearchWorkspace(ctx context.Context, in *SearchWorkspaceRequest, opts ...client.CallOption) (WorkspaceService_SearchWorkspaceClient, error) {
	req := c.c.NewRequest(c.serviceName, "WorkspaceService.SearchWorkspace", &SearchWorkspaceRequest{})
	stream, err := c.c.Stream(ctx, req, opts...)
	if err != nil {
		return nil, err
	}
	if err := stream.Send(in); err != nil {
		return nil, err
	}
	return &workspaceServiceSearchWorkspaceClient{stream}, nil
}

type WorkspaceService_SearchWorkspaceClient interface {
	SendMsg(interface{}) error
	RecvMsg(interface{}) error
	Close() error
	Recv() (*SearchWorkspaceResponse, error)
}

type workspaceServiceSearchWorkspaceClient struct {
	stream client.Streamer
}

func (x *workspaceServiceSearchWorkspaceClient) Close() error {
	return x.stream.Close()
}

func (x *workspaceServiceSearchWorkspaceClient) SendMsg(m interface{}) error {
	return x.stream.Send(m)
}

func (x *workspaceServiceSearchWorkspaceClient) RecvMsg(m interface{}) error {
	return x.stream.Recv(m)
}

func (x *workspaceServiceSearchWorkspaceClient) Recv() (*SearchWorkspaceResponse, error) {
	m := new(SearchWorkspaceResponse)
	err := x.stream.Recv(m)
	if err != nil {
		return nil, err
	}
	return m, nil
}

func (c *workspaceServiceClient) StreamWorkspace(ctx context.Context, opts ...client.CallOption) (WorkspaceService_StreamWorkspaceClient, error) {
	req := c.c.NewRequest(c.serviceName, "WorkspaceService.StreamWorkspace", &SearchWorkspaceRequest{})
	stream, err := c.c.Stream(ctx, req, opts...)
	if err != nil {
		return nil, err
	}
	return &workspaceServiceStreamWorkspaceClient{stream}, nil
}

type WorkspaceService_StreamWorkspaceClient interface {
	SendMsg(interface{}) error
	RecvMsg(interface{}) error
	Close() error
	Send(*SearchWorkspaceRequest) error
	Recv() (*SearchWorkspaceResponse, error)
}

type workspaceServiceStreamWorkspaceClient struct {
	stream client.Streamer
}

func (x *workspaceServiceStreamWorkspaceClient) Close() error {
	return x.stream.Close()
}

func (x *workspaceServiceStreamWorkspaceClient) SendMsg(m interface{}) error {
	return x.stream.Send(m)
}

func (x *workspaceServiceStreamWorkspaceClient) RecvMsg(m interface{}) error {
	return x.stream.Recv(m)
}

func (x *workspaceServiceStreamWorkspaceClient) Send(m *SearchWorkspaceRequest) error {
	return x.stream.Send(m)
}

func (x *workspaceServiceStreamWorkspaceClient) Recv() (*SearchWorkspaceResponse, error) {
	m := new(SearchWorkspaceResponse)
	err := x.stream.Recv(m)
	if err != nil {
		return nil, err
	}
	return m, nil
}

// Server API for WorkspaceService service

type WorkspaceServiceHandler interface {
	CreateWorkspace(context.Context, *CreateWorkspaceRequest, *CreateWorkspaceResponse) error
	DeleteWorkspace(context.Context, *DeleteWorkspaceRequest, *DeleteWorkspaceResponse) error
	SearchWorkspace(context.Context, *SearchWorkspaceRequest, WorkspaceService_SearchWorkspaceStream) error
	StreamWorkspace(context.Context, WorkspaceService_StreamWorkspaceStream) error
}

func RegisterWorkspaceServiceHandler(s server.Server, hdlr WorkspaceServiceHandler, opts ...server.HandlerOption) {
	s.Handle(s.NewHandler(&WorkspaceService{hdlr}, opts...))
}

type WorkspaceService struct {
	WorkspaceServiceHandler
}

func (h *WorkspaceService) CreateWorkspace(ctx context.Context, in *CreateWorkspaceRequest, out *CreateWorkspaceResponse) error {
	return h.WorkspaceServiceHandler.CreateWorkspace(ctx, in, out)
}

func (h *WorkspaceService) DeleteWorkspace(ctx context.Context, in *DeleteWorkspaceRequest, out *DeleteWorkspaceResponse) error {
	return h.WorkspaceServiceHandler.DeleteWorkspace(ctx, in, out)
}

func (h *WorkspaceService) SearchWorkspace(ctx context.Context, stream server.Streamer) error {
	m := new(SearchWorkspaceRequest)
	if err := stream.Recv(m); err != nil {
		return err
	}
	return h.WorkspaceServiceHandler.SearchWorkspace(ctx, m, &workspaceServiceSearchWorkspaceStream{stream})
}

type WorkspaceService_SearchWorkspaceStream interface {
	SendMsg(interface{}) error
	RecvMsg(interface{}) error
	Close() error
	Send(*SearchWorkspaceResponse) error
}

type workspaceServiceSearchWorkspaceStream struct {
	stream server.Streamer
}

func (x *workspaceServiceSearchWorkspaceStream) Close() error {
	return x.stream.Close()
}

func (x *workspaceServiceSearchWorkspaceStream) SendMsg(m interface{}) error {
	return x.stream.Send(m)
}

func (x *workspaceServiceSearchWorkspaceStream) RecvMsg(m interface{}) error {
	return x.stream.Recv(m)
}

func (x *workspaceServiceSearchWorkspaceStream) Send(m *SearchWorkspaceResponse) error {
	return x.stream.Send(m)
}

func (h *WorkspaceService) StreamWorkspace(ctx context.Context, stream server.Streamer) error {
	return h.WorkspaceServiceHandler.StreamWorkspace(ctx, &workspaceServiceStreamWorkspaceStream{stream})
}

type WorkspaceService_StreamWorkspaceStream interface {
	SendMsg(interface{}) error
	RecvMsg(interface{}) error
	Close() error
	Send(*SearchWorkspaceResponse) error
	Recv() (*SearchWorkspaceRequest, error)
}

type workspaceServiceStreamWorkspaceStream struct {
	stream server.Streamer
}

func (x *workspaceServiceStreamWorkspaceStream) Close() error {
	return x.stream.Close()
}

func (x *workspaceServiceStreamWorkspaceStream) SendMsg(m interface{}) error {
	return x.stream.Send(m)
}

func (x *workspaceServiceStreamWorkspaceStream) RecvMsg(m interface{}) error {
	return x.stream.Recv(m)
}

func (x *workspaceServiceStreamWorkspaceStream) Send(m *SearchWorkspaceResponse) error {
	return x.stream.Send(m)
}

func (x *workspaceServiceStreamWorkspaceStream) Recv() (*SearchWorkspaceRequest, error) {
	m := new(SearchWorkspaceRequest)
	if err := x.stream.Recv(m); err != nil {
		return nil, err
	}
	return m, nil
}

// Client API for ACLService service

type ACLServiceClient interface {
	CreateACL(ctx context.Context, in *CreateACLRequest, opts ...client.CallOption) (*CreateACLResponse, error)
	ExpireACL(ctx context.Context, in *ExpireACLRequest, opts ...client.CallOption) (*ExpireACLResponse, error)
	DeleteACL(ctx context.Context, in *DeleteACLRequest, opts ...client.CallOption) (*DeleteACLResponse, error)
	SearchACL(ctx context.Context, in *SearchACLRequest, opts ...client.CallOption) (ACLService_SearchACLClient, error)
	StreamACL(ctx context.Context, opts ...client.CallOption) (ACLService_StreamACLClient, error)
}

type aCLServiceClient struct {
	c           client.Client
	serviceName string
}

func NewACLServiceClient(serviceName string, c client.Client) ACLServiceClient {
	if c == nil {
		c = client.NewClient()
	}
	if len(serviceName) == 0 {
		serviceName = "idm"
	}
	return &aCLServiceClient{
		c:           c,
		serviceName: serviceName,
	}
}

func (c *aCLServiceClient) CreateACL(ctx context.Context, in *CreateACLRequest, opts ...client.CallOption) (*CreateACLResponse, error) {
	req := c.c.NewRequest(c.serviceName, "ACLService.CreateACL", in)
	out := new(CreateACLResponse)
	err := c.c.Call(ctx, req, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aCLServiceClient) ExpireACL(ctx context.Context, in *ExpireACLRequest, opts ...client.CallOption) (*ExpireACLResponse, error) {
	req := c.c.NewRequest(c.serviceName, "ACLService.ExpireACL", in)
	out := new(ExpireACLResponse)
	err := c.c.Call(ctx, req, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aCLServiceClient) DeleteACL(ctx context.Context, in *DeleteACLRequest, opts ...client.CallOption) (*DeleteACLResponse, error) {
	req := c.c.NewRequest(c.serviceName, "ACLService.DeleteACL", in)
	out := new(DeleteACLResponse)
	err := c.c.Call(ctx, req, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aCLServiceClient) SearchACL(ctx context.Context, in *SearchACLRequest, opts ...client.CallOption) (ACLService_SearchACLClient, error) {
	req := c.c.NewRequest(c.serviceName, "ACLService.SearchACL", &SearchACLRequest{})
	stream, err := c.c.Stream(ctx, req, opts...)
	if err != nil {
		return nil, err
	}
	if err := stream.Send(in); err != nil {
		return nil, err
	}
	return &aCLServiceSearchACLClient{stream}, nil
}

type ACLService_SearchACLClient interface {
	SendMsg(interface{}) error
	RecvMsg(interface{}) error
	Close() error
	Recv() (*SearchACLResponse, error)
}

type aCLServiceSearchACLClient struct {
	stream client.Streamer
}

func (x *aCLServiceSearchACLClient) Close() error {
	return x.stream.Close()
}

func (x *aCLServiceSearchACLClient) SendMsg(m interface{}) error {
	return x.stream.Send(m)
}

func (x *aCLServiceSearchACLClient) RecvMsg(m interface{}) error {
	return x.stream.Recv(m)
}

func (x *aCLServiceSearchACLClient) Recv() (*SearchACLResponse, error) {
	m := new(SearchACLResponse)
	err := x.stream.Recv(m)
	if err != nil {
		return nil, err
	}
	return m, nil
}

func (c *aCLServiceClient) StreamACL(ctx context.Context, opts ...client.CallOption) (ACLService_StreamACLClient, error) {
	req := c.c.NewRequest(c.serviceName, "ACLService.StreamACL", &SearchACLRequest{})
	stream, err := c.c.Stream(ctx, req, opts...)
	if err != nil {
		return nil, err
	}
	return &aCLServiceStreamACLClient{stream}, nil
}

type ACLService_StreamACLClient interface {
	SendMsg(interface{}) error
	RecvMsg(interface{}) error
	Close() error
	Send(*SearchACLRequest) error
	Recv() (*SearchACLResponse, error)
}

type aCLServiceStreamACLClient struct {
	stream client.Streamer
}

func (x *aCLServiceStreamACLClient) Close() error {
	return x.stream.Close()
}

func (x *aCLServiceStreamACLClient) SendMsg(m interface{}) error {
	return x.stream.Send(m)
}

func (x *aCLServiceStreamACLClient) RecvMsg(m interface{}) error {
	return x.stream.Recv(m)
}

func (x *aCLServiceStreamACLClient) Send(m *SearchACLRequest) error {
	return x.stream.Send(m)
}

func (x *aCLServiceStreamACLClient) Recv() (*SearchACLResponse, error) {
	m := new(SearchACLResponse)
	err := x.stream.Recv(m)
	if err != nil {
		return nil, err
	}
	return m, nil
}

// Server API for ACLService service

type ACLServiceHandler interface {
	CreateACL(context.Context, *CreateACLRequest, *CreateACLResponse) error
	ExpireACL(context.Context, *ExpireACLRequest, *ExpireACLResponse) error
	DeleteACL(context.Context, *DeleteACLRequest, *DeleteACLResponse) error
	SearchACL(context.Context, *SearchACLRequest, ACLService_SearchACLStream) error
	StreamACL(context.Context, ACLService_StreamACLStream) error
}

func RegisterACLServiceHandler(s server.Server, hdlr ACLServiceHandler, opts ...server.HandlerOption) {
	s.Handle(s.NewHandler(&ACLService{hdlr}, opts...))
}

type ACLService struct {
	ACLServiceHandler
}

func (h *ACLService) CreateACL(ctx context.Context, in *CreateACLRequest, out *CreateACLResponse) error {
	return h.ACLServiceHandler.CreateACL(ctx, in, out)
}

func (h *ACLService) ExpireACL(ctx context.Context, in *ExpireACLRequest, out *ExpireACLResponse) error {
	return h.ACLServiceHandler.ExpireACL(ctx, in, out)
}

func (h *ACLService) DeleteACL(ctx context.Context, in *DeleteACLRequest, out *DeleteACLResponse) error {
	return h.ACLServiceHandler.DeleteACL(ctx, in, out)
}

func (h *ACLService) SearchACL(ctx context.Context, stream server.Streamer) error {
	m := new(SearchACLRequest)
	if err := stream.Recv(m); err != nil {
		return err
	}
	return h.ACLServiceHandler.SearchACL(ctx, m, &aCLServiceSearchACLStream{stream})
}

type ACLService_SearchACLStream interface {
	SendMsg(interface{}) error
	RecvMsg(interface{}) error
	Close() error
	Send(*SearchACLResponse) error
}

type aCLServiceSearchACLStream struct {
	stream server.Streamer
}

func (x *aCLServiceSearchACLStream) Close() error {
	return x.stream.Close()
}

func (x *aCLServiceSearchACLStream) SendMsg(m interface{}) error {
	return x.stream.Send(m)
}

func (x *aCLServiceSearchACLStream) RecvMsg(m interface{}) error {
	return x.stream.Recv(m)
}

func (x *aCLServiceSearchACLStream) Send(m *SearchACLResponse) error {
	return x.stream.Send(m)
}

func (h *ACLService) StreamACL(ctx context.Context, stream server.Streamer) error {
	return h.ACLServiceHandler.StreamACL(ctx, &aCLServiceStreamACLStream{stream})
}

type ACLService_StreamACLStream interface {
	SendMsg(interface{}) error
	RecvMsg(interface{}) error
	Close() error
	Send(*SearchACLResponse) error
	Recv() (*SearchACLRequest, error)
}

type aCLServiceStreamACLStream struct {
	stream server.Streamer
}

func (x *aCLServiceStreamACLStream) Close() error {
	return x.stream.Close()
}

func (x *aCLServiceStreamACLStream) SendMsg(m interface{}) error {
	return x.stream.Send(m)
}

func (x *aCLServiceStreamACLStream) RecvMsg(m interface{}) error {
	return x.stream.Recv(m)
}

func (x *aCLServiceStreamACLStream) Send(m *SearchACLResponse) error {
	return x.stream.Send(m)
}

func (x *aCLServiceStreamACLStream) Recv() (*SearchACLRequest, error) {
	m := new(SearchACLRequest)
	if err := x.stream.Recv(m); err != nil {
		return nil, err
	}
	return m, nil
}

// Client API for UserMetaService service

type UserMetaServiceClient interface {
	UpdateUserMeta(ctx context.Context, in *UpdateUserMetaRequest, opts ...client.CallOption) (*UpdateUserMetaResponse, error)
	SearchUserMeta(ctx context.Context, in *SearchUserMetaRequest, opts ...client.CallOption) (UserMetaService_SearchUserMetaClient, error)
	UpdateUserMetaNamespace(ctx context.Context, in *UpdateUserMetaNamespaceRequest, opts ...client.CallOption) (*UpdateUserMetaNamespaceResponse, error)
	ListUserMetaNamespace(ctx context.Context, in *ListUserMetaNamespaceRequest, opts ...client.CallOption) (UserMetaService_ListUserMetaNamespaceClient, error)
}

type userMetaServiceClient struct {
	c           client.Client
	serviceName string
}

func NewUserMetaServiceClient(serviceName string, c client.Client) UserMetaServiceClient {
	if c == nil {
		c = client.NewClient()
	}
	if len(serviceName) == 0 {
		serviceName = "idm"
	}
	return &userMetaServiceClient{
		c:           c,
		serviceName: serviceName,
	}
}

func (c *userMetaServiceClient) UpdateUserMeta(ctx context.Context, in *UpdateUserMetaRequest, opts ...client.CallOption) (*UpdateUserMetaResponse, error) {
	req := c.c.NewRequest(c.serviceName, "UserMetaService.UpdateUserMeta", in)
	out := new(UpdateUserMetaResponse)
	err := c.c.Call(ctx, req, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userMetaServiceClient) SearchUserMeta(ctx context.Context, in *SearchUserMetaRequest, opts ...client.CallOption) (UserMetaService_SearchUserMetaClient, error) {
	req := c.c.NewRequest(c.serviceName, "UserMetaService.SearchUserMeta", &SearchUserMetaRequest{})
	stream, err := c.c.Stream(ctx, req, opts...)
	if err != nil {
		return nil, err
	}
	if err := stream.Send(in); err != nil {
		return nil, err
	}
	return &userMetaServiceSearchUserMetaClient{stream}, nil
}

type UserMetaService_SearchUserMetaClient interface {
	SendMsg(interface{}) error
	RecvMsg(interface{}) error
	Close() error
	Recv() (*SearchUserMetaResponse, error)
}

type userMetaServiceSearchUserMetaClient struct {
	stream client.Streamer
}

func (x *userMetaServiceSearchUserMetaClient) Close() error {
	return x.stream.Close()
}

func (x *userMetaServiceSearchUserMetaClient) SendMsg(m interface{}) error {
	return x.stream.Send(m)
}

func (x *userMetaServiceSearchUserMetaClient) RecvMsg(m interface{}) error {
	return x.stream.Recv(m)
}

func (x *userMetaServiceSearchUserMetaClient) Recv() (*SearchUserMetaResponse, error) {
	m := new(SearchUserMetaResponse)
	err := x.stream.Recv(m)
	if err != nil {
		return nil, err
	}
	return m, nil
}

func (c *userMetaServiceClient) UpdateUserMetaNamespace(ctx context.Context, in *UpdateUserMetaNamespaceRequest, opts ...client.CallOption) (*UpdateUserMetaNamespaceResponse, error) {
	req := c.c.NewRequest(c.serviceName, "UserMetaService.UpdateUserMetaNamespace", in)
	out := new(UpdateUserMetaNamespaceResponse)
	err := c.c.Call(ctx, req, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *userMetaServiceClient) ListUserMetaNamespace(ctx context.Context, in *ListUserMetaNamespaceRequest, opts ...client.CallOption) (UserMetaService_ListUserMetaNamespaceClient, error) {
	req := c.c.NewRequest(c.serviceName, "UserMetaService.ListUserMetaNamespace", &ListUserMetaNamespaceRequest{})
	stream, err := c.c.Stream(ctx, req, opts...)
	if err != nil {
		return nil, err
	}
	if err := stream.Send(in); err != nil {
		return nil, err
	}
	return &userMetaServiceListUserMetaNamespaceClient{stream}, nil
}

type UserMetaService_ListUserMetaNamespaceClient interface {
	SendMsg(interface{}) error
	RecvMsg(interface{}) error
	Close() error
	Recv() (*ListUserMetaNamespaceResponse, error)
}

type userMetaServiceListUserMetaNamespaceClient struct {
	stream client.Streamer
}

func (x *userMetaServiceListUserMetaNamespaceClient) Close() error {
	return x.stream.Close()
}

func (x *userMetaServiceListUserMetaNamespaceClient) SendMsg(m interface{}) error {
	return x.stream.Send(m)
}

func (x *userMetaServiceListUserMetaNamespaceClient) RecvMsg(m interface{}) error {
	return x.stream.Recv(m)
}

func (x *userMetaServiceListUserMetaNamespaceClient) Recv() (*ListUserMetaNamespaceResponse, error) {
	m := new(ListUserMetaNamespaceResponse)
	err := x.stream.Recv(m)
	if err != nil {
		return nil, err
	}
	return m, nil
}

// Server API for UserMetaService service

type UserMetaServiceHandler interface {
	UpdateUserMeta(context.Context, *UpdateUserMetaRequest, *UpdateUserMetaResponse) error
	SearchUserMeta(context.Context, *SearchUserMetaRequest, UserMetaService_SearchUserMetaStream) error
	UpdateUserMetaNamespace(context.Context, *UpdateUserMetaNamespaceRequest, *UpdateUserMetaNamespaceResponse) error
	ListUserMetaNamespace(context.Context, *ListUserMetaNamespaceRequest, UserMetaService_ListUserMetaNamespaceStream) error
}

func RegisterUserMetaServiceHandler(s server.Server, hdlr UserMetaServiceHandler, opts ...server.HandlerOption) {
	s.Handle(s.NewHandler(&UserMetaService{hdlr}, opts...))
}

type UserMetaService struct {
	UserMetaServiceHandler
}

func (h *UserMetaService) UpdateUserMeta(ctx context.Context, in *UpdateUserMetaRequest, out *UpdateUserMetaResponse) error {
	return h.UserMetaServiceHandler.UpdateUserMeta(ctx, in, out)
}

func (h *UserMetaService) SearchUserMeta(ctx context.Context, stream server.Streamer) error {
	m := new(SearchUserMetaRequest)
	if err := stream.Recv(m); err != nil {
		return err
	}
	return h.UserMetaServiceHandler.SearchUserMeta(ctx, m, &userMetaServiceSearchUserMetaStream{stream})
}

type UserMetaService_SearchUserMetaStream interface {
	SendMsg(interface{}) error
	RecvMsg(interface{}) error
	Close() error
	Send(*SearchUserMetaResponse) error
}

type userMetaServiceSearchUserMetaStream struct {
	stream server.Streamer
}

func (x *userMetaServiceSearchUserMetaStream) Close() error {
	return x.stream.Close()
}

func (x *userMetaServiceSearchUserMetaStream) SendMsg(m interface{}) error {
	return x.stream.Send(m)
}

func (x *userMetaServiceSearchUserMetaStream) RecvMsg(m interface{}) error {
	return x.stream.Recv(m)
}

func (x *userMetaServiceSearchUserMetaStream) Send(m *SearchUserMetaResponse) error {
	return x.stream.Send(m)
}

func (h *UserMetaService) UpdateUserMetaNamespace(ctx context.Context, in *UpdateUserMetaNamespaceRequest, out *UpdateUserMetaNamespaceResponse) error {
	return h.UserMetaServiceHandler.UpdateUserMetaNamespace(ctx, in, out)
}

func (h *UserMetaService) ListUserMetaNamespace(ctx context.Context, stream server.Streamer) error {
	m := new(ListUserMetaNamespaceRequest)
	if err := stream.Recv(m); err != nil {
		return err
	}
	return h.UserMetaServiceHandler.ListUserMetaNamespace(ctx, m, &userMetaServiceListUserMetaNamespaceStream{stream})
}

type UserMetaService_ListUserMetaNamespaceStream interface {
	SendMsg(interface{}) error
	RecvMsg(interface{}) error
	Close() error
	Send(*ListUserMetaNamespaceResponse) error
}

type userMetaServiceListUserMetaNamespaceStream struct {
	stream server.Streamer
}

func (x *userMetaServiceListUserMetaNamespaceStream) Close() error {
	return x.stream.Close()
}

func (x *userMetaServiceListUserMetaNamespaceStream) SendMsg(m interface{}) error {
	return x.stream.Send(m)
}

func (x *userMetaServiceListUserMetaNamespaceStream) RecvMsg(m interface{}) error {
	return x.stream.Recv(m)
}

func (x *userMetaServiceListUserMetaNamespaceStream) Send(m *ListUserMetaNamespaceResponse) error {
	return x.stream.Send(m)
}

// Client API for PolicyEngineService service

type PolicyEngineServiceClient interface {
	IsAllowed(ctx context.Context, in *PolicyEngineRequest, opts ...client.CallOption) (*PolicyEngineResponse, error)
	StorePolicyGroup(ctx context.Context, in *StorePolicyGroupRequest, opts ...client.CallOption) (*StorePolicyGroupResponse, error)
	ListPolicyGroups(ctx context.Context, in *ListPolicyGroupsRequest, opts ...client.CallOption) (*ListPolicyGroupsResponse, error)
	DeletePolicyGroup(ctx context.Context, in *DeletePolicyGroupRequest, opts ...client.CallOption) (*DeletePolicyGroupResponse, error)
}

type policyEngineServiceClient struct {
	c           client.Client
	serviceName string
}

func NewPolicyEngineServiceClient(serviceName string, c client.Client) PolicyEngineServiceClient {
	if c == nil {
		c = client.NewClient()
	}
	if len(serviceName) == 0 {
		serviceName = "idm"
	}
	return &policyEngineServiceClient{
		c:           c,
		serviceName: serviceName,
	}
}

func (c *policyEngineServiceClient) IsAllowed(ctx context.Context, in *PolicyEngineRequest, opts ...client.CallOption) (*PolicyEngineResponse, error) {
	req := c.c.NewRequest(c.serviceName, "PolicyEngineService.IsAllowed", in)
	out := new(PolicyEngineResponse)
	err := c.c.Call(ctx, req, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyEngineServiceClient) StorePolicyGroup(ctx context.Context, in *StorePolicyGroupRequest, opts ...client.CallOption) (*StorePolicyGroupResponse, error) {
	req := c.c.NewRequest(c.serviceName, "PolicyEngineService.StorePolicyGroup", in)
	out := new(StorePolicyGroupResponse)
	err := c.c.Call(ctx, req, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyEngineServiceClient) ListPolicyGroups(ctx context.Context, in *ListPolicyGroupsRequest, opts ...client.CallOption) (*ListPolicyGroupsResponse, error) {
	req := c.c.NewRequest(c.serviceName, "PolicyEngineService.ListPolicyGroups", in)
	out := new(ListPolicyGroupsResponse)
	err := c.c.Call(ctx, req, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policyEngineServiceClient) DeletePolicyGroup(ctx context.Context, in *DeletePolicyGroupRequest, opts ...client.CallOption) (*DeletePolicyGroupResponse, error) {
	req := c.c.NewRequest(c.serviceName, "PolicyEngineService.DeletePolicyGroup", in)
	out := new(DeletePolicyGroupResponse)
	err := c.c.Call(ctx, req, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for PolicyEngineService service

type PolicyEngineServiceHandler interface {
	IsAllowed(context.Context, *PolicyEngineRequest, *PolicyEngineResponse) error
	StorePolicyGroup(context.Context, *StorePolicyGroupRequest, *StorePolicyGroupResponse) error
	ListPolicyGroups(context.Context, *ListPolicyGroupsRequest, *ListPolicyGroupsResponse) error
	DeletePolicyGroup(context.Context, *DeletePolicyGroupRequest, *DeletePolicyGroupResponse) error
}

func RegisterPolicyEngineServiceHandler(s server.Server, hdlr PolicyEngineServiceHandler, opts ...server.HandlerOption) {
	s.Handle(s.NewHandler(&PolicyEngineService{hdlr}, opts...))
}

type PolicyEngineService struct {
	PolicyEngineServiceHandler
}

func (h *PolicyEngineService) IsAllowed(ctx context.Context, in *PolicyEngineRequest, out *PolicyEngineResponse) error {
	return h.PolicyEngineServiceHandler.IsAllowed(ctx, in, out)
}

func (h *PolicyEngineService) StorePolicyGroup(ctx context.Context, in *StorePolicyGroupRequest, out *StorePolicyGroupResponse) error {
	return h.PolicyEngineServiceHandler.StorePolicyGroup(ctx, in, out)
}

func (h *PolicyEngineService) ListPolicyGroups(ctx context.Context, in *ListPolicyGroupsRequest, out *ListPolicyGroupsResponse) error {
	return h.PolicyEngineServiceHandler.ListPolicyGroups(ctx, in, out)
}

func (h *PolicyEngineService) DeletePolicyGroup(ctx context.Context, in *DeletePolicyGroupRequest, out *DeletePolicyGroupResponse) error {
	return h.PolicyEngineServiceHandler.DeletePolicyGroup(ctx, in, out)
}
