// Code generated by protoc-gen-go. DO NOT EDIT.
// source: idm.proto

/*
Package idm is a generated protocol buffer package.

It is generated from these files:
	idm.proto

It has these top-level messages:
	CreateRoleRequest
	CreateRoleResponse
	DeleteRoleRequest
	DeleteRoleResponse
	SearchRoleRequest
	SearchRoleResponse
	CountRoleResponse
	Role
	RoleSingleQuery
	CreateUserRequest
	CreateUserResponse
	BindUserRequest
	BindUserResponse
	DeleteUserRequest
	DeleteUserResponse
	SearchUserRequest
	SearchUserResponse
	CountUserResponse
	User
	UserSingleQuery
	CreateWorkspaceRequest
	CreateWorkspaceResponse
	DeleteWorkspaceRequest
	DeleteWorkspaceResponse
	SearchWorkspaceRequest
	SearchWorkspaceResponse
	Workspace
	WorkspaceSingleQuery
	CreateACLRequest
	CreateACLResponse
	ExpireACLRequest
	ExpireACLResponse
	DeleteACLRequest
	DeleteACLResponse
	SearchACLRequest
	SearchACLResponse
	ACLAction
	ACL
	ACLSingleQuery
	UserMeta
	UserMetaNamespace
	UpdateUserMetaRequest
	UpdateUserMetaResponse
	SearchUserMetaRequest
	SearchUserMetaResponse
	UpdateUserMetaNamespaceRequest
	UpdateUserMetaNamespaceResponse
	ListUserMetaNamespaceRequest
	ListUserMetaNamespaceResponse
	ChangeEvent
	PolicyEngineRequest
	PolicyEngineResponse
	PolicyCondition
	Policy
	PolicyGroup
	StorePolicyGroupRequest
	StorePolicyGroupResponse
	DeletePolicyGroupRequest
	DeletePolicyGroupResponse
	ListPolicyGroupsRequest
	ListPolicyGroupsResponse
*/
package idm

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import service "github.com/pydio/cells/common/service/proto"
import tree "github.com/pydio/cells/common/proto/tree"
import _ "github.com/mwitkow/go-proto-validators"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type NodeType int32

const (
	NodeType_UNKNOWN NodeType = 0
	NodeType_USER    NodeType = 1
	NodeType_GROUP   NodeType = 2
)

var NodeType_name = map[int32]string{
	0: "UNKNOWN",
	1: "USER",
	2: "GROUP",
}
var NodeType_value = map[string]int32{
	"UNKNOWN": 0,
	"USER":    1,
	"GROUP":   2,
}

func (x NodeType) String() string {
	return proto.EnumName(NodeType_name, int32(x))
}
func (NodeType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

type WorkspaceScope int32

const (
	WorkspaceScope_ANY   WorkspaceScope = 0
	WorkspaceScope_ADMIN WorkspaceScope = 1
	WorkspaceScope_ROOM  WorkspaceScope = 2
	WorkspaceScope_LINK  WorkspaceScope = 3
)

var WorkspaceScope_name = map[int32]string{
	0: "ANY",
	1: "ADMIN",
	2: "ROOM",
	3: "LINK",
}
var WorkspaceScope_value = map[string]int32{
	"ANY":   0,
	"ADMIN": 1,
	"ROOM":  2,
	"LINK":  3,
}

func (x WorkspaceScope) String() string {
	return proto.EnumName(WorkspaceScope_name, int32(x))
}
func (WorkspaceScope) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

// Message Types for ChangeEvent
type ChangeEventType int32

const (
	ChangeEventType_CREATE ChangeEventType = 0
	ChangeEventType_READ   ChangeEventType = 1
	ChangeEventType_UPDATE ChangeEventType = 2
	ChangeEventType_DELETE ChangeEventType = 3
	ChangeEventType_LOGIN  ChangeEventType = 4
	ChangeEventType_LOGOUT ChangeEventType = 5
)

var ChangeEventType_name = map[int32]string{
	0: "CREATE",
	1: "READ",
	2: "UPDATE",
	3: "DELETE",
	4: "LOGIN",
	5: "LOGOUT",
}
var ChangeEventType_value = map[string]int32{
	"CREATE": 0,
	"READ":   1,
	"UPDATE": 2,
	"DELETE": 3,
	"LOGIN":  4,
	"LOGOUT": 5,
}

func (x ChangeEventType) String() string {
	return proto.EnumName(ChangeEventType_name, int32(x))
}
func (ChangeEventType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

type PolicyEffect int32

const (
	PolicyEffect_unknown PolicyEffect = 0
	PolicyEffect_deny    PolicyEffect = 1
	PolicyEffect_allow   PolicyEffect = 2
)

var PolicyEffect_name = map[int32]string{
	0: "unknown",
	1: "deny",
	2: "allow",
}
var PolicyEffect_value = map[string]int32{
	"unknown": 0,
	"deny":    1,
	"allow":   2,
}

func (x PolicyEffect) String() string {
	return proto.EnumName(PolicyEffect_name, int32(x))
}
func (PolicyEffect) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

type PolicyResourceGroup int32

const (
	PolicyResourceGroup_rest PolicyResourceGroup = 0
	PolicyResourceGroup_acl  PolicyResourceGroup = 1
	PolicyResourceGroup_oidc PolicyResourceGroup = 2
)

var PolicyResourceGroup_name = map[int32]string{
	0: "rest",
	1: "acl",
	2: "oidc",
}
var PolicyResourceGroup_value = map[string]int32{
	"rest": 0,
	"acl":  1,
	"oidc": 2,
}

func (x PolicyResourceGroup) String() string {
	return proto.EnumName(PolicyResourceGroup_name, int32(x))
}
func (PolicyResourceGroup) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

type UpdateUserMetaRequest_UserMetaOp int32

const (
	UpdateUserMetaRequest_PUT    UpdateUserMetaRequest_UserMetaOp = 0
	UpdateUserMetaRequest_DELETE UpdateUserMetaRequest_UserMetaOp = 1
)

var UpdateUserMetaRequest_UserMetaOp_name = map[int32]string{
	0: "PUT",
	1: "DELETE",
}
var UpdateUserMetaRequest_UserMetaOp_value = map[string]int32{
	"PUT":    0,
	"DELETE": 1,
}

func (x UpdateUserMetaRequest_UserMetaOp) String() string {
	return proto.EnumName(UpdateUserMetaRequest_UserMetaOp_name, int32(x))
}
func (UpdateUserMetaRequest_UserMetaOp) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{41, 0}
}

type UpdateUserMetaNamespaceRequest_UserMetaNsOp int32

const (
	UpdateUserMetaNamespaceRequest_PUT    UpdateUserMetaNamespaceRequest_UserMetaNsOp = 0
	UpdateUserMetaNamespaceRequest_DELETE UpdateUserMetaNamespaceRequest_UserMetaNsOp = 1
)

var UpdateUserMetaNamespaceRequest_UserMetaNsOp_name = map[int32]string{
	0: "PUT",
	1: "DELETE",
}
var UpdateUserMetaNamespaceRequest_UserMetaNsOp_value = map[string]int32{
	"PUT":    0,
	"DELETE": 1,
}

func (x UpdateUserMetaNamespaceRequest_UserMetaNsOp) String() string {
	return proto.EnumName(UpdateUserMetaNamespaceRequest_UserMetaNsOp_name, int32(x))
}
func (UpdateUserMetaNamespaceRequest_UserMetaNsOp) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{45, 0}
}

// *****************************************************************************
//  Messages structure
// *****************************************************************************
type CreateRoleRequest struct {
	Role *Role `protobuf:"bytes,1,opt,name=Role" json:"Role,omitempty"`
}

func (m *CreateRoleRequest) Reset()                    { *m = CreateRoleRequest{} }
func (m *CreateRoleRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateRoleRequest) ProtoMessage()               {}
func (*CreateRoleRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *CreateRoleRequest) GetRole() *Role {
	if m != nil {
		return m.Role
	}
	return nil
}

type CreateRoleResponse struct {
	Role *Role `protobuf:"bytes,1,opt,name=Role" json:"Role,omitempty"`
}

func (m *CreateRoleResponse) Reset()                    { *m = CreateRoleResponse{} }
func (m *CreateRoleResponse) String() string            { return proto.CompactTextString(m) }
func (*CreateRoleResponse) ProtoMessage()               {}
func (*CreateRoleResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *CreateRoleResponse) GetRole() *Role {
	if m != nil {
		return m.Role
	}
	return nil
}

type DeleteRoleRequest struct {
	Query *service.Query `protobuf:"bytes,1,opt,name=Query" json:"Query,omitempty"`
}

func (m *DeleteRoleRequest) Reset()                    { *m = DeleteRoleRequest{} }
func (m *DeleteRoleRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteRoleRequest) ProtoMessage()               {}
func (*DeleteRoleRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *DeleteRoleRequest) GetQuery() *service.Query {
	if m != nil {
		return m.Query
	}
	return nil
}

type DeleteRoleResponse struct {
	RowsDeleted int64 `protobuf:"varint,1,opt,name=RowsDeleted" json:"RowsDeleted,omitempty"`
}

func (m *DeleteRoleResponse) Reset()                    { *m = DeleteRoleResponse{} }
func (m *DeleteRoleResponse) String() string            { return proto.CompactTextString(m) }
func (*DeleteRoleResponse) ProtoMessage()               {}
func (*DeleteRoleResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *DeleteRoleResponse) GetRowsDeleted() int64 {
	if m != nil {
		return m.RowsDeleted
	}
	return 0
}

type SearchRoleRequest struct {
	Query *service.Query `protobuf:"bytes,1,opt,name=Query" json:"Query,omitempty"`
}

func (m *SearchRoleRequest) Reset()                    { *m = SearchRoleRequest{} }
func (m *SearchRoleRequest) String() string            { return proto.CompactTextString(m) }
func (*SearchRoleRequest) ProtoMessage()               {}
func (*SearchRoleRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *SearchRoleRequest) GetQuery() *service.Query {
	if m != nil {
		return m.Query
	}
	return nil
}

type SearchRoleResponse struct {
	Role *Role `protobuf:"bytes,1,opt,name=Role" json:"Role,omitempty"`
}

func (m *SearchRoleResponse) Reset()                    { *m = SearchRoleResponse{} }
func (m *SearchRoleResponse) String() string            { return proto.CompactTextString(m) }
func (*SearchRoleResponse) ProtoMessage()               {}
func (*SearchRoleResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *SearchRoleResponse) GetRole() *Role {
	if m != nil {
		return m.Role
	}
	return nil
}

type CountRoleResponse struct {
	Count int32 `protobuf:"varint,1,opt,name=Count" json:"Count,omitempty"`
}

func (m *CountRoleResponse) Reset()                    { *m = CountRoleResponse{} }
func (m *CountRoleResponse) String() string            { return proto.CompactTextString(m) }
func (*CountRoleResponse) ProtoMessage()               {}
func (*CountRoleResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *CountRoleResponse) GetCount() int32 {
	if m != nil {
		return m.Count
	}
	return 0
}

// Role represents a generic set of permissions that can be applied to any users or groups.
type Role struct {
	// Unique identifier of this role
	Uuid string `protobuf:"bytes,1,opt,name=Uuid" json:"Uuid,omitempty"`
	// Label of this role
	Label string `protobuf:"bytes,2,opt,name=Label" json:"Label,omitempty"`
	// Whether this role represents a user team or not
	IsTeam bool `protobuf:"varint,3,opt,name=IsTeam" json:"IsTeam,omitempty"`
	// Whether this role is attached to a Group object
	GroupRole bool `protobuf:"varint,4,opt,name=GroupRole" json:"GroupRole,omitempty"`
	// Whether this role is attached to a User object
	UserRole bool `protobuf:"varint,5,opt,name=UserRole" json:"UserRole,omitempty"`
	// Last modification date of the role
	LastUpdated int32 `protobuf:"varint,6,opt,name=LastUpdated" json:"LastUpdated,omitempty"`
	// List of profiles (standard, shared, admin) on which the role will be automatically applied
	AutoApplies []string `protobuf:"bytes,7,rep,name=AutoApplies" json:"AutoApplies,omitempty"`
	// List of policies for securing this role access
	Policies []*service.ResourcePolicy `protobuf:"bytes,8,rep,name=Policies" json:"Policies,omitempty"`
	// Whether the policies resolve into an editable state
	PoliciesContextEditable bool `protobuf:"varint,9,opt,name=PoliciesContextEditable" json:"PoliciesContextEditable,omitempty"`
	// Is used in a stack of roles, this one will always be applied last.
	ForceOverride bool `protobuf:"varint,10,opt,name=ForceOverride" json:"ForceOverride,omitempty"`
}

func (m *Role) Reset()                    { *m = Role{} }
func (m *Role) String() string            { return proto.CompactTextString(m) }
func (*Role) ProtoMessage()               {}
func (*Role) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *Role) GetUuid() string {
	if m != nil {
		return m.Uuid
	}
	return ""
}

func (m *Role) GetLabel() string {
	if m != nil {
		return m.Label
	}
	return ""
}

func (m *Role) GetIsTeam() bool {
	if m != nil {
		return m.IsTeam
	}
	return false
}

func (m *Role) GetGroupRole() bool {
	if m != nil {
		return m.GroupRole
	}
	return false
}

func (m *Role) GetUserRole() bool {
	if m != nil {
		return m.UserRole
	}
	return false
}

func (m *Role) GetLastUpdated() int32 {
	if m != nil {
		return m.LastUpdated
	}
	return 0
}

func (m *Role) GetAutoApplies() []string {
	if m != nil {
		return m.AutoApplies
	}
	return nil
}

func (m *Role) GetPolicies() []*service.ResourcePolicy {
	if m != nil {
		return m.Policies
	}
	return nil
}

func (m *Role) GetPoliciesContextEditable() bool {
	if m != nil {
		return m.PoliciesContextEditable
	}
	return false
}

func (m *Role) GetForceOverride() bool {
	if m != nil {
		return m.ForceOverride
	}
	return false
}

// RoleSingleQuery is the basic unit for building queries to Roles.
type RoleSingleQuery struct {
	// Look for roles by Uuid
	Uuid []string `protobuf:"bytes,1,rep,name=Uuid" json:"Uuid,omitempty"`
	// Look for roles by label, eventually using wildchar
	Label string `protobuf:"bytes,2,opt,name=Label" json:"Label,omitempty"`
	// Look for team roles only
	IsTeam bool `protobuf:"varint,3,opt,name=IsTeam" json:"IsTeam,omitempty"`
	// Look for group roles only
	IsGroupRole bool `protobuf:"varint,4,opt,name=IsGroupRole" json:"IsGroupRole,omitempty"`
	// Look for user roles only
	IsUserRole bool `protobuf:"varint,5,opt,name=IsUserRole" json:"IsUserRole,omitempty"`
	// Look for roles that have any value in the autoApplies field
	HasAutoApply bool `protobuf:"varint,6,opt,name=HasAutoApply" json:"HasAutoApply,omitempty"`
	// Negate the query
	Not bool `protobuf:"varint,7,opt,name=not" json:"not,omitempty"`
}

func (m *RoleSingleQuery) Reset()                    { *m = RoleSingleQuery{} }
func (m *RoleSingleQuery) String() string            { return proto.CompactTextString(m) }
func (*RoleSingleQuery) ProtoMessage()               {}
func (*RoleSingleQuery) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *RoleSingleQuery) GetUuid() []string {
	if m != nil {
		return m.Uuid
	}
	return nil
}

func (m *RoleSingleQuery) GetLabel() string {
	if m != nil {
		return m.Label
	}
	return ""
}

func (m *RoleSingleQuery) GetIsTeam() bool {
	if m != nil {
		return m.IsTeam
	}
	return false
}

func (m *RoleSingleQuery) GetIsGroupRole() bool {
	if m != nil {
		return m.IsGroupRole
	}
	return false
}

func (m *RoleSingleQuery) GetIsUserRole() bool {
	if m != nil {
		return m.IsUserRole
	}
	return false
}

func (m *RoleSingleQuery) GetHasAutoApply() bool {
	if m != nil {
		return m.HasAutoApply
	}
	return false
}

func (m *RoleSingleQuery) GetNot() bool {
	if m != nil {
		return m.Not
	}
	return false
}

// *****************************************************************************
//  Messages structure
// *****************************************************************************
type CreateUserRequest struct {
	User *User `protobuf:"bytes,1,opt,name=User" json:"User,omitempty"`
}

func (m *CreateUserRequest) Reset()                    { *m = CreateUserRequest{} }
func (m *CreateUserRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateUserRequest) ProtoMessage()               {}
func (*CreateUserRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *CreateUserRequest) GetUser() *User {
	if m != nil {
		return m.User
	}
	return nil
}

type CreateUserResponse struct {
	User *User `protobuf:"bytes,1,opt,name=User" json:"User,omitempty"`
}

func (m *CreateUserResponse) Reset()                    { *m = CreateUserResponse{} }
func (m *CreateUserResponse) String() string            { return proto.CompactTextString(m) }
func (*CreateUserResponse) ProtoMessage()               {}
func (*CreateUserResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *CreateUserResponse) GetUser() *User {
	if m != nil {
		return m.User
	}
	return nil
}

type BindUserRequest struct {
	UserName string `protobuf:"bytes,1,opt,name=userName" json:"userName,omitempty"`
	Password string `protobuf:"bytes,2,opt,name=password" json:"password,omitempty"`
}

func (m *BindUserRequest) Reset()                    { *m = BindUserRequest{} }
func (m *BindUserRequest) String() string            { return proto.CompactTextString(m) }
func (*BindUserRequest) ProtoMessage()               {}
func (*BindUserRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *BindUserRequest) GetUserName() string {
	if m != nil {
		return m.UserName
	}
	return ""
}

func (m *BindUserRequest) GetPassword() string {
	if m != nil {
		return m.Password
	}
	return ""
}

type BindUserResponse struct {
	User *User `protobuf:"bytes,1,opt,name=User" json:"User,omitempty"`
}

func (m *BindUserResponse) Reset()                    { *m = BindUserResponse{} }
func (m *BindUserResponse) String() string            { return proto.CompactTextString(m) }
func (*BindUserResponse) ProtoMessage()               {}
func (*BindUserResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *BindUserResponse) GetUser() *User {
	if m != nil {
		return m.User
	}
	return nil
}

type DeleteUserRequest struct {
	Query *service.Query `protobuf:"bytes,1,opt,name=Query" json:"Query,omitempty"`
}

func (m *DeleteUserRequest) Reset()                    { *m = DeleteUserRequest{} }
func (m *DeleteUserRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteUserRequest) ProtoMessage()               {}
func (*DeleteUserRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *DeleteUserRequest) GetQuery() *service.Query {
	if m != nil {
		return m.Query
	}
	return nil
}

type DeleteUserResponse struct {
	RowsDeleted int64 `protobuf:"varint,1,opt,name=RowsDeleted" json:"RowsDeleted,omitempty"`
}

func (m *DeleteUserResponse) Reset()                    { *m = DeleteUserResponse{} }
func (m *DeleteUserResponse) String() string            { return proto.CompactTextString(m) }
func (*DeleteUserResponse) ProtoMessage()               {}
func (*DeleteUserResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *DeleteUserResponse) GetRowsDeleted() int64 {
	if m != nil {
		return m.RowsDeleted
	}
	return 0
}

type SearchUserRequest struct {
	Query *service.Query `protobuf:"bytes,1,opt,name=Query" json:"Query,omitempty"`
}

func (m *SearchUserRequest) Reset()                    { *m = SearchUserRequest{} }
func (m *SearchUserRequest) String() string            { return proto.CompactTextString(m) }
func (*SearchUserRequest) ProtoMessage()               {}
func (*SearchUserRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *SearchUserRequest) GetQuery() *service.Query {
	if m != nil {
		return m.Query
	}
	return nil
}

type SearchUserResponse struct {
	User *User `protobuf:"bytes,1,opt,name=User" json:"User,omitempty"`
}

func (m *SearchUserResponse) Reset()                    { *m = SearchUserResponse{} }
func (m *SearchUserResponse) String() string            { return proto.CompactTextString(m) }
func (*SearchUserResponse) ProtoMessage()               {}
func (*SearchUserResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *SearchUserResponse) GetUser() *User {
	if m != nil {
		return m.User
	}
	return nil
}

type CountUserResponse struct {
	Count int32 `protobuf:"varint,1,opt,name=Count" json:"Count,omitempty"`
}

func (m *CountUserResponse) Reset()                    { *m = CountUserResponse{} }
func (m *CountUserResponse) String() string            { return proto.CompactTextString(m) }
func (*CountUserResponse) ProtoMessage()               {}
func (*CountUserResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func (m *CountUserResponse) GetCount() int32 {
	if m != nil {
		return m.Count
	}
	return 0
}

// User can represent either a User or a Group
type User struct {
	// User unique identifier
	Uuid string `protobuf:"bytes,1,opt,name=Uuid" json:"Uuid,omitempty"`
	// Path to the parent group
	GroupPath string `protobuf:"bytes,2,opt,name=GroupPath" json:"GroupPath,omitempty"`
	// A free list of attributes
	Attributes map[string]string `protobuf:"bytes,3,rep,name=Attributes" json:"Attributes,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// List of roles applied to this user or group
	Roles []*Role `protobuf:"bytes,4,rep,name=Roles" json:"Roles,omitempty"`
	// User login is used to connect, field is empty for groups
	Login string `protobuf:"bytes,5,opt,name=Login" json:"Login,omitempty"`
	// Password can be passed to be updated (but never read back), field is empty for groups
	Password string `protobuf:"bytes,6,opt,name=Password" json:"Password,omitempty"`
	// OldPassword must be set when a user updates her own password
	OldPassword string `protobuf:"bytes,11,opt,name=OldPassword" json:"OldPassword,omitempty"`
	// Whether this object is a group or a user
	IsGroup bool `protobuf:"varint,7,opt,name=IsGroup" json:"IsGroup,omitempty"`
	// Label of the group, field is empty for users
	GroupLabel string `protobuf:"bytes,8,opt,name=GroupLabel" json:"GroupLabel,omitempty"`
	// Last successful connection timestamp
	LastConnected int32 `protobuf:"varint,12,opt,name=LastConnected" json:"LastConnected,omitempty"`
	// Policies securing access to this user
	Policies []*service.ResourcePolicy `protobuf:"bytes,9,rep,name=Policies" json:"Policies,omitempty"`
	// Context-resolved to quickly check if user is editable or not.
	PoliciesContextEditable bool `protobuf:"varint,10,opt,name=PoliciesContextEditable" json:"PoliciesContextEditable,omitempty"`
}

func (m *User) Reset()                    { *m = User{} }
func (m *User) String() string            { return proto.CompactTextString(m) }
func (*User) ProtoMessage()               {}
func (*User) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func (m *User) GetUuid() string {
	if m != nil {
		return m.Uuid
	}
	return ""
}

func (m *User) GetGroupPath() string {
	if m != nil {
		return m.GroupPath
	}
	return ""
}

func (m *User) GetAttributes() map[string]string {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *User) GetRoles() []*Role {
	if m != nil {
		return m.Roles
	}
	return nil
}

func (m *User) GetLogin() string {
	if m != nil {
		return m.Login
	}
	return ""
}

func (m *User) GetPassword() string {
	if m != nil {
		return m.Password
	}
	return ""
}

func (m *User) GetOldPassword() string {
	if m != nil {
		return m.OldPassword
	}
	return ""
}

func (m *User) GetIsGroup() bool {
	if m != nil {
		return m.IsGroup
	}
	return false
}

func (m *User) GetGroupLabel() string {
	if m != nil {
		return m.GroupLabel
	}
	return ""
}

func (m *User) GetLastConnected() int32 {
	if m != nil {
		return m.LastConnected
	}
	return 0
}

func (m *User) GetPolicies() []*service.ResourcePolicy {
	if m != nil {
		return m.Policies
	}
	return nil
}

func (m *User) GetPoliciesContextEditable() bool {
	if m != nil {
		return m.PoliciesContextEditable
	}
	return false
}

type UserSingleQuery struct {
	Uuid     string `protobuf:"bytes,11,opt,name=Uuid" json:"Uuid,omitempty"`
	Login    string `protobuf:"bytes,1,opt,name=Login" json:"Login,omitempty"`
	Password string `protobuf:"bytes,2,opt,name=Password" json:"Password,omitempty"`
	// Search on group path, and if so, search recursively
	GroupPath string `protobuf:"bytes,3,opt,name=GroupPath" json:"GroupPath,omitempty"`
	Recursive bool   `protobuf:"varint,4,opt,name=Recursive" json:"Recursive,omitempty"`
	// Search a specific group by path
	FullPath string `protobuf:"bytes,12,opt,name=FullPath" json:"FullPath,omitempty"`
	// Search on attribute
	AttributeName     string `protobuf:"bytes,5,opt,name=AttributeName" json:"AttributeName,omitempty"`
	AttributeValue    string `protobuf:"bytes,6,opt,name=AttributeValue" json:"AttributeValue,omitempty"`
	AttributeAnyValue bool   `protobuf:"varint,7,opt,name=AttributeAnyValue" json:"AttributeAnyValue,omitempty"`
	// Search on roles
	HasRole  string   `protobuf:"bytes,8,opt,name=HasRole" json:"HasRole,omitempty"`
	NodeType NodeType `protobuf:"varint,9,opt,name=NodeType,enum=idm.NodeType" json:"NodeType,omitempty"`
	// Shortcut for pydio:profile attribute
	HasProfile string `protobuf:"bytes,13,opt,name=HasProfile" json:"HasProfile,omitempty"`
	// Compare to last connection date, starting with > or <
	ConnectedSince string `protobuf:"bytes,14,opt,name=ConnectedSince" json:"ConnectedSince,omitempty"`
	Not            bool   `protobuf:"varint,10,opt,name=not" json:"not,omitempty"`
}

func (m *UserSingleQuery) Reset()                    { *m = UserSingleQuery{} }
func (m *UserSingleQuery) String() string            { return proto.CompactTextString(m) }
func (*UserSingleQuery) ProtoMessage()               {}
func (*UserSingleQuery) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{19} }

func (m *UserSingleQuery) GetUuid() string {
	if m != nil {
		return m.Uuid
	}
	return ""
}

func (m *UserSingleQuery) GetLogin() string {
	if m != nil {
		return m.Login
	}
	return ""
}

func (m *UserSingleQuery) GetPassword() string {
	if m != nil {
		return m.Password
	}
	return ""
}

func (m *UserSingleQuery) GetGroupPath() string {
	if m != nil {
		return m.GroupPath
	}
	return ""
}

func (m *UserSingleQuery) GetRecursive() bool {
	if m != nil {
		return m.Recursive
	}
	return false
}

func (m *UserSingleQuery) GetFullPath() string {
	if m != nil {
		return m.FullPath
	}
	return ""
}

func (m *UserSingleQuery) GetAttributeName() string {
	if m != nil {
		return m.AttributeName
	}
	return ""
}

func (m *UserSingleQuery) GetAttributeValue() string {
	if m != nil {
		return m.AttributeValue
	}
	return ""
}

func (m *UserSingleQuery) GetAttributeAnyValue() bool {
	if m != nil {
		return m.AttributeAnyValue
	}
	return false
}

func (m *UserSingleQuery) GetHasRole() string {
	if m != nil {
		return m.HasRole
	}
	return ""
}

func (m *UserSingleQuery) GetNodeType() NodeType {
	if m != nil {
		return m.NodeType
	}
	return NodeType_UNKNOWN
}

func (m *UserSingleQuery) GetHasProfile() string {
	if m != nil {
		return m.HasProfile
	}
	return ""
}

func (m *UserSingleQuery) GetConnectedSince() string {
	if m != nil {
		return m.ConnectedSince
	}
	return ""
}

func (m *UserSingleQuery) GetNot() bool {
	if m != nil {
		return m.Not
	}
	return false
}

// *****************************************************************************
//  Messages structure
// *****************************************************************************
type CreateWorkspaceRequest struct {
	Workspace *Workspace `protobuf:"bytes,1,opt,name=Workspace" json:"Workspace,omitempty"`
}

func (m *CreateWorkspaceRequest) Reset()                    { *m = CreateWorkspaceRequest{} }
func (m *CreateWorkspaceRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateWorkspaceRequest) ProtoMessage()               {}
func (*CreateWorkspaceRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{20} }

func (m *CreateWorkspaceRequest) GetWorkspace() *Workspace {
	if m != nil {
		return m.Workspace
	}
	return nil
}

type CreateWorkspaceResponse struct {
	Workspace *Workspace `protobuf:"bytes,1,opt,name=Workspace" json:"Workspace,omitempty"`
}

func (m *CreateWorkspaceResponse) Reset()                    { *m = CreateWorkspaceResponse{} }
func (m *CreateWorkspaceResponse) String() string            { return proto.CompactTextString(m) }
func (*CreateWorkspaceResponse) ProtoMessage()               {}
func (*CreateWorkspaceResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{21} }

func (m *CreateWorkspaceResponse) GetWorkspace() *Workspace {
	if m != nil {
		return m.Workspace
	}
	return nil
}

type DeleteWorkspaceRequest struct {
	Query *service.Query `protobuf:"bytes,1,opt,name=Query" json:"Query,omitempty"`
}

func (m *DeleteWorkspaceRequest) Reset()                    { *m = DeleteWorkspaceRequest{} }
func (m *DeleteWorkspaceRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteWorkspaceRequest) ProtoMessage()               {}
func (*DeleteWorkspaceRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{22} }

func (m *DeleteWorkspaceRequest) GetQuery() *service.Query {
	if m != nil {
		return m.Query
	}
	return nil
}

type DeleteWorkspaceResponse struct {
	RowsDeleted int64 `protobuf:"varint,1,opt,name=RowsDeleted" json:"RowsDeleted,omitempty"`
}

func (m *DeleteWorkspaceResponse) Reset()                    { *m = DeleteWorkspaceResponse{} }
func (m *DeleteWorkspaceResponse) String() string            { return proto.CompactTextString(m) }
func (*DeleteWorkspaceResponse) ProtoMessage()               {}
func (*DeleteWorkspaceResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{23} }

func (m *DeleteWorkspaceResponse) GetRowsDeleted() int64 {
	if m != nil {
		return m.RowsDeleted
	}
	return 0
}

type SearchWorkspaceRequest struct {
	Query *service.Query `protobuf:"bytes,1,opt,name=Query" json:"Query,omitempty"`
}

func (m *SearchWorkspaceRequest) Reset()                    { *m = SearchWorkspaceRequest{} }
func (m *SearchWorkspaceRequest) String() string            { return proto.CompactTextString(m) }
func (*SearchWorkspaceRequest) ProtoMessage()               {}
func (*SearchWorkspaceRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{24} }

func (m *SearchWorkspaceRequest) GetQuery() *service.Query {
	if m != nil {
		return m.Query
	}
	return nil
}

type SearchWorkspaceResponse struct {
	Workspace *Workspace `protobuf:"bytes,1,opt,name=Workspace" json:"Workspace,omitempty"`
}

func (m *SearchWorkspaceResponse) Reset()                    { *m = SearchWorkspaceResponse{} }
func (m *SearchWorkspaceResponse) String() string            { return proto.CompactTextString(m) }
func (*SearchWorkspaceResponse) ProtoMessage()               {}
func (*SearchWorkspaceResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{25} }

func (m *SearchWorkspaceResponse) GetWorkspace() *Workspace {
	if m != nil {
		return m.Workspace
	}
	return nil
}

// A Workspace is composed of a set of nodes UUIDs and is used to provide accesses to the tree via ACLs.
type Workspace struct {
	// Unique identifier of the workspace
	UUID string `protobuf:"bytes,1,opt,name=UUID" json:"UUID,omitempty"`
	// Label of the workspace (max length 500)
	Label string `protobuf:"bytes,2,opt,name=Label" json:"Label,omitempty"`
	// Description of the workspace (max length 1000)
	Description string `protobuf:"bytes,3,opt,name=Description" json:"Description,omitempty"`
	// Slug is an url-compatible form of the workspace label, or can be freely modified (max length 500)
	Slug string `protobuf:"bytes,4,opt,name=Slug" json:"Slug,omitempty"`
	// Scope can be ADMIN, ROOM (=CELL) or LINK
	Scope WorkspaceScope `protobuf:"varint,5,opt,name=Scope,enum=idm.WorkspaceScope" json:"Scope,omitempty"`
	// Last modification time
	LastUpdated int32 `protobuf:"varint,6,opt,name=LastUpdated" json:"LastUpdated,omitempty"`
	// Policies for securing access
	Policies []*service.ResourcePolicy `protobuf:"bytes,7,rep,name=Policies" json:"Policies,omitempty"`
	// JSON-encoded list of attributes
	Attributes string `protobuf:"bytes,8,opt,name=Attributes" json:"Attributes,omitempty"`
	// Quick list of the RootNodes uuids
	RootUUIDs []string `protobuf:"bytes,9,rep,name=RootUUIDs" json:"RootUUIDs,omitempty"`
	// List of the Root Nodes in the tree that compose this workspace
	RootNodes map[string]*tree.Node `protobuf:"bytes,11,rep,name=RootNodes" json:"RootNodes,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Context-resolved to quickly check if workspace is editable or not
	PoliciesContextEditable bool `protobuf:"varint,12,opt,name=PoliciesContextEditable" json:"PoliciesContextEditable,omitempty"`
}

func (m *Workspace) Reset()                    { *m = Workspace{} }
func (m *Workspace) String() string            { return proto.CompactTextString(m) }
func (*Workspace) ProtoMessage()               {}
func (*Workspace) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{26} }

func (m *Workspace) GetUUID() string {
	if m != nil {
		return m.UUID
	}
	return ""
}

func (m *Workspace) GetLabel() string {
	if m != nil {
		return m.Label
	}
	return ""
}

func (m *Workspace) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Workspace) GetSlug() string {
	if m != nil {
		return m.Slug
	}
	return ""
}

func (m *Workspace) GetScope() WorkspaceScope {
	if m != nil {
		return m.Scope
	}
	return WorkspaceScope_ANY
}

func (m *Workspace) GetLastUpdated() int32 {
	if m != nil {
		return m.LastUpdated
	}
	return 0
}

func (m *Workspace) GetPolicies() []*service.ResourcePolicy {
	if m != nil {
		return m.Policies
	}
	return nil
}

func (m *Workspace) GetAttributes() string {
	if m != nil {
		return m.Attributes
	}
	return ""
}

func (m *Workspace) GetRootUUIDs() []string {
	if m != nil {
		return m.RootUUIDs
	}
	return nil
}

func (m *Workspace) GetRootNodes() map[string]*tree.Node {
	if m != nil {
		return m.RootNodes
	}
	return nil
}

func (m *Workspace) GetPoliciesContextEditable() bool {
	if m != nil {
		return m.PoliciesContextEditable
	}
	return false
}

type WorkspaceSingleQuery struct {
	Uuid           string         `protobuf:"bytes,1,opt,name=uuid" json:"uuid,omitempty"`
	Label          string         `protobuf:"bytes,2,opt,name=label" json:"label,omitempty"`
	Description    string         `protobuf:"bytes,3,opt,name=description" json:"description,omitempty"`
	Slug           string         `protobuf:"bytes,4,opt,name=slug" json:"slug,omitempty"`
	Scope          WorkspaceScope `protobuf:"varint,5,opt,name=scope,enum=idm.WorkspaceScope" json:"scope,omitempty"`
	LastUpdated    string         `protobuf:"bytes,7,opt,name=LastUpdated" json:"LastUpdated,omitempty"`
	HasAttribute   string         `protobuf:"bytes,8,opt,name=HasAttribute" json:"HasAttribute,omitempty"`
	AttributeName  string         `protobuf:"bytes,9,opt,name=AttributeName" json:"AttributeName,omitempty"`
	AttributeValue string         `protobuf:"bytes,10,opt,name=AttributeValue" json:"AttributeValue,omitempty"`
	Not            bool           `protobuf:"varint,6,opt,name=not" json:"not,omitempty"`
}

func (m *WorkspaceSingleQuery) Reset()                    { *m = WorkspaceSingleQuery{} }
func (m *WorkspaceSingleQuery) String() string            { return proto.CompactTextString(m) }
func (*WorkspaceSingleQuery) ProtoMessage()               {}
func (*WorkspaceSingleQuery) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{27} }

func (m *WorkspaceSingleQuery) GetUuid() string {
	if m != nil {
		return m.Uuid
	}
	return ""
}

func (m *WorkspaceSingleQuery) GetLabel() string {
	if m != nil {
		return m.Label
	}
	return ""
}

func (m *WorkspaceSingleQuery) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *WorkspaceSingleQuery) GetSlug() string {
	if m != nil {
		return m.Slug
	}
	return ""
}

func (m *WorkspaceSingleQuery) GetScope() WorkspaceScope {
	if m != nil {
		return m.Scope
	}
	return WorkspaceScope_ANY
}

func (m *WorkspaceSingleQuery) GetLastUpdated() string {
	if m != nil {
		return m.LastUpdated
	}
	return ""
}

func (m *WorkspaceSingleQuery) GetHasAttribute() string {
	if m != nil {
		return m.HasAttribute
	}
	return ""
}

func (m *WorkspaceSingleQuery) GetAttributeName() string {
	if m != nil {
		return m.AttributeName
	}
	return ""
}

func (m *WorkspaceSingleQuery) GetAttributeValue() string {
	if m != nil {
		return m.AttributeValue
	}
	return ""
}

func (m *WorkspaceSingleQuery) GetNot() bool {
	if m != nil {
		return m.Not
	}
	return false
}

// *****************************************************************************
//  ACL Messages structure
// *****************************************************************************
type CreateACLRequest struct {
	ACL       *ACL  `protobuf:"bytes,1,opt,name=ACL" json:"ACL,omitempty"`
	ExpiresIn int64 `protobuf:"varint,2,opt,name=ExpiresIn" json:"ExpiresIn,omitempty"`
}

func (m *CreateACLRequest) Reset()                    { *m = CreateACLRequest{} }
func (m *CreateACLRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateACLRequest) ProtoMessage()               {}
func (*CreateACLRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{28} }

func (m *CreateACLRequest) GetACL() *ACL {
	if m != nil {
		return m.ACL
	}
	return nil
}

func (m *CreateACLRequest) GetExpiresIn() int64 {
	if m != nil {
		return m.ExpiresIn
	}
	return 0
}

type CreateACLResponse struct {
	ACL *ACL `protobuf:"bytes,1,opt,name=ACL" json:"ACL,omitempty"`
}

func (m *CreateACLResponse) Reset()                    { *m = CreateACLResponse{} }
func (m *CreateACLResponse) String() string            { return proto.CompactTextString(m) }
func (*CreateACLResponse) ProtoMessage()               {}
func (*CreateACLResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{29} }

func (m *CreateACLResponse) GetACL() *ACL {
	if m != nil {
		return m.ACL
	}
	return nil
}

type ExpireACLRequest struct {
	Query     *service.Query `protobuf:"bytes,1,opt,name=Query" json:"Query,omitempty"`
	Timestamp int64          `protobuf:"varint,2,opt,name=Timestamp" json:"Timestamp,omitempty"`
}

func (m *ExpireACLRequest) Reset()                    { *m = ExpireACLRequest{} }
func (m *ExpireACLRequest) String() string            { return proto.CompactTextString(m) }
func (*ExpireACLRequest) ProtoMessage()               {}
func (*ExpireACLRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{30} }

func (m *ExpireACLRequest) GetQuery() *service.Query {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *ExpireACLRequest) GetTimestamp() int64 {
	if m != nil {
		return m.Timestamp
	}
	return 0
}

type ExpireACLResponse struct {
	Rows int64 `protobuf:"varint,1,opt,name=Rows" json:"Rows,omitempty"`
}

func (m *ExpireACLResponse) Reset()                    { *m = ExpireACLResponse{} }
func (m *ExpireACLResponse) String() string            { return proto.CompactTextString(m) }
func (*ExpireACLResponse) ProtoMessage()               {}
func (*ExpireACLResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{31} }

func (m *ExpireACLResponse) GetRows() int64 {
	if m != nil {
		return m.Rows
	}
	return 0
}

type DeleteACLRequest struct {
	Query *service.Query `protobuf:"bytes,1,opt,name=Query" json:"Query,omitempty"`
}

func (m *DeleteACLRequest) Reset()                    { *m = DeleteACLRequest{} }
func (m *DeleteACLRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteACLRequest) ProtoMessage()               {}
func (*DeleteACLRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{32} }

func (m *DeleteACLRequest) GetQuery() *service.Query {
	if m != nil {
		return m.Query
	}
	return nil
}

type DeleteACLResponse struct {
	RowsDeleted int64 `protobuf:"varint,1,opt,name=RowsDeleted" json:"RowsDeleted,omitempty"`
}

func (m *DeleteACLResponse) Reset()                    { *m = DeleteACLResponse{} }
func (m *DeleteACLResponse) String() string            { return proto.CompactTextString(m) }
func (*DeleteACLResponse) ProtoMessage()               {}
func (*DeleteACLResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{33} }

func (m *DeleteACLResponse) GetRowsDeleted() int64 {
	if m != nil {
		return m.RowsDeleted
	}
	return 0
}

type SearchACLRequest struct {
	Query *service.Query `protobuf:"bytes,1,opt,name=Query" json:"Query,omitempty"`
}

func (m *SearchACLRequest) Reset()                    { *m = SearchACLRequest{} }
func (m *SearchACLRequest) String() string            { return proto.CompactTextString(m) }
func (*SearchACLRequest) ProtoMessage()               {}
func (*SearchACLRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{34} }

func (m *SearchACLRequest) GetQuery() *service.Query {
	if m != nil {
		return m.Query
	}
	return nil
}

type SearchACLResponse struct {
	ACL *ACL `protobuf:"bytes,1,opt,name=ACL" json:"ACL,omitempty"`
}

func (m *SearchACLResponse) Reset()                    { *m = SearchACLResponse{} }
func (m *SearchACLResponse) String() string            { return proto.CompactTextString(m) }
func (*SearchACLResponse) ProtoMessage()               {}
func (*SearchACLResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{35} }

func (m *SearchACLResponse) GetACL() *ACL {
	if m != nil {
		return m.ACL
	}
	return nil
}

type ACLAction struct {
	Name  string `protobuf:"bytes,1,opt,name=Name" json:"Name,omitempty"`
	Value string `protobuf:"bytes,2,opt,name=Value" json:"Value,omitempty"`
}

func (m *ACLAction) Reset()                    { *m = ACLAction{} }
func (m *ACLAction) String() string            { return proto.CompactTextString(m) }
func (*ACLAction) ProtoMessage()               {}
func (*ACLAction) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{36} }

func (m *ACLAction) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ACLAction) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// ACL are the basic flags that can be put anywhere in the tree to provide some specific rights to a given role.
// The context of how they apply can be fine-tuned by workspace.
type ACL struct {
	// Unique ID of this ACL
	ID string `protobuf:"bytes,1,opt,name=ID" json:"ID,omitempty"`
	// Action on which this ACL provides control
	Action *ACLAction `protobuf:"bytes,2,opt,name=Action" json:"Action,omitempty"`
	// Associated Role
	RoleID string `protobuf:"bytes,3,opt,name=RoleID" json:"RoleID,omitempty"`
	// Associated Workspace
	WorkspaceID string `protobuf:"bytes,4,opt,name=WorkspaceID" json:"WorkspaceID,omitempty"`
	// Associated Node
	NodeID string `protobuf:"bytes,5,opt,name=NodeID" json:"NodeID,omitempty"`
}

func (m *ACL) Reset()                    { *m = ACL{} }
func (m *ACL) String() string            { return proto.CompactTextString(m) }
func (*ACL) ProtoMessage()               {}
func (*ACL) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{37} }

func (m *ACL) GetID() string {
	if m != nil {
		return m.ID
	}
	return ""
}

func (m *ACL) GetAction() *ACLAction {
	if m != nil {
		return m.Action
	}
	return nil
}

func (m *ACL) GetRoleID() string {
	if m != nil {
		return m.RoleID
	}
	return ""
}

func (m *ACL) GetWorkspaceID() string {
	if m != nil {
		return m.WorkspaceID
	}
	return ""
}

func (m *ACL) GetNodeID() string {
	if m != nil {
		return m.NodeID
	}
	return ""
}

type ACLSingleQuery struct {
	Actions      []*ACLAction `protobuf:"bytes,1,rep,name=Actions" json:"Actions,omitempty"`
	RoleIDs      []string     `protobuf:"bytes,2,rep,name=RoleIDs" json:"RoleIDs,omitempty"`
	WorkspaceIDs []string     `protobuf:"bytes,3,rep,name=WorkspaceIDs" json:"WorkspaceIDs,omitempty"`
	NodeIDs      []string     `protobuf:"bytes,4,rep,name=NodeIDs" json:"NodeIDs,omitempty"`
	Not          bool         `protobuf:"varint,5,opt,name=not" json:"not,omitempty"`
}

func (m *ACLSingleQuery) Reset()                    { *m = ACLSingleQuery{} }
func (m *ACLSingleQuery) String() string            { return proto.CompactTextString(m) }
func (*ACLSingleQuery) ProtoMessage()               {}
func (*ACLSingleQuery) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{38} }

func (m *ACLSingleQuery) GetActions() []*ACLAction {
	if m != nil {
		return m.Actions
	}
	return nil
}

func (m *ACLSingleQuery) GetRoleIDs() []string {
	if m != nil {
		return m.RoleIDs
	}
	return nil
}

func (m *ACLSingleQuery) GetWorkspaceIDs() []string {
	if m != nil {
		return m.WorkspaceIDs
	}
	return nil
}

func (m *ACLSingleQuery) GetNodeIDs() []string {
	if m != nil {
		return m.NodeIDs
	}
	return nil
}

func (m *ACLSingleQuery) GetNot() bool {
	if m != nil {
		return m.Not
	}
	return false
}

// Piece of metadata attached to a node
type UserMeta struct {
	// Unique identifier of the metadata
	Uuid string `protobuf:"bytes,1,opt,name=Uuid" json:"Uuid,omitempty"`
	// Unique identifier of the node to which meta is attached
	NodeUuid string `protobuf:"bytes,2,opt,name=NodeUuid" json:"NodeUuid,omitempty"`
	// Namespace for the metadata
	Namespace string `protobuf:"bytes,3,opt,name=Namespace" json:"Namespace,omitempty"`
	// Json encoded value used to pass any type of values
	JsonValue string `protobuf:"bytes,4,opt,name=JsonValue" json:"JsonValue,omitempty"`
	// Policies for securing access
	Policies []*service.ResourcePolicy `protobuf:"bytes,5,rep,name=Policies" json:"Policies,omitempty"`
	// Context-resolved to quickly check if this meta is editable or not
	PoliciesContextEditable bool `protobuf:"varint,6,opt,name=PoliciesContextEditable" json:"PoliciesContextEditable,omitempty"`
	// Pass along resolved Node for advanced filtering
	ResolvedNode *tree.Node `protobuf:"bytes,7,opt,name=ResolvedNode" json:"ResolvedNode,omitempty"`
}

func (m *UserMeta) Reset()                    { *m = UserMeta{} }
func (m *UserMeta) String() string            { return proto.CompactTextString(m) }
func (*UserMeta) ProtoMessage()               {}
func (*UserMeta) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{39} }

func (m *UserMeta) GetUuid() string {
	if m != nil {
		return m.Uuid
	}
	return ""
}

func (m *UserMeta) GetNodeUuid() string {
	if m != nil {
		return m.NodeUuid
	}
	return ""
}

func (m *UserMeta) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *UserMeta) GetJsonValue() string {
	if m != nil {
		return m.JsonValue
	}
	return ""
}

func (m *UserMeta) GetPolicies() []*service.ResourcePolicy {
	if m != nil {
		return m.Policies
	}
	return nil
}

func (m *UserMeta) GetPoliciesContextEditable() bool {
	if m != nil {
		return m.PoliciesContextEditable
	}
	return false
}

func (m *UserMeta) GetResolvedNode() *tree.Node {
	if m != nil {
		return m.ResolvedNode
	}
	return nil
}

// Globally declared Namespace with associated policies
type UserMetaNamespace struct {
	// Namespace identifier, must be unique
	Namespace string `protobuf:"bytes,1,opt,name=Namespace" json:"Namespace,omitempty"`
	// Human-readable Label
	Label string `protobuf:"bytes,2,opt,name=Label" json:"Label,omitempty"`
	// Order is used for sorting lists of namesapces
	Order int32 `protobuf:"varint,3,opt,name=Order" json:"Order,omitempty"`
	// Whether a modification of a metadata value for this namespace should trigger an indexation by the search engine
	Indexable bool `protobuf:"varint,4,opt,name=Indexable" json:"Indexable,omitempty"`
	// Json-encoded type to provide accurate interface for edition
	JsonDefinition string `protobuf:"bytes,5,opt,name=JsonDefinition" json:"JsonDefinition,omitempty"`
	// Policies securing this namespace
	Policies []*service.ResourcePolicy `protobuf:"bytes,6,rep,name=Policies" json:"Policies,omitempty"`
	// Context-resolved to quickly check if this meta is editable or not
	PoliciesContextEditable bool `protobuf:"varint,7,opt,name=PoliciesContextEditable" json:"PoliciesContextEditable,omitempty"`
}

func (m *UserMetaNamespace) Reset()                    { *m = UserMetaNamespace{} }
func (m *UserMetaNamespace) String() string            { return proto.CompactTextString(m) }
func (*UserMetaNamespace) ProtoMessage()               {}
func (*UserMetaNamespace) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{40} }

func (m *UserMetaNamespace) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *UserMetaNamespace) GetLabel() string {
	if m != nil {
		return m.Label
	}
	return ""
}

func (m *UserMetaNamespace) GetOrder() int32 {
	if m != nil {
		return m.Order
	}
	return 0
}

func (m *UserMetaNamespace) GetIndexable() bool {
	if m != nil {
		return m.Indexable
	}
	return false
}

func (m *UserMetaNamespace) GetJsonDefinition() string {
	if m != nil {
		return m.JsonDefinition
	}
	return ""
}

func (m *UserMetaNamespace) GetPolicies() []*service.ResourcePolicy {
	if m != nil {
		return m.Policies
	}
	return nil
}

func (m *UserMetaNamespace) GetPoliciesContextEditable() bool {
	if m != nil {
		return m.PoliciesContextEditable
	}
	return false
}

// Request for modifying UserMeta
type UpdateUserMetaRequest struct {
	// Type of operation to apply (PUT / DELETE)
	Operation UpdateUserMetaRequest_UserMetaOp `protobuf:"varint,1,opt,name=Operation,enum=idm.UpdateUserMetaRequest_UserMetaOp" json:"Operation,omitempty"`
	// List of metadatas to update or delete
	MetaDatas []*UserMeta `protobuf:"bytes,3,rep,name=MetaDatas" json:"MetaDatas,omitempty"`
}

func (m *UpdateUserMetaRequest) Reset()                    { *m = UpdateUserMetaRequest{} }
func (m *UpdateUserMetaRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateUserMetaRequest) ProtoMessage()               {}
func (*UpdateUserMetaRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{41} }

func (m *UpdateUserMetaRequest) GetOperation() UpdateUserMetaRequest_UserMetaOp {
	if m != nil {
		return m.Operation
	}
	return UpdateUserMetaRequest_PUT
}

func (m *UpdateUserMetaRequest) GetMetaDatas() []*UserMeta {
	if m != nil {
		return m.MetaDatas
	}
	return nil
}

// Response of UpdateUserMeta service
type UpdateUserMetaResponse struct {
	// List of metadatas
	MetaDatas []*UserMeta `protobuf:"bytes,3,rep,name=MetaDatas" json:"MetaDatas,omitempty"`
}

func (m *UpdateUserMetaResponse) Reset()                    { *m = UpdateUserMetaResponse{} }
func (m *UpdateUserMetaResponse) String() string            { return proto.CompactTextString(m) }
func (*UpdateUserMetaResponse) ProtoMessage()               {}
func (*UpdateUserMetaResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{42} }

func (m *UpdateUserMetaResponse) GetMetaDatas() []*UserMeta {
	if m != nil {
		return m.MetaDatas
	}
	return nil
}

// Request for searching UserMeta by NodeUuid or by Namespace
type SearchUserMetaRequest struct {
	// Look for meta by their unique identifier
	MetaUuids []string `protobuf:"bytes,1,rep,name=MetaUuids" json:"MetaUuids,omitempty"`
	// Look for all meta for a list of nodes
	NodeUuids []string `protobuf:"bytes,2,rep,name=NodeUuids" json:"NodeUuids,omitempty"`
	// Filter meta by their namespace
	Namespace string `protobuf:"bytes,3,opt,name=Namespace" json:"Namespace,omitempty"`
	// Filter meta by owner (in the sense of the policies)
	ResourceSubjectOwner string `protobuf:"bytes,4,opt,name=ResourceSubjectOwner" json:"ResourceSubjectOwner,omitempty"`
	// Filter meta by policies query
	ResourceQuery *service.ResourcePolicyQuery `protobuf:"bytes,5,opt,name=ResourceQuery" json:"ResourceQuery,omitempty"`
}

func (m *SearchUserMetaRequest) Reset()                    { *m = SearchUserMetaRequest{} }
func (m *SearchUserMetaRequest) String() string            { return proto.CompactTextString(m) }
func (*SearchUserMetaRequest) ProtoMessage()               {}
func (*SearchUserMetaRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{43} }

func (m *SearchUserMetaRequest) GetMetaUuids() []string {
	if m != nil {
		return m.MetaUuids
	}
	return nil
}

func (m *SearchUserMetaRequest) GetNodeUuids() []string {
	if m != nil {
		return m.NodeUuids
	}
	return nil
}

func (m *SearchUserMetaRequest) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *SearchUserMetaRequest) GetResourceSubjectOwner() string {
	if m != nil {
		return m.ResourceSubjectOwner
	}
	return ""
}

func (m *SearchUserMetaRequest) GetResourceQuery() *service.ResourcePolicyQuery {
	if m != nil {
		return m.ResourceQuery
	}
	return nil
}

// Streamed container for the UserMeta results
type SearchUserMetaResponse struct {
	UserMeta *UserMeta `protobuf:"bytes,1,opt,name=UserMeta" json:"UserMeta,omitempty"`
}

func (m *SearchUserMetaResponse) Reset()                    { *m = SearchUserMetaResponse{} }
func (m *SearchUserMetaResponse) String() string            { return proto.CompactTextString(m) }
func (*SearchUserMetaResponse) ProtoMessage()               {}
func (*SearchUserMetaResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{44} }

func (m *SearchUserMetaResponse) GetUserMeta() *UserMeta {
	if m != nil {
		return m.UserMeta
	}
	return nil
}

// Modify UserMetaNamespaces
type UpdateUserMetaNamespaceRequest struct {
	Operation  UpdateUserMetaNamespaceRequest_UserMetaNsOp `protobuf:"varint,1,opt,name=Operation,enum=idm.UpdateUserMetaNamespaceRequest_UserMetaNsOp" json:"Operation,omitempty"`
	Namespaces []*UserMetaNamespace                        `protobuf:"bytes,2,rep,name=Namespaces" json:"Namespaces,omitempty"`
}

func (m *UpdateUserMetaNamespaceRequest) Reset()                    { *m = UpdateUserMetaNamespaceRequest{} }
func (m *UpdateUserMetaNamespaceRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateUserMetaNamespaceRequest) ProtoMessage()               {}
func (*UpdateUserMetaNamespaceRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{45} }

func (m *UpdateUserMetaNamespaceRequest) GetOperation() UpdateUserMetaNamespaceRequest_UserMetaNsOp {
	if m != nil {
		return m.Operation
	}
	return UpdateUserMetaNamespaceRequest_PUT
}

func (m *UpdateUserMetaNamespaceRequest) GetNamespaces() []*UserMetaNamespace {
	if m != nil {
		return m.Namespaces
	}
	return nil
}

// Response of the
type UpdateUserMetaNamespaceResponse struct {
	Namespaces []*UserMetaNamespace `protobuf:"bytes,1,rep,name=Namespaces" json:"Namespaces,omitempty"`
}

func (m *UpdateUserMetaNamespaceResponse) Reset()         { *m = UpdateUserMetaNamespaceResponse{} }
func (m *UpdateUserMetaNamespaceResponse) String() string { return proto.CompactTextString(m) }
func (*UpdateUserMetaNamespaceResponse) ProtoMessage()    {}
func (*UpdateUserMetaNamespaceResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{46}
}

func (m *UpdateUserMetaNamespaceResponse) GetNamespaces() []*UserMetaNamespace {
	if m != nil {
		return m.Namespaces
	}
	return nil
}

// List All MetaNamespaces
type ListUserMetaNamespaceRequest struct {
}

func (m *ListUserMetaNamespaceRequest) Reset()                    { *m = ListUserMetaNamespaceRequest{} }
func (m *ListUserMetaNamespaceRequest) String() string            { return proto.CompactTextString(m) }
func (*ListUserMetaNamespaceRequest) ProtoMessage()               {}
func (*ListUserMetaNamespaceRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{47} }

// Collection of results
type ListUserMetaNamespaceResponse struct {
	UserMetaNamespace *UserMetaNamespace `protobuf:"bytes,1,opt,name=UserMetaNamespace" json:"UserMetaNamespace,omitempty"`
}

func (m *ListUserMetaNamespaceResponse) Reset()                    { *m = ListUserMetaNamespaceResponse{} }
func (m *ListUserMetaNamespaceResponse) String() string            { return proto.CompactTextString(m) }
func (*ListUserMetaNamespaceResponse) ProtoMessage()               {}
func (*ListUserMetaNamespaceResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{48} }

func (m *ListUserMetaNamespaceResponse) GetUserMetaNamespace() *UserMetaNamespace {
	if m != nil {
		return m.UserMetaNamespace
	}
	return nil
}

// Global Event message for IDM
type ChangeEvent struct {
	JsonType      string             `protobuf:"bytes,1,opt,name=jsonType,json=@type" json:"jsonType,omitempty"`
	Type          ChangeEventType    `protobuf:"varint,2,opt,name=Type,enum=idm.ChangeEventType" json:"Type,omitempty"`
	User          *User              `protobuf:"bytes,3,opt,name=User" json:"User,omitempty"`
	Role          *Role              `protobuf:"bytes,4,opt,name=Role" json:"Role,omitempty"`
	Workspace     *Workspace         `protobuf:"bytes,5,opt,name=Workspace" json:"Workspace,omitempty"`
	Acl           *ACL               `protobuf:"bytes,6,opt,name=Acl" json:"Acl,omitempty"`
	MetaNamespace *UserMetaNamespace `protobuf:"bytes,8,opt,name=MetaNamespace" json:"MetaNamespace,omitempty"`
	Attributes    map[string]string  `protobuf:"bytes,7,rep,name=Attributes" json:"Attributes,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *ChangeEvent) Reset()                    { *m = ChangeEvent{} }
func (m *ChangeEvent) String() string            { return proto.CompactTextString(m) }
func (*ChangeEvent) ProtoMessage()               {}
func (*ChangeEvent) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{49} }

func (m *ChangeEvent) GetJsonType() string {
	if m != nil {
		return m.JsonType
	}
	return ""
}

func (m *ChangeEvent) GetType() ChangeEventType {
	if m != nil {
		return m.Type
	}
	return ChangeEventType_CREATE
}

func (m *ChangeEvent) GetUser() *User {
	if m != nil {
		return m.User
	}
	return nil
}

func (m *ChangeEvent) GetRole() *Role {
	if m != nil {
		return m.Role
	}
	return nil
}

func (m *ChangeEvent) GetWorkspace() *Workspace {
	if m != nil {
		return m.Workspace
	}
	return nil
}

func (m *ChangeEvent) GetAcl() *ACL {
	if m != nil {
		return m.Acl
	}
	return nil
}

func (m *ChangeEvent) GetMetaNamespace() *UserMetaNamespace {
	if m != nil {
		return m.MetaNamespace
	}
	return nil
}

func (m *ChangeEvent) GetAttributes() map[string]string {
	if m != nil {
		return m.Attributes
	}
	return nil
}

// ************************************
// Messages Structures
// ************************************
type PolicyEngineRequest struct {
	Resource string            `protobuf:"bytes,1,opt,name=Resource" json:"Resource,omitempty"`
	Action   string            `protobuf:"bytes,2,opt,name=Action" json:"Action,omitempty"`
	Subjects []string          `protobuf:"bytes,3,rep,name=Subjects" json:"Subjects,omitempty"`
	Context  map[string]string `protobuf:"bytes,4,rep,name=Context" json:"Context,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *PolicyEngineRequest) Reset()                    { *m = PolicyEngineRequest{} }
func (m *PolicyEngineRequest) String() string            { return proto.CompactTextString(m) }
func (*PolicyEngineRequest) ProtoMessage()               {}
func (*PolicyEngineRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{50} }

func (m *PolicyEngineRequest) GetResource() string {
	if m != nil {
		return m.Resource
	}
	return ""
}

func (m *PolicyEngineRequest) GetAction() string {
	if m != nil {
		return m.Action
	}
	return ""
}

func (m *PolicyEngineRequest) GetSubjects() []string {
	if m != nil {
		return m.Subjects
	}
	return nil
}

func (m *PolicyEngineRequest) GetContext() map[string]string {
	if m != nil {
		return m.Context
	}
	return nil
}

type PolicyEngineResponse struct {
	Allowed      bool `protobuf:"varint,1,opt,name=Allowed" json:"Allowed,omitempty"`
	ExplicitDeny bool `protobuf:"varint,2,opt,name=ExplicitDeny" json:"ExplicitDeny,omitempty"`
	DefaultDeny  bool `protobuf:"varint,3,opt,name=DefaultDeny" json:"DefaultDeny,omitempty"`
}

func (m *PolicyEngineResponse) Reset()                    { *m = PolicyEngineResponse{} }
func (m *PolicyEngineResponse) String() string            { return proto.CompactTextString(m) }
func (*PolicyEngineResponse) ProtoMessage()               {}
func (*PolicyEngineResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{51} }

func (m *PolicyEngineResponse) GetAllowed() bool {
	if m != nil {
		return m.Allowed
	}
	return false
}

func (m *PolicyEngineResponse) GetExplicitDeny() bool {
	if m != nil {
		return m.ExplicitDeny
	}
	return false
}

func (m *PolicyEngineResponse) GetDefaultDeny() bool {
	if m != nil {
		return m.DefaultDeny
	}
	return false
}

type PolicyCondition struct {
	Type        string `protobuf:"bytes,1,opt,name=type" json:"type,omitempty"`
	JsonOptions string `protobuf:"bytes,2,opt,name=jsonOptions" json:"jsonOptions,omitempty"`
}

func (m *PolicyCondition) Reset()                    { *m = PolicyCondition{} }
func (m *PolicyCondition) String() string            { return proto.CompactTextString(m) }
func (*PolicyCondition) ProtoMessage()               {}
func (*PolicyCondition) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{52} }

func (m *PolicyCondition) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *PolicyCondition) GetJsonOptions() string {
	if m != nil {
		return m.JsonOptions
	}
	return ""
}

type Policy struct {
	Id          string                      `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Description string                      `protobuf:"bytes,2,opt,name=description" json:"description,omitempty"`
	Subjects    []string                    `protobuf:"bytes,3,rep,name=subjects" json:"subjects,omitempty"`
	Resources   []string                    `protobuf:"bytes,4,rep,name=resources" json:"resources,omitempty"`
	Actions     []string                    `protobuf:"bytes,5,rep,name=actions" json:"actions,omitempty"`
	Effect      PolicyEffect                `protobuf:"varint,6,opt,name=effect,enum=idm.PolicyEffect" json:"effect,omitempty"`
	Conditions  map[string]*PolicyCondition `protobuf:"bytes,7,rep,name=conditions" json:"conditions,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *Policy) Reset()                    { *m = Policy{} }
func (m *Policy) String() string            { return proto.CompactTextString(m) }
func (*Policy) ProtoMessage()               {}
func (*Policy) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{53} }

func (m *Policy) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Policy) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Policy) GetSubjects() []string {
	if m != nil {
		return m.Subjects
	}
	return nil
}

func (m *Policy) GetResources() []string {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *Policy) GetActions() []string {
	if m != nil {
		return m.Actions
	}
	return nil
}

func (m *Policy) GetEffect() PolicyEffect {
	if m != nil {
		return m.Effect
	}
	return PolicyEffect_unknown
}

func (m *Policy) GetConditions() map[string]*PolicyCondition {
	if m != nil {
		return m.Conditions
	}
	return nil
}

type PolicyGroup struct {
	Uuid          string              `protobuf:"bytes,1,opt,name=Uuid" json:"Uuid,omitempty"`
	Name          string              `protobuf:"bytes,2,opt,name=Name" json:"Name,omitempty"`
	Description   string              `protobuf:"bytes,3,opt,name=Description" json:"Description,omitempty"`
	OwnerUuid     string              `protobuf:"bytes,4,opt,name=OwnerUuid" json:"OwnerUuid,omitempty"`
	ResourceGroup PolicyResourceGroup `protobuf:"varint,5,opt,name=ResourceGroup,enum=idm.PolicyResourceGroup" json:"ResourceGroup,omitempty"`
	LastUpdated   int32               `protobuf:"varint,6,opt,name=LastUpdated" json:"LastUpdated,omitempty"`
	Policies      []*Policy           `protobuf:"bytes,7,rep,name=Policies" json:"Policies,omitempty"`
}

func (m *PolicyGroup) Reset()                    { *m = PolicyGroup{} }
func (m *PolicyGroup) String() string            { return proto.CompactTextString(m) }
func (*PolicyGroup) ProtoMessage()               {}
func (*PolicyGroup) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{54} }

func (m *PolicyGroup) GetUuid() string {
	if m != nil {
		return m.Uuid
	}
	return ""
}

func (m *PolicyGroup) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *PolicyGroup) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *PolicyGroup) GetOwnerUuid() string {
	if m != nil {
		return m.OwnerUuid
	}
	return ""
}

func (m *PolicyGroup) GetResourceGroup() PolicyResourceGroup {
	if m != nil {
		return m.ResourceGroup
	}
	return PolicyResourceGroup_rest
}

func (m *PolicyGroup) GetLastUpdated() int32 {
	if m != nil {
		return m.LastUpdated
	}
	return 0
}

func (m *PolicyGroup) GetPolicies() []*Policy {
	if m != nil {
		return m.Policies
	}
	return nil
}

// Request / Response Messages
type StorePolicyGroupRequest struct {
	PolicyGroup *PolicyGroup `protobuf:"bytes,1,opt,name=PolicyGroup" json:"PolicyGroup,omitempty"`
}

func (m *StorePolicyGroupRequest) Reset()                    { *m = StorePolicyGroupRequest{} }
func (m *StorePolicyGroupRequest) String() string            { return proto.CompactTextString(m) }
func (*StorePolicyGroupRequest) ProtoMessage()               {}
func (*StorePolicyGroupRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{55} }

func (m *StorePolicyGroupRequest) GetPolicyGroup() *PolicyGroup {
	if m != nil {
		return m.PolicyGroup
	}
	return nil
}

type StorePolicyGroupResponse struct {
	PolicyGroup *PolicyGroup `protobuf:"bytes,1,opt,name=PolicyGroup" json:"PolicyGroup,omitempty"`
}

func (m *StorePolicyGroupResponse) Reset()                    { *m = StorePolicyGroupResponse{} }
func (m *StorePolicyGroupResponse) String() string            { return proto.CompactTextString(m) }
func (*StorePolicyGroupResponse) ProtoMessage()               {}
func (*StorePolicyGroupResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{56} }

func (m *StorePolicyGroupResponse) GetPolicyGroup() *PolicyGroup {
	if m != nil {
		return m.PolicyGroup
	}
	return nil
}

type DeletePolicyGroupRequest struct {
	PolicyGroup *PolicyGroup `protobuf:"bytes,1,opt,name=PolicyGroup" json:"PolicyGroup,omitempty"`
}

func (m *DeletePolicyGroupRequest) Reset()                    { *m = DeletePolicyGroupRequest{} }
func (m *DeletePolicyGroupRequest) String() string            { return proto.CompactTextString(m) }
func (*DeletePolicyGroupRequest) ProtoMessage()               {}
func (*DeletePolicyGroupRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{57} }

func (m *DeletePolicyGroupRequest) GetPolicyGroup() *PolicyGroup {
	if m != nil {
		return m.PolicyGroup
	}
	return nil
}

type DeletePolicyGroupResponse struct {
	Success bool `protobuf:"varint,1,opt,name=Success" json:"Success,omitempty"`
}

func (m *DeletePolicyGroupResponse) Reset()                    { *m = DeletePolicyGroupResponse{} }
func (m *DeletePolicyGroupResponse) String() string            { return proto.CompactTextString(m) }
func (*DeletePolicyGroupResponse) ProtoMessage()               {}
func (*DeletePolicyGroupResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{58} }

func (m *DeletePolicyGroupResponse) GetSuccess() bool {
	if m != nil {
		return m.Success
	}
	return false
}

type ListPolicyGroupsRequest struct {
}

func (m *ListPolicyGroupsRequest) Reset()                    { *m = ListPolicyGroupsRequest{} }
func (m *ListPolicyGroupsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListPolicyGroupsRequest) ProtoMessage()               {}
func (*ListPolicyGroupsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{59} }

type ListPolicyGroupsResponse struct {
	PolicyGroups []*PolicyGroup `protobuf:"bytes,1,rep,name=PolicyGroups" json:"PolicyGroups,omitempty"`
	Total        int32          `protobuf:"varint,2,opt,name=Total" json:"Total,omitempty"`
}

func (m *ListPolicyGroupsResponse) Reset()                    { *m = ListPolicyGroupsResponse{} }
func (m *ListPolicyGroupsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListPolicyGroupsResponse) ProtoMessage()               {}
func (*ListPolicyGroupsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{60} }

func (m *ListPolicyGroupsResponse) GetPolicyGroups() []*PolicyGroup {
	if m != nil {
		return m.PolicyGroups
	}
	return nil
}

func (m *ListPolicyGroupsResponse) GetTotal() int32 {
	if m != nil {
		return m.Total
	}
	return 0
}

func init() {
	proto.RegisterType((*CreateRoleRequest)(nil), "idm.CreateRoleRequest")
	proto.RegisterType((*CreateRoleResponse)(nil), "idm.CreateRoleResponse")
	proto.RegisterType((*DeleteRoleRequest)(nil), "idm.DeleteRoleRequest")
	proto.RegisterType((*DeleteRoleResponse)(nil), "idm.DeleteRoleResponse")
	proto.RegisterType((*SearchRoleRequest)(nil), "idm.SearchRoleRequest")
	proto.RegisterType((*SearchRoleResponse)(nil), "idm.SearchRoleResponse")
	proto.RegisterType((*CountRoleResponse)(nil), "idm.CountRoleResponse")
	proto.RegisterType((*Role)(nil), "idm.Role")
	proto.RegisterType((*RoleSingleQuery)(nil), "idm.RoleSingleQuery")
	proto.RegisterType((*CreateUserRequest)(nil), "idm.CreateUserRequest")
	proto.RegisterType((*CreateUserResponse)(nil), "idm.CreateUserResponse")
	proto.RegisterType((*BindUserRequest)(nil), "idm.BindUserRequest")
	proto.RegisterType((*BindUserResponse)(nil), "idm.BindUserResponse")
	proto.RegisterType((*DeleteUserRequest)(nil), "idm.DeleteUserRequest")
	proto.RegisterType((*DeleteUserResponse)(nil), "idm.DeleteUserResponse")
	proto.RegisterType((*SearchUserRequest)(nil), "idm.SearchUserRequest")
	proto.RegisterType((*SearchUserResponse)(nil), "idm.SearchUserResponse")
	proto.RegisterType((*CountUserResponse)(nil), "idm.CountUserResponse")
	proto.RegisterType((*User)(nil), "idm.User")
	proto.RegisterType((*UserSingleQuery)(nil), "idm.UserSingleQuery")
	proto.RegisterType((*CreateWorkspaceRequest)(nil), "idm.CreateWorkspaceRequest")
	proto.RegisterType((*CreateWorkspaceResponse)(nil), "idm.CreateWorkspaceResponse")
	proto.RegisterType((*DeleteWorkspaceRequest)(nil), "idm.DeleteWorkspaceRequest")
	proto.RegisterType((*DeleteWorkspaceResponse)(nil), "idm.DeleteWorkspaceResponse")
	proto.RegisterType((*SearchWorkspaceRequest)(nil), "idm.SearchWorkspaceRequest")
	proto.RegisterType((*SearchWorkspaceResponse)(nil), "idm.SearchWorkspaceResponse")
	proto.RegisterType((*Workspace)(nil), "idm.Workspace")
	proto.RegisterType((*WorkspaceSingleQuery)(nil), "idm.WorkspaceSingleQuery")
	proto.RegisterType((*CreateACLRequest)(nil), "idm.CreateACLRequest")
	proto.RegisterType((*CreateACLResponse)(nil), "idm.CreateACLResponse")
	proto.RegisterType((*ExpireACLRequest)(nil), "idm.ExpireACLRequest")
	proto.RegisterType((*ExpireACLResponse)(nil), "idm.ExpireACLResponse")
	proto.RegisterType((*DeleteACLRequest)(nil), "idm.DeleteACLRequest")
	proto.RegisterType((*DeleteACLResponse)(nil), "idm.DeleteACLResponse")
	proto.RegisterType((*SearchACLRequest)(nil), "idm.SearchACLRequest")
	proto.RegisterType((*SearchACLResponse)(nil), "idm.SearchACLResponse")
	proto.RegisterType((*ACLAction)(nil), "idm.ACLAction")
	proto.RegisterType((*ACL)(nil), "idm.ACL")
	proto.RegisterType((*ACLSingleQuery)(nil), "idm.ACLSingleQuery")
	proto.RegisterType((*UserMeta)(nil), "idm.UserMeta")
	proto.RegisterType((*UserMetaNamespace)(nil), "idm.UserMetaNamespace")
	proto.RegisterType((*UpdateUserMetaRequest)(nil), "idm.UpdateUserMetaRequest")
	proto.RegisterType((*UpdateUserMetaResponse)(nil), "idm.UpdateUserMetaResponse")
	proto.RegisterType((*SearchUserMetaRequest)(nil), "idm.SearchUserMetaRequest")
	proto.RegisterType((*SearchUserMetaResponse)(nil), "idm.SearchUserMetaResponse")
	proto.RegisterType((*UpdateUserMetaNamespaceRequest)(nil), "idm.UpdateUserMetaNamespaceRequest")
	proto.RegisterType((*UpdateUserMetaNamespaceResponse)(nil), "idm.UpdateUserMetaNamespaceResponse")
	proto.RegisterType((*ListUserMetaNamespaceRequest)(nil), "idm.ListUserMetaNamespaceRequest")
	proto.RegisterType((*ListUserMetaNamespaceResponse)(nil), "idm.ListUserMetaNamespaceResponse")
	proto.RegisterType((*ChangeEvent)(nil), "idm.ChangeEvent")
	proto.RegisterType((*PolicyEngineRequest)(nil), "idm.PolicyEngineRequest")
	proto.RegisterType((*PolicyEngineResponse)(nil), "idm.PolicyEngineResponse")
	proto.RegisterType((*PolicyCondition)(nil), "idm.PolicyCondition")
	proto.RegisterType((*Policy)(nil), "idm.Policy")
	proto.RegisterType((*PolicyGroup)(nil), "idm.PolicyGroup")
	proto.RegisterType((*StorePolicyGroupRequest)(nil), "idm.StorePolicyGroupRequest")
	proto.RegisterType((*StorePolicyGroupResponse)(nil), "idm.StorePolicyGroupResponse")
	proto.RegisterType((*DeletePolicyGroupRequest)(nil), "idm.DeletePolicyGroupRequest")
	proto.RegisterType((*DeletePolicyGroupResponse)(nil), "idm.DeletePolicyGroupResponse")
	proto.RegisterType((*ListPolicyGroupsRequest)(nil), "idm.ListPolicyGroupsRequest")
	proto.RegisterType((*ListPolicyGroupsResponse)(nil), "idm.ListPolicyGroupsResponse")
	proto.RegisterEnum("idm.NodeType", NodeType_name, NodeType_value)
	proto.RegisterEnum("idm.WorkspaceScope", WorkspaceScope_name, WorkspaceScope_value)
	proto.RegisterEnum("idm.ChangeEventType", ChangeEventType_name, ChangeEventType_value)
	proto.RegisterEnum("idm.PolicyEffect", PolicyEffect_name, PolicyEffect_value)
	proto.RegisterEnum("idm.PolicyResourceGroup", PolicyResourceGroup_name, PolicyResourceGroup_value)
	proto.RegisterEnum("idm.UpdateUserMetaRequest_UserMetaOp", UpdateUserMetaRequest_UserMetaOp_name, UpdateUserMetaRequest_UserMetaOp_value)
	proto.RegisterEnum("idm.UpdateUserMetaNamespaceRequest_UserMetaNsOp", UpdateUserMetaNamespaceRequest_UserMetaNsOp_name, UpdateUserMetaNamespaceRequest_UserMetaNsOp_value)
}

func init() { proto.RegisterFile("idm.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 3022 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x5a, 0xcf, 0x6f, 0x1b, 0xc7,
	0xf5, 0x17, 0x97, 0xa2, 0x48, 0x3e, 0xca, 0x14, 0x35, 0x91, 0x25, 0x9a, 0x96, 0x1d, 0x65, 0x93,
	0x6f, 0x22, 0xfb, 0x9b, 0x48, 0x2e, 0xdd, 0x04, 0xce, 0x2f, 0x27, 0x34, 0xc9, 0xc8, 0xac, 0x69,
	0x52, 0x59, 0x49, 0x0e, 0x72, 0x5c, 0x91, 0x23, 0x79, 0x63, 0x6a, 0x97, 0xdd, 0x5d, 0x4a, 0xd6,
	0xad, 0xb7, 0x1e, 0x8b, 0x16, 0x28, 0xfa, 0x0f, 0xf4, 0xd8, 0xff, 0xa3, 0x45, 0x83, 0x1e, 0x5b,
	0x14, 0xe8, 0xa1, 0x40, 0x4e, 0xed, 0xbd, 0x28, 0xd0, 0x5b, 0x31, 0x3f, 0x77, 0x66, 0x77, 0x49,
	0x4b, 0xaa, 0x2f, 0xc4, 0xce, 0x7b, 0xf3, 0xde, 0xcc, 0xbc, 0x79, 0xef, 0x33, 0xef, 0xcd, 0x10,
	0x8a, 0xce, 0xf0, 0x64, 0x6b, 0xec, 0x7b, 0xa1, 0x87, 0xb2, 0xce, 0xf0, 0xa4, 0xf6, 0xe0, 0xd8,
	0x09, 0x9f, 0x4f, 0x0e, 0xb7, 0x06, 0xde, 0xc9, 0xf6, 0xf8, 0x7c, 0xe8, 0x78, 0xdb, 0x03, 0x3c,
	0x1a, 0x05, 0xdb, 0x03, 0xef, 0xe4, 0xc4, 0x73, 0xb7, 0x03, 0xec, 0x9f, 0x3a, 0x03, 0xbc, 0x4d,
	0x25, 0x38, 0x91, 0x89, 0xd7, 0xee, 0xcf, 0x96, 0x64, 0x12, 0xa1, 0x8f, 0x31, 0xfd, 0xe1, 0x42,
	0x1f, 0x29, 0x42, 0x27, 0x67, 0x4e, 0xf8, 0xc2, 0x3b, 0xdb, 0x3e, 0xf6, 0x3e, 0xa0, 0xcc, 0x0f,
	0x4e, 0xed, 0x91, 0x33, 0xb4, 0x43, 0xcf, 0x0f, 0xb6, 0xe5, 0x27, 0x93, 0x33, 0xeb, 0xb0, 0xdc,
	0xf4, 0xb1, 0x1d, 0x62, 0xcb, 0x1b, 0x61, 0x0b, 0xff, 0x74, 0x82, 0x83, 0x10, 0xdd, 0x82, 0x79,
	0xd2, 0xac, 0x66, 0x36, 0x32, 0x9b, 0xa5, 0x7a, 0x71, 0x8b, 0x2c, 0x8d, 0xf2, 0x29, 0xd9, 0xbc,
	0x0f, 0x48, 0x95, 0x09, 0xc6, 0x9e, 0x1b, 0xe0, 0x57, 0x09, 0x7d, 0x0c, 0xcb, 0x2d, 0x3c, 0xc2,
	0xfa, 0x40, 0xef, 0x40, 0xee, 0xeb, 0x09, 0xf6, 0xcf, 0xb9, 0x50, 0x79, 0x8b, 0x9b, 0x65, 0x8b,
	0x52, 0x2d, 0xc6, 0x34, 0x3f, 0x02, 0xa4, 0x8a, 0xf2, 0xf1, 0x36, 0xa0, 0x64, 0x79, 0x67, 0x01,
	0xe3, 0x0c, 0xa9, 0x86, 0xac, 0xa5, 0x92, 0xc8, 0x90, 0x7b, 0xd8, 0xf6, 0x07, 0xcf, 0x2f, 0x3f,
	0xe4, 0x7d, 0x40, 0xaa, 0xe8, 0xc5, 0x96, 0x78, 0x07, 0x96, 0x9b, 0xde, 0xc4, 0x0d, 0x35, 0x99,
	0x15, 0xc8, 0x51, 0x22, 0x15, 0xca, 0x59, 0xac, 0x61, 0xfe, 0xcd, 0x60, 0xaa, 0x10, 0x82, 0xf9,
	0x83, 0x89, 0xc3, 0xa6, 0x5f, 0xb4, 0xe8, 0x37, 0x11, 0xe9, 0xda, 0x87, 0x78, 0x54, 0x35, 0x28,
	0x91, 0x35, 0xd0, 0x2a, 0x2c, 0x74, 0x82, 0x7d, 0x6c, 0x9f, 0x54, 0xb3, 0x1b, 0x99, 0xcd, 0x82,
	0xc5, 0x5b, 0x68, 0x1d, 0x8a, 0x3b, 0xbe, 0x37, 0x19, 0xd3, 0x99, 0xcd, 0x53, 0x56, 0x44, 0x40,
	0x35, 0x28, 0x1c, 0x04, 0xd8, 0xa7, 0xcc, 0x1c, 0x65, 0xca, 0x36, 0xb1, 0x60, 0xd7, 0x0e, 0xc2,
	0x83, 0xf1, 0xd0, 0x26, 0x16, 0x5c, 0xa0, 0x13, 0x54, 0x49, 0xa4, 0x47, 0x63, 0x12, 0x7a, 0x8d,
	0xf1, 0x78, 0xe4, 0xe0, 0xa0, 0x9a, 0xdf, 0xc8, 0x6e, 0x16, 0x2d, 0x95, 0x84, 0xee, 0x43, 0x61,
	0xd7, 0x1b, 0x39, 0x03, 0xc2, 0x2e, 0x6c, 0x64, 0x37, 0x4b, 0xf5, 0x35, 0x69, 0x51, 0x0b, 0x07,
	0xde, 0xc4, 0x1f, 0x60, 0xda, 0xe1, 0xdc, 0x92, 0x1d, 0xd1, 0x03, 0x58, 0x13, 0xdf, 0x4d, 0xcf,
	0x0d, 0xf1, 0xcb, 0xb0, 0x3d, 0x74, 0x42, 0xfb, 0x70, 0x84, 0xab, 0x45, 0x3a, 0xc7, 0x69, 0x6c,
	0xf4, 0x0e, 0x5c, 0xfb, 0xca, 0xf3, 0x07, 0xb8, 0x7f, 0x8a, 0x7d, 0xdf, 0x19, 0xe2, 0x2a, 0xd0,
	0xfe, 0x3a, 0xd1, 0xfc, 0x3e, 0x03, 0x4b, 0x64, 0x85, 0x7b, 0x8e, 0x7b, 0x3c, 0xc2, 0x74, 0x47,
	0x15, 0x43, 0x67, 0xaf, 0x68, 0xe8, 0x0d, 0x28, 0x75, 0x82, 0xb8, 0xa9, 0x55, 0x12, 0xba, 0x0d,
	0xd0, 0x09, 0x62, 0xe6, 0x56, 0x28, 0xc8, 0x84, 0xc5, 0xc7, 0x76, 0x20, 0xcc, 0x77, 0x4e, 0x2d,
	0x5e, 0xb0, 0x34, 0x1a, 0xaa, 0x40, 0xd6, 0xf5, 0xc2, 0x6a, 0x9e, 0xb2, 0xc8, 0x67, 0x14, 0xa2,
	0x54, 0x4f, 0x14, 0xa2, 0xa4, 0xa9, 0xb9, 0x22, 0xe5, 0x53, 0x72, 0x14, 0xa2, 0x4c, 0x26, 0xf2,
	0xdf, 0x59, 0x42, 0x1d, 0x58, 0x7a, 0xe4, 0xb8, 0x43, 0x75, 0x98, 0x1a, 0x14, 0x26, 0x01, 0xf6,
	0x7b, 0xf6, 0x09, 0xe6, 0x2e, 0x2a, 0xdb, 0x84, 0x37, 0xb6, 0x83, 0xe0, 0xcc, 0xf3, 0x87, 0xdc,
	0x80, 0xb2, 0x6d, 0xfe, 0x08, 0x2a, 0x91, 0xaa, 0x8b, 0x8d, 0x2e, 0x01, 0x42, 0x1d, 0xff, 0x92,
	0x00, 0xa1, 0x8d, 0x77, 0x09, 0x80, 0xb8, 0xfc, 0x90, 0x12, 0x20, 0x2e, 0xb3, 0x44, 0x01, 0x10,
	0x9a, 0x4c, 0x3a, 0x40, 0xfc, 0x3b, 0xcb, 0x54, 0xa5, 0x02, 0x84, 0x08, 0xf9, 0x5d, 0x3b, 0x7c,
	0xce, 0x4d, 0x1f, 0x11, 0xd0, 0xc7, 0x00, 0x8d, 0x30, 0xf4, 0x9d, 0xc3, 0x49, 0x88, 0x83, 0x6a,
	0x96, 0x06, 0xe5, 0x0d, 0x39, 0x95, 0xad, 0x88, 0xd7, 0x76, 0x43, 0xff, 0xdc, 0x52, 0x3a, 0xa3,
	0x37, 0x21, 0x47, 0x1c, 0x35, 0xa8, 0xce, 0x53, 0x29, 0x05, 0xe1, 0x18, 0x9d, 0x46, 0x8c, 0x77,
	0xec, 0xb8, 0xd4, 0xb9, 0x49, 0xc4, 0x90, 0x06, 0xf1, 0x84, 0x5d, 0xe1, 0x09, 0x0b, 0xcc, 0x13,
	0x44, 0x9b, 0xec, 0x42, 0x7f, 0x34, 0x94, 0xec, 0x12, 0x65, 0xab, 0x24, 0x54, 0x85, 0x3c, 0x0f,
	0x22, 0xee, 0xf5, 0xa2, 0x49, 0xe2, 0x89, 0x7e, 0xb0, 0x20, 0x2d, 0x50, 0x51, 0x85, 0x42, 0xd0,
	0x80, 0xa0, 0x55, 0xd3, 0x73, 0x5d, 0x3c, 0x20, 0x7b, 0xbc, 0x48, 0x4d, 0xa8, 0x13, 0x35, 0x88,
	0x2a, 0xbe, 0x06, 0x88, 0x82, 0x99, 0x10, 0x55, 0xfb, 0x1c, 0x96, 0x62, 0x26, 0x26, 0x31, 0xfd,
	0x02, 0x9f, 0xf3, 0x2d, 0x24, 0x9f, 0xc4, 0x8e, 0xa7, 0xf6, 0x68, 0x82, 0x05, 0xf2, 0xd0, 0xc6,
	0x27, 0xc6, 0x83, 0x8c, 0xf9, 0xc7, 0x2c, 0x2c, 0x91, 0x7d, 0x4a, 0xc3, 0xae, 0x52, 0xec, 0x90,
	0xa0, 0x3b, 0x91, 0x99, 0xb6, 0x13, 0x46, 0x6c, 0x27, 0x34, 0xaf, 0xc9, 0xc6, 0xbd, 0x66, 0x1d,
	0x8a, 0x16, 0x1e, 0x4c, 0xfc, 0xc0, 0x39, 0x95, 0xc7, 0x88, 0x24, 0x10, 0xbd, 0x5f, 0x4d, 0x46,
	0x23, 0x2a, 0xba, 0xc8, 0xf4, 0x8a, 0x36, 0xd9, 0x05, 0xb9, 0x60, 0x0a, 0x14, 0xcc, 0x37, 0x74,
	0x22, 0x7a, 0x17, 0xca, 0x92, 0xf0, 0x8c, 0x2e, 0x9d, 0x79, 0x4a, 0x8c, 0x8a, 0xde, 0x87, 0x65,
	0x49, 0x69, 0xb8, 0xe7, 0xac, 0x2b, 0xf3, 0x8b, 0x24, 0x83, 0xf8, 0xce, 0x63, 0x3b, 0xa0, 0x70,
	0xcb, 0xdc, 0x43, 0x34, 0xd1, 0x1d, 0x28, 0xf4, 0xbc, 0x21, 0xde, 0x3f, 0x1f, 0xb3, 0x43, 0xa5,
	0x5c, 0xbf, 0x46, 0xbd, 0x59, 0x10, 0x2d, 0xc9, 0x26, 0x6e, 0xf6, 0xd8, 0x0e, 0x76, 0x7d, 0xef,
	0xc8, 0x19, 0xe1, 0xea, 0x35, 0xe6, 0x66, 0x11, 0x85, 0x4c, 0x5d, 0x7a, 0xd3, 0x9e, 0xe3, 0x0e,
	0x70, 0xb5, 0xcc, 0xa6, 0xae, 0x53, 0x05, 0x74, 0x43, 0x04, 0xdd, 0x5f, 0xc1, 0x2a, 0x83, 0xe1,
	0x6f, 0x3c, 0xff, 0x45, 0x30, 0xb6, 0x07, 0x32, 0x0d, 0x79, 0x1f, 0x8a, 0x92, 0x26, 0x91, 0x86,
	0xcc, 0x2f, 0xea, 0x19, 0x75, 0x30, 0x77, 0x60, 0x2d, 0xa1, 0x87, 0xc3, 0xc7, 0xe5, 0x14, 0x3d,
	0x84, 0x55, 0x06, 0x7e, 0x89, 0x09, 0x5d, 0x0c, 0xf6, 0x3e, 0x85, 0xb5, 0x84, 0xfc, 0x85, 0xe1,
	0xf6, 0x21, 0xac, 0x32, 0xcc, 0xbc, 0xe2, 0xe0, 0x3b, 0xb0, 0x96, 0x90, 0xbf, 0x92, 0x15, 0x7e,
	0x3e, 0xaf, 0x74, 0xa7, 0xd1, 0x75, 0xd0, 0x69, 0x49, 0x84, 0x3d, 0xe8, 0xb4, 0xd0, 0x2d, 0x2d,
	0x33, 0x78, 0x94, 0xff, 0xe1, 0xef, 0x6f, 0x66, 0x5f, 0xfe, 0x2b, 0x2b, 0x52, 0x84, 0x3b, 0x50,
	0x6a, 0xe1, 0x60, 0xe0, 0x3b, 0xe3, 0xd0, 0xf1, 0x5c, 0x16, 0x4c, 0xbc, 0xd3, 0x3f, 0xf2, 0x96,
	0xca, 0x43, 0x37, 0x61, 0x7e, 0x6f, 0x34, 0x39, 0xa6, 0x21, 0xa5, 0x28, 0xa2, 0x44, 0x74, 0x07,
	0x72, 0x7b, 0x03, 0x6f, 0xcc, 0x42, 0xa6, 0x5c, 0x7f, 0x43, 0x9f, 0x32, 0x65, 0x59, 0xac, 0xc7,
	0x05, 0x92, 0x35, 0x15, 0xe7, 0xf2, 0x17, 0xc5, 0xb9, 0xdb, 0xda, 0x61, 0xc1, 0x21, 0x56, 0x39,
	0x11, 0x08, 0x2c, 0x78, 0x5e, 0x48, 0x8c, 0xc2, 0xd0, 0xb3, 0x68, 0x45, 0x04, 0xf4, 0x29, 0xe3,
	0x92, 0x48, 0x0a, 0xaa, 0x25, 0x3a, 0xe6, 0x2d, 0x7d, 0x0d, 0x5b, 0x92, 0xcf, 0x4e, 0x9b, 0xa8,
	0xff, 0x2c, 0x88, 0x5d, 0x9c, 0x0d, 0xb1, 0x8f, 0xa1, 0xac, 0xab, 0x4d, 0x41, 0xd8, 0x0d, 0x15,
	0x61, 0x4b, 0x75, 0xd8, 0xa2, 0xc5, 0x12, 0x11, 0x51, 0xd1, 0xf6, 0xf7, 0x06, 0xac, 0x44, 0xf6,
	0xd6, 0x21, 0x77, 0xa2, 0x1c, 0xbb, 0x13, 0x0e, 0xb9, 0x23, 0x35, 0x5d, 0xa4, 0x0d, 0xb2, 0x31,
	0xc3, 0xb8, 0x2f, 0x58, 0x2a, 0x89, 0xe8, 0x0a, 0xa4, 0x0b, 0x58, 0xf4, 0x9b, 0xec, 0x7c, 0xf0,
	0xca, 0x9d, 0x0f, 0xd2, 0x76, 0x3e, 0xcf, 0x06, 0x50, 0x77, 0x9e, 0xe7, 0x95, 0x62, 0xd7, 0xf8,
	0x36, 0x6a, 0xb4, 0x24, 0x4a, 0x17, 0x2f, 0x86, 0xd2, 0x90, 0x8a, 0xd2, 0x1c, 0xea, 0x16, 0x22,
	0xa8, 0xeb, 0x42, 0x85, 0x41, 0x54, 0xa3, 0xd9, 0x8d, 0xb2, 0xc7, 0x6c, 0xa3, 0xd9, 0xe5, 0xf1,
	0x58, 0xa0, 0x4b, 0x24, 0x5c, 0x42, 0x24, 0x8e, 0xd5, 0x7e, 0x39, 0x76, 0x7c, 0x1c, 0x74, 0x5c,
	0x6a, 0xd0, 0xac, 0x15, 0x11, 0xcc, 0x6d, 0x91, 0xf3, 0x52, 0x6d, 0x3c, 0xc8, 0x67, 0xa8, 0x33,
	0x9f, 0x41, 0x85, 0x49, 0x2b, 0xc3, 0x5f, 0x08, 0x55, 0xc8, 0x44, 0xf6, 0x9d, 0x13, 0x1c, 0x84,
	0xf6, 0xc9, 0x58, 0x4c, 0x44, 0x12, 0xcc, 0xf7, 0x60, 0x59, 0xd1, 0xcb, 0x27, 0x82, 0x48, 0xf1,
	0x76, 0x16, 0x70, 0x8c, 0xa3, 0xdf, 0xe6, 0x03, 0xa8, 0x30, 0x9c, 0xbb, 0xec, 0x04, 0xcc, 0x0f,
	0x45, 0xe2, 0xab, 0x0e, 0xf1, 0x6a, 0x34, 0x7d, 0x00, 0x15, 0x86, 0x86, 0x97, 0x1e, 0x70, 0x5b,
	0xa4, 0xbd, 0x17, 0x35, 0xee, 0x87, 0x50, 0x6c, 0x34, 0xbb, 0x8d, 0x81, 0xf0, 0x66, 0xa5, 0x1c,
	0xa0, 0xdf, 0x24, 0x32, 0x9e, 0xa9, 0xe9, 0x0c, 0x6d, 0x98, 0xbf, 0xc8, 0x50, 0x9d, 0xa8, 0x0c,
	0x86, 0x84, 0x57, 0xa3, 0xd3, 0x42, 0xef, 0xc2, 0x02, 0xd3, 0xc5, 0x63, 0xb3, 0x2c, 0x46, 0x63,
	0x54, 0x8b, 0x73, 0x49, 0x21, 0x46, 0x8e, 0xf2, 0x4e, 0x8b, 0x07, 0x15, 0x6f, 0x11, 0xdb, 0xc8,
	0x48, 0xe9, 0xb4, 0x78, 0x58, 0xa9, 0x24, 0x22, 0x49, 0x22, 0xbd, 0xd3, 0xe2, 0xb9, 0x08, 0x6f,
	0x99, 0xbf, 0xcd, 0x40, 0xb9, 0xd1, 0xec, 0xaa, 0x81, 0xbe, 0x09, 0x79, 0x36, 0x5c, 0x40, 0x4b,
	0xc3, 0xe4, 0x6c, 0x04, 0x9b, 0xe4, 0x1a, 0x6c, 0x02, 0x41, 0xd5, 0xa0, 0x40, 0x28, 0x9a, 0x24,
	0xfe, 0x94, 0xd1, 0x59, 0xce, 0x5d, 0xb4, 0x34, 0x1a, 0x91, 0x66, 0x93, 0x60, 0xc9, 0x75, 0xd1,
	0x12, 0x4d, 0x11, 0x4b, 0xb9, 0x28, 0x96, 0x7e, 0x6d, 0xb0, 0xaa, 0xfd, 0x29, 0x0e, 0xed, 0xd4,
	0x02, 0xa0, 0xc6, 0x92, 0x1b, 0x4a, 0xe7, 0x69, 0x9e, 0x68, 0x13, 0x7f, 0x26, 0x7b, 0xc2, 0x8e,
	0x42, 0x9e, 0xe6, 0x49, 0x02, 0xe1, 0xfe, 0x24, 0xf0, 0x5c, 0xb6, 0x5b, 0xcc, 0x72, 0x11, 0x41,
	0x3b, 0x42, 0x72, 0xaf, 0x21, 0x55, 0x5e, 0x98, 0x5d, 0xcd, 0x6f, 0xc1, 0x22, 0xd1, 0x3a, 0x3a,
	0xc5, 0x43, 0x32, 0x7d, 0x0a, 0x6d, 0x3a, 0x54, 0x6b, 0x7c, 0xf3, 0x57, 0x06, 0x2c, 0x0b, 0xbb,
	0x68, 0x4b, 0x8a, 0x16, 0x9c, 0x89, 0x2f, 0x38, 0xbd, 0xc6, 0x5f, 0x81, 0x5c, 0xdf, 0x1f, 0x62,
	0x9f, 0x1a, 0x28, 0x67, 0xb1, 0x06, 0xd1, 0xd4, 0x71, 0x87, 0xf8, 0x25, 0x9d, 0x3b, 0xcf, 0x81,
	0x25, 0x81, 0x60, 0x23, 0xb1, 0x54, 0x0b, 0x1f, 0x39, 0xae, 0x43, 0xdd, 0x97, 0x39, 0x57, 0x8c,
	0xaa, 0x19, 0x71, 0xe1, 0x35, 0x18, 0x31, 0x3f, 0xd3, 0x88, 0xe6, 0xef, 0x32, 0x70, 0x9d, 0x1d,
	0x04, 0xc2, 0x34, 0x02, 0x0d, 0x9a, 0x50, 0xec, 0x8f, 0xb1, 0x6f, 0xd3, 0xb9, 0x66, 0xe8, 0x39,
	0xf3, 0x7f, 0xac, 0x0e, 0x4c, 0xeb, 0xbe, 0x25, 0xda, 0xfd, 0xb1, 0x15, 0xc9, 0xa1, 0xff, 0x87,
	0x22, 0x21, 0xb6, 0xec, 0xd0, 0x16, 0xc5, 0xe4, 0x35, 0x59, 0x4c, 0x52, 0xf1, 0x88, 0x6f, 0xbe,
	0x05, 0x10, 0x69, 0x41, 0x79, 0xc8, 0xee, 0x1e, 0xec, 0x57, 0xe6, 0x10, 0xc0, 0x42, 0xab, 0xdd,
	0x6d, 0xef, 0xb7, 0x2b, 0x19, 0xb3, 0x0d, 0xab, 0xf1, 0xe1, 0x39, 0x02, 0x5d, 0x6a, 0xa4, 0x7f,
	0x66, 0xe0, 0x7a, 0x54, 0x80, 0xab, 0xab, 0x5e, 0x67, 0x6a, 0x48, 0x2c, 0x04, 0xfc, 0xb6, 0x27,
	0x22, 0x50, 0x67, 0xe1, 0x91, 0x22, 0xc2, 0x38, 0x22, 0xbc, 0x22, 0x76, 0xea, 0xb0, 0x22, 0xf6,
	0x6f, 0x6f, 0x72, 0xf8, 0x1d, 0x1e, 0x84, 0xfd, 0x33, 0x17, 0xfb, 0x3c, 0x8c, 0x52, 0x79, 0xe8,
	0x11, 0x5c, 0x13, 0x74, 0x86, 0xcc, 0x39, 0xea, 0xe3, 0xeb, 0x53, 0x3c, 0x82, 0xe1, 0xb4, 0x2e,
	0x62, 0x36, 0x45, 0xde, 0x9c, 0x30, 0xd9, 0x9d, 0x08, 0x27, 0x38, 0x72, 0xc7, 0x2c, 0x26, 0xd9,
	0xe6, 0x9f, 0x32, 0x70, 0x5b, 0x37, 0xbc, 0x5c, 0x98, 0xb0, 0x5c, 0x2f, 0xe9, 0x2f, 0xf7, 0x52,
	0xfc, 0x25, 0x2e, 0x27, 0x47, 0xeb, 0x05, 0xba, 0xeb, 0x7c, 0x04, 0x20, 0xfb, 0x32, 0x63, 0x97,
	0xea, 0xab, 0xda, 0xfc, 0x22, 0x55, 0x4a, 0x4f, 0xf3, 0x6d, 0x58, 0x54, 0x55, 0xa6, 0xfb, 0xd1,
	0xb7, 0xf0, 0xe6, 0xd4, 0x69, 0x71, 0xeb, 0xe8, 0xe3, 0x67, 0x2e, 0x3c, 0xfe, 0x6d, 0x58, 0xef,
	0x3a, 0x41, 0x38, 0x6d, 0xbd, 0x26, 0x86, 0x5b, 0x53, 0xf8, 0x7c, 0xe0, 0x56, 0x0a, 0x4c, 0xf1,
	0xfd, 0x99, 0x36, 0x7e, 0x52, 0xc0, 0xfc, 0x4d, 0x16, 0x4a, 0xcd, 0xe7, 0xb6, 0x7b, 0x8c, 0xdb,
	0xa7, 0xd8, 0x0d, 0xd1, 0x1a, 0x14, 0xbe, 0x0b, 0x3c, 0x97, 0x56, 0xb4, 0xbc, 0xe8, 0xff, 0x32,
	0x24, 0xf5, 0xeb, 0x26, 0xcc, 0x53, 0xa2, 0x41, 0xb7, 0x6c, 0x85, 0x8e, 0xa0, 0x08, 0xd2, 0x6a,
	0x97, 0xf6, 0x90, 0xf7, 0x53, 0xd9, 0xd4, 0xfb, 0x29, 0x79, 0xbf, 0x3d, 0x9f, 0x7a, 0xbf, 0xad,
	0x17, 0x59, 0xb9, 0x57, 0x14, 0x59, 0x34, 0xa1, 0x18, 0x8c, 0xe8, 0x11, 0xa0, 0x27, 0x14, 0x83,
	0x11, 0xfa, 0x0c, 0xae, 0xe9, 0xc6, 0x29, 0xcc, 0x34, 0x8e, 0xde, 0x19, 0x7d, 0xa9, 0xd5, 0x2c,
	0xac, 0xd4, 0xd9, 0x88, 0xaf, 0x7a, 0xd6, 0x3d, 0xd7, 0xff, 0x7a, 0x47, 0xf3, 0x43, 0x06, 0xde,
	0x60, 0xf1, 0xda, 0x76, 0x8f, 0x1d, 0x17, 0x2b, 0xb7, 0xa5, 0x22, 0x72, 0xc5, 0x6d, 0xa9, 0x68,
	0x93, 0x94, 0x44, 0x49, 0x7a, 0x8a, 0x32, 0xc9, 0xa9, 0x41, 0x81, 0x03, 0x86, 0xc8, 0x1b, 0x64,
	0x1b, 0x7d, 0x01, 0x79, 0x8e, 0xf6, 0xfc, 0x42, 0x8e, 0xc1, 0x77, 0xca, 0xd0, 0x5b, 0xe2, 0x54,
	0xa0, 0x4b, 0x15, 0x52, 0xb5, 0x4f, 0x60, 0x51, 0x65, 0x5c, 0x6a, 0x91, 0xa7, 0xb0, 0xa2, 0x0f,
	0xc4, 0x9d, 0xbb, 0x0a, 0xf9, 0xc6, 0x68, 0xe4, 0x9d, 0xf1, 0xac, 0xb4, 0x60, 0x89, 0x26, 0x49,
	0x83, 0xda, 0x2f, 0xc7, 0xe4, 0x94, 0x0a, 0x5b, 0xd8, 0x3d, 0xa7, 0x2a, 0x0b, 0x96, 0x46, 0x23,
	0xb9, 0x5b, 0x0b, 0x1f, 0xd9, 0x93, 0x11, 0xeb, 0xc2, 0x6e, 0xd8, 0x55, 0x92, 0xb9, 0x03, 0x4b,
	0x6c, 0xdc, 0xa6, 0xe7, 0x0e, 0x1d, 0x91, 0x72, 0x86, 0x91, 0xd7, 0xd3, 0x6f, 0xa2, 0x88, 0x44,
	0x43, 0x7f, 0xcc, 0x72, 0x37, 0x36, 0x7d, 0x95, 0x64, 0x7e, 0x6f, 0xc0, 0x02, 0xd3, 0x44, 0x32,
	0x50, 0x99, 0x41, 0x19, 0xce, 0x30, 0x5e, 0xb3, 0x19, 0xc9, 0x9a, 0xad, 0x06, 0x85, 0x20, 0xb6,
	0x2d, 0xa2, 0x4d, 0x4e, 0x09, 0x9f, 0x6f, 0xab, 0x48, 0xe6, 0x22, 0x02, 0xb1, 0x8f, 0xcd, 0x13,
	0xca, 0x1c, 0x4b, 0xf4, 0x78, 0x13, 0xdd, 0x81, 0x05, 0x7c, 0x74, 0x84, 0x07, 0xac, 0x6e, 0x2a,
	0xd7, 0x97, 0xd5, 0xdd, 0xa4, 0x0c, 0x8b, 0x77, 0x40, 0x9f, 0x02, 0x0c, 0xc4, 0xf2, 0x85, 0x8b,
	0xdf, 0x54, 0xba, 0x6f, 0x49, 0xe3, 0x08, 0xef, 0x8e, 0xba, 0xd7, 0xf6, 0x60, 0x29, 0xc6, 0x4e,
	0xd9, 0xf8, 0xbb, 0x7a, 0x7d, 0xbc, 0xa2, 0x28, 0x97, 0xc2, 0xaa, 0x3b, 0xfc, 0xcc, 0x80, 0x12,
	0x63, 0xb3, 0xbb, 0xd9, 0xb4, 0xb4, 0x54, 0x94, 0x06, 0x86, 0x52, 0x1a, 0x6c, 0xa4, 0x5c, 0x95,
	0xe8, 0x37, 0x24, 0xeb, 0x50, 0xa4, 0x67, 0x25, 0x55, 0xc7, 0x53, 0x52, 0x49, 0x40, 0x0f, 0xa3,
	0x03, 0x94, 0xdd, 0x11, 0xb3, 0x82, 0xb9, 0xaa, 0xcc, 0x57, 0xe3, 0x5b, 0x7a, 0xf7, 0x0b, 0xdc,
	0x9b, 0xbc, 0x97, 0xb8, 0x37, 0x29, 0xa9, 0xca, 0x25, 0xd3, 0x7c, 0x0a, 0x6b, 0x7b, 0xa1, 0xe7,
	0x63, 0xc5, 0x0c, 0x22, 0xf2, 0xeb, 0x9a, 0x71, 0x38, 0xd6, 0x57, 0x14, 0x35, 0xac, 0xb7, 0xda,
	0xc9, 0xec, 0x41, 0x35, 0xa9, 0x8e, 0x07, 0xd9, 0x15, 0xf5, 0xb1, 0xda, 0xf0, 0x35, 0xcd, 0xef,
	0x43, 0xb8, 0x91, 0xa2, 0x2f, 0x42, 0x81, 0xbd, 0xc9, 0x60, 0x80, 0x83, 0x40, 0xa0, 0x00, 0x6f,
	0x9a, 0x37, 0x60, 0x8d, 0x9c, 0x8e, 0x8a, 0x50, 0x20, 0x0e, 0xce, 0x23, 0xa8, 0x26, 0x59, 0x5c,
	0xe1, 0x8f, 0x61, 0x51, 0xa5, 0xf3, 0xe3, 0x3a, 0x39, 0x45, 0xad, 0x17, 0x81, 0xaf, 0x7d, 0x2f,
	0xb4, 0x59, 0x76, 0x9f, 0xb3, 0x58, 0xe3, 0xee, 0xfb, 0xd1, 0xdd, 0x2f, 0x2a, 0x41, 0xfe, 0xa0,
	0xf7, 0xa4, 0xd7, 0xff, 0xa6, 0x57, 0x99, 0x43, 0x05, 0x98, 0x3f, 0xd8, 0x6b, 0x5b, 0x95, 0x0c,
	0x2a, 0x42, 0x6e, 0xc7, 0xea, 0x1f, 0xec, 0x56, 0x8c, 0xbb, 0x0f, 0xa0, 0xac, 0x5f, 0xbc, 0x90,
	0x84, 0xa3, 0xd1, 0xfb, 0xb6, 0x32, 0x47, 0x7a, 0x35, 0x5a, 0x4f, 0x3b, 0xbd, 0x4a, 0x86, 0x88,
	0x5a, 0xfd, 0xfe, 0xd3, 0x8a, 0x41, 0xbe, 0xba, 0x9d, 0xde, 0x93, 0x4a, 0xf6, 0xee, 0x33, 0x58,
	0x8a, 0x9d, 0xb3, 0x24, 0x45, 0x69, 0x5a, 0xed, 0xc6, 0x7e, 0x9b, 0x8d, 0x66, 0xb5, 0x1b, 0xad,
	0x4a, 0x86, 0x50, 0x0f, 0x76, 0x5b, 0x84, 0x6a, 0x28, 0x49, 0x4c, 0x96, 0xe8, 0xef, 0xf6, 0x77,
	0x3a, 0xbd, 0xca, 0x3c, 0x21, 0x77, 0xfb, 0x3b, 0xfd, 0x83, 0xfd, 0x4a, 0xee, 0xee, 0x3d, 0x61,
	0x0b, 0x86, 0x0a, 0x64, 0x0d, 0x13, 0xf7, 0x85, 0xeb, 0x9d, 0xb9, 0x4c, 0xeb, 0x10, 0xbb, 0xe7,
	0x6c, 0x0d, 0x36, 0x81, 0xde, 0x8a, 0x71, 0xb7, 0x2e, 0x0e, 0x24, 0xdd, 0xf9, 0x0b, 0x30, 0xef,
	0xe3, 0x20, 0xac, 0xcc, 0x91, 0x25, 0xd9, 0x83, 0x11, 0x5b, 0x87, 0xe7, 0x0c, 0x07, 0x15, 0xa3,
	0xfe, 0x17, 0x03, 0x4a, 0xf4, 0x95, 0x94, 0x65, 0xa2, 0xe8, 0x0b, 0x80, 0xe8, 0x59, 0x1f, 0xb1,
	0xb3, 0x38, 0xf1, 0xdf, 0x80, 0xda, 0x5a, 0x82, 0xce, 0x36, 0xd0, 0x9c, 0x23, 0x0a, 0xa2, 0x77,
	0x7a, 0xae, 0x20, 0xf1, 0xe6, 0xcf, 0x15, 0x24, 0x1f, 0xf4, 0xcd, 0x39, 0xd4, 0x00, 0x88, 0x5e,
	0xdd, 0xb9, 0x82, 0xc4, 0x0b, 0x3e, 0x57, 0x90, 0x7c, 0x9e, 0x37, 0xe7, 0xee, 0x65, 0x50, 0x13,
	0x60, 0x2f, 0xf4, 0xb1, 0x7d, 0x72, 0x45, 0x15, 0x9b, 0x99, 0x7b, 0x19, 0xf4, 0x39, 0x14, 0xe5,
	0x43, 0xfe, 0x54, 0x1d, 0xdc, 0x40, 0xf1, 0x07, 0x7f, 0x73, 0xae, 0xfe, 0xcb, 0x2c, 0x94, 0xe8,
	0x13, 0x4e, 0xdc, 0xb0, 0x34, 0xc9, 0x52, 0x0d, 0xab, 0xbc, 0x3b, 0x6a, 0x86, 0x55, 0x1f, 0x08,
	0x55, 0xc3, 0x2a, 0x0a, 0x12, 0x6f, 0xa5, 0x9a, 0x61, 0x63, 0x0a, 0x3e, 0x86, 0x82, 0x78, 0x8e,
	0x45, 0x0c, 0xe9, 0x63, 0x0f, 0xbd, 0xb5, 0xeb, 0x31, 0xaa, 0x14, 0x15, 0xb6, 0x50, 0x86, 0x4e,
	0xbc, 0x99, 0xaa, 0xb6, 0x88, 0x89, 0xcb, 0x2d, 0x9d, 0x29, 0xbf, 0x96, 0xa0, 0xa7, 0x6d, 0xe9,
	0x15, 0x55, 0x90, 0x2d, 0xad, 0xff, 0xd5, 0x80, 0x4a, 0x14, 0xe5, 0x7c, 0x63, 0x7a, 0xb0, 0x14,
	0x7b, 0x56, 0x41, 0x37, 0x95, 0x5d, 0x88, 0x3f, 0x53, 0xd4, 0xd6, 0xd3, 0x99, 0x72, 0xb1, 0x3d,
	0x58, 0x8a, 0xbd, 0x8e, 0x70, 0x7d, 0xe9, 0x6f, 0x2e, 0x5c, 0xdf, 0x94, 0x07, 0x15, 0x73, 0x0e,
	0xed, 0xc2, 0x52, 0xec, 0xc1, 0x83, 0xeb, 0x4b, 0x7f, 0x46, 0xe1, 0xfa, 0xa6, 0xbc, 0x91, 0x50,
	0x5b, 0x5a, 0xb0, 0xc4, 0x6c, 0xf9, 0x7a, 0x34, 0x52, 0xd3, 0xfe, 0xc1, 0x00, 0x68, 0x34, 0xbb,
	0xc2, 0xa8, 0x9f, 0x41, 0x51, 0x5e, 0xdd, 0xa2, 0xeb, 0x8a, 0xc5, 0xa2, 0x7b, 0xca, 0xda, 0x6a,
	0x9c, 0x2c, 0x97, 0xfc, 0x99, 0xb8, 0x16, 0x8e, 0xa4, 0xe3, 0xf7, 0xba, 0x5c, 0x3a, 0x71, 0x2d,
	0xcb, 0xa4, 0xe5, 0x55, 0x2a, 0x97, 0x8e, 0x5f, 0xca, 0xd6, 0x56, 0xe3, 0x64, 0x29, 0xfd, 0x10,
	0x8a, 0xf2, 0x5e, 0x94, 0x4b, 0xc7, 0x6f, 0x58, 0x6b, 0xab, 0x71, 0xb2, 0x62, 0xdc, 0x2f, 0xa1,
	0xc8, 0x8c, 0x7b, 0x15, 0x79, 0x6a, 0xca, 0xff, 0x18, 0xec, 0xf1, 0x97, 0xd4, 0x3b, 0xc2, 0x9e,
	0x4f, 0xa0, 0xac, 0x17, 0xba, 0xa8, 0x36, 0xfd, 0x12, 0xa7, 0x76, 0x33, 0x95, 0x27, 0x97, 0xf8,
	0x14, 0xca, 0xfa, 0x55, 0x02, 0x57, 0x96, 0x7a, 0x95, 0x52, 0xbb, 0x99, 0xca, 0x53, 0x56, 0x7c,
	0x04, 0x6b, 0x53, 0x8a, 0x70, 0xf4, 0xf6, 0x05, 0x6e, 0x0e, 0x6a, 0xef, 0xcc, 0xee, 0x24, 0xa7,
	0x7d, 0x08, 0xd7, 0x53, 0x2b, 0x6e, 0xf4, 0x16, 0x55, 0x30, 0xab, 0x5a, 0xaf, 0x99, 0xb3, 0xba,
	0x44, 0x6b, 0xa9, 0xff, 0xd9, 0xd0, 0x8b, 0x3a, 0x61, 0xff, 0x47, 0x50, 0xec, 0x04, 0xa2, 0xc4,
	0xa9, 0x4e, 0x2b, 0xc0, 0x6a, 0x37, 0x52, 0x38, 0x72, 0xfe, 0x5f, 0x43, 0x25, 0x9e, 0xea, 0x21,
	0x1e, 0x5a, 0xe9, 0x09, 0x65, 0xed, 0xd6, 0x14, 0xae, 0xaa, 0x32, 0x9e, 0x4b, 0x71, 0x95, 0x53,
	0xb2, 0x2f, 0xae, 0x72, 0x5a, 0x02, 0x66, 0xce, 0xa1, 0x7d, 0xf1, 0x10, 0xa1, 0x4e, 0xf3, 0x96,
	0x12, 0x2e, 0x29, 0xf3, 0xbc, 0x3d, 0x8d, 0x2d, 0xb4, 0x1e, 0x2e, 0xd0, 0x3f, 0x1a, 0xde, 0xff,
	0x6f, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa9, 0xe3, 0x06, 0x48, 0x21, 0x29, 0x00, 0x00,
}
