// Code generated by protoc-gen-go. DO NOT EDIT.
// source: jobs.proto

/*
Package jobs is a generated protocol buffer package.

It is generated from these files:
	jobs.proto

It has these top-level messages:
	NodesSelector
	IdmSelector
	UsersSelector
	DataSourceSelector
	TriggerFilterQuery
	TriggerFilter
	ActionOutputFilter
	ContextMetaFilter
	ContextMetaSingleQuery
	Schedule
	Action
	Job
	JobParameter
	JobChangeEvent
	TaskChangeEvent
	PutJobRequest
	PutJobResponse
	GetJobRequest
	GetJobResponse
	DeleteJobRequest
	DeleteJobResponse
	ListJobsRequest
	ListJobsResponse
	ListTasksRequest
	ListTasksResponse
	PutTaskRequest
	PutTaskResponse
	DeleteTasksRequest
	DeleteTasksResponse
	DetectStuckTasksRequest
	DetectStuckTasksResponse
	Task
	CtrlCommand
	CtrlCommandResponse
	ActionLog
	JobTriggerEvent
	ActionOutput
	ActionOutputSingleQuery
	ActionMessage
*/
package jobs

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import google_protobuf "github.com/golang/protobuf/ptypes/any"
import service "github.com/pydio/cells/common/service/proto"
import tree "github.com/pydio/cells/common/proto/tree"
import idm "github.com/pydio/cells/common/proto/idm"
import activity "github.com/pydio/cells/common/proto/activity"
import object "github.com/pydio/cells/common/proto/object"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Possible values for IdmSelector.Type
type IdmSelectorType int32

const (
	IdmSelectorType_User      IdmSelectorType = 0
	IdmSelectorType_Role      IdmSelectorType = 1
	IdmSelectorType_Workspace IdmSelectorType = 2
	IdmSelectorType_Acl       IdmSelectorType = 3
)

var IdmSelectorType_name = map[int32]string{
	0: "User",
	1: "Role",
	2: "Workspace",
	3: "Acl",
}
var IdmSelectorType_value = map[string]int32{
	"User":      0,
	"Role":      1,
	"Workspace": 2,
	"Acl":       3,
}

func (x IdmSelectorType) String() string {
	return proto.EnumName(IdmSelectorType_name, int32(x))
}
func (IdmSelectorType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

type DataSourceSelectorType int32

const (
	DataSourceSelectorType_DataSource DataSourceSelectorType = 0
	DataSourceSelectorType_Object     DataSourceSelectorType = 1
)

var DataSourceSelectorType_name = map[int32]string{
	0: "DataSource",
	1: "Object",
}
var DataSourceSelectorType_value = map[string]int32{
	"DataSource": 0,
	"Object":     1,
}

func (x DataSourceSelectorType) String() string {
	return proto.EnumName(DataSourceSelectorType_name, int32(x))
}
func (DataSourceSelectorType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

type ContextMetaFilterType int32

const (
	ContextMetaFilterType_RequestMeta ContextMetaFilterType = 0
	ContextMetaFilterType_ContextUser ContextMetaFilterType = 1
)

var ContextMetaFilterType_name = map[int32]string{
	0: "RequestMeta",
	1: "ContextUser",
}
var ContextMetaFilterType_value = map[string]int32{
	"RequestMeta": 0,
	"ContextUser": 1,
}

func (x ContextMetaFilterType) String() string {
	return proto.EnumName(ContextMetaFilterType_name, int32(x))
}
func (ContextMetaFilterType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

// /////////////////
// TASK SERVICE  //
// /////////////////
type TaskStatus int32

const (
	TaskStatus_Unknown     TaskStatus = 0
	TaskStatus_Idle        TaskStatus = 1
	TaskStatus_Running     TaskStatus = 2
	TaskStatus_Finished    TaskStatus = 3
	TaskStatus_Interrupted TaskStatus = 4
	TaskStatus_Paused      TaskStatus = 5
	TaskStatus_Any         TaskStatus = 6
	TaskStatus_Error       TaskStatus = 7
	TaskStatus_Queued      TaskStatus = 8
)

var TaskStatus_name = map[int32]string{
	0: "Unknown",
	1: "Idle",
	2: "Running",
	3: "Finished",
	4: "Interrupted",
	5: "Paused",
	6: "Any",
	7: "Error",
	8: "Queued",
}
var TaskStatus_value = map[string]int32{
	"Unknown":     0,
	"Idle":        1,
	"Running":     2,
	"Finished":    3,
	"Interrupted": 4,
	"Paused":      5,
	"Any":         6,
	"Error":       7,
	"Queued":      8,
}

func (x TaskStatus) String() string {
	return proto.EnumName(TaskStatus_name, int32(x))
}
func (TaskStatus) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

type Command int32

const (
	Command_None     Command = 0
	Command_Pause    Command = 1
	Command_Resume   Command = 2
	Command_Stop     Command = 3
	Command_Delete   Command = 4
	Command_RunOnce  Command = 5
	Command_Inactive Command = 6
	Command_Active   Command = 7
)

var Command_name = map[int32]string{
	0: "None",
	1: "Pause",
	2: "Resume",
	3: "Stop",
	4: "Delete",
	5: "RunOnce",
	6: "Inactive",
	7: "Active",
}
var Command_value = map[string]int32{
	"None":     0,
	"Pause":    1,
	"Resume":   2,
	"Stop":     3,
	"Delete":   4,
	"RunOnce":  5,
	"Inactive": 6,
	"Active":   7,
}

func (x Command) String() string {
	return proto.EnumName(Command_name, int32(x))
}
func (Command) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

// /////////////////
// JOB  SERVICE  //
// /////////////////
type NodesSelector struct {
	// Select all files - ignore any other condition
	All bool `protobuf:"varint,1,opt,name=All" json:"All,omitempty"`
	// Preset list of node pathes
	Pathes []string `protobuf:"bytes,2,rep,name=Pathes" json:"Pathes,omitempty"`
	// Query to apply to select users (or filter a given node passed by event)
	Query *service.Query `protobuf:"bytes,4,opt,name=Query" json:"Query,omitempty"`
	// Whether to trigger one action per node or one action
	// with all nodes as selection
	Collect bool `protobuf:"varint,5,opt,name=Collect" json:"Collect,omitempty"`
	// Selector custom label
	Label string `protobuf:"bytes,6,opt,name=Label" json:"Label,omitempty"`
	// Selector additional description
	Description string `protobuf:"bytes,7,opt,name=Description" json:"Description,omitempty"`
}

func (m *NodesSelector) Reset()                    { *m = NodesSelector{} }
func (m *NodesSelector) String() string            { return proto.CompactTextString(m) }
func (*NodesSelector) ProtoMessage()               {}
func (*NodesSelector) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *NodesSelector) GetAll() bool {
	if m != nil {
		return m.All
	}
	return false
}

func (m *NodesSelector) GetPathes() []string {
	if m != nil {
		return m.Pathes
	}
	return nil
}

func (m *NodesSelector) GetQuery() *service.Query {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *NodesSelector) GetCollect() bool {
	if m != nil {
		return m.Collect
	}
	return false
}

func (m *NodesSelector) GetLabel() string {
	if m != nil {
		return m.Label
	}
	return ""
}

func (m *NodesSelector) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

// Generic container for select/filter idm objects
type IdmSelector struct {
	// Type of objects to look for
	Type IdmSelectorType `protobuf:"varint,1,opt,name=Type,enum=jobs.IdmSelectorType" json:"Type,omitempty"`
	// Load all objects
	All bool `protobuf:"varint,2,opt,name=All" json:"All,omitempty"`
	// Serialized search query
	Query *service.Query `protobuf:"bytes,3,opt,name=Query" json:"Query,omitempty"`
	// Pass a slice of objects to one action, or trigger all actions in parallel
	Collect bool `protobuf:"varint,4,opt,name=Collect" json:"Collect,omitempty"`
	// Selector custom label
	Label string `protobuf:"bytes,5,opt,name=Label" json:"Label,omitempty"`
	// Selector additional description
	Description string `protobuf:"bytes,6,opt,name=Description" json:"Description,omitempty"`
}

func (m *IdmSelector) Reset()                    { *m = IdmSelector{} }
func (m *IdmSelector) String() string            { return proto.CompactTextString(m) }
func (*IdmSelector) ProtoMessage()               {}
func (*IdmSelector) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *IdmSelector) GetType() IdmSelectorType {
	if m != nil {
		return m.Type
	}
	return IdmSelectorType_User
}

func (m *IdmSelector) GetAll() bool {
	if m != nil {
		return m.All
	}
	return false
}

func (m *IdmSelector) GetQuery() *service.Query {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *IdmSelector) GetCollect() bool {
	if m != nil {
		return m.Collect
	}
	return false
}

func (m *IdmSelector) GetLabel() string {
	if m != nil {
		return m.Label
	}
	return ""
}

func (m *IdmSelector) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

// Select or filter users - should be replaced by more generic IdmSelector
type UsersSelector struct {
	// Select all users
	All bool `protobuf:"varint,1,opt,name=All" json:"All,omitempty"`
	// Preset set of Users
	Users []*idm.User `protobuf:"bytes,2,rep,name=Users" json:"Users,omitempty"`
	// Filter users using this query
	Query *service.Query `protobuf:"bytes,3,opt,name=Query" json:"Query,omitempty"`
	// Wether to trigger one action per user or one action
	// with all user as a selection
	Collect bool `protobuf:"varint,5,opt,name=Collect" json:"Collect,omitempty"`
	// Selector custom label
	Label string `protobuf:"bytes,6,opt,name=Label" json:"Label,omitempty"`
	// Selector additional description
	Description string `protobuf:"bytes,7,opt,name=Description" json:"Description,omitempty"`
}

func (m *UsersSelector) Reset()                    { *m = UsersSelector{} }
func (m *UsersSelector) String() string            { return proto.CompactTextString(m) }
func (*UsersSelector) ProtoMessage()               {}
func (*UsersSelector) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *UsersSelector) GetAll() bool {
	if m != nil {
		return m.All
	}
	return false
}

func (m *UsersSelector) GetUsers() []*idm.User {
	if m != nil {
		return m.Users
	}
	return nil
}

func (m *UsersSelector) GetQuery() *service.Query {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *UsersSelector) GetCollect() bool {
	if m != nil {
		return m.Collect
	}
	return false
}

func (m *UsersSelector) GetLabel() string {
	if m != nil {
		return m.Label
	}
	return ""
}

func (m *UsersSelector) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

// Selector/Filter for DataSource objects
type DataSourceSelector struct {
	// Selector custom label
	Label string `protobuf:"bytes,1,opt,name=Label" json:"Label,omitempty"`
	// Selector additional description
	Description string `protobuf:"bytes,2,opt,name=Description" json:"Description,omitempty"`
	// Selector type, either DataSource or Object service
	Type DataSourceSelectorType `protobuf:"varint,3,opt,name=Type,enum=jobs.DataSourceSelectorType" json:"Type,omitempty"`
	// Select all
	All bool `protobuf:"varint,4,opt,name=All" json:"All,omitempty"`
	// Collect results
	Collect bool `protobuf:"varint,5,opt,name=Collect" json:"Collect,omitempty"`
	// Composition of DataSourceSingleQueries
	Query *service.Query `protobuf:"bytes,6,opt,name=Query" json:"Query,omitempty"`
}

func (m *DataSourceSelector) Reset()                    { *m = DataSourceSelector{} }
func (m *DataSourceSelector) String() string            { return proto.CompactTextString(m) }
func (*DataSourceSelector) ProtoMessage()               {}
func (*DataSourceSelector) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *DataSourceSelector) GetLabel() string {
	if m != nil {
		return m.Label
	}
	return ""
}

func (m *DataSourceSelector) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *DataSourceSelector) GetType() DataSourceSelectorType {
	if m != nil {
		return m.Type
	}
	return DataSourceSelectorType_DataSource
}

func (m *DataSourceSelector) GetAll() bool {
	if m != nil {
		return m.All
	}
	return false
}

func (m *DataSourceSelector) GetCollect() bool {
	if m != nil {
		return m.Collect
	}
	return false
}

func (m *DataSourceSelector) GetQuery() *service.Query {
	if m != nil {
		return m.Query
	}
	return nil
}

type TriggerFilterQuery struct {
	IsSchedule bool     `protobuf:"varint,1,opt,name=IsSchedule" json:"IsSchedule,omitempty"`
	IsManual   bool     `protobuf:"varint,2,opt,name=IsManual" json:"IsManual,omitempty"`
	EventNames []string `protobuf:"bytes,3,rep,name=EventNames" json:"EventNames,omitempty"`
}

func (m *TriggerFilterQuery) Reset()                    { *m = TriggerFilterQuery{} }
func (m *TriggerFilterQuery) String() string            { return proto.CompactTextString(m) }
func (*TriggerFilterQuery) ProtoMessage()               {}
func (*TriggerFilterQuery) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *TriggerFilterQuery) GetIsSchedule() bool {
	if m != nil {
		return m.IsSchedule
	}
	return false
}

func (m *TriggerFilterQuery) GetIsManual() bool {
	if m != nil {
		return m.IsManual
	}
	return false
}

func (m *TriggerFilterQuery) GetEventNames() []string {
	if m != nil {
		return m.EventNames
	}
	return nil
}

// Filter for events, can be applied on action branches
type TriggerFilter struct {
	// Filter custom label
	Label string `protobuf:"bytes,1,opt,name=Label" json:"Label,omitempty"`
	// Filter additional description
	Description string `protobuf:"bytes,2,opt,name=Description" json:"Description,omitempty"`
	// Filter type
	Query *service.Query `protobuf:"bytes,3,opt,name=Query" json:"Query,omitempty"`
}

func (m *TriggerFilter) Reset()                    { *m = TriggerFilter{} }
func (m *TriggerFilter) String() string            { return proto.CompactTextString(m) }
func (*TriggerFilter) ProtoMessage()               {}
func (*TriggerFilter) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *TriggerFilter) GetLabel() string {
	if m != nil {
		return m.Label
	}
	return ""
}

func (m *TriggerFilter) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *TriggerFilter) GetQuery() *service.Query {
	if m != nil {
		return m.Query
	}
	return nil
}

// ActionOutputFilter can be used to filter last message output
type ActionOutputFilter struct {
	// Query built from ActionOutputSingleQuery
	Query *service.Query `protobuf:"bytes,1,opt,name=Query" json:"Query,omitempty"`
	// Selector custom label
	Label string `protobuf:"bytes,2,opt,name=Label" json:"Label,omitempty"`
	// Selector additional description
	Description string `protobuf:"bytes,3,opt,name=Description" json:"Description,omitempty"`
}

func (m *ActionOutputFilter) Reset()                    { *m = ActionOutputFilter{} }
func (m *ActionOutputFilter) String() string            { return proto.CompactTextString(m) }
func (*ActionOutputFilter) ProtoMessage()               {}
func (*ActionOutputFilter) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *ActionOutputFilter) GetQuery() *service.Query {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *ActionOutputFilter) GetLabel() string {
	if m != nil {
		return m.Label
	}
	return ""
}

func (m *ActionOutputFilter) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

// PolicyContextFilter can be used to filter request metadata
type ContextMetaFilter struct {
	// Type of context filter
	Type ContextMetaFilterType `protobuf:"varint,1,opt,name=Type,enum=jobs.ContextMetaFilterType" json:"Type,omitempty"`
	// Can be built with ContextMetaSingleQuery
	Query *service.Query `protobuf:"bytes,2,opt,name=Query" json:"Query,omitempty"`
	// Selector custom label
	Label string `protobuf:"bytes,3,opt,name=Label" json:"Label,omitempty"`
	// Selector additional description
	Description string `protobuf:"bytes,4,opt,name=Description" json:"Description,omitempty"`
}

func (m *ContextMetaFilter) Reset()                    { *m = ContextMetaFilter{} }
func (m *ContextMetaFilter) String() string            { return proto.CompactTextString(m) }
func (*ContextMetaFilter) ProtoMessage()               {}
func (*ContextMetaFilter) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *ContextMetaFilter) GetType() ContextMetaFilterType {
	if m != nil {
		return m.Type
	}
	return ContextMetaFilterType_RequestMeta
}

func (m *ContextMetaFilter) GetQuery() *service.Query {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *ContextMetaFilter) GetLabel() string {
	if m != nil {
		return m.Label
	}
	return ""
}

func (m *ContextMetaFilter) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

// ContextMetaSingleQuery uses idm.PolicyCondition
type ContextMetaSingleQuery struct {
	// Condition applies to FieldName
	FieldName string `protobuf:"bytes,1,opt,name=FieldName" json:"FieldName,omitempty"`
	// PolicyCondition
	Condition *idm.PolicyCondition `protobuf:"bytes,2,opt,name=Condition" json:"Condition,omitempty"`
}

func (m *ContextMetaSingleQuery) Reset()                    { *m = ContextMetaSingleQuery{} }
func (m *ContextMetaSingleQuery) String() string            { return proto.CompactTextString(m) }
func (*ContextMetaSingleQuery) ProtoMessage()               {}
func (*ContextMetaSingleQuery) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *ContextMetaSingleQuery) GetFieldName() string {
	if m != nil {
		return m.FieldName
	}
	return ""
}

func (m *ContextMetaSingleQuery) GetCondition() *idm.PolicyCondition {
	if m != nil {
		return m.Condition
	}
	return nil
}

type Schedule struct {
	// ISO 8601 Description of the scheduling for instance "R2/2015-06-04T19:25:16.828696-07:00/PT4S"
	// where first part is the number of repetitions (if 0, infinite repetition),
	// second part the starting date and last part, the duration between 2 occurrences.
	Iso8601Schedule string `protobuf:"bytes,1,opt,name=Iso8601Schedule" json:"Iso8601Schedule,omitempty"`
	// Minimum time between two runs
	Iso8601MinDelta string `protobuf:"bytes,3,opt,name=Iso8601MinDelta" json:"Iso8601MinDelta,omitempty"`
}

func (m *Schedule) Reset()                    { *m = Schedule{} }
func (m *Schedule) String() string            { return proto.CompactTextString(m) }
func (*Schedule) ProtoMessage()               {}
func (*Schedule) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *Schedule) GetIso8601Schedule() string {
	if m != nil {
		return m.Iso8601Schedule
	}
	return ""
}

func (m *Schedule) GetIso8601MinDelta() string {
	if m != nil {
		return m.Iso8601MinDelta
	}
	return ""
}

type Action struct {
	// String Identifier for specific action
	ID string `protobuf:"bytes,1,opt,name=ID" json:"ID,omitempty"`
	// User-defined label for this action
	Label string `protobuf:"bytes,13,opt,name=Label" json:"Label,omitempty"`
	// User-defined comment for this action
	Description string `protobuf:"bytes,14,opt,name=Description" json:"Description,omitempty"`
	// Bypass this action (forward input to output and do nothing)
	Bypass bool `protobuf:"varint,15,opt,name=Bypass" json:"Bypass,omitempty"`
	// Stop full chain now : do not carry on executing next actions
	BreakAfter bool `protobuf:"varint,16,opt,name=BreakAfter" json:"BreakAfter,omitempty"`
	// Nodes Selector
	NodesSelector *NodesSelector `protobuf:"bytes,2,opt,name=NodesSelector" json:"NodesSelector,omitempty"`
	// Users Selector (deprecated in favor of IdmSelector)
	UsersSelector *UsersSelector `protobuf:"bytes,3,opt,name=UsersSelector" json:"UsersSelector,omitempty"`
	// Node Filter
	NodesFilter *NodesSelector `protobuf:"bytes,4,opt,name=NodesFilter" json:"NodesFilter,omitempty"`
	// User Filter (deprecated in favor of IdmSelector)
	UsersFilter *UsersSelector `protobuf:"bytes,5,opt,name=UsersFilter" json:"UsersFilter,omitempty"`
	// Idm objects collector
	IdmSelector *IdmSelector `protobuf:"bytes,9,opt,name=IdmSelector" json:"IdmSelector,omitempty"`
	// Idm objects filter
	IdmFilter *IdmSelector `protobuf:"bytes,10,opt,name=IdmFilter" json:"IdmFilter,omitempty"`
	// DataSource objects collector
	DataSourceSelector *DataSourceSelector `protobuf:"bytes,17,opt,name=DataSourceSelector" json:"DataSourceSelector,omitempty"`
	// DataSource objects filter
	DataSourceFilter *DataSourceSelector `protobuf:"bytes,18,opt,name=DataSourceFilter" json:"DataSourceFilter,omitempty"`
	// Previous action output filter
	ActionOutputFilter *ActionOutputFilter `protobuf:"bytes,6,opt,name=ActionOutputFilter" json:"ActionOutputFilter,omitempty"`
	// Metadata policy-based filter
	ContextMetaFilter *ContextMetaFilter `protobuf:"bytes,11,opt,name=ContextMetaFilter" json:"ContextMetaFilter,omitempty"`
	// Filter on specific triggers
	TriggerFilter *TriggerFilter `protobuf:"bytes,19,opt,name=TriggerFilter" json:"TriggerFilter,omitempty"`
	// Defined parameters for this action
	Parameters map[string]string `protobuf:"bytes,7,rep,name=Parameters" json:"Parameters,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Other actions to perform after this one is finished,
	// using the Output of this action as Input for the next.
	// If there are many, it is considered they can be triggered
	// in parallel
	ChainedActions []*Action `protobuf:"bytes,8,rep,name=ChainedActions" json:"ChainedActions,omitempty"`
	// If any Filter is used, next actions can be triggered on Failure
	// This adds ability to create conditional Yes/No branches
	FailedFilterActions []*Action `protobuf:"bytes,12,rep,name=FailedFilterActions" json:"FailedFilterActions,omitempty"`
}

func (m *Action) Reset()                    { *m = Action{} }
func (m *Action) String() string            { return proto.CompactTextString(m) }
func (*Action) ProtoMessage()               {}
func (*Action) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *Action) GetID() string {
	if m != nil {
		return m.ID
	}
	return ""
}

func (m *Action) GetLabel() string {
	if m != nil {
		return m.Label
	}
	return ""
}

func (m *Action) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Action) GetBypass() bool {
	if m != nil {
		return m.Bypass
	}
	return false
}

func (m *Action) GetBreakAfter() bool {
	if m != nil {
		return m.BreakAfter
	}
	return false
}

func (m *Action) GetNodesSelector() *NodesSelector {
	if m != nil {
		return m.NodesSelector
	}
	return nil
}

func (m *Action) GetUsersSelector() *UsersSelector {
	if m != nil {
		return m.UsersSelector
	}
	return nil
}

func (m *Action) GetNodesFilter() *NodesSelector {
	if m != nil {
		return m.NodesFilter
	}
	return nil
}

func (m *Action) GetUsersFilter() *UsersSelector {
	if m != nil {
		return m.UsersFilter
	}
	return nil
}

func (m *Action) GetIdmSelector() *IdmSelector {
	if m != nil {
		return m.IdmSelector
	}
	return nil
}

func (m *Action) GetIdmFilter() *IdmSelector {
	if m != nil {
		return m.IdmFilter
	}
	return nil
}

func (m *Action) GetDataSourceSelector() *DataSourceSelector {
	if m != nil {
		return m.DataSourceSelector
	}
	return nil
}

func (m *Action) GetDataSourceFilter() *DataSourceSelector {
	if m != nil {
		return m.DataSourceFilter
	}
	return nil
}

func (m *Action) GetActionOutputFilter() *ActionOutputFilter {
	if m != nil {
		return m.ActionOutputFilter
	}
	return nil
}

func (m *Action) GetContextMetaFilter() *ContextMetaFilter {
	if m != nil {
		return m.ContextMetaFilter
	}
	return nil
}

func (m *Action) GetTriggerFilter() *TriggerFilter {
	if m != nil {
		return m.TriggerFilter
	}
	return nil
}

func (m *Action) GetParameters() map[string]string {
	if m != nil {
		return m.Parameters
	}
	return nil
}

func (m *Action) GetChainedActions() []*Action {
	if m != nil {
		return m.ChainedActions
	}
	return nil
}

func (m *Action) GetFailedFilterActions() []*Action {
	if m != nil {
		return m.FailedFilterActions
	}
	return nil
}

type Job struct {
	// Unique ID for this Job
	ID string `protobuf:"bytes,1,opt,name=ID" json:"ID,omitempty"`
	// Human-readable Label
	Label string `protobuf:"bytes,2,opt,name=Label" json:"Label,omitempty"`
	// Who created this Job
	Owner string `protobuf:"bytes,3,opt,name=Owner" json:"Owner,omitempty"`
	// Admin can temporarily disable this job
	Inactive bool `protobuf:"varint,4,opt,name=Inactive" json:"Inactive,omitempty"`
	// Job created by application or by administrator
	Custom bool `protobuf:"varint,20,opt,name=Custom" json:"Custom,omitempty"`
	// Optional list of languages detected in the context at launch time
	Languages []string `protobuf:"bytes,10,rep,name=Languages" json:"Languages,omitempty"`
	// How the job will be triggered.
	// One of these must be set (not exclusive)
	// Listen to a given set of events
	EventNames []string `protobuf:"bytes,5,rep,name=EventNames" json:"EventNames,omitempty"`
	// Schedule a periodic repetition
	Schedule *Schedule `protobuf:"bytes,6,opt,name=Schedule" json:"Schedule,omitempty"`
	// Start task as soon as job is inserted
	AutoStart bool `protobuf:"varint,7,opt,name=AutoStart" json:"AutoStart,omitempty"`
	// Remove job automatically once it is finished (success only)
	AutoClean bool `protobuf:"varint,11,opt,name=AutoClean" json:"AutoClean,omitempty"`
	// Chain of actions to perform
	Actions []*Action `protobuf:"bytes,8,rep,name=Actions" json:"Actions,omitempty"`
	// Task properties
	MaxConcurrency int32 `protobuf:"varint,9,opt,name=MaxConcurrency" json:"MaxConcurrency,omitempty"`
	// Do not send notification on task update
	TasksSilentUpdate bool `protobuf:"varint,12,opt,name=TasksSilentUpdate" json:"TasksSilentUpdate,omitempty"`
	// Filled with currently running tasks
	Tasks []*Task `protobuf:"bytes,14,rep,name=Tasks" json:"Tasks,omitempty"`
	// Filter out specific events
	NodeEventFilter *NodesSelector `protobuf:"bytes,15,opt,name=NodeEventFilter" json:"NodeEventFilter,omitempty"`
	// Deprecated in favor of more generic IdmSelector
	UserEventFilter *UsersSelector `protobuf:"bytes,16,opt,name=UserEventFilter" json:"UserEventFilter,omitempty"`
	// Idm objects filter
	IdmFilter *IdmSelector `protobuf:"bytes,17,opt,name=IdmFilter" json:"IdmFilter,omitempty"`
	// Event Context Filter
	ContextMetaFilter *ContextMetaFilter `protobuf:"bytes,18,opt,name=ContextMetaFilter" json:"ContextMetaFilter,omitempty"`
	// DataSource objects filter
	DataSourceFilter *DataSourceSelector `protobuf:"bytes,21,opt,name=DataSourceFilter" json:"DataSourceFilter,omitempty"`
	// Job-level parameters that can be passed to underlying actions
	Parameters []*JobParameter `protobuf:"bytes,19,rep,name=Parameters" json:"Parameters,omitempty"`
	// Additional dependencies that may be required when running the job
	ResourcesDependencies []*google_protobuf.Any `protobuf:"bytes,22,rep,name=ResourcesDependencies" json:"ResourcesDependencies,omitempty"`
}

func (m *Job) Reset()                    { *m = Job{} }
func (m *Job) String() string            { return proto.CompactTextString(m) }
func (*Job) ProtoMessage()               {}
func (*Job) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *Job) GetID() string {
	if m != nil {
		return m.ID
	}
	return ""
}

func (m *Job) GetLabel() string {
	if m != nil {
		return m.Label
	}
	return ""
}

func (m *Job) GetOwner() string {
	if m != nil {
		return m.Owner
	}
	return ""
}

func (m *Job) GetInactive() bool {
	if m != nil {
		return m.Inactive
	}
	return false
}

func (m *Job) GetCustom() bool {
	if m != nil {
		return m.Custom
	}
	return false
}

func (m *Job) GetLanguages() []string {
	if m != nil {
		return m.Languages
	}
	return nil
}

func (m *Job) GetEventNames() []string {
	if m != nil {
		return m.EventNames
	}
	return nil
}

func (m *Job) GetSchedule() *Schedule {
	if m != nil {
		return m.Schedule
	}
	return nil
}

func (m *Job) GetAutoStart() bool {
	if m != nil {
		return m.AutoStart
	}
	return false
}

func (m *Job) GetAutoClean() bool {
	if m != nil {
		return m.AutoClean
	}
	return false
}

func (m *Job) GetActions() []*Action {
	if m != nil {
		return m.Actions
	}
	return nil
}

func (m *Job) GetMaxConcurrency() int32 {
	if m != nil {
		return m.MaxConcurrency
	}
	return 0
}

func (m *Job) GetTasksSilentUpdate() bool {
	if m != nil {
		return m.TasksSilentUpdate
	}
	return false
}

func (m *Job) GetTasks() []*Task {
	if m != nil {
		return m.Tasks
	}
	return nil
}

func (m *Job) GetNodeEventFilter() *NodesSelector {
	if m != nil {
		return m.NodeEventFilter
	}
	return nil
}

func (m *Job) GetUserEventFilter() *UsersSelector {
	if m != nil {
		return m.UserEventFilter
	}
	return nil
}

func (m *Job) GetIdmFilter() *IdmSelector {
	if m != nil {
		return m.IdmFilter
	}
	return nil
}

func (m *Job) GetContextMetaFilter() *ContextMetaFilter {
	if m != nil {
		return m.ContextMetaFilter
	}
	return nil
}

func (m *Job) GetDataSourceFilter() *DataSourceSelector {
	if m != nil {
		return m.DataSourceFilter
	}
	return nil
}

func (m *Job) GetParameters() []*JobParameter {
	if m != nil {
		return m.Parameters
	}
	return nil
}

func (m *Job) GetResourcesDependencies() []*google_protobuf.Any {
	if m != nil {
		return m.ResourcesDependencies
	}
	return nil
}

type JobParameter struct {
	// Parameter name
	Name string `protobuf:"bytes,1,opt,name=Name" json:"Name,omitempty"`
	// Additional description
	Description string `protobuf:"bytes,2,opt,name=Description" json:"Description,omitempty"`
	// Value saved for this parameter
	Value string `protobuf:"bytes,4,opt,name=Value" json:"Value,omitempty"`
	// If mandatory, job cannot start without a value
	Mandatory bool `protobuf:"varint,3,opt,name=Mandatory" json:"Mandatory,omitempty"`
	// Parameter type used in GUI forms
	Type string `protobuf:"bytes,5,opt,name=Type" json:"Type,omitempty"`
	// Additional data used by GUI elements
	JsonChoices string `protobuf:"bytes,6,opt,name=JsonChoices" json:"JsonChoices,omitempty"`
}

func (m *JobParameter) Reset()                    { *m = JobParameter{} }
func (m *JobParameter) String() string            { return proto.CompactTextString(m) }
func (*JobParameter) ProtoMessage()               {}
func (*JobParameter) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *JobParameter) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *JobParameter) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *JobParameter) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

func (m *JobParameter) GetMandatory() bool {
	if m != nil {
		return m.Mandatory
	}
	return false
}

func (m *JobParameter) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *JobParameter) GetJsonChoices() string {
	if m != nil {
		return m.JsonChoices
	}
	return ""
}

// Events sent by the JobService when CRUD'ing a Job configuration
type JobChangeEvent struct {
	JobUpdated *Job   `protobuf:"bytes,1,opt,name=JobUpdated" json:"JobUpdated,omitempty"`
	JobRemoved string `protobuf:"bytes,2,opt,name=JobRemoved" json:"JobRemoved,omitempty"`
}

func (m *JobChangeEvent) Reset()                    { *m = JobChangeEvent{} }
func (m *JobChangeEvent) String() string            { return proto.CompactTextString(m) }
func (*JobChangeEvent) ProtoMessage()               {}
func (*JobChangeEvent) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *JobChangeEvent) GetJobUpdated() *Job {
	if m != nil {
		return m.JobUpdated
	}
	return nil
}

func (m *JobChangeEvent) GetJobRemoved() string {
	if m != nil {
		return m.JobRemoved
	}
	return ""
}

type TaskChangeEvent struct {
	TaskUpdated *Task `protobuf:"bytes,1,opt,name=TaskUpdated" json:"TaskUpdated,omitempty"`
	Job         *Job  `protobuf:"bytes,2,opt,name=Job" json:"Job,omitempty"`
}

func (m *TaskChangeEvent) Reset()                    { *m = TaskChangeEvent{} }
func (m *TaskChangeEvent) String() string            { return proto.CompactTextString(m) }
func (*TaskChangeEvent) ProtoMessage()               {}
func (*TaskChangeEvent) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *TaskChangeEvent) GetTaskUpdated() *Task {
	if m != nil {
		return m.TaskUpdated
	}
	return nil
}

func (m *TaskChangeEvent) GetJob() *Job {
	if m != nil {
		return m.Job
	}
	return nil
}

type PutJobRequest struct {
	Job *Job `protobuf:"bytes,1,opt,name=Job" json:"Job,omitempty"`
}

func (m *PutJobRequest) Reset()                    { *m = PutJobRequest{} }
func (m *PutJobRequest) String() string            { return proto.CompactTextString(m) }
func (*PutJobRequest) ProtoMessage()               {}
func (*PutJobRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *PutJobRequest) GetJob() *Job {
	if m != nil {
		return m.Job
	}
	return nil
}

type PutJobResponse struct {
	Job *Job `protobuf:"bytes,1,opt,name=Job" json:"Job,omitempty"`
}

func (m *PutJobResponse) Reset()                    { *m = PutJobResponse{} }
func (m *PutJobResponse) String() string            { return proto.CompactTextString(m) }
func (*PutJobResponse) ProtoMessage()               {}
func (*PutJobResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *PutJobResponse) GetJob() *Job {
	if m != nil {
		return m.Job
	}
	return nil
}

type GetJobRequest struct {
	JobID     string     `protobuf:"bytes,1,opt,name=JobID" json:"JobID,omitempty"`
	LoadTasks TaskStatus `protobuf:"varint,2,opt,name=LoadTasks,enum=jobs.TaskStatus" json:"LoadTasks,omitempty"`
}

func (m *GetJobRequest) Reset()                    { *m = GetJobRequest{} }
func (m *GetJobRequest) String() string            { return proto.CompactTextString(m) }
func (*GetJobRequest) ProtoMessage()               {}
func (*GetJobRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func (m *GetJobRequest) GetJobID() string {
	if m != nil {
		return m.JobID
	}
	return ""
}

func (m *GetJobRequest) GetLoadTasks() TaskStatus {
	if m != nil {
		return m.LoadTasks
	}
	return TaskStatus_Unknown
}

type GetJobResponse struct {
	Job *Job `protobuf:"bytes,1,opt,name=Job" json:"Job,omitempty"`
}

func (m *GetJobResponse) Reset()                    { *m = GetJobResponse{} }
func (m *GetJobResponse) String() string            { return proto.CompactTextString(m) }
func (*GetJobResponse) ProtoMessage()               {}
func (*GetJobResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func (m *GetJobResponse) GetJob() *Job {
	if m != nil {
		return m.Job
	}
	return nil
}

type DeleteJobRequest struct {
	JobID         string `protobuf:"bytes,1,opt,name=JobID" json:"JobID,omitempty"`
	CleanableJobs bool   `protobuf:"varint,2,opt,name=CleanableJobs" json:"CleanableJobs,omitempty"`
}

func (m *DeleteJobRequest) Reset()                    { *m = DeleteJobRequest{} }
func (m *DeleteJobRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteJobRequest) ProtoMessage()               {}
func (*DeleteJobRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{19} }

func (m *DeleteJobRequest) GetJobID() string {
	if m != nil {
		return m.JobID
	}
	return ""
}

func (m *DeleteJobRequest) GetCleanableJobs() bool {
	if m != nil {
		return m.CleanableJobs
	}
	return false
}

type DeleteJobResponse struct {
	Success     bool  `protobuf:"varint,1,opt,name=Success" json:"Success,omitempty"`
	DeleteCount int32 `protobuf:"varint,2,opt,name=DeleteCount" json:"DeleteCount,omitempty"`
}

func (m *DeleteJobResponse) Reset()                    { *m = DeleteJobResponse{} }
func (m *DeleteJobResponse) String() string            { return proto.CompactTextString(m) }
func (*DeleteJobResponse) ProtoMessage()               {}
func (*DeleteJobResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{20} }

func (m *DeleteJobResponse) GetSuccess() bool {
	if m != nil {
		return m.Success
	}
	return false
}

func (m *DeleteJobResponse) GetDeleteCount() int32 {
	if m != nil {
		return m.DeleteCount
	}
	return 0
}

type ListJobsRequest struct {
	// Restrict to a specific owner (current user by default)
	Owner string `protobuf:"bytes,1,opt,name=Owner" json:"Owner,omitempty"`
	// Filter with only event-based jobs
	EventsOnly bool `protobuf:"varint,2,opt,name=EventsOnly" json:"EventsOnly,omitempty"`
	// Filter with only timer-based jobs
	TimersOnly bool `protobuf:"varint,3,opt,name=TimersOnly" json:"TimersOnly,omitempty"`
	// Load tasks that correspond to the given TaskStatus
	LoadTasks TaskStatus `protobuf:"varint,4,opt,name=LoadTasks,enum=jobs.TaskStatus" json:"LoadTasks,omitempty"`
	// Load jobs by their ID
	JobIDs []string `protobuf:"bytes,5,rep,name=JobIDs" json:"JobIDs,omitempty"`
	// Start listing at a given position
	TasksOffset int32 `protobuf:"varint,6,opt,name=TasksOffset" json:"TasksOffset,omitempty"`
	// Lmit the number of results
	TasksLimit int32 `protobuf:"varint,7,opt,name=TasksLimit" json:"TasksLimit,omitempty"`
}

func (m *ListJobsRequest) Reset()                    { *m = ListJobsRequest{} }
func (m *ListJobsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListJobsRequest) ProtoMessage()               {}
func (*ListJobsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{21} }

func (m *ListJobsRequest) GetOwner() string {
	if m != nil {
		return m.Owner
	}
	return ""
}

func (m *ListJobsRequest) GetEventsOnly() bool {
	if m != nil {
		return m.EventsOnly
	}
	return false
}

func (m *ListJobsRequest) GetTimersOnly() bool {
	if m != nil {
		return m.TimersOnly
	}
	return false
}

func (m *ListJobsRequest) GetLoadTasks() TaskStatus {
	if m != nil {
		return m.LoadTasks
	}
	return TaskStatus_Unknown
}

func (m *ListJobsRequest) GetJobIDs() []string {
	if m != nil {
		return m.JobIDs
	}
	return nil
}

func (m *ListJobsRequest) GetTasksOffset() int32 {
	if m != nil {
		return m.TasksOffset
	}
	return 0
}

func (m *ListJobsRequest) GetTasksLimit() int32 {
	if m != nil {
		return m.TasksLimit
	}
	return 0
}

type ListJobsResponse struct {
	Job *Job `protobuf:"bytes,1,opt,name=Job" json:"Job,omitempty"`
}

func (m *ListJobsResponse) Reset()                    { *m = ListJobsResponse{} }
func (m *ListJobsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListJobsResponse) ProtoMessage()               {}
func (*ListJobsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{22} }

func (m *ListJobsResponse) GetJob() *Job {
	if m != nil {
		return m.Job
	}
	return nil
}

type ListTasksRequest struct {
	// List tasks for the job with this Id
	JobID string `protobuf:"bytes,1,opt,name=JobID" json:"JobID,omitempty"`
	// List only tasks with this Status
	Status TaskStatus `protobuf:"varint,2,opt,name=Status,enum=jobs.TaskStatus" json:"Status,omitempty"`
}

func (m *ListTasksRequest) Reset()                    { *m = ListTasksRequest{} }
func (m *ListTasksRequest) String() string            { return proto.CompactTextString(m) }
func (*ListTasksRequest) ProtoMessage()               {}
func (*ListTasksRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{23} }

func (m *ListTasksRequest) GetJobID() string {
	if m != nil {
		return m.JobID
	}
	return ""
}

func (m *ListTasksRequest) GetStatus() TaskStatus {
	if m != nil {
		return m.Status
	}
	return TaskStatus_Unknown
}

type ListTasksResponse struct {
	Task *Task `protobuf:"bytes,1,opt,name=Task" json:"Task,omitempty"`
}

func (m *ListTasksResponse) Reset()                    { *m = ListTasksResponse{} }
func (m *ListTasksResponse) String() string            { return proto.CompactTextString(m) }
func (*ListTasksResponse) ProtoMessage()               {}
func (*ListTasksResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{24} }

func (m *ListTasksResponse) GetTask() *Task {
	if m != nil {
		return m.Task
	}
	return nil
}

type PutTaskRequest struct {
	Task *Task `protobuf:"bytes,1,opt,name=Task" json:"Task,omitempty"`
}

func (m *PutTaskRequest) Reset()                    { *m = PutTaskRequest{} }
func (m *PutTaskRequest) String() string            { return proto.CompactTextString(m) }
func (*PutTaskRequest) ProtoMessage()               {}
func (*PutTaskRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{25} }

func (m *PutTaskRequest) GetTask() *Task {
	if m != nil {
		return m.Task
	}
	return nil
}

type PutTaskResponse struct {
	Task *Task `protobuf:"bytes,1,opt,name=Task" json:"Task,omitempty"`
}

func (m *PutTaskResponse) Reset()                    { *m = PutTaskResponse{} }
func (m *PutTaskResponse) String() string            { return proto.CompactTextString(m) }
func (*PutTaskResponse) ProtoMessage()               {}
func (*PutTaskResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{26} }

func (m *PutTaskResponse) GetTask() *Task {
	if m != nil {
		return m.Task
	}
	return nil
}

type DeleteTasksRequest struct {
	// Id of the job
	JobId string `protobuf:"bytes,1,opt,name=JobId" json:"JobId,omitempty"`
	// Ids of tasks to delete
	TaskID []string `protobuf:"bytes,2,rep,name=TaskID" json:"TaskID,omitempty"`
	// If no TaskID and/or no JobID are passed, delete tasks by status
	Status []TaskStatus `protobuf:"varint,3,rep,packed,name=Status,enum=jobs.TaskStatus" json:"Status,omitempty"`
	// If deleting by status, optionally keep only a number of tasks
	PruneLimit int32 `protobuf:"varint,4,opt,name=PruneLimit" json:"PruneLimit,omitempty"`
}

func (m *DeleteTasksRequest) Reset()                    { *m = DeleteTasksRequest{} }
func (m *DeleteTasksRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteTasksRequest) ProtoMessage()               {}
func (*DeleteTasksRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{27} }

func (m *DeleteTasksRequest) GetJobId() string {
	if m != nil {
		return m.JobId
	}
	return ""
}

func (m *DeleteTasksRequest) GetTaskID() []string {
	if m != nil {
		return m.TaskID
	}
	return nil
}

func (m *DeleteTasksRequest) GetStatus() []TaskStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

func (m *DeleteTasksRequest) GetPruneLimit() int32 {
	if m != nil {
		return m.PruneLimit
	}
	return 0
}

type DeleteTasksResponse struct {
	Deleted []string `protobuf:"bytes,1,rep,name=Deleted" json:"Deleted,omitempty"`
}

func (m *DeleteTasksResponse) Reset()                    { *m = DeleteTasksResponse{} }
func (m *DeleteTasksResponse) String() string            { return proto.CompactTextString(m) }
func (*DeleteTasksResponse) ProtoMessage()               {}
func (*DeleteTasksResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{28} }

func (m *DeleteTasksResponse) GetDeleted() []string {
	if m != nil {
		return m.Deleted
	}
	return nil
}

type DetectStuckTasksRequest struct {
	Since int32 `protobuf:"varint,1,opt,name=Since" json:"Since,omitempty"`
}

func (m *DetectStuckTasksRequest) Reset()                    { *m = DetectStuckTasksRequest{} }
func (m *DetectStuckTasksRequest) String() string            { return proto.CompactTextString(m) }
func (*DetectStuckTasksRequest) ProtoMessage()               {}
func (*DetectStuckTasksRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{29} }

func (m *DetectStuckTasksRequest) GetSince() int32 {
	if m != nil {
		return m.Since
	}
	return 0
}

type DetectStuckTasksResponse struct {
	FixedTaskIds []string `protobuf:"bytes,1,rep,name=FixedTaskIds" json:"FixedTaskIds,omitempty"`
}

func (m *DetectStuckTasksResponse) Reset()                    { *m = DetectStuckTasksResponse{} }
func (m *DetectStuckTasksResponse) String() string            { return proto.CompactTextString(m) }
func (*DetectStuckTasksResponse) ProtoMessage()               {}
func (*DetectStuckTasksResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{30} }

func (m *DetectStuckTasksResponse) GetFixedTaskIds() []string {
	if m != nil {
		return m.FixedTaskIds
	}
	return nil
}

type Task struct {
	ID            string     `protobuf:"bytes,1,opt,name=ID" json:"ID,omitempty"`
	JobID         string     `protobuf:"bytes,2,opt,name=JobID" json:"JobID,omitempty"`
	Status        TaskStatus `protobuf:"varint,3,opt,name=Status,enum=jobs.TaskStatus" json:"Status,omitempty"`
	StatusMessage string     `protobuf:"bytes,4,opt,name=StatusMessage" json:"StatusMessage,omitempty"`
	TriggerOwner  string     `protobuf:"bytes,5,opt,name=TriggerOwner" json:"TriggerOwner,omitempty"`
	StartTime     int32      `protobuf:"varint,6,opt,name=StartTime" json:"StartTime,omitempty"`
	EndTime       int32      `protobuf:"varint,7,opt,name=EndTime" json:"EndTime,omitempty"`
	// Can be interrupted
	CanStop bool `protobuf:"varint,8,opt,name=CanStop" json:"CanStop,omitempty"`
	// Can be paused/resumed
	CanPause bool `protobuf:"varint,9,opt,name=CanPause" json:"CanPause,omitempty"`
	// Tasks publish a progress
	HasProgress bool `protobuf:"varint,10,opt,name=HasProgress" json:"HasProgress,omitempty"`
	// Float value of the progress between 0 and 1
	Progress float32 `protobuf:"fixed32,11,opt,name=Progress" json:"Progress,omitempty"`
	// Logs of all the actions performed
	ActionsLogs []*ActionLog `protobuf:"bytes,12,rep,name=ActionsLogs" json:"ActionsLogs,omitempty"`
}

func (m *Task) Reset()                    { *m = Task{} }
func (m *Task) String() string            { return proto.CompactTextString(m) }
func (*Task) ProtoMessage()               {}
func (*Task) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{31} }

func (m *Task) GetID() string {
	if m != nil {
		return m.ID
	}
	return ""
}

func (m *Task) GetJobID() string {
	if m != nil {
		return m.JobID
	}
	return ""
}

func (m *Task) GetStatus() TaskStatus {
	if m != nil {
		return m.Status
	}
	return TaskStatus_Unknown
}

func (m *Task) GetStatusMessage() string {
	if m != nil {
		return m.StatusMessage
	}
	return ""
}

func (m *Task) GetTriggerOwner() string {
	if m != nil {
		return m.TriggerOwner
	}
	return ""
}

func (m *Task) GetStartTime() int32 {
	if m != nil {
		return m.StartTime
	}
	return 0
}

func (m *Task) GetEndTime() int32 {
	if m != nil {
		return m.EndTime
	}
	return 0
}

func (m *Task) GetCanStop() bool {
	if m != nil {
		return m.CanStop
	}
	return false
}

func (m *Task) GetCanPause() bool {
	if m != nil {
		return m.CanPause
	}
	return false
}

func (m *Task) GetHasProgress() bool {
	if m != nil {
		return m.HasProgress
	}
	return false
}

func (m *Task) GetProgress() float32 {
	if m != nil {
		return m.Progress
	}
	return 0
}

func (m *Task) GetActionsLogs() []*ActionLog {
	if m != nil {
		return m.ActionsLogs
	}
	return nil
}

// Command sent to control a job or a task
type CtrlCommand struct {
	// Type of command to send (None, Pause, Resume, Stop, Delete, RunOnce, Inactive, Active)
	Cmd Command `protobuf:"varint,1,opt,name=Cmd,enum=jobs.Command" json:"Cmd,omitempty"`
	// Id of the job
	JobId string `protobuf:"bytes,2,opt,name=JobId" json:"JobId,omitempty"`
	// Id of the associated task
	TaskId string `protobuf:"bytes,3,opt,name=TaskId" json:"TaskId,omitempty"`
	// Owner of the job
	OwnerId string `protobuf:"bytes,4,opt,name=OwnerId" json:"OwnerId,omitempty"`
	// Parameters used for RunOnce command
	RunParameters map[string]string `protobuf:"bytes,5,rep,name=RunParameters" json:"RunParameters,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *CtrlCommand) Reset()                    { *m = CtrlCommand{} }
func (m *CtrlCommand) String() string            { return proto.CompactTextString(m) }
func (*CtrlCommand) ProtoMessage()               {}
func (*CtrlCommand) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{32} }

func (m *CtrlCommand) GetCmd() Command {
	if m != nil {
		return m.Cmd
	}
	return Command_None
}

func (m *CtrlCommand) GetJobId() string {
	if m != nil {
		return m.JobId
	}
	return ""
}

func (m *CtrlCommand) GetTaskId() string {
	if m != nil {
		return m.TaskId
	}
	return ""
}

func (m *CtrlCommand) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *CtrlCommand) GetRunParameters() map[string]string {
	if m != nil {
		return m.RunParameters
	}
	return nil
}

// Response to the CtrlCommand
type CtrlCommandResponse struct {
	Msg string `protobuf:"bytes,1,opt,name=Msg" json:"Msg,omitempty"`
}

func (m *CtrlCommandResponse) Reset()                    { *m = CtrlCommandResponse{} }
func (m *CtrlCommandResponse) String() string            { return proto.CompactTextString(m) }
func (*CtrlCommandResponse) ProtoMessage()               {}
func (*CtrlCommandResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{33} }

func (m *CtrlCommandResponse) GetMsg() string {
	if m != nil {
		return m.Msg
	}
	return ""
}

type ActionLog struct {
	Action        *Action        `protobuf:"bytes,1,opt,name=Action" json:"Action,omitempty"`
	InputMessage  *ActionMessage `protobuf:"bytes,2,opt,name=InputMessage" json:"InputMessage,omitempty"`
	OutputMessage *ActionMessage `protobuf:"bytes,3,opt,name=OutputMessage" json:"OutputMessage,omitempty"`
}

func (m *ActionLog) Reset()                    { *m = ActionLog{} }
func (m *ActionLog) String() string            { return proto.CompactTextString(m) }
func (*ActionLog) ProtoMessage()               {}
func (*ActionLog) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{34} }

func (m *ActionLog) GetAction() *Action {
	if m != nil {
		return m.Action
	}
	return nil
}

func (m *ActionLog) GetInputMessage() *ActionMessage {
	if m != nil {
		return m.InputMessage
	}
	return nil
}

func (m *ActionLog) GetOutputMessage() *ActionMessage {
	if m != nil {
		return m.OutputMessage
	}
	return nil
}

// Simple Event sent by the timer service to trigger a JobID at a given time
// or to trigger a run now, with optional parameters
type JobTriggerEvent struct {
	// Id of the Job
	JobID string `protobuf:"bytes,1,opt,name=JobID" json:"JobID,omitempty"`
	// Schedule
	Schedule *Schedule `protobuf:"bytes,2,opt,name=Schedule" json:"Schedule,omitempty"`
	// Start job now
	RunNow bool `protobuf:"varint,3,opt,name=RunNow" json:"RunNow,omitempty"`
	// Impose the task unique ID for this run
	RunTaskId string `protobuf:"bytes,4,opt,name=RunTaskId" json:"RunTaskId,omitempty"`
	// Use specific parameters values for this run
	RunParameters map[string]string `protobuf:"bytes,5,rep,name=RunParameters" json:"RunParameters,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *JobTriggerEvent) Reset()                    { *m = JobTriggerEvent{} }
func (m *JobTriggerEvent) String() string            { return proto.CompactTextString(m) }
func (*JobTriggerEvent) ProtoMessage()               {}
func (*JobTriggerEvent) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{35} }

func (m *JobTriggerEvent) GetJobID() string {
	if m != nil {
		return m.JobID
	}
	return ""
}

func (m *JobTriggerEvent) GetSchedule() *Schedule {
	if m != nil {
		return m.Schedule
	}
	return nil
}

func (m *JobTriggerEvent) GetRunNow() bool {
	if m != nil {
		return m.RunNow
	}
	return false
}

func (m *JobTriggerEvent) GetRunTaskId() string {
	if m != nil {
		return m.RunTaskId
	}
	return ""
}

func (m *JobTriggerEvent) GetRunParameters() map[string]string {
	if m != nil {
		return m.RunParameters
	}
	return nil
}

// Standard output of an action. Success value is required
// other are optional
type ActionOutput struct {
	// True if action succeeded
	Success bool `protobuf:"varint,1,opt,name=Success" json:"Success,omitempty"`
	// Arbitrary bytes sequence
	RawBody []byte `protobuf:"bytes,2,opt,name=RawBody,proto3" json:"RawBody,omitempty"`
	// Arbitrary string
	StringBody string `protobuf:"bytes,3,opt,name=StringBody" json:"StringBody,omitempty"`
	// Arbitrary JSON-encoded bytes
	JsonBody []byte `protobuf:"bytes,4,opt,name=JsonBody,proto3" json:"JsonBody,omitempty"`
	// Error
	ErrorString string `protobuf:"bytes,5,opt,name=ErrorString" json:"ErrorString,omitempty"`
	// If action was returned WithIgnore()
	Ignored bool `protobuf:"varint,6,opt,name=Ignored" json:"Ignored,omitempty"`
	// Time taken to run the action
	Time int32 `protobuf:"varint,7,opt,name=Time" json:"Time,omitempty"`
}

func (m *ActionOutput) Reset()                    { *m = ActionOutput{} }
func (m *ActionOutput) String() string            { return proto.CompactTextString(m) }
func (*ActionOutput) ProtoMessage()               {}
func (*ActionOutput) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{36} }

func (m *ActionOutput) GetSuccess() bool {
	if m != nil {
		return m.Success
	}
	return false
}

func (m *ActionOutput) GetRawBody() []byte {
	if m != nil {
		return m.RawBody
	}
	return nil
}

func (m *ActionOutput) GetStringBody() string {
	if m != nil {
		return m.StringBody
	}
	return ""
}

func (m *ActionOutput) GetJsonBody() []byte {
	if m != nil {
		return m.JsonBody
	}
	return nil
}

func (m *ActionOutput) GetErrorString() string {
	if m != nil {
		return m.ErrorString
	}
	return ""
}

func (m *ActionOutput) GetIgnored() bool {
	if m != nil {
		return m.Ignored
	}
	return false
}

func (m *ActionOutput) GetTime() int32 {
	if m != nil {
		return m.Time
	}
	return 0
}

// ActionOutputSingleQuery provides a unitary query to filter ActionOutput messages
type ActionOutputSingleQuery struct {
	// Check if ActionOutput has success
	IsSuccess bool `protobuf:"varint,1,opt,name=IsSuccess" json:"IsSuccess,omitempty"`
	// Occurrence of string in StringBody or JsonBody (as string)
	StringBodyRegexp string `protobuf:"bytes,2,opt,name=StringBodyRegexp" json:"StringBodyRegexp,omitempty"`
	// StringBody or JsonBody size bigger than
	StringBodySizeGreaterThan int32 `protobuf:"varint,3,opt,name=StringBodySizeGreaterThan" json:"StringBodySizeGreaterThan,omitempty"`
	// StringBody or JsonBody size smaller than
	StringBodySizeSmallerThan int32 `protobuf:"varint,4,opt,name=StringBodySizeSmallerThan" json:"StringBodySizeSmallerThan,omitempty"`
	// Exact match of StringBody or JsonBody (as string)
	JsonBodyRegexp string `protobuf:"bytes,5,opt,name=JsonBodyRegexp" json:"JsonBodyRegexp,omitempty"`
	// Check existence of key in json body
	JsonBodyHasKey string `protobuf:"bytes,6,opt,name=JsonBodyHasKey" json:"JsonBodyHasKey,omitempty"`
	// StringBody or JsonBody size bigger than
	JsonBodySizeGreaterThan int32 `protobuf:"varint,7,opt,name=JsonBodySizeGreaterThan" json:"JsonBodySizeGreaterThan,omitempty"`
	// StringBody or JsonBody size smaller than
	JsonBodySizeSmallerThan int32 `protobuf:"varint,8,opt,name=JsonBodySizeSmallerThan" json:"JsonBodySizeSmallerThan,omitempty"`
	// Time taken greater than
	TaskTimeGt int32 `protobuf:"varint,9,opt,name=TaskTimeGt" json:"TaskTimeGt,omitempty"`
	// Time taken shorter than
	TaskTimeLt int32 `protobuf:"varint,10,opt,name=TaskTimeLt" json:"TaskTimeLt,omitempty"`
	// Check occurrence on error string
	ErrorStringRegexp string `protobuf:"bytes,11,opt,name=ErrorStringRegexp" json:"ErrorStringRegexp,omitempty"`
	// FreeCondition can be built using templates or gval
	FreeCondition string `protobuf:"bytes,13,opt,name=FreeCondition" json:"FreeCondition,omitempty"`
	// Invert condition
	Not bool `protobuf:"varint,12,opt,name=Not" json:"Not,omitempty"`
}

func (m *ActionOutputSingleQuery) Reset()                    { *m = ActionOutputSingleQuery{} }
func (m *ActionOutputSingleQuery) String() string            { return proto.CompactTextString(m) }
func (*ActionOutputSingleQuery) ProtoMessage()               {}
func (*ActionOutputSingleQuery) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{37} }

func (m *ActionOutputSingleQuery) GetIsSuccess() bool {
	if m != nil {
		return m.IsSuccess
	}
	return false
}

func (m *ActionOutputSingleQuery) GetStringBodyRegexp() string {
	if m != nil {
		return m.StringBodyRegexp
	}
	return ""
}

func (m *ActionOutputSingleQuery) GetStringBodySizeGreaterThan() int32 {
	if m != nil {
		return m.StringBodySizeGreaterThan
	}
	return 0
}

func (m *ActionOutputSingleQuery) GetStringBodySizeSmallerThan() int32 {
	if m != nil {
		return m.StringBodySizeSmallerThan
	}
	return 0
}

func (m *ActionOutputSingleQuery) GetJsonBodyRegexp() string {
	if m != nil {
		return m.JsonBodyRegexp
	}
	return ""
}

func (m *ActionOutputSingleQuery) GetJsonBodyHasKey() string {
	if m != nil {
		return m.JsonBodyHasKey
	}
	return ""
}

func (m *ActionOutputSingleQuery) GetJsonBodySizeGreaterThan() int32 {
	if m != nil {
		return m.JsonBodySizeGreaterThan
	}
	return 0
}

func (m *ActionOutputSingleQuery) GetJsonBodySizeSmallerThan() int32 {
	if m != nil {
		return m.JsonBodySizeSmallerThan
	}
	return 0
}

func (m *ActionOutputSingleQuery) GetTaskTimeGt() int32 {
	if m != nil {
		return m.TaskTimeGt
	}
	return 0
}

func (m *ActionOutputSingleQuery) GetTaskTimeLt() int32 {
	if m != nil {
		return m.TaskTimeLt
	}
	return 0
}

func (m *ActionOutputSingleQuery) GetErrorStringRegexp() string {
	if m != nil {
		return m.ErrorStringRegexp
	}
	return ""
}

func (m *ActionOutputSingleQuery) GetFreeCondition() string {
	if m != nil {
		return m.FreeCondition
	}
	return ""
}

func (m *ActionOutputSingleQuery) GetNot() bool {
	if m != nil {
		return m.Not
	}
	return false
}

// Message passed along from one action to another, main properties
// are modified by the various actions.
// OutputChain is being stacked up when passing through actions
type ActionMessage struct {
	// Initial event that triggered the Job
	Event *google_protobuf.Any `protobuf:"bytes,1,opt,name=Event" json:"Event,omitempty"`
	// One or more Node
	Nodes []*tree.Node `protobuf:"bytes,2,rep,name=Nodes" json:"Nodes,omitempty"`
	// One or more User
	Users []*idm.User `protobuf:"bytes,3,rep,name=Users" json:"Users,omitempty"`
	// One or more Role
	Roles []*idm.Role `protobuf:"bytes,6,rep,name=Roles" json:"Roles,omitempty"`
	// One or more Workspace
	Workspaces []*idm.Workspace `protobuf:"bytes,7,rep,name=Workspaces" json:"Workspaces,omitempty"`
	// One or more ACL
	Acls []*idm.ACL `protobuf:"bytes,8,rep,name=Acls" json:"Acls,omitempty"`
	// One or more Activity
	Activities []*activity.Object `protobuf:"bytes,4,rep,name=Activities" json:"Activities,omitempty"`
	// One or more DataSource
	DataSources []*object.DataSource `protobuf:"bytes,9,rep,name=DataSources" json:"DataSources,omitempty"`
	// Stack of ActionOutput messages appended by all previous actions
	OutputChain []*ActionOutput `protobuf:"bytes,5,rep,name=OutputChain" json:"OutputChain,omitempty"`
}

func (m *ActionMessage) Reset()                    { *m = ActionMessage{} }
func (m *ActionMessage) String() string            { return proto.CompactTextString(m) }
func (*ActionMessage) ProtoMessage()               {}
func (*ActionMessage) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{38} }

func (m *ActionMessage) GetEvent() *google_protobuf.Any {
	if m != nil {
		return m.Event
	}
	return nil
}

func (m *ActionMessage) GetNodes() []*tree.Node {
	if m != nil {
		return m.Nodes
	}
	return nil
}

func (m *ActionMessage) GetUsers() []*idm.User {
	if m != nil {
		return m.Users
	}
	return nil
}

func (m *ActionMessage) GetRoles() []*idm.Role {
	if m != nil {
		return m.Roles
	}
	return nil
}

func (m *ActionMessage) GetWorkspaces() []*idm.Workspace {
	if m != nil {
		return m.Workspaces
	}
	return nil
}

func (m *ActionMessage) GetAcls() []*idm.ACL {
	if m != nil {
		return m.Acls
	}
	return nil
}

func (m *ActionMessage) GetActivities() []*activity.Object {
	if m != nil {
		return m.Activities
	}
	return nil
}

func (m *ActionMessage) GetDataSources() []*object.DataSource {
	if m != nil {
		return m.DataSources
	}
	return nil
}

func (m *ActionMessage) GetOutputChain() []*ActionOutput {
	if m != nil {
		return m.OutputChain
	}
	return nil
}

func init() {
	proto.RegisterType((*NodesSelector)(nil), "jobs.NodesSelector")
	proto.RegisterType((*IdmSelector)(nil), "jobs.IdmSelector")
	proto.RegisterType((*UsersSelector)(nil), "jobs.UsersSelector")
	proto.RegisterType((*DataSourceSelector)(nil), "jobs.DataSourceSelector")
	proto.RegisterType((*TriggerFilterQuery)(nil), "jobs.TriggerFilterQuery")
	proto.RegisterType((*TriggerFilter)(nil), "jobs.TriggerFilter")
	proto.RegisterType((*ActionOutputFilter)(nil), "jobs.ActionOutputFilter")
	proto.RegisterType((*ContextMetaFilter)(nil), "jobs.ContextMetaFilter")
	proto.RegisterType((*ContextMetaSingleQuery)(nil), "jobs.ContextMetaSingleQuery")
	proto.RegisterType((*Schedule)(nil), "jobs.Schedule")
	proto.RegisterType((*Action)(nil), "jobs.Action")
	proto.RegisterType((*Job)(nil), "jobs.Job")
	proto.RegisterType((*JobParameter)(nil), "jobs.JobParameter")
	proto.RegisterType((*JobChangeEvent)(nil), "jobs.JobChangeEvent")
	proto.RegisterType((*TaskChangeEvent)(nil), "jobs.TaskChangeEvent")
	proto.RegisterType((*PutJobRequest)(nil), "jobs.PutJobRequest")
	proto.RegisterType((*PutJobResponse)(nil), "jobs.PutJobResponse")
	proto.RegisterType((*GetJobRequest)(nil), "jobs.GetJobRequest")
	proto.RegisterType((*GetJobResponse)(nil), "jobs.GetJobResponse")
	proto.RegisterType((*DeleteJobRequest)(nil), "jobs.DeleteJobRequest")
	proto.RegisterType((*DeleteJobResponse)(nil), "jobs.DeleteJobResponse")
	proto.RegisterType((*ListJobsRequest)(nil), "jobs.ListJobsRequest")
	proto.RegisterType((*ListJobsResponse)(nil), "jobs.ListJobsResponse")
	proto.RegisterType((*ListTasksRequest)(nil), "jobs.ListTasksRequest")
	proto.RegisterType((*ListTasksResponse)(nil), "jobs.ListTasksResponse")
	proto.RegisterType((*PutTaskRequest)(nil), "jobs.PutTaskRequest")
	proto.RegisterType((*PutTaskResponse)(nil), "jobs.PutTaskResponse")
	proto.RegisterType((*DeleteTasksRequest)(nil), "jobs.DeleteTasksRequest")
	proto.RegisterType((*DeleteTasksResponse)(nil), "jobs.DeleteTasksResponse")
	proto.RegisterType((*DetectStuckTasksRequest)(nil), "jobs.DetectStuckTasksRequest")
	proto.RegisterType((*DetectStuckTasksResponse)(nil), "jobs.DetectStuckTasksResponse")
	proto.RegisterType((*Task)(nil), "jobs.Task")
	proto.RegisterType((*CtrlCommand)(nil), "jobs.CtrlCommand")
	proto.RegisterType((*CtrlCommandResponse)(nil), "jobs.CtrlCommandResponse")
	proto.RegisterType((*ActionLog)(nil), "jobs.ActionLog")
	proto.RegisterType((*JobTriggerEvent)(nil), "jobs.JobTriggerEvent")
	proto.RegisterType((*ActionOutput)(nil), "jobs.ActionOutput")
	proto.RegisterType((*ActionOutputSingleQuery)(nil), "jobs.ActionOutputSingleQuery")
	proto.RegisterType((*ActionMessage)(nil), "jobs.ActionMessage")
	proto.RegisterEnum("jobs.IdmSelectorType", IdmSelectorType_name, IdmSelectorType_value)
	proto.RegisterEnum("jobs.DataSourceSelectorType", DataSourceSelectorType_name, DataSourceSelectorType_value)
	proto.RegisterEnum("jobs.ContextMetaFilterType", ContextMetaFilterType_name, ContextMetaFilterType_value)
	proto.RegisterEnum("jobs.TaskStatus", TaskStatus_name, TaskStatus_value)
	proto.RegisterEnum("jobs.Command", Command_name, Command_value)
}

func init() { proto.RegisterFile("jobs.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 2817 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x59, 0xcd, 0x8f, 0xdc, 0x48,
	0x15, 0x8f, 0xfb, 0xbb, 0x5f, 0xcf, 0x87, 0xa7, 0x32, 0x99, 0x78, 0x67, 0xc3, 0x6e, 0x64, 0x45,
	0xcb, 0xec, 0x68, 0xe9, 0x49, 0x26, 0xbb, 0x6c, 0x82, 0x36, 0xab, 0x9d, 0xf4, 0x24, 0x9b, 0x1e,
	0xe6, 0x6b, 0xab, 0x13, 0x38, 0x80, 0x90, 0xdc, 0xed, 0x4a, 0x8f, 0x77, 0xdc, 0xe5, 0xc6, 0x2e,
	0x27, 0x69, 0xb8, 0x72, 0x83, 0xff, 0x80, 0x13, 0x48, 0x5c, 0x91, 0xb8, 0x72, 0xe4, 0xc6, 0x05,
	0x21, 0xfe, 0x13, 0x4e, 0x1c, 0x41, 0xf5, 0x61, 0xbb, 0xec, 0x76, 0x77, 0x26, 0x08, 0x71, 0x48,
	0xa6, 0xeb, 0xf7, 0xde, 0xab, 0x7a, 0xef, 0xd5, 0xab, 0x57, 0xef, 0x95, 0x01, 0xbe, 0x0d, 0x86,
	0x51, 0x77, 0x1a, 0x06, 0x2c, 0x40, 0x35, 0xfe, 0x7b, 0xfb, 0xbd, 0x71, 0x10, 0x8c, 0x7d, 0xb2,
	0x27, 0xb0, 0x61, 0xfc, 0x72, 0xcf, 0xa1, 0x33, 0xc9, 0xb0, 0xfd, 0x60, 0xec, 0xb1, 0x8b, 0x78,
	0xd8, 0x1d, 0x05, 0x93, 0xbd, 0xe9, 0xcc, 0xf5, 0x82, 0xbd, 0x11, 0xf1, 0xfd, 0x68, 0x6f, 0x14,
	0x4c, 0x26, 0x01, 0xdd, 0x8b, 0x48, 0xf8, 0xca, 0x1b, 0x29, 0x49, 0x05, 0x2a, 0xc9, 0xfb, 0xcb,
	0x25, 0xa5, 0x04, 0x0b, 0x09, 0x11, 0xff, 0x29, 0xa1, 0x7b, 0x57, 0x11, 0xf2, 0xdc, 0x09, 0xff,
	0xa7, 0x44, 0x0e, 0xae, 0x22, 0xe2, 0x8c, 0x98, 0xf7, 0xca, 0x63, 0xb3, 0xf4, 0x47, 0xc4, 0x42,
	0xe2, 0x24, 0x53, 0x7c, 0x7e, 0x95, 0x29, 0x82, 0xe1, 0xb7, 0x64, 0xc4, 0xd4, 0x1f, 0x29, 0x68,
	0xff, 0xc9, 0x80, 0xd5, 0xd3, 0xc0, 0x25, 0xd1, 0x80, 0xf8, 0x64, 0xc4, 0x82, 0x10, 0x99, 0x50,
	0x3d, 0xf0, 0x7d, 0xcb, 0xb8, 0x6d, 0xec, 0xb4, 0x30, 0xff, 0x89, 0xb6, 0xa0, 0x71, 0xee, 0xb0,
	0x0b, 0x12, 0x59, 0x95, 0xdb, 0xd5, 0x9d, 0x36, 0x56, 0x23, 0x74, 0x07, 0xea, 0xdf, 0xc4, 0x24,
	0x9c, 0x59, 0xb5, 0xdb, 0xc6, 0x4e, 0x67, 0x7f, 0xad, 0xab, 0x7c, 0xd9, 0x15, 0x28, 0x96, 0x44,
	0x64, 0x41, 0xb3, 0x17, 0xf8, 0x7c, 0x72, 0xab, 0x2e, 0xe6, 0x4c, 0x86, 0x68, 0x13, 0xea, 0xc7,
	0xce, 0x90, 0xf8, 0x56, 0xe3, 0xb6, 0xb1, 0xd3, 0xc6, 0x72, 0x80, 0x6e, 0x43, 0xe7, 0x90, 0x44,
	0xa3, 0xd0, 0x9b, 0x32, 0x2f, 0xa0, 0x56, 0x53, 0xd0, 0x74, 0xc8, 0xfe, 0x8b, 0x01, 0x9d, 0xbe,
	0x3b, 0x49, 0x35, 0xfe, 0x18, 0x6a, 0xcf, 0x67, 0x53, 0x22, 0x54, 0x5e, 0xdb, 0xbf, 0xd1, 0x15,
	0xd1, 0xa1, 0x31, 0x70, 0x22, 0x16, 0x2c, 0x89, 0x71, 0x95, 0xcc, 0xb8, 0xd4, 0x88, 0xea, 0x15,
	0x8d, 0xa8, 0x2d, 0x30, 0xa2, 0xbe, 0xc4, 0x88, 0xc6, 0xbc, 0x11, 0x7f, 0x36, 0x60, 0xf5, 0x45,
	0x44, 0xc2, 0x65, 0x8e, 0xff, 0x10, 0xea, 0x82, 0x45, 0xf8, 0xbd, 0xb3, 0xdf, 0xee, 0xf2, 0x98,
	0xe1, 0x08, 0x96, 0xf8, 0xbb, 0x2b, 0xff, 0x3f, 0xda, 0x81, 0xbf, 0x1b, 0x80, 0x0e, 0x1d, 0xe6,
	0x0c, 0x82, 0x38, 0x1c, 0x91, 0xd4, 0x82, 0x74, 0x3a, 0x63, 0xc9, 0x74, 0x95, 0xb9, 0xe9, 0xd0,
	0x5d, 0xb5, 0x81, 0x55, 0xb1, 0x81, 0xb7, 0xe4, 0x06, 0xce, 0xcf, 0x3f, 0xbf, 0x8f, 0xb5, 0xcc,
	0x57, 0x8b, 0x8d, 0x4c, 0x9d, 0xd4, 0x58, 0xe2, 0x24, 0x7b, 0x0a, 0xe8, 0x79, 0xe8, 0x8d, 0xc7,
	0x24, 0x7c, 0xea, 0xf9, 0x8c, 0x84, 0xd2, 0x75, 0x1f, 0x00, 0xf4, 0xa3, 0xc1, 0xe8, 0x82, 0xb8,
	0xb1, 0x4f, 0xd4, 0xd6, 0x68, 0x08, 0xda, 0x86, 0x56, 0x3f, 0x3a, 0x71, 0x68, 0xec, 0x24, 0x41,
	0x95, 0x8e, 0xb9, 0xec, 0x93, 0x57, 0x84, 0xb2, 0x53, 0x67, 0x42, 0x22, 0xab, 0x2a, 0x8e, 0x8e,
	0x86, 0xd8, 0x13, 0x58, 0xcd, 0xad, 0xf8, 0x5f, 0xbb, 0xef, 0x4a, 0x51, 0x60, 0x87, 0x80, 0x0e,
	0x46, 0x9c, 0xff, 0x2c, 0x66, 0xd3, 0x98, 0xa9, 0x35, 0x53, 0x59, 0x63, 0x59, 0x04, 0xa5, 0x9a,
	0x55, 0x96, 0x68, 0x56, 0x9d, 0x8f, 0x93, 0xdf, 0x1b, 0xb0, 0xd1, 0x0b, 0x28, 0x23, 0x6f, 0xd8,
	0x09, 0x61, 0x8e, 0x5a, 0x73, 0x2f, 0x77, 0x5e, 0xdf, 0x97, 0xdb, 0x3d, 0xc7, 0xa6, 0xed, 0x76,
	0xaa, 0x64, 0xe5, 0x4a, 0x4a, 0x56, 0x97, 0x28, 0x59, 0x9b, 0x57, 0xf2, 0x5b, 0xd8, 0xd2, 0x16,
	0x1f, 0x78, 0x74, 0xec, 0x13, 0x39, 0xe3, 0x2d, 0x68, 0x3f, 0xf5, 0x88, 0xef, 0xf2, 0xfd, 0x52,
	0x9b, 0x92, 0x01, 0x68, 0x1f, 0xda, 0xbd, 0x80, 0xba, 0x5e, 0xba, 0x2d, 0x9d, 0xfd, 0x4d, 0x71,
	0x42, 0xcf, 0x03, 0xdf, 0x1b, 0xcd, 0x52, 0x1a, 0xce, 0xd8, 0xec, 0x9f, 0x41, 0x2b, 0x8d, 0x9d,
	0x1d, 0x58, 0xef, 0x47, 0xc1, 0x83, 0xef, 0xdf, 0xbd, 0x97, 0x0b, 0xb0, 0x36, 0x2e, 0xc2, 0x1a,
	0xe7, 0x89, 0x47, 0x0f, 0x89, 0xcf, 0x1c, 0x65, 0x63, 0x11, 0xb6, 0x7f, 0xd7, 0x82, 0x86, 0xdc,
	0x65, 0xb4, 0x06, 0x95, 0xfe, 0xa1, 0x9a, 0xb1, 0xd2, 0x3f, 0xcc, 0xdc, 0xb3, 0xba, 0xc4, 0x3d,
	0x6b, 0xf3, 0xd1, 0xb5, 0x05, 0x8d, 0xc7, 0xb3, 0xa9, 0x13, 0x45, 0xd6, 0xba, 0x08, 0x70, 0x35,
	0xe2, 0xe1, 0xfd, 0x38, 0x24, 0xce, 0xe5, 0xc1, 0x4b, 0x46, 0x42, 0xcb, 0x94, 0x47, 0x23, 0x43,
	0xd0, 0xc3, 0xc2, 0xc5, 0xa2, 0x5c, 0x74, 0x5d, 0x6e, 0x77, 0x8e, 0x84, 0x0b, 0x57, 0xd0, 0xc3,
	0x42, 0x6a, 0x54, 0x81, 0xad, 0x44, 0x73, 0x24, 0x5c, 0x48, 0xa2, 0x9f, 0x41, 0x47, 0xcc, 0x25,
	0x63, 0x48, 0xdd, 0x4c, 0xa5, 0x6b, 0xea, 0x7c, 0x5c, 0x4c, 0xcc, 0xa3, 0xc4, 0xea, 0x8b, 0xd7,
	0xd3, 0xf9, 0xd0, 0xfd, 0xdc, 0x45, 0x64, 0xb5, 0x85, 0xd8, 0xc6, 0xdc, 0x05, 0x84, 0x73, 0xd7,
	0xd5, 0x1e, 0xb4, 0xfb, 0xee, 0x44, 0xad, 0x04, 0x8b, 0x44, 0x32, 0x1e, 0xf4, 0xac, 0x2c, 0xd9,
	0x5a, 0x1b, 0x42, 0xd2, 0x5a, 0x94, 0x2c, 0x71, 0x59, 0x82, 0x3e, 0x04, 0x33, 0x43, 0x95, 0x06,
	0xe8, 0x2d, 0xf3, 0xcc, 0x49, 0x70, 0x7d, 0xe6, 0x33, 0x89, 0xca, 0xae, 0x6a, 0x9e, 0x79, 0x3a,
	0x2e, 0xcb, 0x3e, 0x4f, 0x4a, 0xd2, 0x83, 0xd5, 0x11, 0x13, 0xdd, 0x5c, 0x90, 0x16, 0x70, 0x49,
	0x42, 0x79, 0x58, 0xc8, 0xa4, 0xd6, 0x75, 0x7d, 0xff, 0x72, 0x24, 0x5c, 0xc8, 0xb9, 0x5f, 0x00,
	0x9c, 0x3b, 0xa1, 0x33, 0x21, 0x8c, 0xdf, 0xb3, 0x4d, 0x71, 0xcf, 0xde, 0xd2, 0x6d, 0xe8, 0x66,
	0xe4, 0x27, 0x94, 0x85, 0x33, 0xac, 0xf1, 0xa3, 0x4f, 0x61, 0xad, 0x77, 0xe1, 0x78, 0x94, 0xb8,
	0x92, 0x39, 0xb2, 0x5a, 0x62, 0x86, 0x15, 0x7d, 0x06, 0x5c, 0xe0, 0x41, 0x5f, 0xc2, 0xf5, 0xa7,
	0x8e, 0xe7, 0x13, 0x57, 0xea, 0x90, 0x88, 0xae, 0x94, 0x88, 0x96, 0x31, 0x6e, 0x3f, 0x82, 0xf5,
	0x82, 0x52, 0xfc, 0x3e, 0xbc, 0x24, 0x33, 0x75, 0xda, 0xf9, 0x4f, 0x7e, 0xdc, 0x5f, 0x39, 0x7e,
	0x4c, 0x92, 0x94, 0x2d, 0x06, 0x3f, 0xa8, 0x3c, 0x30, 0xec, 0x7f, 0x35, 0xa0, 0x7a, 0x14, 0x0c,
	0x17, 0x27, 0x88, 0x5c, 0x92, 0xdf, 0x84, 0xfa, 0xd9, 0x6b, 0x4a, 0xc2, 0x24, 0xab, 0x8a, 0x81,
	0xb8, 0xf7, 0xa8, 0xa8, 0x44, 0x89, 0xba, 0x84, 0xd3, 0x31, 0x4f, 0x18, 0xbd, 0x38, 0x62, 0xc1,
	0xc4, 0xda, 0x94, 0x09, 0x43, 0x8e, 0x78, 0x36, 0x3d, 0x76, 0xe8, 0x38, 0x76, 0xc6, 0x24, 0xb2,
	0x40, 0x5c, 0x87, 0x19, 0x50, 0xb8, 0x2d, 0xeb, 0xc5, 0xdb, 0x12, 0xed, 0x66, 0x99, 0x33, 0xbd,
	0xc8, 0x85, 0xa7, 0x12, 0x14, 0x67, 0x99, 0xf5, 0x16, 0xb4, 0x0f, 0x62, 0x16, 0x0c, 0x98, 0x13,
	0x32, 0x51, 0xbe, 0xb4, 0x70, 0x06, 0x24, 0xd4, 0x9e, 0x4f, 0x1c, 0x2a, 0x82, 0x4d, 0x51, 0x05,
	0x80, 0x3e, 0x82, 0xe6, 0xb2, 0xbd, 0x4c, 0x88, 0xe8, 0x23, 0x58, 0x3b, 0x71, 0xde, 0xf4, 0x02,
	0x3a, 0x8a, 0xc3, 0x90, 0xd0, 0xd1, 0x4c, 0x9c, 0xfe, 0x3a, 0x2e, 0xa0, 0xe8, 0x13, 0xd8, 0x78,
	0xee, 0x44, 0x97, 0xd1, 0xc0, 0xf3, 0x09, 0x65, 0x2f, 0xa6, 0xae, 0xc3, 0x88, 0xb5, 0x22, 0x56,
	0x9d, 0x27, 0xa0, 0xdb, 0x50, 0x17, 0xa0, 0xb5, 0x26, 0xd6, 0x06, 0x15, 0xc1, 0x4e, 0x74, 0x89,
	0x25, 0x01, 0x3d, 0x82, 0x75, 0x9e, 0xb8, 0x84, 0x67, 0x54, 0xb4, 0xaf, 0x2f, 0x4e, 0x72, 0x45,
	0x5e, 0x2e, 0xce, 0x13, 0x98, 0x2e, 0x6e, 0x2e, 0x4e, 0x76, 0x45, 0xde, 0x7c, 0xee, 0xda, 0xb8,
	0x42, 0xee, 0x2a, 0x3d, 0xe1, 0xe8, 0x9d, 0x4f, 0x78, 0x59, 0xe2, 0xba, 0xf1, 0xce, 0x89, 0x6b,
	0x3f, 0x77, 0xd8, 0xaf, 0x0b, 0x17, 0x23, 0x29, 0x7f, 0x14, 0x0c, 0x53, 0x52, 0xee, 0x88, 0x1f,
	0xc1, 0x0d, 0x4c, 0x22, 0x31, 0x4b, 0x74, 0x48, 0xa6, 0x84, 0xba, 0x84, 0x8e, 0x3c, 0x12, 0x59,
	0x5b, 0x42, 0x7c, 0xb3, 0x2b, 0x3b, 0xcf, 0x6e, 0xd2, 0x79, 0x76, 0x0f, 0xe8, 0x0c, 0x97, 0x8b,
	0xd8, 0x7f, 0x34, 0x60, 0x45, 0x5f, 0x08, 0x21, 0xa8, 0x69, 0xb5, 0x85, 0xf8, 0x7d, 0x85, 0x7a,
	0x6f, 0x13, 0xea, 0x3f, 0x12, 0x47, 0x5b, 0x16, 0x33, 0x72, 0xc0, 0xc3, 0xfa, 0xc4, 0xa1, 0xae,
	0xc3, 0x02, 0x55, 0x09, 0xb6, 0x70, 0x06, 0xf0, 0x95, 0x44, 0xcd, 0x25, 0xbb, 0x14, 0x59, 0x56,
	0xdd, 0x86, 0xce, 0x51, 0x14, 0xd0, 0xde, 0x45, 0xe0, 0x8d, 0x48, 0x94, 0x34, 0x29, 0x1a, 0x64,
	0xff, 0x04, 0xd6, 0x8e, 0x82, 0x61, 0xef, 0xc2, 0xa1, 0x63, 0x19, 0x45, 0xe8, 0x63, 0x80, 0xa3,
	0x60, 0x28, 0xa3, 0xd5, 0x55, 0x45, 0x63, 0x3b, 0x75, 0x21, 0xd6, 0x88, 0xfc, 0x44, 0x73, 0x88,
	0x4c, 0x82, 0x57, 0xc4, 0x55, 0x76, 0x68, 0x88, 0xfd, 0x53, 0x58, 0xe7, 0x21, 0xad, 0xcf, 0xfe,
	0x09, 0x74, 0x38, 0x94, 0x9f, 0x5e, 0x3f, 0x04, 0x3a, 0x19, 0xbd, 0x2f, 0xf2, 0x98, 0xaa, 0x2b,
	0x34, 0x25, 0x38, 0x6a, 0x7f, 0x02, 0xab, 0xe7, 0x31, 0x13, 0xcb, 0xfd, 0x3c, 0x26, 0x11, 0x4b,
	0xb8, 0x8d, 0x52, 0xee, 0xef, 0xc1, 0x5a, 0xc2, 0x1d, 0x4d, 0x03, 0x1a, 0x91, 0xe5, 0xec, 0x2f,
	0x60, 0xf5, 0x6b, 0xa2, 0x4f, 0xbe, 0x09, 0xf5, 0xa3, 0x60, 0x98, 0xa6, 0x53, 0x39, 0x40, 0x5d,
	0x68, 0x1f, 0x07, 0x8e, 0x2b, 0x4f, 0x74, 0x45, 0x54, 0xbb, 0x66, 0x66, 0xcc, 0x80, 0x39, 0x2c,
	0x8e, 0x70, 0xc6, 0xc2, 0xb5, 0x48, 0xa6, 0xbd, 0x8a, 0x16, 0xa7, 0x60, 0x1e, 0x12, 0x9f, 0x30,
	0xf2, 0x56, 0x45, 0xee, 0xc0, 0xaa, 0xc8, 0x6e, 0xce, 0xd0, 0xe7, 0xcc, 0x91, 0xea, 0x55, 0xf2,
	0xa0, 0x7d, 0x06, 0x1b, 0xda, 0x7c, 0x4a, 0x03, 0x0b, 0x9a, 0x83, 0x78, 0x34, 0x22, 0x51, 0xa4,
	0xda, 0x9f, 0x64, 0x28, 0x03, 0x95, 0xb3, 0xf7, 0x82, 0x98, 0x32, 0x31, 0x65, 0x1d, 0xeb, 0x90,
	0xfd, 0x4f, 0x03, 0xd6, 0x8f, 0xbd, 0x88, 0x5b, 0x14, 0x69, 0x0a, 0xca, 0xfb, 0xc4, 0xd0, 0xef,
	0x93, 0x24, 0xfb, 0x47, 0x67, 0xd4, 0x9f, 0x29, 0xed, 0x34, 0x84, 0xd3, 0x9f, 0x7b, 0x13, 0x12,
	0x4a, 0xba, 0x8c, 0x6e, 0x0d, 0xc9, 0x7b, 0xba, 0xf6, 0x56, 0x4f, 0xf3, 0x3b, 0x4a, 0x78, 0x26,
	0xb9, 0x69, 0xd4, 0x88, 0xdb, 0x24, 0x18, 0xce, 0x5e, 0xbe, 0x8c, 0x08, 0x13, 0x47, 0xa2, 0x8e,
	0x75, 0x48, 0x68, 0xc2, 0x87, 0xc7, 0xde, 0xc4, 0x93, 0x97, 0x4b, 0x1d, 0x6b, 0x88, 0xbd, 0x07,
	0x66, 0x66, 0xf2, 0x55, 0x76, 0x11, 0x4b, 0x01, 0x31, 0xc5, 0xf2, 0x5d, 0xdc, 0x81, 0x86, 0xb4,
	0x64, 0x61, 0x2c, 0x29, 0xba, 0x7d, 0x1f, 0x36, 0xb4, 0x39, 0x95, 0x16, 0x1f, 0x40, 0x8d, 0x03,
	0x25, 0xa7, 0x4a, 0xe0, 0xf6, 0x5d, 0x71, 0x06, 0x04, 0xa0, 0xd4, 0x78, 0x9b, 0xc4, 0x3d, 0x58,
	0x4f, 0x25, 0xae, 0xb8, 0xc8, 0x6f, 0x0c, 0x40, 0x32, 0x44, 0xca, 0x0c, 0x76, 0x75, 0x83, 0x5d,
	0xbe, 0x4b, 0x9c, 0xab, 0x7f, 0x98, 0x3c, 0x3c, 0xc9, 0x91, 0xe6, 0x08, 0xde, 0x55, 0x2f, 0x71,
	0x04, 0xdf, 0xad, 0xf3, 0x30, 0xa6, 0x44, 0xee, 0x56, 0x4d, 0xee, 0x56, 0x86, 0xd8, 0x7b, 0x70,
	0x3d, 0xa7, 0x4d, 0x16, 0xf4, 0x12, 0xe6, 0x0a, 0xf1, 0x95, 0x93, 0xa1, 0xbd, 0x07, 0x37, 0x0f,
	0x09, 0x23, 0x23, 0x36, 0x60, 0xf1, 0xe8, 0xb2, 0x68, 0xc3, 0xc0, 0xa3, 0x23, 0x99, 0xcd, 0xeb,
	0x58, 0x0e, 0xec, 0x2f, 0xc1, 0x9a, 0x17, 0x50, 0xcb, 0xd8, 0xb0, 0xf2, 0xd4, 0x7b, 0x43, 0x44,
	0x4c, 0xf6, 0xdd, 0x48, 0xad, 0x95, 0xc3, 0xec, 0x7f, 0x57, 0xa4, 0x47, 0xcb, 0xca, 0x35, 0x19,
	0x23, 0x95, 0xf2, 0x18, 0xa9, 0x2e, 0x8f, 0x11, 0x9e, 0x13, 0xe4, 0xaf, 0x13, 0x12, 0x45, 0xce,
	0x38, 0xb9, 0x4d, 0xf2, 0x20, 0x57, 0x51, 0x15, 0xcc, 0xf2, 0xd4, 0xca, 0xfb, 0x23, 0x87, 0xf1,
	0x9b, 0x47, 0x54, 0x56, 0xfc, 0x3c, 0xaa, 0x23, 0x93, 0x01, 0xdc, 0x97, 0x4f, 0xa8, 0x2b, 0x68,
	0xf2, 0xb4, 0x24, 0x43, 0xf1, 0x64, 0xe3, 0xd0, 0x01, 0x0b, 0xa6, 0x56, 0x4b, 0x3d, 0xd9, 0xc8,
	0x21, 0x2f, 0x2f, 0x7b, 0x0e, 0x3d, 0x77, 0xe2, 0x88, 0x88, 0xb2, 0xaa, 0x85, 0xd3, 0x31, 0x3f,
	0xa2, 0xcf, 0x9c, 0xe8, 0x3c, 0x0c, 0xc6, 0x21, 0x4f, 0x4a, 0x20, 0xc8, 0x3a, 0xc4, 0xa5, 0x53,
	0x32, 0xaf, 0xef, 0x2a, 0x38, 0x1d, 0xa3, 0x7b, 0xd0, 0x51, 0x15, 0xdc, 0x71, 0x30, 0x4e, 0x6a,
	0xee, 0x75, 0xbd, 0xc4, 0x3b, 0x0e, 0xc6, 0x58, 0xe7, 0xb1, 0x7f, 0x55, 0x81, 0x4e, 0x8f, 0x85,
	0x7e, 0x2f, 0x98, 0x4c, 0x1c, 0xea, 0xa2, 0x0f, 0xa1, 0xda, 0x9b, 0xb8, 0xea, 0xf5, 0x62, 0x35,
	0x29, 0x62, 0x04, 0x0d, 0x73, 0x4a, 0x16, 0xcc, 0x95, 0xb2, 0x60, 0x76, 0x55, 0x25, 0xad, 0x46,
	0xdc, 0x0b, 0xc2, 0x8d, 0x7d, 0x57, 0xed, 0x40, 0x32, 0x44, 0x47, 0xb0, 0x8a, 0x63, 0xaa, 0x55,
	0x2c, 0x75, 0xa1, 0xed, 0x1d, 0xb5, 0x64, 0xa6, 0x52, 0x37, 0xc7, 0x26, 0xdb, 0x94, 0xbc, 0xe8,
	0xf6, 0x57, 0x80, 0xe6, 0x99, 0xde, 0xa9, 0x6d, 0xf8, 0x2e, 0x5c, 0xd7, 0x96, 0x4c, 0x63, 0xd8,
	0x84, 0xea, 0x49, 0x34, 0x4e, 0xa6, 0x38, 0x89, 0xc6, 0xf6, 0x1f, 0x0c, 0x68, 0xa7, 0xae, 0x44,
	0x77, 0x92, 0x07, 0x09, 0x95, 0x12, 0xf2, 0xe5, 0x74, 0xf2, 0x58, 0xf1, 0x39, 0xac, 0xf4, 0xe9,
	0x34, 0x66, 0x49, 0x2c, 0xe6, 0xde, 0x0a, 0x24, 0x8f, 0x22, 0xe1, 0x1c, 0x23, 0x6f, 0xfd, 0x64,
	0x47, 0x99, 0x48, 0x56, 0x17, 0x4b, 0xe6, 0x39, 0xed, 0xdf, 0x56, 0x60, 0xfd, 0x28, 0x18, 0xaa,
	0x50, 0x96, 0x05, 0x48, 0x79, 0xe2, 0xd5, 0x7b, 0x8f, 0xca, 0x5b, 0x7a, 0x8f, 0x2d, 0x68, 0xe0,
	0x98, 0x9e, 0x06, 0xaf, 0xd5, 0x2d, 0xa5, 0x46, 0xfc, 0x90, 0xe0, 0x98, 0xaa, 0x08, 0x90, 0x1b,
	0x9d, 0x01, 0xe8, 0xb4, 0x7c, 0xab, 0x77, 0xd2, 0xbb, 0x42, 0xd7, 0xf2, 0xff, 0xb2, 0xdd, 0x7f,
	0x33, 0x60, 0x45, 0xef, 0xd8, 0x97, 0x14, 0x02, 0x16, 0x34, 0xb1, 0xf3, 0xfa, 0x71, 0xe0, 0xca,
	0x9b, 0x7b, 0x05, 0x27, 0x43, 0x9e, 0x7e, 0x07, 0x2c, 0xf4, 0xe8, 0x58, 0x10, 0x65, 0xdc, 0x6b,
	0x08, 0x3f, 0xa9, 0xbc, 0xdc, 0x14, 0xd4, 0x9a, 0x10, 0x4d, 0xc7, 0xfc, 0x9c, 0x3f, 0x09, 0xc3,
	0x20, 0x94, 0xec, 0x2a, 0xf1, 0xe8, 0x10, 0x5f, 0xb7, 0x3f, 0xa6, 0x41, 0x48, 0x5c, 0x91, 0x75,
	0x5a, 0x38, 0x19, 0x8a, 0x6a, 0x37, 0x4b, 0x38, 0xe2, 0xb7, 0xfd, 0xd7, 0x1a, 0xdc, 0xd4, 0x0d,
	0x2a, 0x3c, 0xf4, 0xf5, 0xa3, 0xbc, 0x75, 0x19, 0x80, 0x76, 0xc1, 0xcc, 0x74, 0xc6, 0x64, 0x4c,
	0xde, 0x4c, 0x95, 0xbf, 0xe6, 0x70, 0xf4, 0x05, 0xbc, 0x97, 0x61, 0x03, 0xef, 0x17, 0xe4, 0xeb,
	0x90, 0x38, 0x8c, 0x84, 0xcf, 0x2f, 0x1c, 0xf9, 0x42, 0x5a, 0xc7, 0x8b, 0x19, 0xe6, 0xa5, 0x07,
	0x13, 0xc7, 0xf7, 0x95, 0x74, 0xad, 0x4c, 0x5a, 0x63, 0xe0, 0x2d, 0x69, 0xe2, 0x3d, 0xa5, 0xa5,
	0x74, 0x5a, 0x01, 0xd5, 0xf9, 0x9e, 0x39, 0xd1, 0x0f, 0xc9, 0x4c, 0x95, 0xfe, 0x05, 0x14, 0x3d,
	0x80, 0x9b, 0x09, 0x52, 0xb4, 0x44, 0x3a, 0x76, 0x11, 0xb9, 0x28, 0xa9, 0x5b, 0xd1, 0x9a, 0x97,
	0xd4, 0x6d, 0x50, 0xe5, 0x15, 0xdf, 0xb1, 0xaf, 0x99, 0x6a, 0xa9, 0x35, 0x44, 0xa7, 0x1f, 0x33,
	0x91, 0xfc, 0x35, 0xfa, 0x31, 0xef, 0x20, 0x36, 0xb4, 0x10, 0x51, 0x6e, 0xe8, 0x08, 0xf3, 0xe6,
	0x09, 0xfc, 0x0e, 0x7c, 0x1a, 0x12, 0x92, 0x3d, 0xe3, 0xca, 0xb7, 0xd1, 0x3c, 0xc8, 0x8f, 0xcd,
	0x69, 0xc0, 0x54, 0xd3, 0xce, 0x7f, 0xda, 0xbf, 0xae, 0xc2, 0x6a, 0x2e, 0xb7, 0xa0, 0x5d, 0xa8,
	0x8b, 0xb3, 0xa9, 0xb2, 0x5c, 0x79, 0x5b, 0x28, 0x59, 0x78, 0x93, 0x2f, 0xba, 0x74, 0xf5, 0x59,
	0x07, 0xba, 0xe2, 0xf3, 0x21, 0x87, 0xb0, 0x24, 0x64, 0x1f, 0x7e, 0xaa, 0x0b, 0x3e, 0xfc, 0x7c,
	0x08, 0x75, 0x1c, 0xf8, 0xa2, 0x69, 0xcb, 0x18, 0x38, 0x82, 0x25, 0x8e, 0xba, 0x00, 0x3f, 0x0e,
	0xc2, 0xcb, 0x68, 0xea, 0xf0, 0xd6, 0x4e, 0xbe, 0x6b, 0xad, 0x09, 0xae, 0x14, 0xc6, 0x1a, 0x07,
	0xba, 0x05, 0xb5, 0x83, 0x91, 0x9f, 0xbc, 0x79, 0xb4, 0x04, 0xe7, 0x41, 0xef, 0x18, 0x0b, 0x14,
	0xdd, 0x05, 0x38, 0x90, 0x9f, 0x1d, 0x79, 0xe7, 0x5b, 0x13, 0x3c, 0x66, 0x37, 0xf9, 0x12, 0xd9,
	0x3d, 0x13, 0x5f, 0x14, 0xb1, 0xc6, 0x83, 0x3e, 0x85, 0x4e, 0xd6, 0x7e, 0x47, 0x56, 0x5b, 0xf5,
	0xda, 0xea, 0xdb, 0x63, 0x46, 0xc2, 0x3a, 0x1b, 0x97, 0x92, 0x87, 0x53, 0xbc, 0x98, 0xa9, 0x24,
	0x88, 0xe6, 0x9f, 0x14, 0xb1, 0xce, 0xb6, 0xfb, 0x08, 0xd6, 0x0b, 0x5f, 0xfb, 0x50, 0x0b, 0x6a,
	0xdc, 0x51, 0xe6, 0x35, 0xfe, 0x8b, 0x7b, 0xc4, 0x34, 0xd0, 0x2a, 0xb4, 0x53, 0x83, 0xcd, 0x0a,
	0x6a, 0x42, 0xf5, 0x60, 0xe4, 0x9b, 0xd5, 0xdd, 0x4f, 0x61, 0xab, 0xfc, 0x5b, 0x13, 0x5a, 0x03,
	0xc8, 0x28, 0xe6, 0x35, 0x04, 0xd0, 0x90, 0xa6, 0x9a, 0xc6, 0xee, 0x43, 0xb8, 0x51, 0xfa, 0xc9,
	0x02, 0xad, 0x43, 0x47, 0x55, 0x84, 0x9c, 0x60, 0x5e, 0xe3, 0x80, 0xe2, 0x14, 0x2a, 0x19, 0xbb,
	0xbf, 0x94, 0x31, 0xac, 0xea, 0xb0, 0x0e, 0x34, 0x5f, 0xd0, 0x4b, 0x1a, 0xbc, 0xa6, 0x52, 0xdb,
	0xbe, 0x2b, 0xb4, 0xed, 0x40, 0x13, 0xc7, 0x94, 0x7a, 0x74, 0x6c, 0x56, 0xd0, 0x0a, 0xb4, 0x9e,
	0x7a, 0xd4, 0x8b, 0x2e, 0x88, 0x6b, 0x56, 0xf9, 0x84, 0x7d, 0xca, 0x48, 0x18, 0xc6, 0x53, 0x46,
	0x5c, 0xb3, 0xc6, 0xf5, 0x12, 0xb5, 0x91, 0x6b, 0xd6, 0x85, 0x59, 0x74, 0x66, 0x36, 0x50, 0x1b,
	0xea, 0x22, 0xe0, 0xcd, 0x26, 0xa7, 0x7f, 0x13, 0x93, 0x98, 0xb8, 0x66, 0x6b, 0x77, 0x0c, 0xcd,
	0xa4, 0x90, 0x69, 0x41, 0xed, 0x34, 0xa0, 0xdc, 0xb0, 0x36, 0xd4, 0xc5, 0x04, 0xa6, 0xc1, 0x79,
	0x31, 0x89, 0xe2, 0x09, 0x77, 0x51, 0x0b, 0x6a, 0xbc, 0x1c, 0x33, 0xab, 0x1c, 0x95, 0x15, 0xb0,
	0x59, 0x53, 0x9a, 0x9d, 0xd1, 0x11, 0x31, 0xeb, 0x5c, 0xb3, 0xe4, 0xe1, 0xcf, 0x6c, 0x70, 0xb6,
	0x03, 0xf9, 0xbb, 0xb9, 0xff, 0x8f, 0x9a, 0xe8, 0xff, 0x07, 0xf2, 0x53, 0x0d, 0xfa, 0x0c, 0x1a,
	0xb2, 0xc3, 0x46, 0xea, 0x6e, 0xce, 0x75, 0xe7, 0xdb, 0x9b, 0x79, 0x50, 0x16, 0x17, 0xf6, 0x35,
	0x2e, 0x26, 0x5b, 0xe2, 0x44, 0x2c, 0xd7, 0x77, 0x27, 0x62, 0xf9, 0xae, 0xd9, 0xbe, 0x86, 0xbe,
	0x84, 0x76, 0xda, 0xca, 0xa2, 0x2d, 0xf5, 0x44, 0x54, 0xe8, 0x95, 0xb7, 0x6f, 0xce, 0xe1, 0xa9,
	0xfc, 0x23, 0x68, 0x25, 0x5d, 0x1c, 0x52, 0x1f, 0x94, 0x0b, 0x8d, 0xec, 0xf6, 0x56, 0x11, 0x4e,
	0x84, 0xef, 0x1a, 0xe8, 0x01, 0x34, 0x55, 0x63, 0x84, 0x32, 0xc3, 0xb4, 0xce, 0x6a, 0xfb, 0x46,
	0x01, 0x4d, 0x17, 0x7e, 0x2c, 0x9e, 0x2d, 0x64, 0x78, 0x84, 0xc4, 0x99, 0xbc, 0xa3, 0xfc, 0x8e,
	0x71, 0xd7, 0x40, 0x5f, 0x41, 0x3b, 0xed, 0xfe, 0x90, 0xa6, 0xa6, 0xde, 0xad, 0x24, 0xc6, 0xcf,
	0xb5, 0x89, 0x42, 0xff, 0xc3, 0xa4, 0xb5, 0x97, 0x73, 0x58, 0xba, 0xa3, 0x72, 0xb3, 0xbc, 0x57,
	0x42, 0x49, 0x6d, 0xf9, 0x06, 0xcc, 0x62, 0xeb, 0x83, 0xbe, 0x93, 0x08, 0x94, 0xf6, 0x50, 0xdb,
	0x1f, 0x2c, 0x22, 0xcb, 0x49, 0xf7, 0x9f, 0xc9, 0xfe, 0x3c, 0x09, 0xaa, 0x87, 0x3c, 0x98, 0x29,
	0x0b, 0x03, 0x1f, 0x6d, 0xcc, 0x55, 0xc5, 0x89, 0x72, 0x25, 0x55, 0xab, 0x7d, 0x6d, 0xd8, 0x10,
	0x99, 0xf9, 0xfe, 0x7f, 0x02, 0x00, 0x00, 0xff, 0xff, 0xd7, 0x08, 0x31, 0x30, 0x4c, 0x22, 0x00,
	0x00,
}
