// Code generated by protoc-gen-micro. DO NOT EDIT.
// source: log.proto

/*
Package log is a generated protocol buffer package.

It is generated from these files:
	log.proto

It has these top-level messages:
	RecorderPutResponse
	Log
	LogMessage
	ListLogRequest
	ListLogResponse
	DeleteLogsResponse
	TimeRangeResponse
	TimeRangeResult
	TimeRangeRequest
	TimeRangeCursor
*/
package log

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

import (
	client "github.com/micro/go-micro/client"
	server "github.com/micro/go-micro/server"
	context "context"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ client.Option
var _ server.Option

// Client API for LogRecorder service

type LogRecorderClient interface {
	// PutLog adds received log messages to the corresponding log repository.
	PutLog(ctx context.Context, opts ...client.CallOption) (LogRecorder_PutLogClient, error)
	// ListLogs performs a paginated search query in the log repository.
	ListLogs(ctx context.Context, in *ListLogRequest, opts ...client.CallOption) (LogRecorder_ListLogsClient, error)
	// DeleteLogs deletes logs based on a request (cannot be empty)
	DeleteLogs(ctx context.Context, in *ListLogRequest, opts ...client.CallOption) (*DeleteLogsResponse, error)
	// AggregatedLogs performs a query to retrieve log events of the given type, faceted by time range.
	AggregatedLogs(ctx context.Context, in *TimeRangeRequest, opts ...client.CallOption) (LogRecorder_AggregatedLogsClient, error)
}

type logRecorderClient struct {
	c           client.Client
	serviceName string
}

func NewLogRecorderClient(serviceName string, c client.Client) LogRecorderClient {
	if c == nil {
		c = client.NewClient()
	}
	if len(serviceName) == 0 {
		serviceName = "log"
	}
	return &logRecorderClient{
		c:           c,
		serviceName: serviceName,
	}
}

func (c *logRecorderClient) PutLog(ctx context.Context, opts ...client.CallOption) (LogRecorder_PutLogClient, error) {
	req := c.c.NewRequest(c.serviceName, "LogRecorder.PutLog", &Log{})
	stream, err := c.c.Stream(ctx, req, opts...)
	if err != nil {
		return nil, err
	}
	return &logRecorderPutLogClient{stream}, nil
}

type LogRecorder_PutLogClient interface {
	SendMsg(interface{}) error
	RecvMsg(interface{}) error
	Close() error
	Send(*Log) error
}

type logRecorderPutLogClient struct {
	stream client.Streamer
}

func (x *logRecorderPutLogClient) Close() error {
	return x.stream.Close()
}

func (x *logRecorderPutLogClient) SendMsg(m interface{}) error {
	return x.stream.Send(m)
}

func (x *logRecorderPutLogClient) RecvMsg(m interface{}) error {
	return x.stream.Recv(m)
}

func (x *logRecorderPutLogClient) Send(m *Log) error {
	return x.stream.Send(m)
}

func (c *logRecorderClient) ListLogs(ctx context.Context, in *ListLogRequest, opts ...client.CallOption) (LogRecorder_ListLogsClient, error) {
	req := c.c.NewRequest(c.serviceName, "LogRecorder.ListLogs", &ListLogRequest{})
	stream, err := c.c.Stream(ctx, req, opts...)
	if err != nil {
		return nil, err
	}
	if err := stream.Send(in); err != nil {
		return nil, err
	}
	return &logRecorderListLogsClient{stream}, nil
}

type LogRecorder_ListLogsClient interface {
	SendMsg(interface{}) error
	RecvMsg(interface{}) error
	Close() error
	Recv() (*ListLogResponse, error)
}

type logRecorderListLogsClient struct {
	stream client.Streamer
}

func (x *logRecorderListLogsClient) Close() error {
	return x.stream.Close()
}

func (x *logRecorderListLogsClient) SendMsg(m interface{}) error {
	return x.stream.Send(m)
}

func (x *logRecorderListLogsClient) RecvMsg(m interface{}) error {
	return x.stream.Recv(m)
}

func (x *logRecorderListLogsClient) Recv() (*ListLogResponse, error) {
	m := new(ListLogResponse)
	err := x.stream.Recv(m)
	if err != nil {
		return nil, err
	}
	return m, nil
}

func (c *logRecorderClient) DeleteLogs(ctx context.Context, in *ListLogRequest, opts ...client.CallOption) (*DeleteLogsResponse, error) {
	req := c.c.NewRequest(c.serviceName, "LogRecorder.DeleteLogs", in)
	out := new(DeleteLogsResponse)
	err := c.c.Call(ctx, req, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *logRecorderClient) AggregatedLogs(ctx context.Context, in *TimeRangeRequest, opts ...client.CallOption) (LogRecorder_AggregatedLogsClient, error) {
	req := c.c.NewRequest(c.serviceName, "LogRecorder.AggregatedLogs", &TimeRangeRequest{})
	stream, err := c.c.Stream(ctx, req, opts...)
	if err != nil {
		return nil, err
	}
	if err := stream.Send(in); err != nil {
		return nil, err
	}
	return &logRecorderAggregatedLogsClient{stream}, nil
}

type LogRecorder_AggregatedLogsClient interface {
	SendMsg(interface{}) error
	RecvMsg(interface{}) error
	Close() error
	Recv() (*TimeRangeResponse, error)
}

type logRecorderAggregatedLogsClient struct {
	stream client.Streamer
}

func (x *logRecorderAggregatedLogsClient) Close() error {
	return x.stream.Close()
}

func (x *logRecorderAggregatedLogsClient) SendMsg(m interface{}) error {
	return x.stream.Send(m)
}

func (x *logRecorderAggregatedLogsClient) RecvMsg(m interface{}) error {
	return x.stream.Recv(m)
}

func (x *logRecorderAggregatedLogsClient) Recv() (*TimeRangeResponse, error) {
	m := new(TimeRangeResponse)
	err := x.stream.Recv(m)
	if err != nil {
		return nil, err
	}
	return m, nil
}

// Server API for LogRecorder service

type LogRecorderHandler interface {
	// PutLog adds received log messages to the corresponding log repository.
	PutLog(context.Context, LogRecorder_PutLogStream) error
	// ListLogs performs a paginated search query in the log repository.
	ListLogs(context.Context, *ListLogRequest, LogRecorder_ListLogsStream) error
	// DeleteLogs deletes logs based on a request (cannot be empty)
	DeleteLogs(context.Context, *ListLogRequest, *DeleteLogsResponse) error
	// AggregatedLogs performs a query to retrieve log events of the given type, faceted by time range.
	AggregatedLogs(context.Context, *TimeRangeRequest, LogRecorder_AggregatedLogsStream) error
}

func RegisterLogRecorderHandler(s server.Server, hdlr LogRecorderHandler, opts ...server.HandlerOption) {
	s.Handle(s.NewHandler(&LogRecorder{hdlr}, opts...))
}

type LogRecorder struct {
	LogRecorderHandler
}

func (h *LogRecorder) PutLog(ctx context.Context, stream server.Streamer) error {
	return h.LogRecorderHandler.PutLog(ctx, &logRecorderPutLogStream{stream})
}

type LogRecorder_PutLogStream interface {
	SendMsg(interface{}) error
	RecvMsg(interface{}) error
	Close() error
	Recv() (*Log, error)
}

type logRecorderPutLogStream struct {
	stream server.Streamer
}

func (x *logRecorderPutLogStream) Close() error {
	return x.stream.Close()
}

func (x *logRecorderPutLogStream) SendMsg(m interface{}) error {
	return x.stream.Send(m)
}

func (x *logRecorderPutLogStream) RecvMsg(m interface{}) error {
	return x.stream.Recv(m)
}

func (x *logRecorderPutLogStream) Recv() (*Log, error) {
	m := new(Log)
	if err := x.stream.Recv(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (h *LogRecorder) ListLogs(ctx context.Context, stream server.Streamer) error {
	m := new(ListLogRequest)
	if err := stream.Recv(m); err != nil {
		return err
	}
	return h.LogRecorderHandler.ListLogs(ctx, m, &logRecorderListLogsStream{stream})
}

type LogRecorder_ListLogsStream interface {
	SendMsg(interface{}) error
	RecvMsg(interface{}) error
	Close() error
	Send(*ListLogResponse) error
}

type logRecorderListLogsStream struct {
	stream server.Streamer
}

func (x *logRecorderListLogsStream) Close() error {
	return x.stream.Close()
}

func (x *logRecorderListLogsStream) SendMsg(m interface{}) error {
	return x.stream.Send(m)
}

func (x *logRecorderListLogsStream) RecvMsg(m interface{}) error {
	return x.stream.Recv(m)
}

func (x *logRecorderListLogsStream) Send(m *ListLogResponse) error {
	return x.stream.Send(m)
}

func (h *LogRecorder) DeleteLogs(ctx context.Context, in *ListLogRequest, out *DeleteLogsResponse) error {
	return h.LogRecorderHandler.DeleteLogs(ctx, in, out)
}

func (h *LogRecorder) AggregatedLogs(ctx context.Context, stream server.Streamer) error {
	m := new(TimeRangeRequest)
	if err := stream.Recv(m); err != nil {
		return err
	}
	return h.LogRecorderHandler.AggregatedLogs(ctx, m, &logRecorderAggregatedLogsStream{stream})
}

type LogRecorder_AggregatedLogsStream interface {
	SendMsg(interface{}) error
	RecvMsg(interface{}) error
	Close() error
	Send(*TimeRangeResponse) error
}

type logRecorderAggregatedLogsStream struct {
	stream server.Streamer
}

func (x *logRecorderAggregatedLogsStream) Close() error {
	return x.stream.Close()
}

func (x *logRecorderAggregatedLogsStream) SendMsg(m interface{}) error {
	return x.stream.Send(m)
}

func (x *logRecorderAggregatedLogsStream) RecvMsg(m interface{}) error {
	return x.stream.Recv(m)
}

func (x *logRecorderAggregatedLogsStream) Send(m *TimeRangeResponse) error {
	return x.stream.Send(m)
}
