// Code generated by protoc-gen-go. DO NOT EDIT.
// source: object.proto

/*
Package object is a generated protocol buffer package.

It is generated from these files:
	object.proto

It has these top-level messages:
	CleanResourcesRequest
	CleanResourcesResponse
	DataSource
	MinioConfig
	DataSourceEvent
	DataSourceSingleQuery
	GetMinioConfigRequest
	GetMinioConfigResponse
	StorageStatsRequest
	StorageStatsResponse
	GetDataSourceConfigRequest
	GetDataSourceConfigResponse
*/
package object

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/mwitkow/go-proto-validators"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Type of Gateway
type StorageType int32

const (
	StorageType_LOCAL StorageType = 0
	StorageType_S3    StorageType = 1
	StorageType_SMB   StorageType = 2
	StorageType_CELLS StorageType = 4
	StorageType_AZURE StorageType = 5
	StorageType_GCS   StorageType = 6
	StorageType_B2    StorageType = 7
	StorageType_MANTA StorageType = 8
	StorageType_SIA   StorageType = 9
)

var StorageType_name = map[int32]string{
	0: "LOCAL",
	1: "S3",
	2: "SMB",
	4: "CELLS",
	5: "AZURE",
	6: "GCS",
	7: "B2",
	8: "MANTA",
	9: "SIA",
}
var StorageType_value = map[string]int32{
	"LOCAL": 0,
	"S3":    1,
	"SMB":   2,
	"CELLS": 4,
	"AZURE": 5,
	"GCS":   6,
	"B2":    7,
	"MANTA": 8,
	"SIA":   9,
}

func (x StorageType) String() string {
	return proto.EnumName(StorageType_name, int32(x))
}
func (StorageType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

// Type of Encryption
type EncryptionMode int32

const (
	EncryptionMode_CLEAR    EncryptionMode = 0
	EncryptionMode_MASTER   EncryptionMode = 1
	EncryptionMode_USER     EncryptionMode = 2
	EncryptionMode_USER_PWD EncryptionMode = 3
)

var EncryptionMode_name = map[int32]string{
	0: "CLEAR",
	1: "MASTER",
	2: "USER",
	3: "USER_PWD",
}
var EncryptionMode_value = map[string]int32{
	"CLEAR":    0,
	"MASTER":   1,
	"USER":     2,
	"USER_PWD": 3,
}

func (x EncryptionMode) String() string {
	return proto.EnumName(EncryptionMode_name, int32(x))
}
func (EncryptionMode) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

type StorageTypeFilter int32

const (
	StorageTypeFilter_ANY     StorageTypeFilter = 0
	StorageTypeFilter_LOCALFS StorageTypeFilter = 1
	StorageTypeFilter_REMOTE  StorageTypeFilter = 2
)

var StorageTypeFilter_name = map[int32]string{
	0: "ANY",
	1: "LOCALFS",
	2: "REMOTE",
}
var StorageTypeFilter_value = map[string]int32{
	"ANY":     0,
	"LOCALFS": 1,
	"REMOTE":  2,
}

func (x StorageTypeFilter) String() string {
	return proto.EnumName(StorageTypeFilter_name, int32(x))
}
func (StorageTypeFilter) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

type DataSourceEvent_DSEventType int32

const (
	DataSourceEvent_CREATE   DataSourceEvent_DSEventType = 0
	DataSourceEvent_UPDATE   DataSourceEvent_DSEventType = 1
	DataSourceEvent_DELETE   DataSourceEvent_DSEventType = 2
	DataSourceEvent_ENABLED  DataSourceEvent_DSEventType = 3
	DataSourceEvent_DISABLED DataSourceEvent_DSEventType = 4
)

var DataSourceEvent_DSEventType_name = map[int32]string{
	0: "CREATE",
	1: "UPDATE",
	2: "DELETE",
	3: "ENABLED",
	4: "DISABLED",
}
var DataSourceEvent_DSEventType_value = map[string]int32{
	"CREATE":   0,
	"UPDATE":   1,
	"DELETE":   2,
	"ENABLED":  3,
	"DISABLED": 4,
}

func (x DataSourceEvent_DSEventType) String() string {
	return proto.EnumName(DataSourceEvent_DSEventType_name, int32(x))
}
func (DataSourceEvent_DSEventType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{4, 0}
}

type CleanResourcesRequest struct {
}

func (m *CleanResourcesRequest) Reset()                    { *m = CleanResourcesRequest{} }
func (m *CleanResourcesRequest) String() string            { return proto.CompactTextString(m) }
func (*CleanResourcesRequest) ProtoMessage()               {}
func (*CleanResourcesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

type CleanResourcesResponse struct {
	Success bool   `protobuf:"varint,1,opt,name=Success" json:"Success,omitempty"`
	Message string `protobuf:"bytes,2,opt,name=Message" json:"Message,omitempty"`
}

func (m *CleanResourcesResponse) Reset()                    { *m = CleanResourcesResponse{} }
func (m *CleanResourcesResponse) String() string            { return proto.CompactTextString(m) }
func (*CleanResourcesResponse) ProtoMessage()               {}
func (*CleanResourcesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *CleanResourcesResponse) GetSuccess() bool {
	if m != nil {
		return m.Success
	}
	return false
}

func (m *CleanResourcesResponse) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

// DataSource Object description
type DataSource struct {
	// Name of the data source (max length 34)
	Name string `protobuf:"bytes,1,opt,name=Name" json:"Name,omitempty"`
	// Whether this data source is disabled or running
	Disabled bool `protobuf:"varint,2,opt,name=Disabled" json:"Disabled,omitempty"`
	// Type of underlying storage (LOCAL, S3, AZURE, GCS)
	StorageType StorageType `protobuf:"varint,3,opt,name=StorageType,enum=object.StorageType" json:"StorageType,omitempty"`
	// List of key values describing storage configuration
	StorageConfiguration map[string]string `protobuf:"bytes,4,rep,name=StorageConfiguration" json:"StorageConfiguration,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Corresponding objects service name (underlying s3 service)
	ObjectsServiceName string `protobuf:"bytes,18,opt,name=ObjectsServiceName" json:"ObjectsServiceName,omitempty"`
	// Corresponding objects service host
	ObjectsHost string `protobuf:"bytes,12,opt,name=ObjectsHost" json:"ObjectsHost,omitempty"`
	// Corresponding objects service port
	ObjectsPort int32 `protobuf:"varint,5,opt,name=ObjectsPort" json:"ObjectsPort,omitempty"`
	// Corresponding objects service connection type
	ObjectsSecure bool `protobuf:"varint,13,opt,name=ObjectsSecure" json:"ObjectsSecure,omitempty"`
	// Corresponding objects service bucket
	ObjectsBucket string `protobuf:"bytes,14,opt,name=ObjectsBucket" json:"ObjectsBucket,omitempty"`
	// Corresponding objects service base folder inside the bucket
	ObjectsBaseFolder string `protobuf:"bytes,15,opt,name=ObjectsBaseFolder" json:"ObjectsBaseFolder,omitempty"`
	// Corresponding objects service api key
	ApiKey string `protobuf:"bytes,16,opt,name=ApiKey" json:"ApiKey,omitempty"`
	// Corresponding objects service api secret
	ApiSecret string `protobuf:"bytes,17,opt,name=ApiSecret" json:"ApiSecret,omitempty"`
	// Peer address of the data source
	PeerAddress string `protobuf:"bytes,19,opt,name=PeerAddress" json:"PeerAddress,omitempty"`
	// Not implemented, whether to watch for underlying changes on the FS
	Watch bool `protobuf:"varint,6,opt,name=Watch" json:"Watch,omitempty"`
	// Store data in flat format (object-storage like)
	FlatStorage bool `protobuf:"varint,20,opt,name=FlatStorage" json:"FlatStorage,omitempty"`
	// Do not trigger resync at start
	SkipSyncOnRestart bool `protobuf:"varint,21,opt,name=SkipSyncOnRestart" json:"SkipSyncOnRestart,omitempty"`
	// Type of encryption applied before sending data to storage
	EncryptionMode EncryptionMode `protobuf:"varint,7,opt,name=EncryptionMode,enum=object.EncryptionMode" json:"EncryptionMode,omitempty"`
	// Encryption key used for encrypting data
	EncryptionKey string `protobuf:"bytes,8,opt,name=EncryptionKey" json:"EncryptionKey,omitempty"`
	// Versioning policy describes how files are kept in the versioning queue
	VersioningPolicyName string `protobuf:"bytes,9,opt,name=VersioningPolicyName" json:"VersioningPolicyName,omitempty"`
	// Data Source creation date
	CreationDate int32 `protobuf:"varint,10,opt,name=CreationDate" json:"CreationDate,omitempty"`
	// Data Source last synchronization date
	LastSynchronizationDate int32 `protobuf:"varint,11,opt,name=LastSynchronizationDate" json:"LastSynchronizationDate,omitempty"`
}

func (m *DataSource) Reset()                    { *m = DataSource{} }
func (m *DataSource) String() string            { return proto.CompactTextString(m) }
func (*DataSource) ProtoMessage()               {}
func (*DataSource) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *DataSource) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DataSource) GetDisabled() bool {
	if m != nil {
		return m.Disabled
	}
	return false
}

func (m *DataSource) GetStorageType() StorageType {
	if m != nil {
		return m.StorageType
	}
	return StorageType_LOCAL
}

func (m *DataSource) GetStorageConfiguration() map[string]string {
	if m != nil {
		return m.StorageConfiguration
	}
	return nil
}

func (m *DataSource) GetObjectsServiceName() string {
	if m != nil {
		return m.ObjectsServiceName
	}
	return ""
}

func (m *DataSource) GetObjectsHost() string {
	if m != nil {
		return m.ObjectsHost
	}
	return ""
}

func (m *DataSource) GetObjectsPort() int32 {
	if m != nil {
		return m.ObjectsPort
	}
	return 0
}

func (m *DataSource) GetObjectsSecure() bool {
	if m != nil {
		return m.ObjectsSecure
	}
	return false
}

func (m *DataSource) GetObjectsBucket() string {
	if m != nil {
		return m.ObjectsBucket
	}
	return ""
}

func (m *DataSource) GetObjectsBaseFolder() string {
	if m != nil {
		return m.ObjectsBaseFolder
	}
	return ""
}

func (m *DataSource) GetApiKey() string {
	if m != nil {
		return m.ApiKey
	}
	return ""
}

func (m *DataSource) GetApiSecret() string {
	if m != nil {
		return m.ApiSecret
	}
	return ""
}

func (m *DataSource) GetPeerAddress() string {
	if m != nil {
		return m.PeerAddress
	}
	return ""
}

func (m *DataSource) GetWatch() bool {
	if m != nil {
		return m.Watch
	}
	return false
}

func (m *DataSource) GetFlatStorage() bool {
	if m != nil {
		return m.FlatStorage
	}
	return false
}

func (m *DataSource) GetSkipSyncOnRestart() bool {
	if m != nil {
		return m.SkipSyncOnRestart
	}
	return false
}

func (m *DataSource) GetEncryptionMode() EncryptionMode {
	if m != nil {
		return m.EncryptionMode
	}
	return EncryptionMode_CLEAR
}

func (m *DataSource) GetEncryptionKey() string {
	if m != nil {
		return m.EncryptionKey
	}
	return ""
}

func (m *DataSource) GetVersioningPolicyName() string {
	if m != nil {
		return m.VersioningPolicyName
	}
	return ""
}

func (m *DataSource) GetCreationDate() int32 {
	if m != nil {
		return m.CreationDate
	}
	return 0
}

func (m *DataSource) GetLastSynchronizationDate() int32 {
	if m != nil {
		return m.LastSynchronizationDate
	}
	return 0
}

// Used a config storage for minio services
type MinioConfig struct {
	// Name of the object service
	Name string `protobuf:"bytes,1,opt,name=Name" json:"Name,omitempty"`
	// Underlying storage type (LOCAL, S3, AZURE, GCS)
	StorageType StorageType `protobuf:"varint,2,opt,name=StorageType,enum=object.StorageType" json:"StorageType,omitempty"`
	// Host where this minio is running
	RunningHost string `protobuf:"bytes,3,opt,name=RunningHost" json:"RunningHost,omitempty"`
	// Whether it is exposed with TLS or not
	RunningSecure bool `protobuf:"varint,4,opt,name=RunningSecure" json:"RunningSecure,omitempty"`
	// Port where this minio is bound
	RunningPort int32 `protobuf:"varint,5,opt,name=RunningPort" json:"RunningPort,omitempty"`
	// Api Key to access this object service
	ApiKey string `protobuf:"bytes,6,opt,name=ApiKey" json:"ApiKey,omitempty"`
	// Api Secret to access this object service
	ApiSecret string `protobuf:"bytes,7,opt,name=ApiSecret" json:"ApiSecret,omitempty"`
	// Url to get info about this object service
	EndpointUrl string `protobuf:"bytes,10,opt,name=EndpointUrl" json:"EndpointUrl,omitempty"`
	// Specific to Local storage type
	LocalFolder string `protobuf:"bytes,8,opt,name=LocalFolder" json:"LocalFolder,omitempty"`
	// Restrict this service to run on a given peer
	PeerAddress string `protobuf:"bytes,9,opt,name=PeerAddress" json:"PeerAddress,omitempty"`
	// Additional configs
	GatewayConfiguration map[string]string `protobuf:"bytes,11,rep,name=GatewayConfiguration" json:"GatewayConfiguration,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *MinioConfig) Reset()                    { *m = MinioConfig{} }
func (m *MinioConfig) String() string            { return proto.CompactTextString(m) }
func (*MinioConfig) ProtoMessage()               {}
func (*MinioConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *MinioConfig) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *MinioConfig) GetStorageType() StorageType {
	if m != nil {
		return m.StorageType
	}
	return StorageType_LOCAL
}

func (m *MinioConfig) GetRunningHost() string {
	if m != nil {
		return m.RunningHost
	}
	return ""
}

func (m *MinioConfig) GetRunningSecure() bool {
	if m != nil {
		return m.RunningSecure
	}
	return false
}

func (m *MinioConfig) GetRunningPort() int32 {
	if m != nil {
		return m.RunningPort
	}
	return 0
}

func (m *MinioConfig) GetApiKey() string {
	if m != nil {
		return m.ApiKey
	}
	return ""
}

func (m *MinioConfig) GetApiSecret() string {
	if m != nil {
		return m.ApiSecret
	}
	return ""
}

func (m *MinioConfig) GetEndpointUrl() string {
	if m != nil {
		return m.EndpointUrl
	}
	return ""
}

func (m *MinioConfig) GetLocalFolder() string {
	if m != nil {
		return m.LocalFolder
	}
	return ""
}

func (m *MinioConfig) GetPeerAddress() string {
	if m != nil {
		return m.PeerAddress
	}
	return ""
}

func (m *MinioConfig) GetGatewayConfiguration() map[string]string {
	if m != nil {
		return m.GatewayConfiguration
	}
	return nil
}

// Used to dispatch some specific events
// across services
type DataSourceEvent struct {
	Type   DataSourceEvent_DSEventType `protobuf:"varint,1,opt,name=Type,enum=object.DataSourceEvent_DSEventType" json:"Type,omitempty"`
	Name   string                      `protobuf:"bytes,2,opt,name=Name" json:"Name,omitempty"`
	Config *DataSource                 `protobuf:"bytes,3,opt,name=Config" json:"Config,omitempty"`
}

func (m *DataSourceEvent) Reset()                    { *m = DataSourceEvent{} }
func (m *DataSourceEvent) String() string            { return proto.CompactTextString(m) }
func (*DataSourceEvent) ProtoMessage()               {}
func (*DataSourceEvent) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *DataSourceEvent) GetType() DataSourceEvent_DSEventType {
	if m != nil {
		return m.Type
	}
	return DataSourceEvent_CREATE
}

func (m *DataSourceEvent) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DataSourceEvent) GetConfig() *DataSource {
	if m != nil {
		return m.Config
	}
	return nil
}

type DataSourceSingleQuery struct {
	Name                      string            `protobuf:"bytes,1,opt,name=Name" json:"Name,omitempty"`
	IsDisabled                bool              `protobuf:"varint,2,opt,name=IsDisabled" json:"IsDisabled,omitempty"`
	StorageType               StorageTypeFilter `protobuf:"varint,3,opt,name=StorageType,enum=object.StorageTypeFilter" json:"StorageType,omitempty"`
	PeerAddress               string            `protobuf:"bytes,4,opt,name=PeerAddress" json:"PeerAddress,omitempty"`
	FlatStorage               bool              `protobuf:"varint,5,opt,name=FlatStorage" json:"FlatStorage,omitempty"`
	SkipSyncOnRestart         bool              `protobuf:"varint,6,opt,name=SkipSyncOnRestart" json:"SkipSyncOnRestart,omitempty"`
	IsVersioned               bool              `protobuf:"varint,9,opt,name=IsVersioned" json:"IsVersioned,omitempty"`
	IsEncrypted               bool              `protobuf:"varint,17,opt,name=IsEncrypted" json:"IsEncrypted,omitempty"`
	EncryptionMode            EncryptionMode    `protobuf:"varint,7,opt,name=EncryptionMode,enum=object.EncryptionMode" json:"EncryptionMode,omitempty"`
	EncryptionKey             string            `protobuf:"bytes,8,opt,name=EncryptionKey" json:"EncryptionKey,omitempty"`
	VersioningPolicyName      string            `protobuf:"bytes,10,opt,name=VersioningPolicyName" json:"VersioningPolicyName,omitempty"`
	StorageConfigurationName  string            `protobuf:"bytes,13,opt,name=StorageConfigurationName" json:"StorageConfigurationName,omitempty"`
	StorageConfigurationValue string            `protobuf:"bytes,14,opt,name=StorageConfigurationValue" json:"StorageConfigurationValue,omitempty"`
	ObjectServiceName         string            `protobuf:"bytes,15,opt,name=ObjectServiceName" json:"ObjectServiceName,omitempty"`
	Not                       bool              `protobuf:"varint,16,opt,name=Not" json:"Not,omitempty"`
}

func (m *DataSourceSingleQuery) Reset()                    { *m = DataSourceSingleQuery{} }
func (m *DataSourceSingleQuery) String() string            { return proto.CompactTextString(m) }
func (*DataSourceSingleQuery) ProtoMessage()               {}
func (*DataSourceSingleQuery) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *DataSourceSingleQuery) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DataSourceSingleQuery) GetIsDisabled() bool {
	if m != nil {
		return m.IsDisabled
	}
	return false
}

func (m *DataSourceSingleQuery) GetStorageType() StorageTypeFilter {
	if m != nil {
		return m.StorageType
	}
	return StorageTypeFilter_ANY
}

func (m *DataSourceSingleQuery) GetPeerAddress() string {
	if m != nil {
		return m.PeerAddress
	}
	return ""
}

func (m *DataSourceSingleQuery) GetFlatStorage() bool {
	if m != nil {
		return m.FlatStorage
	}
	return false
}

func (m *DataSourceSingleQuery) GetSkipSyncOnRestart() bool {
	if m != nil {
		return m.SkipSyncOnRestart
	}
	return false
}

func (m *DataSourceSingleQuery) GetIsVersioned() bool {
	if m != nil {
		return m.IsVersioned
	}
	return false
}

func (m *DataSourceSingleQuery) GetIsEncrypted() bool {
	if m != nil {
		return m.IsEncrypted
	}
	return false
}

func (m *DataSourceSingleQuery) GetEncryptionMode() EncryptionMode {
	if m != nil {
		return m.EncryptionMode
	}
	return EncryptionMode_CLEAR
}

func (m *DataSourceSingleQuery) GetEncryptionKey() string {
	if m != nil {
		return m.EncryptionKey
	}
	return ""
}

func (m *DataSourceSingleQuery) GetVersioningPolicyName() string {
	if m != nil {
		return m.VersioningPolicyName
	}
	return ""
}

func (m *DataSourceSingleQuery) GetStorageConfigurationName() string {
	if m != nil {
		return m.StorageConfigurationName
	}
	return ""
}

func (m *DataSourceSingleQuery) GetStorageConfigurationValue() string {
	if m != nil {
		return m.StorageConfigurationValue
	}
	return ""
}

func (m *DataSourceSingleQuery) GetObjectServiceName() string {
	if m != nil {
		return m.ObjectServiceName
	}
	return ""
}

func (m *DataSourceSingleQuery) GetNot() bool {
	if m != nil {
		return m.Not
	}
	return false
}

type GetMinioConfigRequest struct {
}

func (m *GetMinioConfigRequest) Reset()                    { *m = GetMinioConfigRequest{} }
func (m *GetMinioConfigRequest) String() string            { return proto.CompactTextString(m) }
func (*GetMinioConfigRequest) ProtoMessage()               {}
func (*GetMinioConfigRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

type GetMinioConfigResponse struct {
	MinioConfig *MinioConfig `protobuf:"bytes,1,opt,name=MinioConfig" json:"MinioConfig,omitempty"`
}

func (m *GetMinioConfigResponse) Reset()                    { *m = GetMinioConfigResponse{} }
func (m *GetMinioConfigResponse) String() string            { return proto.CompactTextString(m) }
func (*GetMinioConfigResponse) ProtoMessage()               {}
func (*GetMinioConfigResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *GetMinioConfigResponse) GetMinioConfig() *MinioConfig {
	if m != nil {
		return m.MinioConfig
	}
	return nil
}

type StorageStatsRequest struct {
}

func (m *StorageStatsRequest) Reset()                    { *m = StorageStatsRequest{} }
func (m *StorageStatsRequest) String() string            { return proto.CompactTextString(m) }
func (*StorageStatsRequest) ProtoMessage()               {}
func (*StorageStatsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

type StorageStatsResponse struct {
	Stats map[string]string `protobuf:"bytes,1,rep,name=Stats" json:"Stats,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *StorageStatsResponse) Reset()                    { *m = StorageStatsResponse{} }
func (m *StorageStatsResponse) String() string            { return proto.CompactTextString(m) }
func (*StorageStatsResponse) ProtoMessage()               {}
func (*StorageStatsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *StorageStatsResponse) GetStats() map[string]string {
	if m != nil {
		return m.Stats
	}
	return nil
}

type GetDataSourceConfigRequest struct {
}

func (m *GetDataSourceConfigRequest) Reset()                    { *m = GetDataSourceConfigRequest{} }
func (m *GetDataSourceConfigRequest) String() string            { return proto.CompactTextString(m) }
func (*GetDataSourceConfigRequest) ProtoMessage()               {}
func (*GetDataSourceConfigRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

type GetDataSourceConfigResponse struct {
	DataSource *DataSource `protobuf:"bytes,1,opt,name=DataSource" json:"DataSource,omitempty"`
}

func (m *GetDataSourceConfigResponse) Reset()                    { *m = GetDataSourceConfigResponse{} }
func (m *GetDataSourceConfigResponse) String() string            { return proto.CompactTextString(m) }
func (*GetDataSourceConfigResponse) ProtoMessage()               {}
func (*GetDataSourceConfigResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *GetDataSourceConfigResponse) GetDataSource() *DataSource {
	if m != nil {
		return m.DataSource
	}
	return nil
}

func init() {
	proto.RegisterType((*CleanResourcesRequest)(nil), "object.CleanResourcesRequest")
	proto.RegisterType((*CleanResourcesResponse)(nil), "object.CleanResourcesResponse")
	proto.RegisterType((*DataSource)(nil), "object.DataSource")
	proto.RegisterType((*MinioConfig)(nil), "object.MinioConfig")
	proto.RegisterType((*DataSourceEvent)(nil), "object.DataSourceEvent")
	proto.RegisterType((*DataSourceSingleQuery)(nil), "object.DataSourceSingleQuery")
	proto.RegisterType((*GetMinioConfigRequest)(nil), "object.GetMinioConfigRequest")
	proto.RegisterType((*GetMinioConfigResponse)(nil), "object.GetMinioConfigResponse")
	proto.RegisterType((*StorageStatsRequest)(nil), "object.StorageStatsRequest")
	proto.RegisterType((*StorageStatsResponse)(nil), "object.StorageStatsResponse")
	proto.RegisterType((*GetDataSourceConfigRequest)(nil), "object.GetDataSourceConfigRequest")
	proto.RegisterType((*GetDataSourceConfigResponse)(nil), "object.GetDataSourceConfigResponse")
	proto.RegisterEnum("object.StorageType", StorageType_name, StorageType_value)
	proto.RegisterEnum("object.EncryptionMode", EncryptionMode_name, EncryptionMode_value)
	proto.RegisterEnum("object.StorageTypeFilter", StorageTypeFilter_name, StorageTypeFilter_value)
	proto.RegisterEnum("object.DataSourceEvent_DSEventType", DataSourceEvent_DSEventType_name, DataSourceEvent_DSEventType_value)
}

func init() { proto.RegisterFile("object.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 1306 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x57, 0xed, 0x6e, 0xdb, 0x36,
	0x17, 0x8e, 0xfc, 0xed, 0xe3, 0x34, 0x55, 0x99, 0x8f, 0xaa, 0x6e, 0xdf, 0xbe, 0x86, 0x3a, 0x60,
	0x41, 0xd0, 0xba, 0x80, 0x8b, 0x6e, 0x45, 0xf7, 0x05, 0xd9, 0x56, 0xb2, 0xa0, 0x76, 0x92, 0x4a,
	0x49, 0x8b, 0x0d, 0x18, 0x56, 0x45, 0x66, 0x5d, 0x2d, 0xae, 0xe8, 0x49, 0x74, 0x5a, 0xef, 0x12,
	0xf6, 0x67, 0xc0, 0xee, 0x64, 0xb7, 0xb1, 0x2b, 0xd8, 0xbf, 0x01, 0xbb, 0x92, 0x81, 0x47, 0xb2,
	0x45, 0xd9, 0x72, 0xd0, 0xfe, 0xda, 0x2f, 0x93, 0xcf, 0x79, 0x48, 0x53, 0x87, 0xcf, 0x79, 0x48,
	0xc2, 0x3a, 0x3b, 0xff, 0x89, 0xba, 0xbc, 0x39, 0x0e, 0x18, 0x67, 0xa4, 0x14, 0xf5, 0xea, 0x9f,
	0x0d, 0x3d, 0xfe, 0x66, 0x72, 0xde, 0x74, 0xd9, 0xdb, 0x87, 0x6f, 0xdf, 0x79, 0xfc, 0x82, 0xbd,
	0x7b, 0x38, 0x64, 0x0f, 0x90, 0xf4, 0xe0, 0xd2, 0x19, 0x79, 0x03, 0x87, 0xb3, 0x20, 0x7c, 0x38,
	0x6f, 0x46, 0xe3, 0xf5, 0x9b, 0xb0, 0xdd, 0x19, 0x51, 0xc7, 0xb7, 0x68, 0xc8, 0x26, 0x81, 0x4b,
	0x43, 0x8b, 0xfe, 0x3c, 0xa1, 0x21, 0xd7, 0x7b, 0xb0, 0xb3, 0x18, 0x08, 0xc7, 0xcc, 0x0f, 0x29,
	0xd1, 0xa0, 0x6c, 0x4f, 0x5c, 0x97, 0x86, 0xa1, 0xa6, 0x34, 0x94, 0xdd, 0x8a, 0x35, 0xeb, 0x8a,
	0x48, 0x9f, 0x86, 0xa1, 0x33, 0xa4, 0x5a, 0xae, 0xa1, 0xec, 0x56, 0xad, 0x59, 0x57, 0xff, 0xb3,
	0x0c, 0xd0, 0x75, 0xb8, 0x63, 0xe3, 0x5c, 0xa4, 0x0e, 0x85, 0x23, 0xe7, 0x2d, 0xc5, 0xf1, 0xd5,
	0x76, 0xe9, 0x9f, 0xbf, 0xff, 0x9f, 0x7b, 0xaf, 0x5b, 0x88, 0x91, 0x3a, 0x54, 0xba, 0x5e, 0xe8,
	0x9c, 0x8f, 0xe8, 0x00, 0x67, 0xa9, 0x58, 0xf3, 0x3e, 0x79, 0x0c, 0x35, 0x9b, 0xb3, 0xc0, 0x19,
	0xd2, 0xd3, 0xe9, 0x98, 0x6a, 0xf9, 0x86, 0xb2, 0xbb, 0xd1, 0xda, 0x6c, 0xc6, 0x19, 0x91, 0x42,
	0x96, 0xcc, 0x23, 0xaf, 0x60, 0x2b, 0xee, 0x76, 0x98, 0xff, 0xda, 0x1b, 0x4e, 0x02, 0x87, 0x7b,
	0xcc, 0xd7, 0x0a, 0x8d, 0xfc, 0x6e, 0xad, 0x75, 0x7f, 0x36, 0x3e, 0x59, 0x60, 0x33, 0x8b, 0x6e,
	0xfa, 0x3c, 0x98, 0x5a, 0x99, 0x33, 0x91, 0x26, 0x90, 0x63, 0x9c, 0x24, 0xb4, 0x69, 0x70, 0xe9,
	0xb9, 0x14, 0x3f, 0x8f, 0x60, 0x12, 0x32, 0x22, 0xa4, 0x01, 0xb5, 0x18, 0xfd, 0x96, 0x85, 0x5c,
	0x5b, 0x47, 0xa2, 0x0c, 0x49, 0x8c, 0x13, 0x16, 0x70, 0xad, 0xd8, 0x50, 0x76, 0x8b, 0x96, 0x0c,
	0x91, 0x4f, 0xe0, 0xda, 0x7c, 0x66, 0x77, 0x12, 0x50, 0xed, 0x1a, 0x66, 0x2b, 0x0d, 0x4a, 0xac,
	0xf6, 0xc4, 0xbd, 0xa0, 0x5c, 0xdb, 0xc0, 0xff, 0x4a, 0x83, 0xe4, 0x3e, 0xdc, 0x98, 0x01, 0x4e,
	0x48, 0xf7, 0xd9, 0x68, 0x40, 0x03, 0xed, 0x3a, 0x32, 0x97, 0x03, 0x64, 0x07, 0x4a, 0xc6, 0xd8,
	0x7b, 0x46, 0xa7, 0x9a, 0x8a, 0x94, 0xb8, 0x47, 0xee, 0x40, 0xd5, 0x18, 0x7b, 0x36, 0x75, 0x03,
	0xca, 0xb5, 0x1b, 0x18, 0x4a, 0x00, 0xf1, 0x45, 0x27, 0x94, 0x06, 0xc6, 0x60, 0x10, 0x08, 0xed,
	0x6c, 0x46, 0xdf, 0x2c, 0x41, 0x64, 0x0b, 0x8a, 0x2f, 0x1d, 0xee, 0xbe, 0xd1, 0x4a, 0xf8, 0x25,
	0x51, 0x47, 0x8c, 0xdb, 0x1f, 0x39, 0x3c, 0xce, 0xbb, 0xb6, 0x85, 0x31, 0x19, 0x12, 0xab, 0xb7,
	0x2f, 0xbc, 0xb1, 0x3d, 0xf5, 0xdd, 0x63, 0x21, 0x58, 0xee, 0x04, 0x5c, 0xdb, 0x46, 0xde, 0x72,
	0x80, 0x7c, 0x0d, 0x1b, 0xa6, 0xef, 0x06, 0xd3, 0xb1, 0xd8, 0xb9, 0x3e, 0x1b, 0x50, 0xad, 0x8c,
	0x3a, 0xda, 0x99, 0xe9, 0x20, 0x1d, 0xb5, 0x16, 0xd8, 0x22, 0xa3, 0x09, 0x22, 0x92, 0x50, 0x89,
	0x32, 0x9a, 0x02, 0x49, 0x0b, 0xb6, 0x5e, 0xd0, 0x20, 0xf4, 0x98, 0xef, 0xf9, 0xc3, 0x13, 0x36,
	0xf2, 0xdc, 0x29, 0x6a, 0xa2, 0x8a, 0xe4, 0xcc, 0x18, 0xd1, 0x61, 0xbd, 0x13, 0x50, 0x54, 0x54,
	0xd7, 0xe1, 0x54, 0x03, 0xdc, 0xf4, 0x14, 0x46, 0x9e, 0xc0, 0xcd, 0x9e, 0x13, 0x72, 0xf1, 0x49,
	0x6f, 0x02, 0xe6, 0x7b, 0xbf, 0x24, 0xf4, 0x1a, 0xd2, 0x57, 0x85, 0xeb, 0x07, 0x70, 0x6b, 0xa5,
	0xac, 0x89, 0x0a, 0xf9, 0x0b, 0x3a, 0x8d, 0x0a, 0xd2, 0x12, 0x4d, 0xb1, 0x19, 0x97, 0xce, 0x68,
	0x32, 0x2b, 0xe5, 0xa8, 0xf3, 0x34, 0xf7, 0x44, 0xd1, 0x7f, 0x2d, 0x40, 0xad, 0xef, 0xf9, 0x1e,
	0x8b, 0xe6, 0x21, 0x44, 0xae, 0xe6, 0xb8, 0x8a, 0x17, 0x2a, 0x35, 0xf7, 0x81, 0x95, 0xda, 0x80,
	0x9a, 0x35, 0xf1, 0x45, 0x5a, 0xb0, 0x2e, 0xf2, 0x91, 0x46, 0x24, 0x48, 0x64, 0x3f, 0xee, 0xc6,
	0xaa, 0x2f, 0x44, 0xaa, 0x4f, 0x81, 0xd2, 0x3c, 0x72, 0xf5, 0x48, 0x90, 0xa4, 0xe1, 0xd2, 0x6a,
	0x0d, 0x97, 0x33, 0x34, 0x6c, 0xfa, 0x83, 0x31, 0xf3, 0x7c, 0x7e, 0x16, 0x8c, 0x70, 0x83, 0xaa,
	0x96, 0x0c, 0x09, 0x46, 0x8f, 0xb9, 0xce, 0x28, 0xae, 0xa1, 0x48, 0x1b, 0x32, 0xb4, 0x58, 0x07,
	0xd5, 0xe5, 0x3a, 0x70, 0x60, 0xeb, 0xc0, 0xe1, 0xf4, 0x9d, 0x33, 0x4d, 0xfb, 0x55, 0x0d, 0xfd,
	0xea, 0xc1, 0x2c, 0x8b, 0xd2, 0x1e, 0x34, 0xb3, 0xf8, 0xb1, 0x61, 0x65, 0x85, 0x84, 0x18, 0x56,
	0x0e, 0xf9, 0x28, 0x31, 0xfc, 0xa5, 0xc0, 0xf5, 0xc4, 0x38, 0xcd, 0x4b, 0xea, 0x73, 0xf2, 0x39,
	0x14, 0x70, 0xd7, 0x15, 0xdc, 0xf5, 0x7b, 0xcb, 0xfe, 0x8a, 0xb4, 0x66, 0xd7, 0xc6, 0x5f, 0x54,
	0x01, 0x0e, 0x98, 0x2b, 0x29, 0x27, 0x29, 0x69, 0x0f, 0x4a, 0xd1, 0x12, 0x51, 0x0d, 0xb5, 0x16,
	0x59, 0x9e, 0xce, 0x8a, 0x19, 0x7a, 0x0f, 0x6a, 0xd2, 0xa4, 0x04, 0xa0, 0xd4, 0xb1, 0x4c, 0xe3,
	0xd4, 0x54, 0xd7, 0x44, 0xfb, 0xec, 0xa4, 0x2b, 0xda, 0x8a, 0x68, 0x77, 0xcd, 0x9e, 0x79, 0x6a,
	0xaa, 0x39, 0x52, 0x83, 0xb2, 0x79, 0x64, 0xb4, 0x7b, 0x66, 0x57, 0xcd, 0x93, 0x75, 0xa8, 0x74,
	0x0f, 0xed, 0xa8, 0x57, 0xd0, 0x7f, 0x2f, 0xc2, 0x76, 0xf2, 0x27, 0xb6, 0xe7, 0x0f, 0x47, 0xf4,
	0xf9, 0x84, 0x06, 0xd3, 0x4c, 0xc5, 0xdf, 0x05, 0x38, 0x0c, 0x17, 0x4e, 0x2e, 0x09, 0x21, 0x5f,
	0x64, 0x9d, 0x5d, 0xb7, 0x32, 0x2a, 0x62, 0xdf, 0x1b, 0x71, 0x1a, 0x2c, 0xd5, 0x85, 0xac, 0x99,
	0xc2, 0xb2, 0x66, 0x16, 0x5c, 0xb2, 0xf8, 0x81, 0x2e, 0x59, 0x5a, 0xe5, 0x92, 0x0d, 0xa8, 0x1d,
	0x86, 0xb1, 0x4b, 0xd1, 0x01, 0xaa, 0xb4, 0x62, 0xc9, 0x50, 0xc4, 0x88, 0x4d, 0x8f, 0x0e, 0xd0,
	0xef, 0x91, 0x31, 0x87, 0xfe, 0x63, 0xa7, 0x85, 0x2b, 0x9c, 0xf6, 0x29, 0x68, 0x59, 0x5e, 0x88,
	0xe3, 0xae, 0xe1, 0xb8, 0x95, 0x71, 0xf2, 0x65, 0xb6, 0x8f, 0xbe, 0xc0, 0xfa, 0x88, 0x4e, 0xd7,
	0xd5, 0x84, 0xe4, 0xa4, 0x95, 0x2f, 0x0a, 0xa9, 0x93, 0x56, 0xbe, 0x27, 0xa8, 0x90, 0x3f, 0x62,
	0x1c, 0x8f, 0xd9, 0x8a, 0x25, 0x9a, 0xe2, 0xc2, 0x76, 0x40, 0xb9, 0x54, 0xfa, 0xb3, 0x0b, 0xdb,
	0x31, 0xec, 0x2c, 0x06, 0xe2, 0x0b, 0xdb, 0xe3, 0x94, 0x5d, 0xa3, 0x68, 0x6b, 0x89, 0x17, 0xcb,
	0x23, 0x64, 0x9e, 0xbe, 0x0d, 0x9b, 0xf1, 0x67, 0xd8, 0xdc, 0xe1, 0xf3, 0x8b, 0xe1, 0x6f, 0xca,
	0xfc, 0x36, 0x15, 0xe3, 0xf1, 0xdf, 0x7c, 0x05, 0x45, 0x04, 0x34, 0x05, 0x6d, 0xea, 0xd3, 0x05,
	0x69, 0xa7, 0xc8, 0x4d, 0xec, 0x45, 0x06, 0x15, 0x8d, 0xaa, 0x3f, 0x01, 0x48, 0xc0, 0x8f, 0xb2,
	0xa0, 0x3b, 0x50, 0x3f, 0xa0, 0x3c, 0xa9, 0xd4, 0x74, 0x5e, 0x9e, 0xc3, 0xed, 0xcc, 0x68, 0xbc,
	0xea, 0x96, 0x7c, 0x31, 0x8d, 0x73, 0x93, 0x65, 0x31, 0x12, 0x6b, 0x6f, 0x90, 0x2a, 0x65, 0x52,
	0x85, 0x62, 0xef, 0xb8, 0x63, 0xf4, 0xd4, 0x35, 0x52, 0x82, 0x9c, 0xfd, 0x48, 0x55, 0x48, 0x19,
	0xf2, 0x76, 0xbf, 0xad, 0xe6, 0x44, 0xac, 0x63, 0xf6, 0x7a, 0xb6, 0x5a, 0x10, 0x4d, 0xe3, 0xfb,
	0x33, 0xcb, 0x54, 0x8b, 0x22, 0x7c, 0xd0, 0xb1, 0xd5, 0x92, 0xe0, 0xb7, 0x5b, 0x6a, 0x59, 0xc4,
	0xfa, 0xc6, 0xd1, 0xa9, 0xa1, 0x56, 0x70, 0xe8, 0xa1, 0xa1, 0x56, 0xf7, 0xbe, 0x59, 0xac, 0x1e,
	0x9c, 0xac, 0x67, 0x1a, 0x56, 0x64, 0x67, 0x7d, 0xc3, 0x3e, 0x35, 0x2d, 0x55, 0x21, 0x15, 0x28,
	0x9c, 0xd9, 0xa6, 0xa5, 0xe6, 0x84, 0x7f, 0x89, 0xd6, 0x8f, 0x27, 0x2f, 0xbb, 0x6a, 0x7e, 0xef,
	0x31, 0xdc, 0x58, 0xb2, 0x15, 0x31, 0xbd, 0x71, 0xf4, 0x9d, 0xba, 0x26, 0x8c, 0x0f, 0x57, 0xbd,
	0x6f, 0x47, 0x8e, 0x68, 0x99, 0xfd, 0x63, 0xe1, 0x88, 0xad, 0x3f, 0x14, 0xb8, 0x1e, 0xdf, 0xf9,
	0x66, 0x07, 0x1b, 0x79, 0x0e, 0x1b, 0x69, 0x71, 0x91, 0xff, 0xcd, 0x72, 0x94, 0xa9, 0xc6, 0xfa,
	0xdd, 0x55, 0xe1, 0x28, 0xed, 0xfa, 0x1a, 0x79, 0x06, 0xeb, 0xb2, 0x32, 0xc8, 0xed, 0x6c, 0xbd,
	0x44, 0xd3, 0xdd, 0xb9, 0x4a, 0x4c, 0xfa, 0x5a, 0xeb, 0x12, 0x88, 0x74, 0xba, 0xcc, 0x56, 0xfd,
	0x0a, 0x36, 0x33, 0xb6, 0x9e, 0xe8, 0xd2, 0xda, 0x56, 0xa8, 0xa6, 0x7e, 0xef, 0x4a, 0xce, 0xfc,
	0x7f, 0xdf, 0xc3, 0xcd, 0xd9, 0x03, 0x09, 0x5f, 0x4b, 0x34, 0x98, 0xff, 0xf9, 0x0f, 0x50, 0x4f,
	0x3f, 0xa0, 0xda, 0xf4, 0x35, 0x0b, 0x68, 0x97, 0x8e, 0x28, 0xa7, 0x49, 0xfa, 0x32, 0x5f, 0x5f,
	0x49, 0xfa, 0xb2, 0xdf, 0x60, 0xfa, 0xda, 0x79, 0x09, 0xdf, 0x6f, 0x8f, 0xfe, 0x0d, 0x00, 0x00,
	0xff, 0xff, 0xfa, 0x15, 0x56, 0x49, 0x0f, 0x0e, 0x00, 0x00,
}
