// Code generated by protoc-gen-go. DO NOT EDIT.
// source: registry.proto

/*
Package go_micro_registry is a generated protocol buffer package.

It is generated from these files:
	registry.proto

It has these top-level messages:
	Service
	Node
	Endpoint
	Value
	Options
	Result
	EmptyResponse
	GetRequest
	GetResponse
	ListRequest
	ListResponse
	WatchRequest
	Event
*/
package go_micro_registry

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// EventType defines the type of event
type EventType int32

const (
	EventType_Create EventType = 0
	EventType_Delete EventType = 1
	EventType_Update EventType = 2
)

var EventType_name = map[int32]string{
	0: "Create",
	1: "Delete",
	2: "Update",
}
var EventType_value = map[string]int32{
	"Create": 0,
	"Delete": 1,
	"Update": 2,
}

func (x EventType) String() string {
	return proto.EnumName(EventType_name, int32(x))
}
func (EventType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

// Service represents a go-micro service
type Service struct {
	Name      string            `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	Version   string            `protobuf:"bytes,2,opt,name=version" json:"version,omitempty"`
	Metadata  map[string]string `protobuf:"bytes,3,rep,name=metadata" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	Endpoints []*Endpoint       `protobuf:"bytes,4,rep,name=endpoints" json:"endpoints,omitempty"`
	Nodes     []*Node           `protobuf:"bytes,5,rep,name=nodes" json:"nodes,omitempty"`
	Options   *Options          `protobuf:"bytes,6,opt,name=options" json:"options,omitempty"`
}

func (m *Service) Reset()                    { *m = Service{} }
func (m *Service) String() string            { return proto.CompactTextString(m) }
func (*Service) ProtoMessage()               {}
func (*Service) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *Service) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Service) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *Service) GetMetadata() map[string]string {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *Service) GetEndpoints() []*Endpoint {
	if m != nil {
		return m.Endpoints
	}
	return nil
}

func (m *Service) GetNodes() []*Node {
	if m != nil {
		return m.Nodes
	}
	return nil
}

func (m *Service) GetOptions() *Options {
	if m != nil {
		return m.Options
	}
	return nil
}

// Node represents the node the service is on
type Node struct {
	Id       string            `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Address  string            `protobuf:"bytes,2,opt,name=address" json:"address,omitempty"`
	Port     int64             `protobuf:"varint,3,opt,name=port" json:"port,omitempty"`
	Metadata map[string]string `protobuf:"bytes,4,rep,name=metadata" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *Node) Reset()                    { *m = Node{} }
func (m *Node) String() string            { return proto.CompactTextString(m) }
func (*Node) ProtoMessage()               {}
func (*Node) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *Node) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Node) GetAddress() string {
	if m != nil {
		return m.Address
	}
	return ""
}

func (m *Node) GetPort() int64 {
	if m != nil {
		return m.Port
	}
	return 0
}

func (m *Node) GetMetadata() map[string]string {
	if m != nil {
		return m.Metadata
	}
	return nil
}

// Endpoint is a endpoint provided by a service
type Endpoint struct {
	Name     string            `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	Request  *Value            `protobuf:"bytes,2,opt,name=request" json:"request,omitempty"`
	Response *Value            `protobuf:"bytes,3,opt,name=response" json:"response,omitempty"`
	Metadata map[string]string `protobuf:"bytes,4,rep,name=metadata" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *Endpoint) Reset()                    { *m = Endpoint{} }
func (m *Endpoint) String() string            { return proto.CompactTextString(m) }
func (*Endpoint) ProtoMessage()               {}
func (*Endpoint) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *Endpoint) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Endpoint) GetRequest() *Value {
	if m != nil {
		return m.Request
	}
	return nil
}

func (m *Endpoint) GetResponse() *Value {
	if m != nil {
		return m.Response
	}
	return nil
}

func (m *Endpoint) GetMetadata() map[string]string {
	if m != nil {
		return m.Metadata
	}
	return nil
}

// Value is an opaque value for a request or response
type Value struct {
	Name   string   `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	Type   string   `protobuf:"bytes,2,opt,name=type" json:"type,omitempty"`
	Values []*Value `protobuf:"bytes,3,rep,name=values" json:"values,omitempty"`
}

func (m *Value) Reset()                    { *m = Value{} }
func (m *Value) String() string            { return proto.CompactTextString(m) }
func (*Value) ProtoMessage()               {}
func (*Value) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *Value) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Value) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *Value) GetValues() []*Value {
	if m != nil {
		return m.Values
	}
	return nil
}

// Options are registry options
type Options struct {
	Ttl int64 `protobuf:"varint,1,opt,name=ttl" json:"ttl,omitempty"`
}

func (m *Options) Reset()                    { *m = Options{} }
func (m *Options) String() string            { return proto.CompactTextString(m) }
func (*Options) ProtoMessage()               {}
func (*Options) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *Options) GetTtl() int64 {
	if m != nil {
		return m.Ttl
	}
	return 0
}

// Result is returns by the watcher
type Result struct {
	Action    string   `protobuf:"bytes,1,opt,name=action" json:"action,omitempty"`
	Service   *Service `protobuf:"bytes,2,opt,name=service" json:"service,omitempty"`
	Timestamp int64    `protobuf:"varint,3,opt,name=timestamp" json:"timestamp,omitempty"`
}

func (m *Result) Reset()                    { *m = Result{} }
func (m *Result) String() string            { return proto.CompactTextString(m) }
func (*Result) ProtoMessage()               {}
func (*Result) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *Result) GetAction() string {
	if m != nil {
		return m.Action
	}
	return ""
}

func (m *Result) GetService() *Service {
	if m != nil {
		return m.Service
	}
	return nil
}

func (m *Result) GetTimestamp() int64 {
	if m != nil {
		return m.Timestamp
	}
	return 0
}

type EmptyResponse struct {
}

func (m *EmptyResponse) Reset()                    { *m = EmptyResponse{} }
func (m *EmptyResponse) String() string            { return proto.CompactTextString(m) }
func (*EmptyResponse) ProtoMessage()               {}
func (*EmptyResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

type GetRequest struct {
	Service string `protobuf:"bytes,1,opt,name=service" json:"service,omitempty"`
}

func (m *GetRequest) Reset()                    { *m = GetRequest{} }
func (m *GetRequest) String() string            { return proto.CompactTextString(m) }
func (*GetRequest) ProtoMessage()               {}
func (*GetRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *GetRequest) GetService() string {
	if m != nil {
		return m.Service
	}
	return ""
}

type GetResponse struct {
	Services []*Service `protobuf:"bytes,1,rep,name=services" json:"services,omitempty"`
}

func (m *GetResponse) Reset()                    { *m = GetResponse{} }
func (m *GetResponse) String() string            { return proto.CompactTextString(m) }
func (*GetResponse) ProtoMessage()               {}
func (*GetResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *GetResponse) GetServices() []*Service {
	if m != nil {
		return m.Services
	}
	return nil
}

type ListRequest struct {
}

func (m *ListRequest) Reset()                    { *m = ListRequest{} }
func (m *ListRequest) String() string            { return proto.CompactTextString(m) }
func (*ListRequest) ProtoMessage()               {}
func (*ListRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

type ListResponse struct {
	Services []*Service `protobuf:"bytes,1,rep,name=services" json:"services,omitempty"`
}

func (m *ListResponse) Reset()                    { *m = ListResponse{} }
func (m *ListResponse) String() string            { return proto.CompactTextString(m) }
func (*ListResponse) ProtoMessage()               {}
func (*ListResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *ListResponse) GetServices() []*Service {
	if m != nil {
		return m.Services
	}
	return nil
}

type WatchRequest struct {
	// service is optional
	Service string `protobuf:"bytes,1,opt,name=service" json:"service,omitempty"`
}

func (m *WatchRequest) Reset()                    { *m = WatchRequest{} }
func (m *WatchRequest) String() string            { return proto.CompactTextString(m) }
func (*WatchRequest) ProtoMessage()               {}
func (*WatchRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *WatchRequest) GetService() string {
	if m != nil {
		return m.Service
	}
	return ""
}

// Event is registry event
type Event struct {
	// Event Id
	Id string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	// type of event
	Type EventType `protobuf:"varint,2,opt,name=type,enum=go.micro.registry.EventType" json:"type,omitempty"`
	// unix timestamp of event
	Timestamp int64 `protobuf:"varint,3,opt,name=timestamp" json:"timestamp,omitempty"`
	// service entry
	Service *Service `protobuf:"bytes,4,opt,name=service" json:"service,omitempty"`
}

func (m *Event) Reset()                    { *m = Event{} }
func (m *Event) String() string            { return proto.CompactTextString(m) }
func (*Event) ProtoMessage()               {}
func (*Event) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *Event) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Event) GetType() EventType {
	if m != nil {
		return m.Type
	}
	return EventType_Create
}

func (m *Event) GetTimestamp() int64 {
	if m != nil {
		return m.Timestamp
	}
	return 0
}

func (m *Event) GetService() *Service {
	if m != nil {
		return m.Service
	}
	return nil
}

func init() {
	proto.RegisterType((*Service)(nil), "go.micro.registry.Service")
	proto.RegisterType((*Node)(nil), "go.micro.registry.Node")
	proto.RegisterType((*Endpoint)(nil), "go.micro.registry.Endpoint")
	proto.RegisterType((*Value)(nil), "go.micro.registry.Value")
	proto.RegisterType((*Options)(nil), "go.micro.registry.Options")
	proto.RegisterType((*Result)(nil), "go.micro.registry.Result")
	proto.RegisterType((*EmptyResponse)(nil), "go.micro.registry.EmptyResponse")
	proto.RegisterType((*GetRequest)(nil), "go.micro.registry.GetRequest")
	proto.RegisterType((*GetResponse)(nil), "go.micro.registry.GetResponse")
	proto.RegisterType((*ListRequest)(nil), "go.micro.registry.ListRequest")
	proto.RegisterType((*ListResponse)(nil), "go.micro.registry.ListResponse")
	proto.RegisterType((*WatchRequest)(nil), "go.micro.registry.WatchRequest")
	proto.RegisterType((*Event)(nil), "go.micro.registry.Event")
	proto.RegisterEnum("go.micro.registry.EventType", EventType_name, EventType_value)
}

func init() { proto.RegisterFile("registry.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 667 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x55, 0xdd, 0x6e, 0xd3, 0x4c,
	0x10, 0x8d, 0xed, 0xfc, 0x4e, 0xda, 0x7e, 0xfd, 0x46, 0x08, 0x8c, 0x5b, 0x20, 0xb2, 0x04, 0x0a,
	0x48, 0x84, 0x2a, 0x54, 0x88, 0x9f, 0x2b, 0x44, 0x43, 0x25, 0xd4, 0x82, 0x58, 0xfe, 0xae, 0x4d,
	0x3c, 0x2a, 0x16, 0x89, 0x6d, 0x76, 0xb7, 0x91, 0xf2, 0x0e, 0x48, 0x3c, 0x01, 0x6f, 0xc3, 0x53,
	0xf0, 0x34, 0x68, 0xd7, 0xeb, 0x24, 0x55, 0xd7, 0x01, 0xa9, 0x70, 0x37, 0xe3, 0x3d, 0x33, 0x3b,
	0x73, 0xce, 0x59, 0x19, 0xb6, 0x38, 0x9d, 0x24, 0x42, 0xf2, 0xf9, 0x20, 0xe7, 0x99, 0xcc, 0xf0,
	0xff, 0x93, 0x6c, 0x30, 0x4d, 0xc6, 0x3c, 0x1b, 0x94, 0x07, 0xe1, 0x4f, 0x17, 0x5a, 0x6f, 0x88,
	0xcf, 0x92, 0x31, 0x21, 0x42, 0x3d, 0x8d, 0xa6, 0xe4, 0x3b, 0x3d, 0xa7, 0xdf, 0x61, 0x3a, 0x46,
	0x1f, 0x5a, 0x33, 0xe2, 0x22, 0xc9, 0x52, 0xdf, 0xd5, 0x9f, 0xcb, 0x14, 0x0f, 0xa0, 0x3d, 0x25,
	0x19, 0xc5, 0x91, 0x8c, 0x7c, 0xaf, 0xe7, 0xf5, 0xbb, 0xc3, 0xfe, 0xe0, 0x5c, 0xff, 0x81, 0xe9,
	0x3d, 0x38, 0x36, 0xd0, 0x51, 0x2a, 0xf9, 0x9c, 0x2d, 0x2a, 0xf1, 0x11, 0x74, 0x28, 0x8d, 0xf3,
	0x2c, 0x49, 0xa5, 0xf0, 0xeb, 0xba, 0xcd, 0x8e, 0xa5, 0xcd, 0xc8, 0x60, 0xd8, 0x12, 0x8d, 0x77,
	0xa1, 0x91, 0x66, 0x31, 0x09, 0xbf, 0xa1, 0xcb, 0xae, 0x58, 0xca, 0x5e, 0x66, 0x31, 0xb1, 0x02,
	0x85, 0xfb, 0xd0, 0xca, 0x72, 0x99, 0x64, 0xa9, 0xf0, 0x9b, 0x3d, 0xa7, 0xdf, 0x1d, 0x06, 0x96,
	0x82, 0x57, 0x05, 0x82, 0x95, 0xd0, 0xe0, 0x09, 0x6c, 0x9e, 0x19, 0x1d, 0xb7, 0xc1, 0xfb, 0x4c,
	0x73, 0xc3, 0x91, 0x0a, 0xf1, 0x12, 0x34, 0x66, 0xd1, 0xe4, 0x94, 0x0c, 0x41, 0x45, 0xf2, 0xd8,
	0x7d, 0xe8, 0x84, 0x3f, 0x1c, 0xa8, 0xab, 0x11, 0x70, 0x0b, 0xdc, 0x24, 0x36, 0x35, 0x6e, 0x12,
	0x2b, 0x56, 0xa3, 0x38, 0xe6, 0x24, 0x44, 0xc9, 0xaa, 0x49, 0x95, 0x06, 0x79, 0xc6, 0xa5, 0xef,
	0xf5, 0x9c, 0xbe, 0xc7, 0x74, 0x8c, 0x4f, 0x57, 0x98, 0x2e, 0x28, 0xba, 0x59, 0xb1, 0x6b, 0x15,
	0xcd, 0x17, 0x5b, 0xe3, 0xab, 0x0b, 0xed, 0x52, 0x00, 0xab, 0x49, 0x86, 0xd0, 0xe2, 0xf4, 0xe5,
	0x94, 0x84, 0xd4, 0xc5, 0xdd, 0xa1, 0x6f, 0x99, 0xef, 0xbd, 0xea, 0xc7, 0x4a, 0x20, 0xee, 0x43,
	0x9b, 0x93, 0xc8, 0xb3, 0x54, 0x90, 0x5e, 0x76, 0x5d, 0xd1, 0x02, 0x89, 0xa3, 0x73, 0x54, 0xdc,
	0x5e, 0xe3, 0x96, 0x7f, 0x43, 0x47, 0x04, 0x0d, 0x3d, 0x96, 0x95, 0x0a, 0x84, 0xba, 0x9c, 0xe7,
	0x65, 0x95, 0x8e, 0x71, 0x0f, 0x9a, 0xba, 0x5a, 0x98, 0x77, 0x52, 0xbd, 0xa8, 0xc1, 0x85, 0x3b,
	0xd0, 0x32, 0x4e, 0x54, 0x93, 0x49, 0x39, 0xd1, 0x77, 0x78, 0x4c, 0x85, 0xa1, 0x84, 0x26, 0x23,
	0x71, 0x3a, 0x91, 0x78, 0x19, 0x9a, 0xd1, 0x58, 0xc1, 0xcc, 0x08, 0x26, 0x53, 0x56, 0x17, 0xc5,
	0xbb, 0x33, 0x7a, 0x04, 0xd5, 0x2f, 0x93, 0x95, 0x50, 0xdc, 0x85, 0x8e, 0x4c, 0xa6, 0x24, 0x64,
	0x34, 0xcd, 0x8d, 0xff, 0x96, 0x1f, 0xc2, 0xff, 0x60, 0x73, 0x34, 0xcd, 0xe5, 0x9c, 0x19, 0x29,
	0xc2, 0x5b, 0x00, 0x87, 0x24, 0x99, 0x91, 0xd3, 0x5f, 0x5e, 0x59, 0xcc, 0x52, 0xa6, 0xe1, 0x08,
	0xba, 0x1a, 0x67, 0x14, 0x7c, 0x00, 0x6d, 0x73, 0x22, 0x7c, 0x47, 0xd3, 0xb1, 0x6e, 0xb8, 0x05,
	0x36, 0xdc, 0x84, 0xee, 0x51, 0x22, 0xca, 0xfb, 0xc2, 0xe7, 0xb0, 0x51, 0xa4, 0x17, 0x6c, 0xdb,
	0x87, 0x8d, 0x0f, 0x91, 0x1c, 0x7f, 0xfa, 0xfd, 0x1e, 0xdf, 0x1d, 0x68, 0x8c, 0x66, 0x94, 0xca,
	0x73, 0xaf, 0x79, 0x6f, 0x45, 0xf3, 0xad, 0xe1, 0xae, 0xcd, 0x90, 0xaa, 0xee, 0xed, 0x3c, 0x27,
	0xe3, 0x88, 0xb5, 0x54, 0xaf, 0xca, 0x57, 0xff, 0x63, 0xf9, 0xee, 0xdc, 0x83, 0xce, 0xe2, 0x1a,
	0x04, 0x68, 0x3e, 0xe3, 0x14, 0x49, 0xda, 0xae, 0xa9, 0xf8, 0x80, 0x26, 0x24, 0x69, 0xdb, 0x51,
	0xf1, 0xbb, 0x3c, 0x56, 0xdf, 0xdd, 0xe1, 0x37, 0x0f, 0xda, 0xcc, 0xb4, 0xc3, 0x63, 0xad, 0x66,
	0xf9, 0x27, 0xb8, 0x66, 0xb9, 0x70, 0x29, 0x76, 0x70, 0xbd, 0xea, 0xd8, 0x58, 0xa3, 0x86, 0x2f,
	0xca, 0xd6, 0xc4, 0x71, 0xcd, 0xf4, 0x41, 0xcf, 0x46, 0xd6, 0x19, 0x9b, 0xd5, 0xf0, 0x08, 0xe0,
	0x80, 0xf8, 0xdf, 0xea, 0xf6, 0xba, 0x30, 0x8e, 0x29, 0x11, 0x68, 0xdb, 0x65, 0xc5, 0x68, 0xc1,
	0x8d, 0xca, 0xf3, 0x45, 0xcb, 0x43, 0x68, 0x68, 0x0f, 0xa1, 0x0d, 0xbb, 0xea, 0xae, 0xe0, 0xaa,
	0x05, 0x50, 0xbc, 0xe5, 0xb0, 0xb6, 0xe7, 0x7c, 0x6c, 0xea, 0xdf, 0xf4, 0xfd, 0x5f, 0x01, 0x00,
	0x00, 0xff, 0xff, 0xfb, 0x3e, 0x7d, 0xa4, 0xb8, 0x07, 0x00, 0x00,
}
