// Code generated by protoc-gen-go. DO NOT EDIT.
// source: config.proto

package rest

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import tree "github.com/pydio/cells/common/proto/tree"
import object "github.com/pydio/cells/common/proto/object"
import ctl "github.com/pydio/cells/common/proto/ctl"
import install "github.com/pydio/cells/common/proto/install"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Configuration message. Data is an Json representation of any value
type Configuration struct {
	// Full slash-separated path to the config key
	FullPath string `protobuf:"bytes,1,opt,name=FullPath" json:"FullPath,omitempty"`
	// JSON-encoded data to store
	Data string `protobuf:"bytes,2,opt,name=Data" json:"Data,omitempty"`
}

func (m *Configuration) Reset()                    { *m = Configuration{} }
func (m *Configuration) String() string            { return proto.CompactTextString(m) }
func (*Configuration) ProtoMessage()               {}
func (*Configuration) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{0} }

func (m *Configuration) GetFullPath() string {
	if m != nil {
		return m.FullPath
	}
	return ""
}

func (m *Configuration) GetData() string {
	if m != nil {
		return m.Data
	}
	return ""
}

type ListDataSourceRequest struct {
}

func (m *ListDataSourceRequest) Reset()                    { *m = ListDataSourceRequest{} }
func (m *ListDataSourceRequest) String() string            { return proto.CompactTextString(m) }
func (*ListDataSourceRequest) ProtoMessage()               {}
func (*ListDataSourceRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{1} }

// Collection of datasources
type DataSourceCollection struct {
	DataSources []*object.DataSource `protobuf:"bytes,1,rep,name=DataSources" json:"DataSources,omitempty"`
	Total       int32                `protobuf:"varint,2,opt,name=Total" json:"Total,omitempty"`
}

func (m *DataSourceCollection) Reset()                    { *m = DataSourceCollection{} }
func (m *DataSourceCollection) String() string            { return proto.CompactTextString(m) }
func (*DataSourceCollection) ProtoMessage()               {}
func (*DataSourceCollection) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{2} }

func (m *DataSourceCollection) GetDataSources() []*object.DataSource {
	if m != nil {
		return m.DataSources
	}
	return nil
}

func (m *DataSourceCollection) GetTotal() int32 {
	if m != nil {
		return m.Total
	}
	return 0
}

type DeleteDataSourceResponse struct {
	Success bool `protobuf:"varint,1,opt,name=Success" json:"Success,omitempty"`
}

func (m *DeleteDataSourceResponse) Reset()                    { *m = DeleteDataSourceResponse{} }
func (m *DeleteDataSourceResponse) String() string            { return proto.CompactTextString(m) }
func (*DeleteDataSourceResponse) ProtoMessage()               {}
func (*DeleteDataSourceResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{3} }

func (m *DeleteDataSourceResponse) GetSuccess() bool {
	if m != nil {
		return m.Success
	}
	return false
}

type ListPeersAddressesRequest struct {
}

func (m *ListPeersAddressesRequest) Reset()                    { *m = ListPeersAddressesRequest{} }
func (m *ListPeersAddressesRequest) String() string            { return proto.CompactTextString(m) }
func (*ListPeersAddressesRequest) ProtoMessage()               {}
func (*ListPeersAddressesRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{4} }

type ListPeersAddressesResponse struct {
	// List of peer addresses
	PeerAddresses []string `protobuf:"bytes,1,rep,name=PeerAddresses" json:"PeerAddresses,omitempty"`
}

func (m *ListPeersAddressesResponse) Reset()                    { *m = ListPeersAddressesResponse{} }
func (m *ListPeersAddressesResponse) String() string            { return proto.CompactTextString(m) }
func (*ListPeersAddressesResponse) ProtoMessage()               {}
func (*ListPeersAddressesResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{5} }

func (m *ListPeersAddressesResponse) GetPeerAddresses() []string {
	if m != nil {
		return m.PeerAddresses
	}
	return nil
}

type ListPeerFoldersRequest struct {
	// Restrict listing to a given peer
	PeerAddress string `protobuf:"bytes,1,opt,name=PeerAddress" json:"PeerAddress,omitempty"`
	// Path to the parent folder for listing
	Path string `protobuf:"bytes,2,opt,name=Path" json:"Path,omitempty"`
}

func (m *ListPeerFoldersRequest) Reset()                    { *m = ListPeerFoldersRequest{} }
func (m *ListPeerFoldersRequest) String() string            { return proto.CompactTextString(m) }
func (*ListPeerFoldersRequest) ProtoMessage()               {}
func (*ListPeerFoldersRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{6} }

func (m *ListPeerFoldersRequest) GetPeerAddress() string {
	if m != nil {
		return m.PeerAddress
	}
	return ""
}

func (m *ListPeerFoldersRequest) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

type CreatePeerFolderRequest struct {
	// Restrict listing to a given peer
	PeerAddress string `protobuf:"bytes,1,opt,name=PeerAddress" json:"PeerAddress,omitempty"`
	// Path to the folder to be created
	Path string `protobuf:"bytes,2,opt,name=Path" json:"Path,omitempty"`
}

func (m *CreatePeerFolderRequest) Reset()                    { *m = CreatePeerFolderRequest{} }
func (m *CreatePeerFolderRequest) String() string            { return proto.CompactTextString(m) }
func (*CreatePeerFolderRequest) ProtoMessage()               {}
func (*CreatePeerFolderRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{7} }

func (m *CreatePeerFolderRequest) GetPeerAddress() string {
	if m != nil {
		return m.PeerAddress
	}
	return ""
}

func (m *CreatePeerFolderRequest) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

type CreatePeerFolderResponse struct {
	Success bool       `protobuf:"varint,1,opt,name=Success" json:"Success,omitempty"`
	Node    *tree.Node `protobuf:"bytes,2,opt,name=Node" json:"Node,omitempty"`
}

func (m *CreatePeerFolderResponse) Reset()                    { *m = CreatePeerFolderResponse{} }
func (m *CreatePeerFolderResponse) String() string            { return proto.CompactTextString(m) }
func (*CreatePeerFolderResponse) ProtoMessage()               {}
func (*CreatePeerFolderResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{8} }

func (m *CreatePeerFolderResponse) GetSuccess() bool {
	if m != nil {
		return m.Success
	}
	return false
}

func (m *CreatePeerFolderResponse) GetNode() *tree.Node {
	if m != nil {
		return m.Node
	}
	return nil
}

type ListStorageBucketsRequest struct {
	DataSource    *object.DataSource `protobuf:"bytes,1,opt,name=DataSource" json:"DataSource,omitempty"`
	BucketsRegexp string             `protobuf:"bytes,2,opt,name=BucketsRegexp" json:"BucketsRegexp,omitempty"`
}

func (m *ListStorageBucketsRequest) Reset()                    { *m = ListStorageBucketsRequest{} }
func (m *ListStorageBucketsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListStorageBucketsRequest) ProtoMessage()               {}
func (*ListStorageBucketsRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{9} }

func (m *ListStorageBucketsRequest) GetDataSource() *object.DataSource {
	if m != nil {
		return m.DataSource
	}
	return nil
}

func (m *ListStorageBucketsRequest) GetBucketsRegexp() string {
	if m != nil {
		return m.BucketsRegexp
	}
	return ""
}

type Process struct {
	// Process ID
	ID string `protobuf:"bytes,1,opt,name=ID" json:"ID,omitempty"`
	// Parent Process ID
	ParentID string `protobuf:"bytes,2,opt,name=ParentID" json:"ParentID,omitempty"`
	// Port to access the metrics api
	MetricsPort int32 `protobuf:"varint,3,opt,name=MetricsPort" json:"MetricsPort,omitempty"`
	// Id of peer node
	PeerId string `protobuf:"bytes,4,opt,name=PeerId" json:"PeerId,omitempty"`
	// Address of peer node
	PeerAddress string `protobuf:"bytes,5,opt,name=PeerAddress" json:"PeerAddress,omitempty"`
	// Parameters used to start this process
	StartTag string `protobuf:"bytes,6,opt,name=StartTag" json:"StartTag,omitempty"`
	// List of services running inside this process
	Services []string `protobuf:"bytes,7,rep,name=Services" json:"Services,omitempty"`
}

func (m *Process) Reset()                    { *m = Process{} }
func (m *Process) String() string            { return proto.CompactTextString(m) }
func (*Process) ProtoMessage()               {}
func (*Process) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{10} }

func (m *Process) GetID() string {
	if m != nil {
		return m.ID
	}
	return ""
}

func (m *Process) GetParentID() string {
	if m != nil {
		return m.ParentID
	}
	return ""
}

func (m *Process) GetMetricsPort() int32 {
	if m != nil {
		return m.MetricsPort
	}
	return 0
}

func (m *Process) GetPeerId() string {
	if m != nil {
		return m.PeerId
	}
	return ""
}

func (m *Process) GetPeerAddress() string {
	if m != nil {
		return m.PeerAddress
	}
	return ""
}

func (m *Process) GetStartTag() string {
	if m != nil {
		return m.StartTag
	}
	return ""
}

func (m *Process) GetServices() []string {
	if m != nil {
		return m.Services
	}
	return nil
}

type ListProcessesRequest struct {
	// Id of the peer node
	PeerId string `protobuf:"bytes,1,opt,name=PeerId" json:"PeerId,omitempty"`
	// Look for a service name
	ServiceName string `protobuf:"bytes,2,opt,name=ServiceName" json:"ServiceName,omitempty"`
}

func (m *ListProcessesRequest) Reset()                    { *m = ListProcessesRequest{} }
func (m *ListProcessesRequest) String() string            { return proto.CompactTextString(m) }
func (*ListProcessesRequest) ProtoMessage()               {}
func (*ListProcessesRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{11} }

func (m *ListProcessesRequest) GetPeerId() string {
	if m != nil {
		return m.PeerId
	}
	return ""
}

func (m *ListProcessesRequest) GetServiceName() string {
	if m != nil {
		return m.ServiceName
	}
	return ""
}

type ListProcessesResponse struct {
	Processes []*Process `protobuf:"bytes,1,rep,name=Processes" json:"Processes,omitempty"`
}

func (m *ListProcessesResponse) Reset()                    { *m = ListProcessesResponse{} }
func (m *ListProcessesResponse) String() string            { return proto.CompactTextString(m) }
func (*ListProcessesResponse) ProtoMessage()               {}
func (*ListProcessesResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{12} }

func (m *ListProcessesResponse) GetProcesses() []*Process {
	if m != nil {
		return m.Processes
	}
	return nil
}

type ListVersioningPolicyRequest struct {
}

func (m *ListVersioningPolicyRequest) Reset()                    { *m = ListVersioningPolicyRequest{} }
func (m *ListVersioningPolicyRequest) String() string            { return proto.CompactTextString(m) }
func (*ListVersioningPolicyRequest) ProtoMessage()               {}
func (*ListVersioningPolicyRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{13} }

type VersioningPolicyCollection struct {
	Policies []*tree.VersioningPolicy `protobuf:"bytes,1,rep,name=Policies" json:"Policies,omitempty"`
}

func (m *VersioningPolicyCollection) Reset()                    { *m = VersioningPolicyCollection{} }
func (m *VersioningPolicyCollection) String() string            { return proto.CompactTextString(m) }
func (*VersioningPolicyCollection) ProtoMessage()               {}
func (*VersioningPolicyCollection) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{14} }

func (m *VersioningPolicyCollection) GetPolicies() []*tree.VersioningPolicy {
	if m != nil {
		return m.Policies
	}
	return nil
}

type ListVirtualNodesRequest struct {
}

func (m *ListVirtualNodesRequest) Reset()                    { *m = ListVirtualNodesRequest{} }
func (m *ListVirtualNodesRequest) String() string            { return proto.CompactTextString(m) }
func (*ListVirtualNodesRequest) ProtoMessage()               {}
func (*ListVirtualNodesRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{15} }

type ListServiceRequest struct {
	// Filter services by a given status (ANY, STOPPED, STOPPING, RUNNING)
	StatusFilter ctl.ServiceStatus `protobuf:"varint,1,opt,name=StatusFilter,enum=ctl.ServiceStatus" json:"StatusFilter,omitempty"`
}

func (m *ListServiceRequest) Reset()                    { *m = ListServiceRequest{} }
func (m *ListServiceRequest) String() string            { return proto.CompactTextString(m) }
func (*ListServiceRequest) ProtoMessage()               {}
func (*ListServiceRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{16} }

func (m *ListServiceRequest) GetStatusFilter() ctl.ServiceStatus {
	if m != nil {
		return m.StatusFilter
	}
	return ctl.ServiceStatus_ANY
}

type ServiceCollection struct {
	Services []*ctl.Service `protobuf:"bytes,1,rep,name=Services" json:"Services,omitempty"`
	Total    int32          `protobuf:"varint,2,opt,name=Total" json:"Total,omitempty"`
}

func (m *ServiceCollection) Reset()                    { *m = ServiceCollection{} }
func (m *ServiceCollection) String() string            { return proto.CompactTextString(m) }
func (*ServiceCollection) ProtoMessage()               {}
func (*ServiceCollection) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{17} }

func (m *ServiceCollection) GetServices() []*ctl.Service {
	if m != nil {
		return m.Services
	}
	return nil
}

func (m *ServiceCollection) GetTotal() int32 {
	if m != nil {
		return m.Total
	}
	return 0
}

type ControlServiceRequest struct {
	// Name of the service to stop
	ServiceName string `protobuf:"bytes,1,opt,name=ServiceName" json:"ServiceName,omitempty"`
	// Name of the node
	NodeName string `protobuf:"bytes,2,opt,name=NodeName" json:"NodeName,omitempty"`
	// Command to apply (START or STOP)
	Command ctl.ServiceCommand `protobuf:"varint,3,opt,name=Command,enum=ctl.ServiceCommand" json:"Command,omitempty"`
}

func (m *ControlServiceRequest) Reset()                    { *m = ControlServiceRequest{} }
func (m *ControlServiceRequest) String() string            { return proto.CompactTextString(m) }
func (*ControlServiceRequest) ProtoMessage()               {}
func (*ControlServiceRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{18} }

func (m *ControlServiceRequest) GetServiceName() string {
	if m != nil {
		return m.ServiceName
	}
	return ""
}

func (m *ControlServiceRequest) GetNodeName() string {
	if m != nil {
		return m.NodeName
	}
	return ""
}

func (m *ControlServiceRequest) GetCommand() ctl.ServiceCommand {
	if m != nil {
		return m.Command
	}
	return ctl.ServiceCommand_START
}

type DiscoveryRequest struct {
	// Filter result to a specific endpoint type
	EndpointType string `protobuf:"bytes,1,opt,name=EndpointType" json:"EndpointType,omitempty"`
}

func (m *DiscoveryRequest) Reset()                    { *m = DiscoveryRequest{} }
func (m *DiscoveryRequest) String() string            { return proto.CompactTextString(m) }
func (*DiscoveryRequest) ProtoMessage()               {}
func (*DiscoveryRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{19} }

func (m *DiscoveryRequest) GetEndpointType() string {
	if m != nil {
		return m.EndpointType
	}
	return ""
}

type DiscoveryResponse struct {
	// Current Package Type, empty if user is not authenticated
	PackageType string `protobuf:"bytes,1,opt,name=PackageType" json:"PackageType,omitempty"`
	// Current Package Label, empty if user is not authenticated
	PackageLabel string `protobuf:"bytes,2,opt,name=PackageLabel" json:"PackageLabel,omitempty"`
	// Current Package Version, empty if user is not authenticated
	Version string `protobuf:"bytes,3,opt,name=Version" json:"Version,omitempty"`
	// Build stamp of the binary build, empty if user is not authenticated
	BuildStamp int32 `protobuf:"varint,4,opt,name=BuildStamp" json:"BuildStamp,omitempty"`
	// Revision of the current binary build, empty if user is not authenticated
	BuildRevision string `protobuf:"bytes,5,opt,name=BuildRevision" json:"BuildRevision,omitempty"`
	// List of endpoints and their corresponding URL access. Special case for grpc that just send back its port
	Endpoints map[string]string `protobuf:"bytes,6,rep,name=Endpoints" json:"Endpoints,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *DiscoveryResponse) Reset()                    { *m = DiscoveryResponse{} }
func (m *DiscoveryResponse) String() string            { return proto.CompactTextString(m) }
func (*DiscoveryResponse) ProtoMessage()               {}
func (*DiscoveryResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{20} }

func (m *DiscoveryResponse) GetPackageType() string {
	if m != nil {
		return m.PackageType
	}
	return ""
}

func (m *DiscoveryResponse) GetPackageLabel() string {
	if m != nil {
		return m.PackageLabel
	}
	return ""
}

func (m *DiscoveryResponse) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *DiscoveryResponse) GetBuildStamp() int32 {
	if m != nil {
		return m.BuildStamp
	}
	return 0
}

func (m *DiscoveryResponse) GetBuildRevision() string {
	if m != nil {
		return m.BuildRevision
	}
	return ""
}

func (m *DiscoveryResponse) GetEndpoints() map[string]string {
	if m != nil {
		return m.Endpoints
	}
	return nil
}

type ConfigFormRequest struct {
	// Retrieve a configuration form for a given service
	ServiceName string `protobuf:"bytes,1,opt,name=ServiceName" json:"ServiceName,omitempty"`
}

func (m *ConfigFormRequest) Reset()                    { *m = ConfigFormRequest{} }
func (m *ConfigFormRequest) String() string            { return proto.CompactTextString(m) }
func (*ConfigFormRequest) ProtoMessage()               {}
func (*ConfigFormRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{21} }

func (m *ConfigFormRequest) GetServiceName() string {
	if m != nil {
		return m.ServiceName
	}
	return ""
}

type OpenApiResponse struct {
}

func (m *OpenApiResponse) Reset()                    { *m = OpenApiResponse{} }
func (m *OpenApiResponse) String() string            { return proto.CompactTextString(m) }
func (*OpenApiResponse) ProtoMessage()               {}
func (*OpenApiResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{22} }

type ActionDescription struct {
	// Unique name of the action
	Name string `protobuf:"bytes,1,opt,name=Name" json:"Name,omitempty"`
	// Mdi reference name for displaying icon
	Icon string `protobuf:"bytes,2,opt,name=Icon" json:"Icon,omitempty"`
	// Human-readable label
	Label string `protobuf:"bytes,3,opt,name=Label" json:"Label,omitempty"`
	// Long description and help text
	Description string `protobuf:"bytes,4,opt,name=Description" json:"Description,omitempty"`
	// Template for building a short summary of the action configuration
	SummaryTemplate string `protobuf:"bytes,5,opt,name=SummaryTemplate" json:"SummaryTemplate,omitempty"`
	// Whether this action has a form or not
	HasForm bool `protobuf:"varint,6,opt,name=HasForm" json:"HasForm,omitempty"`
	// JS module name to be used instead of loading standard form
	FormModule string `protobuf:"bytes,11,opt,name=FormModule" json:"FormModule,omitempty"`
	// JSON props used to init the FormModule (optional)
	FormModuleProps string `protobuf:"bytes,12,opt,name=FormModuleProps" json:"FormModuleProps,omitempty"`
	// User-defined category to organize actions list
	Category string `protobuf:"bytes,7,opt,name=Category" json:"Category,omitempty"`
	// User-defined hexa or rgb color
	Tint string `protobuf:"bytes,8,opt,name=Tint" json:"Tint,omitempty"`
	// Additional description for expected inputs
	InputDescription string `protobuf:"bytes,9,opt,name=InputDescription" json:"InputDescription,omitempty"`
	// Additional description describing the action output
	OutputDescription string `protobuf:"bytes,10,opt,name=OutputDescription" json:"OutputDescription,omitempty"`
	// If action is declared internal, it is hidden to avoid polluting the list.
	IsInternal bool `protobuf:"varint,13,opt,name=IsInternal" json:"IsInternal,omitempty"`
}

func (m *ActionDescription) Reset()                    { *m = ActionDescription{} }
func (m *ActionDescription) String() string            { return proto.CompactTextString(m) }
func (*ActionDescription) ProtoMessage()               {}
func (*ActionDescription) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{23} }

func (m *ActionDescription) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ActionDescription) GetIcon() string {
	if m != nil {
		return m.Icon
	}
	return ""
}

func (m *ActionDescription) GetLabel() string {
	if m != nil {
		return m.Label
	}
	return ""
}

func (m *ActionDescription) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *ActionDescription) GetSummaryTemplate() string {
	if m != nil {
		return m.SummaryTemplate
	}
	return ""
}

func (m *ActionDescription) GetHasForm() bool {
	if m != nil {
		return m.HasForm
	}
	return false
}

func (m *ActionDescription) GetFormModule() string {
	if m != nil {
		return m.FormModule
	}
	return ""
}

func (m *ActionDescription) GetFormModuleProps() string {
	if m != nil {
		return m.FormModuleProps
	}
	return ""
}

func (m *ActionDescription) GetCategory() string {
	if m != nil {
		return m.Category
	}
	return ""
}

func (m *ActionDescription) GetTint() string {
	if m != nil {
		return m.Tint
	}
	return ""
}

func (m *ActionDescription) GetInputDescription() string {
	if m != nil {
		return m.InputDescription
	}
	return ""
}

func (m *ActionDescription) GetOutputDescription() string {
	if m != nil {
		return m.OutputDescription
	}
	return ""
}

func (m *ActionDescription) GetIsInternal() bool {
	if m != nil {
		return m.IsInternal
	}
	return false
}

type SchedulerActionsRequest struct {
}

func (m *SchedulerActionsRequest) Reset()                    { *m = SchedulerActionsRequest{} }
func (m *SchedulerActionsRequest) String() string            { return proto.CompactTextString(m) }
func (*SchedulerActionsRequest) ProtoMessage()               {}
func (*SchedulerActionsRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{24} }

type SchedulerActionsResponse struct {
	// List of all registered actions
	Actions map[string]*ActionDescription `protobuf:"bytes,1,rep,name=Actions" json:"Actions,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *SchedulerActionsResponse) Reset()                    { *m = SchedulerActionsResponse{} }
func (m *SchedulerActionsResponse) String() string            { return proto.CompactTextString(m) }
func (*SchedulerActionsResponse) ProtoMessage()               {}
func (*SchedulerActionsResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{25} }

func (m *SchedulerActionsResponse) GetActions() map[string]*ActionDescription {
	if m != nil {
		return m.Actions
	}
	return nil
}

type SchedulerActionFormRequest struct {
	// Name of the action to load
	ActionName string `protobuf:"bytes,1,opt,name=ActionName" json:"ActionName,omitempty"`
}

func (m *SchedulerActionFormRequest) Reset()                    { *m = SchedulerActionFormRequest{} }
func (m *SchedulerActionFormRequest) String() string            { return proto.CompactTextString(m) }
func (*SchedulerActionFormRequest) ProtoMessage()               {}
func (*SchedulerActionFormRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{26} }

func (m *SchedulerActionFormRequest) GetActionName() string {
	if m != nil {
		return m.ActionName
	}
	return ""
}

type SchedulerActionFormResponse struct {
}

func (m *SchedulerActionFormResponse) Reset()                    { *m = SchedulerActionFormResponse{} }
func (m *SchedulerActionFormResponse) String() string            { return proto.CompactTextString(m) }
func (*SchedulerActionFormResponse) ProtoMessage()               {}
func (*SchedulerActionFormResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{27} }

// Request used for ListSites api
type ListSitesRequest struct {
	Filter string `protobuf:"bytes,1,opt,name=Filter" json:"Filter,omitempty"`
}

func (m *ListSitesRequest) Reset()                    { *m = ListSitesRequest{} }
func (m *ListSitesRequest) String() string            { return proto.CompactTextString(m) }
func (*ListSitesRequest) ProtoMessage()               {}
func (*ListSitesRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{28} }

func (m *ListSitesRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

// Response with declared sites
type ListSitesResponse struct {
	Sites []*install.ProxyConfig `protobuf:"bytes,1,rep,name=Sites" json:"Sites,omitempty"`
}

func (m *ListSitesResponse) Reset()                    { *m = ListSitesResponse{} }
func (m *ListSitesResponse) String() string            { return proto.CompactTextString(m) }
func (*ListSitesResponse) ProtoMessage()               {}
func (*ListSitesResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{29} }

func (m *ListSitesResponse) GetSites() []*install.ProxyConfig {
	if m != nil {
		return m.Sites
	}
	return nil
}

func init() {
	proto.RegisterType((*Configuration)(nil), "rest.Configuration")
	proto.RegisterType((*ListDataSourceRequest)(nil), "rest.ListDataSourceRequest")
	proto.RegisterType((*DataSourceCollection)(nil), "rest.DataSourceCollection")
	proto.RegisterType((*DeleteDataSourceResponse)(nil), "rest.DeleteDataSourceResponse")
	proto.RegisterType((*ListPeersAddressesRequest)(nil), "rest.ListPeersAddressesRequest")
	proto.RegisterType((*ListPeersAddressesResponse)(nil), "rest.ListPeersAddressesResponse")
	proto.RegisterType((*ListPeerFoldersRequest)(nil), "rest.ListPeerFoldersRequest")
	proto.RegisterType((*CreatePeerFolderRequest)(nil), "rest.CreatePeerFolderRequest")
	proto.RegisterType((*CreatePeerFolderResponse)(nil), "rest.CreatePeerFolderResponse")
	proto.RegisterType((*ListStorageBucketsRequest)(nil), "rest.ListStorageBucketsRequest")
	proto.RegisterType((*Process)(nil), "rest.Process")
	proto.RegisterType((*ListProcessesRequest)(nil), "rest.ListProcessesRequest")
	proto.RegisterType((*ListProcessesResponse)(nil), "rest.ListProcessesResponse")
	proto.RegisterType((*ListVersioningPolicyRequest)(nil), "rest.ListVersioningPolicyRequest")
	proto.RegisterType((*VersioningPolicyCollection)(nil), "rest.VersioningPolicyCollection")
	proto.RegisterType((*ListVirtualNodesRequest)(nil), "rest.ListVirtualNodesRequest")
	proto.RegisterType((*ListServiceRequest)(nil), "rest.ListServiceRequest")
	proto.RegisterType((*ServiceCollection)(nil), "rest.ServiceCollection")
	proto.RegisterType((*ControlServiceRequest)(nil), "rest.ControlServiceRequest")
	proto.RegisterType((*DiscoveryRequest)(nil), "rest.DiscoveryRequest")
	proto.RegisterType((*DiscoveryResponse)(nil), "rest.DiscoveryResponse")
	proto.RegisterType((*ConfigFormRequest)(nil), "rest.ConfigFormRequest")
	proto.RegisterType((*OpenApiResponse)(nil), "rest.OpenApiResponse")
	proto.RegisterType((*ActionDescription)(nil), "rest.ActionDescription")
	proto.RegisterType((*SchedulerActionsRequest)(nil), "rest.SchedulerActionsRequest")
	proto.RegisterType((*SchedulerActionsResponse)(nil), "rest.SchedulerActionsResponse")
	proto.RegisterType((*SchedulerActionFormRequest)(nil), "rest.SchedulerActionFormRequest")
	proto.RegisterType((*SchedulerActionFormResponse)(nil), "rest.SchedulerActionFormResponse")
	proto.RegisterType((*ListSitesRequest)(nil), "rest.ListSitesRequest")
	proto.RegisterType((*ListSitesResponse)(nil), "rest.ListSitesResponse")
}

func init() { proto.RegisterFile("config.proto", fileDescriptor2) }

var fileDescriptor2 = []byte{
	// 1165 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x56, 0x5b, 0x4f, 0x1b, 0x47,
	0x14, 0x96, 0x01, 0x63, 0xfb, 0xd8, 0x10, 0xbc, 0x25, 0xb0, 0x71, 0x54, 0x84, 0x56, 0x55, 0x85,
	0x48, 0x63, 0x54, 0x27, 0x4d, 0x2f, 0x8a, 0x14, 0x81, 0x0d, 0xaa, 0x25, 0x02, 0xd6, 0xda, 0xea,
	0xfb, 0x78, 0x77, 0x6a, 0xa6, 0xcc, 0xee, 0x6c, 0x67, 0x66, 0x51, 0xfc, 0xde, 0x7f, 0xd3, 0xf7,
	0xbe, 0xf5, 0x07, 0xf4, 0x5f, 0x55, 0x73, 0xd9, 0xf5, 0xd8, 0x26, 0x2a, 0x52, 0x1f, 0xc0, 0x73,
	0xbe, 0x73, 0x99, 0x73, 0xf9, 0xe6, 0xd8, 0xd0, 0x8a, 0x58, 0xfa, 0x2b, 0x99, 0x75, 0x33, 0xce,
	0x24, 0xf3, 0xb6, 0x38, 0x16, 0xb2, 0xf3, 0x66, 0x46, 0xe4, 0x5d, 0x3e, 0xed, 0x46, 0x2c, 0x39,
	0xcb, 0xe6, 0x31, 0x61, 0x67, 0x11, 0xa6, 0x54, 0x9c, 0x45, 0x2c, 0x49, 0x58, 0x7a, 0xa6, 0x4d,
	0xcf, 0x24, 0xc7, 0x58, 0xff, 0x33, 0xae, 0x9d, 0xef, 0x9f, 0xe2, 0xc4, 0xa6, 0xbf, 0xe1, 0x48,
	0xda, 0x0f, 0xeb, 0xf8, 0xed, 0x53, 0x1c, 0x23, 0x49, 0xd5, 0x9f, 0x75, 0xf9, 0xf1, 0x29, 0x2e,
	0x24, 0x15, 0x12, 0x51, 0x5a, 0x7c, 0x1a, 0xd7, 0xe0, 0x03, 0xec, 0xf4, 0x75, 0xc5, 0x39, 0x47,
	0x92, 0xb0, 0xd4, 0xeb, 0x40, 0xfd, 0x2a, 0xa7, 0x74, 0x84, 0xe4, 0x9d, 0x5f, 0x39, 0xae, 0x9c,
	0x34, 0xc2, 0x52, 0xf6, 0x3c, 0xd8, 0x1a, 0x20, 0x89, 0xfc, 0x0d, 0x8d, 0xeb, 0x73, 0x70, 0x08,
	0xcf, 0xaf, 0x89, 0x90, 0xea, 0x3c, 0x66, 0x39, 0x8f, 0x70, 0x88, 0x7f, 0xcf, 0xb1, 0x90, 0xc1,
	0x14, 0xf6, 0x17, 0x60, 0x9f, 0x51, 0x8a, 0x23, 0x7d, 0xc1, 0x5b, 0x68, 0x2e, 0x70, 0xe1, 0x57,
	0x8e, 0x37, 0x4f, 0x9a, 0x3d, 0xaf, 0x6b, 0x7b, 0xe0, 0xc4, 0x71, 0xcd, 0xbc, 0x7d, 0xa8, 0x4e,
	0x98, 0x44, 0x54, 0xdf, 0x5d, 0x0d, 0x8d, 0x10, 0xbc, 0x05, 0x7f, 0x80, 0x29, 0x96, 0xd8, 0xbd,
	0x5e, 0x64, 0x2c, 0x15, 0xd8, 0xf3, 0xa1, 0x36, 0xce, 0xa3, 0x08, 0x0b, 0xa1, 0xeb, 0xa8, 0x87,
	0x85, 0x18, 0xbc, 0x84, 0x17, 0x2a, 0xe5, 0x11, 0xc6, 0x5c, 0x9c, 0xc7, 0x31, 0xc7, 0x42, 0x60,
	0x51, 0xa4, 0x7d, 0x01, 0x9d, 0xc7, 0x94, 0x36, 0xe8, 0x57, 0xb0, 0xa3, 0x34, 0xa5, 0x42, 0xa7,
	0xdf, 0x08, 0x97, 0xc1, 0xe0, 0x06, 0x0e, 0x8a, 0x18, 0x57, 0x8c, 0xc6, 0x98, 0x17, 0xd1, 0xbd,
	0x63, 0x68, 0x3a, 0xa6, 0xb6, 0xc1, 0x2e, 0xa4, 0x7a, 0xac, 0x7b, 0x6f, 0x7b, 0xac, 0xce, 0xc1,
	0x2d, 0x1c, 0xf6, 0x39, 0x46, 0x12, 0x2f, 0x22, 0xfe, 0xbf, 0x80, 0x13, 0xf0, 0xd7, 0x03, 0xfe,
	0x57, 0xdf, 0xbc, 0x23, 0xd8, 0xba, 0x61, 0x31, 0xd6, 0x91, 0x9a, 0x3d, 0xe8, 0x6a, 0xb6, 0x2b,
	0x24, 0xd4, 0x78, 0x90, 0x9b, 0xbe, 0x8e, 0x25, 0xe3, 0x68, 0x86, 0x2f, 0xf2, 0xe8, 0x1e, 0xcb,
	0xb2, 0xf2, 0x1e, 0xc0, 0x62, 0x48, 0x3a, 0xf2, 0xe3, 0x53, 0x77, 0xac, 0x54, 0xb7, 0xcb, 0x28,
	0x33, 0xfc, 0x29, 0xb3, 0x35, 0x2c, 0x83, 0xc1, 0x3f, 0x15, 0xa8, 0x8d, 0x38, 0xd3, 0x29, 0xee,
	0xc2, 0xc6, 0x70, 0x60, 0xbb, 0xb0, 0x31, 0x1c, 0x28, 0x36, 0x8f, 0x10, 0xc7, 0xa9, 0x1c, 0x0e,
	0xac, 0x73, 0x29, 0xab, 0xd6, 0x7d, 0xc4, 0x92, 0x93, 0x48, 0x8c, 0x18, 0x97, 0xfe, 0xa6, 0x26,
	0x96, 0x0b, 0x79, 0x07, 0xb0, 0xad, 0x1a, 0x34, 0x8c, 0xfd, 0x2d, 0xed, 0x6b, 0xa5, 0xd5, 0xa6,
	0x57, 0xd7, 0x9b, 0xde, 0x81, 0xfa, 0x58, 0x22, 0x2e, 0x27, 0x68, 0xe6, 0x6f, 0x9b, 0x7b, 0x0b,
	0x59, 0xeb, 0x30, 0x7f, 0x20, 0x8a, 0xfd, 0x35, 0x4d, 0x9f, 0x52, 0x0e, 0x46, 0xb0, 0xaf, 0x99,
	0x63, 0xca, 0x29, 0x59, 0xe9, 0x64, 0x52, 0x59, 0xcd, 0xc4, 0xfa, 0xde, 0xa0, 0x04, 0xdb, 0x12,
	0x5d, 0x28, 0x18, 0x98, 0xf7, 0xe9, 0x44, 0xb4, 0x73, 0x7e, 0x05, 0x8d, 0x12, 0xb4, 0xaf, 0x70,
	0xa7, 0xab, 0xf6, 0x5d, 0xd7, 0xc2, 0xe1, 0x42, 0x1f, 0x7c, 0x09, 0x2f, 0x55, 0x94, 0x5f, 0x30,
	0x17, 0x84, 0xa5, 0x24, 0x9d, 0x8d, 0x18, 0x25, 0xd1, 0xbc, 0x78, 0x34, 0x23, 0xe8, 0xac, 0xaa,
	0x9c, 0x17, 0xdf, 0x83, 0xba, 0xc6, 0x48, 0x79, 0xd1, 0x81, 0xe1, 0xce, 0x5a, 0xb8, 0xd2, 0x2e,
	0x78, 0x01, 0x87, 0xfa, 0x42, 0xc2, 0x65, 0x8e, 0xa8, 0xa2, 0x57, 0xf9, 0x42, 0xaf, 0xc1, 0xd3,
	0x34, 0x33, 0x45, 0x16, 0x1d, 0x7a, 0x07, 0xad, 0xb1, 0x44, 0x32, 0x17, 0x57, 0x84, 0x4a, 0xcc,
	0x75, 0x9f, 0x76, 0x7b, 0x5e, 0x57, 0x6d, 0x49, 0x6b, 0x6a, 0xf4, 0xe1, 0x92, 0x5d, 0x30, 0x86,
	0xb6, 0x55, 0x3b, 0x19, 0x9f, 0x38, 0x23, 0x32, 0x19, 0xb7, 0xdc, 0x40, 0x8b, 0x81, 0x7d, 0x66,
	0x2f, 0xfd, 0x51, 0x81, 0xe7, 0x7d, 0x96, 0x4a, 0xce, 0xe8, 0x4a, 0x9a, 0x2b, 0x03, 0xab, 0xac,
	0x0d, 0x4c, 0xd1, 0x43, 0x95, 0xeb, 0xcc, 0xb3, 0x94, 0xbd, 0xd7, 0x50, 0xeb, 0xb3, 0x24, 0x41,
	0x69, 0xac, 0xe9, 0xba, 0xdb, 0xfb, 0xc2, 0x4d, 0xcb, 0xaa, 0xc2, 0xc2, 0x26, 0x78, 0x07, 0x7b,
	0x03, 0x22, 0x22, 0xf6, 0x80, 0x79, 0x31, 0x2a, 0x2f, 0x80, 0xd6, 0x65, 0x1a, 0x67, 0x8c, 0xa4,
	0x72, 0x32, 0xcf, 0x8a, 0x0c, 0x96, 0xb0, 0xe0, 0xef, 0x0d, 0x68, 0x3b, 0x8e, 0x96, 0x30, 0x8a,
	0xf5, 0x28, 0xba, 0x47, 0x33, 0xec, 0x38, 0xba, 0x90, 0x8a, 0x6d, 0xc5, 0x6b, 0x34, 0xc5, 0xd4,
	0xa6, 0xbf, 0x84, 0xa9, 0xf5, 0x62, 0xc7, 0xae, 0x4b, 0x68, 0x84, 0x85, 0xe8, 0x1d, 0x01, 0x5c,
	0xe4, 0x84, 0xc6, 0x63, 0x89, 0x92, 0x4c, 0xbf, 0xb8, 0x6a, 0xe8, 0x20, 0x66, 0x1b, 0x10, 0x1a,
	0x87, 0xf8, 0x81, 0x68, 0xff, 0x6a, 0xb1, 0x0d, 0x1c, 0xd0, 0x1b, 0x40, 0xa3, 0xa8, 0x45, 0xf8,
	0xdb, 0x7a, 0x76, 0x5f, 0x1b, 0x5a, 0xaf, 0x55, 0xd4, 0x2d, 0x0d, 0x2f, 0x53, 0xc9, 0xe7, 0xe1,
	0xc2, 0xb1, 0xf3, 0x1e, 0x76, 0x97, 0x95, 0xde, 0x1e, 0x6c, 0xde, 0xe3, 0xb9, 0xad, 0x5a, 0x1d,
	0xd5, 0xe8, 0x1f, 0x10, 0xcd, 0x8b, 0x29, 0x19, 0xe1, 0xa7, 0x8d, 0x1f, 0x2a, 0xc1, 0x77, 0xd0,
	0x36, 0x5f, 0xaa, 0x57, 0x8c, 0x27, 0x4f, 0x9e, 0x7c, 0xd0, 0x86, 0x67, 0xb7, 0x19, 0x4e, 0xcf,
	0x33, 0x52, 0x64, 0x18, 0xfc, 0xb9, 0x09, 0xed, 0x73, 0xcd, 0xc9, 0x01, 0x16, 0x11, 0x27, 0x99,
	0xa6, 0xa7, 0x07, 0x5b, 0x4e, 0x0c, 0x7d, 0x56, 0xd8, 0x30, 0x62, 0x69, 0xb1, 0xe6, 0xd5, 0x59,
	0x65, 0x68, 0x06, 0x61, 0x3a, 0x6d, 0x04, 0x95, 0x88, 0x13, 0xcc, 0xae, 0x36, 0x17, 0xf2, 0x4e,
	0xe0, 0xd9, 0x38, 0x4f, 0x12, 0xc4, 0xe7, 0x13, 0x9c, 0x64, 0x14, 0x49, 0x6c, 0x7b, 0xbd, 0x0a,
	0xab, 0x69, 0xfe, 0x8c, 0x84, 0x2a, 0x53, 0xaf, 0xb9, 0x7a, 0x58, 0x88, 0x6a, 0x9a, 0xea, 0xf3,
	0x23, 0x8b, 0x73, 0x8a, 0xfd, 0xa6, 0x76, 0x77, 0x10, 0x75, 0xc7, 0x42, 0x1a, 0x71, 0x96, 0x09,
	0xbf, 0x65, 0xee, 0x58, 0x81, 0xd5, 0x83, 0xe8, 0x23, 0x89, 0x67, 0x8c, 0xcf, 0xfd, 0x9a, 0x79,
	0x10, 0x85, 0xac, 0xaa, 0x9e, 0x90, 0x54, 0xfa, 0x75, 0x53, 0xb5, 0x3a, 0x7b, 0xa7, 0xb0, 0x37,
	0x4c, 0xb3, 0x5c, 0xba, 0x45, 0x36, 0xb4, 0x7e, 0x0d, 0xf7, 0xbe, 0x81, 0xf6, 0x6d, 0x2e, 0x57,
	0x8c, 0x41, 0x1b, 0xaf, 0x2b, 0x54, 0x4d, 0x43, 0x31, 0x4c, 0x25, 0xe6, 0x29, 0xa2, 0xfe, 0x8e,
	0x2e, 0xd8, 0x41, 0xd4, 0xd2, 0x1a, 0x47, 0x77, 0x58, 0xa5, 0xce, 0xcd, 0xd4, 0xca, 0xa5, 0xf5,
	0x57, 0x05, 0xfc, 0x75, 0x9d, 0x7d, 0x59, 0x97, 0x50, 0xb3, 0x90, 0xdd, 0x36, 0xaf, 0x0c, 0x63,
	0x3f, 0xe7, 0xd0, 0xb5, 0xb2, 0xa1, 0x6d, 0xe1, 0xdb, 0x19, 0x43, 0xcb, 0x55, 0x3c, 0x42, 0xd9,
	0xd7, 0x2e, 0x65, 0x9b, 0xbd, 0x43, 0x73, 0xcd, 0x1a, 0xc1, 0x5c, 0x2e, 0xbf, 0x87, 0xce, 0x4a,
	0x1a, 0x2e, 0xa9, 0x8f, 0x00, 0x0c, 0xe8, 0xf0, 0xd1, 0x41, 0xd4, 0xf7, 0xc6, 0xa3, 0xde, 0x96,
	0xde, 0xa7, 0xb0, 0xa7, 0x57, 0x39, 0x91, 0x4b, 0x5f, 0x75, 0xce, 0x0a, 0x6f, 0x84, 0x56, 0x0a,
	0x3e, 0x40, 0xdb, 0xb1, 0xb5, 0x9d, 0x3b, 0x85, 0xaa, 0x06, 0x6c, 0xdf, 0xf6, 0xbb, 0xc5, 0xaf,
	0xdb, 0x11, 0x67, 0x9f, 0xe6, 0xe6, 0x11, 0x86, 0xc6, 0x64, 0xba, 0xad, 0x7f, 0xf1, 0xbe, 0xf9,
	0x37, 0x00, 0x00, 0xff, 0xff, 0x86, 0xb5, 0x92, 0xb3, 0xe3, 0x0b, 0x00, 0x00,
}
