// Code generated by protoc-gen-go. DO NOT EDIT.
// source: tree.proto

/*
Package tree is a generated protocol buffer package.

It is generated from these files:
	tree.proto

It has these top-level messages:
	ReadNodeRequest
	ReadNodeResponse
	ListNodesRequest
	ListNodesResponse
	WrappingStreamerResponse
	CreateNodeRequest
	CreateNodeResponse
	UpdateNodeRequest
	UpdateNodeResponse
	DeleteNodeRequest
	DeleteNodeResponse
	IndexationSession
	IndexationOperation
	OpenSessionRequest
	OpenSessionResponse
	FlushSessionRequest
	FlushSessionResponse
	CloseSessionRequest
	CloseSessionResponse
	WatchNodeRequest
	WatchNodeResponse
	SearchRequest
	SearchFacet
	SearchResponse
	CreateVersionRequest
	CreateVersionResponse
	ListVersionsRequest
	ListVersionsResponse
	HeadVersionRequest
	HeadVersionResponse
	StoreVersionRequest
	StoreVersionResponse
	PruneVersionsRequest
	PruneVersionsResponse
	VersioningPolicy
	VersioningKeepPeriod
	Node
	WorkspaceRelativePath
	ChangeLog
	Query
	GeoQuery
	GeoPoint
	StreamChangesRequest
	NodeChangeEvent
	IndexEvent
	GetEncryptionKeyRequest
	GetEncryptionKeyResponse
	SyncChange
	SyncChangeNode
	PutSyncChangeResponse
	SearchSyncChangeRequest
*/
package tree

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type VersioningNodeDeletedStrategy int32

const (
	VersioningNodeDeletedStrategy_KeepAll  VersioningNodeDeletedStrategy = 0
	VersioningNodeDeletedStrategy_KeepLast VersioningNodeDeletedStrategy = 1
	VersioningNodeDeletedStrategy_KeepNone VersioningNodeDeletedStrategy = 2
)

var VersioningNodeDeletedStrategy_name = map[int32]string{
	0: "KeepAll",
	1: "KeepLast",
	2: "KeepNone",
}
var VersioningNodeDeletedStrategy_value = map[string]int32{
	"KeepAll":  0,
	"KeepLast": 1,
	"KeepNone": 2,
}

func (x VersioningNodeDeletedStrategy) String() string {
	return proto.EnumName(VersioningNodeDeletedStrategy_name, int32(x))
}
func (VersioningNodeDeletedStrategy) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{0}
}

// ==========================================================
// * Standard Messages
// ==========================================================
type NodeType int32

const (
	NodeType_UNKNOWN    NodeType = 0
	NodeType_LEAF       NodeType = 1
	NodeType_COLLECTION NodeType = 2
)

var NodeType_name = map[int32]string{
	0: "UNKNOWN",
	1: "LEAF",
	2: "COLLECTION",
}
var NodeType_value = map[string]int32{
	"UNKNOWN":    0,
	"LEAF":       1,
	"COLLECTION": 2,
}

func (x NodeType) String() string {
	return proto.EnumName(NodeType_name, int32(x))
}
func (NodeType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

type NodeChangeEvent_EventType int32

const (
	NodeChangeEvent_CREATE           NodeChangeEvent_EventType = 0
	NodeChangeEvent_READ             NodeChangeEvent_EventType = 1
	NodeChangeEvent_UPDATE_PATH      NodeChangeEvent_EventType = 2
	NodeChangeEvent_UPDATE_CONTENT   NodeChangeEvent_EventType = 3
	NodeChangeEvent_UPDATE_META      NodeChangeEvent_EventType = 4
	NodeChangeEvent_UPDATE_USER_META NodeChangeEvent_EventType = 6
	NodeChangeEvent_DELETE           NodeChangeEvent_EventType = 5
)

var NodeChangeEvent_EventType_name = map[int32]string{
	0: "CREATE",
	1: "READ",
	2: "UPDATE_PATH",
	3: "UPDATE_CONTENT",
	4: "UPDATE_META",
	6: "UPDATE_USER_META",
	5: "DELETE",
}
var NodeChangeEvent_EventType_value = map[string]int32{
	"CREATE":           0,
	"READ":             1,
	"UPDATE_PATH":      2,
	"UPDATE_CONTENT":   3,
	"UPDATE_META":      4,
	"UPDATE_USER_META": 6,
	"DELETE":           5,
}

func (x NodeChangeEvent_EventType) String() string {
	return proto.EnumName(NodeChangeEvent_EventType_name, int32(x))
}
func (NodeChangeEvent_EventType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{43, 0}
}

type SyncChange_Type int32

const (
	SyncChange_unknown SyncChange_Type = 0
	SyncChange_create  SyncChange_Type = 1
	SyncChange_delete  SyncChange_Type = 2
	SyncChange_path    SyncChange_Type = 3
	SyncChange_content SyncChange_Type = 4
)

var SyncChange_Type_name = map[int32]string{
	0: "unknown",
	1: "create",
	2: "delete",
	3: "path",
	4: "content",
}
var SyncChange_Type_value = map[string]int32{
	"unknown": 0,
	"create":  1,
	"delete":  2,
	"path":    3,
	"content": 4,
}

func (x SyncChange_Type) String() string {
	return proto.EnumName(SyncChange_Type_name, int32(x))
}
func (SyncChange_Type) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{47, 0} }

// Request / Responses Messages
type ReadNodeRequest struct {
	// Input node
	Node *Node `protobuf:"bytes,1,opt,name=Node" json:"Node,omitempty"`
	// Gather commit information
	WithCommits bool `protobuf:"varint,2,opt,name=WithCommits" json:"WithCommits,omitempty"`
	// Get extended stats - For folders, computes ChildrenCount
	WithExtendedStats bool `protobuf:"varint,3,opt,name=WithExtendedStats" json:"WithExtendedStats,omitempty"`
	// Used internally for the router ReadNode request, stat the datasource instead of index
	ObjectStats bool `protobuf:"varint,4,opt,name=ObjectStats" json:"ObjectStats,omitempty"`
}

func (m *ReadNodeRequest) Reset()                    { *m = ReadNodeRequest{} }
func (m *ReadNodeRequest) String() string            { return proto.CompactTextString(m) }
func (*ReadNodeRequest) ProtoMessage()               {}
func (*ReadNodeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *ReadNodeRequest) GetNode() *Node {
	if m != nil {
		return m.Node
	}
	return nil
}

func (m *ReadNodeRequest) GetWithCommits() bool {
	if m != nil {
		return m.WithCommits
	}
	return false
}

func (m *ReadNodeRequest) GetWithExtendedStats() bool {
	if m != nil {
		return m.WithExtendedStats
	}
	return false
}

func (m *ReadNodeRequest) GetObjectStats() bool {
	if m != nil {
		return m.ObjectStats
	}
	return false
}

type ReadNodeResponse struct {
	Success bool  `protobuf:"varint,1,opt,name=Success" json:"Success,omitempty"`
	Node    *Node `protobuf:"bytes,2,opt,name=Node" json:"Node,omitempty"`
}

func (m *ReadNodeResponse) Reset()                    { *m = ReadNodeResponse{} }
func (m *ReadNodeResponse) String() string            { return proto.CompactTextString(m) }
func (*ReadNodeResponse) ProtoMessage()               {}
func (*ReadNodeResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *ReadNodeResponse) GetSuccess() bool {
	if m != nil {
		return m.Success
	}
	return false
}

func (m *ReadNodeResponse) GetNode() *Node {
	if m != nil {
		return m.Node
	}
	return nil
}

type ListNodesRequest struct {
	// Main node used as a parent
	Node *Node `protobuf:"bytes,1,opt,name=Node" json:"Node,omitempty"`
	// Send back all children of the node
	Recursive bool `protobuf:"varint,2,opt,name=Recursive" json:"Recursive,omitempty"`
	// Send back a list of parent nodes, until the root, including the original node
	Ancestors bool `protobuf:"varint,3,opt,name=Ancestors" json:"Ancestors,omitempty"`
	// Sends the list of versions for a given node
	WithVersions bool `protobuf:"varint,7,opt,name=WithVersions" json:"WithVersions,omitempty"`
	// Sends the list of commits for a given node (not used)
	WithCommits bool `protobuf:"varint,8,opt,name=WithCommits" json:"WithCommits,omitempty"`
	// Limit the number of results
	Limit int64 `protobuf:"varint,4,opt,name=Limit" json:"Limit,omitempty"`
	// Start listing at a given position
	Offset int64 `protobuf:"varint,5,opt,name=Offset" json:"Offset,omitempty"`
	// Filter by node type (LEAF / COLLECTION)
	FilterType NodeType `protobuf:"varint,6,opt,name=FilterType,enum=tree.NodeType" json:"FilterType,omitempty"`
}

func (m *ListNodesRequest) Reset()                    { *m = ListNodesRequest{} }
func (m *ListNodesRequest) String() string            { return proto.CompactTextString(m) }
func (*ListNodesRequest) ProtoMessage()               {}
func (*ListNodesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *ListNodesRequest) GetNode() *Node {
	if m != nil {
		return m.Node
	}
	return nil
}

func (m *ListNodesRequest) GetRecursive() bool {
	if m != nil {
		return m.Recursive
	}
	return false
}

func (m *ListNodesRequest) GetAncestors() bool {
	if m != nil {
		return m.Ancestors
	}
	return false
}

func (m *ListNodesRequest) GetWithVersions() bool {
	if m != nil {
		return m.WithVersions
	}
	return false
}

func (m *ListNodesRequest) GetWithCommits() bool {
	if m != nil {
		return m.WithCommits
	}
	return false
}

func (m *ListNodesRequest) GetLimit() int64 {
	if m != nil {
		return m.Limit
	}
	return 0
}

func (m *ListNodesRequest) GetOffset() int64 {
	if m != nil {
		return m.Offset
	}
	return 0
}

func (m *ListNodesRequest) GetFilterType() NodeType {
	if m != nil {
		return m.FilterType
	}
	return NodeType_UNKNOWN
}

type ListNodesResponse struct {
	Node *Node `protobuf:"bytes,1,opt,name=Node" json:"Node,omitempty"`
}

func (m *ListNodesResponse) Reset()                    { *m = ListNodesResponse{} }
func (m *ListNodesResponse) String() string            { return proto.CompactTextString(m) }
func (*ListNodesResponse) ProtoMessage()               {}
func (*ListNodesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *ListNodesResponse) GetNode() *Node {
	if m != nil {
		return m.Node
	}
	return nil
}

type WrappingStreamerResponse struct {
	// Types that are valid to be assigned to Data:
	//	*WrappingStreamerResponse_ListNodesResponse
	//	*WrappingStreamerResponse_NodeChangeEvent
	Data  isWrappingStreamerResponse_Data `protobuf_oneof:"Data"`
	Error string                          `protobuf:"bytes,3,opt,name=Error" json:"Error,omitempty"`
}

func (m *WrappingStreamerResponse) Reset()                    { *m = WrappingStreamerResponse{} }
func (m *WrappingStreamerResponse) String() string            { return proto.CompactTextString(m) }
func (*WrappingStreamerResponse) ProtoMessage()               {}
func (*WrappingStreamerResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

type isWrappingStreamerResponse_Data interface{ isWrappingStreamerResponse_Data() }

type WrappingStreamerResponse_ListNodesResponse struct {
	ListNodesResponse *ListNodesResponse `protobuf:"bytes,1,opt,name=ListNodesResponse,oneof"`
}
type WrappingStreamerResponse_NodeChangeEvent struct {
	NodeChangeEvent *NodeChangeEvent `protobuf:"bytes,2,opt,name=NodeChangeEvent,oneof"`
}

func (*WrappingStreamerResponse_ListNodesResponse) isWrappingStreamerResponse_Data() {}
func (*WrappingStreamerResponse_NodeChangeEvent) isWrappingStreamerResponse_Data()   {}

func (m *WrappingStreamerResponse) GetData() isWrappingStreamerResponse_Data {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *WrappingStreamerResponse) GetListNodesResponse() *ListNodesResponse {
	if x, ok := m.GetData().(*WrappingStreamerResponse_ListNodesResponse); ok {
		return x.ListNodesResponse
	}
	return nil
}

func (m *WrappingStreamerResponse) GetNodeChangeEvent() *NodeChangeEvent {
	if x, ok := m.GetData().(*WrappingStreamerResponse_NodeChangeEvent); ok {
		return x.NodeChangeEvent
	}
	return nil
}

func (m *WrappingStreamerResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*WrappingStreamerResponse) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _WrappingStreamerResponse_OneofMarshaler, _WrappingStreamerResponse_OneofUnmarshaler, _WrappingStreamerResponse_OneofSizer, []interface{}{
		(*WrappingStreamerResponse_ListNodesResponse)(nil),
		(*WrappingStreamerResponse_NodeChangeEvent)(nil),
	}
}

func _WrappingStreamerResponse_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*WrappingStreamerResponse)
	// Data
	switch x := m.Data.(type) {
	case *WrappingStreamerResponse_ListNodesResponse:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ListNodesResponse); err != nil {
			return err
		}
	case *WrappingStreamerResponse_NodeChangeEvent:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.NodeChangeEvent); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("WrappingStreamerResponse.Data has unexpected type %T", x)
	}
	return nil
}

func _WrappingStreamerResponse_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*WrappingStreamerResponse)
	switch tag {
	case 1: // Data.ListNodesResponse
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ListNodesResponse)
		err := b.DecodeMessage(msg)
		m.Data = &WrappingStreamerResponse_ListNodesResponse{msg}
		return true, err
	case 2: // Data.NodeChangeEvent
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(NodeChangeEvent)
		err := b.DecodeMessage(msg)
		m.Data = &WrappingStreamerResponse_NodeChangeEvent{msg}
		return true, err
	default:
		return false, nil
	}
}

func _WrappingStreamerResponse_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*WrappingStreamerResponse)
	// Data
	switch x := m.Data.(type) {
	case *WrappingStreamerResponse_ListNodesResponse:
		s := proto.Size(x.ListNodesResponse)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *WrappingStreamerResponse_NodeChangeEvent:
		s := proto.Size(x.NodeChangeEvent)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Request / Responses Messages
type CreateNodeRequest struct {
	Node              *Node  `protobuf:"bytes,1,opt,name=Node" json:"Node,omitempty"`
	UpdateIfExists    bool   `protobuf:"varint,2,opt,name=UpdateIfExists" json:"UpdateIfExists,omitempty"`
	IndexationSession string `protobuf:"bytes,3,opt,name=IndexationSession" json:"IndexationSession,omitempty"`
	Silent            bool   `protobuf:"varint,4,opt,name=Silent" json:"Silent,omitempty"`
}

func (m *CreateNodeRequest) Reset()                    { *m = CreateNodeRequest{} }
func (m *CreateNodeRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateNodeRequest) ProtoMessage()               {}
func (*CreateNodeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *CreateNodeRequest) GetNode() *Node {
	if m != nil {
		return m.Node
	}
	return nil
}

func (m *CreateNodeRequest) GetUpdateIfExists() bool {
	if m != nil {
		return m.UpdateIfExists
	}
	return false
}

func (m *CreateNodeRequest) GetIndexationSession() string {
	if m != nil {
		return m.IndexationSession
	}
	return ""
}

func (m *CreateNodeRequest) GetSilent() bool {
	if m != nil {
		return m.Silent
	}
	return false
}

type CreateNodeResponse struct {
	Success bool  `protobuf:"varint,1,opt,name=Success" json:"Success,omitempty"`
	Node    *Node `protobuf:"bytes,2,opt,name=Node" json:"Node,omitempty"`
}

func (m *CreateNodeResponse) Reset()                    { *m = CreateNodeResponse{} }
func (m *CreateNodeResponse) String() string            { return proto.CompactTextString(m) }
func (*CreateNodeResponse) ProtoMessage()               {}
func (*CreateNodeResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *CreateNodeResponse) GetSuccess() bool {
	if m != nil {
		return m.Success
	}
	return false
}

func (m *CreateNodeResponse) GetNode() *Node {
	if m != nil {
		return m.Node
	}
	return nil
}

type UpdateNodeRequest struct {
	From              *Node  `protobuf:"bytes,1,opt,name=From" json:"From,omitempty"`
	To                *Node  `protobuf:"bytes,2,opt,name=To" json:"To,omitempty"`
	IndexationSession string `protobuf:"bytes,3,opt,name=IndexationSession" json:"IndexationSession,omitempty"`
	Silent            bool   `protobuf:"varint,4,opt,name=Silent" json:"Silent,omitempty"`
}

func (m *UpdateNodeRequest) Reset()                    { *m = UpdateNodeRequest{} }
func (m *UpdateNodeRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateNodeRequest) ProtoMessage()               {}
func (*UpdateNodeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *UpdateNodeRequest) GetFrom() *Node {
	if m != nil {
		return m.From
	}
	return nil
}

func (m *UpdateNodeRequest) GetTo() *Node {
	if m != nil {
		return m.To
	}
	return nil
}

func (m *UpdateNodeRequest) GetIndexationSession() string {
	if m != nil {
		return m.IndexationSession
	}
	return ""
}

func (m *UpdateNodeRequest) GetSilent() bool {
	if m != nil {
		return m.Silent
	}
	return false
}

type UpdateNodeResponse struct {
	Success bool  `protobuf:"varint,1,opt,name=Success" json:"Success,omitempty"`
	Node    *Node `protobuf:"bytes,2,opt,name=Node" json:"Node,omitempty"`
}

func (m *UpdateNodeResponse) Reset()                    { *m = UpdateNodeResponse{} }
func (m *UpdateNodeResponse) String() string            { return proto.CompactTextString(m) }
func (*UpdateNodeResponse) ProtoMessage()               {}
func (*UpdateNodeResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *UpdateNodeResponse) GetSuccess() bool {
	if m != nil {
		return m.Success
	}
	return false
}

func (m *UpdateNodeResponse) GetNode() *Node {
	if m != nil {
		return m.Node
	}
	return nil
}

type DeleteNodeRequest struct {
	Node              *Node  `protobuf:"bytes,1,opt,name=Node" json:"Node,omitempty"`
	IndexationSession string `protobuf:"bytes,2,opt,name=IndexationSession" json:"IndexationSession,omitempty"`
	Silent            bool   `protobuf:"varint,3,opt,name=Silent" json:"Silent,omitempty"`
}

func (m *DeleteNodeRequest) Reset()                    { *m = DeleteNodeRequest{} }
func (m *DeleteNodeRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteNodeRequest) ProtoMessage()               {}
func (*DeleteNodeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *DeleteNodeRequest) GetNode() *Node {
	if m != nil {
		return m.Node
	}
	return nil
}

func (m *DeleteNodeRequest) GetIndexationSession() string {
	if m != nil {
		return m.IndexationSession
	}
	return ""
}

func (m *DeleteNodeRequest) GetSilent() bool {
	if m != nil {
		return m.Silent
	}
	return false
}

type DeleteNodeResponse struct {
	Success bool `protobuf:"varint,1,opt,name=Success" json:"Success,omitempty"`
}

func (m *DeleteNodeResponse) Reset()                    { *m = DeleteNodeResponse{} }
func (m *DeleteNodeResponse) String() string            { return proto.CompactTextString(m) }
func (*DeleteNodeResponse) ProtoMessage()               {}
func (*DeleteNodeResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *DeleteNodeResponse) GetSuccess() bool {
	if m != nil {
		return m.Success
	}
	return false
}

type IndexationSession struct {
	Uuid                    string `protobuf:"bytes,1,opt,name=Uuid" json:"Uuid,omitempty"`
	Description             string `protobuf:"bytes,2,opt,name=Description" json:"Description,omitempty"`
	RootNode                *Node  `protobuf:"bytes,3,opt,name=RootNode" json:"RootNode,omitempty"`
	ExpectedOperationsCount int64  `protobuf:"varint,4,opt,name=ExpectedOperationsCount" json:"ExpectedOperationsCount,omitempty"`
	CurrentOperationCount   int64  `protobuf:"varint,5,opt,name=CurrentOperationCount" json:"CurrentOperationCount,omitempty"`
	Silent                  bool   `protobuf:"varint,6,opt,name=Silent" json:"Silent,omitempty"`
}

func (m *IndexationSession) Reset()                    { *m = IndexationSession{} }
func (m *IndexationSession) String() string            { return proto.CompactTextString(m) }
func (*IndexationSession) ProtoMessage()               {}
func (*IndexationSession) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *IndexationSession) GetUuid() string {
	if m != nil {
		return m.Uuid
	}
	return ""
}

func (m *IndexationSession) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *IndexationSession) GetRootNode() *Node {
	if m != nil {
		return m.RootNode
	}
	return nil
}

func (m *IndexationSession) GetExpectedOperationsCount() int64 {
	if m != nil {
		return m.ExpectedOperationsCount
	}
	return 0
}

func (m *IndexationSession) GetCurrentOperationCount() int64 {
	if m != nil {
		return m.CurrentOperationCount
	}
	return 0
}

func (m *IndexationSession) GetSilent() bool {
	if m != nil {
		return m.Silent
	}
	return false
}

type IndexationOperation struct {
	SessionUuid string `protobuf:"bytes,1,opt,name=SessionUuid" json:"SessionUuid,omitempty"`
	Description string `protobuf:"bytes,2,opt,name=Description" json:"Description,omitempty"`
	Cursor      int64  `protobuf:"varint,3,opt,name=Cursor" json:"Cursor,omitempty"`
}

func (m *IndexationOperation) Reset()                    { *m = IndexationOperation{} }
func (m *IndexationOperation) String() string            { return proto.CompactTextString(m) }
func (*IndexationOperation) ProtoMessage()               {}
func (*IndexationOperation) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *IndexationOperation) GetSessionUuid() string {
	if m != nil {
		return m.SessionUuid
	}
	return ""
}

func (m *IndexationOperation) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *IndexationOperation) GetCursor() int64 {
	if m != nil {
		return m.Cursor
	}
	return 0
}

type OpenSessionRequest struct {
	Session *IndexationSession `protobuf:"bytes,1,opt,name=Session" json:"Session,omitempty"`
}

func (m *OpenSessionRequest) Reset()                    { *m = OpenSessionRequest{} }
func (m *OpenSessionRequest) String() string            { return proto.CompactTextString(m) }
func (*OpenSessionRequest) ProtoMessage()               {}
func (*OpenSessionRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *OpenSessionRequest) GetSession() *IndexationSession {
	if m != nil {
		return m.Session
	}
	return nil
}

type OpenSessionResponse struct {
	Session *IndexationSession `protobuf:"bytes,1,opt,name=Session" json:"Session,omitempty"`
}

func (m *OpenSessionResponse) Reset()                    { *m = OpenSessionResponse{} }
func (m *OpenSessionResponse) String() string            { return proto.CompactTextString(m) }
func (*OpenSessionResponse) ProtoMessage()               {}
func (*OpenSessionResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *OpenSessionResponse) GetSession() *IndexationSession {
	if m != nil {
		return m.Session
	}
	return nil
}

type FlushSessionRequest struct {
	Session *IndexationSession `protobuf:"bytes,1,opt,name=Session" json:"Session,omitempty"`
}

func (m *FlushSessionRequest) Reset()                    { *m = FlushSessionRequest{} }
func (m *FlushSessionRequest) String() string            { return proto.CompactTextString(m) }
func (*FlushSessionRequest) ProtoMessage()               {}
func (*FlushSessionRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *FlushSessionRequest) GetSession() *IndexationSession {
	if m != nil {
		return m.Session
	}
	return nil
}

type FlushSessionResponse struct {
	Session *IndexationSession `protobuf:"bytes,1,opt,name=Session" json:"Session,omitempty"`
}

func (m *FlushSessionResponse) Reset()                    { *m = FlushSessionResponse{} }
func (m *FlushSessionResponse) String() string            { return proto.CompactTextString(m) }
func (*FlushSessionResponse) ProtoMessage()               {}
func (*FlushSessionResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *FlushSessionResponse) GetSession() *IndexationSession {
	if m != nil {
		return m.Session
	}
	return nil
}

type CloseSessionRequest struct {
	Session *IndexationSession `protobuf:"bytes,1,opt,name=Session" json:"Session,omitempty"`
}

func (m *CloseSessionRequest) Reset()                    { *m = CloseSessionRequest{} }
func (m *CloseSessionRequest) String() string            { return proto.CompactTextString(m) }
func (*CloseSessionRequest) ProtoMessage()               {}
func (*CloseSessionRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func (m *CloseSessionRequest) GetSession() *IndexationSession {
	if m != nil {
		return m.Session
	}
	return nil
}

type CloseSessionResponse struct {
	Session *IndexationSession `protobuf:"bytes,1,opt,name=Session" json:"Session,omitempty"`
}

func (m *CloseSessionResponse) Reset()                    { *m = CloseSessionResponse{} }
func (m *CloseSessionResponse) String() string            { return proto.CompactTextString(m) }
func (*CloseSessionResponse) ProtoMessage()               {}
func (*CloseSessionResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func (m *CloseSessionResponse) GetSession() *IndexationSession {
	if m != nil {
		return m.Session
	}
	return nil
}

// Request / Responses Messages
type WatchNodeRequest struct {
	Node *Node `protobuf:"bytes,1,opt,name=Node" json:"Node,omitempty"`
}

func (m *WatchNodeRequest) Reset()                    { *m = WatchNodeRequest{} }
func (m *WatchNodeRequest) String() string            { return proto.CompactTextString(m) }
func (*WatchNodeRequest) ProtoMessage()               {}
func (*WatchNodeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{19} }

func (m *WatchNodeRequest) GetNode() *Node {
	if m != nil {
		return m.Node
	}
	return nil
}

type WatchNodeResponse struct {
	Node *Node `protobuf:"bytes,1,opt,name=Node" json:"Node,omitempty"`
}

func (m *WatchNodeResponse) Reset()                    { *m = WatchNodeResponse{} }
func (m *WatchNodeResponse) String() string            { return proto.CompactTextString(m) }
func (*WatchNodeResponse) ProtoMessage()               {}
func (*WatchNodeResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{20} }

func (m *WatchNodeResponse) GetNode() *Node {
	if m != nil {
		return m.Node
	}
	return nil
}

type SearchRequest struct {
	// The query object
	Query *Query `protobuf:"bytes,1,opt,name=Query" json:"Query,omitempty"`
	// Limit the number of results
	Size int32 `protobuf:"varint,2,opt,name=Size" json:"Size,omitempty"`
	// Start at given position
	From int32 `protobuf:"varint,3,opt,name=From" json:"From,omitempty"`
	// Load node details
	Details bool `protobuf:"varint,4,opt,name=Details" json:"Details,omitempty"`
}

func (m *SearchRequest) Reset()                    { *m = SearchRequest{} }
func (m *SearchRequest) String() string            { return proto.CompactTextString(m) }
func (*SearchRequest) ProtoMessage()               {}
func (*SearchRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{21} }

func (m *SearchRequest) GetQuery() *Query {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *SearchRequest) GetSize() int32 {
	if m != nil {
		return m.Size
	}
	return 0
}

func (m *SearchRequest) GetFrom() int32 {
	if m != nil {
		return m.From
	}
	return 0
}

func (m *SearchRequest) GetDetails() bool {
	if m != nil {
		return m.Details
	}
	return false
}

type SearchFacet struct {
	// Facet field name
	FieldName string `protobuf:"bytes,1,opt,name=FieldName" json:"FieldName,omitempty"`
	// Segment Label
	Label string `protobuf:"bytes,2,opt,name=Label" json:"Label,omitempty"`
	// Segment results count
	Count int32 `protobuf:"varint,3,opt,name=Count" json:"Count,omitempty"`
	// For string facets, term value
	Term string `protobuf:"bytes,4,opt,name=Term" json:"Term,omitempty"`
	// For NumericRange facets, min/max values
	Min int64 `protobuf:"varint,5,opt,name=Min" json:"Min,omitempty"`
	Max int64 `protobuf:"varint,6,opt,name=Max" json:"Max,omitempty"`
	// For DateRange facets, start/end values
	Start int32 `protobuf:"varint,7,opt,name=Start" json:"Start,omitempty"`
	End   int32 `protobuf:"varint,8,opt,name=End" json:"End,omitempty"`
}

func (m *SearchFacet) Reset()                    { *m = SearchFacet{} }
func (m *SearchFacet) String() string            { return proto.CompactTextString(m) }
func (*SearchFacet) ProtoMessage()               {}
func (*SearchFacet) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{22} }

func (m *SearchFacet) GetFieldName() string {
	if m != nil {
		return m.FieldName
	}
	return ""
}

func (m *SearchFacet) GetLabel() string {
	if m != nil {
		return m.Label
	}
	return ""
}

func (m *SearchFacet) GetCount() int32 {
	if m != nil {
		return m.Count
	}
	return 0
}

func (m *SearchFacet) GetTerm() string {
	if m != nil {
		return m.Term
	}
	return ""
}

func (m *SearchFacet) GetMin() int64 {
	if m != nil {
		return m.Min
	}
	return 0
}

func (m *SearchFacet) GetMax() int64 {
	if m != nil {
		return m.Max
	}
	return 0
}

func (m *SearchFacet) GetStart() int32 {
	if m != nil {
		return m.Start
	}
	return 0
}

func (m *SearchFacet) GetEnd() int32 {
	if m != nil {
		return m.End
	}
	return 0
}

type SearchResponse struct {
	Node  *Node        `protobuf:"bytes,1,opt,name=Node" json:"Node,omitempty"`
	Facet *SearchFacet `protobuf:"bytes,2,opt,name=Facet" json:"Facet,omitempty"`
}

func (m *SearchResponse) Reset()                    { *m = SearchResponse{} }
func (m *SearchResponse) String() string            { return proto.CompactTextString(m) }
func (*SearchResponse) ProtoMessage()               {}
func (*SearchResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{23} }

func (m *SearchResponse) GetNode() *Node {
	if m != nil {
		return m.Node
	}
	return nil
}

func (m *SearchResponse) GetFacet() *SearchFacet {
	if m != nil {
		return m.Facet
	}
	return nil
}

type CreateVersionRequest struct {
	Node         *Node            `protobuf:"bytes,1,opt,name=Node" json:"Node,omitempty"`
	TriggerEvent *NodeChangeEvent `protobuf:"bytes,2,opt,name=TriggerEvent" json:"TriggerEvent,omitempty"`
}

func (m *CreateVersionRequest) Reset()                    { *m = CreateVersionRequest{} }
func (m *CreateVersionRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateVersionRequest) ProtoMessage()               {}
func (*CreateVersionRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{24} }

func (m *CreateVersionRequest) GetNode() *Node {
	if m != nil {
		return m.Node
	}
	return nil
}

func (m *CreateVersionRequest) GetTriggerEvent() *NodeChangeEvent {
	if m != nil {
		return m.TriggerEvent
	}
	return nil
}

type CreateVersionResponse struct {
	Version *ChangeLog `protobuf:"bytes,1,opt,name=Version" json:"Version,omitempty"`
}

func (m *CreateVersionResponse) Reset()                    { *m = CreateVersionResponse{} }
func (m *CreateVersionResponse) String() string            { return proto.CompactTextString(m) }
func (*CreateVersionResponse) ProtoMessage()               {}
func (*CreateVersionResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{25} }

func (m *CreateVersionResponse) GetVersion() *ChangeLog {
	if m != nil {
		return m.Version
	}
	return nil
}

type ListVersionsRequest struct {
	Node *Node `protobuf:"bytes,1,opt,name=Node" json:"Node,omitempty"`
}

func (m *ListVersionsRequest) Reset()                    { *m = ListVersionsRequest{} }
func (m *ListVersionsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListVersionsRequest) ProtoMessage()               {}
func (*ListVersionsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{26} }

func (m *ListVersionsRequest) GetNode() *Node {
	if m != nil {
		return m.Node
	}
	return nil
}

type ListVersionsResponse struct {
	Version *ChangeLog `protobuf:"bytes,1,opt,name=Version" json:"Version,omitempty"`
}

func (m *ListVersionsResponse) Reset()                    { *m = ListVersionsResponse{} }
func (m *ListVersionsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListVersionsResponse) ProtoMessage()               {}
func (*ListVersionsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{27} }

func (m *ListVersionsResponse) GetVersion() *ChangeLog {
	if m != nil {
		return m.Version
	}
	return nil
}

type HeadVersionRequest struct {
	Node      *Node  `protobuf:"bytes,1,opt,name=Node" json:"Node,omitempty"`
	VersionId string `protobuf:"bytes,2,opt,name=VersionId" json:"VersionId,omitempty"`
}

func (m *HeadVersionRequest) Reset()                    { *m = HeadVersionRequest{} }
func (m *HeadVersionRequest) String() string            { return proto.CompactTextString(m) }
func (*HeadVersionRequest) ProtoMessage()               {}
func (*HeadVersionRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{28} }

func (m *HeadVersionRequest) GetNode() *Node {
	if m != nil {
		return m.Node
	}
	return nil
}

func (m *HeadVersionRequest) GetVersionId() string {
	if m != nil {
		return m.VersionId
	}
	return ""
}

type HeadVersionResponse struct {
	Version *ChangeLog `protobuf:"bytes,1,opt,name=Version" json:"Version,omitempty"`
}

func (m *HeadVersionResponse) Reset()                    { *m = HeadVersionResponse{} }
func (m *HeadVersionResponse) String() string            { return proto.CompactTextString(m) }
func (*HeadVersionResponse) ProtoMessage()               {}
func (*HeadVersionResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{29} }

func (m *HeadVersionResponse) GetVersion() *ChangeLog {
	if m != nil {
		return m.Version
	}
	return nil
}

type StoreVersionRequest struct {
	Node    *Node      `protobuf:"bytes,1,opt,name=Node" json:"Node,omitempty"`
	Version *ChangeLog `protobuf:"bytes,2,opt,name=Version" json:"Version,omitempty"`
}

func (m *StoreVersionRequest) Reset()                    { *m = StoreVersionRequest{} }
func (m *StoreVersionRequest) String() string            { return proto.CompactTextString(m) }
func (*StoreVersionRequest) ProtoMessage()               {}
func (*StoreVersionRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{30} }

func (m *StoreVersionRequest) GetNode() *Node {
	if m != nil {
		return m.Node
	}
	return nil
}

func (m *StoreVersionRequest) GetVersion() *ChangeLog {
	if m != nil {
		return m.Version
	}
	return nil
}

type StoreVersionResponse struct {
	Success       bool         `protobuf:"varint,1,opt,name=Success" json:"Success,omitempty"`
	PruneVersions []*ChangeLog `protobuf:"bytes,2,rep,name=PruneVersions" json:"PruneVersions,omitempty"`
}

func (m *StoreVersionResponse) Reset()                    { *m = StoreVersionResponse{} }
func (m *StoreVersionResponse) String() string            { return proto.CompactTextString(m) }
func (*StoreVersionResponse) ProtoMessage()               {}
func (*StoreVersionResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{31} }

func (m *StoreVersionResponse) GetSuccess() bool {
	if m != nil {
		return m.Success
	}
	return false
}

func (m *StoreVersionResponse) GetPruneVersions() []*ChangeLog {
	if m != nil {
		return m.PruneVersions
	}
	return nil
}

type PruneVersionsRequest struct {
	UniqueNode      *Node `protobuf:"bytes,1,opt,name=UniqueNode" json:"UniqueNode,omitempty"`
	AllDeletedNodes bool  `protobuf:"varint,2,opt,name=AllDeletedNodes" json:"AllDeletedNodes,omitempty"`
}

func (m *PruneVersionsRequest) Reset()                    { *m = PruneVersionsRequest{} }
func (m *PruneVersionsRequest) String() string            { return proto.CompactTextString(m) }
func (*PruneVersionsRequest) ProtoMessage()               {}
func (*PruneVersionsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{32} }

func (m *PruneVersionsRequest) GetUniqueNode() *Node {
	if m != nil {
		return m.UniqueNode
	}
	return nil
}

func (m *PruneVersionsRequest) GetAllDeletedNodes() bool {
	if m != nil {
		return m.AllDeletedNodes
	}
	return false
}

type PruneVersionsResponse struct {
	DeletedVersions []*ChangeLog `protobuf:"bytes,1,rep,name=DeletedVersions" json:"DeletedVersions,omitempty"`
}

func (m *PruneVersionsResponse) Reset()                    { *m = PruneVersionsResponse{} }
func (m *PruneVersionsResponse) String() string            { return proto.CompactTextString(m) }
func (*PruneVersionsResponse) ProtoMessage()               {}
func (*PruneVersionsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{33} }

func (m *PruneVersionsResponse) GetDeletedVersions() []*ChangeLog {
	if m != nil {
		return m.DeletedVersions
	}
	return nil
}

type VersioningPolicy struct {
	Uuid                     string                        `protobuf:"bytes,1,opt,name=Uuid" json:"Uuid,omitempty"`
	Name                     string                        `protobuf:"bytes,2,opt,name=Name" json:"Name,omitempty"`
	Description              string                        `protobuf:"bytes,3,opt,name=Description" json:"Description,omitempty"`
	VersionsDataSourceName   string                        `protobuf:"bytes,4,opt,name=VersionsDataSourceName" json:"VersionsDataSourceName,omitempty"`
	VersionsDataSourceBucket string                        `protobuf:"bytes,5,opt,name=VersionsDataSourceBucket" json:"VersionsDataSourceBucket,omitempty"`
	MaxTotalSize             int64                         `protobuf:"varint,6,opt,name=MaxTotalSize" json:"MaxTotalSize,omitempty"`
	MaxSizePerFile           int64                         `protobuf:"varint,7,opt,name=MaxSizePerFile" json:"MaxSizePerFile,omitempty"`
	IgnoreFilesGreaterThan   int64                         `protobuf:"varint,8,opt,name=IgnoreFilesGreaterThan" json:"IgnoreFilesGreaterThan,omitempty"`
	KeepPeriods              []*VersioningKeepPeriod       `protobuf:"bytes,9,rep,name=KeepPeriods" json:"KeepPeriods,omitempty"`
	NodeDeletedStrategy      VersioningNodeDeletedStrategy `protobuf:"varint,10,opt,name=NodeDeletedStrategy,enum=tree.VersioningNodeDeletedStrategy" json:"NodeDeletedStrategy,omitempty"`
}

func (m *VersioningPolicy) Reset()                    { *m = VersioningPolicy{} }
func (m *VersioningPolicy) String() string            { return proto.CompactTextString(m) }
func (*VersioningPolicy) ProtoMessage()               {}
func (*VersioningPolicy) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{34} }

func (m *VersioningPolicy) GetUuid() string {
	if m != nil {
		return m.Uuid
	}
	return ""
}

func (m *VersioningPolicy) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *VersioningPolicy) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *VersioningPolicy) GetVersionsDataSourceName() string {
	if m != nil {
		return m.VersionsDataSourceName
	}
	return ""
}

func (m *VersioningPolicy) GetVersionsDataSourceBucket() string {
	if m != nil {
		return m.VersionsDataSourceBucket
	}
	return ""
}

func (m *VersioningPolicy) GetMaxTotalSize() int64 {
	if m != nil {
		return m.MaxTotalSize
	}
	return 0
}

func (m *VersioningPolicy) GetMaxSizePerFile() int64 {
	if m != nil {
		return m.MaxSizePerFile
	}
	return 0
}

func (m *VersioningPolicy) GetIgnoreFilesGreaterThan() int64 {
	if m != nil {
		return m.IgnoreFilesGreaterThan
	}
	return 0
}

func (m *VersioningPolicy) GetKeepPeriods() []*VersioningKeepPeriod {
	if m != nil {
		return m.KeepPeriods
	}
	return nil
}

func (m *VersioningPolicy) GetNodeDeletedStrategy() VersioningNodeDeletedStrategy {
	if m != nil {
		return m.NodeDeletedStrategy
	}
	return VersioningNodeDeletedStrategy_KeepAll
}

type VersioningKeepPeriod struct {
	IntervalStart string `protobuf:"bytes,1,opt,name=IntervalStart" json:"IntervalStart,omitempty"`
	MaxNumber     int32  `protobuf:"varint,3,opt,name=MaxNumber" json:"MaxNumber,omitempty"`
}

func (m *VersioningKeepPeriod) Reset()                    { *m = VersioningKeepPeriod{} }
func (m *VersioningKeepPeriod) String() string            { return proto.CompactTextString(m) }
func (*VersioningKeepPeriod) ProtoMessage()               {}
func (*VersioningKeepPeriod) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{35} }

func (m *VersioningKeepPeriod) GetIntervalStart() string {
	if m != nil {
		return m.IntervalStart
	}
	return ""
}

func (m *VersioningKeepPeriod) GetMaxNumber() int32 {
	if m != nil {
		return m.MaxNumber
	}
	return 0
}

type Node struct {
	// ------------------------------------
	// Core identification of the node
	// ------------------------------------
	Uuid string   `protobuf:"bytes,1,opt,name=Uuid" json:"Uuid,omitempty"`
	Path string   `protobuf:"bytes,2,opt,name=Path" json:"Path,omitempty"`
	Type NodeType `protobuf:"varint,3,opt,name=Type,enum=tree.NodeType" json:"Type,omitempty"`
	// Size of the file, or cumulated size of folder
	Size int64 `protobuf:"varint,4,opt,name=Size" json:"Size,omitempty"`
	// Last modification Timestamp
	MTime int64 `protobuf:"varint,5,opt,name=MTime" json:"MTime,omitempty"`
	// Permission mode, like 0777
	Mode int32 `protobuf:"varint,6,opt,name=Mode" json:"Mode,omitempty"`
	// Hash of the content if node is a LEAF, Uuid or
	Etag string `protobuf:"bytes,7,opt,name=Etag" json:"Etag,omitempty"`
	// List of successive commits
	Commits []*ChangeLog `protobuf:"bytes,9,rep,name=Commits" json:"Commits,omitempty"`
	// ------------------------------------
	// Then a free K => V representation of any kind of metadata
	// ------------------------------------
	MetaStore map[string]string `protobuf:"bytes,8,rep,name=MetaStore" json:"MetaStore,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Can be used for output when node is appearing in multiple workspaces
	AppearsIn []*WorkspaceRelativePath `protobuf:"bytes,10,rep,name=AppearsIn" json:"AppearsIn,omitempty"`
}

func (m *Node) Reset()                    { *m = Node{} }
func (m *Node) String() string            { return proto.CompactTextString(m) }
func (*Node) ProtoMessage()               {}
func (*Node) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{36} }

func (m *Node) GetUuid() string {
	if m != nil {
		return m.Uuid
	}
	return ""
}

func (m *Node) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *Node) GetType() NodeType {
	if m != nil {
		return m.Type
	}
	return NodeType_UNKNOWN
}

func (m *Node) GetSize() int64 {
	if m != nil {
		return m.Size
	}
	return 0
}

func (m *Node) GetMTime() int64 {
	if m != nil {
		return m.MTime
	}
	return 0
}

func (m *Node) GetMode() int32 {
	if m != nil {
		return m.Mode
	}
	return 0
}

func (m *Node) GetEtag() string {
	if m != nil {
		return m.Etag
	}
	return ""
}

func (m *Node) GetCommits() []*ChangeLog {
	if m != nil {
		return m.Commits
	}
	return nil
}

func (m *Node) GetMetaStore() map[string]string {
	if m != nil {
		return m.MetaStore
	}
	return nil
}

func (m *Node) GetAppearsIn() []*WorkspaceRelativePath {
	if m != nil {
		return m.AppearsIn
	}
	return nil
}

// Used in AppearsIn to signal a node is
// appearing in multiple workspaces in the current context
type WorkspaceRelativePath struct {
	// Workspace Id
	WsUuid string `protobuf:"bytes,1,opt,name=WsUuid" json:"WsUuid,omitempty"`
	// Workspace Label
	WsLabel string `protobuf:"bytes,2,opt,name=WsLabel" json:"WsLabel,omitempty"`
	// Relative Path inside workspace
	Path string `protobuf:"bytes,3,opt,name=Path" json:"Path,omitempty"`
	// Workspace slug
	WsSlug string `protobuf:"bytes,4,opt,name=WsSlug" json:"WsSlug,omitempty"`
	// Workspace Scope
	WsScope string `protobuf:"bytes,5,opt,name=WsScope" json:"WsScope,omitempty"`
}

func (m *WorkspaceRelativePath) Reset()                    { *m = WorkspaceRelativePath{} }
func (m *WorkspaceRelativePath) String() string            { return proto.CompactTextString(m) }
func (*WorkspaceRelativePath) ProtoMessage()               {}
func (*WorkspaceRelativePath) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{37} }

func (m *WorkspaceRelativePath) GetWsUuid() string {
	if m != nil {
		return m.WsUuid
	}
	return ""
}

func (m *WorkspaceRelativePath) GetWsLabel() string {
	if m != nil {
		return m.WsLabel
	}
	return ""
}

func (m *WorkspaceRelativePath) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *WorkspaceRelativePath) GetWsSlug() string {
	if m != nil {
		return m.WsSlug
	}
	return ""
}

func (m *WorkspaceRelativePath) GetWsScope() string {
	if m != nil {
		return m.WsScope
	}
	return ""
}

type ChangeLog struct {
	// Unique commit ID
	Uuid string `protobuf:"bytes,1,opt,name=Uuid" json:"Uuid,omitempty"`
	// Human-readable description of what happened
	Description string `protobuf:"bytes,2,opt,name=Description" json:"Description,omitempty"`
	// Unix Timestamp
	MTime int64 `protobuf:"varint,3,opt,name=MTime" json:"MTime,omitempty"`
	// Content Size at that moment
	Size int64 `protobuf:"varint,4,opt,name=Size" json:"Size,omitempty"`
	// Arbitrary additional data
	Data []byte `protobuf:"bytes,5,opt,name=Data,proto3" json:"Data,omitempty"`
	// Who performed this action
	OwnerUuid string `protobuf:"bytes,6,opt,name=OwnerUuid" json:"OwnerUuid,omitempty"`
	// Event that triggered this change
	Event *NodeChangeEvent `protobuf:"bytes,7,opt,name=Event" json:"Event,omitempty"`
	// Actual location of the stored version
	Location *Node `protobuf:"bytes,8,opt,name=Location" json:"Location,omitempty"`
}

func (m *ChangeLog) Reset()                    { *m = ChangeLog{} }
func (m *ChangeLog) String() string            { return proto.CompactTextString(m) }
func (*ChangeLog) ProtoMessage()               {}
func (*ChangeLog) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{38} }

func (m *ChangeLog) GetUuid() string {
	if m != nil {
		return m.Uuid
	}
	return ""
}

func (m *ChangeLog) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *ChangeLog) GetMTime() int64 {
	if m != nil {
		return m.MTime
	}
	return 0
}

func (m *ChangeLog) GetSize() int64 {
	if m != nil {
		return m.Size
	}
	return 0
}

func (m *ChangeLog) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *ChangeLog) GetOwnerUuid() string {
	if m != nil {
		return m.OwnerUuid
	}
	return ""
}

func (m *ChangeLog) GetEvent() *NodeChangeEvent {
	if m != nil {
		return m.Event
	}
	return nil
}

func (m *ChangeLog) GetLocation() *Node {
	if m != nil {
		return m.Location
	}
	return nil
}

// Search Queries
type Query struct {
	// Preset list of nodes by Path
	Paths []string `protobuf:"bytes,13,rep,name=Paths" json:"Paths,omitempty"`
	// Limit to a given subtree
	PathPrefix []string `protobuf:"bytes,1,rep,name=PathPrefix" json:"PathPrefix,omitempty"`
	// Range for size
	MinSize int64 `protobuf:"varint,2,opt,name=MinSize" json:"MinSize,omitempty"`
	MaxSize int64 `protobuf:"varint,3,opt,name=MaxSize" json:"MaxSize,omitempty"`
	// Range for date
	MinDate int64 `protobuf:"varint,4,opt,name=MinDate" json:"MinDate,omitempty"`
	MaxDate int64 `protobuf:"varint,5,opt,name=MaxDate" json:"MaxDate,omitempty"`
	// Pass a duration with > or < to compute MinDate / MaxDate
	DurationDate string `protobuf:"bytes,16,opt,name=DurationDate" json:"DurationDate,omitempty"`
	// Limit to a given node type
	Type NodeType `protobuf:"varint,6,opt,name=Type,enum=tree.NodeType" json:"Type,omitempty"`
	// Search in filename
	FileName string `protobuf:"bytes,7,opt,name=FileName" json:"FileName,omitempty"`
	// Search in content
	Content string `protobuf:"bytes,8,opt,name=Content" json:"Content,omitempty"`
	// Search in either filename or content (but at least one of them)
	FileNameOrContent string `protobuf:"bytes,17,opt,name=FileNameOrContent" json:"FileNameOrContent,omitempty"`
	// Free Query String (for metadata)
	FreeString string `protobuf:"bytes,9,opt,name=FreeString" json:"FreeString,omitempty"`
	// Search files by extension
	Extension string `protobuf:"bytes,10,opt,name=Extension" json:"Extension,omitempty"`
	// Search geographically
	GeoQuery *GeoQuery `protobuf:"bytes,11,opt,name=GeoQuery" json:"GeoQuery,omitempty"`
	// Limit to a given level of the tree - can be used in filters
	PathDepth int32 `protobuf:"varint,12,opt,name=PathDepth" json:"PathDepth,omitempty"`
	// Preset list of Node by UUIDs
	UUIDs []string `protobuf:"bytes,15,rep,name=UUIDs" json:"UUIDs,omitempty"`
	// Negate this query
	Not bool `protobuf:"varint,14,opt,name=Not" json:"Not,omitempty"`
}

func (m *Query) Reset()                    { *m = Query{} }
func (m *Query) String() string            { return proto.CompactTextString(m) }
func (*Query) ProtoMessage()               {}
func (*Query) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{39} }

func (m *Query) GetPaths() []string {
	if m != nil {
		return m.Paths
	}
	return nil
}

func (m *Query) GetPathPrefix() []string {
	if m != nil {
		return m.PathPrefix
	}
	return nil
}

func (m *Query) GetMinSize() int64 {
	if m != nil {
		return m.MinSize
	}
	return 0
}

func (m *Query) GetMaxSize() int64 {
	if m != nil {
		return m.MaxSize
	}
	return 0
}

func (m *Query) GetMinDate() int64 {
	if m != nil {
		return m.MinDate
	}
	return 0
}

func (m *Query) GetMaxDate() int64 {
	if m != nil {
		return m.MaxDate
	}
	return 0
}

func (m *Query) GetDurationDate() string {
	if m != nil {
		return m.DurationDate
	}
	return ""
}

func (m *Query) GetType() NodeType {
	if m != nil {
		return m.Type
	}
	return NodeType_UNKNOWN
}

func (m *Query) GetFileName() string {
	if m != nil {
		return m.FileName
	}
	return ""
}

func (m *Query) GetContent() string {
	if m != nil {
		return m.Content
	}
	return ""
}

func (m *Query) GetFileNameOrContent() string {
	if m != nil {
		return m.FileNameOrContent
	}
	return ""
}

func (m *Query) GetFreeString() string {
	if m != nil {
		return m.FreeString
	}
	return ""
}

func (m *Query) GetExtension() string {
	if m != nil {
		return m.Extension
	}
	return ""
}

func (m *Query) GetGeoQuery() *GeoQuery {
	if m != nil {
		return m.GeoQuery
	}
	return nil
}

func (m *Query) GetPathDepth() int32 {
	if m != nil {
		return m.PathDepth
	}
	return 0
}

func (m *Query) GetUUIDs() []string {
	if m != nil {
		return m.UUIDs
	}
	return nil
}

func (m *Query) GetNot() bool {
	if m != nil {
		return m.Not
	}
	return false
}

type GeoQuery struct {
	// Either use a center point and a distance
	Center *GeoPoint `protobuf:"bytes,1,opt,name=Center" json:"Center,omitempty"`
	// Example formats supported:
	// "5in" "5inch" "7yd" "7yards" "9ft" "9feet" "11km" "11kilometers"
	// "3nm" "3nauticalmiles" "13mm" "13millimeters" "15cm" "15centimeters"
	// "17mi" "17miles" "19m" "19meters"
	// If the unit cannot be determined, the entire string is parsed and the
	// unit of meters is assumed.
	Distance string `protobuf:"bytes,2,opt,name=Distance" json:"Distance,omitempty"`
	// Or use a bounding box with TopLeft and BottomRight points
	TopLeft     *GeoPoint `protobuf:"bytes,3,opt,name=TopLeft" json:"TopLeft,omitempty"`
	BottomRight *GeoPoint `protobuf:"bytes,4,opt,name=BottomRight" json:"BottomRight,omitempty"`
}

func (m *GeoQuery) Reset()                    { *m = GeoQuery{} }
func (m *GeoQuery) String() string            { return proto.CompactTextString(m) }
func (*GeoQuery) ProtoMessage()               {}
func (*GeoQuery) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{40} }

func (m *GeoQuery) GetCenter() *GeoPoint {
	if m != nil {
		return m.Center
	}
	return nil
}

func (m *GeoQuery) GetDistance() string {
	if m != nil {
		return m.Distance
	}
	return ""
}

func (m *GeoQuery) GetTopLeft() *GeoPoint {
	if m != nil {
		return m.TopLeft
	}
	return nil
}

func (m *GeoQuery) GetBottomRight() *GeoPoint {
	if m != nil {
		return m.BottomRight
	}
	return nil
}

type GeoPoint struct {
	Lat float64 `protobuf:"fixed64,1,opt,name=Lat" json:"Lat,omitempty"`
	Lon float64 `protobuf:"fixed64,2,opt,name=Lon" json:"Lon,omitempty"`
}

func (m *GeoPoint) Reset()                    { *m = GeoPoint{} }
func (m *GeoPoint) String() string            { return proto.CompactTextString(m) }
func (*GeoPoint) ProtoMessage()               {}
func (*GeoPoint) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{41} }

func (m *GeoPoint) GetLat() float64 {
	if m != nil {
		return m.Lat
	}
	return 0
}

func (m *GeoPoint) GetLon() float64 {
	if m != nil {
		return m.Lon
	}
	return 0
}

type StreamChangesRequest struct {
	RootPath string `protobuf:"bytes,1,opt,name=RootPath" json:"RootPath,omitempty"`
}

func (m *StreamChangesRequest) Reset()                    { *m = StreamChangesRequest{} }
func (m *StreamChangesRequest) String() string            { return proto.CompactTextString(m) }
func (*StreamChangesRequest) ProtoMessage()               {}
func (*StreamChangesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{42} }

func (m *StreamChangesRequest) GetRootPath() string {
	if m != nil {
		return m.RootPath
	}
	return ""
}

type NodeChangeEvent struct {
	Type       NodeChangeEvent_EventType `protobuf:"varint,1,opt,name=Type,enum=tree.NodeChangeEvent_EventType" json:"Type,omitempty"`
	Source     *Node                     `protobuf:"bytes,2,opt,name=Source" json:"Source,omitempty"`
	Target     *Node                     `protobuf:"bytes,3,opt,name=Target" json:"Target,omitempty"`
	Metadata   map[string]string         `protobuf:"bytes,6,rep,name=Metadata" json:"Metadata,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	Silent     bool                      `protobuf:"varint,4,opt,name=Silent" json:"Silent,omitempty"`
	Optimistic bool                      `protobuf:"varint,5,opt,name=Optimistic" json:"Optimistic,omitempty"`
}

func (m *NodeChangeEvent) Reset()                    { *m = NodeChangeEvent{} }
func (m *NodeChangeEvent) String() string            { return proto.CompactTextString(m) }
func (*NodeChangeEvent) ProtoMessage()               {}
func (*NodeChangeEvent) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{43} }

func (m *NodeChangeEvent) GetType() NodeChangeEvent_EventType {
	if m != nil {
		return m.Type
	}
	return NodeChangeEvent_CREATE
}

func (m *NodeChangeEvent) GetSource() *Node {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *NodeChangeEvent) GetTarget() *Node {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *NodeChangeEvent) GetMetadata() map[string]string {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *NodeChangeEvent) GetSilent() bool {
	if m != nil {
		return m.Silent
	}
	return false
}

func (m *NodeChangeEvent) GetOptimistic() bool {
	if m != nil {
		return m.Optimistic
	}
	return false
}

type IndexEvent struct {
	ErrorDetected     bool   `protobuf:"varint,1,opt,name=ErrorDetected" json:"ErrorDetected,omitempty"`
	DataSourceName    string `protobuf:"bytes,2,opt,name=DataSourceName" json:"DataSourceName,omitempty"`
	ErrorPath         string `protobuf:"bytes,3,opt,name=ErrorPath" json:"ErrorPath,omitempty"`
	SessionForceClose string `protobuf:"bytes,4,opt,name=SessionForceClose" json:"SessionForceClose,omitempty"`
}

func (m *IndexEvent) Reset()                    { *m = IndexEvent{} }
func (m *IndexEvent) String() string            { return proto.CompactTextString(m) }
func (*IndexEvent) ProtoMessage()               {}
func (*IndexEvent) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{44} }

func (m *IndexEvent) GetErrorDetected() bool {
	if m != nil {
		return m.ErrorDetected
	}
	return false
}

func (m *IndexEvent) GetDataSourceName() string {
	if m != nil {
		return m.DataSourceName
	}
	return ""
}

func (m *IndexEvent) GetErrorPath() string {
	if m != nil {
		return m.ErrorPath
	}
	return ""
}

func (m *IndexEvent) GetSessionForceClose() string {
	if m != nil {
		return m.SessionForceClose
	}
	return ""
}

type GetEncryptionKeyRequest struct {
	User     string `protobuf:"bytes,1,opt,name=User" json:"User,omitempty"`
	Password string `protobuf:"bytes,2,opt,name=Password" json:"Password,omitempty"`
	Node     *Node  `protobuf:"bytes,3,opt,name=Node" json:"Node,omitempty"`
	Create   bool   `protobuf:"varint,5,opt,name=Create" json:"Create,omitempty"`
}

func (m *GetEncryptionKeyRequest) Reset()                    { *m = GetEncryptionKeyRequest{} }
func (m *GetEncryptionKeyRequest) String() string            { return proto.CompactTextString(m) }
func (*GetEncryptionKeyRequest) ProtoMessage()               {}
func (*GetEncryptionKeyRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{45} }

func (m *GetEncryptionKeyRequest) GetUser() string {
	if m != nil {
		return m.User
	}
	return ""
}

func (m *GetEncryptionKeyRequest) GetPassword() string {
	if m != nil {
		return m.Password
	}
	return ""
}

func (m *GetEncryptionKeyRequest) GetNode() *Node {
	if m != nil {
		return m.Node
	}
	return nil
}

func (m *GetEncryptionKeyRequest) GetCreate() bool {
	if m != nil {
		return m.Create
	}
	return false
}

type GetEncryptionKeyResponse struct {
	Key []byte `protobuf:"bytes,1,opt,name=Key,proto3" json:"Key,omitempty"`
}

func (m *GetEncryptionKeyResponse) Reset()                    { *m = GetEncryptionKeyResponse{} }
func (m *GetEncryptionKeyResponse) String() string            { return proto.CompactTextString(m) }
func (*GetEncryptionKeyResponse) ProtoMessage()               {}
func (*GetEncryptionKeyResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{46} }

func (m *GetEncryptionKeyResponse) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

type SyncChange struct {
	Seq    uint64          `protobuf:"varint,1,opt,name=seq" json:"seq,omitempty"`
	NodeId string          `protobuf:"bytes,2,opt,name=nodeId,json=node_id" json:"nodeId,omitempty"`
	Type   SyncChange_Type `protobuf:"varint,3,opt,name=type,enum=tree.SyncChange_Type" json:"type,omitempty"`
	Source string          `protobuf:"bytes,4,opt,name=source" json:"source,omitempty"`
	Target string          `protobuf:"bytes,5,opt,name=target" json:"target,omitempty"`
	Node   *SyncChangeNode `protobuf:"bytes,6,opt,name=node" json:"node,omitempty"`
}

func (m *SyncChange) Reset()                    { *m = SyncChange{} }
func (m *SyncChange) String() string            { return proto.CompactTextString(m) }
func (*SyncChange) ProtoMessage()               {}
func (*SyncChange) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{47} }

func (m *SyncChange) GetSeq() uint64 {
	if m != nil {
		return m.Seq
	}
	return 0
}

func (m *SyncChange) GetNodeId() string {
	if m != nil {
		return m.NodeId
	}
	return ""
}

func (m *SyncChange) GetType() SyncChange_Type {
	if m != nil {
		return m.Type
	}
	return SyncChange_unknown
}

func (m *SyncChange) GetSource() string {
	if m != nil {
		return m.Source
	}
	return ""
}

func (m *SyncChange) GetTarget() string {
	if m != nil {
		return m.Target
	}
	return ""
}

func (m *SyncChange) GetNode() *SyncChangeNode {
	if m != nil {
		return m.Node
	}
	return nil
}

type SyncChangeNode struct {
	Bytesize             int64  `protobuf:"varint,1,opt,name=bytesize" json:"bytesize,omitempty"`
	Md5                  string `protobuf:"bytes,2,opt,name=md5" json:"md5,omitempty"`
	Mtime                int64  `protobuf:"varint,3,opt,name=mtime" json:"mtime,omitempty"`
	NodePath             string `protobuf:"bytes,4,opt,name=nodePath,json=node_path" json:"nodePath,omitempty"`
	RepositoryIdentifier string `protobuf:"bytes,5,opt,name=repositoryIdentifier,json=repository_identifier" json:"repositoryIdentifier,omitempty"`
}

func (m *SyncChangeNode) Reset()                    { *m = SyncChangeNode{} }
func (m *SyncChangeNode) String() string            { return proto.CompactTextString(m) }
func (*SyncChangeNode) ProtoMessage()               {}
func (*SyncChangeNode) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{48} }

func (m *SyncChangeNode) GetBytesize() int64 {
	if m != nil {
		return m.Bytesize
	}
	return 0
}

func (m *SyncChangeNode) GetMd5() string {
	if m != nil {
		return m.Md5
	}
	return ""
}

func (m *SyncChangeNode) GetMtime() int64 {
	if m != nil {
		return m.Mtime
	}
	return 0
}

func (m *SyncChangeNode) GetNodePath() string {
	if m != nil {
		return m.NodePath
	}
	return ""
}

func (m *SyncChangeNode) GetRepositoryIdentifier() string {
	if m != nil {
		return m.RepositoryIdentifier
	}
	return ""
}

type PutSyncChangeResponse struct {
	Success bool   `protobuf:"varint,1,opt,name=success" json:"success,omitempty"`
	Msg     string `protobuf:"bytes,2,opt,name=msg" json:"msg,omitempty"`
}

func (m *PutSyncChangeResponse) Reset()                    { *m = PutSyncChangeResponse{} }
func (m *PutSyncChangeResponse) String() string            { return proto.CompactTextString(m) }
func (*PutSyncChangeResponse) ProtoMessage()               {}
func (*PutSyncChangeResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{49} }

func (m *PutSyncChangeResponse) GetSuccess() bool {
	if m != nil {
		return m.Success
	}
	return false
}

func (m *PutSyncChangeResponse) GetMsg() string {
	if m != nil {
		return m.Msg
	}
	return ""
}

type SearchSyncChangeRequest struct {
	Seq         uint64 `protobuf:"varint,1,opt,name=seq" json:"seq,omitempty"`
	Flatten     bool   `protobuf:"varint,2,opt,name=flatten" json:"flatten,omitempty"`
	Prefix      string `protobuf:"bytes,3,opt,name=prefix" json:"prefix,omitempty"`
	LastSeqOnly bool   `protobuf:"varint,4,opt,name=lastSeqOnly" json:"lastSeqOnly,omitempty"`
}

func (m *SearchSyncChangeRequest) Reset()                    { *m = SearchSyncChangeRequest{} }
func (m *SearchSyncChangeRequest) String() string            { return proto.CompactTextString(m) }
func (*SearchSyncChangeRequest) ProtoMessage()               {}
func (*SearchSyncChangeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{50} }

func (m *SearchSyncChangeRequest) GetSeq() uint64 {
	if m != nil {
		return m.Seq
	}
	return 0
}

func (m *SearchSyncChangeRequest) GetFlatten() bool {
	if m != nil {
		return m.Flatten
	}
	return false
}

func (m *SearchSyncChangeRequest) GetPrefix() string {
	if m != nil {
		return m.Prefix
	}
	return ""
}

func (m *SearchSyncChangeRequest) GetLastSeqOnly() bool {
	if m != nil {
		return m.LastSeqOnly
	}
	return false
}

func init() {
	proto.RegisterType((*ReadNodeRequest)(nil), "tree.ReadNodeRequest")
	proto.RegisterType((*ReadNodeResponse)(nil), "tree.ReadNodeResponse")
	proto.RegisterType((*ListNodesRequest)(nil), "tree.ListNodesRequest")
	proto.RegisterType((*ListNodesResponse)(nil), "tree.ListNodesResponse")
	proto.RegisterType((*WrappingStreamerResponse)(nil), "tree.WrappingStreamerResponse")
	proto.RegisterType((*CreateNodeRequest)(nil), "tree.CreateNodeRequest")
	proto.RegisterType((*CreateNodeResponse)(nil), "tree.CreateNodeResponse")
	proto.RegisterType((*UpdateNodeRequest)(nil), "tree.UpdateNodeRequest")
	proto.RegisterType((*UpdateNodeResponse)(nil), "tree.UpdateNodeResponse")
	proto.RegisterType((*DeleteNodeRequest)(nil), "tree.DeleteNodeRequest")
	proto.RegisterType((*DeleteNodeResponse)(nil), "tree.DeleteNodeResponse")
	proto.RegisterType((*IndexationSession)(nil), "tree.IndexationSession")
	proto.RegisterType((*IndexationOperation)(nil), "tree.IndexationOperation")
	proto.RegisterType((*OpenSessionRequest)(nil), "tree.OpenSessionRequest")
	proto.RegisterType((*OpenSessionResponse)(nil), "tree.OpenSessionResponse")
	proto.RegisterType((*FlushSessionRequest)(nil), "tree.FlushSessionRequest")
	proto.RegisterType((*FlushSessionResponse)(nil), "tree.FlushSessionResponse")
	proto.RegisterType((*CloseSessionRequest)(nil), "tree.CloseSessionRequest")
	proto.RegisterType((*CloseSessionResponse)(nil), "tree.CloseSessionResponse")
	proto.RegisterType((*WatchNodeRequest)(nil), "tree.WatchNodeRequest")
	proto.RegisterType((*WatchNodeResponse)(nil), "tree.WatchNodeResponse")
	proto.RegisterType((*SearchRequest)(nil), "tree.SearchRequest")
	proto.RegisterType((*SearchFacet)(nil), "tree.SearchFacet")
	proto.RegisterType((*SearchResponse)(nil), "tree.SearchResponse")
	proto.RegisterType((*CreateVersionRequest)(nil), "tree.CreateVersionRequest")
	proto.RegisterType((*CreateVersionResponse)(nil), "tree.CreateVersionResponse")
	proto.RegisterType((*ListVersionsRequest)(nil), "tree.ListVersionsRequest")
	proto.RegisterType((*ListVersionsResponse)(nil), "tree.ListVersionsResponse")
	proto.RegisterType((*HeadVersionRequest)(nil), "tree.HeadVersionRequest")
	proto.RegisterType((*HeadVersionResponse)(nil), "tree.HeadVersionResponse")
	proto.RegisterType((*StoreVersionRequest)(nil), "tree.StoreVersionRequest")
	proto.RegisterType((*StoreVersionResponse)(nil), "tree.StoreVersionResponse")
	proto.RegisterType((*PruneVersionsRequest)(nil), "tree.PruneVersionsRequest")
	proto.RegisterType((*PruneVersionsResponse)(nil), "tree.PruneVersionsResponse")
	proto.RegisterType((*VersioningPolicy)(nil), "tree.VersioningPolicy")
	proto.RegisterType((*VersioningKeepPeriod)(nil), "tree.VersioningKeepPeriod")
	proto.RegisterType((*Node)(nil), "tree.Node")
	proto.RegisterType((*WorkspaceRelativePath)(nil), "tree.WorkspaceRelativePath")
	proto.RegisterType((*ChangeLog)(nil), "tree.ChangeLog")
	proto.RegisterType((*Query)(nil), "tree.Query")
	proto.RegisterType((*GeoQuery)(nil), "tree.GeoQuery")
	proto.RegisterType((*GeoPoint)(nil), "tree.GeoPoint")
	proto.RegisterType((*StreamChangesRequest)(nil), "tree.StreamChangesRequest")
	proto.RegisterType((*NodeChangeEvent)(nil), "tree.NodeChangeEvent")
	proto.RegisterType((*IndexEvent)(nil), "tree.IndexEvent")
	proto.RegisterType((*GetEncryptionKeyRequest)(nil), "tree.GetEncryptionKeyRequest")
	proto.RegisterType((*GetEncryptionKeyResponse)(nil), "tree.GetEncryptionKeyResponse")
	proto.RegisterType((*SyncChange)(nil), "tree.SyncChange")
	proto.RegisterType((*SyncChangeNode)(nil), "tree.SyncChangeNode")
	proto.RegisterType((*PutSyncChangeResponse)(nil), "tree.PutSyncChangeResponse")
	proto.RegisterType((*SearchSyncChangeRequest)(nil), "tree.SearchSyncChangeRequest")
	proto.RegisterEnum("tree.VersioningNodeDeletedStrategy", VersioningNodeDeletedStrategy_name, VersioningNodeDeletedStrategy_value)
	proto.RegisterEnum("tree.NodeType", NodeType_name, NodeType_value)
	proto.RegisterEnum("tree.NodeChangeEvent_EventType", NodeChangeEvent_EventType_name, NodeChangeEvent_EventType_value)
	proto.RegisterEnum("tree.SyncChange_Type", SyncChange_Type_name, SyncChange_Type_value)
}

func init() { proto.RegisterFile("tree.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 2955 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x3a, 0x5b, 0x6f, 0x23, 0x49,
	0xd5, 0x69, 0xdb, 0x71, 0xec, 0x93, 0x5b, 0xa7, 0xe2, 0xcc, 0x78, 0xbd, 0x97, 0x6f, 0xbe, 0xde,
	0xd5, 0x92, 0x1d, 0x56, 0xd1, 0x6e, 0x86, 0x65, 0xaf, 0x88, 0xf5, 0xd8, 0xce, 0x4c, 0x98, 0x5c,
	0x4c, 0xdb, 0xd9, 0x08, 0x24, 0xb4, 0xf4, 0xb4, 0x2b, 0x4e, 0x33, 0x76, 0xb7, 0xa7, 0xba, 0x9c,
	0x8d, 0x79, 0x81, 0x79, 0xe1, 0x0d, 0x21, 0x21, 0xf1, 0x03, 0x10, 0x12, 0x0f, 0xfc, 0x01, 0x1e,
	0x79, 0xe1, 0x3f, 0xf0, 0x17, 0xe0, 0x95, 0x37, 0xc4, 0x0b, 0x3a, 0x75, 0xe9, 0x8b, 0xbb, 0x33,
	0x93, 0xcc, 0xec, 0x8b, 0xd5, 0xe7, 0x52, 0xa7, 0xce, 0xa5, 0xce, 0xa9, 0x53, 0x55, 0x06, 0xe0,
	0x8c, 0xd2, 0x9d, 0x09, 0x0b, 0x78, 0x40, 0x4a, 0xf8, 0x6d, 0xfd, 0xc9, 0x80, 0x75, 0x9b, 0x3a,
	0x83, 0xa3, 0x60, 0x40, 0x6d, 0xfa, 0x74, 0x4a, 0x43, 0x4e, 0xde, 0x82, 0x12, 0x82, 0x75, 0xe3,
	0x8e, 0xb1, 0xbd, 0xbc, 0x0b, 0x3b, 0x62, 0x90, 0x60, 0x10, 0x78, 0x72, 0x07, 0x96, 0x4f, 0x3d,
	0x7e, 0xde, 0x0a, 0xc6, 0x63, 0x8f, 0x87, 0xf5, 0xc2, 0x1d, 0x63, 0xbb, 0x62, 0x27, 0x51, 0xe4,
	0x7d, 0xd8, 0x40, 0xb0, 0x73, 0xc9, 0xa9, 0x3f, 0xa0, 0x83, 0x1e, 0x77, 0x78, 0x58, 0x2f, 0x0a,
	0xbe, 0x2c, 0x01, 0xe5, 0x1d, 0x3f, 0xfe, 0x05, 0x75, 0xb9, 0xe4, 0x2b, 0x49, 0x79, 0x09, 0x94,
	0x75, 0x00, 0x66, 0xac, 0x64, 0x38, 0x09, 0xfc, 0x90, 0x92, 0x3a, 0x2c, 0xf5, 0xa6, 0xae, 0x4b,
	0xc3, 0x50, 0x28, 0x5a, 0xb1, 0x35, 0x18, 0xe9, 0x5f, 0xc8, 0xd7, 0xdf, 0xfa, 0x7d, 0x01, 0xcc,
	0x03, 0x2f, 0xe4, 0x08, 0x84, 0xd7, 0x35, 0xfa, 0x0d, 0xa8, 0xda, 0xd4, 0x9d, 0xb2, 0xd0, 0xbb,
	0xa0, 0xca, 0xe4, 0x18, 0x81, 0xd4, 0xa6, 0xef, 0xd2, 0x90, 0x07, 0x4c, 0x1b, 0x1a, 0x23, 0x88,
	0x05, 0x2b, 0x68, 0xf5, 0x57, 0x94, 0x85, 0x5e, 0xe0, 0x87, 0xf5, 0x25, 0xc1, 0x90, 0xc2, 0xcd,
	0x3b, 0xb5, 0x92, 0x75, 0x6a, 0x0d, 0x16, 0x0f, 0xbc, 0xb1, 0xc7, 0x85, 0x83, 0x8a, 0xb6, 0x04,
	0xc8, 0x2d, 0x28, 0x1f, 0x9f, 0x9d, 0x85, 0x94, 0xd7, 0x17, 0x05, 0x5a, 0x41, 0x64, 0x07, 0x60,
	0xcf, 0x1b, 0x71, 0xca, 0xfa, 0xb3, 0x09, 0xad, 0x97, 0xef, 0x18, 0xdb, 0x6b, 0xbb, 0x6b, 0xb1,
	0x55, 0x88, 0xb5, 0x13, 0x1c, 0xd6, 0x3d, 0xd8, 0x48, 0xf8, 0x44, 0xf9, 0xf8, 0x05, 0x4e, 0xb1,
	0xfe, 0x6e, 0x40, 0xfd, 0x94, 0x39, 0x93, 0x89, 0xe7, 0x0f, 0x7b, 0x9c, 0x51, 0x67, 0x4c, 0x59,
	0x34, 0xf8, 0x41, 0x8e, 0x44, 0x25, 0xe9, 0xb6, 0x94, 0x94, 0x21, 0x3f, 0x5c, 0xb0, 0x73, 0xb4,
	0x68, 0xc2, 0x3a, 0x22, 0x5a, 0xe7, 0x8e, 0x3f, 0xa4, 0x9d, 0x0b, 0xea, 0x73, 0x15, 0xda, 0xad,
	0x58, 0xa1, 0x04, 0xf1, 0xe1, 0x82, 0x3d, 0xcf, 0x8f, 0xbe, 0xeb, 0x30, 0x16, 0x30, 0x11, 0x9b,
	0xaa, 0x2d, 0x81, 0xfb, 0x65, 0x28, 0xb5, 0x1d, 0xee, 0x58, 0x7f, 0x34, 0x60, 0xa3, 0xc5, 0xa8,
	0xc3, 0xe9, 0x4d, 0xd2, 0xe0, 0x5d, 0x58, 0x3b, 0x99, 0x0c, 0x1c, 0x4e, 0xf7, 0xcf, 0x3a, 0x97,
	0x5e, 0x18, 0x65, 0xc2, 0x1c, 0x16, 0x93, 0x61, 0xdf, 0x1f, 0xd0, 0x4b, 0x87, 0x7b, 0x81, 0xdf,
	0xa3, 0x21, 0xc6, 0x5b, 0xe9, 0x91, 0x25, 0x60, 0x3c, 0x7b, 0xde, 0x08, 0x6d, 0x94, 0x79, 0xa0,
	0x20, 0xeb, 0x08, 0x48, 0x52, 0xc5, 0x57, 0x4e, 0x82, 0x3f, 0x18, 0xb0, 0x21, 0x15, 0x9d, 0xb3,
	0x79, 0x8f, 0x05, 0xe3, 0x3c, 0x9b, 0x11, 0x4f, 0x1a, 0x50, 0xe8, 0x07, 0x39, 0x32, 0x0b, 0xfd,
	0xe0, 0xdb, 0xb3, 0x33, 0xa9, 0xd6, 0x2b, 0xdb, 0x39, 0x83, 0x8d, 0x36, 0x1d, 0xd1, 0x9b, 0x85,
	0x36, 0xd7, 0x94, 0xc2, 0x8b, 0x4d, 0x29, 0xa6, 0x4c, 0xd9, 0x01, 0x92, 0x9c, 0xfa, 0x45, 0xa6,
	0x58, 0xff, 0x31, 0x72, 0xa6, 0x25, 0x04, 0x4a, 0x27, 0x53, 0x6f, 0x20, 0x98, 0xab, 0xb6, 0xf8,
	0xc6, 0x62, 0xd1, 0xa6, 0xa1, 0xcb, 0xbc, 0x09, 0x8f, 0x35, 0x4b, 0xa2, 0xc8, 0xbb, 0x50, 0xb1,
	0x83, 0x40, 0x24, 0x92, 0xd0, 0x2a, 0x6d, 0x65, 0x44, 0x23, 0x9f, 0xc0, 0xed, 0xce, 0xe5, 0x84,
	0xba, 0x9c, 0x0e, 0x8e, 0x27, 0x94, 0x89, 0x99, 0xc3, 0x56, 0x30, 0xf5, 0x75, 0x99, 0xb9, 0x8a,
	0x4c, 0xbe, 0x07, 0x5b, 0xad, 0x29, 0x63, 0xd4, 0xe7, 0x11, 0x45, 0x8e, 0x93, 0x75, 0x28, 0x9f,
	0x98, 0xf0, 0x55, 0x39, 0xe5, 0xab, 0xa7, 0xb0, 0x19, 0x9b, 0x1e, 0x8d, 0x41, 0x43, 0x95, 0x1f,
	0x12, 0x3e, 0x48, 0xa2, 0xae, 0xe1, 0x8a, 0x5b, 0x50, 0x6e, 0x4d, 0x59, 0xa8, 0x92, 0xbf, 0x68,
	0x2b, 0xc8, 0x7a, 0x00, 0xe4, 0x78, 0x42, 0xb5, 0x9f, 0xf5, 0xd2, 0xf8, 0x10, 0x96, 0x74, 0xc0,
	0x53, 0xb5, 0x2a, 0x13, 0x18, 0x5b, 0xf3, 0x59, 0x0f, 0x61, 0x33, 0x25, 0x48, 0x05, 0xfa, 0xe5,
	0x24, 0xed, 0x8d, 0xa6, 0xe1, 0xf9, 0xab, 0xeb, 0xb4, 0x0f, 0xb5, 0xb4, 0xa4, 0x57, 0x52, 0xaa,
	0x35, 0x0a, 0x42, 0xfa, 0xad, 0x28, 0x95, 0x96, 0xf4, 0xf2, 0x4a, 0xed, 0x82, 0x79, 0xea, 0x70,
	0xf7, 0xfc, 0x06, 0x59, 0x8d, 0x5b, 0x5c, 0x62, 0xcc, 0x35, 0xb7, 0x38, 0x0e, 0xab, 0x3d, 0xea,
	0x30, 0xf7, 0x5c, 0xcf, 0xf2, 0xff, 0xb0, 0xf8, 0xe3, 0x29, 0x65, 0x33, 0x35, 0x62, 0x59, 0x8e,
	0x10, 0x28, 0x5b, 0x52, 0x30, 0x65, 0x7b, 0xde, 0x2f, 0x65, 0x4d, 0x5a, 0xb4, 0xc5, 0x37, 0xe2,
	0x44, 0x65, 0x2d, 0x4a, 0x9c, 0xa8, 0xa6, 0x75, 0x58, 0x6a, 0x53, 0xee, 0x78, 0x23, 0xdd, 0xf4,
	0x68, 0xd0, 0xfa, 0xab, 0x81, 0x0b, 0x1f, 0xa7, 0xdd, 0x73, 0x5c, 0xca, 0xb1, 0xbf, 0xd8, 0xf3,
	0xe8, 0x68, 0x70, 0xe4, 0x8c, 0xa9, 0xca, 0x82, 0x18, 0x21, 0x3a, 0x03, 0xe7, 0x31, 0x1d, 0xa9,
	0xd5, 0x2f, 0x01, 0xc4, 0xca, 0x84, 0x94, 0x53, 0x4a, 0x00, 0xf5, 0xe8, 0x53, 0x36, 0x16, 0x13,
	0x56, 0x6d, 0xf1, 0x4d, 0x4c, 0x28, 0x1e, 0x7a, 0xbe, 0x4a, 0x5c, 0xfc, 0x14, 0x18, 0xe7, 0x52,
	0xe4, 0x28, 0x62, 0x9c, 0x4b, 0x94, 0xd6, 0xe3, 0x0e, 0xe3, 0xa2, 0x79, 0x59, 0xb4, 0x25, 0x80,
	0x7c, 0x1d, 0x7f, 0x20, 0xba, 0x95, 0x45, 0x1b, 0x3f, 0xad, 0x9f, 0xc0, 0x9a, 0xf6, 0xd7, 0xf5,
	0x3c, 0x4c, 0xbe, 0x03, 0x8b, 0xc2, 0x48, 0x55, 0xc2, 0x37, 0x24, 0x43, 0xc2, 0x7a, 0x5b, 0xd2,
	0xad, 0xa7, 0x50, 0x93, 0x5b, 0xa0, 0x6a, 0x9a, 0xae, 0x5b, 0xcd, 0x3f, 0x85, 0x95, 0x3e, 0xf3,
	0x86, 0x43, 0xca, 0x5e, 0xdc, 0x3c, 0xd8, 0x29, 0x56, 0xeb, 0x3e, 0x6c, 0xcd, 0x4d, 0xa9, 0x8c,
	0x7a, 0x0f, 0x96, 0x14, 0x4a, 0x4d, 0xbb, 0x2e, 0xc5, 0x49, 0x51, 0x07, 0xc1, 0xd0, 0xd6, 0x74,
	0xeb, 0x23, 0xd8, 0xc4, 0x9e, 0x46, 0x77, 0x7a, 0xd7, 0x5d, 0xad, 0x4d, 0xa8, 0xa5, 0x87, 0xdd,
	0x7c, 0x66, 0x1b, 0xc8, 0x43, 0xea, 0x0c, 0x6e, 0xe8, 0xae, 0x37, 0xa0, 0xaa, 0x46, 0xec, 0x0f,
	0xd4, 0x8a, 0x8a, 0x11, 0xd6, 0x97, 0xb0, 0x99, 0x92, 0x79, 0x73, 0xad, 0x7e, 0x0e, 0x9b, 0x3d,
	0x1e, 0xb0, 0x9b, 0x46, 0x31, 0x31, 0x43, 0xe1, 0x05, 0x33, 0x0c, 0xa1, 0x96, 0x9e, 0xe1, 0x85,
	0x5d, 0xc4, 0x47, 0xb0, 0xda, 0x65, 0x53, 0x9f, 0x46, 0x2d, 0x7a, 0xe1, 0x4e, 0x31, 0x6f, 0x8a,
	0x34, 0x97, 0x35, 0x82, 0x5a, 0x0a, 0xa1, 0x6d, 0xb9, 0x0b, 0x70, 0xe2, 0x7b, 0x4f, 0xa7, 0xf4,
	0x0a, 0x8b, 0x12, 0x54, 0xb2, 0x0d, 0xeb, 0xcd, 0xd1, 0x48, 0x36, 0x0a, 0xe2, 0x84, 0xa3, 0xfb,
	0xc8, 0x79, 0xb4, 0x65, 0xc3, 0xd6, 0xdc, 0x6c, 0xca, 0xae, 0x4f, 0x61, 0x5d, 0x31, 0x46, 0xfa,
	0x1b, 0xf9, 0xfa, 0xcf, 0xf3, 0x59, 0xff, 0x2a, 0x82, 0xa9, 0x00, 0xcf, 0x1f, 0x76, 0x83, 0x91,
	0xe7, 0xce, 0x72, 0x5b, 0x0e, 0x02, 0x25, 0x51, 0x7c, 0xe4, 0x82, 0x10, 0xdf, 0xf3, 0x7b, 0x6f,
	0x31, 0xbb, 0xf7, 0x7e, 0x1f, 0x6e, 0xe9, 0xa9, 0xb0, 0xd3, 0xee, 0x05, 0x53, 0xe6, 0x52, 0x21,
	0x47, 0xd6, 0x9f, 0x2b, 0xa8, 0xe4, 0x33, 0xa8, 0x67, 0x29, 0xf7, 0xa7, 0xee, 0x13, 0x75, 0xce,
	0xa9, 0xda, 0x57, 0xd2, 0xf1, 0xb4, 0x75, 0xe8, 0x5c, 0xf6, 0x03, 0xee, 0x8c, 0x44, 0x15, 0x96,
	0x45, 0x2c, 0x85, 0xc3, 0xde, 0xfd, 0xd0, 0xb9, 0xc4, 0xcf, 0x2e, 0x65, 0x7b, 0xde, 0x88, 0x8a,
	0xb2, 0x56, 0xb4, 0xe7, 0xb0, 0xa8, 0xff, 0xfe, 0xd0, 0x0f, 0x18, 0x45, 0x28, 0x7c, 0x20, 0x4a,
	0x01, 0xeb, 0x9f, 0x3b, 0xbe, 0x28, 0x79, 0x45, 0xfb, 0x0a, 0x2a, 0xf9, 0x02, 0x96, 0x1f, 0x51,
	0x3a, 0xe9, 0x52, 0xe6, 0x05, 0x83, 0xb0, 0x5e, 0x15, 0xd1, 0x68, 0xc8, 0x68, 0xc4, 0xee, 0x8e,
	0x59, 0xec, 0x24, 0x3b, 0x39, 0x81, 0x4d, 0x8c, 0xb8, 0x8a, 0x55, 0x8f, 0x33, 0x87, 0xd3, 0xe1,
	0xac, 0x0e, 0xe2, 0x10, 0xf7, 0xf6, 0xbc, 0x94, 0x1c, 0x56, 0x3b, 0x6f, 0xbc, 0xf5, 0x53, 0xa8,
	0xe5, 0xcd, 0x4d, 0xde, 0x81, 0xd5, 0x7d, 0x9f, 0x53, 0x76, 0xe1, 0x8c, 0x64, 0x89, 0x97, 0x71,
	0x4f, 0x23, 0xb1, 0x2c, 0x1c, 0x3a, 0x97, 0x47, 0xd3, 0xf1, 0x63, 0xca, 0xd4, 0x96, 0x12, 0x23,
	0xac, 0x67, 0x45, 0x99, 0xbe, 0x57, 0xad, 0x9d, 0xae, 0xc3, 0xcf, 0xf5, 0xda, 0xc1, 0x6f, 0x62,
	0x41, 0x49, 0x9c, 0x4c, 0x8b, 0xb9, 0x27, 0x53, 0x41, 0x8b, 0xf6, 0x51, 0xd9, 0x89, 0xca, 0x7d,
	0xb4, 0x06, 0x8b, 0x87, 0x7d, 0x6f, 0x4c, 0xd5, 0x6e, 0x25, 0x01, 0xe4, 0x3c, 0xc4, 0x54, 0x2b,
	0xcb, 0xdd, 0xf5, 0x50, 0x69, 0xd2, 0xe1, 0xce, 0x50, 0x44, 0xb6, 0x6a, 0x8b, 0x6f, 0x2c, 0x22,
	0xfa, 0x84, 0x5d, 0xcd, 0xcf, 0x10, 0x4d, 0x27, 0x1f, 0x43, 0xf5, 0x90, 0x72, 0x47, 0x14, 0x92,
	0x7a, 0x45, 0x30, 0xbf, 0x16, 0x6b, 0xb9, 0x13, 0xd1, 0x3a, 0x3e, 0x67, 0x33, 0x3b, 0xe6, 0x25,
	0x9f, 0x42, 0xb5, 0x39, 0x99, 0x50, 0x87, 0x85, 0xfb, 0x7e, 0x1d, 0xc4, 0xc0, 0xd7, 0xe5, 0xc0,
	0xd3, 0x80, 0x3d, 0x09, 0x27, 0x8e, 0x4b, 0x6d, 0x3a, 0x72, 0xb8, 0x77, 0x41, 0xd1, 0x13, 0x76,
	0xcc, 0xdd, 0xf8, 0x02, 0xd6, 0xd2, 0x72, 0x71, 0x83, 0x7d, 0x42, 0x67, 0xca, 0x9b, 0xf8, 0x89,
	0x0e, 0xb8, 0x70, 0x46, 0x53, 0x9d, 0x89, 0x12, 0xf8, 0xac, 0xf0, 0x89, 0x61, 0xfd, 0xce, 0x80,
	0xad, 0xdc, 0x29, 0xb0, 0x05, 0x3e, 0x0d, 0x13, 0x61, 0x51, 0x10, 0x16, 0xc4, 0xd3, 0x30, 0xd9,
	0x3a, 0x68, 0x30, 0x0a, 0x59, 0x31, 0x11, 0x32, 0x21, 0xa5, 0x37, 0x9a, 0x0e, 0x55, 0xf2, 0x2a,
	0x48, 0x4a, 0xe9, 0xb9, 0xc1, 0x84, 0xaa, 0xdc, 0xd4, 0xa0, 0xf5, 0x6f, 0x03, 0xaa, 0x91, 0x6b,
	0x5f, 0xf2, 0x24, 0x13, 0x05, 0xbc, 0x38, 0x17, 0xf0, 0xcc, 0xd2, 0x20, 0xf2, 0x38, 0x2f, 0x94,
	0x58, 0xb1, 0xc5, 0x37, 0xae, 0xda, 0xe3, 0x6f, 0x7c, 0xca, 0xc4, 0xc4, 0x65, 0xb9, 0x99, 0x45,
	0x08, 0xf2, 0x5d, 0x58, 0x94, 0x2d, 0xc1, 0xd2, 0xf3, 0x5a, 0x02, 0xc9, 0x83, 0x47, 0xaa, 0x83,
	0xc0, 0x15, 0xed, 0xa8, 0xc8, 0xfe, 0xb9, 0x23, 0x95, 0xa6, 0x59, 0xcf, 0x4a, 0xaa, 0x43, 0x44,
	0xd5, 0xd1, 0x71, 0x61, 0x7d, 0xf5, 0x4e, 0x11, 0x43, 0x25, 0x00, 0xf2, 0x16, 0x00, 0x7e, 0x74,
	0x19, 0x3d, 0xf3, 0x2e, 0x45, 0xa1, 0xae, 0xda, 0x09, 0x0c, 0xba, 0xf3, 0xd0, 0xf3, 0xa3, 0x06,
	0xb2, 0x68, 0x6b, 0x50, 0x50, 0x64, 0x7d, 0x52, 0xce, 0xd0, 0xa0, 0x1a, 0xd3, 0x76, 0xb8, 0xf6,
	0x88, 0x06, 0xd5, 0x18, 0x41, 0x59, 0x8c, 0xc6, 0x08, 0x8a, 0x05, 0x2b, 0xed, 0xa9, 0x3c, 0x67,
	0x09, 0xb2, 0x29, 0xbc, 0x93, 0xc2, 0x45, 0x59, 0x5a, 0x7e, 0x4e, 0x96, 0x36, 0xa0, 0x82, 0xf5,
	0x4f, 0x54, 0x75, 0x99, 0x6b, 0x11, 0x8c, 0xb3, 0xb7, 0x02, 0x9f, 0xa3, 0x8b, 0x2b, 0x72, 0x69,
	0x28, 0x10, 0x8f, 0xd8, 0x9a, 0xeb, 0x98, 0x69, 0x9e, 0x0d, 0x79, 0xc4, 0xce, 0x10, 0xd0, 0x67,
	0x7b, 0x8c, 0xd2, 0x1e, 0x67, 0x9e, 0x3f, 0xac, 0x57, 0x05, 0x5b, 0x02, 0x83, 0x61, 0x16, 0x77,
	0x8a, 0xa2, 0x3d, 0x00, 0x19, 0xe6, 0x08, 0x41, 0xee, 0x42, 0xe5, 0x01, 0x0d, 0x64, 0xd7, 0xbe,
	0x2c, 0x22, 0xa7, 0x2c, 0xd1, 0x58, 0x3b, 0xa2, 0xa3, 0x24, 0x8c, 0x45, 0x9b, 0x4e, 0xf8, 0x79,
	0x7d, 0x45, 0x96, 0xb9, 0x08, 0x81, 0x11, 0x3d, 0x39, 0xd9, 0x6f, 0x87, 0xf5, 0x75, 0x19, 0x51,
	0x01, 0x60, 0x92, 0x1e, 0x05, 0xbc, 0xbe, 0x26, 0xb6, 0x6d, 0xfc, 0xb4, 0xfe, 0x62, 0xc4, 0x53,
	0x92, 0x77, 0xa1, 0xdc, 0xa2, 0x58, 0x4b, 0x55, 0x27, 0x10, 0x4f, 0xde, 0x0d, 0x3c, 0x9f, 0xdb,
	0x8a, 0x8a, 0x8e, 0x6c, 0x7b, 0x21, 0x77, 0x7c, 0x57, 0x27, 0x77, 0x04, 0x93, 0x6d, 0x58, 0xea,
	0x07, 0x93, 0x03, 0x7a, 0xc6, 0xd5, 0x71, 0x7e, 0x5e, 0x88, 0x26, 0x93, 0x0f, 0x60, 0xf9, 0x7e,
	0xc0, 0x79, 0x30, 0xb6, 0xbd, 0xe1, 0xb9, 0x3c, 0xc5, 0x67, 0xb9, 0x93, 0x2c, 0xd6, 0x8e, 0xd0,
	0x55, 0x10, 0xd0, 0x94, 0x03, 0x47, 0xee, 0x00, 0x86, 0x8d, 0x9f, 0x02, 0xa3, 0x32, 0x13, 0x31,
	0xe2, 0xec, 0x55, 0x93, 0x97, 0x7d, 0x32, 0x49, 0xa2, 0xae, 0xa7, 0x21, 0xef, 0x1c, 0x44, 0xdd,
	0x90, 0x39, 0x1e, 0xc1, 0xd6, 0xdf, 0x8a, 0x99, 0x4b, 0x3c, 0x72, 0x4f, 0x2d, 0x2e, 0x43, 0x2c,
	0xae, 0xff, 0xcb, 0x4d, 0xbe, 0x1d, 0xf1, 0x9b, 0x58, 0x6d, 0x16, 0x94, 0xe5, 0x6e, 0x9f, 0x73,
	0xe3, 0xa3, 0x28, 0xc8, 0xd3, 0x77, 0xd8, 0x90, 0xf2, 0x9c, 0xab, 0x0f, 0x45, 0x21, 0x3f, 0x84,
	0x0a, 0x96, 0xda, 0x01, 0x16, 0x8c, 0xb2, 0x28, 0xd2, 0x6f, 0xe7, 0x2b, 0xa0, 0xb9, 0x64, 0x9d,
	0x8f, 0x06, 0x5d, 0x75, 0x81, 0x85, 0x4b, 0xf5, 0x78, 0xc2, 0xbd, 0xb1, 0x17, 0x72, 0xcf, 0x15,
	0x39, 0x57, 0xb1, 0x13, 0x98, 0xc6, 0xe7, 0xb0, 0x9a, 0x12, 0x79, 0xa3, 0x12, 0x3f, 0x83, 0x6a,
	0xe4, 0x10, 0x02, 0x50, 0x6e, 0xd9, 0x9d, 0x66, 0xbf, 0x63, 0x2e, 0x90, 0x0a, 0x94, 0xec, 0x4e,
	0xb3, 0x6d, 0x1a, 0x64, 0x1d, 0x96, 0x4f, 0xba, 0xed, 0x66, 0xbf, 0xf3, 0x75, 0xb7, 0xd9, 0x7f,
	0x68, 0x16, 0x08, 0x81, 0x35, 0x85, 0x68, 0x1d, 0x1f, 0xf5, 0x3b, 0x47, 0x7d, 0xb3, 0x98, 0x60,
	0x3a, 0xec, 0xf4, 0x9b, 0x66, 0x89, 0xd4, 0xc0, 0x54, 0x88, 0x93, 0x5e, 0xc7, 0x96, 0xd8, 0x32,
	0xce, 0xd0, 0xee, 0x1c, 0x74, 0xfa, 0x1d, 0x73, 0xd1, 0xfa, 0xb3, 0x01, 0x20, 0x0e, 0xe4, 0x32,
	0x78, 0xef, 0xc0, 0xaa, 0xb8, 0x44, 0x6d, 0x53, 0x2e, 0xae, 0x87, 0x54, 0x47, 0x9d, 0x46, 0x62,
	0x9f, 0x35, 0xd7, 0xf7, 0x49, 0x93, 0xe6, 0xb0, 0x22, 0x7f, 0x71, 0x60, 0x62, 0xcf, 0x89, 0x11,
	0x58, 0x2b, 0xd4, 0xb9, 0x7f, 0x2f, 0x60, 0x2e, 0x15, 0x77, 0x08, 0x6a, 0x0f, 0xca, 0x12, 0xac,
	0x67, 0x06, 0xdc, 0x7e, 0x40, 0x79, 0xc7, 0x77, 0xd9, 0x4c, 0x6c, 0x21, 0x8f, 0xe8, 0x4c, 0x2f,
	0x51, 0xdc, 0x82, 0x42, 0x95, 0x88, 0xb8, 0x05, 0x85, 0x32, 0xed, 0xba, 0x4e, 0x18, 0x7e, 0x13,
	0x30, 0x7d, 0xdc, 0x89, 0xe0, 0xe8, 0x50, 0x52, 0xbc, 0xe2, 0x50, 0x72, 0x0b, 0xca, 0xf2, 0x7c,
	0xa8, 0x02, 0xad, 0x20, 0xeb, 0x7d, 0xa8, 0x67, 0x55, 0x50, 0xdd, 0xba, 0x09, 0xc5, 0x47, 0x2a,
	0xde, 0x2b, 0x36, 0x7e, 0x5a, 0xbf, 0x2e, 0x00, 0xf4, 0x66, 0xbe, 0x2b, 0x97, 0x1d, 0x32, 0x84,
	0xf4, 0xa9, 0x60, 0x28, 0xd9, 0xf8, 0x49, 0x6e, 0x43, 0xd9, 0x0f, 0x06, 0x34, 0x3a, 0x8f, 0x2d,
	0x21, 0xf4, 0xb5, 0x37, 0x20, 0xef, 0x41, 0x89, 0xc7, 0x5d, 0x94, 0xda, 0xbf, 0x62, 0x51, 0x3b,
	0x32, 0x71, 0x90, 0x05, 0x55, 0x0d, 0x65, 0xe2, 0xa8, 0xdd, 0x5b, 0x42, 0x88, 0xe7, 0x32, 0x59,
	0xe4, 0xe6, 0xad, 0x20, 0xb2, 0x0d, 0x25, 0x5f, 0xb7, 0x54, 0xcb, 0xbb, 0xb5, 0x79, 0xd1, 0xd2,
	0x09, 0xc8, 0x61, 0xdd, 0x97, 0x79, 0x4c, 0x96, 0x61, 0x69, 0xea, 0x3f, 0xf1, 0x83, 0x6f, 0x7c,
	0x73, 0x01, 0x97, 0x8e, 0x2b, 0x7c, 0x61, 0x1a, 0xf8, 0x3d, 0x10, 0xbd, 0xa8, 0x59, 0xc0, 0x85,
	0x3a, 0x71, 0xf8, 0xb9, 0x59, 0x44, 0x76, 0x57, 0x96, 0x77, 0xb3, 0x84, 0xab, 0x6b, 0x2d, 0x2d,
	0x1c, 0xe3, 0xf2, 0x78, 0xc6, 0x69, 0x88, 0xdb, 0x9d, 0x21, 0xb6, 0xae, 0x08, 0x46, 0x17, 0x8d,
	0x07, 0x1f, 0x29, 0x6f, 0xe0, 0x27, 0xe6, 0xcc, 0x98, 0x27, 0xda, 0x04, 0x01, 0x90, 0xd7, 0xa1,
	0x82, 0x2a, 0x8a, 0x65, 0x25, 0xcd, 0xae, 0x0a, 0xd7, 0xa1, 0x0a, 0xe4, 0x1e, 0xd4, 0x18, 0x9d,
	0x04, 0xa1, 0xc7, 0x03, 0x36, 0xdb, 0x1f, 0x50, 0x9f, 0x7b, 0x67, 0x1e, 0x65, 0xca, 0x0f, 0x5b,
	0x31, 0xed, 0x6b, 0x2f, 0x22, 0x5a, 0x2d, 0xd8, 0xea, 0x4e, 0x79, 0xac, 0x6a, 0xf2, 0x70, 0x19,
	0xa6, 0x0f, 0x97, 0x0a, 0x14, 0xca, 0x86, 0xc3, 0x48, 0xd9, 0x70, 0x68, 0xfd, 0x0a, 0x6e, 0xcb,
	0xfb, 0x8d, 0xa4, 0x1c, 0xb9, 0x42, 0xb3, 0xc1, 0xaf, 0xc3, 0xd2, 0xd9, 0xc8, 0xe1, 0x9c, 0xfa,
	0xea, 0x60, 0xa8, 0x41, 0x0c, 0xdd, 0x44, 0x76, 0x11, 0x32, 0x65, 0x14, 0x84, 0x4d, 0xd5, 0xc8,
	0x09, 0x79, 0x8f, 0x3e, 0x3d, 0xf6, 0x47, 0x33, 0xfd, 0xa0, 0x96, 0x40, 0xdd, 0x7d, 0x08, 0x6f,
	0x3e, 0xf7, 0x00, 0x81, 0xc1, 0xc1, 0x13, 0x42, 0x73, 0x34, 0x32, 0x17, 0xc8, 0x0a, 0x54, 0x10,
	0x38, 0x70, 0x42, 0x6e, 0x1a, 0x1a, 0x3a, 0x0a, 0x7c, 0x6a, 0x16, 0xee, 0x7e, 0x08, 0x15, 0xdd,
	0x0f, 0xe0, 0xa0, 0x93, 0xa3, 0x47, 0x47, 0xc7, 0xa7, 0x47, 0xb2, 0x22, 0x1d, 0x74, 0x9a, 0x7b,
	0xa6, 0x41, 0xd6, 0x00, 0x5a, 0xc7, 0x07, 0x07, 0x9d, 0x56, 0x7f, 0xff, 0xf8, 0xc8, 0x2c, 0xec,
	0xfe, 0xd6, 0x80, 0x15, 0x1c, 0xd3, 0x65, 0xc1, 0x85, 0x37, 0xa0, 0x8c, 0x7c, 0x0e, 0x15, 0xfd,
	0xbc, 0x47, 0xd4, 0x1a, 0x9e, 0x7b, 0x93, 0x6c, 0xdc, 0x9a, 0x47, 0x4b, 0xaf, 0x5b, 0x0b, 0xe4,
	0x4b, 0xa8, 0x46, 0x4f, 0x46, 0xe4, 0x56, 0xe6, 0x61, 0x49, 0x0e, 0xbf, 0xea, 0xc1, 0xc9, 0x5a,
	0xf8, 0xc0, 0xd8, 0xfd, 0x19, 0xd4, 0x92, 0xea, 0xe8, 0x87, 0x2c, 0xd2, 0x81, 0x35, 0x3d, 0x9f,
	0xc4, 0xdd, 0x58, 0xb9, 0x6d, 0x43, 0x88, 0xdf, 0x8c, 0xf7, 0x94, 0x30, 0x92, 0xbe, 0x07, 0xab,
	0xa9, 0x5d, 0x94, 0xa8, 0xe3, 0x61, 0xde, 0xd6, 0xda, 0xc8, 0xef, 0x4c, 0x85, 0xf6, 0xff, 0x50,
	0xde, 0xb4, 0xa9, 0x4b, 0xbd, 0x0b, 0xca, 0x48, 0x13, 0x20, 0x7e, 0x29, 0x22, 0xca, 0xf2, 0xcc,
	0xf3, 0x56, 0xa3, 0x9e, 0x25, 0x44, 0x3e, 0x6d, 0x02, 0xc4, 0x8f, 0x30, 0x5a, 0x44, 0xe6, 0xb5,
	0x48, 0x8b, 0xc8, 0xbe, 0xd7, 0x48, 0x11, 0xf1, 0xe3, 0x87, 0x16, 0x91, 0x79, 0x89, 0xd1, 0x22,
	0xb2, 0xef, 0x24, 0xd6, 0xc2, 0xee, 0x7f, 0x0d, 0x20, 0x49, 0xcb, 0x54, 0x10, 0x1e, 0x81, 0x19,
	0x2b, 0xad, 0x70, 0x2f, 0x63, 0x25, 0x06, 0x07, 0x85, 0xc5, 0xea, 0xa7, 0x85, 0xdd, 0xc8, 0x5e,
	0x2d, 0x2c, 0x36, 0x24, 0x2d, 0xec, 0x46, 0x96, 0x8b, 0x65, 0xf3, 0x4f, 0xac, 0x88, 0x72, 0x73,
	0x13, 0xdb, 0x2e, 0x65, 0xa4, 0x0d, 0xcb, 0x89, 0x87, 0x06, 0xa2, 0x24, 0x64, 0x1f, 0x31, 0x1a,
	0xaf, 0xe5, 0x50, 0xa2, 0xc8, 0x3c, 0x80, 0x95, 0xe4, 0xd3, 0x00, 0x51, 0xcc, 0x39, 0x0f, 0x0f,
	0x8d, 0x46, 0x1e, 0x29, 0x29, 0x28, 0x79, 0x9d, 0xaf, 0x05, 0xe5, 0x3c, 0x16, 0x68, 0x41, 0x79,
	0xb7, 0xff, 0xd6, 0xc2, 0xee, 0x57, 0x32, 0xce, 0x62, 0x4d, 0x87, 0x51, 0x55, 0xf8, 0x12, 0xaa,
	0xd1, 0x75, 0xbd, 0x4e, 0xec, 0xf9, 0x3b, 0x7f, 0x9d, 0xd8, 0x99, 0x7b, 0x7d, 0x91, 0x1a, 0x2d,
	0xa8, 0xc8, 0x32, 0x4b, 0x19, 0xf9, 0x18, 0xca, 0xf2, 0x9b, 0x6c, 0x26, 0x2f, 0x98, 0xb5, 0x9c,
	0x5a, 0x1a, 0x99, 0x10, 0xb2, 0x09, 0x1b, 0x22, 0xed, 0xe4, 0x56, 0x85, 0x39, 0x4e, 0xd9, 0x1c,
	0xf2, 0x94, 0x79, 0x9c, 0xb2, 0xdd, 0x67, 0x45, 0x58, 0x45, 0xac, 0xaa, 0xac, 0x94, 0x91, 0x1f,
	0xc1, 0x6a, 0xea, 0xfa, 0x58, 0xe7, 0x78, 0xde, 0x35, 0x76, 0xe3, 0xf5, 0x5c, 0x5a, 0xd2, 0xdb,
	0xc9, 0x4b, 0x4d, 0xed, 0xed, 0x9c, 0xab, 0xd4, 0x46, 0x23, 0x8f, 0x14, 0x09, 0xda, 0x87, 0x95,
	0xe4, 0xc5, 0xb2, 0x16, 0x94, 0x73, 0x47, 0xad, 0x05, 0xe5, 0xdd, 0x43, 0xa3, 0x6f, 0x70, 0x41,
	0x26, 0x2e, 0x83, 0xf5, 0x82, 0xcc, 0xde, 0x39, 0xeb, 0x05, 0x99, 0x73, 0x73, 0x6c, 0x2d, 0xa0,
	0x97, 0x52, 0xf7, 0x9a, 0xda, 0x4b, 0x79, 0x57, 0xab, 0xda, 0x4b, 0xb9, 0x17, 0xa1, 0xd6, 0xc2,
	0x2e, 0x85, 0x35, 0x3c, 0x3d, 0x3e, 0xa2, 0xb3, 0x43, 0xc7, 0x77, 0x86, 0x94, 0x91, 0x1e, 0x98,
	0xf3, 0xad, 0x18, 0x79, 0x53, 0x1f, 0x87, 0x72, 0xbb, 0xc4, 0xc6, 0x5b, 0x57, 0x91, 0xa3, 0x69,
	0x7e, 0x63, 0xc0, 0x72, 0xbc, 0x77, 0x87, 0xe4, 0x13, 0x28, 0x76, 0xa7, 0x9c, 0x98, 0xf3, 0x5d,
	0x52, 0xa4, 0x6e, 0x5e, 0xcb, 0x80, 0x89, 0x4e, 0x7e, 0x10, 0xad, 0xcb, 0x37, 0x93, 0x4b, 0x30,
	0xd3, 0x18, 0x34, 0x32, 0xb2, 0x31, 0x02, 0x8f, 0xcb, 0xe2, 0xcf, 0x3c, 0xf7, 0xfe, 0x17, 0x00,
	0x00, 0xff, 0xff, 0xcd, 0xff, 0x06, 0x6d, 0xda, 0x23, 0x00, 0x00,
}
