var languages = {};
module.exports = languages;
languages["ar"] = {"welcome.stepLabel":{"other":"Terms of Use"},"welcome.title":{"other":"Welcome to Pydio Cells Installation Wizard"},"welcome.legend":{"other":"This will install all services on the current server. Please agree with the terms of the license below before starting"},"welcome.agreed":{"other":"I agree with the terms"},"database.stepLabel":{"other":"Database Connection"},"database.title":{"other":"Database Configuration"},"database.legend":{"other":"Pydio requires at least one SQL storage for configuration and data indexation. Configure here the connection to your MySQL/MariaDB server."},"database.legend.bold":{"other":"Please make sure that your database is running MySQL version 5.6 or higher"},"database.installDetected":{"other":"There seem to be a Cells installation already setup in this database. Please confirm to continue or "},"database.installDetected.retry":{"other":"retry with new value"},"database.useDefaultsSet":{"other":"A default database is already configured, just click next to validate connection."},"database.forceConfigure":{"other":"Configure another database."},"admin.stepLabel":{"other":"Admin User"},"admin.title":{"other":"Admin user and frontend defaults"},"admin.legend":{"other":"Provide credentials for the administrative user. Leave fields empty if you are deploying on top of an existing installation."},"admin.adminFound":{"other":"An administrative user was already found in the DB. Check if you wish to create a new one."},"advanced.stepLabel":{"other":"Advanced Settings"},"advanced.title":{"other":"Advanced Settings (optional)"},"advanced.legend":{"other":"Pydio Cells services will be deployed on this machine. You may review some advanced settings below for fine-tuning your configuration."},"advanced.toggle":{"other":"Show Advanced Settings"},"advanced.default.datasource":{"other":"A default data source to store users personal data and cells data is created at startup. You can create other datasources later on."},"license.stepLabel":{"other":"Enterprise License"},"license.title":{"other":"Pydio Cells Enterprise License"},"license.success":{"other":"License file was successfully detected."},"license.details":{"other":"This installation is valid for %count users until %expiration."},"license.failed":{"other":"Error while trying to verify this license key. Please contact the support."},"license.required":{"other":"A valid license key is required to run the Enterprise Distribution. To get a 30 days trial license or a sales quotation, please contact"},"license.fieldLabel":{"other":"License String"},"license.fieldLegend":{"other":"Please copy/paste the license key provided to you."},"apply.stepLabel":{"other":"Apply Installation"},"apply.title":{"other":"Please wait while installation Pydio Cells..."},"apply.success":{"other":"Install was successful and services are now starting, this installer will reload the page when services are started."},"apply.success.restarted":{"other":"Install was successful and services are now started, please reload the page now (it will be automatically reloaded in %1s)"},"apply.error":{"other":"There was an error while performing installation! Please check your configuration."},"apply.error.detail":{"other":"Error was: "},"form.dbConnectionType.label":{"other":"Connection Type"},"form.dbConnectionType.tcp":{"other":"TCP"},"form.dbConnectionType.socket":{"other":"Socket"},"form.dbConnectionType.manual":{"other":"Manual"},"form.dbTCPHostname.label":{"other":"Host Name"},"form.dbTCPHostname.legend":{"other":"Server where mysql is running"},"form.dbName.label":{"other":"Database Name"},"form.dbName.legend":{"other":"Database to use (will be created if it does not exist)"},"form.dbTCPPort.label":{"other":"Port"},"form.dbTCPPort.legend":{"other":"Port to connect to mysql"},"form.dbUser.label":{"other":"Database User"},"form.dbUser.legend":{"other":"Leave blank if not required"},"form.dbPassword.label":{"other":"Database Password"},"form.dbPassword.legend":{"other":"Leave blank if not required"},"form.dbSocketFile.label":{"other":"Socket"},"form.dbSocketFile.legend":{"other":"Enter the location of the socket file to use to connect"},"form.dbManualDSN.label":{"other":"DSN"},"form.dbManualDSN.legend":{"other":"Use Golang-style DSN to describe the database connection"},"form.frontendApplicationTitle.label":{"other":"Application Title"},"form.frontendApplicationTitle.legend":{"other":"Main title of your installation"},"form.frontendDefaultLanguage.label":{"other":"Default Language"},"form.frontendLogin.label":{"other":"Admin user login *"},"form.frontendLogin.legend":{"other":"Identifier used to log in"},"form.frontendPassword.label":{"other":"Admin password *"},"form.frontendPassword.legend":{"other":"Password used to log in"},"form.frontendRepeatPassword.label":{"other":"Confirm password"},"form.frontendRepeatPassword.legend":{"other":"Confirm password twice"},"form.dsFolder.label":{"other":"Path of the default datasource"},"form.dsFolder.legend":{"other":"Use an absolute path on the server"},"form.dsType.FS":{"other":"Local FS (store all data on this server)"},"form.dsType.S3":{"other":"Amazon S3 / S3-compatible (store inside S3 buckets)"},"form.dsS3Custom.label":{"other":"S3-Compatible storage endpoint"},"form.dsS3Custom.legend":{"other":"Leave empty for Amazon"},"form.dsS3CustomRegion.label":{"other":"S3 Custom region"},"form.dsS3CustomRegion.legend":{"other":"Leave empty for default (us-east-1)"},"form.dsS3ApiKey.label":{"other":"S3 Api Key"},"form.dsS3ApiKey.legend":{"other":"Key to connect to S3"},"form.dsS3ApiSecret.label":{"other":"S3 Api Secret"},"form.dsS3ApiSecret.legend":{"other":"Secret Key"},"form.dsS3ValidateKeys":{"other":"Connect to S3 to define buckets"},"form.s3BucketsPrefix.label":{"other":"Buckets prefix"},"form.s3BucketsPrefix.legend":{"other":"A unique prefix for creating the 6 default buckets"},"form.bucketList.found":{"other":"Following bucket(s) already exist"},"form.bucketList.toCreate":{"other":"Following bucket(s) will be created"},"form.bucketList.notFound":{"other":"Following buckets were not found"},"form.bucketList.warnCreate":{"other":"You are not allowed to create buckets, make sure to create them manually!"},"stepper.button.next":{"other":"Next"},"stepper.button.back":{"other":"Back"},"stepper.button.last":{"other":"Install Now"},"stepper.button.reload":{"other":"Reload"}};
languages["de"] = {"welcome.stepLabel":{"other":"Allgemeine Geschäftsbedingungen"},"welcome.title":{"other":"Willkommen zum Pydio Cells Installation Wizard"},"welcome.legend":{"other":"Dies wird alle Dienste auf dem Ihrem Server installieren. Bitte stimmen Sie den Bedingungen der folgenden Lizenz zu, bevor Sie beginnen"},"welcome.agreed":{"other":"Ich stimme diesen Bedingungen zu"},"database.stepLabel":{"other":"Datenbankverbindung"},"database.title":{"other":"Datenbankeinstellungen"},"database.legend":{"other":"Pydio benötigt mindestens einen SQL-Speicher für Konfiguration und Datenindexierung. Konfigurieren Sie hier die Verbindung zu Ihrem MySQL/MariaDB-Server."},"database.legend.bold":{"other":"Bitte stellen Sie sicher, dass Ihre Datenbank MySQL Version 5.6 oder höher läuft"},"database.installDetected":{"other":"In dieser Datenbank scheint eine Installation der Zellen bereits eingerichtet zu sein. Bitte bestätigen Sie das Fortfahren oder "},"database.installDetected.retry":{"other":"mit neuem Wert erneut versuchen"},"database.useDefaultsSet":{"other":"Eine Standarddatenbank ist bereits konfiguriert. Klicken Sie einfach auf Weiter, um die Verbindung zu überprüfen."},"database.forceConfigure":{"other":"Konfigurieren Sie eine andere Datenbank."},"admin.stepLabel":{"other":"Admin-Benutzer"},"admin.title":{"other":"Standardeinstellungen für Administratorbenutzer und Frontend"},"admin.legend":{"other":"Geben Sie Anmeldeinformationen für den Administrator ein. Lassen Sie die Felder leer, wenn Sie über einer vorhandenen Installation bereitstellen."},"admin.adminFound":{"other":"Ein administrativer Benutzer wurde bereits in der Datenbank gefunden. Überprüfen Sie, ob Sie einen neuen erstellen möchten."},"advanced.stepLabel":{"other":"Erweiterte Einstellungen"},"advanced.title":{"other":"Erweiterte Einstellungen (optional)"},"advanced.legend":{"other":"Pydio Cells wird auf diesem Computer bereitgestellt. Sie können einige erweiterte Einstellungen unten überprüfen, um Ihre Konfiguration zu optimieren."},"advanced.toggle":{"other":"Erweiterte Einstellungen anzeigen"},"advanced.default.datasource":{"other":"Beim Start wird eine Standarddatenquelle zum Speichern persönlicher Daten und Zellendaten des Benutzers erstellt. Sie können später weitere Datenquellen erstellen."},"license.stepLabel":{"other":"Enterprise-Lizenz"},"license.title":{"other":"Pydio Cells Enterprise-Lizenz"},"license.success":{"other":"Lizenzdatei wurde erfolgreich erkannt."},"license.details":{"other":"Diese Installation gilt für %count Benutzer bis zum Ablauf am %expiration."},"license.failed":{"other":"Fehler beim Versuch, diesen Lizenzschlüssel zu überprüfen. Bitte wenden Sie sich an den Support."},"license.required":{"other":"Zum Ausführen der Enterprise Distribution ist ein gültiger Lizenzschlüssel erforderlich. Um eine 30-Tage-Testlizenz oder ein Angebot zu erhalten, wenden Sie sich bitte an"},"license.fieldLabel":{"other":"Lizenzzeichenfolge"},"license.fieldLegend":{"other":"Bitte kopieren Sie den Ihnen zur Verfügung gestellten Lizenzschlüssel."},"apply.stepLabel":{"other":"Installation anwenden"},"apply.title":{"other":"Bitte warten Sie während der Installation Pydio Cells ..."},"apply.success":{"other":"Die Installation war erfolgreich und die Dienste werden jetzt gestartet. Dieses Installationsprogramm lädt die Seite neu, wenn die Dienste gestartet werden."},"apply.success.restarted":{"other":"Die Installation war erfolgreich und die Dienste werden jetzt gestartet. Bitte laden Sie die Seite jetzt neu (sie wird in %1s automatisch neu geladen.)"},"apply.error":{"other":"Bei der Installation ist ein Fehler aufgetreten! Bitte überprüfen Sie Ihre Konfiguration."},"apply.error.detail":{"other":"Fehler war: "},"form.dbConnectionType.label":{"other":"Verbindungstyp"},"form.dbConnectionType.tcp":{"other":"TCP"},"form.dbConnectionType.socket":{"other":"Socket"},"form.dbConnectionType.manual":{"other":"Manuell"},"form.dbTCPHostname.label":{"other":"Hostname"},"form.dbTCPHostname.legend":{"other":"auf dem MySQL läuft"},"form.dbName.label":{"other":"Name der Datenbank"},"form.dbName.legend":{"other":"Zu verwendende DB (wird erstellt, wenn sie nicht vorhanden ist)"},"form.dbTCPPort.label":{"other":"Port"},"form.dbTCPPort.legend":{"other":"Port zum Verbinden mit MySQL"},"form.dbUser.label":{"other":"Datenbank-User"},"form.dbUser.legend":{"other":"Leer lassen, falls nicht benötigt"},"form.dbPassword.label":{"other":"Datenbank Passwort"},"form.dbPassword.legend":{"other":"Leer lassen, falls nicht benötigt"},"form.dbSocketFile.label":{"other":"Socket"},"form.dbSocketFile.legend":{"other":"Geben Sie den Speicherort der Socket-Datei ein, über die eine Verbindung hergestellt werden soll"},"form.dbManualDSN.label":{"other":"DSN"},"form.dbManualDSN.legend":{"other":"Verwenden Sie DSN im Golang-Stil, um die Datenbankverbindung zu beschreiben"},"form.frontendApplicationTitle.label":{"other":"Titel der Anwendung"},"form.frontendApplicationTitle.legend":{"other":"Haupttitel Ihrer Installation"},"form.frontendDefaultLanguage.label":{"other":"Standardsprache"},"form.frontendLogin.label":{"other":"Administrator-Login *"},"form.frontendLogin.legend":{"other":"Kennung zur Anmeldung"},"form.frontendPassword.label":{"other":"Administrator-Passwort *"},"form.frontendPassword.legend":{"other":"Passwort zum Anmelden"},"form.frontendRepeatPassword.label":{"other":"Bestätige das Passwort"},"form.frontendRepeatPassword.legend":{"other":"Passwort wiederholen"},"form.dsFolder.label":{"other":"Pfad der Standarddatenquelle"},"form.dsFolder.legend":{"other":"Verwenden Sie einen absoluten Pfad auf dem Server"},"form.dsType.FS":{"other":"Lokaler FS (alle Daten auf diesem Server speichern)"},"form.dsType.S3":{"other":"Amazon S3 / S3-kompatibel (in S3-Buckets speichern)"},"form.dsS3Custom.label":{"other":"S3-kompatibler Speicher-Endpunkt"},"form.dsS3Custom.legend":{"other":"Für Amazon leer lassen"},"form.dsS3CustomRegion.label":{"other":"S3 Benutzerdefinierte Region"},"form.dsS3CustomRegion.legend":{"other":"Leer lassen für Standard (us-east-1)"},"form.dsS3ApiKey.label":{"other":"S3 API-Schlüssel"},"form.dsS3ApiKey.legend":{"other":"Schlüssel zum Verbinden"},"form.dsS3ApiSecret.label":{"other":"S3 Api Secret"},"form.dsS3ApiSecret.legend":{"other":"Geheimschlüssel"},"form.dsS3ValidateKeys":{"other":"Mit S3 verbinden, um Buckets zu definieren"},"form.s3BucketsPrefix.label":{"other":"Buckets-Präfix"},"form.s3BucketsPrefix.legend":{"other":"Ein eindeutiges Präfix zum Erstellen der 6 Standard-Buckets"},"form.bucketList.found":{"other":"Folgende Bucket(s) sind bereits vorhanden"},"form.bucketList.toCreate":{"other":"Folgende Bucket(s) werden erstellt"},"form.bucketList.notFound":{"other":"Die folgenden Buckets wurden nicht gefunden"},"form.bucketList.warnCreate":{"other":"Sie dürfen keine Buckets erstellen, stellen Sie sicher, dass Sie diese manuell erstellen!"},"stepper.button.next":{"other":"Weiter"},"stepper.button.back":{"other":"Zurück"},"stepper.button.last":{"other":"Jetzt installieren"},"stepper.button.reload":{"other":"Neu laden"}};
languages["en-us"] = {"welcome.stepLabel":{"other":"Terms of Use"},"welcome.title":{"other":"Welcome to Pydio Cells Installation Wizard"},"welcome.legend":{"other":"This will install all services on the current server. Please agree with the terms of the license below before starting"},"welcome.agreed":{"other":"I agree with the terms"},"database.stepLabel":{"other":"Database Connection"},"database.title":{"other":"Database Configuration"},"database.legend":{"other":"Pydio requires at least one SQL storage for configuration and data indexation. Configure here the connection to your MySQL/MariaDB server."},"database.legend.bold":{"other":"Please make sure that your database is running MySQL version 5.6 or higher"},"database.installDetected":{"other":"There seem to be a Cells installation already setup in this database. Please confirm to continue or "},"database.installDetected.retry":{"other":"retry with new value"},"database.useDefaultsSet":{"other":"A default database is already configured, just click next to validate connection."},"database.forceConfigure":{"other":"Configure another database."},"admin.stepLabel":{"other":"Admin User"},"admin.title":{"other":"Admin user and frontend defaults"},"admin.legend":{"other":"Provide credentials for the administrative user. Leave fields empty if you are deploying on top of an existing installation."},"admin.adminFound":{"other":"An administrative user was already found in the DB. Check if you wish to create a new one."},"advanced.stepLabel":{"other":"Advanced Settings"},"advanced.title":{"other":"Advanced Settings (optional)"},"advanced.legend":{"other":"Pydio Cells services will be deployed on this machine. You may review some advanced settings below for fine-tuning your configuration."},"advanced.toggle":{"other":"Show Advanced Settings"},"advanced.default.datasource":{"other":"A default data source to store users personal data and cells data is created at startup. You can create other datasources later on."},"license.stepLabel":{"other":"Enterprise License"},"license.title":{"other":"Pydio Cells Enterprise License"},"license.success":{"other":"License file was successfully detected."},"license.details":{"other":"This installation is valid for %count users until %expiration."},"license.failed":{"other":"Error while trying to verify this license key. Please contact the support."},"license.required":{"other":"A valid license key is required to run the Enterprise Distribution. To get a 30 days trial license or a sales quotation, please contact"},"license.fieldLabel":{"other":"License String"},"license.fieldLegend":{"other":"Please copy/paste the license key provided to you."},"apply.stepLabel":{"other":"Apply Installation"},"apply.title":{"other":"Please wait while installation Pydio Cells..."},"apply.success":{"other":"Install was successful and services are now starting, this installer will reload the page when services are started."},"apply.success.restarted":{"other":"Install was successful and services are now started, please reload the page now (it will be automatically reloaded in %1s)"},"apply.error":{"other":"There was an error while performing installation! Please check your configuration."},"apply.error.detail":{"other":"Error was: "},"form.dbConnectionType.label":{"other":"Connection Type"},"form.dbConnectionType.tcp":{"other":"TCP"},"form.dbConnectionType.socket":{"other":"Socket"},"form.dbConnectionType.manual":{"other":"Manual"},"form.dbTCPHostname.label":{"other":"Host Name"},"form.dbTCPHostname.legend":{"other":"Server where mysql is running"},"form.dbName.label":{"other":"Database Name"},"form.dbName.legend":{"other":"Database to use (will be created if it does not exist)"},"form.dbTCPPort.label":{"other":"Port"},"form.dbTCPPort.legend":{"other":"Port to connect to mysql"},"form.dbUser.label":{"other":"Database User"},"form.dbUser.legend":{"other":"Leave blank if not required"},"form.dbPassword.label":{"other":"Database Password"},"form.dbPassword.legend":{"other":"Leave blank if not required"},"form.dbSocketFile.label":{"other":"Socket"},"form.dbSocketFile.legend":{"other":"Enter the location of the socket file to use to connect"},"form.dbManualDSN.label":{"other":"DSN"},"form.dbManualDSN.legend":{"other":"Use Golang-style DSN to describe the database connection"},"form.frontendApplicationTitle.label":{"other":"Application Title"},"form.frontendApplicationTitle.legend":{"other":"Main title of your installation"},"form.frontendDefaultLanguage.label":{"other":"Default Language"},"form.frontendLogin.label":{"other":"Admin user login *"},"form.frontendLogin.legend":{"other":"Identifier used to log in"},"form.frontendPassword.label":{"other":"Admin password *"},"form.frontendPassword.legend":{"other":"Password used to log in"},"form.frontendRepeatPassword.label":{"other":"Confirm password"},"form.frontendRepeatPassword.legend":{"other":"Confirm password twice"},"form.dsFolder.label":{"other":"Path of the default datasource"},"form.dsFolder.legend":{"other":"Use an absolute path on the server"},"form.dsType.FS":{"other":"Local FS (store all data on this server)"},"form.dsType.S3":{"other":"Amazon S3 / S3-compatible (store inside S3 buckets)"},"form.dsS3Custom.label":{"other":"S3-Compatible storage endpoint"},"form.dsS3Custom.legend":{"other":"Leave empty for Amazon"},"form.dsS3CustomRegion.label":{"other":"S3 Custom region"},"form.dsS3CustomRegion.legend":{"other":"Leave empty for default (us-east-1)"},"form.dsS3ApiKey.label":{"other":"S3 Api Key"},"form.dsS3ApiKey.legend":{"other":"Key to connect to S3"},"form.dsS3ApiSecret.label":{"other":"S3 Api Secret"},"form.dsS3ApiSecret.legend":{"other":"Secret Key"},"form.dsS3ValidateKeys":{"other":"Connect to S3 to define buckets"},"form.s3BucketsPrefix.label":{"other":"Buckets prefix"},"form.s3BucketsPrefix.legend":{"other":"A unique prefix for creating the 6 default buckets"},"form.bucketList.found":{"other":"Following bucket(s) already exist"},"form.bucketList.toCreate":{"other":"Following bucket(s) will be created"},"form.bucketList.notFound":{"other":"Following buckets were not found"},"form.bucketList.warnCreate":{"other":"You are not allowed to create buckets, make sure to create them manually!"},"stepper.button.next":{"other":"Next"},"stepper.button.back":{"other":"Back"},"stepper.button.last":{"other":"Install Now"},"stepper.button.reload":{"other":"Reload"}};
languages["es-es"] = {"welcome.stepLabel":{"other":"Condiciones de Uso"},"welcome.title":{"other":"Bienvenido al Asistente de Anstalación de Pydio Cells"},"welcome.legend":{"other":"Este proceso instalará todos los servicios en el servidor actual. Por favor, acepte abajo las condiciones de la licencia antes de empezar"},"welcome.agreed":{"other":"Acepto las condiciones"},"database.stepLabel":{"other":"Conexión a la Base de Datos"},"database.title":{"other":"Configuración de la Base de Datos"},"database.legend":{"other":"Pydio requiere al menos un almacenamiento SQL para la configuración y la indexación de datos. Configure aquí la conexión a su servidor MySQL/MariaDB."},"database.legend.bold":{"other":"Por favor, asegúrese de que su base de datos está ejecutando MySQL versión 5.6 o superior"},"database.installDetected":{"other":"Parece que ya hay una versión de Cells configurada en esta base de datos. Por favor, confirme para continuar o "},"database.installDetected.retry":{"other":"reintentar con nuevo valor"},"database.useDefaultsSet":{"other":"A default database is already configured, just click next to validate connection."},"database.forceConfigure":{"other":"Configure another database."},"admin.stepLabel":{"other":"Administrador"},"admin.title":{"other":"Configuración de Administrador y frontend por defecto"},"admin.legend":{"other":"Proporcione credenciales para usuario administrador. Deje los campos vacíos si está instalando la aplicación sobre una ya existente."},"admin.adminFound":{"other":"Ya existe un usuario administrador en la Base de Datos. Compruebe si desea crear uno nuevo."},"advanced.stepLabel":{"other":"Configuración avanzada"},"advanced.title":{"other":"Configuración Avanzada (opcional)"},"advanced.legend":{"other":"Los servicios de Pydio Cells se implementarán en esta máquina. Abajo puede revisar algunos parámetros avanzados para ajustar la configuración."},"advanced.toggle":{"other":"Mostrar Configuración Avanzada"},"advanced.default.datasource":{"other":"Al comenzar se crea un datasource por defecto para almacenar los datos personales de los usuarios y datos de Cells. Puede crear otros datasources más adelante."},"license.stepLabel":{"other":"Licencia Enterprise"},"license.title":{"other":"Licencia Enterprise de Pydio Cells"},"license.success":{"other":"El archivo de licencia fue eliminado con éxito."},"license.details":{"other":"Esta instalación es válida para usuarios %count hasta su %expiration."},"license.failed":{"other":"Error al intentar verificar esta clave de licencia. Por favor, póngase en contacto con el servicio de soporte."},"license.required":{"other":"Se requiere una clave de licencia válida para ejecutar la Distribución Enterprise. Para obtener una licencia de prueba de 30 días o un presupuesto, póngase en contacto con nosotros"},"license.fieldLabel":{"other":"Cadena de Licencia"},"license.fieldLegend":{"other":"Por favor, copie/pegue la clave de licencia que se le ha proporcionado."},"apply.stepLabel":{"other":"Ejecutar la Instalación"},"apply.title":{"other":"Espere mientras se instala Pydio Cells..."},"apply.success":{"other":"La instalación se ha realizado correctamente y los servicios se están iniciando. Este instalador volverá a cargar la página cuando se inicien los servicios."},"apply.success.restarted":{"other":"La instalación se ha realizado correctamente y los servicios se han iniciado, por favor, recargue la página ahora (se volverá a cargar automáticamente en %1s)"},"apply.error":{"other":"¡Ha habido un error mientras se realizaba la instalación! Por favor, compruebe la configuración."},"apply.error.detail":{"other":"El error ha sido: "},"form.dbConnectionType.label":{"other":"Tipo de Conexión"},"form.dbConnectionType.tcp":{"other":"TCP"},"form.dbConnectionType.socket":{"other":"Socket"},"form.dbConnectionType.manual":{"other":"Manual"},"form.dbTCPHostname.label":{"other":"Hostname"},"form.dbTCPHostname.legend":{"other":"Servidor en el que se está ejecutando mySQL"},"form.dbName.label":{"other":"Nombre de la Base de Datos"},"form.dbName.legend":{"other":"Base de Datos a usar (se creará si no existe)"},"form.dbTCPPort.label":{"other":"Puerto"},"form.dbTCPPort.legend":{"other":"Puerto para conectar a mySQL"},"form.dbUser.label":{"other":"Usuario de Base de Datos"},"form.dbUser.legend":{"other":"Dejar en blanco si no se requiere"},"form.dbPassword.label":{"other":"Contraseña de la Base de Datos"},"form.dbPassword.legend":{"other":"Dejar en blanco si no se requiere"},"form.dbSocketFile.label":{"other":"Socket"},"form.dbSocketFile.legend":{"other":"Introduzca la ubicación del archivo socket que se utilizará para conectar"},"form.dbManualDSN.label":{"other":"DSN"},"form.dbManualDSN.legend":{"other":"Use DSN con formato Golang para describir la conexión a la base de datos"},"form.frontendApplicationTitle.label":{"other":"Título de la Aplicación"},"form.frontendApplicationTitle.legend":{"other":"Título principal de la instalación"},"form.frontendDefaultLanguage.label":{"other":"Idioma por Defecto"},"form.frontendLogin.label":{"other":"Login de Administrador *"},"form.frontendLogin.legend":{"other":"Identificador usado para iniciar sesión"},"form.frontendPassword.label":{"other":"Contraseña de Administrador *"},"form.frontendPassword.legend":{"other":"Contraseña usada para iniciar sesión"},"form.frontendRepeatPassword.label":{"other":"Confirmar contraseña"},"form.frontendRepeatPassword.legend":{"other":"Confirmar contraseña dos veces"},"form.dsFolder.label":{"other":"Ruta de la base de datos predeterminada"},"form.dsFolder.legend":{"other":"Usar una ruta absoluta en el servidor"},"form.dsType.FS":{"other":"FS local (almacenar todos los datos en este servidor)"},"form.dsType.S3":{"other":"Amazon S3 / S3-compatible (store inside S3 buckets)"},"form.dsS3Custom.label":{"other":"S3-Compatible storage endpoint"},"form.dsS3Custom.legend":{"other":"Leave empty for Amazon"},"form.dsS3CustomRegion.label":{"other":"S3 Custom region"},"form.dsS3CustomRegion.legend":{"other":"Leave empty for default (us-east-1)"},"form.dsS3ApiKey.label":{"other":"Clave Api S3"},"form.dsS3ApiKey.legend":{"other":"Clave para conectar a S3"},"form.dsS3ApiSecret.label":{"other":"Clave Secreta Api S3"},"form.dsS3ApiSecret.legend":{"other":"Clave Secreta"},"form.dsS3ValidateKeys":{"other":"Conectar a S3 para definir buckets"},"form.s3BucketsPrefix.label":{"other":"Prefijo de los buckets"},"form.s3BucketsPrefix.legend":{"other":"Un prefijo único para crear los 6 buckets por defecto"},"form.bucketList.found":{"other":"Los siguientes buckets ya existen"},"form.bucketList.toCreate":{"other":"Se crearán los siguientes buckets"},"form.bucketList.notFound":{"other":"No se encontraron los siguientes buckets"},"form.bucketList.warnCreate":{"other":"No está autorizado a crear buckets, ¡asegúrese de crearlos manualmente!"},"stepper.button.next":{"other":"Siguiente"},"stepper.button.back":{"other":"Atrás"},"stepper.button.last":{"other":"Instalar ahora"},"stepper.button.reload":{"other":"Recargar"}};
languages["fr-ca"] = {"welcome.stepLabel":{"other":"Terms of Use"},"welcome.title":{"other":"Welcome to Pydio Cells Installation Wizard"},"welcome.legend":{"other":"This will install all services on the current server. Please agree with the terms of the license below before starting"},"welcome.agreed":{"other":"I agree with the terms"},"database.stepLabel":{"other":"Database Connection"},"database.title":{"other":"Database Configuration"},"database.legend":{"other":"Pydio requires at least one SQL storage for configuration and data indexation. Configure here the connection to your MySQL/MariaDB server."},"database.legend.bold":{"other":"Please make sure that your database is running MySQL version 5.6 or higher"},"database.installDetected":{"other":"There seem to be a Cells installation already setup in this database. Please confirm to continue or "},"database.installDetected.retry":{"other":"retry with new value"},"database.useDefaultsSet":{"other":"A default database is already configured, just click next to validate connection."},"database.forceConfigure":{"other":"Configure another database."},"admin.stepLabel":{"other":"Admin User"},"admin.title":{"other":"Admin user and frontend defaults"},"admin.legend":{"other":"Provide credentials for the administrative user. Leave fields empty if you are deploying on top of an existing installation."},"admin.adminFound":{"other":"An administrative user was already found in the DB. Check if you wish to create a new one."},"advanced.stepLabel":{"other":"Advanced Settings"},"advanced.title":{"other":"Advanced Settings (optional)"},"advanced.legend":{"other":"Pydio Cells services will be deployed on this machine. You may review some advanced settings below for fine-tuning your configuration."},"advanced.toggle":{"other":"Show Advanced Settings"},"advanced.default.datasource":{"other":"A default data source to store users personal data and cells data is created at startup. You can create other datasources later on."},"license.stepLabel":{"other":"Enterprise License"},"license.title":{"other":"Pydio Cells Enterprise License"},"license.success":{"other":"License file was successfully detected."},"license.details":{"other":"This installation is valid for %count users until %expiration."},"license.failed":{"other":"Error while trying to verify this license key. Please contact the support."},"license.required":{"other":"A valid license key is required to run the Enterprise Distribution. To get a 30 days trial license or a sales quotation, please contact"},"license.fieldLabel":{"other":"License String"},"license.fieldLegend":{"other":"Please copy/paste the license key provided to you."},"apply.stepLabel":{"other":"Apply Installation"},"apply.title":{"other":"Please wait while installation Pydio Cells..."},"apply.success":{"other":"Install was successful and services are now starting, this installer will reload the page when services are started."},"apply.success.restarted":{"other":"Install was successful and services are now started, please reload the page now (it will be automatically reloaded in %1s)"},"apply.error":{"other":"There was an error while performing installation! Please check your configuration."},"apply.error.detail":{"other":"Error was: "},"form.dbConnectionType.label":{"other":"Connection Type"},"form.dbConnectionType.tcp":{"other":"TCP"},"form.dbConnectionType.socket":{"other":"Socket"},"form.dbConnectionType.manual":{"other":"Manual"},"form.dbTCPHostname.label":{"other":"Host Name"},"form.dbTCPHostname.legend":{"other":"Server where mysql is running"},"form.dbName.label":{"other":"Database Name"},"form.dbName.legend":{"other":"Database to use (will be created if it does not exist)"},"form.dbTCPPort.label":{"other":"Port"},"form.dbTCPPort.legend":{"other":"Port to connect to mysql"},"form.dbUser.label":{"other":"Database User"},"form.dbUser.legend":{"other":"Leave blank if not required"},"form.dbPassword.label":{"other":"Database Password"},"form.dbPassword.legend":{"other":"Leave blank if not required"},"form.dbSocketFile.label":{"other":"Socket"},"form.dbSocketFile.legend":{"other":"Enter the location of the socket file to use to connect"},"form.dbManualDSN.label":{"other":"DSN"},"form.dbManualDSN.legend":{"other":"Use Golang-style DSN to describe the database connection"},"form.frontendApplicationTitle.label":{"other":"Application Title"},"form.frontendApplicationTitle.legend":{"other":"Main title of your installation"},"form.frontendDefaultLanguage.label":{"other":"Default Language"},"form.frontendLogin.label":{"other":"Admin user login *"},"form.frontendLogin.legend":{"other":"Identifier used to log in"},"form.frontendPassword.label":{"other":"Admin password *"},"form.frontendPassword.legend":{"other":"Password used to log in"},"form.frontendRepeatPassword.label":{"other":"Confirm password"},"form.frontendRepeatPassword.legend":{"other":"Confirm password twice"},"form.dsFolder.label":{"other":"Path of the default datasource"},"form.dsFolder.legend":{"other":"Use an absolute path on the server"},"form.dsType.FS":{"other":"Local FS (store all data on this server)"},"form.dsType.S3":{"other":"Amazon S3 / S3-compatible (store inside S3 buckets)"},"form.dsS3Custom.label":{"other":"S3-Compatible storage endpoint"},"form.dsS3Custom.legend":{"other":"Leave empty for Amazon"},"form.dsS3CustomRegion.label":{"other":"S3 Custom region"},"form.dsS3CustomRegion.legend":{"other":"Leave empty for default (us-east-1)"},"form.dsS3ApiKey.label":{"other":"S3 Api Key"},"form.dsS3ApiKey.legend":{"other":"Key to connect to S3"},"form.dsS3ApiSecret.label":{"other":"S3 Api Secret"},"form.dsS3ApiSecret.legend":{"other":"Secret Key"},"form.dsS3ValidateKeys":{"other":"Connect to S3 to define buckets"},"form.s3BucketsPrefix.label":{"other":"Buckets prefix"},"form.s3BucketsPrefix.legend":{"other":"A unique prefix for creating the 6 default buckets"},"form.bucketList.found":{"other":"Following bucket(s) already exist"},"form.bucketList.toCreate":{"other":"Following bucket(s) will be created"},"form.bucketList.notFound":{"other":"Following buckets were not found"},"form.bucketList.warnCreate":{"other":"You are not allowed to create buckets, make sure to create them manually!"},"stepper.button.next":{"other":"Next"},"stepper.button.back":{"other":"Back"},"stepper.button.last":{"other":"Install Now"},"stepper.button.reload":{"other":"Reload"}};
languages["fr"] = {"welcome.stepLabel":{"other":"Conditions d'utilisation"},"welcome.title":{"other":"Bienvenue dans l'assistant d'installation de Pydio Cells"},"welcome.legend":{"other":"Ceci installera tous les services sur votre serveur. Veuillez accepter les conditions de la licence ci-dessous avant de commencer"},"welcome.agreed":{"other":"J'accepte les termes d'utilisation"},"database.stepLabel":{"other":"Connexion à la base de données"},"database.title":{"other":"Configuration de la base de données"},"database.legend":{"other":"Pydio a, au minimum, besoin d'un stockage SQL pour la configuration et l'indexation des données. Configurez ici la connexion à votre serveur MySQL/MariaDB."},"database.legend.bold":{"other":"Veuillez vous assurer que votre base de données utilise MySQL version 5.6 ou supérieure"},"database.installDetected":{"other":"Il semble y avoir une instance de Cells déjà installée dans cette base de données. Veuillez confirmer pour continuer ou "},"database.installDetected.retry":{"other":"réessayer avec une autre base"},"database.useDefaultsSet":{"other":"Une base de données par défaut est déjà configurée, cliquez sur \"Suivant\" pour valider la connexion."},"database.forceConfigure":{"other":"Configurer une autre base de données."},"admin.stepLabel":{"other":"Administrateur"},"admin.title":{"other":"Administrateur et interface par défaut"},"admin.legend":{"other":"Fournissez les informations d'identification à l'utilisateur admin. Laissez les champs vides si vous déployez sur une installation existante."},"admin.adminFound":{"other":"Un utilisateur admin a été trouvé dans la base de données. Cochez la case si vous souhaitez en créer un nouveau."},"advanced.stepLabel":{"other":"Configuration avancée"},"advanced.title":{"other":"Paramètres avancés (optionnel)"},"advanced.legend":{"other":"Les services Pydio Cells seront déployés sur cette machine. Vous pouvez consulter certains paramètres avancés ci-dessous pour affiner votre configuration."},"advanced.toggle":{"other":"Afficher les paramètres avancés"},"advanced.default.datasource":{"other":"Une DataSource par défaut est créée au démarrage pour stocker les données personnelles des utilisateurs et les données des Cells. Vous pourrez créer d'autres DataSource plus tard."},"license.stepLabel":{"other":"Licence Entreprise"},"license.title":{"other":"Licence Pydio Cells Entreprise"},"license.success":{"other":"Le fichier de licence a été correctement détecté."},"license.details":{"other":"Cette installation est valide pour %count utilisateurs jusqu'à %expiration."},"license.failed":{"other":"Erreur lors de la vérification de cette clé de licence. Veuillez contacter le support."},"license.required":{"other":"Une clé de licence valide est requise pour utiliser la distribution Entreprise. Pour obtenir une licence d'essai de 30 jours ou un devis, veuillez contacter"},"license.fieldLabel":{"other":"Licence"},"license.fieldLegend":{"other":"Veuillez copier/coller la clé de licence qui vous a été fournie."},"apply.stepLabel":{"other":"Lancer l'installation"},"apply.title":{"other":"Veuillez patienter pendant l'installation de Pydio Cells..."},"apply.success":{"other":"L'installation a été effectuée avec succès et les services sont en cours de démarrage, l'installateur rechargera la page lorsque les services auront été redémarrés."},"apply.success.restarted":{"other":"L'installation a été effectuée avec succès et les services sont maintenant démarrés. Veuillez recharger la page maintenant (elle sera automatiquement rechargée dans %1s)"},"apply.error":{"other":"Il y a eu une erreur lors de l'installation ! Veuillez vérifier votre configuration."},"apply.error.detail":{"other":"L'erreur était: "},"form.dbConnectionType.label":{"other":"Type de connexion"},"form.dbConnectionType.tcp":{"other":"TCP"},"form.dbConnectionType.socket":{"other":"Socket"},"form.dbConnectionType.manual":{"other":"Manuel"},"form.dbTCPHostname.label":{"other":"Nom de l'hôte"},"form.dbTCPHostname.legend":{"other":"Serveur sur lequel MySQL tourne"},"form.dbName.label":{"other":"Nom de la base de données"},"form.dbName.legend":{"other":"Base de données à utiliser (celle-ci sera créée si elle n'existe pas encore)"},"form.dbTCPPort.label":{"other":"Port"},"form.dbTCPPort.legend":{"other":"Port pour se connecter à MySQL"},"form.dbUser.label":{"other":"Utilisateur de la base de données"},"form.dbUser.legend":{"other":"Laissez vide si non requis"},"form.dbPassword.label":{"other":"Mot de passe de la base"},"form.dbPassword.legend":{"other":"Laissez vide si non requis"},"form.dbSocketFile.label":{"other":"Socket"},"form.dbSocketFile.legend":{"other":"Entrez l'emplacement du fichier de socket à utiliser pour se connecter"},"form.dbManualDSN.label":{"other":"DSN"},"form.dbManualDSN.legend":{"other":"Utiliser un DSN de style Golang pour décrire la connexion à la base de données"},"form.frontendApplicationTitle.label":{"other":"Titre de l'application"},"form.frontendApplicationTitle.legend":{"other":"Titre principal de votre installation"},"form.frontendDefaultLanguage.label":{"other":"Langue par défaut"},"form.frontendLogin.label":{"other":"Identifiant de l'admin *"},"form.frontendLogin.legend":{"other":"Utilisé pour se connecter"},"form.frontendPassword.label":{"other":"Mot de passe admin *"},"form.frontendPassword.legend":{"other":"Mot de passe de connexion"},"form.frontendRepeatPassword.label":{"other":"Confirmer le mot de passe"},"form.frontendRepeatPassword.legend":{"other":"Confirmer le mot de passe"},"form.dsFolder.label":{"other":"Chemin vers la DataSource par défaut"},"form.dsFolder.legend":{"other":"Utiliser un chemin absolu sur le serveur"},"form.dsType.FS":{"other":"Fichiers locaux (stocker les données sur ce serveur)"},"form.dsType.S3":{"other":"Amazon / Compatible S3 (stocker dans des buckets S3)"},"form.dsS3Custom.label":{"other":"URL d'un stockage compatible S3"},"form.dsS3Custom.legend":{"other":"Laissez vide pour AWS"},"form.dsS3CustomRegion.label":{"other":"Région personnalisée"},"form.dsS3CustomRegion.legend":{"other":"Valeur par défaut (us-east-1)"},"form.dsS3ApiKey.label":{"other":"Clé d'API S3"},"form.dsS3ApiKey.legend":{"other":"Clé pour connection à S3"},"form.dsS3ApiSecret.label":{"other":"Clé secrète S3"},"form.dsS3ApiSecret.legend":{"other":"Clé secrète"},"form.dsS3ValidateKeys":{"other":"Connectez-vous à S3 pour définir les buckets à utiliser"},"form.s3BucketsPrefix.label":{"other":"Préfixe des buckets"},"form.s3BucketsPrefix.legend":{"other":"Définir un préfixe unique pour créer les 6 buckets par défaut"},"form.bucketList.found":{"other":"Les buckets suivants existent déjà"},"form.bucketList.toCreate":{"other":"Les buckets suivants seront créés"},"form.bucketList.notFound":{"other":"Les buckets suivants sont introuvables"},"form.bucketList.warnCreate":{"other":"Vous n'êtes pas autorisé à créer des buckets, assurez-vous de les créer manuellement!"},"stepper.button.next":{"other":"Suivant"},"stepper.button.back":{"other":"Précédent"},"stepper.button.last":{"other":"Lancer l'installation"},"stepper.button.reload":{"other":"Recharger"}};
languages["it"] = {"welcome.stepLabel":{"other":"Condizioni d'Uso"},"welcome.title":{"other":"Benvenuto nella procedura guidata di installazione di Pydio Cells"},"welcome.legend":{"other":"Questo installerà tutti i servizi sul server corrente. Si prega di accettare i termini della licenza qui sotto prima di iniziare"},"welcome.agreed":{"other":"Accetto le condizioni"},"database.stepLabel":{"other":"Connessione al Database"},"database.title":{"other":"Configurazione del Database"},"database.legend":{"other":"Pydio richiede almeno uno storage SQL per la configurazione e l'indicizzazione dei dati. Configura qui la connessione al tuo server MySQL/MariaDB."},"database.legend.bold":{"other":"Assicurati che il tuo database utilizzi MySQL versione 5.6 o superiore"},"database.installDetected":{"other":"Sembra ci sia già un'installazione di Cells già configurata in questo database. Si prega di confermare per continuare o "},"database.installDetected.retry":{"other":"riprova con un nuovo valore"},"database.useDefaultsSet":{"other":"A default database is already configured, just click next to validate connection."},"database.forceConfigure":{"other":"Configure another database."},"admin.stepLabel":{"other":"Utente Amministratore"},"admin.title":{"other":"Utente amministratore e valori predefiniti per il frontend"},"admin.legend":{"other":"Fornire le credenziali per l'utente amministratore. Lasciare i campi vuoti se si sta impostando su un'installazione esistente."},"admin.adminFound":{"other":"Un utente amministratore è già presente nel DB. Verifica se vuoi crearne uno nuovo."},"advanced.stepLabel":{"other":"Impostazioni Avanzate"},"advanced.title":{"other":"Impostazioni Avanzate (opzionale)"},"advanced.legend":{"other":"I servizi Pydio Cells saranno implementati su questa macchina. È possibile rivedere alcune impostazioni avanzate qui sotto per perfezionare la configurazione."},"advanced.toggle":{"other":"Mostra Impostazioni Avanzate"},"advanced.default.datasource":{"other":"All'avvio viene creato un datasource predefinito per memorizzare i dati personali degli utenti e le celle. È possibile creare altri datasource in un secondo momento."},"license.stepLabel":{"other":"Licenza Enterprise"},"license.title":{"other":"Licenza Pydio Cells Enterprise"},"license.success":{"other":"File di licenza rilevato con successo."},"license.details":{"other":"Questa installazione è valida per %count utenti fino a %expiration."},"license.failed":{"other":"Errore durante il tentativo di verificare questa chiave di licenza. Si prega di contattare il supporto."},"license.required":{"other":"Per eseguire la Enterprise Distribution è necessaria una chiave di licenza valida. Per ottenere una licenza di prova di 30 giorni o un preventivo di vendita, si prega di contattare"},"license.fieldLabel":{"other":"Stringa di Licenza"},"license.fieldLegend":{"other":"Si prega di copiare/incollare la chiave di licenza fornita."},"apply.stepLabel":{"other":"Applica Installazione"},"apply.title":{"other":"Attendere mentre viene installato Pydio Cells..."},"apply.success":{"other":"L'installazione è avvenuta con successo e i servizi sono in fase di avvio, il programma di installazione ricaricherà la pagina quando i servizi sono stati avviati."},"apply.success.restarted":{"other":"L'installazione è avvenuta con successo e i servizi sono stati avviati, ricaricare la pagina ora (verrà automaticamente ricaricata in %1s)"},"apply.error":{"other":"Si è verificato un errore durante l'esecuzione dell'installazione! Si prega di controllare la configurazione."},"apply.error.detail":{"other":"L'errore era: "},"form.dbConnectionType.label":{"other":"Tipo di Connessione"},"form.dbConnectionType.tcp":{"other":"TCP"},"form.dbConnectionType.socket":{"other":"Socket"},"form.dbConnectionType.manual":{"other":"Manuale"},"form.dbTCPHostname.label":{"other":"Nome Host"},"form.dbTCPHostname.legend":{"other":"Server dove è in esecuzione mysql"},"form.dbName.label":{"other":"Nome del Database"},"form.dbName.legend":{"other":"Database da usare (verrà creato se non esiste)"},"form.dbTCPPort.label":{"other":"Porta"},"form.dbTCPPort.legend":{"other":"Porta per connettersi a mysql"},"form.dbUser.label":{"other":"Utente Database"},"form.dbUser.legend":{"other":"Lascia vuoto se non richiesto"},"form.dbPassword.label":{"other":"Password del Database"},"form.dbPassword.legend":{"other":"Lascia vuoto se non richiesto"},"form.dbSocketFile.label":{"other":"Socket"},"form.dbSocketFile.legend":{"other":"Inserire la posizione del file socket da usare per la connessione"},"form.dbManualDSN.label":{"other":"DSN"},"form.dbManualDSN.legend":{"other":"Usa un DSN stile Golang per descrivere la connessione al database"},"form.frontendApplicationTitle.label":{"other":"Titolo dell'Applicazione"},"form.frontendApplicationTitle.legend":{"other":"Titolo principale della tua installazione"},"form.frontendDefaultLanguage.label":{"other":"Lingua Predefinita"},"form.frontendLogin.label":{"other":"Accesso utente amministratore *"},"form.frontendLogin.legend":{"other":"Identificatore utilizzato per accedere"},"form.frontendPassword.label":{"other":"Password amministratore *"},"form.frontendPassword.legend":{"other":"Password utilizzata per accedere"},"form.frontendRepeatPassword.label":{"other":"Conferma password"},"form.frontendRepeatPassword.legend":{"other":"Conferma la password due volte"},"form.dsFolder.label":{"other":"Percorso del datasource predefinito"},"form.dsFolder.legend":{"other":"Usa un percorso assoluto sul server"},"form.dsType.FS":{"other":"FS locale (memorizza tutti i dati su questo server)"},"form.dsType.S3":{"other":"Amazon S3 / S3-compatible (store inside S3 buckets)"},"form.dsS3Custom.label":{"other":"S3-Compatible storage endpoint"},"form.dsS3Custom.legend":{"other":"Leave empty for Amazon"},"form.dsS3CustomRegion.label":{"other":"S3 Custom region"},"form.dsS3CustomRegion.legend":{"other":"Leave empty for default (us-east-1)"},"form.dsS3ApiKey.label":{"other":"Chiave Api S3"},"form.dsS3ApiKey.legend":{"other":"Chiave per connettersi a S3"},"form.dsS3ApiSecret.label":{"other":"Api Segreta S3"},"form.dsS3ApiSecret.legend":{"other":"Chiave Segreta"},"form.dsS3ValidateKeys":{"other":"Collegati a S3 per definire i bucket"},"form.s3BucketsPrefix.label":{"other":"Prefisso dei bucket"},"form.s3BucketsPrefix.legend":{"other":"Un prefisso unico per creare i 6 bucket predefiniti"},"form.bucketList.found":{"other":"I seguenti bucket esistono già"},"form.bucketList.toCreate":{"other":"Verranno creati i seguenti bucket"},"form.bucketList.notFound":{"other":"I seguenti bucket non sono stati trovati:"},"form.bucketList.warnCreate":{"other":"Non sei autorizzato a creare bucket, assicurati di crearli manualmente!"},"stepper.button.next":{"other":"Successivo"},"stepper.button.back":{"other":"Indietro"},"stepper.button.last":{"other":"Installa Ora"},"stepper.button.reload":{"other":"Ricarica"}};
languages["ja"] = {"welcome.stepLabel":{"other":"利用規約"},"welcome.title":{"other":"Pydio Cellsインストールウィザードへようこそ"},"welcome.legend":{"other":"サーバーにすべてのサービスをインストールします。実行する前に、以下のライセンス条件に同意してください。"},"welcome.agreed":{"other":"利用規約に同意する"},"database.stepLabel":{"other":"データベース接続"},"database.title":{"other":"データベース設定"},"database.legend":{"other":"Pydioでは、各種設定の保存とデータの検索のため、少なくとも1つのSQLストレージが必要です。MySQL/MariaDBサーバーへの接続設定を実施してください。"},"database.legend.bold":{"other":"MySQLのバージョンが5.6以上であることを確認してください。"},"database.installDetected":{"other":"データベースにセットアップされたCellsがあります。このまま続行するか確認してください。 "},"database.installDetected.retry":{"other":"新しい値で再試行する"},"database.useDefaultsSet":{"other":"A default database is already configured, just click next to validate connection."},"database.forceConfigure":{"other":"Configure another database."},"admin.stepLabel":{"other":"管理者ユーザー"},"admin.title":{"other":"管理者ユーザーとフロントエンドのデフォルト設定"},"admin.legend":{"other":"管理者ユーザーの認証情報を提供します。インストール済みのプログラムにデプロイする場合は、フィールドを空のままにします。"},"admin.adminFound":{"other":"管理者ユーザーはすでに登録されています。新しいユーザーを作成しますか？"},"advanced.stepLabel":{"other":"詳細設定"},"advanced.title":{"other":"詳細設定 (オプション)"},"advanced.legend":{"other":"Pydio Cells サービスがデプロイされます。設定を変更する場合、以下の詳細設定を確認してください。"},"advanced.toggle":{"other":"詳細設定を表示"},"advanced.default.datasource":{"other":"ユーザーの個人データとcellsを保存するデータソースは、スタートアップ時に作成されます。後で、他のデータソースを作成することも可能です。"},"license.stepLabel":{"other":"エンタープライズライセンス"},"license.title":{"other":"Pydio Cells エンタープライズライセンス"},"license.success":{"other":"ライセンスファイルの検出に成功しました。"},"license.details":{"other":"このプログラムは%expiration中%countのユーザーまで登録可能です"},"license.failed":{"other":"ライセンスキーの検証中にエラーが発生しました。サポートに連絡してください。"},"license.required":{"other":"エンタープライズディストリビューションの実行には、ライセンスキーが必要です。30日間のトライアルライセンス、またはお見積もりが必要な場合は、お問い合わせください"},"license.fieldLabel":{"other":"ライセンス文字列"},"license.fieldLegend":{"other":"ライセンスキーをコピー/ペーストしてください。"},"apply.stepLabel":{"other":"プログラムを適用"},"apply.title":{"other":"Pydio Cellsのインストールしています。しばらくお待ちください..."},"apply.success":{"other":"インストールが成功しました。サービスを開始しております。サービス開始後に、このページを再読み込みします。"},"apply.success.restarted":{"other":"インストールが成功し、サービスが開始されました。今すぐページを再読み込みしてください（ %1sに自動で再読み込みされます）"},"apply.error":{"other":"インストール中にエラーが発生しました！設定を確認してください。"},"apply.error.detail":{"other":"エラーが発生しました: "},"form.dbConnectionType.label":{"other":"接続タイプ"},"form.dbConnectionType.tcp":{"other":"TCP"},"form.dbConnectionType.socket":{"other":"ソケット"},"form.dbConnectionType.manual":{"other":"手動"},"form.dbTCPHostname.label":{"other":"ホスト名"},"form.dbTCPHostname.legend":{"other":"mysqlサーバー"},"form.dbName.label":{"other":"データベース名"},"form.dbName.legend":{"other":"使用するデータベース（存在しない場合は作成されます）"},"form.dbTCPPort.label":{"other":"ポート"},"form.dbTCPPort.legend":{"other":"mysqlに接続するポート"},"form.dbUser.label":{"other":"データベースのユーザー"},"form.dbUser.legend":{"other":"不要な場合は空白にしてください"},"form.dbPassword.label":{"other":"データベースのパスワード"},"form.dbPassword.legend":{"other":"不要な場合は空白にしてください"},"form.dbSocketFile.label":{"other":"ソケット"},"form.dbSocketFile.legend":{"other":"接続に使用するソケットファイルの場所を入力してください"},"form.dbManualDSN.label":{"other":"DSN"},"form.dbManualDSN.legend":{"other":"Golang-style DSNを使用してデータベースに接続します"},"form.frontendApplicationTitle.label":{"other":"アプリケーションのタイトル"},"form.frontendApplicationTitle.legend":{"other":"プログラムのメインタイトル"},"form.frontendDefaultLanguage.label":{"other":"デフォルトの言語"},"form.frontendLogin.label":{"other":"管理者ユーザーのログイン *"},"form.frontendLogin.legend":{"other":"ログインに使用するID"},"form.frontendPassword.label":{"other":"管理者のパスワード *"},"form.frontendPassword.legend":{"other":"ログインに使用するパスワード"},"form.frontendRepeatPassword.label":{"other":"パスワードの確認"},"form.frontendRepeatPassword.legend":{"other":"パスワードの確認"},"form.dsFolder.label":{"other":"データソースのデフォルトパス"},"form.dsFolder.legend":{"other":"絶対パスを使用する"},"form.dsType.FS":{"other":"ローカル FS (このサーバーにすべてのデータを保存する)"},"form.dsType.S3":{"other":"Amazon S3 / S3-compatible (store inside S3 buckets)"},"form.dsS3Custom.label":{"other":"S3-Compatible storage endpoint"},"form.dsS3Custom.legend":{"other":"Leave empty for Amazon"},"form.dsS3CustomRegion.label":{"other":"S3 Custom region"},"form.dsS3CustomRegion.legend":{"other":"Leave empty for default (us-east-1)"},"form.dsS3ApiKey.label":{"other":"S3 APIキー"},"form.dsS3ApiKey.legend":{"other":"S3に接続するキー"},"form.dsS3ApiSecret.label":{"other":"S3 APIシークレット"},"form.dsS3ApiSecret.legend":{"other":"シークレットキー"},"form.dsS3ValidateKeys":{"other":"S3に接続して、バケットを設定する"},"form.s3BucketsPrefix.label":{"other":"バケットのプリフィクス"},"form.s3BucketsPrefix.legend":{"other":"6つのデフォルトバケットを作成するためのユニークなプリフィックスです。"},"form.bucketList.found":{"other":"以下のバケットは既に存在しています"},"form.bucketList.toCreate":{"other":"以下のバケットが作成されます"},"form.bucketList.notFound":{"other":"以下のバケットが見つかりません"},"form.bucketList.warnCreate":{"other":"バケットの作成は許可されていません。手動で作成できるか確認してください。"},"stepper.button.next":{"other":"次へ"},"stepper.button.back":{"other":"戻る"},"stepper.button.last":{"other":"今すぐインストールする"},"stepper.button.reload":{"other":"再読み込み"}};
languages["ko"] = {"welcome.stepLabel":{"other":"이용약관"},"welcome.title":{"other":"Welcome to Pydio Cells Installation Wizard"},"welcome.legend":{"other":"This will install all services on the current server. Please agree with the terms of the license below before starting"},"welcome.agreed":{"other":"I agree with the terms"},"database.stepLabel":{"other":"Database Connection"},"database.title":{"other":"Database Configuration"},"database.legend":{"other":"Pydio requires at least one SQL storage for configuration and data indexation. Configure here the connection to your MySQL/MariaDB server."},"database.legend.bold":{"other":"Please make sure that your database is running MySQL version 5.6 or higher"},"database.installDetected":{"other":"There seem to be a Cells installation already setup in this database. Please confirm to continue or "},"database.installDetected.retry":{"other":"retry with new value"},"database.useDefaultsSet":{"other":"A default database is already configured, just click next to validate connection."},"database.forceConfigure":{"other":"Configure another database."},"admin.stepLabel":{"other":"Admin User"},"admin.title":{"other":"Admin user and frontend defaults"},"admin.legend":{"other":"Provide credentials for the administrative user. Leave fields empty if you are deploying on top of an existing installation."},"admin.adminFound":{"other":"An administrative user was already found in the DB. Check if you wish to create a new one."},"advanced.stepLabel":{"other":"고급 설정"},"advanced.title":{"other":"고급 설정 (선택)"},"advanced.legend":{"other":"Pydio Cells services will be deployed on this machine. You may review some advanced settings below for fine-tuning your configuration."},"advanced.toggle":{"other":"고급 설정 표시"},"advanced.default.datasource":{"other":"A default data source to store users personal data and cells data is created at startup. You can create other datasources later on."},"license.stepLabel":{"other":"기업 라이선스"},"license.title":{"other":"Pydio Cells Enterprise License"},"license.success":{"other":"License file was successfully detected."},"license.details":{"other":"This installation is valid for %count users until %expiration."},"license.failed":{"other":"Error while trying to verify this license key. Please contact the support."},"license.required":{"other":"A valid license key is required to run the Enterprise Distribution. To get a 30 days trial license or a sales quotation, please contact"},"license.fieldLabel":{"other":"License String"},"license.fieldLegend":{"other":"Please copy/paste the license key provided to you."},"apply.stepLabel":{"other":"Apply Installation"},"apply.title":{"other":"Please wait while installation Pydio Cells..."},"apply.success":{"other":"Install was successful and services are now starting, this installer will reload the page when services are started."},"apply.success.restarted":{"other":"Install was successful and services are now started, please reload the page now (it will be automatically reloaded in %1s)"},"apply.error":{"other":"There was an error while performing installation! Please check your configuration."},"apply.error.detail":{"other":"Error was: "},"form.dbConnectionType.label":{"other":"Connection Type"},"form.dbConnectionType.tcp":{"other":"TCP"},"form.dbConnectionType.socket":{"other":"소켓"},"form.dbConnectionType.manual":{"other":"Manual"},"form.dbTCPHostname.label":{"other":"호스트명"},"form.dbTCPHostname.legend":{"other":"Server where mysql is running"},"form.dbName.label":{"other":"데이터베이스 이름"},"form.dbName.legend":{"other":"Database to use (will be created if it does not exist)"},"form.dbTCPPort.label":{"other":"포트"},"form.dbTCPPort.legend":{"other":"Port to connect to mysql"},"form.dbUser.label":{"other":"데이터베이스 사용자"},"form.dbUser.legend":{"other":"Leave blank if not required"},"form.dbPassword.label":{"other":"데이터베이스 비밀번호"},"form.dbPassword.legend":{"other":"Leave blank if not required"},"form.dbSocketFile.label":{"other":"소켓"},"form.dbSocketFile.legend":{"other":"Enter the location of the socket file to use to connect"},"form.dbManualDSN.label":{"other":"DSN"},"form.dbManualDSN.legend":{"other":"Use Golang-style DSN to describe the database connection"},"form.frontendApplicationTitle.label":{"other":"Application Title"},"form.frontendApplicationTitle.legend":{"other":"Main title of your installation"},"form.frontendDefaultLanguage.label":{"other":"Default Language"},"form.frontendLogin.label":{"other":"Admin user login *"},"form.frontendLogin.legend":{"other":"Identifier used to log in"},"form.frontendPassword.label":{"other":"Admin password *"},"form.frontendPassword.legend":{"other":"Password used to log in"},"form.frontendRepeatPassword.label":{"other":"Confirm password"},"form.frontendRepeatPassword.legend":{"other":"Confirm password twice"},"form.dsFolder.label":{"other":"Path of the default datasource"},"form.dsFolder.legend":{"other":"Use an absolute path on the server"},"form.dsType.FS":{"other":"Local FS (store all data on this server)"},"form.dsType.S3":{"other":"Amazon S3 / S3-compatible (store inside S3 buckets)"},"form.dsS3Custom.label":{"other":"S3-Compatible storage endpoint"},"form.dsS3Custom.legend":{"other":"Leave empty for Amazon"},"form.dsS3CustomRegion.label":{"other":"S3 Custom region"},"form.dsS3CustomRegion.legend":{"other":"Leave empty for default (us-east-1)"},"form.dsS3ApiKey.label":{"other":"S3 Api Key"},"form.dsS3ApiKey.legend":{"other":"Key to connect to S3"},"form.dsS3ApiSecret.label":{"other":"S3 Api Secret"},"form.dsS3ApiSecret.legend":{"other":"Secret Key"},"form.dsS3ValidateKeys":{"other":"Connect to S3 to define buckets"},"form.s3BucketsPrefix.label":{"other":"Buckets prefix"},"form.s3BucketsPrefix.legend":{"other":"A unique prefix for creating the 6 default buckets"},"form.bucketList.found":{"other":"Following bucket(s) already exist"},"form.bucketList.toCreate":{"other":"Following bucket(s) will be created"},"form.bucketList.notFound":{"other":"Following buckets were not found"},"form.bucketList.warnCreate":{"other":"You are not allowed to create buckets, make sure to create them manually!"},"stepper.button.next":{"other":"Next"},"stepper.button.back":{"other":"Back"},"stepper.button.last":{"other":"Install Now"},"stepper.button.reload":{"other":"Reload"}};
languages["lv"] = {"welcome.stepLabel":{"other":"Terms of Use"},"welcome.title":{"other":"Welcome to Pydio Cells Installation Wizard"},"welcome.legend":{"other":"This will install all services on the current server. Please agree with the terms of the license below before starting"},"welcome.agreed":{"other":"I agree with the terms"},"database.stepLabel":{"other":"Database Connection"},"database.title":{"other":"Database Configuration"},"database.legend":{"other":"Pydio requires at least one SQL storage for configuration and data indexation. Configure here the connection to your MySQL/MariaDB server."},"database.legend.bold":{"other":"Please make sure that your database is running MySQL version 5.6 or higher"},"database.installDetected":{"other":"There seem to be a Cells installation already setup in this database. Please confirm to continue or "},"database.installDetected.retry":{"other":"retry with new value"},"database.useDefaultsSet":{"other":"A default database is already configured, just click next to validate connection."},"database.forceConfigure":{"other":"Configure another database."},"admin.stepLabel":{"other":"Admin User"},"admin.title":{"other":"Admin user and frontend defaults"},"admin.legend":{"other":"Provide credentials for the administrative user. Leave fields empty if you are deploying on top of an existing installation."},"admin.adminFound":{"other":"An administrative user was already found in the DB. Check if you wish to create a new one."},"advanced.stepLabel":{"other":"Advanced Settings"},"advanced.title":{"other":"Advanced Settings (optional)"},"advanced.legend":{"other":"Pydio Cells services will be deployed on this machine. You may review some advanced settings below for fine-tuning your configuration."},"advanced.toggle":{"other":"Show Advanced Settings"},"advanced.default.datasource":{"other":"A default data source to store users personal data and cells data is created at startup. You can create other datasources later on."},"license.stepLabel":{"other":"Enterprise License"},"license.title":{"other":"Pydio Cells Enterprise License"},"license.success":{"other":"License file was successfully detected."},"license.details":{"other":"This installation is valid for %count users until %expiration."},"license.failed":{"other":"Error while trying to verify this license key. Please contact the support."},"license.required":{"other":"A valid license key is required to run the Enterprise Distribution. To get a 30 days trial license or a sales quotation, please contact"},"license.fieldLabel":{"other":"License String"},"license.fieldLegend":{"other":"Please copy/paste the license key provided to you."},"apply.stepLabel":{"other":"Apply Installation"},"apply.title":{"other":"Please wait while installation Pydio Cells..."},"apply.success":{"other":"Install was successful and services are now starting, this installer will reload the page when services are started."},"apply.success.restarted":{"other":"Install was successful and services are now started, please reload the page now (it will be automatically reloaded in %1s)"},"apply.error":{"other":"There was an error while performing installation! Please check your configuration."},"apply.error.detail":{"other":"Error was: "},"form.dbConnectionType.label":{"other":"Connection Type"},"form.dbConnectionType.tcp":{"other":"TCP"},"form.dbConnectionType.socket":{"other":"Socket"},"form.dbConnectionType.manual":{"other":"Manuāli"},"form.dbTCPHostname.label":{"other":"Host Name"},"form.dbTCPHostname.legend":{"other":"Server where mysql is running"},"form.dbName.label":{"other":"Database Name"},"form.dbName.legend":{"other":"Database to use (will be created if it does not exist)"},"form.dbTCPPort.label":{"other":"Port"},"form.dbTCPPort.legend":{"other":"Port to connect to mysql"},"form.dbUser.label":{"other":"Database User"},"form.dbUser.legend":{"other":"Leave blank if not required"},"form.dbPassword.label":{"other":"Database Password"},"form.dbPassword.legend":{"other":"Leave blank if not required"},"form.dbSocketFile.label":{"other":"Socket"},"form.dbSocketFile.legend":{"other":"Enter the location of the socket file to use to connect"},"form.dbManualDSN.label":{"other":"DSN"},"form.dbManualDSN.legend":{"other":"Use Golang-style DSN to describe the database connection"},"form.frontendApplicationTitle.label":{"other":"Aplikācijas nosaukums"},"form.frontendApplicationTitle.legend":{"other":"Main title of your installation"},"form.frontendDefaultLanguage.label":{"other":"Noklusējuma valoda"},"form.frontendLogin.label":{"other":"Admin user login *"},"form.frontendLogin.legend":{"other":"Identifier used to log in"},"form.frontendPassword.label":{"other":"Admin password *"},"form.frontendPassword.legend":{"other":"Password used to log in"},"form.frontendRepeatPassword.label":{"other":"Apstiprināt paroli"},"form.frontendRepeatPassword.legend":{"other":"Confirm password twice"},"form.dsFolder.label":{"other":"Path of the default datasource"},"form.dsFolder.legend":{"other":"Use an absolute path on the server"},"form.dsType.FS":{"other":"Local FS (store all data on this server)"},"form.dsType.S3":{"other":"Amazon S3 / S3-compatible (store inside S3 buckets)"},"form.dsS3Custom.label":{"other":"S3-Compatible storage endpoint"},"form.dsS3Custom.legend":{"other":"Leave empty for Amazon"},"form.dsS3CustomRegion.label":{"other":"S3 Custom region"},"form.dsS3CustomRegion.legend":{"other":"Leave empty for default (us-east-1)"},"form.dsS3ApiKey.label":{"other":"S3 Api atslēga"},"form.dsS3ApiKey.legend":{"other":"Key to connect to S3"},"form.dsS3ApiSecret.label":{"other":"S3 Api Parole"},"form.dsS3ApiSecret.legend":{"other":"Secret Key"},"form.dsS3ValidateKeys":{"other":"Connect to S3 to define buckets"},"form.s3BucketsPrefix.label":{"other":"Buckets prefix"},"form.s3BucketsPrefix.legend":{"other":"A unique prefix for creating the 6 default buckets"},"form.bucketList.found":{"other":"Following bucket(s) already exist"},"form.bucketList.toCreate":{"other":"Following bucket(s) will be created"},"form.bucketList.notFound":{"other":"Following buckets were not found"},"form.bucketList.warnCreate":{"other":"You are not allowed to create buckets, make sure to create them manually!"},"stepper.button.next":{"other":"Nākamā"},"stepper.button.back":{"other":"Atpakaļ"},"stepper.button.last":{"other":"Install Now"},"stepper.button.reload":{"other":"Pārlādēt"}};
languages["nl"] = {"welcome.stepLabel":{"other":"Gebruiksvoorwaarden"},"welcome.title":{"other":"Welkom bij Pydio Cells Installatie Wizard"},"welcome.legend":{"other":"Dit zal alle services op de huidige server installeren. Ga akkoord met de voorwaarden van onderstaande licentie voordat u begint"},"welcome.agreed":{"other":"Ik ga akkoord met de voorwaarden"},"database.stepLabel":{"other":"Database verbinding"},"database.title":{"other":"Database configuratie"},"database.legend":{"other":"Pydio vereist ten minste één SQL databank voor configuratie en gegevensindexatie. Configureer hier de verbinding met uw MySQL/MariaDB server."},"database.legend.bold":{"other":"Zorg ervoor dat uw database MySQL versie 5.6 of hoger gebruikt"},"database.installDetected":{"other":"Er lijkt al een Cells-installatie in deze database te zijn ingesteld. Bevestig om door te gaan of "},"database.installDetected.retry":{"other":"probeer opnieuw met nieuwe waarde"},"database.useDefaultsSet":{"other":"A default database is already configured, just click next to validate connection."},"database.forceConfigure":{"other":"Configure another database."},"admin.stepLabel":{"other":"Admin gebruiker"},"admin.title":{"other":"Admin gebruiker en frontend standaardinstellingen"},"admin.legend":{"other":"Geef referenties op voor de beheerder. Laat de velden leeg als u installeert bovenop een bestaande installatie."},"admin.adminFound":{"other":"Er is al een beheerder gevonden in de database. Controleer of u een nieuwe wilt maken."},"advanced.stepLabel":{"other":"Geavanceerde instellingen"},"advanced.title":{"other":"Geavanceerde instellingen (optioneel)"},"advanced.legend":{"other":"Pydio Cells-services worden geïnstalleerd op deze machine. Je kunt hieronder enkele geavanceerde instellingen bekijken om je configuratie aan te passen."},"advanced.toggle":{"other":"Geavanceerde Instellingen weergeven"},"advanced.default.datasource":{"other":"Een standaard gegevensbron voor het opslaan van persoonlijke gegevens van gebruikers en cellen is gemaakt bij het opstarten. U kunt later andere datasources maken."},"license.stepLabel":{"other":"Enterprise Licentie"},"license.title":{"other":"Pydio Cells Enterprise Licentie"},"license.success":{"other":"Licentiebestand is met succes gedetecteerd."},"license.details":{"other":"Deze installatie is geldig voor %count gebruikers tot %expiration."},"license.failed":{"other":"Fout tijdens het verifiëren van deze licentiesleutel. Neem contact op met support."},"license.required":{"other":"Een geldige licentiesleutel is vereist voor het uitvoeren van de Enterprise Distributie. Voor een proeflicentie van 30 dagen of een offerte, neem contact op met"},"license.fieldLabel":{"other":"Licentie String"},"license.fieldLegend":{"other":"Kopieer en plak de licentiesleutel die aan u is verstrekt."},"apply.stepLabel":{"other":"Installatie toepassen"},"apply.title":{"other":"Een ogenblik geduld terwijl de installatie van Pydio Cells..."},"apply.success":{"other":"De installatie was succesvol en de services zijn nu gestart, deze installer herlaadt de pagina wanneer de services worden gestart."},"apply.success.restarted":{"other":"De installatie was succesvol en de services zijn nu gestart, gelieve de pagina nu te herladen (het wordt automatisch herladen in %1s)"},"apply.error":{"other":"Er is een fout opgetreden tijdens het uitvoeren van de installatie! Controleer uw configuratie."},"apply.error.detail":{"other":"Fout was: "},"form.dbConnectionType.label":{"other":"Verbindingstype"},"form.dbConnectionType.tcp":{"other":"TCP"},"form.dbConnectionType.socket":{"other":"Socket"},"form.dbConnectionType.manual":{"other":"Manueel"},"form.dbTCPHostname.label":{"other":"Host Naam"},"form.dbTCPHostname.legend":{"other":"Server waar mysql actief is"},"form.dbName.label":{"other":"Database naam"},"form.dbName.legend":{"other":"Te gebruiken database (zal worden aangemaakt als deze niet bestaat)"},"form.dbTCPPort.label":{"other":"Poort"},"form.dbTCPPort.legend":{"other":"Poort om te verbinden met mysql"},"form.dbUser.label":{"other":"Database Gebruiker"},"form.dbUser.legend":{"other":"Leeg laten indien niet vereist"},"form.dbPassword.label":{"other":"Database wachtwoord"},"form.dbPassword.legend":{"other":"Leeg laten indien niet vereist"},"form.dbSocketFile.label":{"other":"Socket"},"form.dbSocketFile.legend":{"other":"Voer de locatie in van het socket-bestand dat gebruikt wordt om te verbinden"},"form.dbManualDSN.label":{"other":"DSN"},"form.dbManualDSN.legend":{"other":"Gebruik Golang-stijl DSN om de databaseverbinding te beschrijven"},"form.frontendApplicationTitle.label":{"other":"Toepassingsnaam"},"form.frontendApplicationTitle.legend":{"other":"Hoofdtitel van uw installatie"},"form.frontendDefaultLanguage.label":{"other":"Standaard taal"},"form.frontendLogin.label":{"other":"Beheerder login *"},"form.frontendLogin.legend":{"other":"Identifier gebruikt om in te loggen"},"form.frontendPassword.label":{"other":"Admin wachtwoord *"},"form.frontendPassword.legend":{"other":"Wachtwoord gebruikt om in te loggen"},"form.frontendRepeatPassword.label":{"other":"Bevestig wachtwoord"},"form.frontendRepeatPassword.legend":{"other":"Bevestig wachtwoord tweemaal"},"form.dsFolder.label":{"other":"Pad van de standaard databron"},"form.dsFolder.legend":{"other":"Gebruik een absoluut pad op de server"},"form.dsType.FS":{"other":"Lokale Bestandsbron (sla alle gegevens op deze server)"},"form.dsType.S3":{"other":"Amazon S3 / S3-compatible (store inside S3 buckets)"},"form.dsS3Custom.label":{"other":"S3-Compatible storage endpoint"},"form.dsS3Custom.legend":{"other":"Leave empty for Amazon"},"form.dsS3CustomRegion.label":{"other":"S3 Custom region"},"form.dsS3CustomRegion.legend":{"other":"Leave empty for default (us-east-1)"},"form.dsS3ApiKey.label":{"other":"S3 Api sleutel"},"form.dsS3ApiKey.legend":{"other":"Sleutel om te verbinden met S3"},"form.dsS3ApiSecret.label":{"other":"S3 Api geheim"},"form.dsS3ApiSecret.legend":{"other":"Geheime sleutel"},"form.dsS3ValidateKeys":{"other":"Verbind met S3 om S3-buckets te definiëren"},"form.s3BucketsPrefix.label":{"other":"Buckets prefix"},"form.s3BucketsPrefix.legend":{"other":"Een unieke prefix voor het maken van de 6 standaard S3-buckets"},"form.bucketList.found":{"other":"De volgende S3-bucket(s) bestaan al"},"form.bucketList.toCreate":{"other":"Volgende S3-bucket(s) zullen worden gemaakt"},"form.bucketList.notFound":{"other":"De volgende S3-bucket(s) zijn niet gevonden"},"form.bucketList.warnCreate":{"other":"U hebt geen rechten om S3-buckets te maken, zorg ervoor dat je ze handmatig maakt!"},"stepper.button.next":{"other":"Volgende"},"stepper.button.back":{"other":"Vorige"},"stepper.button.last":{"other":"Nu installeren"},"stepper.button.reload":{"other":"Opnieuw laden"}};
languages["pt-br"] = {"welcome.stepLabel":{"other":"Terms of Use"},"welcome.title":{"other":"Welcome to Pydio Cells Installation Wizard"},"welcome.legend":{"other":"This will install all services on the current server. Please agree with the terms of the license below before starting"},"welcome.agreed":{"other":"I agree with the terms"},"database.stepLabel":{"other":"Database Connection"},"database.title":{"other":"Database Configuration"},"database.legend":{"other":"Pydio requires at least one SQL storage for configuration and data indexation. Configure here the connection to your MySQL/MariaDB server."},"database.legend.bold":{"other":"Please make sure that your database is running MySQL version 5.6 or higher"},"database.installDetected":{"other":"There seem to be a Cells installation already setup in this database. Please confirm to continue or "},"database.installDetected.retry":{"other":"retry with new value"},"database.useDefaultsSet":{"other":"A default database is already configured, just click next to validate connection."},"database.forceConfigure":{"other":"Configure another database."},"admin.stepLabel":{"other":"Admin User"},"admin.title":{"other":"Admin user and frontend defaults"},"admin.legend":{"other":"Provide credentials for the administrative user. Leave fields empty if you are deploying on top of an existing installation."},"admin.adminFound":{"other":"An administrative user was already found in the DB. Check if you wish to create a new one."},"advanced.stepLabel":{"other":"Advanced Settings"},"advanced.title":{"other":"Advanced Settings (optional)"},"advanced.legend":{"other":"Pydio Cells services will be deployed on this machine. You may review some advanced settings below for fine-tuning your configuration."},"advanced.toggle":{"other":"Show Advanced Settings"},"advanced.default.datasource":{"other":"A default data source to store users personal data and cells data is created at startup. You can create other datasources later on."},"license.stepLabel":{"other":"Enterprise License"},"license.title":{"other":"Pydio Cells Enterprise License"},"license.success":{"other":"License file was successfully detected."},"license.details":{"other":"This installation is valid for %count users until %expiration."},"license.failed":{"other":"Error while trying to verify this license key. Please contact the support."},"license.required":{"other":"A valid license key is required to run the Enterprise Distribution. To get a 30 days trial license or a sales quotation, please contact"},"license.fieldLabel":{"other":"License String"},"license.fieldLegend":{"other":"Please copy/paste the license key provided to you."},"apply.stepLabel":{"other":"Apply Installation"},"apply.title":{"other":"Please wait while installation Pydio Cells..."},"apply.success":{"other":"Install was successful and services are now starting, this installer will reload the page when services are started."},"apply.success.restarted":{"other":"Install was successful and services are now started, please reload the page now (it will be automatically reloaded in %1s)"},"apply.error":{"other":"There was an error while performing installation! Please check your configuration."},"apply.error.detail":{"other":"Error was: "},"form.dbConnectionType.label":{"other":"Connection Type"},"form.dbConnectionType.tcp":{"other":"TCP"},"form.dbConnectionType.socket":{"other":"Socket"},"form.dbConnectionType.manual":{"other":"Manual"},"form.dbTCPHostname.label":{"other":"Host Name"},"form.dbTCPHostname.legend":{"other":"Server where mysql is running"},"form.dbName.label":{"other":"Database Name"},"form.dbName.legend":{"other":"Database to use (will be created if it does not exist)"},"form.dbTCPPort.label":{"other":"Port"},"form.dbTCPPort.legend":{"other":"Port to connect to mysql"},"form.dbUser.label":{"other":"Database User"},"form.dbUser.legend":{"other":"Leave blank if not required"},"form.dbPassword.label":{"other":"Database Password"},"form.dbPassword.legend":{"other":"Leave blank if not required"},"form.dbSocketFile.label":{"other":"Socket"},"form.dbSocketFile.legend":{"other":"Enter the location of the socket file to use to connect"},"form.dbManualDSN.label":{"other":"DSN"},"form.dbManualDSN.legend":{"other":"Use Golang-style DSN to describe the database connection"},"form.frontendApplicationTitle.label":{"other":"Application Title"},"form.frontendApplicationTitle.legend":{"other":"Main title of your installation"},"form.frontendDefaultLanguage.label":{"other":"Default Language"},"form.frontendLogin.label":{"other":"Admin user login *"},"form.frontendLogin.legend":{"other":"Identifier used to log in"},"form.frontendPassword.label":{"other":"Admin password *"},"form.frontendPassword.legend":{"other":"Password used to log in"},"form.frontendRepeatPassword.label":{"other":"Confirm password"},"form.frontendRepeatPassword.legend":{"other":"Confirm password twice"},"form.dsFolder.label":{"other":"Path of the default datasource"},"form.dsFolder.legend":{"other":"Use an absolute path on the server"},"form.dsType.FS":{"other":"Local FS (store all data on this server)"},"form.dsType.S3":{"other":"Amazon S3 / S3-compatible (store inside S3 buckets)"},"form.dsS3Custom.label":{"other":"S3-Compatible storage endpoint"},"form.dsS3Custom.legend":{"other":"Leave empty for Amazon"},"form.dsS3CustomRegion.label":{"other":"S3 Custom region"},"form.dsS3CustomRegion.legend":{"other":"Leave empty for default (us-east-1)"},"form.dsS3ApiKey.label":{"other":"S3 Api Key"},"form.dsS3ApiKey.legend":{"other":"Key to connect to S3"},"form.dsS3ApiSecret.label":{"other":"S3 Api Secret"},"form.dsS3ApiSecret.legend":{"other":"Secret Key"},"form.dsS3ValidateKeys":{"other":"Connect to S3 to define buckets"},"form.s3BucketsPrefix.label":{"other":"Buckets prefix"},"form.s3BucketsPrefix.legend":{"other":"A unique prefix for creating the 6 default buckets"},"form.bucketList.found":{"other":"Following bucket(s) already exist"},"form.bucketList.toCreate":{"other":"Following bucket(s) will be created"},"form.bucketList.notFound":{"other":"Following buckets were not found"},"form.bucketList.warnCreate":{"other":"You are not allowed to create buckets, make sure to create them manually!"},"stepper.button.next":{"other":"Próximo"},"stepper.button.back":{"other":"Voltar"},"stepper.button.last":{"other":"Install Now"},"stepper.button.reload":{"other":"Atualizar"}};
languages["ru"] = {"welcome.stepLabel":{"other":"Пользовательское соглашение"},"welcome.title":{"other":"Добро пожаловать в Мастер установки Pydio Cells"},"welcome.legend":{"other":"Установка сервисов на текущий сервер. Перед началом, необходимо согласиться с условиями лицензирования"},"welcome.agreed":{"other":"Я согласен с условиями выше"},"database.stepLabel":{"other":"Соединение с Базой Данных"},"database.title":{"other":"Конфигурация базы данных"},"database.legend":{"other":"Pydio требуется установленная база данных для настройки и индексации. Настройте здесь подключение к серверу MySQL/MariaDB."},"database.legend.bold":{"other":"Пожалуйста, убедитесь, что ваша база данных работает под управлением MySQL версии 5.6 или выше"},"database.installDetected":{"other":"Похоже, что в этой базе данных уже установлены Cell. Подтвердите, чтобы продолжить, или "},"database.installDetected.retry":{"other":"повторить попытку с новым значением"},"database.useDefaultsSet":{"other":"A default database is already configured, just click next to validate connection."},"database.forceConfigure":{"other":"Configure another database."},"admin.stepLabel":{"other":"Администратор"},"admin.title":{"other":"Для администратора и интерфейса по умолчанию"},"admin.legend":{"other":"Укажите учётные данные для администратора. Оставьте пустым, если вы обновляете существующую установки."},"admin.adminFound":{"other":"В базе данных уже существует администратор. Удостоверьтесь что вы хотите создать новый профиль."},"advanced.stepLabel":{"other":"Дополнительные параметры"},"advanced.title":{"other":"Дополнительные параметры (опционально)"},"advanced.legend":{"other":"Развертывание Pydio Cells сервисов. Ниже Вы можете просмотреть дополнительные параметры для точной настройки вашей конфигурации."},"advanced.toggle":{"other":"Показать дополнительные параметры"},"advanced.default.datasource":{"other":"При запуске создается исходный источник данных для хранения персональных данных пользователей и данных. Вы можете создать другие источники данных."},"license.stepLabel":{"other":"Корпоративная лицензия"},"license.title":{"other":"Pydio Cells корпоративная лицензия"},"license.success":{"other":"Файл лицензии был найден."},"license.details":{"other":"Эта установка действительна для %count пользователей до %expiration."},"license.failed":{"other":"Ошибка при попытке проверить этот лицензионный ключ. Обратитесь в службу поддержки."},"license.required":{"other":"Для запуска Enterprise Distribution требуется действительный лицензионный ключ. Чтобы получить 30-дневную пробную лицензию свяжитесь с нами"},"license.fieldLabel":{"other":"Лицензия"},"license.fieldLegend":{"other":"Пожалуйста, скопируйте/вставьте предоставленный вам лицензионный ключ."},"apply.stepLabel":{"other":"🚀 Установка"},"apply.title":{"other":"Пожалуйста, подождите, пока будет установлена Pydio Cell..."},"apply.success":{"other":"Установка прошла успешно, сервисы запускаются, программа установки перезагрузит страницу при запуске служб."},"apply.success.restarted":{"other":"Установка прошла успешно и сервисы запущены, пожалуйста, перезагрузите страницу (она будет автоматически перезагружена в %1s)"},"apply.error":{"other":"Произошла ошибка при выполнении установки! Пожалуйста, проверьте конфигурацию."},"apply.error.detail":{"other":"Ошибка: "},"form.dbConnectionType.label":{"other":"Тип соединения"},"form.dbConnectionType.tcp":{"other":"TCP"},"form.dbConnectionType.socket":{"other":"Сокет"},"form.dbConnectionType.manual":{"other":"Ручной"},"form.dbTCPHostname.label":{"other":"Имя хоста"},"form.dbTCPHostname.legend":{"other":"Сервер с запущенным MySQL"},"form.dbName.label":{"other":"Имя базы данных"},"form.dbName.legend":{"other":"Если база данных не существует, она будет создана автоматически"},"form.dbTCPPort.label":{"other":"Порт"},"form.dbTCPPort.legend":{"other":"Порт для подключения к mysql"},"form.dbUser.label":{"other":"Пользователь базы данных"},"form.dbUser.legend":{"other":"Оставьте пустым, если не требуется"},"form.dbPassword.label":{"other":"Пароль к базе данных"},"form.dbPassword.legend":{"other":"Оставьте пустым, если не требуется"},"form.dbSocketFile.label":{"other":"Сокет"},"form.dbSocketFile.legend":{"other":"Выберите файла сокета для создания подключения"},"form.dbManualDSN.label":{"other":"DSN"},"form.dbManualDSN.legend":{"other":"Использовать Golang-стиль DSN для описания соединения с базой данных"},"form.frontendApplicationTitle.label":{"other":"Название приложения"},"form.frontendApplicationTitle.legend":{"other":"Название установки"},"form.frontendDefaultLanguage.label":{"other":"Язык по умолчанию"},"form.frontendLogin.label":{"other":"Логин администратора *"},"form.frontendLogin.legend":{"other":"Идентификатор, используемый для входа"},"form.frontendPassword.label":{"other":"Пароль администратора"},"form.frontendPassword.legend":{"other":"Пароль для входа в систему"},"form.frontendRepeatPassword.label":{"other":"Подтверждение пароля"},"form.frontendRepeatPassword.legend":{"other":"Подтверждение пароля еще раз"},"form.dsFolder.label":{"other":"Путь по умолчанию для данных"},"form.dsFolder.legend":{"other":"Использовать абсолютный путь на сервере"},"form.dsType.FS":{"other":"Локальный файл-сервер (хранить все данные на этом сервере)"},"form.dsType.S3":{"other":"Amazon S3 / S3-compatible (store inside S3 buckets)"},"form.dsS3Custom.label":{"other":"S3-Compatible storage endpoint"},"form.dsS3Custom.legend":{"other":"Leave empty for Amazon"},"form.dsS3CustomRegion.label":{"other":"S3 Custom region"},"form.dsS3CustomRegion.legend":{"other":"Leave empty for default (us-east-1)"},"form.dsS3ApiKey.label":{"other":"S3 Api ключ"},"form.dsS3ApiKey.legend":{"other":"Ключ для подключения к S3"},"form.dsS3ApiSecret.label":{"other":"S3 Api код"},"form.dsS3ApiSecret.legend":{"other":"Секретный ключ"},"form.dsS3ValidateKeys":{"other":"Подключиться к S3 для определения сегментов"},"form.s3BucketsPrefix.label":{"other":"Префикс сегментов"},"form.s3BucketsPrefix.legend":{"other":"Уникальный префикс для создания 6 сегментов по умолчанию"},"form.bucketList.found":{"other":"Следующие контейнеры уже существуют"},"form.bucketList.toCreate":{"other":"Будут созданы следующие сегменты"},"form.bucketList.notFound":{"other":"Следующие сегменты не найдены"},"form.bucketList.warnCreate":{"other":"Вам не разрешено создавать сегменты, убедитесь, что они создаются вручную!"},"stepper.button.next":{"other":"Вперед"},"stepper.button.back":{"other":"Назад"},"stepper.button.last":{"other":"Установить сейчас"},"stepper.button.reload":{"other":"Перезагрузка"}};
languages["sv-se"] = {"welcome.stepLabel":{"other":"Terms of Use"},"welcome.title":{"other":"Welcome to Pydio Cells Installation Wizard"},"welcome.legend":{"other":"This will install all services on the current server. Please agree with the terms of the license below before starting"},"welcome.agreed":{"other":"I agree with the terms"},"database.stepLabel":{"other":"Database Connection"},"database.title":{"other":"Database Configuration"},"database.legend":{"other":"Pydio requires at least one SQL storage for configuration and data indexation. Configure here the connection to your MySQL/MariaDB server."},"database.legend.bold":{"other":"Please make sure that your database is running MySQL version 5.6 or higher"},"database.installDetected":{"other":"There seem to be a Cells installation already setup in this database. Please confirm to continue or "},"database.installDetected.retry":{"other":"retry with new value"},"database.useDefaultsSet":{"other":"A default database is already configured, just click next to validate connection."},"database.forceConfigure":{"other":"Configure another database."},"admin.stepLabel":{"other":"Admin User"},"admin.title":{"other":"Admin user and frontend defaults"},"admin.legend":{"other":"Provide credentials for the administrative user. Leave fields empty if you are deploying on top of an existing installation."},"admin.adminFound":{"other":"An administrative user was already found in the DB. Check if you wish to create a new one."},"advanced.stepLabel":{"other":"Advanced Settings"},"advanced.title":{"other":"Advanced Settings (optional)"},"advanced.legend":{"other":"Pydio Cells services will be deployed on this machine. You may review some advanced settings below for fine-tuning your configuration."},"advanced.toggle":{"other":"Show Advanced Settings"},"advanced.default.datasource":{"other":"A default data source to store users personal data and cells data is created at startup. You can create other datasources later on."},"license.stepLabel":{"other":"Enterprise License"},"license.title":{"other":"Pydio Cells Enterprise License"},"license.success":{"other":"License file was successfully detected."},"license.details":{"other":"This installation is valid for %count users until %expiration."},"license.failed":{"other":"Error while trying to verify this license key. Please contact the support."},"license.required":{"other":"A valid license key is required to run the Enterprise Distribution. To get a 30 days trial license or a sales quotation, please contact"},"license.fieldLabel":{"other":"License String"},"license.fieldLegend":{"other":"Please copy/paste the license key provided to you."},"apply.stepLabel":{"other":"Apply Installation"},"apply.title":{"other":"Please wait while installation Pydio Cells..."},"apply.success":{"other":"Install was successful and services are now starting, this installer will reload the page when services are started."},"apply.success.restarted":{"other":"Install was successful and services are now started, please reload the page now (it will be automatically reloaded in %1s)"},"apply.error":{"other":"There was an error while performing installation! Please check your configuration."},"apply.error.detail":{"other":"Error was: "},"form.dbConnectionType.label":{"other":"Connection Type"},"form.dbConnectionType.tcp":{"other":"TCP"},"form.dbConnectionType.socket":{"other":"Socket"},"form.dbConnectionType.manual":{"other":"Manual"},"form.dbTCPHostname.label":{"other":"Host Name"},"form.dbTCPHostname.legend":{"other":"Server where mysql is running"},"form.dbName.label":{"other":"Database Name"},"form.dbName.legend":{"other":"Database to use (will be created if it does not exist)"},"form.dbTCPPort.label":{"other":"Port"},"form.dbTCPPort.legend":{"other":"Port to connect to mysql"},"form.dbUser.label":{"other":"Database User"},"form.dbUser.legend":{"other":"Leave blank if not required"},"form.dbPassword.label":{"other":"Database Password"},"form.dbPassword.legend":{"other":"Leave blank if not required"},"form.dbSocketFile.label":{"other":"Socket"},"form.dbSocketFile.legend":{"other":"Enter the location of the socket file to use to connect"},"form.dbManualDSN.label":{"other":"DSN"},"form.dbManualDSN.legend":{"other":"Use Golang-style DSN to describe the database connection"},"form.frontendApplicationTitle.label":{"other":"Application Title"},"form.frontendApplicationTitle.legend":{"other":"Main title of your installation"},"form.frontendDefaultLanguage.label":{"other":"Default Language"},"form.frontendLogin.label":{"other":"Admin user login *"},"form.frontendLogin.legend":{"other":"Identifier used to log in"},"form.frontendPassword.label":{"other":"Admin password *"},"form.frontendPassword.legend":{"other":"Password used to log in"},"form.frontendRepeatPassword.label":{"other":"Confirm password"},"form.frontendRepeatPassword.legend":{"other":"Confirm password twice"},"form.dsFolder.label":{"other":"Path of the default datasource"},"form.dsFolder.legend":{"other":"Use an absolute path on the server"},"form.dsType.FS":{"other":"Local FS (store all data on this server)"},"form.dsType.S3":{"other":"Amazon S3 / S3-compatible (store inside S3 buckets)"},"form.dsS3Custom.label":{"other":"S3-Compatible storage endpoint"},"form.dsS3Custom.legend":{"other":"Leave empty for Amazon"},"form.dsS3CustomRegion.label":{"other":"S3 Custom region"},"form.dsS3CustomRegion.legend":{"other":"Leave empty for default (us-east-1)"},"form.dsS3ApiKey.label":{"other":"S3 Api Key"},"form.dsS3ApiKey.legend":{"other":"Key to connect to S3"},"form.dsS3ApiSecret.label":{"other":"S3 Api Secret"},"form.dsS3ApiSecret.legend":{"other":"Secret Key"},"form.dsS3ValidateKeys":{"other":"Connect to S3 to define buckets"},"form.s3BucketsPrefix.label":{"other":"Buckets prefix"},"form.s3BucketsPrefix.legend":{"other":"A unique prefix for creating the 6 default buckets"},"form.bucketList.found":{"other":"Following bucket(s) already exist"},"form.bucketList.toCreate":{"other":"Following bucket(s) will be created"},"form.bucketList.notFound":{"other":"Following buckets were not found"},"form.bucketList.warnCreate":{"other":"You are not allowed to create buckets, make sure to create them manually!"},"stepper.button.next":{"other":"Next"},"stepper.button.back":{"other":"Back"},"stepper.button.last":{"other":"Install Now"},"stepper.button.reload":{"other":"Reload"}};
languages["vi-vn"] = {"welcome.stepLabel":{"other":"Điều khoản sử dụng"},"welcome.title":{"other":"Chào mừng bạn đến với Pydio Cells Installation Wizard"},"welcome.legend":{"other":"Điều này sẽ cài đặt tất cả các dịch vụ trên máy chủ. Vui lòng đồng ý với các điều khoản dưới đây trước khi bắt đầu"},"welcome.agreed":{"other":"Tôi đồng ý với các điều khoản"},"database.stepLabel":{"other":"Kết nối Database"},"database.title":{"other":"Cấu hình Database"},"database.legend":{"other":"Pydio yêu cầu ít nhất một bộ lưu trữ SQL để cấu hình và lập chỉ mục dữ liệu. Cấu hình ở đây để kết nối đến máy chủ MySQL / MariaDB của bạn."},"database.legend.bold":{"other":"Vui lòng chắc chắn rằng database của bạn đang chạy MySQL phiên bản 5.6 hoặc cao hơn"},"database.installDetected":{"other":"Cells đã được thiết lập trong database. Vui lòng xác nhận để tiếp tục hoặc "},"database.installDetected.retry":{"other":"hãy thử lại với giá trị mới"},"database.useDefaultsSet":{"other":"A default database is already configured, just click next to validate connection."},"database.forceConfigure":{"other":"Configure another database."},"admin.stepLabel":{"other":"Admin User"},"admin.title":{"other":"Admin user and frontend defaults"},"admin.legend":{"other":"Cung cấp thông tin đăng nhập cho người dùng quản trị. Bỏ trống nếu bạn đang triển khai trên cài đặt hiện có."},"admin.adminFound":{"other":"Người dùng đã được tìm thấy trong DB. Kiếm tra nếu bạn muốn một cái mới."},"advanced.stepLabel":{"other":"Cài đặt nâng cao"},"advanced.title":{"other":"Cài đặt năng cao (Không bắt buộc)"},"advanced.legend":{"other":"Dịch vụ Pydio Cells sẽ được triển khai trên máy. Bạn có thể cài theo một số tùy chọn nâng cao ở dưới đây để phù hợp với máy của bạn."},"advanced.toggle":{"other":"Hiển thị thiết lập nâng cao"},"advanced.default.datasource":{"other":"Một datasource để lưu trữ dữ liệu cá nhân và dữ liệu của cells được tạo khi khởi động. Bạn có thể tạo các datasources sau quá trình cài đặt."},"license.stepLabel":{"other":"Giấy phép doanh nghiệp"},"license.title":{"other":"Giấy phép doanh nghiệp của Pydio Cells"},"license.success":{"other":"Giấy phép đăng ký đã được tìm thấy."},"license.details":{"other":"Cài đặt này hợp lệ cho %count người dùng cho đến khi %expiration."},"license.failed":{"other":"Gặp lỗi khi cố gắng xác minh mã bản quyền này. Vui lòng liên hệ với bộ phận hỗ trợ để được giúp đỡ."},"license.required":{"other":"Cần có mã cấp phép để chạy được Enterprise Distribution. Dùng thử trong 30 ngày hoặc vui lòng liên lạc để mua thêm"},"license.fieldLabel":{"other":"Chuỗi giấy phép"},"license.fieldLegend":{"other":"Vui lòng sao chép và dán mã bản quyền mà bạn đã được cung cấp."},"apply.stepLabel":{"other":"Áp dụng cài đặt"},"apply.title":{"other":"Vui lòng đợi trong khi cài đặt Pydio Cells..."},"apply.success":{"other":"Cài đặt thành công, các dịch vụ đang khởi động, quá trình này sẽ tải lại các trang khi các dịch vụ được khởi động."},"apply.success.restarted":{"other":"Cài đặt thành công, các dịch vụ đã được khởi động, vui lòng tải lại trang (trang sẽ tự động tải lại trong %1s)"},"apply.error":{"other":"Có lỗi trong khi thực hiện cài đặt! Vui lòng kiểm tra cấu hình của bạn."},"apply.error.detail":{"other":"Lỗi: "},"form.dbConnectionType.label":{"other":"Kiểu kết nối"},"form.dbConnectionType.tcp":{"other":"TCP"},"form.dbConnectionType.socket":{"other":"Socket"},"form.dbConnectionType.manual":{"other":"Thủ công"},"form.dbTCPHostname.label":{"other":"Tên Host"},"form.dbTCPHostname.legend":{"other":"Nơi máy chủ mysql đang chạy"},"form.dbName.label":{"other":"Tên database"},"form.dbName.legend":{"other":"Database to use (sẽ được tạo nếu nó không tồn tại)"},"form.dbTCPPort.label":{"other":"Cổng"},"form.dbTCPPort.legend":{"other":"Cổng kết nối đến mysql"},"form.dbUser.label":{"other":"Database User"},"form.dbUser.legend":{"other":"Bỏ trống nếu thấy không cần thiết"},"form.dbPassword.label":{"other":"Mật khẩu Database"},"form.dbPassword.legend":{"other":"Bỏ trống nếu thấy không cần thiết"},"form.dbSocketFile.label":{"other":"Socket"},"form.dbSocketFile.legend":{"other":"Nhập vị trí của tệp socket để kết nối"},"form.dbManualDSN.label":{"other":"DSN"},"form.dbManualDSN.legend":{"other":"Sử dụng DSN kiểu Golang để mô tả kết nối database"},"form.frontendApplicationTitle.label":{"other":"Tên Ứng Dụng"},"form.frontendApplicationTitle.legend":{"other":"Cài đặt tiêu đề chính của bạn"},"form.frontendDefaultLanguage.label":{"other":"Ngôn ngữ mặc định"},"form.frontendLogin.label":{"other":"Đăng nhập Admin user *"},"form.frontendLogin.legend":{"other":"Mã định danh được sử dụng để đăng nhập"},"form.frontendPassword.label":{"other":"Mật khẩu Admin"},"form.frontendPassword.legend":{"other":"Mật khẩu được sử dụng để đăng nhập"},"form.frontendRepeatPassword.label":{"other":"Xác nhận mật khẩu"},"form.frontendRepeatPassword.legend":{"other":"Xác nhận mật khẩu hai lần"},"form.dsFolder.label":{"other":"Đường dẫn mặc định của datasource"},"form.dsFolder.legend":{"other":"Sử dụng đường dẫn tuyệt đối trên máy chủ"},"form.dsType.FS":{"other":"Local FS (lưu trữ tất cả dữ liệu trên máy chủ này)"},"form.dsType.S3":{"other":"Amazon S3 / S3-compatible (store inside S3 buckets)"},"form.dsS3Custom.label":{"other":"S3-Compatible storage endpoint"},"form.dsS3Custom.legend":{"other":"Leave empty for Amazon"},"form.dsS3CustomRegion.label":{"other":"S3 Custom region"},"form.dsS3CustomRegion.legend":{"other":"Leave empty for default (us-east-1)"},"form.dsS3ApiKey.label":{"other":"S3 Api Key"},"form.dsS3ApiKey.legend":{"other":"Key để kết nối với S3"},"form.dsS3ApiSecret.label":{"other":"S3 Api Secret"},"form.dsS3ApiSecret.legend":{"other":"Khóa Bí mật"},"form.dsS3ValidateKeys":{"other":"Kết nối tới S3 để xác định buckets"},"form.s3BucketsPrefix.label":{"other":"Buckets prefix"},"form.s3BucketsPrefix.legend":{"other":"Một tiền tố duy nhất để tạo 6 buckets mặc định"},"form.bucketList.found":{"other":"Bucket(s) đã tồn tại"},"form.bucketList.toCreate":{"other":"Bucket(s) sẽ được tạo"},"form.bucketList.notFound":{"other":"Không tìm thấy buckets"},"form.bucketList.warnCreate":{"other":"Bạn không được phép tạo buckets, hãy tạo chúng theo cách thủ công!"},"stepper.button.next":{"other":"Tiếp theo"},"stepper.button.back":{"other":"Quay lại"},"stepper.button.last":{"other":"Cài đặt ngay"},"stepper.button.reload":{"other":"Tải lại"}};
languages["zh-cn"] = {"welcome.stepLabel":{"other":"使用条款"},"welcome.title":{"other":"欢迎使用 Pydio Cells安装向导"},"welcome.legend":{"other":"这将在当前服务器上安装所有服务。请在开始前同意以下许可条款"},"welcome.agreed":{"other":"我同意"},"database.stepLabel":{"other":"数据库连接"},"database.title":{"other":"数据库配置"},"database.legend":{"other":"Pydio 需要至少一个 SQL 存储来进行配置和数据索引。设置连接到您的 MySQL/MariaDB 服务器的配置。"},"database.legend.bold":{"other":"请确保您的数据库正在运行 MySQL 版本 5.6 或更高版本"},"database.installDetected":{"other":"似乎在这个数据库中已经安装了Cells。请确认继续或 "},"database.installDetected.retry":{"other":"使用新的值重试"},"database.useDefaultsSet":{"other":"A default database is already configured, just click next to validate connection."},"database.forceConfigure":{"other":"Configure another database."},"admin.stepLabel":{"other":"管理员用户"},"admin.title":{"other":"管理员用户和前端默认值"},"admin.legend":{"other":"为管理员提供凭据。如果您部署到已存在的数据库中，请将字段留空。"},"admin.adminFound":{"other":"已经在数据库中找到了一个管理员用户。如果您想要创建一个新的用户，请选中此项。"},"advanced.stepLabel":{"other":"高级设置"},"advanced.title":{"other":"高级设置 (可选)"},"advanced.legend":{"other":"Pydio Cells 服务将部署在这台机器上。您可以在下面查看一些高级设置以调整您的配置。"},"advanced.toggle":{"other":"显示高级设置"},"advanced.default.datasource":{"other":"启动时会创建存储用户个人数据和资料库数据的默认数据源。您可以稍后创建其他数据源。"},"license.stepLabel":{"other":"企业版许可证"},"license.title":{"other":"Pydio Cells企业许可证"},"license.success":{"other":"成功检测到许可文件。"},"license.details":{"other":"有效用户 %count 个，%expiration 后过期。"},"license.failed":{"other":"尝试验证此许可时出错。请联系客服。"},"license.required":{"other":"需要一个有效的许可来运行企业版。要获得30天试用许可证或销售报价，请联系"},"license.fieldLabel":{"other":"许可字符串"},"license.fieldLegend":{"other":"请复制/粘贴提供给您的许可证密钥。"},"apply.stepLabel":{"other":"开始安装"},"apply.title":{"other":"请稍等，正在安装 Pydio Cells..."},"apply.success":{"other":"安装已成功，服务正在启动，安装程序将在启动服务后重新加载页面。"},"apply.success.restarted":{"other":"安装成功，服务已启动，请重新加载页面 (它将在 %1s 中自动重新加载)"},"apply.error":{"other":"执行安装时出错！请检查您的配置。"},"apply.error.detail":{"other":"错误: "},"form.dbConnectionType.label":{"other":"连接类型"},"form.dbConnectionType.tcp":{"other":"TCP"},"form.dbConnectionType.socket":{"other":"Socket"},"form.dbConnectionType.manual":{"other":"手动"},"form.dbTCPHostname.label":{"other":"主机名"},"form.dbTCPHostname.legend":{"other":"运行 mysql 的服务器"},"form.dbName.label":{"other":"数据库名称"},"form.dbName.legend":{"other":"要使用的数据库 (如果不存在将被创建)"},"form.dbTCPPort.label":{"other":"端口"},"form.dbTCPPort.legend":{"other":"连接到 mysql 的端口"},"form.dbUser.label":{"other":"数据库用户"},"form.dbUser.legend":{"other":"如果不需要则留空"},"form.dbPassword.label":{"other":"数据库密码"},"form.dbPassword.legend":{"other":"如果不需要则留空"},"form.dbSocketFile.label":{"other":"Socket"},"form.dbSocketFile.legend":{"other":"输入要连接的Socket文件的位置"},"form.dbManualDSN.label":{"other":"DSN"},"form.dbManualDSN.legend":{"other":"使用 Golang 风格的 DSN 来描述数据库连接"},"form.frontendApplicationTitle.label":{"other":"应用标题"},"form.frontendApplicationTitle.legend":{"other":"您的主标题"},"form.frontendDefaultLanguage.label":{"other":"默认语言"},"form.frontendLogin.label":{"other":"管理员用户登录 *"},"form.frontendLogin.legend":{"other":"用于登录的标识符"},"form.frontendPassword.label":{"other":"管理员密码*"},"form.frontendPassword.legend":{"other":"用于登录的密码"},"form.frontendRepeatPassword.label":{"other":"确认密码"},"form.frontendRepeatPassword.legend":{"other":"再次确认密码"},"form.dsFolder.label":{"other":"默认数据源路径"},"form.dsFolder.legend":{"other":"使用服务器上的绝对路径"},"form.dsType.FS":{"other":"本地文件系统 (所有数据存储的此服务器上)"},"form.dsType.S3":{"other":"Amazon S3 / S3-compatible (store inside S3 buckets)"},"form.dsS3Custom.label":{"other":"S3-Compatible storage endpoint"},"form.dsS3Custom.legend":{"other":"Leave empty for Amazon"},"form.dsS3CustomRegion.label":{"other":"S3 Custom region"},"form.dsS3CustomRegion.legend":{"other":"Leave empty for default (us-east-1)"},"form.dsS3ApiKey.label":{"other":"S3 Api Key"},"form.dsS3ApiKey.legend":{"other":"连接到 S3 的Key"},"form.dsS3ApiSecret.label":{"other":"S3 Api Secret"},"form.dsS3ApiSecret.legend":{"other":"密钥"},"form.dsS3ValidateKeys":{"other":"连接到 S3 来查找存储桶"},"form.s3BucketsPrefix.label":{"other":"存储桶前缀"},"form.s3BucketsPrefix.legend":{"other":"用于创建6个默认存储桶的前缀"},"form.bucketList.found":{"other":"以下存储桶已存在"},"form.bucketList.toCreate":{"other":"以下存储桶将被创建"},"form.bucketList.notFound":{"other":"以下存储桶未找到"},"form.bucketList.warnCreate":{"other":"您无权创建桶，请务必手动创建它们！"},"stepper.button.next":{"other":"下一步"},"stepper.button.back":{"other":"后退"},"stepper.button.last":{"other":"立即安装"},"stepper.button.reload":{"other":"重新加载"}};
languages["zh-tw"] = {"welcome.stepLabel":{"other":"Terms of Use"},"welcome.title":{"other":"Welcome to Pydio Cells Installation Wizard"},"welcome.legend":{"other":"This will install all services on the current server. Please agree with the terms of the license below before starting"},"welcome.agreed":{"other":"I agree with the terms"},"database.stepLabel":{"other":"Database Connection"},"database.title":{"other":"Database Configuration"},"database.legend":{"other":"Pydio requires at least one SQL storage for configuration and data indexation. Configure here the connection to your MySQL/MariaDB server."},"database.legend.bold":{"other":"Please make sure that your database is running MySQL version 5.6 or higher"},"database.installDetected":{"other":"There seem to be a Cells installation already setup in this database. Please confirm to continue or "},"database.installDetected.retry":{"other":"retry with new value"},"database.useDefaultsSet":{"other":"A default database is already configured, just click next to validate connection."},"database.forceConfigure":{"other":"Configure another database."},"admin.stepLabel":{"other":"Admin User"},"admin.title":{"other":"Admin user and frontend defaults"},"admin.legend":{"other":"Provide credentials for the administrative user. Leave fields empty if you are deploying on top of an existing installation."},"admin.adminFound":{"other":"An administrative user was already found in the DB. Check if you wish to create a new one."},"advanced.stepLabel":{"other":"Advanced Settings"},"advanced.title":{"other":"Advanced Settings (optional)"},"advanced.legend":{"other":"Pydio Cells services will be deployed on this machine. You may review some advanced settings below for fine-tuning your configuration."},"advanced.toggle":{"other":"Show Advanced Settings"},"advanced.default.datasource":{"other":"A default data source to store users personal data and cells data is created at startup. You can create other datasources later on."},"license.stepLabel":{"other":"Enterprise License"},"license.title":{"other":"Pydio Cells Enterprise License"},"license.success":{"other":"License file was successfully detected."},"license.details":{"other":"This installation is valid for %count users until %expiration."},"license.failed":{"other":"Error while trying to verify this license key. Please contact the support."},"license.required":{"other":"A valid license key is required to run the Enterprise Distribution. To get a 30 days trial license or a sales quotation, please contact"},"license.fieldLabel":{"other":"License String"},"license.fieldLegend":{"other":"Please copy/paste the license key provided to you."},"apply.stepLabel":{"other":"Apply Installation"},"apply.title":{"other":"Please wait while installation Pydio Cells..."},"apply.success":{"other":"Install was successful and services are now starting, this installer will reload the page when services are started."},"apply.success.restarted":{"other":"Install was successful and services are now started, please reload the page now (it will be automatically reloaded in %1s)"},"apply.error":{"other":"There was an error while performing installation! Please check your configuration."},"apply.error.detail":{"other":"Error was: "},"form.dbConnectionType.label":{"other":"Connection Type"},"form.dbConnectionType.tcp":{"other":"TCP"},"form.dbConnectionType.socket":{"other":"Socket"},"form.dbConnectionType.manual":{"other":"Manual"},"form.dbTCPHostname.label":{"other":"Host Name"},"form.dbTCPHostname.legend":{"other":"Server where mysql is running"},"form.dbName.label":{"other":"Database Name"},"form.dbName.legend":{"other":"Database to use (will be created if it does not exist)"},"form.dbTCPPort.label":{"other":"Port"},"form.dbTCPPort.legend":{"other":"Port to connect to mysql"},"form.dbUser.label":{"other":"Database User"},"form.dbUser.legend":{"other":"Leave blank if not required"},"form.dbPassword.label":{"other":"Database Password"},"form.dbPassword.legend":{"other":"Leave blank if not required"},"form.dbSocketFile.label":{"other":"Socket"},"form.dbSocketFile.legend":{"other":"Enter the location of the socket file to use to connect"},"form.dbManualDSN.label":{"other":"DSN"},"form.dbManualDSN.legend":{"other":"Use Golang-style DSN to describe the database connection"},"form.frontendApplicationTitle.label":{"other":"Application Title"},"form.frontendApplicationTitle.legend":{"other":"Main title of your installation"},"form.frontendDefaultLanguage.label":{"other":"Default Language"},"form.frontendLogin.label":{"other":"Admin user login *"},"form.frontendLogin.legend":{"other":"Identifier used to log in"},"form.frontendPassword.label":{"other":"Admin password *"},"form.frontendPassword.legend":{"other":"Password used to log in"},"form.frontendRepeatPassword.label":{"other":"Confirm password"},"form.frontendRepeatPassword.legend":{"other":"Confirm password twice"},"form.dsFolder.label":{"other":"Path of the default datasource"},"form.dsFolder.legend":{"other":"Use an absolute path on the server"},"form.dsType.FS":{"other":"Local FS (store all data on this server)"},"form.dsType.S3":{"other":"Amazon S3 / S3-compatible (store inside S3 buckets)"},"form.dsS3Custom.label":{"other":"S3-Compatible storage endpoint"},"form.dsS3Custom.legend":{"other":"Leave empty for Amazon"},"form.dsS3CustomRegion.label":{"other":"S3 Custom region"},"form.dsS3CustomRegion.legend":{"other":"Leave empty for default (us-east-1)"},"form.dsS3ApiKey.label":{"other":"S3 Api Key"},"form.dsS3ApiKey.legend":{"other":"Key to connect to S3"},"form.dsS3ApiSecret.label":{"other":"S3 Api Secret"},"form.dsS3ApiSecret.legend":{"other":"Secret Key"},"form.dsS3ValidateKeys":{"other":"Connect to S3 to define buckets"},"form.s3BucketsPrefix.label":{"other":"Buckets prefix"},"form.s3BucketsPrefix.legend":{"other":"A unique prefix for creating the 6 default buckets"},"form.bucketList.found":{"other":"Following bucket(s) already exist"},"form.bucketList.toCreate":{"other":"Following bucket(s) will be created"},"form.bucketList.notFound":{"other":"Following buckets were not found"},"form.bucketList.warnCreate":{"other":"You are not allowed to create buckets, make sure to create them manually!"},"stepper.button.next":{"other":"Next"},"stepper.button.back":{"other":"Back"},"stepper.button.last":{"other":"Install Now"},"stepper.button.reload":{"other":"Reload"}};