package rest

import "github.com/pydio/cells/common/forms"

var formDevelConfigs = &forms.Form{
	Groups: []*forms.Group{{
		Label: "Default Group Name",
		Fields: []forms.Field{
			&forms.FormField{
				Name:        "f1",
				Label:       "Label (string)",
				Description: "Field 1 Description (string)",
				Mandatory:   true,
				Type:        forms.ParamString,
			},
			&forms.FormField{
				Name:        "f2",
				Label:       "Label (string)",
				Description: "Field 2 Description (string)",
				Mandatory:   true,
				Type:        forms.ParamString,
			},
			&forms.FormField{
				Name:        "f21",
				Label:       "Textarea",
				Description: "Textarea Description",
				Mandatory:   true,
				Type:        forms.ParamTextarea,
			},
			&forms.FormField{
				Name:        "f22",
				Label:       "Textarea 2",
				Description: "Field 22 Description (area)",
				Mandatory:   true,
				Type:        forms.ParamTextarea,
			},
			&forms.FormField{
				Name:        "f3",
				Label:       "Label (bool)",
				Description: "Field 3 Description (bool)",
				Mandatory:   true,
				Type:        forms.ParamBool,
			},
			&forms.FormField{
				Name:        "f4",
				Label:       "Label (bool)",
				Description: "Field 4 Description (bool)",
				Mandatory:   true,
				Type:        forms.ParamBool,
			},
			&forms.FormField{
				Name:        "f5",
				Label:       "Label (integer)",
				Description: "Field 5 Description (integer)",
				Mandatory:   true,
				Type:        forms.ParamInteger,
			},
			&forms.FormField{
				Name:        "f6",
				Label:       "Label (integer)",
				Description: "Field 6 Description (integer)",
				Mandatory:   true,
				Type:        forms.ParamInteger,
			},
			&forms.FormField{
				Name:        "f7",
				Label:       "Legend",
				Description: "Legend Description (legend)",
				Mandatory:   true,
				Type:        forms.ParamLegend,
			},
			&forms.FormField{
				Name:        "f8",
				Label:       "Selector Label",
				Description: "Selector Unique Description",
				Mandatory:   false,
				Default:     "user",
				Type:        forms.ParamSelect,
				ChoicePresetList: []map[string]string{
					{"k1": "value 1"},
					{"k2": "value 2"},
					{"k3": "value 3"},
				},
			},
			&forms.FormField{
				Name:        "f9",
				Label:       "AutoComplete",
				Description: "AutoComplete Description",
				Mandatory:   false,
				Default:     "user",
				Type:        forms.ParamAutoComplete,
				ChoicePresetList: []map[string]string{
					{"k1": "value 1"},
					{"k2": "value 2"},
					{"k3": "value 3"},
				},
			},
			&forms.SwitchField{
				Name:        "sender",
				Label:       "Switch Field (label)",
				Description: "Switch Field (description)",
				Mandatory:   true,
				Default:     "disabled",
				Values: []*forms.SwitchValue{
					{
						Name:   "name",
						Label:  "value 1 (no fields)",
						Value:  "k1",
						Fields: []forms.Field{},
					},
					{
						Name:  "name",
						Label: "value 2 (subform)",
						Value: "k2",
						Fields: []forms.Field{
							&forms.FormField{
								Name:        "f1",
								Label:       "Field 1 Label (string)",
								Description: "Field 1 Description (string)",
								Mandatory:   true,
								Type:        forms.ParamString,
							},
							&forms.FormField{
								Name:        "f2",
								Label:       "Field 2 Label (string)",
								Description: "Field 2 Description (string)",
								Mandatory:   true,
								Type:        forms.ParamString,
							},
							&forms.FormField{
								Name:        "f3",
								Label:       "Field 3 Label (bool)",
								Description: "Field 3 Description (bool)",
								Mandatory:   true,
								Type:        forms.ParamBool,
							},
							&forms.FormField{
								Name:        "f4",
								Label:       "Field 4 Label (bool)",
								Description: "Field 4 Description (bool)",
								Mandatory:   true,
								Type:        forms.ParamBool,
							},
							&forms.FormField{
								Name:        "f5",
								Label:       "Field 5 Label (integer)",
								Description: "Field 5 Description (integer)",
								Mandatory:   true,
								Type:        forms.ParamInteger,
							},
							&forms.FormField{
								Name:        "f6",
								Label:       "Field 6 Label (integer)",
								Description: "Field 6 Description (integer)",
								Mandatory:   true,
								Type:        forms.ParamInteger,
							},
							&forms.FormField{
								Name:        "f7",
								Label:       "Legend Label (legend)",
								Description: "Legend Description (legend)",
								Mandatory:   true,
								Type:        forms.ParamLegend,
							},
							&forms.FormField{
								Name:        "f8",
								Label:       "Selector Unique Label",
								Description: "Selector Unique Description",
								Mandatory:   false,
								Default:     "user",
								Type:        forms.ParamSelect,
								ChoicePresetList: []map[string]string{
									{"k1": "value 1"},
									{"k2": "value 2"},
									{"k3": "value 3"},
								},
							},
						},
					},
				},
			},
			&forms.ReplicableFields{
				Id:          "replicable",
				Title:       "Replicable Field Title",
				Description: "Replicable Field Description",
				Mandatory:   false,
				Fields: []forms.Field{
					&forms.FormField{
						Name:        "f1",
						Label:       "Field 1 Label (string)",
						Description: "Field 1 Description (string)",
						Mandatory:   true,
						Type:        forms.ParamString,
					},
					&forms.FormField{
						Name:        "f2",
						Label:       "Field 2 Label (string)",
						Description: "Field 2 Description (string)",
						Mandatory:   true,
						Type:        forms.ParamString,
					},
					&forms.FormField{
						Name:        "f3",
						Label:       "Field 3 Label (bool)",
						Description: "Field 3 Description (bool)",
						Mandatory:   true,
						Type:        forms.ParamBool,
					},
					&forms.FormField{
						Name:        "f4",
						Label:       "Field 4 Label (bool)",
						Description: "Field 4 Description (bool)",
						Mandatory:   true,
						Type:        forms.ParamBool,
					},
					&forms.FormField{
						Name:        "f5",
						Label:       "Field 5 Label (integer)",
						Description: "Field 5 Description (integer)",
						Mandatory:   true,
						Type:        forms.ParamInteger,
					},
					&forms.FormField{
						Name:        "f6",
						Label:       "Field 6 Label (integer)",
						Description: "Field 6 Description (integer)",
						Mandatory:   true,
						Type:        forms.ParamInteger,
					},
					&forms.FormField{
						Name:        "f7",
						Label:       "Legend Label (legend)",
						Description: "Legend Description (legend)",
						Mandatory:   true,
						Type:        forms.ParamLegend,
					},
					&forms.FormField{
						Name:        "f8",
						Label:       "Selector Unique Label",
						Description: "Selector Unique Description",
						Mandatory:   false,
						Default:     "user",
						Type:        forms.ParamSelect,
						ChoicePresetList: []map[string]string{
							{"k1": "value 1"},
							{"k2": "value 2"},
							{"k3": "value 3"},
						},
					},
				},
			},
			&forms.FormField{
				Name:        "f10",
				Label:       "Bytes (integer bytes)",
				Description: "Field 10 Description (integer bytes)",
				Mandatory:   true,
				Type:        forms.ParamIntegerBytes,
			},
			&forms.FormField{
				Name:        "f11",
				Label:       "Password (integer bytes)",
				Description: "Field 11 Password (integer bytes)",
				Mandatory:   true,
				Type:        forms.ParamPassword,
			},
			&forms.FormField{
				Name:        "f12a",
				Label:       "Valid Login (label)",
				Description: "Field 12a Valid Login (desc)",
				Mandatory:   true,
				Type:        forms.ParamValidLogin,
			},
			&forms.FormField{
				Name:        "f12",
				Label:       "Valid Password (label)",
				Description: "Field 12b Valid Password (desc)",
				Mandatory:   true,
				Type:        forms.ParamValidPassword,
			},
			&forms.FormField{
				Name:        "f15",
				Label:       "Image (label)",
				Description: "Image (desc)",
				Mandatory:   true,
				Type:        forms.ParamImage,
			},
		},
	}},
}
