// auto generated 2021-03-11 19:43:57.892726 +0100 CET m=+13.979950967

package api

import (
	"encoding/base64"

	jsadvisory "github.com/nats-io/jsm.go/api/jetstream/advisory"
	jsmetric "github.com/nats-io/jsm.go/api/jetstream/metric"
	srvadvisory "github.com/nats-io/jsm.go/api/server/advisory"
	srvmetric "github.com/nats-io/jsm.go/api/server/metric"
)

var schemas map[string][]byte

var schemaTypes = map[string]func() interface{}{
	"io.nats.server.advisory.v1.client_connect":                  func() interface{} { return &srvadvisory.ConnectEventMsgV1{} },
	"io.nats.server.advisory.v1.client_disconnect":               func() interface{} { return &srvadvisory.DisconnectEventMsgV1{} },
	"io.nats.server.advisory.v1.account_connections":             func() interface{} { return &srvadvisory.AccountConnectionsV1{} },
	"io.nats.server.metric.v1.service_latency":                   func() interface{} { return &srvmetric.ServiceLatencyV1{} },
	"io.nats.jetstream.advisory.v1.api_audit":                    func() interface{} { return &jsadvisory.JetStreamAPIAuditV1{} },
	"io.nats.jetstream.advisory.v1.max_deliver":                  func() interface{} { return &jsadvisory.ConsumerDeliveryExceededAdvisoryV1{} },
	"io.nats.jetstream.advisory.v1.terminated":                   func() interface{} { return &jsadvisory.JSConsumerDeliveryTerminatedAdvisoryV1{} },
	"io.nats.jetstream.advisory.v1.stream_action":                func() interface{} { return &jsadvisory.JSStreamActionAdvisoryV1{} },
	"io.nats.jetstream.advisory.v1.consumer_action":              func() interface{} { return &jsadvisory.JSConsumerActionAdvisoryV1{} },
	"io.nats.jetstream.advisory.v1.snapshot_create":              func() interface{} { return &jsadvisory.JSSnapshotCreateAdvisoryV1{} },
	"io.nats.jetstream.advisory.v1.snapshot_complete":            func() interface{} { return &jsadvisory.JSSnapshotCompleteAdvisoryV1{} },
	"io.nats.jetstream.advisory.v1.restore_create":               func() interface{} { return &jsadvisory.JSRestoreCreateAdvisoryV1{} },
	"io.nats.jetstream.advisory.v1.restore_complete":             func() interface{} { return &jsadvisory.JSRestoreCompleteAdvisoryV1{} },
	"io.nats.jetstream.advisory.v1.stream_leader_elected":        func() interface{} { return &jsadvisory.JSStreamLeaderElectedV1{} },
	"io.nats.jetstream.advisory.v1.consumer_leader_elected":      func() interface{} { return &jsadvisory.JSConsumerLeaderElectedV1{} },
	"io.nats.jetstream.advisory.v1.stream_quorum_lost":           func() interface{} { return &jsadvisory.JSStreamQuorumLostV1{} },
	"io.nats.jetstream.advisory.v1.consumer_quorum_lost":         func() interface{} { return &jsadvisory.JSConsumerQuorumLostV1{} },
	"io.nats.jetstream.advisory.v1.server_out_of_space":          func() interface{} { return &jsadvisory.JSServerOutOfSpaceAdvisoryV1{} },
	"io.nats.jetstream.metric.v1.consumer_ack":                   func() interface{} { return &jsmetric.ConsumerAckMetricV1{} },
	"io.nats.jetstream.api.v1.consumer_configuration":            func() interface{} { return &ConsumerConfig{} },
	"io.nats.jetstream.api.v1.stream_configuration":              func() interface{} { return &StreamConfig{} },
	"io.nats.jetstream.api.v1.stream_template_configuration":     func() interface{} { return &StreamTemplateConfig{} },
	"io.nats.jetstream.api.v1.account_info_response":             func() interface{} { return &JSApiAccountInfoResponse{} },
	"io.nats.jetstream.api.v1.consumer_create_request":           func() interface{} { return &JSApiConsumerCreateRequest{} },
	"io.nats.jetstream.api.v1.consumer_create_response":          func() interface{} { return &JSApiConsumerCreateResponse{} },
	"io.nats.jetstream.api.v1.consumer_delete_response":          func() interface{} { return &JSApiConsumerDeleteResponse{} },
	"io.nats.jetstream.api.v1.consumer_info_response":            func() interface{} { return &JSApiConsumerInfoResponse{} },
	"io.nats.jetstream.api.v1.consumer_list_request":             func() interface{} { return &JSApiConsumerListRequest{} },
	"io.nats.jetstream.api.v1.consumer_list_response":            func() interface{} { return &JSApiConsumerListResponse{} },
	"io.nats.jetstream.api.v1.consumer_names_request":            func() interface{} { return &JSApiConsumerNamesRequest{} },
	"io.nats.jetstream.api.v1.consumer_names_response":           func() interface{} { return &JSApiConsumerNamesResponse{} },
	"io.nats.jetstream.api.v1.consumer_getnext_request":          func() interface{} { return &JSApiConsumerGetNextRequest{} },
	"io.nats.jetstream.api.v1.consumer_leader_stepdown_response": func() interface{} { return &JSApiConsumerLeaderStepDownResponse{} },
	"io.nats.jetstream.api.v1.stream_create_request":             func() interface{} { return &JSApiStreamCreateRequest{} },
	"io.nats.jetstream.api.v1.stream_create_response":            func() interface{} { return &JSApiStreamCreateResponse{} },
	"io.nats.jetstream.api.v1.stream_delete_response":            func() interface{} { return &JSApiStreamDeleteResponse{} },
	"io.nats.jetstream.api.v1.stream_info_response":              func() interface{} { return &JSApiStreamInfoResponse{} },
	"io.nats.jetstream.api.v1.stream_list_request":               func() interface{} { return &JSApiStreamListRequest{} },
	"io.nats.jetstream.api.v1.stream_list_response":              func() interface{} { return &JSApiStreamListResponse{} },
	"io.nats.jetstream.api.v1.stream_msg_delete_response":        func() interface{} { return &JSApiMsgDeleteResponse{} },
	"io.nats.jetstream.api.v1.stream_msg_get_request":            func() interface{} { return &JSApiMsgGetRequest{} },
	"io.nats.jetstream.api.v1.stream_msg_get_response":           func() interface{} { return &JSApiMsgGetResponse{} },
	"io.nats.jetstream.api.v1.stream_names_request":              func() interface{} { return &JSApiStreamNamesRequest{} },
	"io.nats.jetstream.api.v1.stream_names_response":             func() interface{} { return &JSApiStreamNamesResponse{} },
	"io.nats.jetstream.api.v1.stream_purge_response":             func() interface{} { return &JSApiStreamPurgeResponse{} },
	"io.nats.jetstream.api.v1.stream_snapshot_response":          func() interface{} { return &JSApiStreamSnapshotResponse{} },
	"io.nats.jetstream.api.v1.stream_snapshot_request":           func() interface{} { return &JSApiStreamSnapshotRequest{} },
	"io.nats.jetstream.api.v1.stream_restore_request":            func() interface{} { return &JSApiStreamRestoreRequest{} },
	"io.nats.jetstream.api.v1.stream_restore_response":           func() interface{} { return &JSApiStreamRestoreResponse{} },
	"io.nats.jetstream.api.v1.stream_template_create_request":    func() interface{} { return &JSApiStreamTemplateCreateRequest{} },
	"io.nats.jetstream.api.v1.stream_template_create_response":   func() interface{} { return &JSApiStreamTemplateCreateResponse{} },
	"io.nats.jetstream.api.v1.stream_template_delete_response":   func() interface{} { return &JSApiStreamTemplateDeleteResponse{} },
	"io.nats.jetstream.api.v1.stream_template_info_response":     func() interface{} { return &JSApiStreamTemplateInfoResponse{} },
	"io.nats.jetstream.api.v1.stream_template_names_response":    func() interface{} { return &JSApiStreamTemplateNamesResponse{} },
	"io.nats.jetstream.api.v1.stream_template_names_request":     func() interface{} { return &JSApiStreamTemplateNamesRequest{} },
	"io.nats.jetstream.api.v1.stream_update_response":            func() interface{} { return &JSApiStreamUpdateResponse{} },
	"io.nats.jetstream.api.v1.stream_remove_peer_request":        func() interface{} { return &JSApiStreamRemovePeerRequest{} },
	"io.nats.jetstream.api.v1.stream_remove_peer_response":       func() interface{} { return &JSApiStreamRemovePeerResponse{} },
	"io.nats.jetstream.api.v1.stream_leader_stepdown_response":   func() interface{} { return &JSApiStreamLeaderStepDownResponse{} },
	"io.nats.jetstream.api.v1.pub_ack_response":                  func() interface{} { return &JSPubAckResponse{} },
	"io.nats.jetstream.api.v1.meta_leader_stepdown_request":      func() interface{} { return &JSApiLeaderStepDownRequest{} },
	"io.nats.jetstream.api.v1.meta_leader_stepdown_response":     func() interface{} { return &JSApiLeaderStepDownResponse{} },
	"io.nats.jetstream.api.v1.meta_server_remove_request":        func() interface{} { return &JSApiMetaServerRemoveRequest{} },
	"io.nats.jetstream.api.v1.meta_server_remove_response":       func() interface{} { return &JSApiMetaServerRemoveResponse{} },
	"io.nats.unknown_message":                                    func() interface{} { return &UnknownMessage{} },
}

// Validate performs a JSON Schema validation of the configuration
func (t ConsumerConfig) Validate(v ...StructValidator) (valid bool, errors []string) {
	if len(v) == 0 || v[0] == nil {
		return true, nil
	}

	return v[0].ValidateStruct(t, t.SchemaType())
}

// SchemaType is the NATS schema type io.nats.jetstream.api.v1.consumer_configuration
func (t ConsumerConfig) SchemaType() string {
	return "io.nats.jetstream.api.v1.consumer_configuration"
}

// SchemaID is the url to the JSON Schema for JetStream Consumer Configuration
func (t ConsumerConfig) SchemaID() string {
	return "https://raw.githubusercontent.com/nats-io/jetstream/master/schemas/jetstream/api/v1/consumer_configuration.json"
}

// Schema is a JSON Schema document for the JetStream Consumer Configuration
func (t ConsumerConfig) Schema() []byte {
	return schemas[t.SchemaType()]
}

// Validate performs a JSON Schema validation of the configuration
func (t StreamConfig) Validate(v ...StructValidator) (valid bool, errors []string) {
	if len(v) == 0 || v[0] == nil {
		return true, nil
	}

	return v[0].ValidateStruct(t, t.SchemaType())
}

// SchemaType is the NATS schema type io.nats.jetstream.api.v1.stream_configuration
func (t StreamConfig) SchemaType() string {
	return "io.nats.jetstream.api.v1.stream_configuration"
}

// SchemaID is the url to the JSON Schema for JetStream Consumer Configuration
func (t StreamConfig) SchemaID() string {
	return "https://raw.githubusercontent.com/nats-io/jetstream/master/schemas/jetstream/api/v1/stream_configuration.json"
}

// Schema is a JSON Schema document for the JetStream Consumer Configuration
func (t StreamConfig) Schema() []byte {
	return schemas[t.SchemaType()]
}

// Validate performs a JSON Schema validation of the configuration
func (t StreamTemplateConfig) Validate(v ...StructValidator) (valid bool, errors []string) {
	if len(v) == 0 || v[0] == nil {
		return true, nil
	}

	return v[0].ValidateStruct(t, t.SchemaType())
}

// SchemaType is the NATS schema type io.nats.jetstream.api.v1.stream_template_configuration
func (t StreamTemplateConfig) SchemaType() string {
	return "io.nats.jetstream.api.v1.stream_template_configuration"
}

// SchemaID is the url to the JSON Schema for JetStream Consumer Configuration
func (t StreamTemplateConfig) SchemaID() string {
	return "https://raw.githubusercontent.com/nats-io/jetstream/master/schemas/jetstream/api/v1/stream_template_configuration.json"
}

// Schema is a JSON Schema document for the JetStream Consumer Configuration
func (t StreamTemplateConfig) Schema() []byte {
	return schemas[t.SchemaType()]
}

// Validate performs a JSON Schema validation of the configuration
func (t JSApiAccountInfoResponse) Validate(v ...StructValidator) (valid bool, errors []string) {
	if len(v) == 0 || v[0] == nil {
		return true, nil
	}

	return v[0].ValidateStruct(t, t.SchemaType())
}

// SchemaType is the NATS schema type io.nats.jetstream.api.v1.account_info_response
func (t JSApiAccountInfoResponse) SchemaType() string {
	return "io.nats.jetstream.api.v1.account_info_response"
}

// SchemaID is the url to the JSON Schema for JetStream Consumer Configuration
func (t JSApiAccountInfoResponse) SchemaID() string {
	return "https://raw.githubusercontent.com/nats-io/jetstream/master/schemas/jetstream/api/v1/account_info_response.json"
}

// Schema is a JSON Schema document for the JetStream Consumer Configuration
func (t JSApiAccountInfoResponse) Schema() []byte {
	return schemas[t.SchemaType()]
}

// Validate performs a JSON Schema validation of the configuration
func (t JSApiConsumerCreateRequest) Validate(v ...StructValidator) (valid bool, errors []string) {
	if len(v) == 0 || v[0] == nil {
		return true, nil
	}

	return v[0].ValidateStruct(t, t.SchemaType())
}

// SchemaType is the NATS schema type io.nats.jetstream.api.v1.consumer_create_request
func (t JSApiConsumerCreateRequest) SchemaType() string {
	return "io.nats.jetstream.api.v1.consumer_create_request"
}

// SchemaID is the url to the JSON Schema for JetStream Consumer Configuration
func (t JSApiConsumerCreateRequest) SchemaID() string {
	return "https://raw.githubusercontent.com/nats-io/jetstream/master/schemas/jetstream/api/v1/consumer_create_request.json"
}

// Schema is a JSON Schema document for the JetStream Consumer Configuration
func (t JSApiConsumerCreateRequest) Schema() []byte {
	return schemas[t.SchemaType()]
}

// Validate performs a JSON Schema validation of the configuration
func (t JSApiConsumerCreateResponse) Validate(v ...StructValidator) (valid bool, errors []string) {
	if len(v) == 0 || v[0] == nil {
		return true, nil
	}

	return v[0].ValidateStruct(t, t.SchemaType())
}

// SchemaType is the NATS schema type io.nats.jetstream.api.v1.consumer_create_response
func (t JSApiConsumerCreateResponse) SchemaType() string {
	return "io.nats.jetstream.api.v1.consumer_create_response"
}

// SchemaID is the url to the JSON Schema for JetStream Consumer Configuration
func (t JSApiConsumerCreateResponse) SchemaID() string {
	return "https://raw.githubusercontent.com/nats-io/jetstream/master/schemas/jetstream/api/v1/consumer_create_response.json"
}

// Schema is a JSON Schema document for the JetStream Consumer Configuration
func (t JSApiConsumerCreateResponse) Schema() []byte {
	return schemas[t.SchemaType()]
}

// Validate performs a JSON Schema validation of the configuration
func (t JSApiConsumerDeleteResponse) Validate(v ...StructValidator) (valid bool, errors []string) {
	if len(v) == 0 || v[0] == nil {
		return true, nil
	}

	return v[0].ValidateStruct(t, t.SchemaType())
}

// SchemaType is the NATS schema type io.nats.jetstream.api.v1.consumer_delete_response
func (t JSApiConsumerDeleteResponse) SchemaType() string {
	return "io.nats.jetstream.api.v1.consumer_delete_response"
}

// SchemaID is the url to the JSON Schema for JetStream Consumer Configuration
func (t JSApiConsumerDeleteResponse) SchemaID() string {
	return "https://raw.githubusercontent.com/nats-io/jetstream/master/schemas/jetstream/api/v1/consumer_delete_response.json"
}

// Schema is a JSON Schema document for the JetStream Consumer Configuration
func (t JSApiConsumerDeleteResponse) Schema() []byte {
	return schemas[t.SchemaType()]
}

// Validate performs a JSON Schema validation of the configuration
func (t JSApiConsumerInfoResponse) Validate(v ...StructValidator) (valid bool, errors []string) {
	if len(v) == 0 || v[0] == nil {
		return true, nil
	}

	return v[0].ValidateStruct(t, t.SchemaType())
}

// SchemaType is the NATS schema type io.nats.jetstream.api.v1.consumer_info_response
func (t JSApiConsumerInfoResponse) SchemaType() string {
	return "io.nats.jetstream.api.v1.consumer_info_response"
}

// SchemaID is the url to the JSON Schema for JetStream Consumer Configuration
func (t JSApiConsumerInfoResponse) SchemaID() string {
	return "https://raw.githubusercontent.com/nats-io/jetstream/master/schemas/jetstream/api/v1/consumer_info_response.json"
}

// Schema is a JSON Schema document for the JetStream Consumer Configuration
func (t JSApiConsumerInfoResponse) Schema() []byte {
	return schemas[t.SchemaType()]
}

// Validate performs a JSON Schema validation of the configuration
func (t JSApiConsumerListRequest) Validate(v ...StructValidator) (valid bool, errors []string) {
	if len(v) == 0 || v[0] == nil {
		return true, nil
	}

	return v[0].ValidateStruct(t, t.SchemaType())
}

// SchemaType is the NATS schema type io.nats.jetstream.api.v1.consumer_list_request
func (t JSApiConsumerListRequest) SchemaType() string {
	return "io.nats.jetstream.api.v1.consumer_list_request"
}

// SchemaID is the url to the JSON Schema for JetStream Consumer Configuration
func (t JSApiConsumerListRequest) SchemaID() string {
	return "https://raw.githubusercontent.com/nats-io/jetstream/master/schemas/jetstream/api/v1/consumer_list_request.json"
}

// Schema is a JSON Schema document for the JetStream Consumer Configuration
func (t JSApiConsumerListRequest) Schema() []byte {
	return schemas[t.SchemaType()]
}

// Validate performs a JSON Schema validation of the configuration
func (t JSApiConsumerListResponse) Validate(v ...StructValidator) (valid bool, errors []string) {
	if len(v) == 0 || v[0] == nil {
		return true, nil
	}

	return v[0].ValidateStruct(t, t.SchemaType())
}

// SchemaType is the NATS schema type io.nats.jetstream.api.v1.consumer_list_response
func (t JSApiConsumerListResponse) SchemaType() string {
	return "io.nats.jetstream.api.v1.consumer_list_response"
}

// SchemaID is the url to the JSON Schema for JetStream Consumer Configuration
func (t JSApiConsumerListResponse) SchemaID() string {
	return "https://raw.githubusercontent.com/nats-io/jetstream/master/schemas/jetstream/api/v1/consumer_list_response.json"
}

// Schema is a JSON Schema document for the JetStream Consumer Configuration
func (t JSApiConsumerListResponse) Schema() []byte {
	return schemas[t.SchemaType()]
}

// Validate performs a JSON Schema validation of the configuration
func (t JSApiConsumerNamesRequest) Validate(v ...StructValidator) (valid bool, errors []string) {
	if len(v) == 0 || v[0] == nil {
		return true, nil
	}

	return v[0].ValidateStruct(t, t.SchemaType())
}

// SchemaType is the NATS schema type io.nats.jetstream.api.v1.consumer_names_request
func (t JSApiConsumerNamesRequest) SchemaType() string {
	return "io.nats.jetstream.api.v1.consumer_names_request"
}

// SchemaID is the url to the JSON Schema for JetStream Consumer Configuration
func (t JSApiConsumerNamesRequest) SchemaID() string {
	return "https://raw.githubusercontent.com/nats-io/jetstream/master/schemas/jetstream/api/v1/consumer_names_request.json"
}

// Schema is a JSON Schema document for the JetStream Consumer Configuration
func (t JSApiConsumerNamesRequest) Schema() []byte {
	return schemas[t.SchemaType()]
}

// Validate performs a JSON Schema validation of the configuration
func (t JSApiConsumerNamesResponse) Validate(v ...StructValidator) (valid bool, errors []string) {
	if len(v) == 0 || v[0] == nil {
		return true, nil
	}

	return v[0].ValidateStruct(t, t.SchemaType())
}

// SchemaType is the NATS schema type io.nats.jetstream.api.v1.consumer_names_response
func (t JSApiConsumerNamesResponse) SchemaType() string {
	return "io.nats.jetstream.api.v1.consumer_names_response"
}

// SchemaID is the url to the JSON Schema for JetStream Consumer Configuration
func (t JSApiConsumerNamesResponse) SchemaID() string {
	return "https://raw.githubusercontent.com/nats-io/jetstream/master/schemas/jetstream/api/v1/consumer_names_response.json"
}

// Schema is a JSON Schema document for the JetStream Consumer Configuration
func (t JSApiConsumerNamesResponse) Schema() []byte {
	return schemas[t.SchemaType()]
}

// Validate performs a JSON Schema validation of the configuration
func (t JSApiConsumerGetNextRequest) Validate(v ...StructValidator) (valid bool, errors []string) {
	if len(v) == 0 || v[0] == nil {
		return true, nil
	}

	return v[0].ValidateStruct(t, t.SchemaType())
}

// SchemaType is the NATS schema type io.nats.jetstream.api.v1.consumer_getnext_request
func (t JSApiConsumerGetNextRequest) SchemaType() string {
	return "io.nats.jetstream.api.v1.consumer_getnext_request"
}

// SchemaID is the url to the JSON Schema for JetStream Consumer Configuration
func (t JSApiConsumerGetNextRequest) SchemaID() string {
	return "https://raw.githubusercontent.com/nats-io/jetstream/master/schemas/jetstream/api/v1/consumer_getnext_request.json"
}

// Schema is a JSON Schema document for the JetStream Consumer Configuration
func (t JSApiConsumerGetNextRequest) Schema() []byte {
	return schemas[t.SchemaType()]
}

// Validate performs a JSON Schema validation of the configuration
func (t JSApiConsumerLeaderStepDownResponse) Validate(v ...StructValidator) (valid bool, errors []string) {
	if len(v) == 0 || v[0] == nil {
		return true, nil
	}

	return v[0].ValidateStruct(t, t.SchemaType())
}

// SchemaType is the NATS schema type io.nats.jetstream.api.v1.consumer_leader_stepdown_response
func (t JSApiConsumerLeaderStepDownResponse) SchemaType() string {
	return "io.nats.jetstream.api.v1.consumer_leader_stepdown_response"
}

// SchemaID is the url to the JSON Schema for JetStream Consumer Configuration
func (t JSApiConsumerLeaderStepDownResponse) SchemaID() string {
	return "https://raw.githubusercontent.com/nats-io/jetstream/master/schemas/jetstream/api/v1/consumer_leader_stepdown_response.json"
}

// Schema is a JSON Schema document for the JetStream Consumer Configuration
func (t JSApiConsumerLeaderStepDownResponse) Schema() []byte {
	return schemas[t.SchemaType()]
}

// Validate performs a JSON Schema validation of the configuration
func (t JSApiStreamCreateRequest) Validate(v ...StructValidator) (valid bool, errors []string) {
	if len(v) == 0 || v[0] == nil {
		return true, nil
	}

	return v[0].ValidateStruct(t, t.SchemaType())
}

// SchemaType is the NATS schema type io.nats.jetstream.api.v1.stream_create_request
func (t JSApiStreamCreateRequest) SchemaType() string {
	return "io.nats.jetstream.api.v1.stream_create_request"
}

// SchemaID is the url to the JSON Schema for JetStream Consumer Configuration
func (t JSApiStreamCreateRequest) SchemaID() string {
	return "https://raw.githubusercontent.com/nats-io/jetstream/master/schemas/jetstream/api/v1/stream_create_request.json"
}

// Schema is a JSON Schema document for the JetStream Consumer Configuration
func (t JSApiStreamCreateRequest) Schema() []byte {
	return schemas[t.SchemaType()]
}

// Validate performs a JSON Schema validation of the configuration
func (t JSApiStreamCreateResponse) Validate(v ...StructValidator) (valid bool, errors []string) {
	if len(v) == 0 || v[0] == nil {
		return true, nil
	}

	return v[0].ValidateStruct(t, t.SchemaType())
}

// SchemaType is the NATS schema type io.nats.jetstream.api.v1.stream_create_response
func (t JSApiStreamCreateResponse) SchemaType() string {
	return "io.nats.jetstream.api.v1.stream_create_response"
}

// SchemaID is the url to the JSON Schema for JetStream Consumer Configuration
func (t JSApiStreamCreateResponse) SchemaID() string {
	return "https://raw.githubusercontent.com/nats-io/jetstream/master/schemas/jetstream/api/v1/stream_create_response.json"
}

// Schema is a JSON Schema document for the JetStream Consumer Configuration
func (t JSApiStreamCreateResponse) Schema() []byte {
	return schemas[t.SchemaType()]
}

// Validate performs a JSON Schema validation of the configuration
func (t JSApiStreamDeleteResponse) Validate(v ...StructValidator) (valid bool, errors []string) {
	if len(v) == 0 || v[0] == nil {
		return true, nil
	}

	return v[0].ValidateStruct(t, t.SchemaType())
}

// SchemaType is the NATS schema type io.nats.jetstream.api.v1.stream_delete_response
func (t JSApiStreamDeleteResponse) SchemaType() string {
	return "io.nats.jetstream.api.v1.stream_delete_response"
}

// SchemaID is the url to the JSON Schema for JetStream Consumer Configuration
func (t JSApiStreamDeleteResponse) SchemaID() string {
	return "https://raw.githubusercontent.com/nats-io/jetstream/master/schemas/jetstream/api/v1/stream_delete_response.json"
}

// Schema is a JSON Schema document for the JetStream Consumer Configuration
func (t JSApiStreamDeleteResponse) Schema() []byte {
	return schemas[t.SchemaType()]
}

// Validate performs a JSON Schema validation of the configuration
func (t JSApiStreamInfoResponse) Validate(v ...StructValidator) (valid bool, errors []string) {
	if len(v) == 0 || v[0] == nil {
		return true, nil
	}

	return v[0].ValidateStruct(t, t.SchemaType())
}

// SchemaType is the NATS schema type io.nats.jetstream.api.v1.stream_info_response
func (t JSApiStreamInfoResponse) SchemaType() string {
	return "io.nats.jetstream.api.v1.stream_info_response"
}

// SchemaID is the url to the JSON Schema for JetStream Consumer Configuration
func (t JSApiStreamInfoResponse) SchemaID() string {
	return "https://raw.githubusercontent.com/nats-io/jetstream/master/schemas/jetstream/api/v1/stream_info_response.json"
}

// Schema is a JSON Schema document for the JetStream Consumer Configuration
func (t JSApiStreamInfoResponse) Schema() []byte {
	return schemas[t.SchemaType()]
}

// Validate performs a JSON Schema validation of the configuration
func (t JSApiStreamListRequest) Validate(v ...StructValidator) (valid bool, errors []string) {
	if len(v) == 0 || v[0] == nil {
		return true, nil
	}

	return v[0].ValidateStruct(t, t.SchemaType())
}

// SchemaType is the NATS schema type io.nats.jetstream.api.v1.stream_list_request
func (t JSApiStreamListRequest) SchemaType() string {
	return "io.nats.jetstream.api.v1.stream_list_request"
}

// SchemaID is the url to the JSON Schema for JetStream Consumer Configuration
func (t JSApiStreamListRequest) SchemaID() string {
	return "https://raw.githubusercontent.com/nats-io/jetstream/master/schemas/jetstream/api/v1/stream_list_request.json"
}

// Schema is a JSON Schema document for the JetStream Consumer Configuration
func (t JSApiStreamListRequest) Schema() []byte {
	return schemas[t.SchemaType()]
}

// Validate performs a JSON Schema validation of the configuration
func (t JSApiStreamListResponse) Validate(v ...StructValidator) (valid bool, errors []string) {
	if len(v) == 0 || v[0] == nil {
		return true, nil
	}

	return v[0].ValidateStruct(t, t.SchemaType())
}

// SchemaType is the NATS schema type io.nats.jetstream.api.v1.stream_list_response
func (t JSApiStreamListResponse) SchemaType() string {
	return "io.nats.jetstream.api.v1.stream_list_response"
}

// SchemaID is the url to the JSON Schema for JetStream Consumer Configuration
func (t JSApiStreamListResponse) SchemaID() string {
	return "https://raw.githubusercontent.com/nats-io/jetstream/master/schemas/jetstream/api/v1/stream_list_response.json"
}

// Schema is a JSON Schema document for the JetStream Consumer Configuration
func (t JSApiStreamListResponse) Schema() []byte {
	return schemas[t.SchemaType()]
}

// Validate performs a JSON Schema validation of the configuration
func (t JSApiMsgDeleteResponse) Validate(v ...StructValidator) (valid bool, errors []string) {
	if len(v) == 0 || v[0] == nil {
		return true, nil
	}

	return v[0].ValidateStruct(t, t.SchemaType())
}

// SchemaType is the NATS schema type io.nats.jetstream.api.v1.stream_msg_delete_response
func (t JSApiMsgDeleteResponse) SchemaType() string {
	return "io.nats.jetstream.api.v1.stream_msg_delete_response"
}

// SchemaID is the url to the JSON Schema for JetStream Consumer Configuration
func (t JSApiMsgDeleteResponse) SchemaID() string {
	return "https://raw.githubusercontent.com/nats-io/jetstream/master/schemas/jetstream/api/v1/stream_msg_delete_response.json"
}

// Schema is a JSON Schema document for the JetStream Consumer Configuration
func (t JSApiMsgDeleteResponse) Schema() []byte {
	return schemas[t.SchemaType()]
}

// Validate performs a JSON Schema validation of the configuration
func (t JSApiMsgGetRequest) Validate(v ...StructValidator) (valid bool, errors []string) {
	if len(v) == 0 || v[0] == nil {
		return true, nil
	}

	return v[0].ValidateStruct(t, t.SchemaType())
}

// SchemaType is the NATS schema type io.nats.jetstream.api.v1.stream_msg_get_request
func (t JSApiMsgGetRequest) SchemaType() string {
	return "io.nats.jetstream.api.v1.stream_msg_get_request"
}

// SchemaID is the url to the JSON Schema for JetStream Consumer Configuration
func (t JSApiMsgGetRequest) SchemaID() string {
	return "https://raw.githubusercontent.com/nats-io/jetstream/master/schemas/jetstream/api/v1/stream_msg_get_request.json"
}

// Schema is a JSON Schema document for the JetStream Consumer Configuration
func (t JSApiMsgGetRequest) Schema() []byte {
	return schemas[t.SchemaType()]
}

// Validate performs a JSON Schema validation of the configuration
func (t JSApiMsgGetResponse) Validate(v ...StructValidator) (valid bool, errors []string) {
	if len(v) == 0 || v[0] == nil {
		return true, nil
	}

	return v[0].ValidateStruct(t, t.SchemaType())
}

// SchemaType is the NATS schema type io.nats.jetstream.api.v1.stream_msg_get_response
func (t JSApiMsgGetResponse) SchemaType() string {
	return "io.nats.jetstream.api.v1.stream_msg_get_response"
}

// SchemaID is the url to the JSON Schema for JetStream Consumer Configuration
func (t JSApiMsgGetResponse) SchemaID() string {
	return "https://raw.githubusercontent.com/nats-io/jetstream/master/schemas/jetstream/api/v1/stream_msg_get_response.json"
}

// Schema is a JSON Schema document for the JetStream Consumer Configuration
func (t JSApiMsgGetResponse) Schema() []byte {
	return schemas[t.SchemaType()]
}

// Validate performs a JSON Schema validation of the configuration
func (t JSApiStreamNamesRequest) Validate(v ...StructValidator) (valid bool, errors []string) {
	if len(v) == 0 || v[0] == nil {
		return true, nil
	}

	return v[0].ValidateStruct(t, t.SchemaType())
}

// SchemaType is the NATS schema type io.nats.jetstream.api.v1.stream_names_request
func (t JSApiStreamNamesRequest) SchemaType() string {
	return "io.nats.jetstream.api.v1.stream_names_request"
}

// SchemaID is the url to the JSON Schema for JetStream Consumer Configuration
func (t JSApiStreamNamesRequest) SchemaID() string {
	return "https://raw.githubusercontent.com/nats-io/jetstream/master/schemas/jetstream/api/v1/stream_names_request.json"
}

// Schema is a JSON Schema document for the JetStream Consumer Configuration
func (t JSApiStreamNamesRequest) Schema() []byte {
	return schemas[t.SchemaType()]
}

// Validate performs a JSON Schema validation of the configuration
func (t JSApiStreamNamesResponse) Validate(v ...StructValidator) (valid bool, errors []string) {
	if len(v) == 0 || v[0] == nil {
		return true, nil
	}

	return v[0].ValidateStruct(t, t.SchemaType())
}

// SchemaType is the NATS schema type io.nats.jetstream.api.v1.stream_names_response
func (t JSApiStreamNamesResponse) SchemaType() string {
	return "io.nats.jetstream.api.v1.stream_names_response"
}

// SchemaID is the url to the JSON Schema for JetStream Consumer Configuration
func (t JSApiStreamNamesResponse) SchemaID() string {
	return "https://raw.githubusercontent.com/nats-io/jetstream/master/schemas/jetstream/api/v1/stream_names_response.json"
}

// Schema is a JSON Schema document for the JetStream Consumer Configuration
func (t JSApiStreamNamesResponse) Schema() []byte {
	return schemas[t.SchemaType()]
}

// Validate performs a JSON Schema validation of the configuration
func (t JSApiStreamPurgeResponse) Validate(v ...StructValidator) (valid bool, errors []string) {
	if len(v) == 0 || v[0] == nil {
		return true, nil
	}

	return v[0].ValidateStruct(t, t.SchemaType())
}

// SchemaType is the NATS schema type io.nats.jetstream.api.v1.stream_purge_response
func (t JSApiStreamPurgeResponse) SchemaType() string {
	return "io.nats.jetstream.api.v1.stream_purge_response"
}

// SchemaID is the url to the JSON Schema for JetStream Consumer Configuration
func (t JSApiStreamPurgeResponse) SchemaID() string {
	return "https://raw.githubusercontent.com/nats-io/jetstream/master/schemas/jetstream/api/v1/stream_purge_response.json"
}

// Schema is a JSON Schema document for the JetStream Consumer Configuration
func (t JSApiStreamPurgeResponse) Schema() []byte {
	return schemas[t.SchemaType()]
}

// Validate performs a JSON Schema validation of the configuration
func (t JSApiStreamSnapshotResponse) Validate(v ...StructValidator) (valid bool, errors []string) {
	if len(v) == 0 || v[0] == nil {
		return true, nil
	}

	return v[0].ValidateStruct(t, t.SchemaType())
}

// SchemaType is the NATS schema type io.nats.jetstream.api.v1.stream_snapshot_response
func (t JSApiStreamSnapshotResponse) SchemaType() string {
	return "io.nats.jetstream.api.v1.stream_snapshot_response"
}

// SchemaID is the url to the JSON Schema for JetStream Consumer Configuration
func (t JSApiStreamSnapshotResponse) SchemaID() string {
	return "https://raw.githubusercontent.com/nats-io/jetstream/master/schemas/jetstream/api/v1/stream_snapshot_response.json"
}

// Schema is a JSON Schema document for the JetStream Consumer Configuration
func (t JSApiStreamSnapshotResponse) Schema() []byte {
	return schemas[t.SchemaType()]
}

// Validate performs a JSON Schema validation of the configuration
func (t JSApiStreamSnapshotRequest) Validate(v ...StructValidator) (valid bool, errors []string) {
	if len(v) == 0 || v[0] == nil {
		return true, nil
	}

	return v[0].ValidateStruct(t, t.SchemaType())
}

// SchemaType is the NATS schema type io.nats.jetstream.api.v1.stream_snapshot_request
func (t JSApiStreamSnapshotRequest) SchemaType() string {
	return "io.nats.jetstream.api.v1.stream_snapshot_request"
}

// SchemaID is the url to the JSON Schema for JetStream Consumer Configuration
func (t JSApiStreamSnapshotRequest) SchemaID() string {
	return "https://raw.githubusercontent.com/nats-io/jetstream/master/schemas/jetstream/api/v1/stream_snapshot_request.json"
}

// Schema is a JSON Schema document for the JetStream Consumer Configuration
func (t JSApiStreamSnapshotRequest) Schema() []byte {
	return schemas[t.SchemaType()]
}

// Validate performs a JSON Schema validation of the configuration
func (t JSApiStreamRestoreRequest) Validate(v ...StructValidator) (valid bool, errors []string) {
	if len(v) == 0 || v[0] == nil {
		return true, nil
	}

	return v[0].ValidateStruct(t, t.SchemaType())
}

// SchemaType is the NATS schema type io.nats.jetstream.api.v1.stream_restore_request
func (t JSApiStreamRestoreRequest) SchemaType() string {
	return "io.nats.jetstream.api.v1.stream_restore_request"
}

// SchemaID is the url to the JSON Schema for JetStream Consumer Configuration
func (t JSApiStreamRestoreRequest) SchemaID() string {
	return "https://raw.githubusercontent.com/nats-io/jetstream/master/schemas/jetstream/api/v1/stream_restore_request.json"
}

// Schema is a JSON Schema document for the JetStream Consumer Configuration
func (t JSApiStreamRestoreRequest) Schema() []byte {
	return schemas[t.SchemaType()]
}

// Validate performs a JSON Schema validation of the configuration
func (t JSApiStreamRestoreResponse) Validate(v ...StructValidator) (valid bool, errors []string) {
	if len(v) == 0 || v[0] == nil {
		return true, nil
	}

	return v[0].ValidateStruct(t, t.SchemaType())
}

// SchemaType is the NATS schema type io.nats.jetstream.api.v1.stream_restore_response
func (t JSApiStreamRestoreResponse) SchemaType() string {
	return "io.nats.jetstream.api.v1.stream_restore_response"
}

// SchemaID is the url to the JSON Schema for JetStream Consumer Configuration
func (t JSApiStreamRestoreResponse) SchemaID() string {
	return "https://raw.githubusercontent.com/nats-io/jetstream/master/schemas/jetstream/api/v1/stream_restore_response.json"
}

// Schema is a JSON Schema document for the JetStream Consumer Configuration
func (t JSApiStreamRestoreResponse) Schema() []byte {
	return schemas[t.SchemaType()]
}

// Validate performs a JSON Schema validation of the configuration
func (t JSApiStreamTemplateCreateRequest) Validate(v ...StructValidator) (valid bool, errors []string) {
	if len(v) == 0 || v[0] == nil {
		return true, nil
	}

	return v[0].ValidateStruct(t, t.SchemaType())
}

// SchemaType is the NATS schema type io.nats.jetstream.api.v1.stream_template_create_request
func (t JSApiStreamTemplateCreateRequest) SchemaType() string {
	return "io.nats.jetstream.api.v1.stream_template_create_request"
}

// SchemaID is the url to the JSON Schema for JetStream Consumer Configuration
func (t JSApiStreamTemplateCreateRequest) SchemaID() string {
	return "https://raw.githubusercontent.com/nats-io/jetstream/master/schemas/jetstream/api/v1/stream_template_create_request.json"
}

// Schema is a JSON Schema document for the JetStream Consumer Configuration
func (t JSApiStreamTemplateCreateRequest) Schema() []byte {
	return schemas[t.SchemaType()]
}

// Validate performs a JSON Schema validation of the configuration
func (t JSApiStreamTemplateCreateResponse) Validate(v ...StructValidator) (valid bool, errors []string) {
	if len(v) == 0 || v[0] == nil {
		return true, nil
	}

	return v[0].ValidateStruct(t, t.SchemaType())
}

// SchemaType is the NATS schema type io.nats.jetstream.api.v1.stream_template_create_response
func (t JSApiStreamTemplateCreateResponse) SchemaType() string {
	return "io.nats.jetstream.api.v1.stream_template_create_response"
}

// SchemaID is the url to the JSON Schema for JetStream Consumer Configuration
func (t JSApiStreamTemplateCreateResponse) SchemaID() string {
	return "https://raw.githubusercontent.com/nats-io/jetstream/master/schemas/jetstream/api/v1/stream_template_create_response.json"
}

// Schema is a JSON Schema document for the JetStream Consumer Configuration
func (t JSApiStreamTemplateCreateResponse) Schema() []byte {
	return schemas[t.SchemaType()]
}

// Validate performs a JSON Schema validation of the configuration
func (t JSApiStreamTemplateDeleteResponse) Validate(v ...StructValidator) (valid bool, errors []string) {
	if len(v) == 0 || v[0] == nil {
		return true, nil
	}

	return v[0].ValidateStruct(t, t.SchemaType())
}

// SchemaType is the NATS schema type io.nats.jetstream.api.v1.stream_template_delete_response
func (t JSApiStreamTemplateDeleteResponse) SchemaType() string {
	return "io.nats.jetstream.api.v1.stream_template_delete_response"
}

// SchemaID is the url to the JSON Schema for JetStream Consumer Configuration
func (t JSApiStreamTemplateDeleteResponse) SchemaID() string {
	return "https://raw.githubusercontent.com/nats-io/jetstream/master/schemas/jetstream/api/v1/stream_template_delete_response.json"
}

// Schema is a JSON Schema document for the JetStream Consumer Configuration
func (t JSApiStreamTemplateDeleteResponse) Schema() []byte {
	return schemas[t.SchemaType()]
}

// Validate performs a JSON Schema validation of the configuration
func (t JSApiStreamTemplateInfoResponse) Validate(v ...StructValidator) (valid bool, errors []string) {
	if len(v) == 0 || v[0] == nil {
		return true, nil
	}

	return v[0].ValidateStruct(t, t.SchemaType())
}

// SchemaType is the NATS schema type io.nats.jetstream.api.v1.stream_template_info_response
func (t JSApiStreamTemplateInfoResponse) SchemaType() string {
	return "io.nats.jetstream.api.v1.stream_template_info_response"
}

// SchemaID is the url to the JSON Schema for JetStream Consumer Configuration
func (t JSApiStreamTemplateInfoResponse) SchemaID() string {
	return "https://raw.githubusercontent.com/nats-io/jetstream/master/schemas/jetstream/api/v1/stream_template_info_response.json"
}

// Schema is a JSON Schema document for the JetStream Consumer Configuration
func (t JSApiStreamTemplateInfoResponse) Schema() []byte {
	return schemas[t.SchemaType()]
}

// Validate performs a JSON Schema validation of the configuration
func (t JSApiStreamTemplateNamesResponse) Validate(v ...StructValidator) (valid bool, errors []string) {
	if len(v) == 0 || v[0] == nil {
		return true, nil
	}

	return v[0].ValidateStruct(t, t.SchemaType())
}

// SchemaType is the NATS schema type io.nats.jetstream.api.v1.stream_template_names_response
func (t JSApiStreamTemplateNamesResponse) SchemaType() string {
	return "io.nats.jetstream.api.v1.stream_template_names_response"
}

// SchemaID is the url to the JSON Schema for JetStream Consumer Configuration
func (t JSApiStreamTemplateNamesResponse) SchemaID() string {
	return "https://raw.githubusercontent.com/nats-io/jetstream/master/schemas/jetstream/api/v1/stream_template_names_response.json"
}

// Schema is a JSON Schema document for the JetStream Consumer Configuration
func (t JSApiStreamTemplateNamesResponse) Schema() []byte {
	return schemas[t.SchemaType()]
}

// Validate performs a JSON Schema validation of the configuration
func (t JSApiStreamTemplateNamesRequest) Validate(v ...StructValidator) (valid bool, errors []string) {
	if len(v) == 0 || v[0] == nil {
		return true, nil
	}

	return v[0].ValidateStruct(t, t.SchemaType())
}

// SchemaType is the NATS schema type io.nats.jetstream.api.v1.stream_template_names_request
func (t JSApiStreamTemplateNamesRequest) SchemaType() string {
	return "io.nats.jetstream.api.v1.stream_template_names_request"
}

// SchemaID is the url to the JSON Schema for JetStream Consumer Configuration
func (t JSApiStreamTemplateNamesRequest) SchemaID() string {
	return "https://raw.githubusercontent.com/nats-io/jetstream/master/schemas/jetstream/api/v1/stream_template_names_request.json"
}

// Schema is a JSON Schema document for the JetStream Consumer Configuration
func (t JSApiStreamTemplateNamesRequest) Schema() []byte {
	return schemas[t.SchemaType()]
}

// Validate performs a JSON Schema validation of the configuration
func (t JSApiStreamUpdateResponse) Validate(v ...StructValidator) (valid bool, errors []string) {
	if len(v) == 0 || v[0] == nil {
		return true, nil
	}

	return v[0].ValidateStruct(t, t.SchemaType())
}

// SchemaType is the NATS schema type io.nats.jetstream.api.v1.stream_update_response
func (t JSApiStreamUpdateResponse) SchemaType() string {
	return "io.nats.jetstream.api.v1.stream_update_response"
}

// SchemaID is the url to the JSON Schema for JetStream Consumer Configuration
func (t JSApiStreamUpdateResponse) SchemaID() string {
	return "https://raw.githubusercontent.com/nats-io/jetstream/master/schemas/jetstream/api/v1/stream_update_response.json"
}

// Schema is a JSON Schema document for the JetStream Consumer Configuration
func (t JSApiStreamUpdateResponse) Schema() []byte {
	return schemas[t.SchemaType()]
}

// Validate performs a JSON Schema validation of the configuration
func (t JSApiStreamRemovePeerRequest) Validate(v ...StructValidator) (valid bool, errors []string) {
	if len(v) == 0 || v[0] == nil {
		return true, nil
	}

	return v[0].ValidateStruct(t, t.SchemaType())
}

// SchemaType is the NATS schema type io.nats.jetstream.api.v1.stream_remove_peer_request
func (t JSApiStreamRemovePeerRequest) SchemaType() string {
	return "io.nats.jetstream.api.v1.stream_remove_peer_request"
}

// SchemaID is the url to the JSON Schema for JetStream Consumer Configuration
func (t JSApiStreamRemovePeerRequest) SchemaID() string {
	return "https://raw.githubusercontent.com/nats-io/jetstream/master/schemas/jetstream/api/v1/stream_remove_peer_request.json"
}

// Schema is a JSON Schema document for the JetStream Consumer Configuration
func (t JSApiStreamRemovePeerRequest) Schema() []byte {
	return schemas[t.SchemaType()]
}

// Validate performs a JSON Schema validation of the configuration
func (t JSApiStreamRemovePeerResponse) Validate(v ...StructValidator) (valid bool, errors []string) {
	if len(v) == 0 || v[0] == nil {
		return true, nil
	}

	return v[0].ValidateStruct(t, t.SchemaType())
}

// SchemaType is the NATS schema type io.nats.jetstream.api.v1.stream_remove_peer_response
func (t JSApiStreamRemovePeerResponse) SchemaType() string {
	return "io.nats.jetstream.api.v1.stream_remove_peer_response"
}

// SchemaID is the url to the JSON Schema for JetStream Consumer Configuration
func (t JSApiStreamRemovePeerResponse) SchemaID() string {
	return "https://raw.githubusercontent.com/nats-io/jetstream/master/schemas/jetstream/api/v1/stream_remove_peer_response.json"
}

// Schema is a JSON Schema document for the JetStream Consumer Configuration
func (t JSApiStreamRemovePeerResponse) Schema() []byte {
	return schemas[t.SchemaType()]
}

// Validate performs a JSON Schema validation of the configuration
func (t JSApiStreamLeaderStepDownResponse) Validate(v ...StructValidator) (valid bool, errors []string) {
	if len(v) == 0 || v[0] == nil {
		return true, nil
	}

	return v[0].ValidateStruct(t, t.SchemaType())
}

// SchemaType is the NATS schema type io.nats.jetstream.api.v1.stream_leader_stepdown_response
func (t JSApiStreamLeaderStepDownResponse) SchemaType() string {
	return "io.nats.jetstream.api.v1.stream_leader_stepdown_response"
}

// SchemaID is the url to the JSON Schema for JetStream Consumer Configuration
func (t JSApiStreamLeaderStepDownResponse) SchemaID() string {
	return "https://raw.githubusercontent.com/nats-io/jetstream/master/schemas/jetstream/api/v1/stream_leader_stepdown_response.json"
}

// Schema is a JSON Schema document for the JetStream Consumer Configuration
func (t JSApiStreamLeaderStepDownResponse) Schema() []byte {
	return schemas[t.SchemaType()]
}

// Validate performs a JSON Schema validation of the configuration
func (t JSPubAckResponse) Validate(v ...StructValidator) (valid bool, errors []string) {
	if len(v) == 0 || v[0] == nil {
		return true, nil
	}

	return v[0].ValidateStruct(t, t.SchemaType())
}

// SchemaType is the NATS schema type io.nats.jetstream.api.v1.pub_ack_response
func (t JSPubAckResponse) SchemaType() string {
	return "io.nats.jetstream.api.v1.pub_ack_response"
}

// SchemaID is the url to the JSON Schema for JetStream Consumer Configuration
func (t JSPubAckResponse) SchemaID() string {
	return "https://raw.githubusercontent.com/nats-io/jetstream/master/schemas/jetstream/api/v1/pub_ack_response.json"
}

// Schema is a JSON Schema document for the JetStream Consumer Configuration
func (t JSPubAckResponse) Schema() []byte {
	return schemas[t.SchemaType()]
}

// Validate performs a JSON Schema validation of the configuration
func (t JSApiLeaderStepDownRequest) Validate(v ...StructValidator) (valid bool, errors []string) {
	if len(v) == 0 || v[0] == nil {
		return true, nil
	}

	return v[0].ValidateStruct(t, t.SchemaType())
}

// SchemaType is the NATS schema type io.nats.jetstream.api.v1.meta_leader_stepdown_request
func (t JSApiLeaderStepDownRequest) SchemaType() string {
	return "io.nats.jetstream.api.v1.meta_leader_stepdown_request"
}

// SchemaID is the url to the JSON Schema for JetStream Consumer Configuration
func (t JSApiLeaderStepDownRequest) SchemaID() string {
	return "https://raw.githubusercontent.com/nats-io/jetstream/master/schemas/jetstream/api/v1/meta_leader_stepdown_request.json"
}

// Schema is a JSON Schema document for the JetStream Consumer Configuration
func (t JSApiLeaderStepDownRequest) Schema() []byte {
	return schemas[t.SchemaType()]
}

// Validate performs a JSON Schema validation of the configuration
func (t JSApiLeaderStepDownResponse) Validate(v ...StructValidator) (valid bool, errors []string) {
	if len(v) == 0 || v[0] == nil {
		return true, nil
	}

	return v[0].ValidateStruct(t, t.SchemaType())
}

// SchemaType is the NATS schema type io.nats.jetstream.api.v1.meta_leader_stepdown_response
func (t JSApiLeaderStepDownResponse) SchemaType() string {
	return "io.nats.jetstream.api.v1.meta_leader_stepdown_response"
}

// SchemaID is the url to the JSON Schema for JetStream Consumer Configuration
func (t JSApiLeaderStepDownResponse) SchemaID() string {
	return "https://raw.githubusercontent.com/nats-io/jetstream/master/schemas/jetstream/api/v1/meta_leader_stepdown_response.json"
}

// Schema is a JSON Schema document for the JetStream Consumer Configuration
func (t JSApiLeaderStepDownResponse) Schema() []byte {
	return schemas[t.SchemaType()]
}

// Validate performs a JSON Schema validation of the configuration
func (t JSApiMetaServerRemoveRequest) Validate(v ...StructValidator) (valid bool, errors []string) {
	if len(v) == 0 || v[0] == nil {
		return true, nil
	}

	return v[0].ValidateStruct(t, t.SchemaType())
}

// SchemaType is the NATS schema type io.nats.jetstream.api.v1.meta_server_remove_request
func (t JSApiMetaServerRemoveRequest) SchemaType() string {
	return "io.nats.jetstream.api.v1.meta_server_remove_request"
}

// SchemaID is the url to the JSON Schema for JetStream Consumer Configuration
func (t JSApiMetaServerRemoveRequest) SchemaID() string {
	return "https://raw.githubusercontent.com/nats-io/jetstream/master/schemas/jetstream/api/v1/meta_server_remove_request.json"
}

// Schema is a JSON Schema document for the JetStream Consumer Configuration
func (t JSApiMetaServerRemoveRequest) Schema() []byte {
	return schemas[t.SchemaType()]
}

// Validate performs a JSON Schema validation of the configuration
func (t JSApiMetaServerRemoveResponse) Validate(v ...StructValidator) (valid bool, errors []string) {
	if len(v) == 0 || v[0] == nil {
		return true, nil
	}

	return v[0].ValidateStruct(t, t.SchemaType())
}

// SchemaType is the NATS schema type io.nats.jetstream.api.v1.meta_server_remove_response
func (t JSApiMetaServerRemoveResponse) SchemaType() string {
	return "io.nats.jetstream.api.v1.meta_server_remove_response"
}

// SchemaID is the url to the JSON Schema for JetStream Consumer Configuration
func (t JSApiMetaServerRemoveResponse) SchemaID() string {
	return "https://raw.githubusercontent.com/nats-io/jetstream/master/schemas/jetstream/api/v1/meta_server_remove_response.json"
}

// Schema is a JSON Schema document for the JetStream Consumer Configuration
func (t JSApiMetaServerRemoveResponse) Schema() []byte {
	return schemas[t.SchemaType()]
}

func init() {
	schemas = make(map[string][]byte)
	schemas["io.nats.server.advisory.v1.client_connect"], _ = base64.StdEncoding.DecodeString("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")
	schemas["io.nats.server.advisory.v1.client_disconnect"], _ = base64.StdEncoding.DecodeString("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")
	schemas["io.nats.server.advisory.v1.account_connections"], _ = base64.StdEncoding.DecodeString("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")
	schemas["io.nats.server.metric.v1.service_latency"], _ = base64.StdEncoding.DecodeString("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")
	schemas["io.nats.jetstream.advisory.v1.api_audit"], _ = base64.StdEncoding.DecodeString("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")
	schemas["io.nats.jetstream.advisory.v1.max_deliver"], _ = base64.StdEncoding.DecodeString("ewogICIkc2NoZW1hIjogImh0dHA6Ly9qc29uLXNjaGVtYS5vcmcvZHJhZnQtMDcvc2NoZW1hIyIsCiAgIiRpZCI6ICJodHRwczovL25hdHMuaW8vc2NoZW1hcy9qZXRzdHJlYW0vYWR2aXNvcnkvdjEvbWF4X2RlbGl2ZXIuanNvbiIsCiAgImRlc2NyaXB0aW9uIjogIkFkdmlzb3J5IHB1Ymxpc2hlZCB3aGVuIGEgbWVzc2FnZSBoYXZlIHJlYWNoZWQgaXRzIG1heGltdW0gZGVsaXZlcnkgYXR0ZW1wdHMiLAogICJ0aXRsZSI6ICJpby5uYXRzLmpldHN0cmVhbS5hZHZpc29yeS52MS5tYXhfZGVsaXZlciIsCiAgInR5cGUiOiAib2JqZWN0IiwKICAicmVxdWlyZWQiOiBbCiAgICAidHlwZSIsCiAgICAiaWQiLAogICAgInRpbWVzdGFtcCIsCiAgICAic3RyZWFtIiwKICAgICJjb25zdW1lciIsCiAgICAic3RyZWFtX3NlcSIsCiAgICAiZGVsaXZlcmllcyIKICBdLAogICJhZGRpdGlvbmFsUHJvcGVydGllcyI6IGZhbHNlLAogICJwcm9wZXJ0aWVzIjogewogICAgInR5cGUiOiB7CiAgICAgICJ0eXBlIjogInN0cmluZyIsCiAgICAgICJjb25zdCI6ICJpby5uYXRzLmpldHN0cmVhbS5hZHZpc29yeS52MS5tYXhfZGVsaXZlciIKICAgIH0sCiAgICAiaWQiOiB7CiAgICAgICJ0eXBlIjogInN0cmluZyIsCiAgICAgICJkZXNjcmlwdGlvbiI6ICJVbmlxdWUgY29ycmVsYXRpb24gSUQgZm9yIHRoaXMgZXZlbnQiCiAgICB9LAogICAgInRpbWVzdGFtcCI6IHsKICAgICAgInR5cGUiOiAic3RyaW5nIiwKICAgICAgImRlc2NyaXB0aW9uIjogIlRoZSB0aW1lIHRoaXMgZXZlbnQgd2FzIGNyZWF0ZWQgaW4gUkZDMzMzOSBmb3JtYXQiCiAgICB9LAogICAgInN0cmVhbSI6IHsKICAgICAgInR5cGUiOiAic3RyaW5nIiwKICAgICAgImRlc2NyaXB0aW9uIjogIlRoZSBuYW1lIG9mIHRoZSBzdHJlYW0gd2hlcmUgdGhlIG1lc3NhZ2UgaXMgc3RvcmVkIgogICAgfSwKICAgICJjb25zdW1lciI6IHsKICAgICAgInR5cGUiOiAic3RyaW5nIiwKICAgICAgImRlc2NyaXB0aW9uIjogIlRoZSBuYW1lIG9mIHRoZSBjb25zdW1lciB3aGVyZSB0aGUgbWVzc2FnZSByZWFjaGVkIGl0cyBsaW1pdCIKICAgIH0sCiAgICAic3RyZWFtX3NlcSI6IHsKICAgICAgInR5cGUiOiAic3RyaW5nIiwKICAgICAgIm1pbmltdW0iOiAxLAogICAgICAiZGVzY3JpcHRpb24iOiAiVGhlIHNlcXVlbmNlIG9mIHRoZSBtZXNzYWdlIGluIHRoZSBzdHJlYW0gdGhhdCBmYWlsZWQiCiAgICB9LAogICAgImRlbGl2ZXJpZXMiOiB7CiAgICAgICJ0eXBlIjogImludGVnZXIiLAogICAgICAibWluaW11bSI6IDEsCiAgICAgICJkZXNjcmlwdGlvbiI6ICJUaGUgbnVtYmVyIG9mIGRlbGl2ZXJpZXMgdGhhdCB3ZXJlIGF0dGVtcHRlZCIKICAgIH0KICB9Cn0K")
	schemas["io.nats.jetstream.advisory.v1.terminated"], _ = base64.StdEncoding.DecodeString("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")
	schemas["io.nats.jetstream.advisory.v1.stream_action"], _ = base64.StdEncoding.DecodeString("ewogICIkc2NoZW1hIjogImh0dHA6Ly9qc29uLXNjaGVtYS5vcmcvZHJhZnQtMDcvc2NoZW1hIyIsCiAgIiRpZCI6ICJodHRwczovL25hdHMuaW8vc2NoZW1hcy9qZXRzdHJlYW0vYWR2aXNvcnkvdjEvc3RyZWFtX2FjdGlvbi5qc29uIiwKICAiZGVzY3JpcHRpb24iOiAiQW4gQWR2aXNvcnkgc2VudCB3aGVuIGEgU3RyZWFtIGlzIGNyZWF0ZWQsIG1vZGlmaWVkIG9yIGRlbGV0ZWQiLAogICJ0aXRsZSI6ICJpby5uYXRzLmpldHN0cmVhbS5hZHZpc29yeS52MS5zdHJlYW1fYWN0aW9uIiwKICAidHlwZSI6ICJvYmplY3QiLAogICJyZXF1aXJlZCI6IFsKICAgICJ0eXBlIiwKICAgICJpZCIsCiAgICAidGltZXN0YW1wIiwKICAgICJzdHJlYW0iLAogICAgImFjdGlvbiIKICBdLAogICJhZGRpdGlvbmFsUHJvcGVydGllcyI6IGZhbHNlLAogICJwcm9wZXJ0aWVzIjogewogICAgInR5cGUiOiB7CiAgICAgICJ0eXBlIjogInN0cmluZyIsCiAgICAgICJjb25zdCI6ICJpby5uYXRzLmpldHN0cmVhbS5hZHZpc29yeS52MS5zdHJlYW1fYWN0aW9uIgogICAgfSwKICAgICJpZCI6IHsKICAgICAgInR5cGUiOiAic3RyaW5nIiwKICAgICAgImRlc2NyaXB0aW9uIjogIlVuaXF1ZSBjb3JyZWxhdGlvbiBJRCBmb3IgdGhpcyBldmVudCIKICAgIH0sCiAgICAidGltZXN0YW1wIjogewogICAgICAidHlwZSI6ICJzdHJpbmciLAogICAgICAiZGVzY3JpcHRpb24iOiAiVGhlIHRpbWUgdGhpcyBldmVudCB3YXMgY3JlYXRlZCBpbiBSRkMzMzM5IGZvcm1hdCIKICAgIH0sCiAgICAiYWN0aW9uIjogewogICAgICAidHlwZSI6ICJzdHJpbmciLAogICAgICAiZGVzY3JpcHRpb24iOiAiVGhlIGFjdGlvbiB0aGF0IHRoZSBldmVudCBkZXNjcmliZXMiLAogICAgICAiZW51bSI6IFsKICAgICAgICAiY3JlYXRlIiwKICAgICAgICAiZGVsZXRlIiwKICAgICAgICAibW9kaWZ5IgogICAgICBdCiAgICB9LAogICAgInN0cmVhbSI6IHsKICAgICAgInR5cGUiOiAic3RyaW5nIiwKICAgICAgImRlc2NyaXB0aW9uIjogIlRoZSBuYW1lIG9mIHRoZSBTdHJlYW0gdGhhdCdzIGFjdGVkIG9uIgogICAgfSwKICAgICJ0ZW1wbGF0ZSI6IHsKICAgICAgInR5cGUiOiAic3RyaW5nIiwKICAgICAgImRlc2NyaXB0aW9uIjogIlRoZSBTdHJlYW0gVGVtcGxhdGUgdGhhdCBtYW5hZ2VzIHRoZSBTdHJlYW0iCiAgICB9CiAgfQp9Cg==")
	schemas["io.nats.jetstream.advisory.v1.consumer_action"], _ = base64.StdEncoding.DecodeString("ewogICIkc2NoZW1hIjogImh0dHA6Ly9qc29uLXNjaGVtYS5vcmcvZHJhZnQtMDcvc2NoZW1hIyIsCiAgIiRpZCI6ICJodHRwczovL25hdHMuaW8vc2NoZW1hcy9qZXRzdHJlYW0vYWR2aXNvcnkvdjEvY29uc3VtZXJfYWN0aW9uLmpzb24iLAogICJkZXNjcmlwdGlvbiI6ICJBbiBBZHZpc29yeSBzZW50IHdoZW4gYSBDb25zdW1lciBpcyBjcmVhdGVkIG9yIGRlbGV0ZWQiLAogICJ0aXRsZSI6ICJpby5uYXRzLmpldHN0cmVhbS5hZHZpc29yeS52MS5jb25zdW1lcl9hY3Rpb24iLAogICJ0eXBlIjogIm9iamVjdCIsCiAgInJlcXVpcmVkIjogWwogICAgInR5cGUiLAogICAgImlkIiwKICAgICJ0aW1lc3RhbXAiLAogICAgInN0cmVhbSIsCiAgICAiYWN0aW9uIgogIF0sCiAgImFkZGl0aW9uYWxQcm9wZXJ0aWVzIjogZmFsc2UsCiAgInByb3BlcnRpZXMiOiB7CiAgICAidHlwZSI6IHsKICAgICAgInR5cGUiOiAic3RyaW5nIiwKICAgICAgImNvbnN0IjogImlvLm5hdHMuamV0c3RyZWFtLmFkdmlzb3J5LnYxLmNvbnN1bWVyX2FjdGlvbiIKICAgIH0sCiAgICAiaWQiOiB7CiAgICAgICJ0eXBlIjogInN0cmluZyIsCiAgICAgICJkZXNjcmlwdGlvbiI6ICJVbmlxdWUgY29ycmVsYXRpb24gSUQgZm9yIHRoaXMgZXZlbnQiCiAgICB9LAogICAgInRpbWVzdGFtcCI6IHsKICAgICAgInR5cGUiOiAic3RyaW5nIiwKICAgICAgImRlc2NyaXB0aW9uIjogIlRoZSB0aW1lIHRoaXMgZXZlbnQgd2FzIGNyZWF0ZWQgaW4gUkZDMzMzOSBmb3JtYXQiCiAgICB9LAogICAgImFjdGlvbiI6IHsKICAgICAgInR5cGUiOiAic3RyaW5nIiwKICAgICAgImRlc2NyaXB0aW9uIjogIlRoZSBhY3Rpb24gdGhhdCB0aGUgZXZlbnQgZGVzY3JpYmVzIiwKICAgICAgImVudW0iOiBbCiAgICAgICAgImNyZWF0ZSIsCiAgICAgICAgImRlbGV0ZSIKICAgICAgXQogICAgfSwKICAgICJzdHJlYW0iOiB7CiAgICAgICJ0eXBlIjogInN0cmluZyIsCiAgICAgICJkZXNjcmlwdGlvbiI6ICJUaGUgbmFtZSBvZiB0aGUgU3RyZWFtIHRoYXQgdGhlIENvbnN1bWVyIGJlbG9uZ3MgdG8iCiAgICB9LAogICAgImNvbnN1bWVyIjogewogICAgICAidHlwZSI6ICJzdHJpbmciLAogICAgICAiZGVzY3JpcHRpb24iOiAiVGhlIG5hbWUgb2YgdGhlIENvbnN1bWVyIHRoYXQncyBhY3RlZCBvbiIKICAgIH0KICB9Cn0K")
	schemas["io.nats.jetstream.advisory.v1.snapshot_create"], _ = base64.StdEncoding.DecodeString("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")
	schemas["io.nats.jetstream.advisory.v1.snapshot_complete"], _ = base64.StdEncoding.DecodeString("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")
	schemas["io.nats.jetstream.advisory.v1.restore_create"], _ = base64.StdEncoding.DecodeString("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")
	schemas["io.nats.jetstream.advisory.v1.restore_complete"], _ = base64.StdEncoding.DecodeString("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")
	schemas["io.nats.jetstream.advisory.v1.stream_leader_elected"], _ = base64.StdEncoding.DecodeString("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")
	schemas["io.nats.jetstream.advisory.v1.consumer_leader_elected"], _ = base64.StdEncoding.DecodeString("ewogICIkc2NoZW1hIjogImh0dHA6Ly9qc29uLXNjaGVtYS5vcmcvZHJhZnQtMDcvc2NoZW1hIyIsCiAgIiRpZCI6ICJodHRwczovL25hdHMuaW8vc2NoZW1hcy9qZXRzdHJlYW0vYWR2aXNvcnkvdjEvY29uc3VtZXJfbGVhZGVyX2VsZWN0ZWQuanNvbiIsCiAgImRlc2NyaXB0aW9uIjogIkFuIEFkdmlzb3J5IHNlbnQgd2hlbiBhIGNsdXN0ZXJlZCBDb25zdW1lciBlbGVjdGVkIGEgbmV3IGxlYWRlciIsCiAgInRpdGxlIjogImlvLm5hdHMuamV0c3RyZWFtLmFkdmlzb3J5LnYxLmNvbnN1bWVyX2xlYWRlcl9lbGVjdGVkIiwKICAidHlwZSI6ICJvYmplY3QiLAogICJyZXF1aXJlZCI6IFsKICAgICJ0eXBlIiwKICAgICJpZCIsCiAgICAidGltZXN0YW1wIiwKICAgICJzdHJlYW0iLAogICAgImNvbnN1bWVyIiwKICAgICJsZWFkZXIiLAogICAgInJlcGxpY2FzIgogIF0sCiAgImFkZGl0aW9uYWxQcm9wZXJ0aWVzIjogZmFsc2UsCiAgInByb3BlcnRpZXMiOiB7CiAgICAidHlwZSI6IHsKICAgICAgInR5cGUiOiAic3RyaW5nIiwKICAgICAgImNvbnN0IjogImlvLm5hdHMuamV0c3RyZWFtLmFkdmlzb3J5LnYxLmNvbnN1bWVyX2xlYWRlcl9lbGVjdGVkIgogICAgfSwKICAgICJpZCI6IHsKICAgICAgInR5cGUiOiAic3RyaW5nIiwKICAgICAgImRlc2NyaXB0aW9uIjogIlVuaXF1ZSBjb3JyZWxhdGlvbiBJRCBmb3IgdGhpcyBldmVudCIKICAgIH0sCiAgICAidGltZXN0YW1wIjogewogICAgICAidHlwZSI6ICJzdHJpbmciLAogICAgICAiZGVzY3JpcHRpb24iOiAiVGhlIHRpbWUgdGhpcyBldmVudCB3YXMgY3JlYXRlZCBpbiBSRkMzMzM5IGZvcm1hdCIKICAgIH0sCiAgICAic3RyZWFtIjogewogICAgICAidHlwZSI6ICJzdHJpbmciLAogICAgICAiZGVzY3JpcHRpb24iOiAiVGhlIG5hbWUgb2YgdGhlIFN0cmVhbSB0aGUgQ29uc3VtZXIgYmVsb25ncyB0byIKICAgIH0sCiAgICAiY29uc3VtZXIiOiB7CiAgICAgICJ0eXBlIjogInN0cmluZyIsCiAgICAgICJkZXNjcmlwdGlvbiI6ICJUaGUgbmFtZSBvZiB0aGUgQ29uc3VtZXIgdGhhdCBlbGVjdGVkIGEgbmV3IGxlYWRlciIKICAgIH0sCiAgICAibGVhZGVyIjogewogICAgICAidHlwZSI6ICJzdHJpbmciLAogICAgICAiZGVzY3JpcHRpb24iOiAiVGhlIHNlcnZlciBuYW1lIG9mIHRoZSBlbGVjdGVkIGxlYWRlciIKICAgIH0sCiAgICAicmVwbGljYXMiOiB7CiAgICAgICJ0eXBlIjogIm9iamVjdCIsCiAgICAgICJyZXF1aXJlZCI6IFsKICAgICAgICAibmFtZSIsCiAgICAgICAgImN1cnJlbnQiLAogICAgICAgICJhY3RpdmUiCiAgICAgIF0sCiAgICAgICJwcm9wZXJ0aWVzIjogewogICAgICAgICJuYW1lIjogewogICAgICAgICAgImRlc2NyaXB0aW9uIjogIlRoZSBzZXJ2ZXIgbmFtZSBvZiB0aGUgcGVlciIsCiAgICAgICAgICAidHlwZSI6ICJzdHJpbmciLAogICAgICAgICAgIm1pbmltdW0iOiAxCiAgICAgICAgfSwKICAgICAgICAiY3VycmVudCI6IHsKICAgICAgICAgICJkZXNjcmlwdGlvbiI6ICJJbmRpY2F0ZXMgaWYgdGhlIHNlcnZlciBpcyB1cCB0byBkYXRlIGFuZCBzeW5jaHJvbmlzZWQiLAogICAgICAgICAgInR5cGUiOiAiYm9vbGVhbiIsCiAgICAgICAgICAiZGVmYXVsdCI6IGZhbHNlCiAgICAgICAgfSwKICAgICAgICAiYWN0aXZlIjogewogICAgICAgICAgImRlc2NyaXB0aW9uIjogIk5hbm9zZWNvbmRzIHNpbmNlIHRoaXMgcGVlciB3YXMgbGFzdCBzZWVuIiwKICAgICAgICAgICJ0eXBlIjogIm51bWJlciIKICAgICAgICB9LAogICAgICAgICJvZmZsaW5lIjogewogICAgICAgICAgImRlc2NyaXB0aW9uIjogIkluZGljYXRlcyB0aGUgbm9kZSBpcyBjb25zaWRlcmVkIG9mZmxpbmUgYnkgdGhlIGdyb3VwIiwKICAgICAgICAgICJ0eXBlIjogImJvb2xlYW4iLAogICAgICAgICAgImRlZmF1bHQiOiBmYWxzZQogICAgICAgIH0sCiAgICAgICAgImxhZyI6IHsKICAgICAgICAgICJkZXNjcmlwdGlvbiI6ICJIb3cgbWFueSB1bmNvbW1pdHRlZCBvcGVyYXRpb25zIHRoaXMgcGVlciBpcyBiZWhpbmQgdGhlIGxlYWRlciIsCiAgICAgICAgICAidHlwZSI6ICJpbnRlZ2VyIiwKICAgICAgICAgICJtaW5pbXVtIjogMAogICAgICAgIH0KICAgICAgfQogICAgfQogIH0KfQo=")
	schemas["io.nats.jetstream.advisory.v1.stream_quorum_lost"], _ = base64.StdEncoding.DecodeString("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")
	schemas["io.nats.jetstream.advisory.v1.consumer_quorum_lost"], _ = base64.StdEncoding.DecodeString("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")
	schemas["io.nats.jetstream.advisory.v1.server_out_of_space"], _ = base64.StdEncoding.DecodeString("ewogICIkc2NoZW1hIjogImh0dHA6Ly9qc29uLXNjaGVtYS5vcmcvZHJhZnQtMDcvc2NoZW1hIyIsCiAgIiRpZCI6ICJodHRwczovL25hdHMuaW8vc2NoZW1hcy9qZXRzdHJlYW0vYWR2aXNvcnkvdjEvc2VydmVyX291dF9vZl9zcGFjZS5qc29uIiwKICAiZGVzY3JpcHRpb24iOiAiQW4gQWR2aXNvcnkgc2VudCB3aGVuIGEgU2VydmVyIGhhcyBydW4gb3V0IG9mIGRpc2sgc3BhY2UiLAogICJ0aXRsZSI6ICJpby5uYXRzLmpldHN0cmVhbS5hZHZpc29yeS52MS5zZXJ2ZXJfb3V0X29mX3NwYWNlIiwKICAidHlwZSI6ICJvYmplY3QiLAogICJyZXF1aXJlZCI6IFsKICAgICJ0eXBlIiwKICAgICJpZCIsCiAgICAidGltZXN0YW1wIiwKICAgICJzZXJ2ZXIiLAogICAgInNlcnZlcl9pZCIKICBdLAogICJhZGRpdGlvbmFsUHJvcGVydGllcyI6IGZhbHNlLAogICJwcm9wZXJ0aWVzIjogewogICAgInR5cGUiOiB7CiAgICAgICJ0eXBlIjogInN0cmluZyIsCiAgICAgICJjb25zdCI6ICJpby5uYXRzLmpldHN0cmVhbS5hZHZpc29yeS52MS5zZXJ2ZXJfb3V0X29mX3NwYWNlIgogICAgfSwKICAgICJpZCI6IHsKICAgICAgInR5cGUiOiAic3RyaW5nIiwKICAgICAgImRlc2NyaXB0aW9uIjogIlVuaXF1ZSBjb3JyZWxhdGlvbiBJRCBmb3IgdGhpcyBldmVudCIKICAgIH0sCiAgICAidGltZXN0YW1wIjogewogICAgICAidHlwZSI6ICJzdHJpbmciLAogICAgICAiZGVzY3JpcHRpb24iOiAiVGhlIHRpbWUgdGhpcyBldmVudCB3YXMgY3JlYXRlZCBpbiBSRkMzMzM5IGZvcm1hdCIKICAgIH0sCiAgICAic3RyZWFtIjogewogICAgICAidHlwZSI6ICJzdHJpbmciLAogICAgICAiZGVzY3JpcHRpb24iOiAiVGhlIFN0cmVhbSB0aGF0IHRyaWdnZXJlZCB0aGUgb3V0IG9mIHNwYWNlIGV2ZW50IgogICAgfSwKICAgICJzZXJ2ZXIiOiB7CiAgICAgICJ0eXBlIjogInN0cmluZyIsCiAgICAgICJkZXNjcmlwdGlvbiI6ICJUaGUgc2VydmVyIG5hbWUgdGhhdCByYW4gb3V0IG9mIHNwYWNlIgogICAgfSwKICAgICJzZXJ2ZXJfaWQiOiB7CiAgICAgICJ0eXBlIjogInN0cmluZyIsCiAgICAgICJkZXNjcmlwdGlvbiI6ICJUaGUgc2VydmVyIElEIHRoYXQgcmFuIG91dCBvZiBzcGFjZSIKICAgIH0sCiAgICAiY2x1c3RlciI6IHsKICAgICAgInR5cGUiOiAic3RyaW5nIiwKICAgICAgImRlc2NyaXB0aW9uIjogIlRoZSBjbHVzdGVyIHRoZSBzZXJ2ZXIgaXMgaW4iCiAgICB9CiAgfQp9Cg==")
	schemas["io.nats.jetstream.metric.v1.consumer_ack"], _ = base64.StdEncoding.DecodeString("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")
	schemas["io.nats.jetstream.api.v1.consumer_configuration"], _ = base64.StdEncoding.DecodeString("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")
	schemas["io.nats.jetstream.api.v1.stream_configuration"], _ = base64.StdEncoding.DecodeString("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")
	schemas["io.nats.jetstream.api.v1.stream_template_configuration"], _ = base64.StdEncoding.DecodeString("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")
	schemas["io.nats.jetstream.api.v1.account_info_response"], _ = base64.StdEncoding.DecodeString("ewogICIkc2NoZW1hIjogImh0dHA6Ly9qc29uLXNjaGVtYS5vcmcvZHJhZnQtMDcvc2NoZW1hIyIsCiAgIiRpZCI6ICJodHRwczovL25hdHMuaW8vc2NoZW1hcy9qZXRzdHJlYW0vYXBpL3YxL2FjY291bnRfaW5mb19yZXNwb25zZS5qc29uIiwKICAiZGVzY3JpcHRpb24iOiAiQSByZXNwb25zZSBmcm9tIHRoZSBKZXRTdHJlYW0gJEpTLkFQSS5JTkZPIEFQSSIsCiAgInRpdGxlIjogImlvLm5hdHMuamV0c3RyZWFtLmFwaS52MS5hY2NvdW50X2luZm9fcmVzcG9uc2UiLAogICJ0eXBlIjogIm9iamVjdCIsCiAgInJlcXVpcmVkIjogWwogICAgInR5cGUiCiAgXSwKICAib25lT2YiOiBbCiAgICB7CiAgICAgICJ0eXBlIjogIm9iamVjdCIsCiAgICAgICJyZXF1aXJlZCI6IFsKICAgICAgICAibWVtb3J5IiwKICAgICAgICAic3RvcmFnZSIsCiAgICAgICAgInN0cmVhbXMiLAogICAgICAgICJsaW1pdHMiLAogICAgICAgICJhcGkiLAogICAgICAgICJjb25zdW1lcnMiCiAgICAgIF0sCiAgICAgICJwcm9wZXJ0aWVzIjogewogICAgICAgICJtZW1vcnkiOiB7CiAgICAgICAgICAiZGVzY3JpcHRpb24iOiAiTWVtb3J5IFN0b3JhZ2UgYmVpbmcgdXNlZCBmb3IgU3RyZWFtIE1lc3NhZ2Ugc3RvcmFnZSIsCiAgICAgICAgICAidHlwZSI6ICJpbnRlZ2VyIiwKICAgICAgICAgICJtaW5pbXVtIjogMAogICAgICAgIH0sCiAgICAgICAgInN0b3JhZ2UiOiB7CiAgICAgICAgICAiZGVzY3JpcHRpb24iOiAiRmlsZSBTdG9yYWdlIGJlaW5nIHVzZWQgZm9yIFN0cmVhbSBNZXNzYWdlIHN0b3JhZ2UiLAogICAgICAgICAgInR5cGUiOiAiaW50ZWdlciIsCiAgICAgICAgICAibWluaW11bSI6IDAKICAgICAgICB9LAogICAgICAgICJzdHJlYW1zIjogewogICAgICAgICAgImRlc2NyaXB0aW9uIjogIk51bWJlciBvZiBhY3RpdmUgU3RyZWFtcyIsCiAgICAgICAgICAidHlwZSI6ICJpbnRlZ2VyIiwKICAgICAgICAgICJtaW5pbXVtIjogMAogICAgICAgIH0sCiAgICAgICAgImNvbnN1bWVycyI6IHsKICAgICAgICAgICJkZXNjcmlwdGlvbiI6ICJOdW1iZXIgb2YgYWN0aXZlIENvbnN1bWVycyIsCiAgICAgICAgICAidHlwZSI6ICJpbnRlZ2VyIiwKICAgICAgICAgICJtaW5pbXVtIjogMAogICAgICAgIH0sCiAgICAgICAgImxpbWl0cyI6IHsKICAgICAgICAgICJ0eXBlIjogIm9iamVjdCIsCiAgICAgICAgICAiYWRkaXRpb25hbFByb3BlcnRpZXMiOiBmYWxzZSwKICAgICAgICAgICJyZXF1aXJlZCI6IFsKICAgICAgICAgICAgIm1heF9jb25zdW1lcnMiLAogICAgICAgICAgICAibWF4X21lbW9yeSIsCiAgICAgICAgICAgICJtYXhfc3RvcmFnZSIsCiAgICAgICAgICAgICJtYXhfc3RyZWFtcyIKICAgICAgICAgIF0sCiAgICAgICAgICAicHJvcGVydGllcyI6IHsKICAgICAgICAgICAgIm1heF9tZW1vcnkiOiB7CiAgICAgICAgICAgICAgInR5cGUiOiAiaW50ZWdlciIsCiAgICAgICAgICAgICAgImRlc2NyaXB0aW9uIjogIlRoZSBtYXhpbXVtIGFtb3VudCBvZiBNZW1vcnkgc3RvcmFnZSBTdHJlYW0gTWVzc2FnZXMgbWF5IGNvbnN1bWUiLAogICAgICAgICAgICAgICJtaW5pbXVtIjogLTEKICAgICAgICAgICAgfSwKICAgICAgICAgICAgIm1heF9zdG9yYWdlIjogewogICAgICAgICAgICAgICJ0eXBlIjogImludGVnZXIiLAogICAgICAgICAgICAgICJkZXNjcmlwdGlvbiI6ICJUaGUgbWF4aW11bSBhbW91bnQgb2YgRmlsZSBzdG9yYWdlIFN0cmVhbSBNZXNzYWdlcyBtYXkgY29uc3VtZSIsCiAgICAgICAgICAgICAgIm1pbmltdW0iOiAtMQogICAgICAgICAgICB9LAogICAgICAgICAgICAibWF4X3N0cmVhbXMiOiB7CiAgICAgICAgICAgICAgInR5cGUiOiAiaW50ZWdlciIsCiAgICAgICAgICAgICAgImRlc2NyaXB0aW9uIjogIlRoZSBtYXhpbXVtIG51bWJlciBvZiBTdHJlYW1zIGFuIGFjY291bnQgY2FuIGNyZWF0ZSIsCiAgICAgICAgICAgICAgIm1pbmltdW0iOiAtMQogICAgICAgICAgICB9LAogICAgICAgICAgICAibWF4X2NvbnN1bWVycyI6IHsKICAgICAgICAgICAgICAidHlwZSI6ICJpbnRlZ2VyIiwKICAgICAgICAgICAgICAiZGVzY3JpcHRpb24iOiAiVGhlIG1heGltdW0gbnVtYmVyIG9mIENvbnN1bWVyIGFuIGFjY291bnQgY2FuIGNyZWF0ZSIsCiAgICAgICAgICAgICAgIm1pbmltdW0iOiAtMQogICAgICAgICAgICB9CiAgICAgICAgICB9CiAgICAgICAgfSwKICAgICAgICAiYXBpIjogewogICAgICAgICAgInR5cGUiOiAib2JqZWN0IiwKICAgICAgICAgICJyZXF1aXJlZCI6IFsKICAgICAgICAgICAgInRvdGFsIiwKICAgICAgICAgICAgImVycm9ycyIKICAgICAgICAgIF0sCiAgICAgICAgICAicHJvcGVydGllcyI6IHsKICAgICAgICAgICAgInRvdGFsIjogewogICAgICAgICAgICAgICJkZXNjcmlwdGlvbiI6ICJUb3RhbCBudW1iZXIgb2YgQVBJIHJlcXVlc3RzIHJlY2VpdmVkIGZvciB0aGlzIGFjY291bnQiLAogICAgICAgICAgICAgICJtaW5pbXVtIjogMCwKICAgICAgICAgICAgICAidHlwZSI6ICJpbnRlZ2VyIgogICAgICAgICAgICB9LAogICAgICAgICAgICAiZXJyb3JzIjogewogICAgICAgICAgICAgICJkZXNjcmlwdGlvbiI6ICJBUEkgcmVxdWVzdHMgdGhhdCByZXN1bHRlZCBpbiBhbiBlcnJvciByZXNwb25zZSIsCiAgICAgICAgICAgICAgIm1pbmltdW0iOiAwLAogICAgICAgICAgICAgICJ0eXBlIjogImludGVnZXIiCiAgICAgICAgICAgIH0KICAgICAgICAgIH0KICAgICAgICB9CiAgICAgIH0KICAgIH0sCiAgICB7CiAgICAgICJ0eXBlIjogIm9iamVjdCIsCiAgICAgICJyZXF1aXJlZCI6IFsKICAgICAgICAiZXJyb3IiCiAgICAgIF0sCiAgICAgICJwcm9wZXJ0aWVzIjogewogICAgICAgICJlcnJvciI6IHsKICAgICAgICAgICJ0eXBlIjogIm9iamVjdCIsCiAgICAgICAgICAicmVxdWlyZWQiOiBbCiAgICAgICAgICAgICJjb2RlIgogICAgICAgICAgXSwKICAgICAgICAgICJwcm9wZXJ0aWVzIjogewogICAgICAgICAgICAiY29kZSI6IHsKICAgICAgICAgICAgICAidHlwZSI6ICJpbnRlZ2VyIiwKICAgICAgICAgICAgICAiZGVzY3JpcHRpb24iOiAiSFRUUCBsaWtlIGVycm9yIGNvZGUgaW4gdGhlIDMwMCB0byA1MDAgcmFuZ2UiLAogICAgICAgICAgICAgICJtaW5pbXVtIjogMzAwLAogICAgICAgICAgICAgICJtYXhpbXVtIjogNjk5CiAgICAgICAgICAgIH0sCiAgICAgICAgICAgICJkZXNjcmlwdGlvbiI6IHsKICAgICAgICAgICAgICAidHlwZSI6ICJzdHJpbmciLAogICAgICAgICAgICAgICJkZXNjcmlwdGlvbiI6ICJBIGh1bWFuIGZyaWVuZGx5IGRlc2NyaXB0aW9uIG9mIHRoZSBlcnJvciIKICAgICAgICAgICAgfQogICAgICAgICAgfQogICAgICAgIH0KICAgICAgfQogICAgfQogIF0sCiAgInByb3BlcnRpZXMiOiB7CiAgICAidHlwZSI6IHsKICAgICAgInR5cGUiOiAic3RyaW5nIiwKICAgICAgImNvbnN0IjogImlvLm5hdHMuamV0c3RyZWFtLmFwaS52MS5hY2NvdW50X2luZm9fcmVzcG9uc2UiCiAgICB9CiAgfQp9Cg==")
	schemas["io.nats.jetstream.api.v1.consumer_create_request"], _ = base64.StdEncoding.DecodeString("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")
	schemas["io.nats.jetstream.api.v1.consumer_create_response"], _ = base64.StdEncoding.DecodeString("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")
	schemas["io.nats.jetstream.api.v1.consumer_delete_response"], _ = base64.StdEncoding.DecodeString("ewogICIkc2NoZW1hIjogImh0dHA6Ly9qc29uLXNjaGVtYS5vcmcvZHJhZnQtMDcvc2NoZW1hIyIsCiAgIiRpZCI6ICJodHRwczovL25hdHMuaW8vc2NoZW1hcy9qZXRzdHJlYW0vYXBpL3YxL2NvbnN1bWVyX2RlbGV0ZV9yZXNwb25zZS5qc29uIiwKICAiZGVzY3JpcHRpb24iOiAiQSByZXNwb25zZSBmcm9tIHRoZSBKZXRTdHJlYW0gJEpTLkFQSS5DT05TVU1FUi5ERUxFVEUgQVBJIiwKICAidGl0bGUiOiAiaW8ubmF0cy5qZXRzdHJlYW0uYXBpLnYxLmNvbnN1bWVyX2RlbGV0ZV9yZXNwb25zZSIsCiAgInR5cGUiOiAib2JqZWN0IiwKICAicmVxdWlyZWQiOiBbCiAgICAidHlwZSIKICBdLAogICJvbmVPZiI6IFsKICAgIHsKICAgICAgInR5cGUiOiAib2JqZWN0IiwKICAgICAgInJlcXVpcmVkIjogWwogICAgICAgICJlcnJvciIKICAgICAgXSwKICAgICAgInByb3BlcnRpZXMiOiB7CiAgICAgICAgImVycm9yIjogewogICAgICAgICAgInR5cGUiOiAib2JqZWN0IiwKICAgICAgICAgICJyZXF1aXJlZCI6IFsKICAgICAgICAgICAgImNvZGUiCiAgICAgICAgICBdLAogICAgICAgICAgInByb3BlcnRpZXMiOiB7CiAgICAgICAgICAgICJjb2RlIjogewogICAgICAgICAgICAgICJ0eXBlIjogImludGVnZXIiLAogICAgICAgICAgICAgICJkZXNjcmlwdGlvbiI6ICJIVFRQIGxpa2UgZXJyb3IgY29kZSBpbiB0aGUgMzAwIHRvIDUwMCByYW5nZSIsCiAgICAgICAgICAgICAgIm1pbmltdW0iOiAzMDAsCiAgICAgICAgICAgICAgIm1heGltdW0iOiA2OTkKICAgICAgICAgICAgfSwKICAgICAgICAgICAgImRlc2NyaXB0aW9uIjogewogICAgICAgICAgICAgICJ0eXBlIjogInN0cmluZyIsCiAgICAgICAgICAgICAgImRlc2NyaXB0aW9uIjogIkEgaHVtYW4gZnJpZW5kbHkgZGVzY3JpcHRpb24gb2YgdGhlIGVycm9yIgogICAgICAgICAgICB9CiAgICAgICAgICB9CiAgICAgICAgfQogICAgICB9CiAgICB9LAogICAgewogICAgICAidHlwZSI6ICJvYmplY3QiLAogICAgICAicmVxdWlyZWQiOiBbCiAgICAgICAgInN1Y2Nlc3MiCiAgICAgIF0sCiAgICAgICJwcm9wZXJ0aWVzIjogewogICAgICAgICJzdWNjZXNzIjogewogICAgICAgICAgInR5cGUiOiAiYm9vbGVhbiIKICAgICAgICB9CiAgICAgIH0KICAgIH0KICBdLAogICJwcm9wZXJ0aWVzIjogewogICAgInR5cGUiOiB7CiAgICAgICJ0eXBlIjogInN0cmluZyIsCiAgICAgICJjb25zdCI6ICJpby5uYXRzLmpldHN0cmVhbS5hcGkudjEuY29uc3VtZXJfZGVsZXRlX3Jlc3BvbnNlIgogICAgfQogIH0KfQo=")
	schemas["io.nats.jetstream.api.v1.consumer_info_response"], _ = base64.StdEncoding.DecodeString("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")
	schemas["io.nats.jetstream.api.v1.consumer_list_request"], _ = base64.StdEncoding.DecodeString("ewogICIkc2NoZW1hIjogImh0dHA6Ly9qc29uLXNjaGVtYS5vcmcvZHJhZnQtMDcvc2NoZW1hIyIsCiAgIiRpZCI6ICJodHRwczovL25hdHMuaW8vc2NoZW1hcy9qZXRzdHJlYW0vYXBpL3YxL2NvbnN1bWVyX2xpc3RfcmVxdWVzdC5qc29uIiwKICAiZGVzY3JpcHRpb24iOiAiQSByZXF1ZXN0IHRvIHRoZSBKZXRTdHJlYW0gJEpTLkFQSS5DT05TVU1FUi5MSVNUIEFQSSIsCiAgInRpdGxlIjogImlvLm5hdHMuamV0c3RyZWFtLmFwaS52MS5jb25zdW1lcl9saXN0X3JlcXVlc3QiLAogICJ0eXBlIjogIm9iamVjdCIsCiAgImFsbE9mIjogWwogICAgewogICAgICAidHlwZSI6ICJvYmplY3QiLAogICAgICAiYWRkaXRpb25hbFByb3BlcnRpZXMiOiBmYWxzZSwKICAgICAgInJlcXVpcmVkIjogWwogICAgICAgICJvZmZzZXQiCiAgICAgIF0sCiAgICAgICJwcm9wZXJ0aWVzIjogewogICAgICAgICJvZmZzZXQiOiB7CiAgICAgICAgICAidHlwZSI6ICJpbnRlZ2VyIiwKICAgICAgICAgICJtaW5pbXVtIjogMAogICAgICAgIH0KICAgICAgfQogICAgfQogIF0KfQo=")
	schemas["io.nats.jetstream.api.v1.consumer_list_response"], _ = base64.StdEncoding.DecodeString("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")
	schemas["io.nats.jetstream.api.v1.consumer_names_request"], _ = base64.StdEncoding.DecodeString("ewogICIkc2NoZW1hIjogImh0dHA6Ly9qc29uLXNjaGVtYS5vcmcvZHJhZnQtMDcvc2NoZW1hIyIsCiAgIiRpZCI6ICJodHRwczovL25hdHMuaW8vc2NoZW1hcy9qZXRzdHJlYW0vYXBpL3YxL2NvbnN1bWVyX25hbWVzX3JlcXVlc3QuanNvbiIsCiAgImRlc2NyaXB0aW9uIjogIkEgcmVxdWVzdCB0byB0aGUgSmV0U3RyZWFtICRKUy5BUEkuQ09OU1VNRVIuTkFNRVMgQVBJIiwKICAidGl0bGUiOiAiaW8ubmF0cy5qZXRzdHJlYW0uYXBpLnYxLmNvbnN1bWVyX25hbWVzX3JlcXVlc3QiLAogICJ0eXBlIjogIm9iamVjdCIsCiAgImFsbE9mIjogWwogICAgewogICAgICAidHlwZSI6ICJvYmplY3QiLAogICAgICAiYWRkaXRpb25hbFByb3BlcnRpZXMiOiBmYWxzZSwKICAgICAgInJlcXVpcmVkIjogWwogICAgICAgICJvZmZzZXQiCiAgICAgIF0sCiAgICAgICJwcm9wZXJ0aWVzIjogewogICAgICAgICJvZmZzZXQiOiB7CiAgICAgICAgICAidHlwZSI6ICJpbnRlZ2VyIiwKICAgICAgICAgICJtaW5pbXVtIjogMAogICAgICAgIH0KICAgICAgfQogICAgfQogIF0sCiAgInByb3BlcnRpZXMiOiB7CiAgICAic3ViamVjdCI6IHsKICAgICAgInR5cGUiOiAic3RyaW5nIiwKICAgICAgImRlc2NyaXB0aW9uIjogIkZpbHRlciB0aGUgbmFtZXMgdG8gdGhvc2UgY29uc3VtaW5nIG1lc3NhZ2VzIG1hdGNoaW5nIHRoaXMgc3ViamVjdCBvciB3aWxkY2FyZCIKICAgIH0KICB9Cn0K")
	schemas["io.nats.jetstream.api.v1.consumer_names_response"], _ = base64.StdEncoding.DecodeString("ewogICIkc2NoZW1hIjogImh0dHA6Ly9qc29uLXNjaGVtYS5vcmcvZHJhZnQtMDcvc2NoZW1hIyIsCiAgIiRpZCI6ICJodHRwczovL25hdHMuaW8vc2NoZW1hcy9qZXRzdHJlYW0vYXBpL3YxL2NvbnN1bWVyX25hbWVzX3Jlc3BvbnNlLmpzb24iLAogICJkZXNjcmlwdGlvbiI6ICJBIHJlc3BvbnNlIGZyb20gdGhlIEpldFN0cmVhbSAkSlMuQVBJLkNPTlNVTUVSLk5BTUVTIEFQSSIsCiAgInRpdGxlIjogImlvLm5hdHMuamV0c3RyZWFtLmFwaS52MS5jb25zdW1lcl9uYW1lc19yZXNwb25zZSIsCiAgInR5cGUiOiAib2JqZWN0IiwKICAicmVxdWlyZWQiOiBbCiAgICAidHlwZSIKICBdLAogICJhbGxPZiI6IFsKICAgIHsKICAgICAgInR5cGUiOiAib2JqZWN0IiwKICAgICAgInJlcXVpcmVkIjogWwogICAgICAgICJ0b3RhbCIsCiAgICAgICAgIm9mZnNldCIsCiAgICAgICAgImxpbWl0IgogICAgICBdLAogICAgICAicHJvcGVydGllcyI6IHsKICAgICAgICAidG90YWwiOiB7CiAgICAgICAgICAidHlwZSI6ICJpbnRlZ2VyIiwKICAgICAgICAgICJtaW5pbXVtIjogMAogICAgICAgIH0sCiAgICAgICAgIm9mZnNldCI6IHsKICAgICAgICAgICJ0eXBlIjogImludGVnZXIiLAogICAgICAgICAgIm1pbmltdW0iOiAwCiAgICAgICAgfSwKICAgICAgICAibGltaXQiOiB7CiAgICAgICAgICAidHlwZSI6ICJpbnRlZ2VyIiwKICAgICAgICAgICJtaW5pbXVtIjogMAogICAgICAgIH0KICAgICAgfQogICAgfQogIF0sCiAgIm9uZU9mIjogWwogICAgewogICAgICAidHlwZSI6ICJvYmplY3QiLAogICAgICAicmVxdWlyZWQiOiBbCiAgICAgICAgImVycm9yIgogICAgICBdLAogICAgICAicHJvcGVydGllcyI6IHsKICAgICAgICAiZXJyb3IiOiB7CiAgICAgICAgICAidHlwZSI6ICJvYmplY3QiLAogICAgICAgICAgInJlcXVpcmVkIjogWwogICAgICAgICAgICAiY29kZSIKICAgICAgICAgIF0sCiAgICAgICAgICAicHJvcGVydGllcyI6IHsKICAgICAgICAgICAgImNvZGUiOiB7CiAgICAgICAgICAgICAgInR5cGUiOiAiaW50ZWdlciIsCiAgICAgICAgICAgICAgImRlc2NyaXB0aW9uIjogIkhUVFAgbGlrZSBlcnJvciBjb2RlIGluIHRoZSAzMDAgdG8gNTAwIHJhbmdlIiwKICAgICAgICAgICAgICAibWluaW11bSI6IDMwMCwKICAgICAgICAgICAgICAibWF4aW11bSI6IDY5OQogICAgICAgICAgICB9LAogICAgICAgICAgICAiZGVzY3JpcHRpb24iOiB7CiAgICAgICAgICAgICAgInR5cGUiOiAic3RyaW5nIiwKICAgICAgICAgICAgICAiZGVzY3JpcHRpb24iOiAiQSBodW1hbiBmcmllbmRseSBkZXNjcmlwdGlvbiBvZiB0aGUgZXJyb3IiCiAgICAgICAgICAgIH0KICAgICAgICAgIH0KICAgICAgICB9CiAgICAgIH0KICAgIH0sCiAgICB7CiAgICAgICJ0eXBlIjogIm9iamVjdCIsCiAgICAgICJyZXF1aXJlZCI6IFsKICAgICAgICAiY29uc3VtZXJzIgogICAgICBdLAogICAgICAicHJvcGVydGllcyI6IHsKICAgICAgICAiY29uc3VtZXJzIjogewogICAgICAgICAgInR5cGUiOiAiYXJyYXkiLAogICAgICAgICAgIml0ZW1zIjogewogICAgICAgICAgICAidHlwZSI6ICJzdHJpbmciCiAgICAgICAgICB9CiAgICAgICAgfQogICAgICB9CiAgICB9CiAgXSwKICAicHJvcGVydGllcyI6IHsKICAgICJ0eXBlIjogewogICAgICAidHlwZSI6ICJzdHJpbmciLAogICAgICAiY29uc3QiOiAiaW8ubmF0cy5qZXRzdHJlYW0uYXBpLnYxLmNvbnN1bWVyX25hbWVzX3Jlc3BvbnNlIgogICAgfQogIH0KfQo=")
	schemas["io.nats.jetstream.api.v1.consumer_getnext_request"], _ = base64.StdEncoding.DecodeString("ewogICIkc2NoZW1hIjogImh0dHA6Ly9qc29uLXNjaGVtYS5vcmcvZHJhZnQtMDcvc2NoZW1hIyIsCiAgIiRpZCI6ICJodHRwczovL25hdHMuaW8vc2NoZW1hcy9qZXRzdHJlYW0vYXBpL3YxL2NvbnN1bWVyX2dldG5leHRfcmVxdWVzdC5qc29uIiwKICAiZGVzY3JpcHRpb24iOiAiQSByZXF1ZXN0IHRvIHRoZSBKZXRTdHJlYW0gJEpTLkFQSS5DT05TVU1FUi5NU0cuTkVYVCBBUEkiLAogICJ0aXRsZSI6ICJpby5uYXRzLmpldHN0cmVhbS5hcGkudjEuY29uc3VtZXJfZ2V0bmV4dF9yZXF1ZXN0IiwKICAidHlwZSI6ICJvYmplY3QiLAogICJwcm9wZXJ0aWVzIjogewogICAgImV4cGlyZXMiOiB7CiAgICAgICJ0eXBlIjogImludGVnZXIiLAogICAgICAiZGVzY3JpcHRpb24iOiAiQSBkdXJhdGlvbiBmcm9tIG5vdyB3aGVuIHRoZSBwdWxsIHNob3VsZCBleHBpcmUsIHN0YXRlZCBpbiBuYW5vc2Vjb25kcywgMCBmb3Igbm8gZXhwaXJ5IgogICAgfSwKICAgICJiYXRjaCI6IHsKICAgICAgInR5cGUiOiAiaW50ZWdlciIsCiAgICAgICJkZXNjcmlwdGlvbiI6ICJIb3cgbWFueSBtZXNzYWdlcyB0aGUgc2VydmVyIHNob3VsZCBkZWxpdmVyIHRvIHRoZSByZXF1ZXN0b3IiLAogICAgICAibWluaW11bSI6IDAsCiAgICAgICJtYXhpbXVtIjogMjU2CiAgICB9LAogICAgIm5vX3dhaXQiOiB7CiAgICAgICJ0eXBlIjogImJvb2xlYW4iLAogICAgICAiZGVzY3JpcHRpb24iOiAiV2hlbiB0cnVlIGEgcmVzcG9uc2Ugd2l0aCBhIDQwNCBzdGF0dXMgaGVhZGVyIHdpbGwgYmUgcmV0dXJuZWQgd2hlbiBubyBtZXNzYWdlcyBhcmUgYXZhaWxhYmxlIgogICAgfQogIH0KfQo=")
	schemas["io.nats.jetstream.api.v1.consumer_leader_stepdown_response"], _ = base64.StdEncoding.DecodeString("ewogICIkc2NoZW1hIjogImh0dHA6Ly9qc29uLXNjaGVtYS5vcmcvZHJhZnQtMDcvc2NoZW1hIyIsCiAgIiRpZCI6ICJodHRwczovL25hdHMuaW8vc2NoZW1hcy9qZXRzdHJlYW0vYXBpL3YxL2NvbnN1bWVyX2xlYWRlcl9zdGVwZG93bl9yZXNwb25zZS5qc29uIiwKICAiZGVzY3JpcHRpb24iOiAiQSByZXNwb25zZSBmcm9tIHRoZSBKZXRTdHJlYW0gJEpTLkFQSS5DT05TVU1FUi5MRUFERVIuU1RFUERPV04gQVBJIiwKICAidGl0bGUiOiAiaW8ubmF0cy5qZXRzdHJlYW0uYXBpLnYxLmNvbnN1bWVyX2xlYWRlcl9zdGVwZG93bl9yZXNwb25zZSIsCiAgInR5cGUiOiAib2JqZWN0IiwKICAib25lT2YiOiBbCiAgICB7CiAgICAgICJ0eXBlIjogIm9iamVjdCIsCiAgICAgICJyZXF1aXJlZCI6IFsKICAgICAgICAiZXJyb3IiCiAgICAgIF0sCiAgICAgICJwcm9wZXJ0aWVzIjogewogICAgICAgICJlcnJvciI6IHsKICAgICAgICAgICJ0eXBlIjogIm9iamVjdCIsCiAgICAgICAgICAicmVxdWlyZWQiOiBbCiAgICAgICAgICAgICJjb2RlIgogICAgICAgICAgXSwKICAgICAgICAgICJwcm9wZXJ0aWVzIjogewogICAgICAgICAgICAiY29kZSI6IHsKICAgICAgICAgICAgICAidHlwZSI6ICJpbnRlZ2VyIiwKICAgICAgICAgICAgICAiZGVzY3JpcHRpb24iOiAiSFRUUCBsaWtlIGVycm9yIGNvZGUgaW4gdGhlIDMwMCB0byA1MDAgcmFuZ2UiLAogICAgICAgICAgICAgICJtaW5pbXVtIjogMzAwLAogICAgICAgICAgICAgICJtYXhpbXVtIjogNjk5CiAgICAgICAgICAgIH0sCiAgICAgICAgICAgICJkZXNjcmlwdGlvbiI6IHsKICAgICAgICAgICAgICAidHlwZSI6ICJzdHJpbmciLAogICAgICAgICAgICAgICJkZXNjcmlwdGlvbiI6ICJBIGh1bWFuIGZyaWVuZGx5IGRlc2NyaXB0aW9uIG9mIHRoZSBlcnJvciIKICAgICAgICAgICAgfQogICAgICAgICAgfQogICAgICAgIH0KICAgICAgfQogICAgfSwKICAgIHsKICAgICAgInJlcXVpcmVkIjogWwogICAgICAgICJzdWNjZXNzIgogICAgICBdLAogICAgICAidHlwZSI6ICJvYmplY3QiLAogICAgICAicHJvcGVydGllcyI6IHsKICAgICAgICAic3VjY2VzcyI6IHsKICAgICAgICAgICJ0eXBlIjogImJvb2xlYW4iLAogICAgICAgICAgImRlc2NyaXB0aW9uIjogIklmIHRoZSBsZWFkZXIgc3VjY2Vzc2Z1bGx5IHN0b29kIGRvd24iLAogICAgICAgICAgImRlZmF1bHQiOiBmYWxzZQogICAgICAgIH0KICAgICAgfQogICAgfQogIF0sCiAgInByb3BlcnRpZXMiOiB7CiAgICAidHlwZSI6IHsKICAgICAgInR5cGUiOiAic3RyaW5nIiwKICAgICAgImNvbnN0IjogImlvLm5hdHMuamV0c3RyZWFtLmFwaS52MS5jb25zdW1lcl9sZWFkZXJfc3RlcGRvd25fcmVzcG9uc2UiCiAgICB9CiAgfQp9Cg==")
	schemas["io.nats.jetstream.api.v1.stream_create_request"], _ = base64.StdEncoding.DecodeString("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")
	schemas["io.nats.jetstream.api.v1.stream_create_response"], _ = base64.StdEncoding.DecodeString("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")
	schemas["io.nats.jetstream.api.v1.stream_delete_response"], _ = base64.StdEncoding.DecodeString("ewogICIkc2NoZW1hIjogImh0dHA6Ly9qc29uLXNjaGVtYS5vcmcvZHJhZnQtMDcvc2NoZW1hIyIsCiAgIiRpZCI6ICJodHRwczovL25hdHMuaW8vc2NoZW1hcy9qZXRzdHJlYW0vYXBpL3YxL3N0cmVhbV9kZWxldGVfcmVzcG9uc2UuanNvbiIsCiAgImRlc2NyaXB0aW9uIjogIkEgcmVzcG9uc2UgZnJvbSB0aGUgSmV0U3RyZWFtICRKUy5BUEkuU1RSRUFNLkRFTEVURSBBUEkiLAogICJ0aXRsZSI6ICJpby5uYXRzLmpldHN0cmVhbS5hcGkudjEuc3RyZWFtX2RlbGV0ZV9yZXNwb25zZSIsCiAgInR5cGUiOiAib2JqZWN0IiwKICAicmVxdWlyZWQiOiBbCiAgICAidHlwZSIKICBdLAogICJvbmVPZiI6IFsKICAgIHsKICAgICAgInR5cGUiOiAib2JqZWN0IiwKICAgICAgInJlcXVpcmVkIjogWwogICAgICAgICJlcnJvciIKICAgICAgXSwKICAgICAgInByb3BlcnRpZXMiOiB7CiAgICAgICAgImVycm9yIjogewogICAgICAgICAgInR5cGUiOiAib2JqZWN0IiwKICAgICAgICAgICJyZXF1aXJlZCI6IFsKICAgICAgICAgICAgImNvZGUiCiAgICAgICAgICBdLAogICAgICAgICAgInByb3BlcnRpZXMiOiB7CiAgICAgICAgICAgICJjb2RlIjogewogICAgICAgICAgICAgICJ0eXBlIjogImludGVnZXIiLAogICAgICAgICAgICAgICJkZXNjcmlwdGlvbiI6ICJIVFRQIGxpa2UgZXJyb3IgY29kZSBpbiB0aGUgMzAwIHRvIDUwMCByYW5nZSIsCiAgICAgICAgICAgICAgIm1pbmltdW0iOiAzMDAsCiAgICAgICAgICAgICAgIm1heGltdW0iOiA2OTkKICAgICAgICAgICAgfSwKICAgICAgICAgICAgImRlc2NyaXB0aW9uIjogewogICAgICAgICAgICAgICJ0eXBlIjogInN0cmluZyIsCiAgICAgICAgICAgICAgImRlc2NyaXB0aW9uIjogIkEgaHVtYW4gZnJpZW5kbHkgZGVzY3JpcHRpb24gb2YgdGhlIGVycm9yIgogICAgICAgICAgICB9CiAgICAgICAgICB9CiAgICAgICAgfQogICAgICB9CiAgICB9LAogICAgewogICAgICAicmVxdWlyZWQiOiBbCiAgICAgICAgInN1Y2Nlc3MiCiAgICAgIF0sCiAgICAgICJ0eXBlIjogIm9iamVjdCIsCiAgICAgICJwcm9wZXJ0aWVzIjogewogICAgICAgICJzdWNjZXNzIjogewogICAgICAgICAgInR5cGUiOiAiYm9vbGVhbiIKICAgICAgICB9CiAgICAgIH0KICAgIH0KICBdLAogICJwcm9wZXJ0aWVzIjogewogICAgInR5cGUiOiB7CiAgICAgICJ0eXBlIjogInN0cmluZyIsCiAgICAgICJjb25zdCI6ICJpby5uYXRzLmpldHN0cmVhbS5hcGkudjEuc3RyZWFtX2RlbGV0ZV9yZXNwb25zZSIKICAgIH0KICB9Cn0K")
	schemas["io.nats.jetstream.api.v1.stream_info_response"], _ = base64.StdEncoding.DecodeString("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")
	schemas["io.nats.jetstream.api.v1.stream_list_request"], _ = base64.StdEncoding.DecodeString("ewogICIkc2NoZW1hIjogImh0dHA6Ly9qc29uLXNjaGVtYS5vcmcvZHJhZnQtMDcvc2NoZW1hIyIsCiAgIiRpZCI6ICJodHRwczovL25hdHMuaW8vc2NoZW1hcy9qZXRzdHJlYW0vYXBpL3YxL3N0cmVhbV9saXN0X3JlcXVlc3QuanNvbiIsCiAgImRlc2NyaXB0aW9uIjogIkEgcmVxdWVzdCB0byB0aGUgSmV0U3RyZWFtICRKUy5BUEkuU1RSRUFNLkxJU1QgQVBJIiwKICAidGl0bGUiOiAiaW8ubmF0cy5qZXRzdHJlYW0uYXBpLnYxLnN0cmVhbV9saXN0X3JlcXVlc3QiLAogICJ0eXBlIjogIm9iamVjdCIsCiAgImFsbE9mIjogWwogICAgewogICAgICAidHlwZSI6ICJvYmplY3QiLAogICAgICAiYWRkaXRpb25hbFByb3BlcnRpZXMiOiBmYWxzZSwKICAgICAgInJlcXVpcmVkIjogWwogICAgICAgICJvZmZzZXQiCiAgICAgIF0sCiAgICAgICJwcm9wZXJ0aWVzIjogewogICAgICAgICJvZmZzZXQiOiB7CiAgICAgICAgICAidHlwZSI6ICJpbnRlZ2VyIiwKICAgICAgICAgICJtaW5pbXVtIjogMAogICAgICAgIH0KICAgICAgfQogICAgfQogIF0KfQo=")
	schemas["io.nats.jetstream.api.v1.stream_list_response"], _ = base64.StdEncoding.DecodeString("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")
	schemas["io.nats.jetstream.api.v1.stream_msg_delete_response"], _ = base64.StdEncoding.DecodeString("ewogICIkc2NoZW1hIjogImh0dHA6Ly9qc29uLXNjaGVtYS5vcmcvZHJhZnQtMDcvc2NoZW1hIyIsCiAgIiRpZCI6ICJodHRwczovL25hdHMuaW8vc2NoZW1hcy9qZXRzdHJlYW0vYXBpL3YxL3N0cmVhbV9tc2dfZGVsZXRlX3Jlc3BvbnNlLmpzb24iLAogICJkZXNjcmlwdGlvbiI6ICJBIHJlc3BvbnNlIGZyb20gdGhlIEpldFN0cmVhbSAkSlMuQVBJLlNUUkVBTS5NU0cuREVMRVRFIEFQSSIsCiAgInRpdGxlIjogImlvLm5hdHMuamV0c3RyZWFtLmFwaS52MS5zdHJlYW1fbXNnX2RlbGV0ZV9yZXNwb25zZSIsCiAgInR5cGUiOiAib2JqZWN0IiwKICAicmVxdWlyZWQiOiBbCiAgICAidHlwZSIKICBdLAogICJvbmVPZiI6IFsKICAgIHsKICAgICAgInR5cGUiOiAib2JqZWN0IiwKICAgICAgInJlcXVpcmVkIjogWwogICAgICAgICJlcnJvciIKICAgICAgXSwKICAgICAgInByb3BlcnRpZXMiOiB7CiAgICAgICAgImVycm9yIjogewogICAgICAgICAgInR5cGUiOiAib2JqZWN0IiwKICAgICAgICAgICJyZXF1aXJlZCI6IFsKICAgICAgICAgICAgImNvZGUiCiAgICAgICAgICBdLAogICAgICAgICAgInByb3BlcnRpZXMiOiB7CiAgICAgICAgICAgICJjb2RlIjogewogICAgICAgICAgICAgICJ0eXBlIjogImludGVnZXIiLAogICAgICAgICAgICAgICJkZXNjcmlwdGlvbiI6ICJIVFRQIGxpa2UgZXJyb3IgY29kZSBpbiB0aGUgMzAwIHRvIDUwMCByYW5nZSIsCiAgICAgICAgICAgICAgIm1pbmltdW0iOiAzMDAsCiAgICAgICAgICAgICAgIm1heGltdW0iOiA2OTkKICAgICAgICAgICAgfSwKICAgICAgICAgICAgImRlc2NyaXB0aW9uIjogewogICAgICAgICAgICAgICJ0eXBlIjogInN0cmluZyIsCiAgICAgICAgICAgICAgImRlc2NyaXB0aW9uIjogIkEgaHVtYW4gZnJpZW5kbHkgZGVzY3JpcHRpb24gb2YgdGhlIGVycm9yIgogICAgICAgICAgICB9CiAgICAgICAgICB9CiAgICAgICAgfQogICAgICB9CiAgICB9LAogICAgewogICAgICAidHlwZSI6ICJvYmplY3QiLAogICAgICAicmVxdWlyZWQiOiBbCiAgICAgICAgInN1Y2Nlc3MiCiAgICAgIF0sCiAgICAgICJwcm9wZXJ0aWVzIjogewogICAgICAgICJzdWNjZXNzIjogewogICAgICAgICAgInR5cGUiOiAiYm9vbGVhbiIKICAgICAgICB9CiAgICAgIH0KICAgIH0KICBdLAogICJwcm9wZXJ0aWVzIjogewogICAgInR5cGUiOiB7CiAgICAgICJ0eXBlIjogInN0cmluZyIsCiAgICAgICJjb25zdCI6ICJpby5uYXRzLmpldHN0cmVhbS5hcGkudjEuc3RyZWFtX21zZ19kZWxldGVfcmVzcG9uc2UiCiAgICB9CiAgfQp9Cg==")
	schemas["io.nats.jetstream.api.v1.stream_msg_get_request"], _ = base64.StdEncoding.DecodeString("ewogICIkc2NoZW1hIjogImh0dHA6Ly9qc29uLXNjaGVtYS5vcmcvZHJhZnQtMDcvc2NoZW1hIyIsCiAgIiRpZCI6ICJodHRwczovL25hdHMuaW8vc2NoZW1hcy9qZXRzdHJlYW0vYXBpL3YxL3N0cmVhbV9tc2dfZ2V0X3JlcXVlc3QuanNvbiIsCiAgImRlc2NyaXB0aW9uIjogIkEgcmVxdWVzdCB0byB0aGUgSmV0U3RyZWFtICRKUy5BUEkuU1RSRUFNLk1TRy5HRVQgQVBJIiwKICAidGl0bGUiOiAiaW8ubmF0cy5qZXRzdHJlYW0uYXBpLnYxLnN0cmVhbV9tc2dfZ2V0X3JlcXVlc3QiLAogICJ0eXBlIjogIm9iamVjdCIsCiAgInJlcXVpcmVkIjogWwogICAgInNlcSIKICBdLAogICJwcm9wZXJ0aWVzIjogewogICAgInNlcSI6IHsKICAgICAgInR5cGUiOiAiaW50ZWdlciIsCiAgICAgICJkZXNjcmlwdGlvbiI6ICJTdHJlYW0gc2VxdWVuY2UgbnVtYmVyIG9mIHRoZSBtZXNzYWdlIHRvIHJldHJpZXZlIgogICAgfQogIH0KfQo=")
	schemas["io.nats.jetstream.api.v1.stream_msg_get_response"], _ = base64.StdEncoding.DecodeString("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")
	schemas["io.nats.jetstream.api.v1.stream_names_request"], _ = base64.StdEncoding.DecodeString("ewogICIkc2NoZW1hIjogImh0dHA6Ly9qc29uLXNjaGVtYS5vcmcvZHJhZnQtMDcvc2NoZW1hIyIsCiAgIiRpZCI6ICJodHRwczovL25hdHMuaW8vc2NoZW1hcy9qZXRzdHJlYW0vYXBpL3YxL3N0cmVhbV9uYW1lc19yZXF1ZXN0Lmpzb24iLAogICJkZXNjcmlwdGlvbiI6ICJBIHJlcXVlc3QgdG8gdGhlIEpldFN0cmVhbSAkSlMuQVBJLlNUUkVBTS5OQU1FUyBBUEkiLAogICJ0aXRsZSI6ICJpby5uYXRzLmpldHN0cmVhbS5hcGkudjEuc3RyZWFtX25hbWVzX3JlcXVlc3QiLAogICJ0eXBlIjogIm9iamVjdCIsCiAgImFsbE9mIjogWwogICAgewogICAgICAidHlwZSI6ICJvYmplY3QiLAogICAgICAiYWRkaXRpb25hbFByb3BlcnRpZXMiOiBmYWxzZSwKICAgICAgInJlcXVpcmVkIjogWwogICAgICAgICJvZmZzZXQiCiAgICAgIF0sCiAgICAgICJwcm9wZXJ0aWVzIjogewogICAgICAgICJvZmZzZXQiOiB7CiAgICAgICAgICAidHlwZSI6ICJpbnRlZ2VyIiwKICAgICAgICAgICJtaW5pbXVtIjogMAogICAgICAgIH0KICAgICAgfQogICAgfQogIF0KfQo=")
	schemas["io.nats.jetstream.api.v1.stream_names_response"], _ = base64.StdEncoding.DecodeString("ewogICIkc2NoZW1hIjogImh0dHA6Ly9qc29uLXNjaGVtYS5vcmcvZHJhZnQtMDcvc2NoZW1hIyIsCiAgIiRpZCI6ICJodHRwczovL25hdHMuaW8vc2NoZW1hcy9qZXRzdHJlYW0vYXBpL3YxL3N0cmVhbV9uYW1lc19yZXNwb25zZS5qc29uIiwKICAiZGVzY3JpcHRpb24iOiAiQSByZXNwb25zZSBmcm9tIHRoZSBKZXRTdHJlYW0gJEpTLkFQSS5TVFJFQU0uTkFNRVMgQVBJIiwKICAidGl0bGUiOiAiaW8ubmF0cy5qZXRzdHJlYW0uYXBpLnYxLnN0cmVhbV9uYW1lc19yZXNwb25zZSIsCiAgInR5cGUiOiAib2JqZWN0IiwKICAicmVxdWlyZWQiOiBbCiAgICAidHlwZSIKICBdLAogICJhbGxPZiI6IFsKICAgIHsKICAgICAgInR5cGUiOiAib2JqZWN0IiwKICAgICAgInJlcXVpcmVkIjogWwogICAgICAgICJ0b3RhbCIsCiAgICAgICAgIm9mZnNldCIsCiAgICAgICAgImxpbWl0IgogICAgICBdLAogICAgICAicHJvcGVydGllcyI6IHsKICAgICAgICAidG90YWwiOiB7CiAgICAgICAgICAidHlwZSI6ICJpbnRlZ2VyIiwKICAgICAgICAgICJtaW5pbXVtIjogMAogICAgICAgIH0sCiAgICAgICAgIm9mZnNldCI6IHsKICAgICAgICAgICJ0eXBlIjogImludGVnZXIiLAogICAgICAgICAgIm1pbmltdW0iOiAwCiAgICAgICAgfSwKICAgICAgICAibGltaXQiOiB7CiAgICAgICAgICAidHlwZSI6ICJpbnRlZ2VyIiwKICAgICAgICAgICJtaW5pbXVtIjogMAogICAgICAgIH0KICAgICAgfQogICAgfQogIF0sCiAgIm9uZU9mIjogWwogICAgewogICAgICAidHlwZSI6ICJvYmplY3QiLAogICAgICAicmVxdWlyZWQiOiBbCiAgICAgICAgImVycm9yIgogICAgICBdLAogICAgICAicHJvcGVydGllcyI6IHsKICAgICAgICAiZXJyb3IiOiB7CiAgICAgICAgICAidHlwZSI6ICJvYmplY3QiLAogICAgICAgICAgInJlcXVpcmVkIjogWwogICAgICAgICAgICAiY29kZSIKICAgICAgICAgIF0sCiAgICAgICAgICAicHJvcGVydGllcyI6IHsKICAgICAgICAgICAgImNvZGUiOiB7CiAgICAgICAgICAgICAgInR5cGUiOiAiaW50ZWdlciIsCiAgICAgICAgICAgICAgImRlc2NyaXB0aW9uIjogIkhUVFAgbGlrZSBlcnJvciBjb2RlIGluIHRoZSAzMDAgdG8gNTAwIHJhbmdlIiwKICAgICAgICAgICAgICAibWluaW11bSI6IDMwMCwKICAgICAgICAgICAgICAibWF4aW11bSI6IDY5OQogICAgICAgICAgICB9LAogICAgICAgICAgICAiZGVzY3JpcHRpb24iOiB7CiAgICAgICAgICAgICAgInR5cGUiOiAic3RyaW5nIiwKICAgICAgICAgICAgICAiZGVzY3JpcHRpb24iOiAiQSBodW1hbiBmcmllbmRseSBkZXNjcmlwdGlvbiBvZiB0aGUgZXJyb3IiCiAgICAgICAgICAgIH0KICAgICAgICAgIH0KICAgICAgICB9CiAgICAgIH0KICAgIH0sCiAgICB7CiAgICAgICJ0eXBlIjogIm9iamVjdCIsCiAgICAgICJyZXF1aXJlZCI6IFsKICAgICAgICAic3RyZWFtcyIKICAgICAgXSwKICAgICAgInByb3BlcnRpZXMiOiB7CiAgICAgICAgImNvbnN1bWVycyI6IHsKICAgICAgICAgICJ0eXBlIjogImFycmF5IiwKICAgICAgICAgICJpdGVtcyI6IHsKICAgICAgICAgICAgInR5cGUiOiAic3RyaW5nIgogICAgICAgICAgfQogICAgICAgIH0KICAgICAgfQogICAgfQogIF0sCiAgInByb3BlcnRpZXMiOiB7CiAgICAidHlwZSI6IHsKICAgICAgInR5cGUiOiAic3RyaW5nIiwKICAgICAgImNvbnN0IjogImlvLm5hdHMuamV0c3RyZWFtLmFwaS52MS5zdHJlYW1fbmFtZXNfcmVzcG9uc2UiCiAgICB9CiAgfQp9Cg==")
	schemas["io.nats.jetstream.api.v1.stream_purge_response"], _ = base64.StdEncoding.DecodeString("ewogICIkc2NoZW1hIjogImh0dHA6Ly9qc29uLXNjaGVtYS5vcmcvZHJhZnQtMDcvc2NoZW1hIyIsCiAgIiRpZCI6ICJodHRwczovL25hdHMuaW8vc2NoZW1hcy9qZXRzdHJlYW0vYXBpL3YxL3N0cmVhbV9wdXJnZV9yZXNwb25zZS5qc29uIiwKICAiZGVzY3JpcHRpb24iOiAiQSByZXNwb25zZSBmcm9tIHRoZSBKZXRTdHJlYW0gJEpTLkFQSS5TVFJFQU0uUFVSR0UgQVBJIiwKICAidGl0bGUiOiAiaW8ubmF0cy5qZXRzdHJlYW0uYXBpLnYxLnN0cmVhbV9wdXJnZV9yZXNwb25zZSIsCiAgInR5cGUiOiAib2JqZWN0IiwKICAicmVxdWlyZWQiOiBbCiAgICAidHlwZSIKICBdLAogICJvbmVPZiI6IFsKICAgIHsKICAgICAgInR5cGUiOiAib2JqZWN0IiwKICAgICAgInJlcXVpcmVkIjogWwogICAgICAgICJlcnJvciIKICAgICAgXSwKICAgICAgInByb3BlcnRpZXMiOiB7CiAgICAgICAgImVycm9yIjogewogICAgICAgICAgInR5cGUiOiAib2JqZWN0IiwKICAgICAgICAgICJyZXF1aXJlZCI6IFsKICAgICAgICAgICAgImNvZGUiCiAgICAgICAgICBdLAogICAgICAgICAgInByb3BlcnRpZXMiOiB7CiAgICAgICAgICAgICJjb2RlIjogewogICAgICAgICAgICAgICJ0eXBlIjogImludGVnZXIiLAogICAgICAgICAgICAgICJkZXNjcmlwdGlvbiI6ICJIVFRQIGxpa2UgZXJyb3IgY29kZSBpbiB0aGUgMzAwIHRvIDUwMCByYW5nZSIsCiAgICAgICAgICAgICAgIm1pbmltdW0iOiAzMDAsCiAgICAgICAgICAgICAgIm1heGltdW0iOiA2OTkKICAgICAgICAgICAgfSwKICAgICAgICAgICAgImRlc2NyaXB0aW9uIjogewogICAgICAgICAgICAgICJ0eXBlIjogInN0cmluZyIsCiAgICAgICAgICAgICAgImRlc2NyaXB0aW9uIjogIkEgaHVtYW4gZnJpZW5kbHkgZGVzY3JpcHRpb24gb2YgdGhlIGVycm9yIgogICAgICAgICAgICB9CiAgICAgICAgICB9CiAgICAgICAgfQogICAgICB9CiAgICB9LAogICAgewogICAgICAicmVxdWlyZWQiOiBbCiAgICAgICAgInN1Y2Nlc3MiLAogICAgICAgICJwdXJnZWQiCiAgICAgIF0sCiAgICAgICJ0eXBlIjogIm9iamVjdCIsCiAgICAgICJwcm9wZXJ0aWVzIjogewogICAgICAgICJzdWNjZXNzIjogewogICAgICAgICAgInR5cGUiOiAiYm9vbGVhbiIKICAgICAgICB9LAogICAgICAgICJwdXJnZWQiOiB7CiAgICAgICAgICAiZGVzY3JpcHRpb24iOiAiTnVtYmVyIG9mIG1lc3NhZ2VzIHB1cmdlZCBmcm9tIHRoZSBTdHJlYW0iLAogICAgICAgICAgInR5cGUiOiAiaW50ZWdlciIsCiAgICAgICAgICAibWluaW11bSI6IDAKICAgICAgICB9CiAgICAgIH0KICAgIH0KICBdLAogICJwcm9wZXJ0aWVzIjogewogICAgInR5cGUiOiB7CiAgICAgICJ0eXBlIjogInN0cmluZyIsCiAgICAgICJjb25zdCI6ICJpby5uYXRzLmpldHN0cmVhbS5hcGkudjEuc3RyZWFtX3B1cmdlX3Jlc3BvbnNlIgogICAgfQogIH0KfQo=")
	schemas["io.nats.jetstream.api.v1.stream_snapshot_response"], _ = base64.StdEncoding.DecodeString("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")
	schemas["io.nats.jetstream.api.v1.stream_snapshot_request"], _ = base64.StdEncoding.DecodeString("ewogICIkc2NoZW1hIjogImh0dHA6Ly9qc29uLXNjaGVtYS5vcmcvZHJhZnQtMDcvc2NoZW1hIyIsCiAgIiRpZCI6ICJodHRwczovL25hdHMuaW8vc2NoZW1hcy9qZXRzdHJlYW0vYXBpL3YxL3N0cmVhbV9zbmFwc2hvdF9yZXF1ZXN0Lmpzb24iLAogICJkZXNjcmlwdGlvbiI6ICJBIHJlcXVlc3QgdG8gdGhlIEpldFN0cmVhbSAkSlMuQVBJLlNUUkVBTS5TTkFQU0hPVCBBUEkiLAogICJ0aXRsZSI6ICJpby5uYXRzLmpldHN0cmVhbS5hcGkudjEuc3RyZWFtX3NuYXBzaG90X3JlcXVlc3QiLAogICJ0eXBlIjogIm9iamVjdCIsCiAgInJlcXVpcmVkIjogWwogICAgImRlbGl2ZXJfc3ViamVjdCIKICBdLAogICJhZGRpdGlvbmFsUHJvcGVydGllcyI6IGZhbHNlLAogICJwcm9wZXJ0aWVzIjogewogICAgImRlbGl2ZXJfc3ViamVjdCI6IHsKICAgICAgInR5cGUiOiAic3RyaW5nIiwKICAgICAgImRlc2NyaXB0aW9uIjogIlRoZSBOQVRTIHN1YmplY3Qgd2hlcmUgdGhlIHNuYXBzaG90IHdpbGwgYmUgZGVsaXZlcmVkIiwKICAgICAgIm1pbkxlbmd0aCI6IDEKICAgIH0sCiAgICAibm9fY29uc3VtZXJzIjogewogICAgICAidHlwZSI6ICJib29sZWFuIiwKICAgICAgImRlc2NyaXB0aW9uIjogIldoZW4gdHJ1ZSBjb25zdW1lciBzdGF0ZXMgYW5kIGNvbmZpZ3VyYXRpb25zIHdpbGwgbm90IGJlIHByZXNlbnQgaW4gdGhlIHNuYXBzaG90IgogICAgfSwKICAgICJjaHVua19zaXplIjogewogICAgICAidHlwZSI6ICJpbnRlZ2VyIiwKICAgICAgImRlc2NyaXB0aW9uIjogIlRoZSBzaXplIG9mIGRhdGEgY2h1bmtzIHRvIHNlbmQgdG8gZGVsaXZlcl9zdWJqZWN0IiwKICAgICAgIm1pbmltdW0iOiAxMDI0CiAgICB9LAogICAgImpzY2siOiB7CiAgICAgICJ0eXBlIjogImJvb2xlYW4iLAogICAgICAiZGVzY3JpcHRpb24iOiAiQ2hlY2sgYWxsIG1lc3NhZ2UncyBjaGVja3N1bXMgcHJpb3IgdG8gc25hcHNob3QiLAogICAgICAiZGVmYXVsdCI6IGZhbHNlCiAgICB9CiAgfQp9Cg==")
	schemas["io.nats.jetstream.api.v1.stream_restore_request"], _ = base64.StdEncoding.DecodeString("ewogICIkc2NoZW1hIjogImh0dHA6Ly9qc29uLXNjaGVtYS5vcmcvZHJhZnQtMDcvc2NoZW1hIyIsCiAgIiRpZCI6ICJodHRwczovL25hdHMuaW8vc2NoZW1hcy9qZXRzdHJlYW0vYXBpL3YxL3N0cmVhbV9yZXN0b3JlX3JlcXVlc3QuanNvbiIsCiAgImRlc2NyaXB0aW9uIjogIkEgcmVzcG9uc2UgZnJvbSB0aGUgSmV0U3RyZWFtICRKUy5BUEkuU1RSRUFNLlJFU1RPUkUgQVBJIiwKICAidGl0bGUiOiAiaW8ubmF0cy5qZXRzdHJlYW0uYXBpLnYxLnN0cmVhbV9yZXN0b3JlX3JlcXVlc3QiLAogICJ0eXBlIjogIm9iamVjdCIsCiAgInJlcXVpcmVkIjogWwogICAgImNvbmZpZyIsCiAgICAic3RhdGUiCiAgXSwKICAicHJvcGVydGllcyI6IHsKICAgICJjb25maWciOiB7CiAgICAgICJ0eXBlIjogIm9iamVjdCIsCiAgICAgICJyZXF1aXJlZCI6IFsKICAgICAgICAicmV0ZW50aW9uIiwKICAgICAgICAibWF4X2NvbnN1bWVycyIsCiAgICAgICAgIm1heF9tc2dzIiwKICAgICAgICAibWF4X2J5dGVzIiwKICAgICAgICAibWF4X2FnZSIsCiAgICAgICAgInN0b3JhZ2UiLAogICAgICAgICJudW1fcmVwbGljYXMiCiAgICAgIF0sCiAgICAgICJhZGRpdGlvbmFsUHJvcGVydGllcyI6IGZhbHNlLAogICAgICAicHJvcGVydGllcyI6IHsKICAgICAgICAibmFtZSI6IHsKICAgICAgICAgICJkZXNjcmlwdGlvbiI6ICJBIHVuaXF1ZSBuYW1lIGZvciB0aGUgU3RyZWFtLCBlbXB0eSBmb3IgU3RyZWFtIFRlbXBsYXRlcy4iLAogICAgICAgICAgInR5cGUiOiAic3RyaW5nIiwKICAgICAgICAgICJwYXR0ZXJuIjogIl5bXi4qPl0qJCIsCiAgICAgICAgICAibWluTGVuZ3RoIjogMAogICAgICAgIH0sCiAgICAgICAgInN1YmplY3RzIjogewogICAgICAgICAgImRlc2NyaXB0aW9uIjogIkEgbGlzdCBvZiBzdWJqZWN0cyB0byBjb25zdW1lLCBzdXBwb3J0cyB3aWxkY2FyZHMuIE11c3QgYmUgZW1wdHkgd2hlbiBhIG1pcnJvciBpcyBjb25maWd1cmVkLiBNYXkgYmUgZW1wdHkgd2hlbiBzb3VyY2VzIGFyZSBjb25maWd1cmVkLiIsCiAgICAgICAgICAidHlwZSI6ICJhcnJheSIsCiAgICAgICAgICAibWluTGVuZ3RoIjogMCwKICAgICAgICAgICJpdGVtcyI6IHsKICAgICAgICAgICAgInR5cGUiOiAic3RyaW5nIgogICAgICAgICAgfQogICAgICAgIH0sCiAgICAgICAgInJldGVudGlvbiI6IHsKICAgICAgICAgICJkZXNjcmlwdGlvbiI6ICJIb3cgbWVzc2FnZXMgYXJlIHJldGFpbmVkIGluIHRoZSBTdHJlYW0sIG9uY2UgdGhpcyBpcyBleGNlZWRlZCBvbGQgbWVzc2FnZXMgYXJlIHJlbW92ZWQuIiwKICAgICAgICAgICJ0eXBlIjogInN0cmluZyIsCiAgICAgICAgICAiZW51bSI6IFsKICAgICAgICAgICAgImxpbWl0cyIsCiAgICAgICAgICAgICJpbnRlcmVzdCIsCiAgICAgICAgICAgICJ3b3JrcXVldWUiCiAgICAgICAgICBdLAogICAgICAgICAgImRlZmF1bHQiOiAibGltaXRzIgogICAgICAgIH0sCiAgICAgICAgIm1heF9jb25zdW1lcnMiOiB7CiAgICAgICAgICAiZGVzY3JpcHRpb24iOiAiSG93IG1hbnkgQ29uc3VtZXJzIGNhbiBiZSBkZWZpbmVkIGZvciBhIGdpdmVuIFN0cmVhbS4gLTEgZm9yIHVubGltaXRlZC4iLAogICAgICAgICAgInR5cGUiOiAiaW50ZWdlciIsCiAgICAgICAgICAibWluaW11bSI6IC0xLAogICAgICAgICAgImRlZmF1bHQiOiAtMQogICAgICAgIH0sCiAgICAgICAgIm1heF9tc2dzIjogewogICAgICAgICAgImRlc2NyaXB0aW9uIjogIkhvdyBtYW55IG1lc3NhZ2VzIG1heSBiZSBpbiBhIFN0cmVhbSwgb2xkZXN0IG1lc3NhZ2VzIHdpbGwgYmUgcmVtb3ZlZCBpZiB0aGUgU3RyZWFtIGV4Y2VlZHMgdGhpcyBzaXplLiAtMSBmb3IgdW5saW1pdGVkLiIsCiAgICAgICAgICAidHlwZSI6ICJpbnRlZ2VyIiwKICAgICAgICAgICJtaW5pbXVtIjogLTEsCiAgICAgICAgICAiZGVmYXVsdCI6IC0xCiAgICAgICAgfSwKICAgICAgICAibWF4X2J5dGVzIjogewogICAgICAgICAgImRlc2NyaXB0aW9uIjogIkhvdyBiaWcgdGhlIFN0cmVhbSBtYXkgYmUsIHdoZW4gdGhlIGNvbWJpbmVkIHN0cmVhbSBzaXplIGV4Y2VlZHMgdGhpcyBvbGQgbWVzc2FnZXMgYXJlIHJlbW92ZWQuIC0xIGZvciB1bmxpbWl0ZWQuIiwKICAgICAgICAgICJ0eXBlIjogImludGVnZXIiLAogICAgICAgICAgIm1pbmltdW0iOiAtMSwKICAgICAgICAgICJkZWZhdWx0IjogLTEKICAgICAgICB9LAogICAgICAgICJtYXhfYWdlIjogewogICAgICAgICAgImRlc2NyaXB0aW9uIjogIk1heGltdW0gYWdlIG9mIGFueSBtZXNzYWdlIGluIHRoZSBzdHJlYW0sIGV4cHJlc3NlZCBpbiBuYW5vc2Vjb25kcy4gMCBmb3IgdW5saW1pdGVkLiIsCiAgICAgICAgICAidHlwZSI6ICJpbnRlZ2VyIiwKICAgICAgICAgICJtaW5pbXVtIjogMCwKICAgICAgICAgICJkZWZhdWx0IjogMAogICAgICAgIH0sCiAgICAgICAgIm1heF9tc2dfc2l6ZSI6IHsKICAgICAgICAgICJkZXNjcmlwdGlvbiI6ICJUaGUgbGFyZ2VzdCBtZXNzYWdlIHRoYXQgd2lsbCBiZSBhY2NlcHRlZCBieSB0aGUgU3RyZWFtLiAtMSBmb3IgdW5saW1pdGVkLiIsCiAgICAgICAgICAidHlwZSI6ICJpbnRlZ2VyIiwKICAgICAgICAgICJtaW5pbXVtIjogLTEsCiAgICAgICAgICAiZGVmYXVsdCI6IC0xCiAgICAgICAgfSwKICAgICAgICAic3RvcmFnZSI6IHsKICAgICAgICAgICJkZXNjcmlwdGlvbiI6ICJUaGUgc3RvcmFnZSBiYWNrZW5kIHRvIHVzZSBmb3IgdGhlIFN0cmVhbS4iLAogICAgICAgICAgInR5cGUiOiAic3RyaW5nIiwKICAgICAgICAgICJlbnVtIjogWwogICAgICAgICAgICAiZmlsZSIsCiAgICAgICAgICAgICJtZW1vcnkiCiAgICAgICAgICBdLAogICAgICAgICAgImRlZmF1bHQiOiAiZmlsZSIKICAgICAgICB9LAogICAgICAgICJudW1fcmVwbGljYXMiOiB7CiAgICAgICAgICAiZGVzY3JpcHRpb24iOiAiSG93IG1hbnkgcmVwbGljYXMgdG8ga2VlcCBmb3IgZWFjaCBtZXNzYWdlLiIsCiAgICAgICAgICAidHlwZSI6ICJpbnRlZ2VyIiwKICAgICAgICAgICJtaW5pbXVtIjogMSwKICAgICAgICAgICJkZWZhdWx0IjogMSwKICAgICAgICAgICJtYXhpbXVtIjogNQogICAgICAgIH0sCiAgICAgICAgIm5vX2FjayI6IHsKICAgICAgICAgICJkZXNjcmlwdGlvbiI6ICJEaXNhYmxlcyBhY2tub3dsZWRnaW5nIG1lc3NhZ2VzIHRoYXQgYXJlIHJlY2VpdmVkIGJ5IHRoZSBTdHJlYW0uIiwKICAgICAgICAgICJ0eXBlIjogImJvb2xlYW4iLAogICAgICAgICAgImRlZmF1bHQiOiBmYWxzZQogICAgICAgIH0sCiAgICAgICAgInRlbXBsYXRlX293bmVyIjogewogICAgICAgICAgImRlc2NyaXB0aW9uIjogIldoZW4gdGhlIFN0cmVhbSBpcyBtYW5hZ2VkIGJ5IGEgU3RyZWFtIFRlbXBsYXRlIHRoaXMgaWRlbnRpZmllcyB0aGUgdGVtcGxhdGUgdGhhdCBtYW5hZ2VzIHRoZSBTdHJlYW0uIiwKICAgICAgICAgICJ0eXBlIjogInN0cmluZyIKICAgICAgICB9LAogICAgICAgICJkaXNjYXJkIjogewogICAgICAgICAgImRlc2NyaXB0aW9uIjogIldoZW4gYSBTdHJlYW0gcmVhY2ggaXQncyBsaW1pdHMgZWl0aGVyIG9sZCBtZXNzYWdlcyBhcmUgZGVsZXRlZCBvciBuZXcgb25lcyBhcmUgZGVuaWVkIiwKICAgICAgICAgICJ0eXBlIjogInN0cmluZyIsCiAgICAgICAgICAiZW51bSI6IFsKICAgICAgICAgICAgIm9sZCIsCiAgICAgICAgICAgICJuZXciCiAgICAgICAgICBdLAogICAgICAgICAgImRlZmF1bHQiOiAib2xkIgogICAgICAgIH0sCiAgICAgICAgImR1cGxpY2F0ZV93aW5kb3ciOiB7CiAgICAgICAgICAiZGVzY3JpcHRpb24iOiAiVGhlIHRpbWUgd2luZG93IHRvIHRyYWNrIGR1cGxpY2F0ZSBtZXNzYWdlcyBmb3IsIGV4cHJlc3NlZCBpbiBuYW5vc2Vjb25kcy4gMCBmb3IgZGVmYXVsdCIsCiAgICAgICAgICAidHlwZSI6ICJpbnRlZ2VyIiwKICAgICAgICAgICJtaW5pbXVtIjogMCwKICAgICAgICAgICJkZWZhdWx0IjogMAogICAgICAgIH0sCiAgICAgICAgInBsYWNlbWVudCI6IHsKICAgICAgICAgICJkZXNjcmlwdGlvbiI6ICJQbGFjZW1lbnQgZGlyZWN0aXZlcyB0byBjb25zaWRlciB3aGVuIHBsYWNpbmcgcmVwbGljYXMgb2YgdGhpcyBzdHJlYW0sIHJhbmRvbSBwbGFjZW1lbnQgd2hlbiB1bnNldCIsCiAgICAgICAgICAidHlwZSI6ICJvYmplY3QiLAogICAgICAgICAgInJlcXVpcmVkIjogWwogICAgICAgICAgICAiY2x1c3RlciIKICAgICAgICAgIF0sCiAgICAgICAgICAicHJvcGVydGllcyI6IHsKICAgICAgICAgICAgImNsdXN0ZXIiOiB7CiAgICAgICAgICAgICAgInR5cGUiOiAic3RyaW5nIiwKICAgICAgICAgICAgICAiZGVzY3JpcHRpb24iOiAiVGhlIGRlc2lyZWQgY2x1c3RlciBuYW1lIHRvIHBsYWNlIHRoZSBzdHJlYW0iLAogICAgICAgICAgICAgICJtaW5MZW5ndGgiOiAxCiAgICAgICAgICAgIH0sCiAgICAgICAgICAgICJ0YWdzIjogewogICAgICAgICAgICAgICJkZXNjcmlwdGlvbiI6ICJUYWdzIHJlcXVpcmVkIG9uIHNlcnZlcnMgaG9zdGluZyB0aGlzIHN0cmVhbSIsCiAgICAgICAgICAgICAgInR5cGUiOiAiYXJyYXkiLAogICAgICAgICAgICAgICJpdGVtcyI6IHsKICAgICAgICAgICAgICAgICJ0eXBlIjogInN0cmluZyIKICAgICAgICAgICAgICB9CiAgICAgICAgICAgIH0KICAgICAgICAgIH0KICAgICAgICB9LAogICAgICAgICJtaXJyb3IiOiB7CiAgICAgICAgICAiZGVzY3JpcHRpb24iOiAiTWFpbnRhaW5zIGEgMToxIG1pcnJvciBvZiBhbm90aGVyIHN0cmVhbSB3aXRoIG5hbWUgbWF0Y2hpbmcgdGhpcyBwcm9wZXJ0eS4gIFdoZW4gYSBtaXJyb3IgaXMgY29uZmlndXJlZCBzdWJqZWN0cyBhbmQgc291cmNlcyBtdXN0IGJlIGVtcHR5LiIsCiAgICAgICAgICAidHlwZSI6ICJvYmplY3QiLAogICAgICAgICAgInJlcXVpcmVkIjogWwogICAgICAgICAgICAibmFtZSIKICAgICAgICAgIF0sCiAgICAgICAgICAicHJvcGVydGllcyI6IHsKICAgICAgICAgICAgIm5hbWUiOiB7CiAgICAgICAgICAgICAgImRlc2NyaXB0aW9uIjogIlN0cmVhbSBuYW1lIiwKICAgICAgICAgICAgICAidHlwZSI6ICJzdHJpbmciLAogICAgICAgICAgICAgICJwYXR0ZXJuIjogIl5bXi4qPl0rJCIsCiAgICAgICAgICAgICAgIm1pbkxlbmd0aCI6IDEKICAgICAgICAgICAgfSwKICAgICAgICAgICAgIm9wdF9zdGFydF9zZXEiOiB7CiAgICAgICAgICAgICAgImRlc2NyaXB0aW9uIjogIlNlcXVlbmNlIHRvIHN0YXJ0IHJlcGxpY2F0aW5nIGZyb20iLAogICAgICAgICAgICAgICJ0eXBlIjogImludGVnZXIiLAogICAgICAgICAgICAgICJtaW5pbXVtIjogMAogICAgICAgICAgICB9LAogICAgICAgICAgICAib3B0X3N0YXJ0X3RpbWUiOiB7CiAgICAgICAgICAgICAgImRlc2NyaXB0aW9uIjogIlRpbWUgc3RhbXAgdG8gc3RhcnQgcmVwbGljYXRpbmcgZnJvbSIsCiAgICAgICAgICAgICAgInR5cGUiOiAic3RyaW5nIgogICAgICAgICAgICB9LAogICAgICAgICAgICAiZmlsdGVyX3N1YmplY3QiOiB7CiAgICAgICAgICAgICAgImRlc2NyaXB0aW9uIjogIlJlcGxpY2F0ZSBvbmx5IGEgc3Vic2V0IG9mIG1lc3NhZ2VzIGJhc2VkIG9uIGZpbHRlciIsCiAgICAgICAgICAgICAgInR5cGUiOiAic3RyaW5nIgogICAgICAgICAgICB9LAogICAgICAgICAgICAiZXh0ZXJuYWwiOiB7CiAgICAgICAgICAgICAgInJlcXVpcmVkIjogWwogICAgICAgICAgICAgICAgImFwaSIsCiAgICAgICAgICAgICAgICAiZGVsaXZlciIKICAgICAgICAgICAgICBdLAogICAgICAgICAgICAgICJ0eXBlIjogIm9iamVjdCIsCiAgICAgICAgICAgICAgImRlc2NyaXB0aW9uIjogIkNvbmZpZ3VyYXRpb24gcmVmZXJlbmNpbmcgYSBzdHJlYW0gc291cmNlIGluIGFub3RoZXIgYWNjb3VudCIsCiAgICAgICAgICAgICAgInByb3BlcnRpZXMiOiB7CiAgICAgICAgICAgICAgICAiYXBpIjogewogICAgICAgICAgICAgICAgICAidHlwZSI6ICJzdHJpbmciLAogICAgICAgICAgICAgICAgICAiZGVzY3JpcHRpb24iOiAiVGhlIHN1YmplY3QgcHJlZml4IHRoYXQgaW1wb3J0cyB0aGUgb3RoZXIgYWNjb3VudCAkSlMuQVBJLkNPTlNVTUVSLj4gc3ViamVjdHMiCiAgICAgICAgICAgICAgICB9LAogICAgICAgICAgICAgICAgImRlbGl2ZXIiOiB7CiAgICAgICAgICAgICAgICAgICJ0eXBlIjogInN0cmluZyIsCiAgICAgICAgICAgICAgICAgICJkZXNjcmlwdGlvbiI6ICJUaGUgZGVsaXZlcnkgc3ViamVjdCB0byB1c2UgZm9yIHRoZSBwdXNoIGNvbnN1bWVyIgogICAgICAgICAgICAgICAgfQogICAgICAgICAgICAgIH0KICAgICAgICAgICAgfQogICAgICAgICAgfQogICAgICAgIH0sCiAgICAgICAgInNvdXJjZXMiOiB7CiAgICAgICAgICAidHlwZSI6ICJhcnJheSIsCiAgICAgICAgICAiZGVzY3JpcHRpb24iOiAiTGlzdCBvZiBTdHJlYW0gbmFtZXMgdG8gcmVwbGljYXRlIGludG8gdGhpcyBTdHJlYW0iLAogICAgICAgICAgIml0ZW1zIjogewogICAgICAgICAgICAidHlwZSI6ICJvYmplY3QiLAogICAgICAgICAgICAiZGVzY3JpcHRpb24iOiAiRGVmaW5lcyBhIHNvdXJjZSB3aGVyZSBzdHJlYW1zIHNob3VsZCBiZSByZXBsaWNhdGVkIGZyb20iLAogICAgICAgICAgICAicmVxdWlyZWQiOiBbCiAgICAgICAgICAgICAgIm5hbWUiCiAgICAgICAgICAgIF0sCiAgICAgICAgICAgICJwcm9wZXJ0aWVzIjogewogICAgICAgICAgICAgICJuYW1lIjogewogICAgICAgICAgICAgICAgImRlc2NyaXB0aW9uIjogIlN0cmVhbSBuYW1lIiwKICAgICAgICAgICAgICAgICJ0eXBlIjogInN0cmluZyIsCiAgICAgICAgICAgICAgICAicGF0dGVybiI6ICJeW14uKj5dKyQiLAogICAgICAgICAgICAgICAgIm1pbkxlbmd0aCI6IDEKICAgICAgICAgICAgICB9LAogICAgICAgICAgICAgICJvcHRfc3RhcnRfc2VxIjogewogICAgICAgICAgICAgICAgImRlc2NyaXB0aW9uIjogIlNlcXVlbmNlIHRvIHN0YXJ0IHJlcGxpY2F0aW5nIGZyb20iLAogICAgICAgICAgICAgICAgInR5cGUiOiAiaW50ZWdlciIsCiAgICAgICAgICAgICAgICAibWluaW11bSI6IDAKICAgICAgICAgICAgICB9LAogICAgICAgICAgICAgICJvcHRfc3RhcnRfdGltZSI6IHsKICAgICAgICAgICAgICAgICJkZXNjcmlwdGlvbiI6ICJUaW1lIHN0YW1wIHRvIHN0YXJ0IHJlcGxpY2F0aW5nIGZyb20iLAogICAgICAgICAgICAgICAgInR5cGUiOiAic3RyaW5nIgogICAgICAgICAgICAgIH0sCiAgICAgICAgICAgICAgImZpbHRlcl9zdWJqZWN0IjogewogICAgICAgICAgICAgICAgImRlc2NyaXB0aW9uIjogIlJlcGxpY2F0ZSBvbmx5IGEgc3Vic2V0IG9mIG1lc3NhZ2VzIGJhc2VkIG9uIGZpbHRlciIsCiAgICAgICAgICAgICAgICAidHlwZSI6ICJzdHJpbmciCiAgICAgICAgICAgICAgfSwKICAgICAgICAgICAgICAiZXh0ZXJuYWwiOiB7CiAgICAgICAgICAgICAgICAicmVxdWlyZWQiOiBbCiAgICAgICAgICAgICAgICAgICJhcGkiLAogICAgICAgICAgICAgICAgICAiZGVsaXZlciIKICAgICAgICAgICAgICAgIF0sCiAgICAgICAgICAgICAgICAidHlwZSI6ICJvYmplY3QiLAogICAgICAgICAgICAgICAgImRlc2NyaXB0aW9uIjogIkNvbmZpZ3VyYXRpb24gcmVmZXJlbmNpbmcgYSBzdHJlYW0gc291cmNlIGluIGFub3RoZXIgYWNjb3VudCIsCiAgICAgICAgICAgICAgICAicHJvcGVydGllcyI6IHsKICAgICAgICAgICAgICAgICAgImFwaSI6IHsKICAgICAgICAgICAgICAgICAgICAidHlwZSI6ICJzdHJpbmciLAogICAgICAgICAgICAgICAgICAgICJkZXNjcmlwdGlvbiI6ICJUaGUgc3ViamVjdCBwcmVmaXggdGhhdCBpbXBvcnRzIHRoZSBvdGhlciBhY2NvdW50ICRKUy5BUEkuQ09OU1VNRVIuPiBzdWJqZWN0cyIKICAgICAgICAgICAgICAgICAgfSwKICAgICAgICAgICAgICAgICAgImRlbGl2ZXIiOiB7CiAgICAgICAgICAgICAgICAgICAgInR5cGUiOiAic3RyaW5nIiwKICAgICAgICAgICAgICAgICAgICAiZGVzY3JpcHRpb24iOiAiVGhlIGRlbGl2ZXJ5IHN1YmplY3QgdG8gdXNlIGZvciB0aGUgcHVzaCBjb25zdW1lciIKICAgICAgICAgICAgICAgICAgfQogICAgICAgICAgICAgICAgfQogICAgICAgICAgICAgIH0KICAgICAgICAgICAgfQogICAgICAgICAgfQogICAgICAgIH0KICAgICAgfQogICAgfSwKICAgICJzdGF0ZSI6IHsKICAgICAgInR5cGUiOiAib2JqZWN0IiwKICAgICAgImFkZGl0aW9uYWxQcm9wZXJ0aWVzIjogZmFsc2UsCiAgICAgICJyZXF1aXJlZCI6IFsKICAgICAgICAibWVzc2FnZXMiLAogICAgICAgICJieXRlcyIsCiAgICAgICAgImZpcnN0X3NlcSIsCiAgICAgICAgImxhc3Rfc2VxIiwKICAgICAgICAiY29uc3VtZXJfY291bnQiCiAgICAgIF0sCiAgICAgICJwcm9wZXJ0aWVzIjogewogICAgICAgICJtZXNzYWdlcyI6IHsKICAgICAgICAgICJ0eXBlIjogImludGVnZXIiLAogICAgICAgICAgImRlc2NyaXB0aW9uIjogIk51bWJlciBvZiBtZXNzYWdlcyBzdG9yZWQgaW4gdGhlIFN0cmVhbSIsCiAgICAgICAgICAibWluaW11bSI6IDAKICAgICAgICB9LAogICAgICAgICJieXRlcyI6IHsKICAgICAgICAgICJ0eXBlIjogImludGVnZXIiLAogICAgICAgICAgImRlc2NyaXB0aW9uIjogIkNvbWJpbmVkIHNpemUgb2YgYWxsIG1lc3NhZ2VzIGluIHRoZSBTdHJlYW0iLAogICAgICAgICAgIm1pbmltdW0iOiAwCiAgICAgICAgfSwKICAgICAgICAiZmlyc3Rfc2VxIjogewogICAgICAgICAgInR5cGUiOiAiaW50ZWdlciIsCiAgICAgICAgICAiZGVzY3JpcHRpb24iOiAiU2VxdWVuY2UgbnVtYmVyIG9mIHRoZSBmaXJzdCBtZXNzYWdlIGluIHRoZSBTdHJlYW0iLAogICAgICAgICAgIm1pbmltdW0iOiAwCiAgICAgICAgfSwKICAgICAgICAiZmlyc3RfdHMiOiB7CiAgICAgICAgICAidHlwZSI6ICJzdHJpbmciLAogICAgICAgICAgImRlc2NyaXB0aW9uIjogIlRoZSB0aW1lc3RhbXAgb2YgdGhlIGZpcnN0IG1lc3NhZ2UgaW4gdGhlIFN0cmVhbSIKICAgICAgICB9LAogICAgICAgICJsYXN0X3NlcSI6IHsKICAgICAgICAgICJ0eXBlIjogImludGVnZXIiLAogICAgICAgICAgImRlc2NyaXB0aW9uIjogIlNlcXVlbmNlIG51bWJlciBvZiB0aGUgbGFzdCBtZXNzYWdlIGluIHRoZSBTdHJlYW0iLAogICAgICAgICAgIm1pbmltdW0iOiAwCiAgICAgICAgfSwKICAgICAgICAibGFzdF90cyI6IHsKICAgICAgICAgICJ0eXBlIjogInN0cmluZyIsCiAgICAgICAgICAiZGVzY3JpcHRpb24iOiAiVGhlIHRpbWVzdGFtcCBvZiB0aGUgbGFzdCBtZXNzYWdlIGluIHRoZSBTdHJlYW0iCiAgICAgICAgfSwKICAgICAgICAiZGVsZXRlZCI6IHsKICAgICAgICAgICJkZXNjcmlwdGlvbiI6ICJJRHMgb2YgbWVzc2FnZXMgdGhhdCB3ZXJlIGRlbGV0ZWQgdXNpbmcgdGhlIE1lc3NhZ2UgRGVsZXRlIEFQSSIsCiAgICAgICAgICAidHlwZSI6ICJhcnJheSIsCiAgICAgICAgICAibWluTGVuZ3RoIjogMCwKICAgICAgICAgICJpdGVtcyI6IHsKICAgICAgICAgICAgInR5cGUiOiAiaW50ZWdlciIsCiAgICAgICAgICAgICJtaW5pbXVtIjogMAogICAgICAgICAgfQogICAgICAgIH0sCiAgICAgICAgImxvc3QiOiB7CiAgICAgICAgICAidHlwZSI6ICJvYmplY3QiLAogICAgICAgICAgImRlc2NyaXB0aW9uIjogIlJlY29yZHMgbWVzc2FnZXMgdGhhdCB3ZXJlIGRhbWFnZWQgYW5kIHVucmVjb3ZlcmFibGUiLAogICAgICAgICAgInByb3BlcnRpZXMiOiB7CiAgICAgICAgICAgICJtc2dzIjogewogICAgICAgICAgICAgICJ0eXBlIjogImFycmF5IiwKICAgICAgICAgICAgICAiZGVzY3JpcHRpb24iOiAiVGhlIG1lc3NhZ2VzIHRoYXQgd2VyZSBsb3N0IiwKICAgICAgICAgICAgICAiaXRlbXMiOiB7CiAgICAgICAgICAgICAgICAidHlwZSI6ICJpbnRlZ2VyIiwKICAgICAgICAgICAgICAgICJtaW5pbXVtIjogMAogICAgICAgICAgICAgIH0KICAgICAgICAgICAgfSwKICAgICAgICAgICAgImJ5dGVzIjogewogICAgICAgICAgICAgICJkZXNjcmlwdGlvbiI6ICJUaGUgbnVtYmVyIG9mIGJ5dGVzIHRoYXQgd2VyZSBsb3N0IiwKICAgICAgICAgICAgICAidHlwZSI6ICJpbnRlZ2VyIgogICAgICAgICAgICB9CiAgICAgICAgICB9CiAgICAgICAgfSwKICAgICAgICAiY29uc3VtZXJfY291bnQiOiB7CiAgICAgICAgICAidHlwZSI6ICJpbnRlZ2VyIiwKICAgICAgICAgICJkZXNjcmlwdGlvbiI6ICJOdW1iZXIgb2YgQ29uc3VtZXJzIGF0dGFjaGVkIHRvIHRoZSBTdHJlYW0iLAogICAgICAgICAgIm1pbmltdW0iOiAwCiAgICAgICAgfQogICAgICB9CiAgICB9CiAgfQp9Cg==")
	schemas["io.nats.jetstream.api.v1.stream_restore_response"], _ = base64.StdEncoding.DecodeString("ewogICIkc2NoZW1hIjogImh0dHA6Ly9qc29uLXNjaGVtYS5vcmcvZHJhZnQtMDcvc2NoZW1hIyIsCiAgIiRpZCI6ICJodHRwczovL25hdHMuaW8vc2NoZW1hcy9qZXRzdHJlYW0vYXBpL3YxL3N0cmVhbV9yZXN0b3JlX3Jlc3BvbnNlLmpzb24iLAogICJkZXNjcmlwdGlvbiI6ICJBIHJlc3BvbnNlIGZyb20gdGhlIEpldFN0cmVhbSAkSlMuQVBJLlNUUkVBTS5SRVNUT1JFIEFQSSIsCiAgInRpdGxlIjogImlvLm5hdHMuamV0c3RyZWFtLmFwaS52MS5zdHJlYW1fcmVzdG9yZV9yZXNwb25zZSIsCiAgInR5cGUiOiAib2JqZWN0IiwKICAib25lT2YiOiBbCiAgICB7CiAgICAgICJ0eXBlIjogIm9iamVjdCIsCiAgICAgICJyZXF1aXJlZCI6IFsKICAgICAgICAiZXJyb3IiCiAgICAgIF0sCiAgICAgICJwcm9wZXJ0aWVzIjogewogICAgICAgICJlcnJvciI6IHsKICAgICAgICAgICJ0eXBlIjogIm9iamVjdCIsCiAgICAgICAgICAicmVxdWlyZWQiOiBbCiAgICAgICAgICAgICJjb2RlIgogICAgICAgICAgXSwKICAgICAgICAgICJwcm9wZXJ0aWVzIjogewogICAgICAgICAgICAiY29kZSI6IHsKICAgICAgICAgICAgICAidHlwZSI6ICJpbnRlZ2VyIiwKICAgICAgICAgICAgICAiZGVzY3JpcHRpb24iOiAiSFRUUCBsaWtlIGVycm9yIGNvZGUgaW4gdGhlIDMwMCB0byA1MDAgcmFuZ2UiLAogICAgICAgICAgICAgICJtaW5pbXVtIjogMzAwLAogICAgICAgICAgICAgICJtYXhpbXVtIjogNjk5CiAgICAgICAgICAgIH0sCiAgICAgICAgICAgICJkZXNjcmlwdGlvbiI6IHsKICAgICAgICAgICAgICAidHlwZSI6ICJzdHJpbmciLAogICAgICAgICAgICAgICJkZXNjcmlwdGlvbiI6ICJBIGh1bWFuIGZyaWVuZGx5IGRlc2NyaXB0aW9uIG9mIHRoZSBlcnJvciIKICAgICAgICAgICAgfQogICAgICAgICAgfQogICAgICAgIH0KICAgICAgfQogICAgfSwKICAgIHsKICAgICAgInJlcXVpcmVkIjogWwogICAgICAgICJkZWxpdmVyX3N1YmplY3QiCiAgICAgIF0sCiAgICAgICJ0eXBlIjogIm9iamVjdCIsCiAgICAgICJwcm9wZXJ0aWVzIjogewogICAgICAgICJkZWxpdmVyX3N1YmplY3QiOiB7CiAgICAgICAgICAidHlwZSI6ICJzdHJpbmciLAogICAgICAgICAgImRlc2NyaXB0aW9uIjogIlRoZSBTdWJqZWN0IHRvIHNlbmQgcmVzdG9yZSBjaHVua3MgdG8iLAogICAgICAgICAgIm1pbkxlbmd0aCI6IDEKICAgICAgICB9CiAgICAgIH0KICAgIH0KICBdLAogICJwcm9wZXJ0aWVzIjogewogICAgInR5cGUiOiB7CiAgICAgICJ0eXBlIjogInN0cmluZyIsCiAgICAgICJjb25zdCI6ICJpby5uYXRzLmpldHN0cmVhbS5hcGkudjEuc3RyZWFtX3Jlc3RvcmVfcmVzcG9uc2UiCiAgICB9CiAgfQp9Cg==")
	schemas["io.nats.jetstream.api.v1.stream_template_create_request"], _ = base64.StdEncoding.DecodeString("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")
	schemas["io.nats.jetstream.api.v1.stream_template_create_response"], _ = base64.StdEncoding.DecodeString("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")
	schemas["io.nats.jetstream.api.v1.stream_template_delete_response"], _ = base64.StdEncoding.DecodeString("ewogICIkc2NoZW1hIjogImh0dHA6Ly9qc29uLXNjaGVtYS5vcmcvZHJhZnQtMDcvc2NoZW1hIyIsCiAgIiRpZCI6ICJodHRwczovL25hdHMuaW8vc2NoZW1hcy9qZXRzdHJlYW0vYXBpL3YxL3N0cmVhbV90ZW1wbGF0ZV9kZWxldGVfcmVzcG9uc2UuanNvbiIsCiAgImRlc2NyaXB0aW9uIjogIkEgcmVzcG9uc2UgZnJvbSB0aGUgSmV0U3RyZWFtICRKUy5BUEkuU1RSRUFNLlRFTVBMQVRFLkRFTEVURSBBUEkiLAogICJ0aXRsZSI6ICJpby5uYXRzLmpldHN0cmVhbS5hcGkudjEuc3RyZWFtX3RlbXBsYXRlX2RlbGV0ZV9yZXNwb25zZSIsCiAgInR5cGUiOiAib2JqZWN0IiwKICAicmVxdWlyZWQiOiBbCiAgICAidHlwZSIKICBdLAogICJvbmVPZiI6IFsKICAgIHsKICAgICAgInR5cGUiOiAib2JqZWN0IiwKICAgICAgInJlcXVpcmVkIjogWwogICAgICAgICJlcnJvciIKICAgICAgXSwKICAgICAgInByb3BlcnRpZXMiOiB7CiAgICAgICAgImVycm9yIjogewogICAgICAgICAgInR5cGUiOiAib2JqZWN0IiwKICAgICAgICAgICJyZXF1aXJlZCI6IFsKICAgICAgICAgICAgImNvZGUiCiAgICAgICAgICBdLAogICAgICAgICAgInByb3BlcnRpZXMiOiB7CiAgICAgICAgICAgICJjb2RlIjogewogICAgICAgICAgICAgICJ0eXBlIjogImludGVnZXIiLAogICAgICAgICAgICAgICJkZXNjcmlwdGlvbiI6ICJIVFRQIGxpa2UgZXJyb3IgY29kZSBpbiB0aGUgMzAwIHRvIDUwMCByYW5nZSIsCiAgICAgICAgICAgICAgIm1pbmltdW0iOiAzMDAsCiAgICAgICAgICAgICAgIm1heGltdW0iOiA2OTkKICAgICAgICAgICAgfSwKICAgICAgICAgICAgImRlc2NyaXB0aW9uIjogewogICAgICAgICAgICAgICJ0eXBlIjogInN0cmluZyIsCiAgICAgICAgICAgICAgImRlc2NyaXB0aW9uIjogIkEgaHVtYW4gZnJpZW5kbHkgZGVzY3JpcHRpb24gb2YgdGhlIGVycm9yIgogICAgICAgICAgICB9CiAgICAgICAgICB9CiAgICAgICAgfQogICAgICB9CiAgICB9LAogICAgewogICAgICAicmVxdWlyZWQiOiBbCiAgICAgICAgInN1Y2Nlc3MiCiAgICAgIF0sCiAgICAgICJ0eXBlIjogIm9iamVjdCIsCiAgICAgICJwcm9wZXJ0aWVzIjogewogICAgICAgICJzdWNjZXNzIjogewogICAgICAgICAgInR5cGUiOiAiYm9vbGVhbiIKICAgICAgICB9CiAgICAgIH0KICAgIH0KICBdLAogICJwcm9wZXJ0aWVzIjogewogICAgInR5cGUiOiB7CiAgICAgICJ0eXBlIjogInN0cmluZyIsCiAgICAgICJjb25zdCI6ICJpby5uYXRzLmpldHN0cmVhbS5hcGkudjEuc3RyZWFtX3RlbXBsYXRlX2RlbGV0ZV9yZXNwb25zZSIKICAgIH0KICB9Cn0K")
	schemas["io.nats.jetstream.api.v1.stream_template_info_response"], _ = base64.StdEncoding.DecodeString("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")
	schemas["io.nats.jetstream.api.v1.stream_template_names_response"], _ = base64.StdEncoding.DecodeString("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")
	schemas["io.nats.jetstream.api.v1.stream_template_names_request"], _ = base64.StdEncoding.DecodeString("ewogICIkc2NoZW1hIjogImh0dHA6Ly9qc29uLXNjaGVtYS5vcmcvZHJhZnQtMDcvc2NoZW1hIyIsCiAgIiRpZCI6ICJodHRwczovL25hdHMuaW8vc2NoZW1hcy9qZXRzdHJlYW0vYXBpL3YxL3N0cmVhbV90ZW1wbGF0ZV9uYW1lc19yZXF1ZXN0Lmpzb24iLAogICJkZXNjcmlwdGlvbiI6ICJBIHJlcXVlc3QgdG8gdGhlIEpldFN0cmVhbSAkSlMuQVBJLkNPTlNVTUVSLkxJU1QgQVBJIiwKICAidGl0bGUiOiAiaW8ubmF0cy5qZXRzdHJlYW0uYXBpLnYxLnN0cmVhbV90ZW1wbGF0ZV9uYW1lc19yZXF1ZXN0IiwKICAidHlwZSI6ICJvYmplY3QiLAogICJhbGxPZiI6IFsKICAgIHsKICAgICAgInR5cGUiOiAib2JqZWN0IiwKICAgICAgImFkZGl0aW9uYWxQcm9wZXJ0aWVzIjogZmFsc2UsCiAgICAgICJyZXF1aXJlZCI6IFsKICAgICAgICAib2Zmc2V0IgogICAgICBdLAogICAgICAicHJvcGVydGllcyI6IHsKICAgICAgICAib2Zmc2V0IjogewogICAgICAgICAgInR5cGUiOiAiaW50ZWdlciIsCiAgICAgICAgICAibWluaW11bSI6IDAKICAgICAgICB9CiAgICAgIH0KICAgIH0KICBdCn0K")
	schemas["io.nats.jetstream.api.v1.stream_update_response"], _ = base64.StdEncoding.DecodeString("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")
	schemas["io.nats.jetstream.api.v1.stream_remove_peer_request"], _ = base64.StdEncoding.DecodeString("ewogICIkc2NoZW1hIjogImh0dHA6Ly9qc29uLXNjaGVtYS5vcmcvZHJhZnQtMDcvc2NoZW1hIyIsCiAgIiRpZCI6ICJodHRwczovL25hdHMuaW8vc2NoZW1hcy9qZXRzdHJlYW0vYXBpL3YxL3N0cmVhbV9yZW1vdmVfcGVlcl9yZXF1ZXN0Lmpzb24iLAogICJkZXNjcmlwdGlvbiI6ICJBIHJlcXVlc3QgdG8gdGhlIEpldFN0cmVhbSAkSlMuQVBJLlNUUkVBTS5QRUVSLlJFTU9WRSBBUEkiLAogICJ0aXRsZSI6ICJpby5uYXRzLmpldHN0cmVhbS5hcGkudjEuc3RyZWFtX3JlbW92ZV9wZWVyX3JlcXVlc3QiLAogICJ0eXBlIjogIm9iamVjdCIsCiAgInJlcXVpcmVkIjogWwogICAgInBlZXIiCiAgXSwKICAiYWRkaXRpb25hbFByb3BlcnRpZXMiOiBmYWxzZSwKICAicHJvcGVydGllcyI6IHsKICAgICJwZWVyIjogewogICAgICAidHlwZSI6ICJzdHJpbmciLAogICAgICAiZGVzY3JpcHRpb24iOiAiU2VydmVyIG5hbWUgb2YgdGhlIHBlZXIgdG8gcmVtb3ZlIiwKICAgICAgIm1pbkxlbmd0aCI6IDEKICAgIH0KICB9Cn0K")
	schemas["io.nats.jetstream.api.v1.stream_remove_peer_response"], _ = base64.StdEncoding.DecodeString("ewogICIkc2NoZW1hIjogImh0dHA6Ly9qc29uLXNjaGVtYS5vcmcvZHJhZnQtMDcvc2NoZW1hIyIsCiAgIiRpZCI6ICJodHRwczovL25hdHMuaW8vc2NoZW1hcy9qZXRzdHJlYW0vYXBpL3YxL3N0cmVhbV9yZW1vdmVfcGVlcl9yZXNwb25zZS5qc29uIiwKICAiZGVzY3JpcHRpb24iOiAiQSByZXNwb25zZSBmcm9tIHRoZSBKZXRTdHJlYW0gJEpTLkFQSS5TVFJFQU0uUEVFUi5SRU1PVkUgQVBJIiwKICAidGl0bGUiOiAiaW8ubmF0cy5qZXRzdHJlYW0uYXBpLnYxLnN0cmVhbV9yZW1vdmVfcGVlcl9yZXNwb25zZSIsCiAgInR5cGUiOiAib2JqZWN0IiwKICAib25lT2YiOiBbCiAgICB7CiAgICAgICJ0eXBlIjogIm9iamVjdCIsCiAgICAgICJyZXF1aXJlZCI6IFsKICAgICAgICAiZXJyb3IiCiAgICAgIF0sCiAgICAgICJwcm9wZXJ0aWVzIjogewogICAgICAgICJlcnJvciI6IHsKICAgICAgICAgICJ0eXBlIjogIm9iamVjdCIsCiAgICAgICAgICAicmVxdWlyZWQiOiBbCiAgICAgICAgICAgICJjb2RlIgogICAgICAgICAgXSwKICAgICAgICAgICJwcm9wZXJ0aWVzIjogewogICAgICAgICAgICAiY29kZSI6IHsKICAgICAgICAgICAgICAidHlwZSI6ICJpbnRlZ2VyIiwKICAgICAgICAgICAgICAiZGVzY3JpcHRpb24iOiAiSFRUUCBsaWtlIGVycm9yIGNvZGUgaW4gdGhlIDMwMCB0byA1MDAgcmFuZ2UiLAogICAgICAgICAgICAgICJtaW5pbXVtIjogMzAwLAogICAgICAgICAgICAgICJtYXhpbXVtIjogNjk5CiAgICAgICAgICAgIH0sCiAgICAgICAgICAgICJkZXNjcmlwdGlvbiI6IHsKICAgICAgICAgICAgICAidHlwZSI6ICJzdHJpbmciLAogICAgICAgICAgICAgICJkZXNjcmlwdGlvbiI6ICJBIGh1bWFuIGZyaWVuZGx5IGRlc2NyaXB0aW9uIG9mIHRoZSBlcnJvciIKICAgICAgICAgICAgfQogICAgICAgICAgfQogICAgICAgIH0KICAgICAgfQogICAgfSwKICAgIHsKICAgICAgInJlcXVpcmVkIjogWwogICAgICAgICJzdWNjZXNzIgogICAgICBdLAogICAgICAidHlwZSI6ICJvYmplY3QiLAogICAgICAicHJvcGVydGllcyI6IHsKICAgICAgICAic3VjY2VzcyI6IHsKICAgICAgICAgICJ0eXBlIjogImJvb2xlYW4iLAogICAgICAgICAgImRlc2NyaXB0aW9uIjogIklmIHRoZSBwZWVyIHdhcyBzdWNjZXNzZnVsbHkgcmVtb3ZlZCIsCiAgICAgICAgICAiZGVmYXVsdCI6IGZhbHNlCiAgICAgICAgfQogICAgICB9CiAgICB9CiAgXSwKICAicHJvcGVydGllcyI6IHsKICAgICJ0eXBlIjogewogICAgICAidHlwZSI6ICJzdHJpbmciLAogICAgICAiY29uc3QiOiAiaW8ubmF0cy5qZXRzdHJlYW0uYXBpLnYxLnN0cmVhbV9yZW1vdmVfcGVlcl9yZXNwb25zZSIKICAgIH0KICB9Cn0K")
	schemas["io.nats.jetstream.api.v1.stream_leader_stepdown_response"], _ = base64.StdEncoding.DecodeString("ewogICIkc2NoZW1hIjogImh0dHA6Ly9qc29uLXNjaGVtYS5vcmcvZHJhZnQtMDcvc2NoZW1hIyIsCiAgIiRpZCI6ICJodHRwczovL25hdHMuaW8vc2NoZW1hcy9qZXRzdHJlYW0vYXBpL3YxL3N0cmVhbV9sZWFkZXJfc3RlcGRvd25fcmVzcG9uc2UuanNvbiIsCiAgImRlc2NyaXB0aW9uIjogIkEgcmVzcG9uc2UgZnJvbSB0aGUgSmV0U3RyZWFtICRKUy5BUEkuU1RSRUFNLkxFQURFUi5TVEVQRE9XTiBBUEkiLAogICJ0aXRsZSI6ICJpby5uYXRzLmpldHN0cmVhbS5hcGkudjEuc3RyZWFtX2xlYWRlcl9zdGVwZG93bl9yZXNwb25zZSIsCiAgInR5cGUiOiAib2JqZWN0IiwKICAib25lT2YiOiBbCiAgICB7CiAgICAgICJ0eXBlIjogIm9iamVjdCIsCiAgICAgICJyZXF1aXJlZCI6IFsKICAgICAgICAiZXJyb3IiCiAgICAgIF0sCiAgICAgICJwcm9wZXJ0aWVzIjogewogICAgICAgICJlcnJvciI6IHsKICAgICAgICAgICJ0eXBlIjogIm9iamVjdCIsCiAgICAgICAgICAicmVxdWlyZWQiOiBbCiAgICAgICAgICAgICJjb2RlIgogICAgICAgICAgXSwKICAgICAgICAgICJwcm9wZXJ0aWVzIjogewogICAgICAgICAgICAiY29kZSI6IHsKICAgICAgICAgICAgICAidHlwZSI6ICJpbnRlZ2VyIiwKICAgICAgICAgICAgICAiZGVzY3JpcHRpb24iOiAiSFRUUCBsaWtlIGVycm9yIGNvZGUgaW4gdGhlIDMwMCB0byA1MDAgcmFuZ2UiLAogICAgICAgICAgICAgICJtaW5pbXVtIjogMzAwLAogICAgICAgICAgICAgICJtYXhpbXVtIjogNjk5CiAgICAgICAgICAgIH0sCiAgICAgICAgICAgICJkZXNjcmlwdGlvbiI6IHsKICAgICAgICAgICAgICAidHlwZSI6ICJzdHJpbmciLAogICAgICAgICAgICAgICJkZXNjcmlwdGlvbiI6ICJBIGh1bWFuIGZyaWVuZGx5IGRlc2NyaXB0aW9uIG9mIHRoZSBlcnJvciIKICAgICAgICAgICAgfQogICAgICAgICAgfQogICAgICAgIH0KICAgICAgfQogICAgfSwKICAgIHsKICAgICAgInJlcXVpcmVkIjogWwogICAgICAgICJzdWNjZXNzIgogICAgICBdLAogICAgICAidHlwZSI6ICJvYmplY3QiLAogICAgICAicHJvcGVydGllcyI6IHsKICAgICAgICAic3VjY2VzcyI6IHsKICAgICAgICAgICJ0eXBlIjogImJvb2xlYW4iLAogICAgICAgICAgImRlc2NyaXB0aW9uIjogIklmIHRoZSBsZWFkZXIgc3VjY2Vzc2Z1bGx5IHN0b29kIGRvd24iLAogICAgICAgICAgImRlZmF1bHQiOiBmYWxzZQogICAgICAgIH0KICAgICAgfQogICAgfQogIF0sCiAgInByb3BlcnRpZXMiOiB7CiAgICAidHlwZSI6IHsKICAgICAgInR5cGUiOiAic3RyaW5nIiwKICAgICAgImNvbnN0IjogImlvLm5hdHMuamV0c3RyZWFtLmFwaS52MS5zdHJlYW1fbGVhZGVyX3N0ZXBkb3duX3Jlc3BvbnNlIgogICAgfQogIH0KfQo=")
	schemas["io.nats.jetstream.api.v1.pub_ack_response"], _ = base64.StdEncoding.DecodeString("ewogICIkc2NoZW1hIjogImh0dHA6Ly9qc29uLXNjaGVtYS5vcmcvZHJhZnQtMDcvc2NoZW1hIyIsCiAgIiRpZCI6ICJodHRwczovL25hdHMuaW8vc2NoZW1hcy9qZXRzdHJlYW0vYXBpL3YxL3B1Yl9hY2tfcmVzcG9uc2UuanNvbiIsCiAgImRlc2NyaXB0aW9uIjogIkEgcmVzcG9uc2UgcmVjZWl2ZWQgd2hlbiBwdWJsaXNoaW5nIGEgbWVzc2FnZSIsCiAgInRpdGxlIjogImlvLm5hdHMuamV0c3RyZWFtLmFwaS52MS5wdWJfYWNrX3Jlc3BvbnNlIiwKICAidHlwZSI6ICJvYmplY3QiLAogICJyZXF1aXJlZCI6IFsKICAgICJzdHJlYW0iCiAgXSwKICAiYWRkaXRpb25hbFByb3BlcnRpZXMiOiBmYWxzZSwKICAicHJvcGVydGllcyI6IHsKICAgICJlcnJvciI6IHsKICAgICAgInR5cGUiOiAib2JqZWN0IiwKICAgICAgInJlcXVpcmVkIjogWwogICAgICAgICJjb2RlIgogICAgICBdLAogICAgICAicHJvcGVydGllcyI6IHsKICAgICAgICAiY29kZSI6IHsKICAgICAgICAgICJ0eXBlIjogImludGVnZXIiLAogICAgICAgICAgImRlc2NyaXB0aW9uIjogIkhUVFAgbGlrZSBlcnJvciBjb2RlIGluIHRoZSAzMDAgdG8gNTAwIHJhbmdlIiwKICAgICAgICAgICJtaW5pbXVtIjogMzAwLAogICAgICAgICAgIm1heGltdW0iOiA2OTkKICAgICAgICB9LAogICAgICAgICJkZXNjcmlwdGlvbiI6IHsKICAgICAgICAgICJ0eXBlIjogInN0cmluZyIsCiAgICAgICAgICAiZGVzY3JpcHRpb24iOiAiQSBodW1hbiBmcmllbmRseSBkZXNjcmlwdGlvbiBvZiB0aGUgZXJyb3IiCiAgICAgICAgfQogICAgICB9CiAgICB9LAogICAgInN0cmVhbSI6IHsKICAgICAgInR5cGUiOiAic3RyaW5nIiwKICAgICAgImRlc2NyaXB0aW9uIjogIlRoZSBuYW1lIG9mIHRoZSBzdHJlYW0gdGhhdCByZWNlaXZlZCB0aGUgbWVzc2FnZSIsCiAgICAgICJtaW5MZW5ndGgiOiAxCiAgICB9LAogICAgInNlcSI6IHsKICAgICAgInR5cGUiOiAiaW50ZWdlciIsCiAgICAgICJkZXNjcmlwdGlvbiI6ICJJZiBzdWNjZXNzZnVsIHRoaXMgd2lsbCBiZSB0aGUgc2VxdWVuY2UgdGhlIG1lc3NhZ2UgaXMgc3RvcmVkIGF0IiwKICAgICAgIm1pbmltdW0iOiAwLAogICAgICAibWF4aW11bSI6IDE4NDQ2NzQ0MDczNzA5NTUyMDAwCiAgICB9LAogICAgImR1cGxpY2F0ZSI6IHsKICAgICAgInR5cGUiOiAiYm9vbGVhbiIsCiAgICAgICJkZXNjcmlwdGlvbiI6ICJJbmRpY2F0ZXMgdGhhdCB0aGUgbWVzc2FnZSB3YXMgbm90IHN0b3JlZCBkdWUgdG8gdGhlIE5hdHMtTXNnLUlkIGhlYWRlciBhbmQgZHVwbGljYXRlIHRyYWNraW5nIiwKICAgICAgImRlZmF1bHQiOiBmYWxzZQogICAgfQogIH0KfQo=")
	schemas["io.nats.jetstream.api.v1.meta_leader_stepdown_request"], _ = base64.StdEncoding.DecodeString("ewogICIkc2NoZW1hIjogImh0dHA6Ly9qc29uLXNjaGVtYS5vcmcvZHJhZnQtMDcvc2NoZW1hIyIsCiAgIiRpZCI6ICJodHRwczovL25hdHMuaW8vc2NoZW1hcy9qZXRzdHJlYW0vYXBpL3YxL21ldGFfbGVhZGVyX3N0ZXBkb3duX3JlcXVlc3QuanNvbiIsCiAgImRlc2NyaXB0aW9uIjogIkEgcmVxdWVzdCB0byB0aGUgSmV0U3RyZWFtICRKUy5BUEkuTUVUQS5MRUFERVIuU1RFUERPV04gQVBJIiwKICAidGl0bGUiOiAiaW8ubmF0cy5qZXRzdHJlYW0uYXBpLnYxLm1ldGFfbGVhZGVyX3N0ZXBkb3duX3JlcXVlc3QiLAogICJ0eXBlIjogIm9iamVjdCIsCiAgInByb3BlcnRpZXMiOiB7CiAgICAicGxhY2VtZW50IjogewogICAgICAidHlwZSI6ICJvYmplY3QiLAogICAgICAiZGVzY3JpcHRpb24iOiAiUGxhY2VtZW50IHJlcXVpcmVtZW50cyBmb3IgYSBzdHJlYW0iLAogICAgICAicmVxdWlyZWQiOiBbCiAgICAgICAgImNsdXN0ZXIiCiAgICAgIF0sCiAgICAgICJwcm9wZXJ0aWVzIjogewogICAgICAgICJjbHVzdGVyIjogewogICAgICAgICAgInR5cGUiOiAic3RyaW5nIiwKICAgICAgICAgICJkZXNjcmlwdGlvbiI6ICJUaGUgZGVzaXJlZCBjbHVzdGVyIG5hbWUgdG8gcGxhY2UgdGhlIHN0cmVhbSIsCiAgICAgICAgICAibWluTGVuZ3RoIjogMQogICAgICAgIH0sCiAgICAgICAgInRhZ3MiOiB7CiAgICAgICAgICAiZGVzY3JpcHRpb24iOiAiVGFncyByZXF1aXJlZCBvbiBzZXJ2ZXJzIGhvc3RpbmcgdGhpcyBzdHJlYW0iLAogICAgICAgICAgInR5cGUiOiAiYXJyYXkiLAogICAgICAgICAgIml0ZW1zIjogewogICAgICAgICAgICAidHlwZSI6ICJzdHJpbmciCiAgICAgICAgICB9CiAgICAgICAgfQogICAgICB9CiAgICB9CiAgfQp9Cg==")
	schemas["io.nats.jetstream.api.v1.meta_leader_stepdown_response"], _ = base64.StdEncoding.DecodeString("ewogICIkc2NoZW1hIjogImh0dHA6Ly9qc29uLXNjaGVtYS5vcmcvZHJhZnQtMDcvc2NoZW1hIyIsCiAgIiRpZCI6ICJodHRwczovL25hdHMuaW8vc2NoZW1hcy9qZXRzdHJlYW0vYXBpL3YxL21ldGFfbGVhZGVyX3N0ZXBkb3duX3Jlc3BvbnNlLmpzb24iLAogICJkZXNjcmlwdGlvbiI6ICJBIHJlc3BvbnNlIGZyb20gdGhlIEpldFN0cmVhbSAkSlMuQVBJLk1FVEEuTEVBREVSLlNURVBET1dOIEFQSSIsCiAgInRpdGxlIjogImlvLm5hdHMuamV0c3RyZWFtLmFwaS52MS5tZXRhX2xlYWRlcl9zdGVwZG93bl9yZXNwb25zZSIsCiAgInR5cGUiOiAib2JqZWN0IiwKICAib25lT2YiOiBbCiAgICB7CiAgICAgICJ0eXBlIjogIm9iamVjdCIsCiAgICAgICJyZXF1aXJlZCI6IFsKICAgICAgICAiZXJyb3IiCiAgICAgIF0sCiAgICAgICJwcm9wZXJ0aWVzIjogewogICAgICAgICJlcnJvciI6IHsKICAgICAgICAgICJ0eXBlIjogIm9iamVjdCIsCiAgICAgICAgICAicmVxdWlyZWQiOiBbCiAgICAgICAgICAgICJjb2RlIgogICAgICAgICAgXSwKICAgICAgICAgICJwcm9wZXJ0aWVzIjogewogICAgICAgICAgICAiY29kZSI6IHsKICAgICAgICAgICAgICAidHlwZSI6ICJpbnRlZ2VyIiwKICAgICAgICAgICAgICAiZGVzY3JpcHRpb24iOiAiSFRUUCBsaWtlIGVycm9yIGNvZGUgaW4gdGhlIDMwMCB0byA1MDAgcmFuZ2UiLAogICAgICAgICAgICAgICJtaW5pbXVtIjogMzAwLAogICAgICAgICAgICAgICJtYXhpbXVtIjogNjk5CiAgICAgICAgICAgIH0sCiAgICAgICAgICAgICJkZXNjcmlwdGlvbiI6IHsKICAgICAgICAgICAgICAidHlwZSI6ICJzdHJpbmciLAogICAgICAgICAgICAgICJkZXNjcmlwdGlvbiI6ICJBIGh1bWFuIGZyaWVuZGx5IGRlc2NyaXB0aW9uIG9mIHRoZSBlcnJvciIKICAgICAgICAgICAgfQogICAgICAgICAgfQogICAgICAgIH0KICAgICAgfQogICAgfSwKICAgIHsKICAgICAgInJlcXVpcmVkIjogWwogICAgICAgICJzdWNjZXNzIgogICAgICBdLAogICAgICAidHlwZSI6ICJvYmplY3QiLAogICAgICAicHJvcGVydGllcyI6IHsKICAgICAgICAic3VjY2VzcyI6IHsKICAgICAgICAgICJ0eXBlIjogImJvb2xlYW4iLAogICAgICAgICAgImRlc2NyaXB0aW9uIjogIklmIHRoZSBsZWFkZXIgc3VjY2Vzc2Z1bGx5IHN0b29kIGRvd24iLAogICAgICAgICAgImRlZmF1bHQiOiBmYWxzZQogICAgICAgIH0KICAgICAgfQogICAgfQogIF0sCiAgInByb3BlcnRpZXMiOiB7CiAgICAidHlwZSI6IHsKICAgICAgInR5cGUiOiAic3RyaW5nIiwKICAgICAgImNvbnN0IjogImlvLm5hdHMuamV0c3RyZWFtLmFwaS52MS5tZXRhX2xlYWRlcl9zdGVwZG93bl9yZXNwb25zZSIKICAgIH0KICB9Cn0K")
	schemas["io.nats.jetstream.api.v1.meta_server_remove_request"], _ = base64.StdEncoding.DecodeString("ewogICIkc2NoZW1hIjogImh0dHA6Ly9qc29uLXNjaGVtYS5vcmcvZHJhZnQtMDcvc2NoZW1hIyIsCiAgIiRpZCI6ICJodHRwczovL25hdHMuaW8vc2NoZW1hcy9qZXRzdHJlYW0vYXBpL3YxL21ldGFfc2VydmVyX3JlbW92ZV9yZXF1ZXN0Lmpzb24iLAogICJkZXNjcmlwdGlvbiI6ICJBIHJlcXVlc3QgdG8gdGhlIEpldFN0cmVhbSAkSlMuQVBJLlNFUlZFUi5SRU1PVkUgQVBJIiwKICAidGl0bGUiOiAiaW8ubmF0cy5qZXRzdHJlYW0uYXBpLnYxLm1ldGFfc2VydmVyX3JlbW92ZV9yZXF1ZXN0IiwKICAidHlwZSI6ICJvYmplY3QiLAogICJyZXF1aXJlZCI6IFsKICAgICJwZWVyIgogIF0sCiAgInByb3BlcnRpZXMiOiB7CiAgICAicGVlciI6IHsKICAgICAgInR5cGUiOiAic3RyaW5nIiwKICAgICAgImRlc2NyaXB0aW9uIjogIlRoZSBOYW1lIG9mIHRoZSBzZXJ2ZXIgdG8gcmVtb3ZlIGZyb20gdGhlIG1ldGEgZ3JvdXAiLAogICAgICAibWluaW11bSI6IDEKICAgIH0KICB9Cn0K")
	schemas["io.nats.jetstream.api.v1.meta_server_remove_response"], _ = base64.StdEncoding.DecodeString("ewogICIkc2NoZW1hIjogImh0dHA6Ly9qc29uLXNjaGVtYS5vcmcvZHJhZnQtMDcvc2NoZW1hIyIsCiAgIiRpZCI6ICJodHRwczovL25hdHMuaW8vc2NoZW1hcy9qZXRzdHJlYW0vYXBpL3YxL21ldGFfc2VydmVyX3JlbW92ZV9yZXNwb25zZS5qc29uIiwKICAiZGVzY3JpcHRpb24iOiAiQSByZXNwb25zZSBmcm9tIHRoZSBKZXRTdHJlYW0gJEpTLkFQSS5TRVJWRVIuUkVNT1ZFIEFQSSIsCiAgInRpdGxlIjogImlvLm5hdHMuamV0c3RyZWFtLmFwaS52MS5tZXRhX3NlcnZlcl9yZW1vdmVfcmVzcG9uc2UiLAogICJvbmVPZiI6IFsKICAgIHsKICAgICAgInR5cGUiOiAib2JqZWN0IiwKICAgICAgInJlcXVpcmVkIjogWwogICAgICAgICJlcnJvciIKICAgICAgXSwKICAgICAgInByb3BlcnRpZXMiOiB7CiAgICAgICAgImVycm9yIjogewogICAgICAgICAgInR5cGUiOiAib2JqZWN0IiwKICAgICAgICAgICJyZXF1aXJlZCI6IFsKICAgICAgICAgICAgImNvZGUiCiAgICAgICAgICBdLAogICAgICAgICAgInByb3BlcnRpZXMiOiB7CiAgICAgICAgICAgICJjb2RlIjogewogICAgICAgICAgICAgICJ0eXBlIjogImludGVnZXIiLAogICAgICAgICAgICAgICJkZXNjcmlwdGlvbiI6ICJIVFRQIGxpa2UgZXJyb3IgY29kZSBpbiB0aGUgMzAwIHRvIDUwMCByYW5nZSIsCiAgICAgICAgICAgICAgIm1pbmltdW0iOiAzMDAsCiAgICAgICAgICAgICAgIm1heGltdW0iOiA2OTkKICAgICAgICAgICAgfSwKICAgICAgICAgICAgImRlc2NyaXB0aW9uIjogewogICAgICAgICAgICAgICJ0eXBlIjogInN0cmluZyIsCiAgICAgICAgICAgICAgImRlc2NyaXB0aW9uIjogIkEgaHVtYW4gZnJpZW5kbHkgZGVzY3JpcHRpb24gb2YgdGhlIGVycm9yIgogICAgICAgICAgICB9CiAgICAgICAgICB9CiAgICAgICAgfQogICAgICB9CiAgICB9LAogICAgewogICAgICAicmVxdWlyZWQiOiBbCiAgICAgICAgInN1Y2Nlc3MiCiAgICAgIF0sCiAgICAgICJ0eXBlIjogIm9iamVjdCIsCiAgICAgICJwcm9wZXJ0aWVzIjogewogICAgICAgICJzdWNjZXNzIjogewogICAgICAgICAgInR5cGUiOiAiYm9vbGVhbiIsCiAgICAgICAgICAiZGVzY3JpcHRpb24iOiAiSWYgdGhlIHBlZXIgd2FzIHN1Y2Nlc3NmdWxseSByZW1vdmVkIiwKICAgICAgICAgICJkZWZhdWx0IjogZmFsc2UKICAgICAgICB9CiAgICAgIH0KICAgIH0KICBdLAogICJwcm9wZXJ0aWVzIjogewogICAgInR5cGUiOiB7CiAgICAgICJ0eXBlIjogInN0cmluZyIsCiAgICAgICJjb25zdCI6ICJpby5uYXRzLmpldHN0cmVhbS5hcGkudjEubWV0YV9zZXJ2ZXJfcmVtb3ZlX3Jlc3BvbnNlIgogICAgfQogIH0KfQo=")
}
