// Code generated by protoc-gen-gogo.
// source: protocol.proto
// DO NOT EDIT!

/*
	Package spb is a generated protocol buffer package.

	It is generated from these files:
		protocol.proto

	It has these top-level messages:
		SubState
		SubStateDelete
		SubStateUpdate
		ServerInfo
		ClientInfo
		ClientDelete
		CtrlMsg
		RaftJoinRequest
		RaftJoinResponse
		RaftOperation
		Batch
		AddSubscription
		SubSentAndAck
		AddClient
		RaftSnapshot
		ChannelSnapshot
		SubscriptionSnapshot
*/
package spb

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/gogo/protobuf/gogoproto"
import pb "github.com/nats-io/stan.go/pb"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

type CtrlMsg_Type int32

const (
	CtrlMsg_SubUnsubscribe CtrlMsg_Type = 0
	CtrlMsg_SubClose       CtrlMsg_Type = 1
	CtrlMsg_ConnClose      CtrlMsg_Type = 2
	CtrlMsg_FTHeartbeat    CtrlMsg_Type = 3
	CtrlMsg_Partitioning   CtrlMsg_Type = 4
)

var CtrlMsg_Type_name = map[int32]string{
	0: "SubUnsubscribe",
	1: "SubClose",
	2: "ConnClose",
	3: "FTHeartbeat",
	4: "Partitioning",
}
var CtrlMsg_Type_value = map[string]int32{
	"SubUnsubscribe": 0,
	"SubClose":       1,
	"ConnClose":      2,
	"FTHeartbeat":    3,
	"Partitioning":   4,
}

func (x CtrlMsg_Type) String() string {
	return proto.EnumName(CtrlMsg_Type_name, int32(x))
}
func (CtrlMsg_Type) EnumDescriptor() ([]byte, []int) { return fileDescriptorProtocol, []int{6, 0} }

type RaftOperation_Type int32

const (
	RaftOperation_Publish            RaftOperation_Type = 0
	RaftOperation_Subscribe          RaftOperation_Type = 1
	RaftOperation_RemoveSubscription RaftOperation_Type = 2
	RaftOperation_CloseSubscription  RaftOperation_Type = 3
	RaftOperation_SendAndAck         RaftOperation_Type = 4
	RaftOperation_Connect            RaftOperation_Type = 6
	RaftOperation_Disconnect         RaftOperation_Type = 7
	RaftOperation_DeleteChannel      RaftOperation_Type = 8
)

var RaftOperation_Type_name = map[int32]string{
	0: "Publish",
	1: "Subscribe",
	2: "RemoveSubscription",
	3: "CloseSubscription",
	4: "SendAndAck",
	6: "Connect",
	7: "Disconnect",
	8: "DeleteChannel",
}
var RaftOperation_Type_value = map[string]int32{
	"Publish":            0,
	"Subscribe":          1,
	"RemoveSubscription": 2,
	"CloseSubscription":  3,
	"SendAndAck":         4,
	"Connect":            6,
	"Disconnect":         7,
	"DeleteChannel":      8,
}

func (x RaftOperation_Type) String() string {
	return proto.EnumName(RaftOperation_Type_name, int32(x))
}
func (RaftOperation_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorProtocol, []int{9, 0}
}

// SubState represents the state of a Subscription
type SubState struct {
	ID            uint64 `protobuf:"varint,1,opt,name=ID,proto3" json:"ID,omitempty"`
	ClientID      string `protobuf:"bytes,2,opt,name=clientID,proto3" json:"clientID,omitempty"`
	QGroup        string `protobuf:"bytes,3,opt,name=qGroup,proto3" json:"qGroup,omitempty"`
	Inbox         string `protobuf:"bytes,4,opt,name=inbox,proto3" json:"inbox,omitempty"`
	AckInbox      string `protobuf:"bytes,5,opt,name=ackInbox,proto3" json:"ackInbox,omitempty"`
	MaxInFlight   int32  `protobuf:"varint,6,opt,name=maxInFlight,proto3" json:"maxInFlight,omitempty"`
	AckWaitInSecs int32  `protobuf:"varint,7,opt,name=ackWaitInSecs,proto3" json:"ackWaitInSecs,omitempty"`
	DurableName   string `protobuf:"bytes,8,opt,name=durableName,proto3" json:"durableName,omitempty"`
	LastSent      uint64 `protobuf:"varint,9,opt,name=lastSent,proto3" json:"lastSent,omitempty"`
	IsDurable     bool   `protobuf:"varint,10,opt,name=isDurable,proto3" json:"isDurable,omitempty"`
	IsClosed      bool   `protobuf:"varint,11,opt,name=isClosed,proto3" json:"isClosed,omitempty"`
}

func (m *SubState) Reset()                    { *m = SubState{} }
func (m *SubState) String() string            { return proto.CompactTextString(m) }
func (*SubState) ProtoMessage()               {}
func (*SubState) Descriptor() ([]byte, []int) { return fileDescriptorProtocol, []int{0} }

// SubStateDelete marks a Subscription as deleted
type SubStateDelete struct {
	ID uint64 `protobuf:"varint,1,opt,name=ID,proto3" json:"ID,omitempty"`
}

func (m *SubStateDelete) Reset()                    { *m = SubStateDelete{} }
func (m *SubStateDelete) String() string            { return proto.CompactTextString(m) }
func (*SubStateDelete) ProtoMessage()               {}
func (*SubStateDelete) Descriptor() ([]byte, []int) { return fileDescriptorProtocol, []int{1} }

// SubStateUpdate represents a subscription update (either Msg or Ack)
type SubStateUpdate struct {
	ID    uint64 `protobuf:"varint,1,opt,name=ID,proto3" json:"ID,omitempty"`
	Seqno uint64 `protobuf:"varint,2,opt,name=seqno,proto3" json:"seqno,omitempty"`
}

func (m *SubStateUpdate) Reset()                    { *m = SubStateUpdate{} }
func (m *SubStateUpdate) String() string            { return proto.CompactTextString(m) }
func (*SubStateUpdate) ProtoMessage()               {}
func (*SubStateUpdate) Descriptor() ([]byte, []int) { return fileDescriptorProtocol, []int{2} }

// ServerInfo contains basic information regarding the Server
type ServerInfo struct {
	ClusterID   string `protobuf:"bytes,1,opt,name=ClusterID,proto3" json:"ClusterID,omitempty"`
	Discovery   string `protobuf:"bytes,2,opt,name=Discovery,proto3" json:"Discovery,omitempty"`
	Publish     string `protobuf:"bytes,3,opt,name=Publish,proto3" json:"Publish,omitempty"`
	Subscribe   string `protobuf:"bytes,4,opt,name=Subscribe,proto3" json:"Subscribe,omitempty"`
	Unsubscribe string `protobuf:"bytes,5,opt,name=Unsubscribe,proto3" json:"Unsubscribe,omitempty"`
	Close       string `protobuf:"bytes,6,opt,name=Close,proto3" json:"Close,omitempty"`
	SubClose    string `protobuf:"bytes,7,opt,name=SubClose,proto3" json:"SubClose,omitempty"`
	AcksSubs    string `protobuf:"bytes,8,opt,name=AcksSubs,proto3" json:"AcksSubs,omitempty"`
	NodeID      string `protobuf:"bytes,9,opt,name=NodeID,proto3" json:"NodeID,omitempty"`
}

func (m *ServerInfo) Reset()                    { *m = ServerInfo{} }
func (m *ServerInfo) String() string            { return proto.CompactTextString(m) }
func (*ServerInfo) ProtoMessage()               {}
func (*ServerInfo) Descriptor() ([]byte, []int) { return fileDescriptorProtocol, []int{3} }

// ClientInfo contains information related to a Client
type ClientInfo struct {
	ID           string `protobuf:"bytes,1,opt,name=ID,proto3" json:"ID,omitempty"`
	HbInbox      string `protobuf:"bytes,2,opt,name=HbInbox,proto3" json:"HbInbox,omitempty"`
	ConnID       []byte `protobuf:"bytes,3,opt,name=ConnID,proto3" json:"ConnID,omitempty"`
	Protocol     int32  `protobuf:"varint,4,opt,name=Protocol,proto3" json:"Protocol,omitempty"`
	PingInterval int32  `protobuf:"varint,5,opt,name=PingInterval,proto3" json:"PingInterval,omitempty"`
	PingMaxOut   int32  `protobuf:"varint,6,opt,name=PingMaxOut,proto3" json:"PingMaxOut,omitempty"`
}

func (m *ClientInfo) Reset()                    { *m = ClientInfo{} }
func (m *ClientInfo) String() string            { return proto.CompactTextString(m) }
func (*ClientInfo) ProtoMessage()               {}
func (*ClientInfo) Descriptor() ([]byte, []int) { return fileDescriptorProtocol, []int{4} }

type ClientDelete struct {
	ID string `protobuf:"bytes,1,opt,name=ID,proto3" json:"ID,omitempty"`
}

func (m *ClientDelete) Reset()                    { *m = ClientDelete{} }
func (m *ClientDelete) String() string            { return proto.CompactTextString(m) }
func (*ClientDelete) ProtoMessage()               {}
func (*ClientDelete) Descriptor() ([]byte, []int) { return fileDescriptorProtocol, []int{5} }

type CtrlMsg struct {
	MsgType  CtrlMsg_Type `protobuf:"varint,1,opt,name=MsgType,proto3,enum=spb.CtrlMsg_Type" json:"MsgType,omitempty"`
	ServerID string       `protobuf:"bytes,2,opt,name=ServerID,proto3" json:"ServerID,omitempty"`
	Data     []byte       `protobuf:"bytes,3,opt,name=Data,proto3" json:"Data,omitempty"`
	RefID    string       `protobuf:"bytes,4,opt,name=RefID,proto3" json:"RefID,omitempty"`
}

func (m *CtrlMsg) Reset()                    { *m = CtrlMsg{} }
func (m *CtrlMsg) String() string            { return proto.CompactTextString(m) }
func (*CtrlMsg) ProtoMessage()               {}
func (*CtrlMsg) Descriptor() ([]byte, []int) { return fileDescriptorProtocol, []int{6} }

// RaftJoinRequest is a request to join a Raft group.
type RaftJoinRequest struct {
	NodeID   string `protobuf:"bytes,1,opt,name=NodeID,proto3" json:"NodeID,omitempty"`
	NodeAddr string `protobuf:"bytes,2,opt,name=NodeAddr,proto3" json:"NodeAddr,omitempty"`
}

func (m *RaftJoinRequest) Reset()                    { *m = RaftJoinRequest{} }
func (m *RaftJoinRequest) String() string            { return proto.CompactTextString(m) }
func (*RaftJoinRequest) ProtoMessage()               {}
func (*RaftJoinRequest) Descriptor() ([]byte, []int) { return fileDescriptorProtocol, []int{7} }

// RaftJoinResponse is a response to a RaftJoinRequest.
type RaftJoinResponse struct {
	Error string `protobuf:"bytes,1,opt,name=Error,proto3" json:"Error,omitempty"`
}

func (m *RaftJoinResponse) Reset()                    { *m = RaftJoinResponse{} }
func (m *RaftJoinResponse) String() string            { return proto.CompactTextString(m) }
func (*RaftJoinResponse) ProtoMessage()               {}
func (*RaftJoinResponse) Descriptor() ([]byte, []int) { return fileDescriptorProtocol, []int{8} }

// RaftOperation is a Raft log message.
type RaftOperation struct {
	OpType           RaftOperation_Type     `protobuf:"varint,1,opt,name=OpType,proto3,enum=spb.RaftOperation_Type" json:"OpType,omitempty"`
	PublishBatch     *Batch                 `protobuf:"bytes,2,opt,name=PublishBatch" json:"PublishBatch,omitempty"`
	Sub              *AddSubscription       `protobuf:"bytes,3,opt,name=Sub" json:"Sub,omitempty"`
	Unsub            *pb.UnsubscribeRequest `protobuf:"bytes,4,opt,name=Unsub" json:"Unsub,omitempty"`
	SubSentAck       *SubSentAndAck         `protobuf:"bytes,5,opt,name=SubSentAck" json:"SubSentAck,omitempty"`
	ClientConnect    *AddClient             `protobuf:"bytes,7,opt,name=ClientConnect" json:"ClientConnect,omitempty"`
	ClientDisconnect *pb.CloseRequest       `protobuf:"bytes,8,opt,name=ClientDisconnect" json:"ClientDisconnect,omitempty"`
	Channel          string                 `protobuf:"bytes,9,opt,name=Channel,proto3" json:"Channel,omitempty"`
	ChannelID        uint64                 `protobuf:"varint,10,opt,name=ChannelID,proto3" json:"ChannelID,omitempty"`
}

func (m *RaftOperation) Reset()                    { *m = RaftOperation{} }
func (m *RaftOperation) String() string            { return proto.CompactTextString(m) }
func (*RaftOperation) ProtoMessage()               {}
func (*RaftOperation) Descriptor() ([]byte, []int) { return fileDescriptorProtocol, []int{9} }

// Batch is a batch of messages for replication.
type Batch struct {
	Messages []*pb.MsgProto `protobuf:"bytes,1,rep,name=Messages" json:"Messages,omitempty"`
}

func (m *Batch) Reset()                    { *m = Batch{} }
func (m *Batch) String() string            { return proto.CompactTextString(m) }
func (*Batch) ProtoMessage()               {}
func (*Batch) Descriptor() ([]byte, []int) { return fileDescriptorProtocol, []int{10} }

// AddSubscription is used to replicate a new client subscription.
type AddSubscription struct {
	Request  *pb.SubscriptionRequest `protobuf:"bytes,1,opt,name=Request" json:"Request,omitempty"`
	AckInbox string                  `protobuf:"bytes,2,opt,name=AckInbox,proto3" json:"AckInbox,omitempty"`
	ID       uint64                  `protobuf:"varint,3,opt,name=ID,proto3" json:"ID,omitempty"`
}

func (m *AddSubscription) Reset()                    { *m = AddSubscription{} }
func (m *AddSubscription) String() string            { return proto.CompactTextString(m) }
func (*AddSubscription) ProtoMessage()               {}
func (*AddSubscription) Descriptor() ([]byte, []int) { return fileDescriptorProtocol, []int{11} }

// SubSentAndAck is used to replicate a sent and/or ack messages.
type SubSentAndAck struct {
	Channel  string   `protobuf:"bytes,1,opt,name=Channel,proto3" json:"Channel,omitempty"`
	AckInbox string   `protobuf:"bytes,2,opt,name=AckInbox,proto3" json:"AckInbox,omitempty"`
	Sent     []uint64 `protobuf:"varint,3,rep,packed,name=Sent" json:"Sent,omitempty"`
	Ack      []uint64 `protobuf:"varint,4,rep,packed,name=Ack" json:"Ack,omitempty"`
}

func (m *SubSentAndAck) Reset()                    { *m = SubSentAndAck{} }
func (m *SubSentAndAck) String() string            { return proto.CompactTextString(m) }
func (*SubSentAndAck) ProtoMessage()               {}
func (*SubSentAndAck) Descriptor() ([]byte, []int) { return fileDescriptorProtocol, []int{12} }

// AddClient is used to replicate a new client connection.
type AddClient struct {
	Request *pb.ConnectRequest `protobuf:"bytes,1,opt,name=Request" json:"Request,omitempty"`
	Refresh bool               `protobuf:"varint,2,opt,name=Refresh,proto3" json:"Refresh,omitempty"`
}

func (m *AddClient) Reset()                    { *m = AddClient{} }
func (m *AddClient) String() string            { return proto.CompactTextString(m) }
func (*AddClient) ProtoMessage()               {}
func (*AddClient) Descriptor() ([]byte, []int) { return fileDescriptorProtocol, []int{13} }

// RaftSnapshot is a snapshot of the state of the server.
type RaftSnapshot struct {
	Clients  []*ClientInfo      `protobuf:"bytes,1,rep,name=Clients" json:"Clients,omitempty"`
	Channels []*ChannelSnapshot `protobuf:"bytes,2,rep,name=Channels" json:"Channels,omitempty"`
	Padding  []byte             `protobuf:"bytes,3,opt,name=Padding,proto3" json:"Padding,omitempty"`
}

func (m *RaftSnapshot) Reset()                    { *m = RaftSnapshot{} }
func (m *RaftSnapshot) String() string            { return proto.CompactTextString(m) }
func (*RaftSnapshot) ProtoMessage()               {}
func (*RaftSnapshot) Descriptor() ([]byte, []int) { return fileDescriptorProtocol, []int{14} }

// ChannelSnapshot is a snapshot of a channel
type ChannelSnapshot struct {
	Channel       string                  `protobuf:"bytes,1,opt,name=Channel,proto3" json:"Channel,omitempty"`
	First         uint64                  `protobuf:"varint,2,opt,name=First,proto3" json:"First,omitempty"`
	Last          uint64                  `protobuf:"varint,3,opt,name=Last,proto3" json:"Last,omitempty"`
	Subscriptions []*SubscriptionSnapshot `protobuf:"bytes,4,rep,name=Subscriptions" json:"Subscriptions,omitempty"`
	NextSubID     uint64                  `protobuf:"varint,5,opt,name=NextSubID,proto3" json:"NextSubID,omitempty"`
	ChannelID     uint64                  `protobuf:"varint,6,opt,name=ChannelID,proto3" json:"ChannelID,omitempty"`
}

func (m *ChannelSnapshot) Reset()                    { *m = ChannelSnapshot{} }
func (m *ChannelSnapshot) String() string            { return proto.CompactTextString(m) }
func (*ChannelSnapshot) ProtoMessage()               {}
func (*ChannelSnapshot) Descriptor() ([]byte, []int) { return fileDescriptorProtocol, []int{15} }

// SubscriptionSnaphot is the snapshot of a subscription
type SubscriptionSnapshot struct {
	State       *SubState `protobuf:"bytes,1,opt,name=State" json:"State,omitempty"`
	AcksPending []uint64  `protobuf:"varint,2,rep,packed,name=AcksPending" json:"AcksPending,omitempty"`
}

func (m *SubscriptionSnapshot) Reset()                    { *m = SubscriptionSnapshot{} }
func (m *SubscriptionSnapshot) String() string            { return proto.CompactTextString(m) }
func (*SubscriptionSnapshot) ProtoMessage()               {}
func (*SubscriptionSnapshot) Descriptor() ([]byte, []int) { return fileDescriptorProtocol, []int{16} }

func init() {
	proto.RegisterType((*SubState)(nil), "spb.SubState")
	proto.RegisterType((*SubStateDelete)(nil), "spb.SubStateDelete")
	proto.RegisterType((*SubStateUpdate)(nil), "spb.SubStateUpdate")
	proto.RegisterType((*ServerInfo)(nil), "spb.ServerInfo")
	proto.RegisterType((*ClientInfo)(nil), "spb.ClientInfo")
	proto.RegisterType((*ClientDelete)(nil), "spb.ClientDelete")
	proto.RegisterType((*CtrlMsg)(nil), "spb.CtrlMsg")
	proto.RegisterType((*RaftJoinRequest)(nil), "spb.RaftJoinRequest")
	proto.RegisterType((*RaftJoinResponse)(nil), "spb.RaftJoinResponse")
	proto.RegisterType((*RaftOperation)(nil), "spb.RaftOperation")
	proto.RegisterType((*Batch)(nil), "spb.Batch")
	proto.RegisterType((*AddSubscription)(nil), "spb.AddSubscription")
	proto.RegisterType((*SubSentAndAck)(nil), "spb.SubSentAndAck")
	proto.RegisterType((*AddClient)(nil), "spb.AddClient")
	proto.RegisterType((*RaftSnapshot)(nil), "spb.RaftSnapshot")
	proto.RegisterType((*ChannelSnapshot)(nil), "spb.ChannelSnapshot")
	proto.RegisterType((*SubscriptionSnapshot)(nil), "spb.SubscriptionSnapshot")
	proto.RegisterEnum("spb.CtrlMsg_Type", CtrlMsg_Type_name, CtrlMsg_Type_value)
	proto.RegisterEnum("spb.RaftOperation_Type", RaftOperation_Type_name, RaftOperation_Type_value)
}
func (m *SubState) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *SubState) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ID != 0 {
		data[i] = 0x8
		i++
		i = encodeVarintProtocol(data, i, uint64(m.ID))
	}
	if len(m.ClientID) > 0 {
		data[i] = 0x12
		i++
		i = encodeVarintProtocol(data, i, uint64(len(m.ClientID)))
		i += copy(data[i:], m.ClientID)
	}
	if len(m.QGroup) > 0 {
		data[i] = 0x1a
		i++
		i = encodeVarintProtocol(data, i, uint64(len(m.QGroup)))
		i += copy(data[i:], m.QGroup)
	}
	if len(m.Inbox) > 0 {
		data[i] = 0x22
		i++
		i = encodeVarintProtocol(data, i, uint64(len(m.Inbox)))
		i += copy(data[i:], m.Inbox)
	}
	if len(m.AckInbox) > 0 {
		data[i] = 0x2a
		i++
		i = encodeVarintProtocol(data, i, uint64(len(m.AckInbox)))
		i += copy(data[i:], m.AckInbox)
	}
	if m.MaxInFlight != 0 {
		data[i] = 0x30
		i++
		i = encodeVarintProtocol(data, i, uint64(m.MaxInFlight))
	}
	if m.AckWaitInSecs != 0 {
		data[i] = 0x38
		i++
		i = encodeVarintProtocol(data, i, uint64(m.AckWaitInSecs))
	}
	if len(m.DurableName) > 0 {
		data[i] = 0x42
		i++
		i = encodeVarintProtocol(data, i, uint64(len(m.DurableName)))
		i += copy(data[i:], m.DurableName)
	}
	if m.LastSent != 0 {
		data[i] = 0x48
		i++
		i = encodeVarintProtocol(data, i, uint64(m.LastSent))
	}
	if m.IsDurable {
		data[i] = 0x50
		i++
		if m.IsDurable {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	if m.IsClosed {
		data[i] = 0x58
		i++
		if m.IsClosed {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *SubStateDelete) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *SubStateDelete) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ID != 0 {
		data[i] = 0x8
		i++
		i = encodeVarintProtocol(data, i, uint64(m.ID))
	}
	return i, nil
}

func (m *SubStateUpdate) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *SubStateUpdate) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ID != 0 {
		data[i] = 0x8
		i++
		i = encodeVarintProtocol(data, i, uint64(m.ID))
	}
	if m.Seqno != 0 {
		data[i] = 0x10
		i++
		i = encodeVarintProtocol(data, i, uint64(m.Seqno))
	}
	return i, nil
}

func (m *ServerInfo) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ServerInfo) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ClusterID) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintProtocol(data, i, uint64(len(m.ClusterID)))
		i += copy(data[i:], m.ClusterID)
	}
	if len(m.Discovery) > 0 {
		data[i] = 0x12
		i++
		i = encodeVarintProtocol(data, i, uint64(len(m.Discovery)))
		i += copy(data[i:], m.Discovery)
	}
	if len(m.Publish) > 0 {
		data[i] = 0x1a
		i++
		i = encodeVarintProtocol(data, i, uint64(len(m.Publish)))
		i += copy(data[i:], m.Publish)
	}
	if len(m.Subscribe) > 0 {
		data[i] = 0x22
		i++
		i = encodeVarintProtocol(data, i, uint64(len(m.Subscribe)))
		i += copy(data[i:], m.Subscribe)
	}
	if len(m.Unsubscribe) > 0 {
		data[i] = 0x2a
		i++
		i = encodeVarintProtocol(data, i, uint64(len(m.Unsubscribe)))
		i += copy(data[i:], m.Unsubscribe)
	}
	if len(m.Close) > 0 {
		data[i] = 0x32
		i++
		i = encodeVarintProtocol(data, i, uint64(len(m.Close)))
		i += copy(data[i:], m.Close)
	}
	if len(m.SubClose) > 0 {
		data[i] = 0x3a
		i++
		i = encodeVarintProtocol(data, i, uint64(len(m.SubClose)))
		i += copy(data[i:], m.SubClose)
	}
	if len(m.AcksSubs) > 0 {
		data[i] = 0x42
		i++
		i = encodeVarintProtocol(data, i, uint64(len(m.AcksSubs)))
		i += copy(data[i:], m.AcksSubs)
	}
	if len(m.NodeID) > 0 {
		data[i] = 0x4a
		i++
		i = encodeVarintProtocol(data, i, uint64(len(m.NodeID)))
		i += copy(data[i:], m.NodeID)
	}
	return i, nil
}

func (m *ClientInfo) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ClientInfo) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ID) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintProtocol(data, i, uint64(len(m.ID)))
		i += copy(data[i:], m.ID)
	}
	if len(m.HbInbox) > 0 {
		data[i] = 0x12
		i++
		i = encodeVarintProtocol(data, i, uint64(len(m.HbInbox)))
		i += copy(data[i:], m.HbInbox)
	}
	if len(m.ConnID) > 0 {
		data[i] = 0x1a
		i++
		i = encodeVarintProtocol(data, i, uint64(len(m.ConnID)))
		i += copy(data[i:], m.ConnID)
	}
	if m.Protocol != 0 {
		data[i] = 0x20
		i++
		i = encodeVarintProtocol(data, i, uint64(m.Protocol))
	}
	if m.PingInterval != 0 {
		data[i] = 0x28
		i++
		i = encodeVarintProtocol(data, i, uint64(m.PingInterval))
	}
	if m.PingMaxOut != 0 {
		data[i] = 0x30
		i++
		i = encodeVarintProtocol(data, i, uint64(m.PingMaxOut))
	}
	return i, nil
}

func (m *ClientDelete) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ClientDelete) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ID) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintProtocol(data, i, uint64(len(m.ID)))
		i += copy(data[i:], m.ID)
	}
	return i, nil
}

func (m *CtrlMsg) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *CtrlMsg) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.MsgType != 0 {
		data[i] = 0x8
		i++
		i = encodeVarintProtocol(data, i, uint64(m.MsgType))
	}
	if len(m.ServerID) > 0 {
		data[i] = 0x12
		i++
		i = encodeVarintProtocol(data, i, uint64(len(m.ServerID)))
		i += copy(data[i:], m.ServerID)
	}
	if len(m.Data) > 0 {
		data[i] = 0x1a
		i++
		i = encodeVarintProtocol(data, i, uint64(len(m.Data)))
		i += copy(data[i:], m.Data)
	}
	if len(m.RefID) > 0 {
		data[i] = 0x22
		i++
		i = encodeVarintProtocol(data, i, uint64(len(m.RefID)))
		i += copy(data[i:], m.RefID)
	}
	return i, nil
}

func (m *RaftJoinRequest) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *RaftJoinRequest) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.NodeID) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintProtocol(data, i, uint64(len(m.NodeID)))
		i += copy(data[i:], m.NodeID)
	}
	if len(m.NodeAddr) > 0 {
		data[i] = 0x12
		i++
		i = encodeVarintProtocol(data, i, uint64(len(m.NodeAddr)))
		i += copy(data[i:], m.NodeAddr)
	}
	return i, nil
}

func (m *RaftJoinResponse) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *RaftJoinResponse) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Error) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintProtocol(data, i, uint64(len(m.Error)))
		i += copy(data[i:], m.Error)
	}
	return i, nil
}

func (m *RaftOperation) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *RaftOperation) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.OpType != 0 {
		data[i] = 0x8
		i++
		i = encodeVarintProtocol(data, i, uint64(m.OpType))
	}
	if m.PublishBatch != nil {
		data[i] = 0x12
		i++
		i = encodeVarintProtocol(data, i, uint64(m.PublishBatch.Size()))
		n1, err := m.PublishBatch.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.Sub != nil {
		data[i] = 0x1a
		i++
		i = encodeVarintProtocol(data, i, uint64(m.Sub.Size()))
		n2, err := m.Sub.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.Unsub != nil {
		data[i] = 0x22
		i++
		i = encodeVarintProtocol(data, i, uint64(m.Unsub.Size()))
		n3, err := m.Unsub.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.SubSentAck != nil {
		data[i] = 0x2a
		i++
		i = encodeVarintProtocol(data, i, uint64(m.SubSentAck.Size()))
		n4, err := m.SubSentAck.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if m.ClientConnect != nil {
		data[i] = 0x3a
		i++
		i = encodeVarintProtocol(data, i, uint64(m.ClientConnect.Size()))
		n5, err := m.ClientConnect.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if m.ClientDisconnect != nil {
		data[i] = 0x42
		i++
		i = encodeVarintProtocol(data, i, uint64(m.ClientDisconnect.Size()))
		n6, err := m.ClientDisconnect.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if len(m.Channel) > 0 {
		data[i] = 0x4a
		i++
		i = encodeVarintProtocol(data, i, uint64(len(m.Channel)))
		i += copy(data[i:], m.Channel)
	}
	if m.ChannelID != 0 {
		data[i] = 0x50
		i++
		i = encodeVarintProtocol(data, i, uint64(m.ChannelID))
	}
	return i, nil
}

func (m *Batch) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Batch) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Messages) > 0 {
		for _, msg := range m.Messages {
			data[i] = 0xa
			i++
			i = encodeVarintProtocol(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *AddSubscription) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *AddSubscription) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Request != nil {
		data[i] = 0xa
		i++
		i = encodeVarintProtocol(data, i, uint64(m.Request.Size()))
		n7, err := m.Request.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if len(m.AckInbox) > 0 {
		data[i] = 0x12
		i++
		i = encodeVarintProtocol(data, i, uint64(len(m.AckInbox)))
		i += copy(data[i:], m.AckInbox)
	}
	if m.ID != 0 {
		data[i] = 0x18
		i++
		i = encodeVarintProtocol(data, i, uint64(m.ID))
	}
	return i, nil
}

func (m *SubSentAndAck) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *SubSentAndAck) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Channel) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintProtocol(data, i, uint64(len(m.Channel)))
		i += copy(data[i:], m.Channel)
	}
	if len(m.AckInbox) > 0 {
		data[i] = 0x12
		i++
		i = encodeVarintProtocol(data, i, uint64(len(m.AckInbox)))
		i += copy(data[i:], m.AckInbox)
	}
	if len(m.Sent) > 0 {
		data9 := make([]byte, len(m.Sent)*10)
		var j8 int
		for _, num := range m.Sent {
			for num >= 1<<7 {
				data9[j8] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j8++
			}
			data9[j8] = uint8(num)
			j8++
		}
		data[i] = 0x1a
		i++
		i = encodeVarintProtocol(data, i, uint64(j8))
		i += copy(data[i:], data9[:j8])
	}
	if len(m.Ack) > 0 {
		data11 := make([]byte, len(m.Ack)*10)
		var j10 int
		for _, num := range m.Ack {
			for num >= 1<<7 {
				data11[j10] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j10++
			}
			data11[j10] = uint8(num)
			j10++
		}
		data[i] = 0x22
		i++
		i = encodeVarintProtocol(data, i, uint64(j10))
		i += copy(data[i:], data11[:j10])
	}
	return i, nil
}

func (m *AddClient) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *AddClient) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Request != nil {
		data[i] = 0xa
		i++
		i = encodeVarintProtocol(data, i, uint64(m.Request.Size()))
		n12, err := m.Request.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n12
	}
	if m.Refresh {
		data[i] = 0x10
		i++
		if m.Refresh {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *RaftSnapshot) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *RaftSnapshot) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Clients) > 0 {
		for _, msg := range m.Clients {
			data[i] = 0xa
			i++
			i = encodeVarintProtocol(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Channels) > 0 {
		for _, msg := range m.Channels {
			data[i] = 0x12
			i++
			i = encodeVarintProtocol(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Padding) > 0 {
		data[i] = 0x1a
		i++
		i = encodeVarintProtocol(data, i, uint64(len(m.Padding)))
		i += copy(data[i:], m.Padding)
	}
	return i, nil
}

func (m *ChannelSnapshot) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ChannelSnapshot) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Channel) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintProtocol(data, i, uint64(len(m.Channel)))
		i += copy(data[i:], m.Channel)
	}
	if m.First != 0 {
		data[i] = 0x10
		i++
		i = encodeVarintProtocol(data, i, uint64(m.First))
	}
	if m.Last != 0 {
		data[i] = 0x18
		i++
		i = encodeVarintProtocol(data, i, uint64(m.Last))
	}
	if len(m.Subscriptions) > 0 {
		for _, msg := range m.Subscriptions {
			data[i] = 0x22
			i++
			i = encodeVarintProtocol(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.NextSubID != 0 {
		data[i] = 0x28
		i++
		i = encodeVarintProtocol(data, i, uint64(m.NextSubID))
	}
	if m.ChannelID != 0 {
		data[i] = 0x30
		i++
		i = encodeVarintProtocol(data, i, uint64(m.ChannelID))
	}
	return i, nil
}

func (m *SubscriptionSnapshot) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *SubscriptionSnapshot) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.State != nil {
		data[i] = 0xa
		i++
		i = encodeVarintProtocol(data, i, uint64(m.State.Size()))
		n13, err := m.State.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	if len(m.AcksPending) > 0 {
		data15 := make([]byte, len(m.AcksPending)*10)
		var j14 int
		for _, num := range m.AcksPending {
			for num >= 1<<7 {
				data15[j14] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j14++
			}
			data15[j14] = uint8(num)
			j14++
		}
		data[i] = 0x12
		i++
		i = encodeVarintProtocol(data, i, uint64(j14))
		i += copy(data[i:], data15[:j14])
	}
	return i, nil
}

func encodeFixed64Protocol(data []byte, offset int, v uint64) int {
	data[offset] = uint8(v)
	data[offset+1] = uint8(v >> 8)
	data[offset+2] = uint8(v >> 16)
	data[offset+3] = uint8(v >> 24)
	data[offset+4] = uint8(v >> 32)
	data[offset+5] = uint8(v >> 40)
	data[offset+6] = uint8(v >> 48)
	data[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32Protocol(data []byte, offset int, v uint32) int {
	data[offset] = uint8(v)
	data[offset+1] = uint8(v >> 8)
	data[offset+2] = uint8(v >> 16)
	data[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintProtocol(data []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		data[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	data[offset] = uint8(v)
	return offset + 1
}
func (m *SubState) Size() (n int) {
	var l int
	_ = l
	if m.ID != 0 {
		n += 1 + sovProtocol(uint64(m.ID))
	}
	l = len(m.ClientID)
	if l > 0 {
		n += 1 + l + sovProtocol(uint64(l))
	}
	l = len(m.QGroup)
	if l > 0 {
		n += 1 + l + sovProtocol(uint64(l))
	}
	l = len(m.Inbox)
	if l > 0 {
		n += 1 + l + sovProtocol(uint64(l))
	}
	l = len(m.AckInbox)
	if l > 0 {
		n += 1 + l + sovProtocol(uint64(l))
	}
	if m.MaxInFlight != 0 {
		n += 1 + sovProtocol(uint64(m.MaxInFlight))
	}
	if m.AckWaitInSecs != 0 {
		n += 1 + sovProtocol(uint64(m.AckWaitInSecs))
	}
	l = len(m.DurableName)
	if l > 0 {
		n += 1 + l + sovProtocol(uint64(l))
	}
	if m.LastSent != 0 {
		n += 1 + sovProtocol(uint64(m.LastSent))
	}
	if m.IsDurable {
		n += 2
	}
	if m.IsClosed {
		n += 2
	}
	return n
}

func (m *SubStateDelete) Size() (n int) {
	var l int
	_ = l
	if m.ID != 0 {
		n += 1 + sovProtocol(uint64(m.ID))
	}
	return n
}

func (m *SubStateUpdate) Size() (n int) {
	var l int
	_ = l
	if m.ID != 0 {
		n += 1 + sovProtocol(uint64(m.ID))
	}
	if m.Seqno != 0 {
		n += 1 + sovProtocol(uint64(m.Seqno))
	}
	return n
}

func (m *ServerInfo) Size() (n int) {
	var l int
	_ = l
	l = len(m.ClusterID)
	if l > 0 {
		n += 1 + l + sovProtocol(uint64(l))
	}
	l = len(m.Discovery)
	if l > 0 {
		n += 1 + l + sovProtocol(uint64(l))
	}
	l = len(m.Publish)
	if l > 0 {
		n += 1 + l + sovProtocol(uint64(l))
	}
	l = len(m.Subscribe)
	if l > 0 {
		n += 1 + l + sovProtocol(uint64(l))
	}
	l = len(m.Unsubscribe)
	if l > 0 {
		n += 1 + l + sovProtocol(uint64(l))
	}
	l = len(m.Close)
	if l > 0 {
		n += 1 + l + sovProtocol(uint64(l))
	}
	l = len(m.SubClose)
	if l > 0 {
		n += 1 + l + sovProtocol(uint64(l))
	}
	l = len(m.AcksSubs)
	if l > 0 {
		n += 1 + l + sovProtocol(uint64(l))
	}
	l = len(m.NodeID)
	if l > 0 {
		n += 1 + l + sovProtocol(uint64(l))
	}
	return n
}

func (m *ClientInfo) Size() (n int) {
	var l int
	_ = l
	l = len(m.ID)
	if l > 0 {
		n += 1 + l + sovProtocol(uint64(l))
	}
	l = len(m.HbInbox)
	if l > 0 {
		n += 1 + l + sovProtocol(uint64(l))
	}
	l = len(m.ConnID)
	if l > 0 {
		n += 1 + l + sovProtocol(uint64(l))
	}
	if m.Protocol != 0 {
		n += 1 + sovProtocol(uint64(m.Protocol))
	}
	if m.PingInterval != 0 {
		n += 1 + sovProtocol(uint64(m.PingInterval))
	}
	if m.PingMaxOut != 0 {
		n += 1 + sovProtocol(uint64(m.PingMaxOut))
	}
	return n
}

func (m *ClientDelete) Size() (n int) {
	var l int
	_ = l
	l = len(m.ID)
	if l > 0 {
		n += 1 + l + sovProtocol(uint64(l))
	}
	return n
}

func (m *CtrlMsg) Size() (n int) {
	var l int
	_ = l
	if m.MsgType != 0 {
		n += 1 + sovProtocol(uint64(m.MsgType))
	}
	l = len(m.ServerID)
	if l > 0 {
		n += 1 + l + sovProtocol(uint64(l))
	}
	l = len(m.Data)
	if l > 0 {
		n += 1 + l + sovProtocol(uint64(l))
	}
	l = len(m.RefID)
	if l > 0 {
		n += 1 + l + sovProtocol(uint64(l))
	}
	return n
}

func (m *RaftJoinRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.NodeID)
	if l > 0 {
		n += 1 + l + sovProtocol(uint64(l))
	}
	l = len(m.NodeAddr)
	if l > 0 {
		n += 1 + l + sovProtocol(uint64(l))
	}
	return n
}

func (m *RaftJoinResponse) Size() (n int) {
	var l int
	_ = l
	l = len(m.Error)
	if l > 0 {
		n += 1 + l + sovProtocol(uint64(l))
	}
	return n
}

func (m *RaftOperation) Size() (n int) {
	var l int
	_ = l
	if m.OpType != 0 {
		n += 1 + sovProtocol(uint64(m.OpType))
	}
	if m.PublishBatch != nil {
		l = m.PublishBatch.Size()
		n += 1 + l + sovProtocol(uint64(l))
	}
	if m.Sub != nil {
		l = m.Sub.Size()
		n += 1 + l + sovProtocol(uint64(l))
	}
	if m.Unsub != nil {
		l = m.Unsub.Size()
		n += 1 + l + sovProtocol(uint64(l))
	}
	if m.SubSentAck != nil {
		l = m.SubSentAck.Size()
		n += 1 + l + sovProtocol(uint64(l))
	}
	if m.ClientConnect != nil {
		l = m.ClientConnect.Size()
		n += 1 + l + sovProtocol(uint64(l))
	}
	if m.ClientDisconnect != nil {
		l = m.ClientDisconnect.Size()
		n += 1 + l + sovProtocol(uint64(l))
	}
	l = len(m.Channel)
	if l > 0 {
		n += 1 + l + sovProtocol(uint64(l))
	}
	if m.ChannelID != 0 {
		n += 1 + sovProtocol(uint64(m.ChannelID))
	}
	return n
}

func (m *Batch) Size() (n int) {
	var l int
	_ = l
	if len(m.Messages) > 0 {
		for _, e := range m.Messages {
			l = e.Size()
			n += 1 + l + sovProtocol(uint64(l))
		}
	}
	return n
}

func (m *AddSubscription) Size() (n int) {
	var l int
	_ = l
	if m.Request != nil {
		l = m.Request.Size()
		n += 1 + l + sovProtocol(uint64(l))
	}
	l = len(m.AckInbox)
	if l > 0 {
		n += 1 + l + sovProtocol(uint64(l))
	}
	if m.ID != 0 {
		n += 1 + sovProtocol(uint64(m.ID))
	}
	return n
}

func (m *SubSentAndAck) Size() (n int) {
	var l int
	_ = l
	l = len(m.Channel)
	if l > 0 {
		n += 1 + l + sovProtocol(uint64(l))
	}
	l = len(m.AckInbox)
	if l > 0 {
		n += 1 + l + sovProtocol(uint64(l))
	}
	if len(m.Sent) > 0 {
		l = 0
		for _, e := range m.Sent {
			l += sovProtocol(uint64(e))
		}
		n += 1 + sovProtocol(uint64(l)) + l
	}
	if len(m.Ack) > 0 {
		l = 0
		for _, e := range m.Ack {
			l += sovProtocol(uint64(e))
		}
		n += 1 + sovProtocol(uint64(l)) + l
	}
	return n
}

func (m *AddClient) Size() (n int) {
	var l int
	_ = l
	if m.Request != nil {
		l = m.Request.Size()
		n += 1 + l + sovProtocol(uint64(l))
	}
	if m.Refresh {
		n += 2
	}
	return n
}

func (m *RaftSnapshot) Size() (n int) {
	var l int
	_ = l
	if len(m.Clients) > 0 {
		for _, e := range m.Clients {
			l = e.Size()
			n += 1 + l + sovProtocol(uint64(l))
		}
	}
	if len(m.Channels) > 0 {
		for _, e := range m.Channels {
			l = e.Size()
			n += 1 + l + sovProtocol(uint64(l))
		}
	}
	l = len(m.Padding)
	if l > 0 {
		n += 1 + l + sovProtocol(uint64(l))
	}
	return n
}

func (m *ChannelSnapshot) Size() (n int) {
	var l int
	_ = l
	l = len(m.Channel)
	if l > 0 {
		n += 1 + l + sovProtocol(uint64(l))
	}
	if m.First != 0 {
		n += 1 + sovProtocol(uint64(m.First))
	}
	if m.Last != 0 {
		n += 1 + sovProtocol(uint64(m.Last))
	}
	if len(m.Subscriptions) > 0 {
		for _, e := range m.Subscriptions {
			l = e.Size()
			n += 1 + l + sovProtocol(uint64(l))
		}
	}
	if m.NextSubID != 0 {
		n += 1 + sovProtocol(uint64(m.NextSubID))
	}
	if m.ChannelID != 0 {
		n += 1 + sovProtocol(uint64(m.ChannelID))
	}
	return n
}

func (m *SubscriptionSnapshot) Size() (n int) {
	var l int
	_ = l
	if m.State != nil {
		l = m.State.Size()
		n += 1 + l + sovProtocol(uint64(l))
	}
	if len(m.AcksPending) > 0 {
		l = 0
		for _, e := range m.AcksPending {
			l += sovProtocol(uint64(e))
		}
		n += 1 + sovProtocol(uint64(l)) + l
	}
	return n
}

func sovProtocol(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozProtocol(x uint64) (n int) {
	return sovProtocol(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *SubState) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocol
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SubState: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SubState: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			m.ID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.ID |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClientID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProtocol
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClientID = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field QGroup", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProtocol
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.QGroup = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Inbox", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProtocol
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Inbox = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AckInbox", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProtocol
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AckInbox = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxInFlight", wireType)
			}
			m.MaxInFlight = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.MaxInFlight |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AckWaitInSecs", wireType)
			}
			m.AckWaitInSecs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.AckWaitInSecs |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DurableName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProtocol
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DurableName = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastSent", wireType)
			}
			m.LastSent = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.LastSent |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsDurable", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsDurable = bool(v != 0)
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsClosed", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsClosed = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipProtocol(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProtocol
			}
			if (iNdEx+skippy) > l || (iNdEx+skippy) < 0 {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SubStateDelete) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocol
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SubStateDelete: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SubStateDelete: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			m.ID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.ID |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipProtocol(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProtocol
			}
			if (iNdEx+skippy) > l || (iNdEx+skippy) < 0 {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SubStateUpdate) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocol
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SubStateUpdate: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SubStateUpdate: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			m.ID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.ID |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Seqno", wireType)
			}
			m.Seqno = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Seqno |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipProtocol(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProtocol
			}
			if (iNdEx+skippy) > l || (iNdEx+skippy) < 0 {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ServerInfo) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocol
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ServerInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ServerInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProtocol
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterID = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Discovery", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProtocol
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Discovery = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Publish", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProtocol
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Publish = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subscribe", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProtocol
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Subscribe = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Unsubscribe", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProtocol
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Unsubscribe = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Close", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProtocol
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Close = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SubClose", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProtocol
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SubClose = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AcksSubs", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProtocol
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AcksSubs = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProtocol
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeID = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocol(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProtocol
			}
			if (iNdEx+skippy) > l || (iNdEx+skippy) < 0 {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ClientInfo) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocol
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ClientInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ClientInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProtocol
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ID = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HbInbox", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProtocol
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HbInbox = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConnID", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocol
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ConnID = append(m.ConnID[:0], data[iNdEx:postIndex]...)
			if m.ConnID == nil {
				m.ConnID = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Protocol", wireType)
			}
			m.Protocol = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Protocol |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PingInterval", wireType)
			}
			m.PingInterval = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.PingInterval |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PingMaxOut", wireType)
			}
			m.PingMaxOut = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.PingMaxOut |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipProtocol(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProtocol
			}
			if (iNdEx+skippy) > l || (iNdEx+skippy) < 0 {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ClientDelete) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocol
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ClientDelete: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ClientDelete: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProtocol
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ID = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocol(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProtocol
			}
			if (iNdEx+skippy) > l || (iNdEx+skippy) < 0 {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CtrlMsg) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocol
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CtrlMsg: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CtrlMsg: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MsgType", wireType)
			}
			m.MsgType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.MsgType |= (CtrlMsg_Type(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServerID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProtocol
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ServerID = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocol
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], data[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RefID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProtocol
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RefID = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocol(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProtocol
			}
			if (iNdEx+skippy) > l || (iNdEx+skippy) < 0 {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RaftJoinRequest) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocol
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RaftJoinRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RaftJoinRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProtocol
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeID = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeAddr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProtocol
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeAddr = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocol(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProtocol
			}
			if (iNdEx+skippy) > l || (iNdEx+skippy) < 0 {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RaftJoinResponse) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocol
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RaftJoinResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RaftJoinResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProtocol
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Error = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocol(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProtocol
			}
			if (iNdEx+skippy) > l || (iNdEx+skippy) < 0 {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RaftOperation) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocol
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RaftOperation: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RaftOperation: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field OpType", wireType)
			}
			m.OpType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.OpType |= (RaftOperation_Type(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PublishBatch", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProtocol
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PublishBatch == nil {
				m.PublishBatch = &Batch{}
			}
			if err := m.PublishBatch.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sub", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProtocol
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Sub == nil {
				m.Sub = &AddSubscription{}
			}
			if err := m.Sub.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Unsub", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProtocol
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Unsub == nil {
				m.Unsub = &pb.UnsubscribeRequest{}
			}
			if err := m.Unsub.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SubSentAck", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProtocol
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SubSentAck == nil {
				m.SubSentAck = &SubSentAndAck{}
			}
			if err := m.SubSentAck.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClientConnect", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProtocol
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ClientConnect == nil {
				m.ClientConnect = &AddClient{}
			}
			if err := m.ClientConnect.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClientDisconnect", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProtocol
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ClientDisconnect == nil {
				m.ClientDisconnect = &pb.CloseRequest{}
			}
			if err := m.ClientDisconnect.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Channel", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProtocol
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Channel = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ChannelID", wireType)
			}
			m.ChannelID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.ChannelID |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipProtocol(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProtocol
			}
			if (iNdEx+skippy) > l || (iNdEx+skippy) < 0 {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Batch) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocol
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Batch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Batch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Messages", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProtocol
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Messages = append(m.Messages, &pb.MsgProto{})
			if err := m.Messages[len(m.Messages)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocol(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProtocol
			}
			if (iNdEx+skippy) > l || (iNdEx+skippy) < 0 {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AddSubscription) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocol
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AddSubscription: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AddSubscription: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Request", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProtocol
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Request == nil {
				m.Request = &pb.SubscriptionRequest{}
			}
			if err := m.Request.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AckInbox", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProtocol
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AckInbox = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			m.ID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.ID |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipProtocol(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProtocol
			}
			if (iNdEx+skippy) > l || (iNdEx+skippy) < 0 {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SubSentAndAck) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocol
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SubSentAndAck: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SubSentAndAck: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Channel", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProtocol
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Channel = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AckInbox", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProtocol
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AckInbox = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProtocol
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := data[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthProtocol
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowProtocol
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := data[iNdEx]
						iNdEx++
						v |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Sent = append(m.Sent, v)
				}
			} else if wireType == 0 {
				var v uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProtocol
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := data[iNdEx]
					iNdEx++
					v |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Sent = append(m.Sent, v)
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Sent", wireType)
			}
		case 4:
			if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProtocol
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := data[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthProtocol
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowProtocol
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := data[iNdEx]
						iNdEx++
						v |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Ack = append(m.Ack, v)
				}
			} else if wireType == 0 {
				var v uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProtocol
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := data[iNdEx]
					iNdEx++
					v |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Ack = append(m.Ack, v)
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Ack", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipProtocol(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProtocol
			}
			if (iNdEx+skippy) > l || (iNdEx+skippy) < 0 {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AddClient) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocol
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AddClient: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AddClient: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Request", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProtocol
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Request == nil {
				m.Request = &pb.ConnectRequest{}
			}
			if err := m.Request.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Refresh", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Refresh = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipProtocol(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProtocol
			}
			if (iNdEx+skippy) > l || (iNdEx+skippy) < 0 {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RaftSnapshot) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocol
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RaftSnapshot: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RaftSnapshot: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Clients", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProtocol
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Clients = append(m.Clients, &ClientInfo{})
			if err := m.Clients[len(m.Clients)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Channels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProtocol
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Channels = append(m.Channels, &ChannelSnapshot{})
			if err := m.Channels[len(m.Channels)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Padding", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProtocol
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Padding = append(m.Padding[:0], data[iNdEx:postIndex]...)
			if m.Padding == nil {
				m.Padding = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProtocol(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProtocol
			}
			if (iNdEx+skippy) > l || (iNdEx+skippy) < 0 {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ChannelSnapshot) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocol
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ChannelSnapshot: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ChannelSnapshot: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Channel", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthProtocol
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Channel = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field First", wireType)
			}
			m.First = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.First |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Last", wireType)
			}
			m.Last = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Last |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subscriptions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProtocol
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Subscriptions = append(m.Subscriptions, &SubscriptionSnapshot{})
			if err := m.Subscriptions[len(m.Subscriptions)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextSubID", wireType)
			}
			m.NextSubID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.NextSubID |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ChannelID", wireType)
			}
			m.ChannelID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.ChannelID |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipProtocol(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProtocol
			}
			if (iNdEx+skippy) > l || (iNdEx+skippy) < 0 {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SubscriptionSnapshot) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProtocol
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SubscriptionSnapshot: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SubscriptionSnapshot: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProtocol
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.State == nil {
				m.State = &SubState{}
			}
			if err := m.State.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProtocol
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := data[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthProtocol
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowProtocol
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := data[iNdEx]
						iNdEx++
						v |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.AcksPending = append(m.AcksPending, v)
				}
			} else if wireType == 0 {
				var v uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProtocol
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := data[iNdEx]
					iNdEx++
					v |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.AcksPending = append(m.AcksPending, v)
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field AcksPending", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipProtocol(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProtocol
			}
			if (iNdEx+skippy) > l || (iNdEx+skippy) < 0 {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipProtocol(data []byte) (n int, err error) {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowProtocol
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if data[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowProtocol
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthProtocol
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowProtocol
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := data[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipProtocol(data[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, io.ErrUnexpectedEOF
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthProtocol = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowProtocol   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("protocol.proto", fileDescriptorProtocol) }

var fileDescriptorProtocol = []byte{
	// 1252 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x7c, 0x56, 0x41, 0x8f, 0xdb, 0x44,
	0x14, 0x5e, 0x27, 0xce, 0x26, 0x79, 0x49, 0x76, 0xdd, 0xd1, 0xd2, 0x9a, 0x0a, 0x45, 0x91, 0x41,
	0x28, 0x88, 0x36, 0x4b, 0x03, 0xe2, 0x84, 0x84, 0xb6, 0x9b, 0x96, 0x1a, 0xb1, 0xed, 0x6a, 0xd2,
	0x0a, 0x09, 0x89, 0xc3, 0xd8, 0x99, 0xcd, 0x5a, 0xc9, 0x8e, 0x5d, 0xcf, 0x78, 0xb5, 0xfd, 0x01,
	0x48, 0x1c, 0xe1, 0x8f, 0xf0, 0x03, 0x38, 0x71, 0xec, 0x11, 0x71, 0xe2, 0x08, 0xe5, 0x8f, 0xa0,
	0x79, 0x33, 0x76, 0x9c, 0xdd, 0xaa, 0xb7, 0xf9, 0xde, 0x7b, 0x33, 0x7e, 0xf3, 0x7d, 0xef, 0xbd,
	0x31, 0xec, 0x65, 0x79, 0xaa, 0xd2, 0x38, 0x5d, 0x4f, 0x70, 0x41, 0x9a, 0x32, 0x8b, 0xee, 0xde,
	0x5f, 0x26, 0xea, 0xbc, 0x88, 0x26, 0x71, 0x7a, 0x71, 0xb8, 0x4c, 0x97, 0xe9, 0x21, 0xfa, 0xa2,
	0xe2, 0x0c, 0x11, 0x02, 0x5c, 0x99, 0x3d, 0x77, 0xef, 0xd5, 0xc2, 0x05, 0x53, 0xf2, 0x7e, 0x92,
	0x1e, 0x4a, 0xc5, 0xc4, 0x44, 0xef, 0x8c, 0x0e, 0xb7, 0xbf, 0x10, 0xfc, 0xd1, 0x80, 0xce, 0xbc,
	0x88, 0xe6, 0x8a, 0x29, 0x4e, 0xf6, 0xa0, 0x11, 0xce, 0x7c, 0x67, 0xe4, 0x8c, 0x5d, 0xda, 0x08,
	0x67, 0xe4, 0x2e, 0x74, 0xe2, 0x75, 0xc2, 0x85, 0x0a, 0x67, 0x7e, 0x63, 0xe4, 0x8c, 0xbb, 0xb4,
	0xc2, 0xe4, 0x36, 0xec, 0xbe, 0xfc, 0x26, 0x4f, 0x8b, 0xcc, 0x6f, 0xa2, 0xc7, 0x22, 0x72, 0x00,
	0xad, 0x44, 0x44, 0xe9, 0x95, 0xef, 0xa2, 0xd9, 0x00, 0x7d, 0x12, 0x8b, 0x57, 0x21, 0x3a, 0x5a,
	0xe6, 0xa4, 0x12, 0x93, 0x11, 0xf4, 0x2e, 0xd8, 0x55, 0x28, 0x1e, 0xaf, 0x93, 0xe5, 0xb9, 0xf2,
	0x77, 0x47, 0xce, 0xb8, 0x45, 0xeb, 0x26, 0xf2, 0x11, 0x0c, 0x58, 0xbc, 0xfa, 0x9e, 0x25, 0x2a,
	0x14, 0x73, 0x1e, 0x4b, 0xbf, 0x8d, 0x31, 0xdb, 0x46, 0x7d, 0xce, 0xa2, 0xc8, 0x59, 0xb4, 0xe6,
	0x4f, 0xd9, 0x05, 0xf7, 0x3b, 0xf8, 0x99, 0xba, 0x49, 0x67, 0xb1, 0x66, 0x52, 0xcd, 0xb9, 0x50,
	0x7e, 0x17, 0x6f, 0x59, 0x61, 0xf2, 0x01, 0x74, 0x13, 0x39, 0x33, 0xc1, 0x3e, 0x8c, 0x9c, 0x71,
	0x87, 0x6e, 0x0c, 0x7a, 0x67, 0x22, 0x8f, 0xd7, 0xa9, 0xe4, 0x0b, 0xbf, 0x87, 0xce, 0x0a, 0x07,
	0x23, 0xd8, 0x2b, 0x19, 0x9c, 0xf1, 0x35, 0xbf, 0xc9, 0x63, 0xf0, 0xe5, 0x26, 0xe2, 0x45, 0xb6,
	0x78, 0x1b, 0xd3, 0x07, 0xd0, 0x92, 0xfc, 0xa5, 0x48, 0x91, 0x66, 0x97, 0x1a, 0x10, 0xfc, 0xdc,
	0x00, 0x98, 0xf3, 0xfc, 0x92, 0xe7, 0xa1, 0x38, 0x4b, 0x75, 0x8a, 0xc7, 0xeb, 0x42, 0x2a, 0x9e,
	0xdb, 0xbd, 0x5d, 0xba, 0x31, 0x68, 0xef, 0x2c, 0x91, 0x71, 0x7a, 0xc9, 0xf3, 0x57, 0x56, 0xad,
	0x8d, 0x81, 0xf8, 0xd0, 0x3e, 0x2d, 0xa2, 0x75, 0x22, 0xcf, 0xad, 0x5e, 0x25, 0xd4, 0xfb, 0xe6,
	0x45, 0x24, 0xe3, 0x3c, 0x89, 0xb8, 0x15, 0x6d, 0x63, 0xd0, 0xa4, 0xbe, 0x10, 0xb2, 0xf2, 0x1b,
	0xed, 0xea, 0x26, 0x9d, 0x3a, 0x12, 0x81, 0xc2, 0x75, 0xa9, 0x01, 0x9a, 0xb0, 0x79, 0x11, 0x19,
	0x47, 0xdb, 0x08, 0x5e, 0x62, 0xed, 0x3b, 0x8a, 0x57, 0x52, 0x7f, 0xc4, 0xaa, 0x54, 0x61, 0x5d,
	0x56, 0x4f, 0xd3, 0x05, 0x0f, 0x67, 0x28, 0x50, 0x97, 0x5a, 0x14, 0xfc, 0xe6, 0x00, 0x1c, 0x9b,
	0xda, 0xd3, 0x54, 0x6c, 0xf8, 0xeb, 0x22, 0x7f, 0x3e, 0xb4, 0x9f, 0x44, 0xa6, 0xbc, 0xcc, 0xd5,
	0x4b, 0xa8, 0x0f, 0x3c, 0x4e, 0x85, 0x08, 0x67, 0x78, 0xef, 0x3e, 0xb5, 0x48, 0x27, 0x71, 0x6a,
	0x5b, 0x01, 0x6f, 0xdd, 0xa2, 0x15, 0x26, 0x01, 0xf4, 0x4f, 0x13, 0xb1, 0x0c, 0x85, 0xe2, 0xf9,
	0x25, 0x5b, 0xe3, 0xad, 0x5b, 0x74, 0xcb, 0x46, 0x86, 0x00, 0x1a, 0x9f, 0xb0, 0xab, 0x67, 0x45,
	0x59, 0xb4, 0x35, 0x4b, 0x30, 0x84, 0xbe, 0xc9, 0xf7, 0x46, 0x4d, 0x60, 0xc6, 0xc1, 0xdf, 0x0e,
	0xb4, 0x8f, 0x55, 0xbe, 0x3e, 0x91, 0x4b, 0xf2, 0x29, 0xb4, 0x4f, 0xe4, 0xf2, 0xf9, 0xab, 0x8c,
	0x63, 0xc0, 0xde, 0xf4, 0xd6, 0x44, 0x66, 0xd1, 0xc4, 0xba, 0x27, 0xda, 0x41, 0xcb, 0x08, 0x64,
	0xd6, 0xd4, 0x44, 0xd5, 0x94, 0x25, 0x26, 0x04, 0xdc, 0x19, 0x53, 0xcc, 0x5e, 0x15, 0xd7, 0x5a,
	0x1f, 0xca, 0xcf, 0xc2, 0x59, 0xd9, 0x90, 0x08, 0x82, 0x1f, 0xc0, 0xc5, 0xd3, 0x08, 0x96, 0x66,
	0x4d, 0x4f, 0x6f, 0x87, 0xf4, 0x37, 0xda, 0x79, 0x0e, 0x19, 0x40, 0x57, 0x53, 0x66, 0x60, 0x83,
	0xec, 0x43, 0xef, 0xf1, 0xf3, 0x27, 0x9c, 0xe5, 0x2a, 0xe2, 0x4c, 0x79, 0x4d, 0xe2, 0x41, 0xff,
	0x94, 0xe5, 0x2a, 0x51, 0x49, 0x2a, 0x12, 0xb1, 0xf4, 0xdc, 0xe0, 0x11, 0xec, 0x53, 0x76, 0xa6,
	0xbe, 0x4d, 0x13, 0x41, 0xf9, 0xcb, 0x82, 0x4b, 0x55, 0x93, 0xd5, 0xa9, 0xcb, 0xaa, 0x2f, 0xa3,
	0x57, 0x47, 0x8b, 0x45, 0x5e, 0x5e, 0xa6, 0xc4, 0xc1, 0x18, 0xbc, 0xcd, 0x31, 0x32, 0x4b, 0x85,
	0xc4, 0x62, 0x7b, 0x94, 0xe7, 0x69, 0x6e, 0x8f, 0x31, 0x20, 0xf8, 0xdd, 0x85, 0x81, 0x0e, 0x7d,
	0x96, 0xf1, 0x9c, 0xe9, 0x3c, 0xc8, 0x21, 0xec, 0x3e, 0xcb, 0x6a, 0x84, 0xde, 0x41, 0x42, 0xb7,
	0x62, 0x0c, 0xad, 0x36, 0x8c, 0x4c, 0xa0, 0x6f, 0x1b, 0xe2, 0x21, 0x53, 0xf1, 0x39, 0x26, 0xd3,
	0x9b, 0x02, 0x6e, 0x43, 0x0b, 0xdd, 0xf2, 0x93, 0x8f, 0xa1, 0x39, 0x2f, 0x22, 0x24, 0xba, 0x37,
	0x3d, 0xc0, 0xb0, 0xa3, 0xc5, 0xc2, 0xf6, 0x4d, 0xa6, 0xcf, 0xa7, 0x3a, 0x80, 0xdc, 0x83, 0x16,
	0x92, 0x8b, 0xec, 0xf7, 0xa6, 0xb7, 0x27, 0x59, 0x34, 0xa9, 0xb1, 0x6d, 0xf9, 0xa1, 0x26, 0x88,
	0x4c, 0x01, 0xf4, 0xa0, 0xe0, 0x42, 0x1d, 0xc5, 0x2b, 0x2c, 0xbb, 0xde, 0x94, 0xe0, 0xe1, 0xa5,
	0x59, 0x2c, 0x8e, 0xe2, 0x15, 0xad, 0x45, 0x91, 0x2f, 0x60, 0x60, 0x0a, 0x4d, 0xab, 0xc4, 0x63,
	0x85, 0xed, 0xd6, 0x9b, 0xee, 0x95, 0x39, 0x19, 0x27, 0xdd, 0x0e, 0x22, 0x5f, 0x81, 0x67, 0xcb,
	0x53, 0x8f, 0x08, 0xb3, 0xb1, 0x83, 0x1b, 0x3d, 0x9d, 0x22, 0xaa, 0x5d, 0x26, 0x77, 0x23, 0x52,
	0xb7, 0xdb, 0xf1, 0x39, 0x13, 0x82, 0xaf, 0x6d, 0x9b, 0x96, 0x10, 0x67, 0x94, 0x59, 0x86, 0x33,
	0x1c, 0xa3, 0x2e, 0xdd, 0x18, 0x82, 0x5f, 0x1d, 0x5b, 0x76, 0xbd, 0x6a, 0x1c, 0x79, 0x3b, 0xba,
	0xc2, 0xaa, 0x81, 0xe3, 0x39, 0xe4, 0x36, 0x10, 0xca, 0x2f, 0xd2, 0x4b, 0x5e, 0x67, 0xd3, 0x6b,
	0x90, 0xf7, 0xe0, 0x16, 0xa6, 0xb5, 0x65, 0x6e, 0x92, 0x3d, 0x3d, 0x23, 0xc5, 0xc2, 0x30, 0xe3,
	0xb9, 0xfa, 0x68, 0x7b, 0x49, 0x6f, 0x57, 0x3b, 0x37, 0x69, 0x7b, 0x6d, 0x72, 0x0b, 0x06, 0xa6,
	0x1f, 0x6d, 0x4e, 0x5e, 0x27, 0x78, 0x00, 0x2d, 0x23, 0xe9, 0x18, 0x3a, 0x27, 0x5c, 0x4a, 0xb6,
	0xe4, 0xd2, 0x77, 0x46, 0xcd, 0x71, 0x6f, 0xda, 0xd7, 0x54, 0x9c, 0xc8, 0x25, 0x0e, 0x06, 0x5a,
	0x79, 0x83, 0x0c, 0xf6, 0xaf, 0x89, 0x4d, 0x1e, 0x40, 0xdb, 0xd2, 0x85, 0x15, 0xd7, 0x9b, 0xde,
	0x99, 0x18, 0xd5, 0x36, 0xf5, 0x60, 0xd9, 0x2c, 0xe3, 0xec, 0x18, 0xac, 0x0f, 0xad, 0x0a, 0xdb,
	0x69, 0xd1, 0xac, 0x5e, 0x90, 0x15, 0x0c, 0xb6, 0x2a, 0xa0, 0xae, 0x80, 0xb3, 0xad, 0xc0, 0xbb,
	0x8e, 0x25, 0xe0, 0xe2, 0xe3, 0xd7, 0x1c, 0x35, 0xc7, 0x2e, 0xc5, 0x35, 0xf1, 0xa0, 0xa9, 0x8b,
	0xcd, 0x45, 0x93, 0x5e, 0x06, 0x73, 0xe8, 0x56, 0x75, 0x43, 0xee, 0x5d, 0xbf, 0x18, 0xc1, 0xfa,
	0x30, 0x8c, 0xde, 0xb8, 0x93, 0xaf, 0xa3, 0xcf, 0x72, 0x2e, 0x4d, 0x07, 0x75, 0x68, 0x09, 0x83,
	0x9f, 0x1c, 0xe8, 0xeb, 0xfe, 0x9b, 0x0b, 0x96, 0xc9, 0xf3, 0x54, 0x91, 0x4f, 0xa0, 0x6d, 0x3e,
	0x51, 0xb2, 0xbd, 0x6f, 0x86, 0x5e, 0x35, 0xe4, 0x69, 0xe9, 0x27, 0x9f, 0x41, 0xc7, 0xde, 0x4e,
	0xfa, 0x0d, 0x8c, 0x35, 0x1d, 0x67, 0x8d, 0xe5, 0x91, 0xb4, 0x8a, 0xc2, 0xe7, 0x8e, 0x2d, 0x16,
	0x89, 0x58, 0xda, 0x59, 0x58, 0xc2, 0xe0, 0x2f, 0x07, 0xf6, 0xaf, 0xed, 0x7b, 0x07, 0x99, 0x07,
	0xd0, 0x7a, 0x9c, 0xe4, 0x52, 0x95, 0xef, 0x32, 0x02, 0x4d, 0xe3, 0x77, 0x4c, 0x2a, 0xab, 0x0f,
	0xae, 0xc9, 0xd7, 0xa8, 0x50, 0xa5, 0xb6, 0x44, 0x42, 0x7b, 0xd3, 0xf7, 0xcb, 0xee, 0xad, 0x3c,
	0x55, 0xb6, 0xdb, 0xf1, 0xba, 0x73, 0x9e, 0xf2, 0x2b, 0x35, 0x2f, 0xa2, 0x70, 0x86, 0xad, 0xef,
	0xd2, 0x8d, 0x61, 0xbb, 0xaf, 0x76, 0xaf, 0xf7, 0xd5, 0x8f, 0x70, 0xf0, 0xb6, 0x4f, 0x90, 0x0f,
	0xa1, 0x85, 0x7f, 0x1d, 0x56, 0xba, 0x41, 0x35, 0x4a, 0xb4, 0x91, 0x1a, 0x9f, 0x7e, 0xe2, 0xf5,
	0xf3, 0x7b, 0xca, 0x05, 0xf2, 0xd5, 0xc0, 0x42, 0xa8, 0x9b, 0x1e, 0x1e, 0xbc, 0xfe, 0x77, 0xb8,
	0xf3, 0xfa, 0xcd, 0xd0, 0xf9, 0xf3, 0xcd, 0xd0, 0xf9, 0xe7, 0xcd, 0xd0, 0xf9, 0xe5, 0xbf, 0xe1,
	0x4e, 0xb4, 0x8b, 0x7f, 0x90, 0x9f, 0xff, 0x1f, 0x00, 0x00, 0xff, 0xff, 0xc3, 0xd1, 0xdb, 0x9c,
	0xb5, 0x0a, 0x00, 0x00,
}
