// Code generated by go-swagger; DO NOT EDIT.

package file

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"
	"time"

	"golang.org/x/net/context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/swag"

	strfmt "github.com/go-openapi/strfmt"
)

// NewDownloadParams creates a new DownloadParams object
// with the default values initialized.
func NewDownloadParams() *DownloadParams {
	var ()
	return &DownloadParams{

		timeout: cr.DefaultTimeout,
	}
}

// NewDownloadParamsWithTimeout creates a new DownloadParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewDownloadParamsWithTimeout(timeout time.Duration) *DownloadParams {
	var ()
	return &DownloadParams{

		timeout: timeout,
	}
}

// NewDownloadParamsWithContext creates a new DownloadParams object
// with the default values initialized, and the ability to set a context for a request
func NewDownloadParamsWithContext(ctx context.Context) *DownloadParams {
	var ()
	return &DownloadParams{

		Context: ctx,
	}
}

// NewDownloadParamsWithHTTPClient creates a new DownloadParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewDownloadParamsWithHTTPClient(client *http.Client) *DownloadParams {
	var ()
	return &DownloadParams{
		HTTPClient: client,
	}
}

/*DownloadParams contains all the parameters to send to the API endpoint
for the download operation typically these are written to a http.Request
*/
type DownloadParams struct {

	/*AdditionalParameters
	  some plugin can take more parameters to send various contents
	derived from main resource. For example, for images, you can pass
	get_thumb & dimension


	*/
	AdditionalParameters *string
	/*Attachment
	  if set, send back a force-download, otherwise use Accept header to try to find the best response Content-Type.

	*/
	Attachment *bool
	/*Path
	  Workspace id or alias + full path to the node, e.g. "/my-files/path/to/node"

	*/
	Path string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the download params
func (o *DownloadParams) WithTimeout(timeout time.Duration) *DownloadParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the download params
func (o *DownloadParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the download params
func (o *DownloadParams) WithContext(ctx context.Context) *DownloadParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the download params
func (o *DownloadParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the download params
func (o *DownloadParams) WithHTTPClient(client *http.Client) *DownloadParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the download params
func (o *DownloadParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAdditionalParameters adds the additionalParameters to the download params
func (o *DownloadParams) WithAdditionalParameters(additionalParameters *string) *DownloadParams {
	o.SetAdditionalParameters(additionalParameters)
	return o
}

// SetAdditionalParameters adds the additionalParameters to the download params
func (o *DownloadParams) SetAdditionalParameters(additionalParameters *string) {
	o.AdditionalParameters = additionalParameters
}

// WithAttachment adds the attachment to the download params
func (o *DownloadParams) WithAttachment(attachment *bool) *DownloadParams {
	o.SetAttachment(attachment)
	return o
}

// SetAttachment adds the attachment to the download params
func (o *DownloadParams) SetAttachment(attachment *bool) {
	o.Attachment = attachment
}

// WithPath adds the path to the download params
func (o *DownloadParams) WithPath(path string) *DownloadParams {
	o.SetPath(path)
	return o
}

// SetPath adds the path to the download params
func (o *DownloadParams) SetPath(path string) {
	o.Path = path
}

// WriteToRequest writes these params to a swagger request
func (o *DownloadParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AdditionalParameters != nil {

		// query param additional_parameters
		var qrAdditionalParameters string
		if o.AdditionalParameters != nil {
			qrAdditionalParameters = *o.AdditionalParameters
		}
		qAdditionalParameters := qrAdditionalParameters
		if qAdditionalParameters != "" {
			if err := r.SetQueryParam("additional_parameters", qAdditionalParameters); err != nil {
				return err
			}
		}

	}

	if o.Attachment != nil {

		// query param attachment
		var qrAttachment bool
		if o.Attachment != nil {
			qrAttachment = *o.Attachment
		}
		qAttachment := swag.FormatBool(qrAttachment)
		if qAttachment != "" {
			if err := r.SetQueryParam("attachment", qAttachment); err != nil {
				return err
			}
		}

	}

	// path param path
	if err := r.SetPathParam("path", o.Path); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
