// Code generated by go-swagger; DO NOT EDIT.

package file

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"io"

	"github.com/go-openapi/runtime"

	strfmt "github.com/go-openapi/strfmt"
)

// New creates a new file API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) *Client {
	return &Client{transport: transport, formats: formats}
}

/*
Client for file API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

/*
CreateNode Create new resources or move/copy existing resources:
+ Create a new folder (pass a path **with a trailing slash**), or a new empty file (no trailing slash).
+ Copy a resource to a new destination: pass destination as {path}, and origin via copy_from parameter.
+ Rename / Move a resource : basically a copy operation followed by a delete of original

*/
func (a *Client) CreateNode(params *CreateNodeParams, authInfo runtime.ClientAuthInfoWriter) (*CreateNodeOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateNodeParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "createNode",
		Method:             "POST",
		PathPattern:        "/fs/{path}",
		ProducesMediaTypes: []string{"application/json", "application/xml"},
		ConsumesMediaTypes: []string{""},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &CreateNodeReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*CreateNodeOK), nil

}

/*
DeleteNode Delete existing resource

*/
func (a *Client) DeleteNode(params *DeleteNodeParams, authInfo runtime.ClientAuthInfoWriter) (*DeleteNodeOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDeleteNodeParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "deleteNode",
		Method:             "DELETE",
		PathPattern:        "/fs/{path}",
		ProducesMediaTypes: []string{"application/json", "application/xml"},
		ConsumesMediaTypes: []string{""},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DeleteNodeReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*DeleteNodeOK), nil

}

/*
Download Get resource content. Depending on the attachment parameter, will try to either trigger a download, or send binary stream with appropriate headers. Depending on the active plugins, may be able to serve: + Plain text + MP3/Wav Stream + MP4 Stream + On-the-fly generated images + On-the-fly generated thumbnails for images or pdf

*/
func (a *Client) Download(params *DownloadParams, authInfo runtime.ClientAuthInfoWriter, writer io.Writer) (*DownloadOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDownloadParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "download",
		Method:             "GET",
		PathPattern:        "/io/{path}",
		ProducesMediaTypes: []string{"application/octet-stream"},
		ConsumesMediaTypes: []string{""},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DownloadReader{formats: a.formats, writer: writer},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*DownloadOK), nil

}

/*
GetNodeInfos Get information about a node and its metadata. By default, it will return
Pydio "primary" metadata (stat, internal informations). Extended metadata can
be added by some plugins.
For collections (folders), pass the **children** parameter to list its content.
To access the actual content of the nodes, see the I/O API.

*/
func (a *Client) GetNodeInfos(params *GetNodeInfosParams, authInfo runtime.ClientAuthInfoWriter) (*GetNodeInfosOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetNodeInfosParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "getNodeInfos",
		Method:             "GET",
		PathPattern:        "/fs/{path}",
		ProducesMediaTypes: []string{"application/json", "application/xml"},
		ConsumesMediaTypes: []string{""},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetNodeInfosReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*GetNodeInfosOK), nil

}

/*
UpdateNode Update existing resources metadata (see I/O for content modification). Basic metadata is provided by core plugins, but they can be extended by other plugins.
For example :
`{"core": {"chmod": 777}}, {"user_meta":[{"metaName":"metaValue"}]}`
`{"bookmarks":{"bookmarked": true}, "locks":{"locked":true}, "meta.watch":{"watch":true}}`
etc...

*/
func (a *Client) UpdateNode(params *UpdateNodeParams, authInfo runtime.ClientAuthInfoWriter) (*UpdateNodeOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUpdateNodeParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "updateNode",
		Method:             "PATCH",
		PathPattern:        "/fs/{path}",
		ProducesMediaTypes: []string{"application/json", "application/xml"},
		ConsumesMediaTypes: []string{""},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UpdateNodeReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*UpdateNodeOK), nil

}

/*
UploadStream Create or update resource by posting to Input Stream

*/
func (a *Client) UploadStream(params *UploadStreamParams, authInfo runtime.ClientAuthInfoWriter) (*UploadStreamOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUploadStreamParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "uploadStream",
		Method:             "PUT",
		PathPattern:        "/io/{path}",
		ProducesMediaTypes: []string{""},
		ConsumesMediaTypes: []string{""},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UploadStreamReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*UploadStreamOK), nil

}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
