// Code generated by go-swagger; DO NOT EDIT.

package file

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"
	"time"

	"golang.org/x/net/context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/swag"

	strfmt "github.com/go-openapi/strfmt"
)

// NewGetNodeInfosParams creates a new GetNodeInfosParams object
// with the default values initialized.
func NewGetNodeInfosParams() *GetNodeInfosParams {
	var (
		maxDepthDefault     = int64(-1)
		maxNodesDefault     = int64(-1)
		metaDefault         = string("standard")
		pagePositionDefault = bool(false)
		remoteOrderDefault  = bool(false)
	)
	return &GetNodeInfosParams{
		MaxDepth:     &maxDepthDefault,
		MaxNodes:     &maxNodesDefault,
		Meta:         metaDefault,
		PagePosition: &pagePositionDefault,
		RemoteOrder:  &remoteOrderDefault,

		timeout: cr.DefaultTimeout,
	}
}

// NewGetNodeInfosParamsWithTimeout creates a new GetNodeInfosParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewGetNodeInfosParamsWithTimeout(timeout time.Duration) *GetNodeInfosParams {
	var (
		maxDepthDefault     = int64(-1)
		maxNodesDefault     = int64(-1)
		metaDefault         = string("standard")
		pagePositionDefault = bool(false)
		remoteOrderDefault  = bool(false)
	)
	return &GetNodeInfosParams{
		MaxDepth:     &maxDepthDefault,
		MaxNodes:     &maxNodesDefault,
		Meta:         metaDefault,
		PagePosition: &pagePositionDefault,
		RemoteOrder:  &remoteOrderDefault,

		timeout: timeout,
	}
}

// NewGetNodeInfosParamsWithContext creates a new GetNodeInfosParams object
// with the default values initialized, and the ability to set a context for a request
func NewGetNodeInfosParamsWithContext(ctx context.Context) *GetNodeInfosParams {
	var (
		maxDepthDefault     = int64(-1)
		maxNodesDefault     = int64(-1)
		metaDefault         = string("standard")
		pagePositionDefault = bool(false)
		remoteOrderDefault  = bool(false)
	)
	return &GetNodeInfosParams{
		MaxDepth:     &maxDepthDefault,
		MaxNodes:     &maxNodesDefault,
		Meta:         metaDefault,
		PagePosition: &pagePositionDefault,
		RemoteOrder:  &remoteOrderDefault,

		Context: ctx,
	}
}

// NewGetNodeInfosParamsWithHTTPClient creates a new GetNodeInfosParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewGetNodeInfosParamsWithHTTPClient(client *http.Client) *GetNodeInfosParams {
	var (
		maxDepthDefault     = int64(-1)
		maxNodesDefault     = int64(-1)
		metaDefault         = string("standard")
		pagePositionDefault = bool(false)
		remoteOrderDefault  = bool(false)
	)
	return &GetNodeInfosParams{
		MaxDepth:     &maxDepthDefault,
		MaxNodes:     &maxNodesDefault,
		Meta:         metaDefault,
		PagePosition: &pagePositionDefault,
		RemoteOrder:  &remoteOrderDefault,
		HTTPClient:   client,
	}
}

/*GetNodeInfosParams contains all the parameters to send to the API endpoint
for the get node infos operation typically these are written to a http.Request
*/
type GetNodeInfosParams struct {

	/*XIndexationRequired
	  Invalidate current index and trigger a background indexation

	*/
	XIndexationRequired *bool
	/*Children
	  Load children if node is a collection

	*/
	Children *string
	/*MaxDepth
	  If requiring children recursively, stop at the given depth. If -1, no limit.

	*/
	MaxDepth *int64
	/*MaxNodes
	  If requiring children recursively, stop at the given depth. If -1, no limit.

	*/
	MaxNodes *int64
	/*Meta
	  Level of precision for expected metadata

	*/
	Meta string
	/*OrderColumn
	  Order column to use for server-side sorting

	*/
	OrderColumn *string
	/*OrderDirection
	  Order direction to use for server-side sorting (asc or desc)

	*/
	OrderDirection *string
	/*PagePosition
	  For a single file, try to detect the page position in the parent node listing.

	*/
	PagePosition *bool
	/*Path
	  Workspace id or alias + full path to the node, e.g. "/my-files/path/to/node"

	*/
	Path string
	/*Recursive
	  If requiring children, load grandchildren recursively

	*/
	Recursive *bool
	/*RemoteOrder
	  Apply server-side sorting

	*/
	RemoteOrder *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the get node infos params
func (o *GetNodeInfosParams) WithTimeout(timeout time.Duration) *GetNodeInfosParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get node infos params
func (o *GetNodeInfosParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get node infos params
func (o *GetNodeInfosParams) WithContext(ctx context.Context) *GetNodeInfosParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get node infos params
func (o *GetNodeInfosParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get node infos params
func (o *GetNodeInfosParams) WithHTTPClient(client *http.Client) *GetNodeInfosParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get node infos params
func (o *GetNodeInfosParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithXIndexationRequired adds the xIndexationRequired to the get node infos params
func (o *GetNodeInfosParams) WithXIndexationRequired(xIndexationRequired *bool) *GetNodeInfosParams {
	o.SetXIndexationRequired(xIndexationRequired)
	return o
}

// SetXIndexationRequired adds the xIndexationRequired to the get node infos params
func (o *GetNodeInfosParams) SetXIndexationRequired(xIndexationRequired *bool) {
	o.XIndexationRequired = xIndexationRequired
}

// WithChildren adds the children to the get node infos params
func (o *GetNodeInfosParams) WithChildren(children *string) *GetNodeInfosParams {
	o.SetChildren(children)
	return o
}

// SetChildren adds the children to the get node infos params
func (o *GetNodeInfosParams) SetChildren(children *string) {
	o.Children = children
}

// WithMaxDepth adds the maxDepth to the get node infos params
func (o *GetNodeInfosParams) WithMaxDepth(maxDepth *int64) *GetNodeInfosParams {
	o.SetMaxDepth(maxDepth)
	return o
}

// SetMaxDepth adds the maxDepth to the get node infos params
func (o *GetNodeInfosParams) SetMaxDepth(maxDepth *int64) {
	o.MaxDepth = maxDepth
}

// WithMaxNodes adds the maxNodes to the get node infos params
func (o *GetNodeInfosParams) WithMaxNodes(maxNodes *int64) *GetNodeInfosParams {
	o.SetMaxNodes(maxNodes)
	return o
}

// SetMaxNodes adds the maxNodes to the get node infos params
func (o *GetNodeInfosParams) SetMaxNodes(maxNodes *int64) {
	o.MaxNodes = maxNodes
}

// WithMeta adds the meta to the get node infos params
func (o *GetNodeInfosParams) WithMeta(meta string) *GetNodeInfosParams {
	o.SetMeta(meta)
	return o
}

// SetMeta adds the meta to the get node infos params
func (o *GetNodeInfosParams) SetMeta(meta string) {
	o.Meta = meta
}

// WithOrderColumn adds the orderColumn to the get node infos params
func (o *GetNodeInfosParams) WithOrderColumn(orderColumn *string) *GetNodeInfosParams {
	o.SetOrderColumn(orderColumn)
	return o
}

// SetOrderColumn adds the orderColumn to the get node infos params
func (o *GetNodeInfosParams) SetOrderColumn(orderColumn *string) {
	o.OrderColumn = orderColumn
}

// WithOrderDirection adds the orderDirection to the get node infos params
func (o *GetNodeInfosParams) WithOrderDirection(orderDirection *string) *GetNodeInfosParams {
	o.SetOrderDirection(orderDirection)
	return o
}

// SetOrderDirection adds the orderDirection to the get node infos params
func (o *GetNodeInfosParams) SetOrderDirection(orderDirection *string) {
	o.OrderDirection = orderDirection
}

// WithPagePosition adds the pagePosition to the get node infos params
func (o *GetNodeInfosParams) WithPagePosition(pagePosition *bool) *GetNodeInfosParams {
	o.SetPagePosition(pagePosition)
	return o
}

// SetPagePosition adds the pagePosition to the get node infos params
func (o *GetNodeInfosParams) SetPagePosition(pagePosition *bool) {
	o.PagePosition = pagePosition
}

// WithPath adds the path to the get node infos params
func (o *GetNodeInfosParams) WithPath(path string) *GetNodeInfosParams {
	o.SetPath(path)
	return o
}

// SetPath adds the path to the get node infos params
func (o *GetNodeInfosParams) SetPath(path string) {
	o.Path = path
}

// WithRecursive adds the recursive to the get node infos params
func (o *GetNodeInfosParams) WithRecursive(recursive *bool) *GetNodeInfosParams {
	o.SetRecursive(recursive)
	return o
}

// SetRecursive adds the recursive to the get node infos params
func (o *GetNodeInfosParams) SetRecursive(recursive *bool) {
	o.Recursive = recursive
}

// WithRemoteOrder adds the remoteOrder to the get node infos params
func (o *GetNodeInfosParams) WithRemoteOrder(remoteOrder *bool) *GetNodeInfosParams {
	o.SetRemoteOrder(remoteOrder)
	return o
}

// SetRemoteOrder adds the remoteOrder to the get node infos params
func (o *GetNodeInfosParams) SetRemoteOrder(remoteOrder *bool) {
	o.RemoteOrder = remoteOrder
}

// WriteToRequest writes these params to a swagger request
func (o *GetNodeInfosParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.XIndexationRequired != nil {

		// header param X-Indexation-Required
		if err := r.SetHeaderParam("X-Indexation-Required", swag.FormatBool(*o.XIndexationRequired)); err != nil {
			return err
		}

	}

	if o.Children != nil {

		// query param children
		var qrChildren string
		if o.Children != nil {
			qrChildren = *o.Children
		}
		qChildren := qrChildren
		if qChildren != "" {
			if err := r.SetQueryParam("children", qChildren); err != nil {
				return err
			}
		}

	}

	if o.MaxDepth != nil {

		// form param max_depth
		var frMaxDepth int64
		if o.MaxDepth != nil {
			frMaxDepth = *o.MaxDepth
		}
		fMaxDepth := swag.FormatInt64(frMaxDepth)
		if fMaxDepth != "" {
			if err := r.SetFormParam("max_depth", fMaxDepth); err != nil {
				return err
			}
		}

	}

	if o.MaxNodes != nil {

		// form param max_nodes
		var frMaxNodes int64
		if o.MaxNodes != nil {
			frMaxNodes = *o.MaxNodes
		}
		fMaxNodes := swag.FormatInt64(frMaxNodes)
		if fMaxNodes != "" {
			if err := r.SetFormParam("max_nodes", fMaxNodes); err != nil {
				return err
			}
		}

	}

	// query param meta
	qrMeta := o.Meta
	qMeta := qrMeta
	if qMeta != "" {
		if err := r.SetQueryParam("meta", qMeta); err != nil {
			return err
		}
	}

	if o.OrderColumn != nil {

		// form param order_column
		var frOrderColumn string
		if o.OrderColumn != nil {
			frOrderColumn = *o.OrderColumn
		}
		fOrderColumn := frOrderColumn
		if fOrderColumn != "" {
			if err := r.SetFormParam("order_column", fOrderColumn); err != nil {
				return err
			}
		}

	}

	if o.OrderDirection != nil {

		// form param order_direction
		var frOrderDirection string
		if o.OrderDirection != nil {
			frOrderDirection = *o.OrderDirection
		}
		fOrderDirection := frOrderDirection
		if fOrderDirection != "" {
			if err := r.SetFormParam("order_direction", fOrderDirection); err != nil {
				return err
			}
		}

	}

	if o.PagePosition != nil {

		// form param page_position
		var frPagePosition bool
		if o.PagePosition != nil {
			frPagePosition = *o.PagePosition
		}
		fPagePosition := swag.FormatBool(frPagePosition)
		if fPagePosition != "" {
			if err := r.SetFormParam("page_position", fPagePosition); err != nil {
				return err
			}
		}

	}

	// path param path
	if err := r.SetPathParam("path", o.Path); err != nil {
		return err
	}

	if o.Recursive != nil {

		// form param recursive
		var frRecursive bool
		if o.Recursive != nil {
			frRecursive = *o.Recursive
		}
		fRecursive := swag.FormatBool(frRecursive)
		if fRecursive != "" {
			if err := r.SetFormParam("recursive", fRecursive); err != nil {
				return err
			}
		}

	}

	if o.RemoteOrder != nil {

		// form param remote_order
		var frRemoteOrder bool
		if o.RemoteOrder != nil {
			frRemoteOrder = *o.RemoteOrder
		}
		fRemoteOrder := swag.FormatBool(frRemoteOrder)
		if fRemoteOrder != "" {
			if err := r.SetFormParam("remote_order", fRemoteOrder); err != nil {
				return err
			}
		}

	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
