// Code generated by go-swagger; DO NOT EDIT.

package file

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"
	"time"

	"golang.org/x/net/context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"

	strfmt "github.com/go-openapi/strfmt"
)

// NewUpdateNodeParams creates a new UpdateNodeParams object
// with the default values initialized.
func NewUpdateNodeParams() *UpdateNodeParams {
	var ()
	return &UpdateNodeParams{

		timeout: cr.DefaultTimeout,
	}
}

// NewUpdateNodeParamsWithTimeout creates a new UpdateNodeParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewUpdateNodeParamsWithTimeout(timeout time.Duration) *UpdateNodeParams {
	var ()
	return &UpdateNodeParams{

		timeout: timeout,
	}
}

// NewUpdateNodeParamsWithContext creates a new UpdateNodeParams object
// with the default values initialized, and the ability to set a context for a request
func NewUpdateNodeParamsWithContext(ctx context.Context) *UpdateNodeParams {
	var ()
	return &UpdateNodeParams{

		Context: ctx,
	}
}

// NewUpdateNodeParamsWithHTTPClient creates a new UpdateNodeParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewUpdateNodeParamsWithHTTPClient(client *http.Client) *UpdateNodeParams {
	var ()
	return &UpdateNodeParams{
		HTTPClient: client,
	}
}

/*UpdateNodeParams contains all the parameters to send to the API endpoint
for the update node operation typically these are written to a http.Request
*/
type UpdateNodeParams struct {

	/*Metadata
	  Json-serialized metadata to update

	*/
	Metadata string
	/*Path
	  Workspace id or alias + full path to the node, e.g. "/my-files/path/to/node"

	*/
	Path string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the update node params
func (o *UpdateNodeParams) WithTimeout(timeout time.Duration) *UpdateNodeParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the update node params
func (o *UpdateNodeParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the update node params
func (o *UpdateNodeParams) WithContext(ctx context.Context) *UpdateNodeParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the update node params
func (o *UpdateNodeParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the update node params
func (o *UpdateNodeParams) WithHTTPClient(client *http.Client) *UpdateNodeParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the update node params
func (o *UpdateNodeParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithMetadata adds the metadata to the update node params
func (o *UpdateNodeParams) WithMetadata(metadata string) *UpdateNodeParams {
	o.SetMetadata(metadata)
	return o
}

// SetMetadata adds the metadata to the update node params
func (o *UpdateNodeParams) SetMetadata(metadata string) {
	o.Metadata = metadata
}

// WithPath adds the path to the update node params
func (o *UpdateNodeParams) WithPath(path string) *UpdateNodeParams {
	o.SetPath(path)
	return o
}

// SetPath adds the path to the update node params
func (o *UpdateNodeParams) SetPath(path string) {
	o.Path = path
}

// WriteToRequest writes these params to a swagger request
func (o *UpdateNodeParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// form param metadata
	frMetadata := o.Metadata
	fMetadata := frMetadata
	if fMetadata != "" {
		if err := r.SetFormParam("metadata", fMetadata); err != nil {
			return err
		}
	}

	// path param path
	if err := r.SetPathParam("path", o.Path); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
