// Code generated by go-swagger; DO NOT EDIT.

package provisioning

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"
	"time"

	"golang.org/x/net/context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/swag"

	strfmt "github.com/go-openapi/strfmt"
)

// NewAdminLoadSharedElementDataParams creates a new AdminLoadSharedElementDataParams object
// with the default values initialized.
func NewAdminLoadSharedElementDataParams() *AdminLoadSharedElementDataParams {
	var ()
	return &AdminLoadSharedElementDataParams{

		timeout: cr.DefaultTimeout,
	}
}

// NewAdminLoadSharedElementDataParamsWithTimeout creates a new AdminLoadSharedElementDataParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewAdminLoadSharedElementDataParamsWithTimeout(timeout time.Duration) *AdminLoadSharedElementDataParams {
	var ()
	return &AdminLoadSharedElementDataParams{

		timeout: timeout,
	}
}

// NewAdminLoadSharedElementDataParamsWithContext creates a new AdminLoadSharedElementDataParams object
// with the default values initialized, and the ability to set a context for a request
func NewAdminLoadSharedElementDataParamsWithContext(ctx context.Context) *AdminLoadSharedElementDataParams {
	var ()
	return &AdminLoadSharedElementDataParams{

		Context: ctx,
	}
}

// NewAdminLoadSharedElementDataParamsWithHTTPClient creates a new AdminLoadSharedElementDataParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewAdminLoadSharedElementDataParamsWithHTTPClient(client *http.Client) *AdminLoadSharedElementDataParams {
	var ()
	return &AdminLoadSharedElementDataParams{
		HTTPClient: client,
	}
}

/*AdminLoadSharedElementDataParams contains all the parameters to send to the API endpoint
for the admin load shared element data operation typically these are written to a http.Request
*/
type AdminLoadSharedElementDataParams struct {

	/*File
	  relative file path in workspace

	*/
	File string
	/*Merged*/
	Merged *bool
	/*Owner
	  file path and owner id

	*/
	Owner *string
	/*TmpRepositoryID*/
	TmpRepositoryID *string
	/*WorkspaceID
	  Id of Alias of workspace

	*/
	WorkspaceID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the admin load shared element data params
func (o *AdminLoadSharedElementDataParams) WithTimeout(timeout time.Duration) *AdminLoadSharedElementDataParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the admin load shared element data params
func (o *AdminLoadSharedElementDataParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the admin load shared element data params
func (o *AdminLoadSharedElementDataParams) WithContext(ctx context.Context) *AdminLoadSharedElementDataParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the admin load shared element data params
func (o *AdminLoadSharedElementDataParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the admin load shared element data params
func (o *AdminLoadSharedElementDataParams) WithHTTPClient(client *http.Client) *AdminLoadSharedElementDataParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the admin load shared element data params
func (o *AdminLoadSharedElementDataParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFile adds the file to the admin load shared element data params
func (o *AdminLoadSharedElementDataParams) WithFile(file string) *AdminLoadSharedElementDataParams {
	o.SetFile(file)
	return o
}

// SetFile adds the file to the admin load shared element data params
func (o *AdminLoadSharedElementDataParams) SetFile(file string) {
	o.File = file
}

// WithMerged adds the merged to the admin load shared element data params
func (o *AdminLoadSharedElementDataParams) WithMerged(merged *bool) *AdminLoadSharedElementDataParams {
	o.SetMerged(merged)
	return o
}

// SetMerged adds the merged to the admin load shared element data params
func (o *AdminLoadSharedElementDataParams) SetMerged(merged *bool) {
	o.Merged = merged
}

// WithOwner adds the owner to the admin load shared element data params
func (o *AdminLoadSharedElementDataParams) WithOwner(owner *string) *AdminLoadSharedElementDataParams {
	o.SetOwner(owner)
	return o
}

// SetOwner adds the owner to the admin load shared element data params
func (o *AdminLoadSharedElementDataParams) SetOwner(owner *string) {
	o.Owner = owner
}

// WithTmpRepositoryID adds the tmpRepositoryID to the admin load shared element data params
func (o *AdminLoadSharedElementDataParams) WithTmpRepositoryID(tmpRepositoryID *string) *AdminLoadSharedElementDataParams {
	o.SetTmpRepositoryID(tmpRepositoryID)
	return o
}

// SetTmpRepositoryID adds the tmpRepositoryId to the admin load shared element data params
func (o *AdminLoadSharedElementDataParams) SetTmpRepositoryID(tmpRepositoryID *string) {
	o.TmpRepositoryID = tmpRepositoryID
}

// WithWorkspaceID adds the workspaceID to the admin load shared element data params
func (o *AdminLoadSharedElementDataParams) WithWorkspaceID(workspaceID string) *AdminLoadSharedElementDataParams {
	o.SetWorkspaceID(workspaceID)
	return o
}

// SetWorkspaceID adds the workspaceId to the admin load shared element data params
func (o *AdminLoadSharedElementDataParams) SetWorkspaceID(workspaceID string) {
	o.WorkspaceID = workspaceID
}

// WriteToRequest writes these params to a swagger request
func (o *AdminLoadSharedElementDataParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param file
	if err := r.SetPathParam("file", o.File); err != nil {
		return err
	}

	if o.Merged != nil {

		// form param merged
		var frMerged bool
		if o.Merged != nil {
			frMerged = *o.Merged
		}
		fMerged := swag.FormatBool(frMerged)
		if fMerged != "" {
			if err := r.SetFormParam("merged", fMerged); err != nil {
				return err
			}
		}

	}

	if o.Owner != nil {

		// form param owner
		var frOwner string
		if o.Owner != nil {
			frOwner = *o.Owner
		}
		fOwner := frOwner
		if fOwner != "" {
			if err := r.SetFormParam("owner", fOwner); err != nil {
				return err
			}
		}

	}

	if o.TmpRepositoryID != nil {

		// form param tmp_repository_id
		var frTmpRepositoryID string
		if o.TmpRepositoryID != nil {
			frTmpRepositoryID = *o.TmpRepositoryID
		}
		fTmpRepositoryID := frTmpRepositoryID
		if fTmpRepositoryID != "" {
			if err := r.SetFormParam("tmp_repository_id", fTmpRepositoryID); err != nil {
				return err
			}
		}

	}

	// path param workspaceId
	if err := r.SetPathParam("workspaceId", o.WorkspaceID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
