// Code generated by go-swagger; DO NOT EDIT.

package provisioning

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"
	"time"

	"golang.org/x/net/context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"

	strfmt "github.com/go-openapi/strfmt"
)

// NewCreatePeopleParams creates a new CreatePeopleParams object
// with the default values initialized.
func NewCreatePeopleParams() *CreatePeopleParams {
	var ()
	return &CreatePeopleParams{

		timeout: cr.DefaultTimeout,
	}
}

// NewCreatePeopleParamsWithTimeout creates a new CreatePeopleParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewCreatePeopleParamsWithTimeout(timeout time.Duration) *CreatePeopleParams {
	var ()
	return &CreatePeopleParams{

		timeout: timeout,
	}
}

// NewCreatePeopleParamsWithContext creates a new CreatePeopleParams object
// with the default values initialized, and the ability to set a context for a request
func NewCreatePeopleParamsWithContext(ctx context.Context) *CreatePeopleParams {
	var ()
	return &CreatePeopleParams{

		Context: ctx,
	}
}

// NewCreatePeopleParamsWithHTTPClient creates a new CreatePeopleParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewCreatePeopleParamsWithHTTPClient(client *http.Client) *CreatePeopleParams {
	var ()
	return &CreatePeopleParams{
		HTTPClient: client,
	}
}

/*CreatePeopleParams contains all the parameters to send to the API endpoint
for the create people operation typically these are written to a http.Request
*/
type CreatePeopleParams struct {

	/*Format
	  Format produced in output (defaults to xml)

	*/
	Format *string
	/*GroupLabel
	  Label of the new group if we are creating a group

	*/
	GroupLabel *string
	/*Path
	  User or group identifier, including full group path

	*/
	Path string
	/*ResourceType
	  Wether it's a user or a group

	*/
	ResourceType string
	/*UserPass
	  Password of the new user if we are creating a user

	*/
	UserPass *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the create people params
func (o *CreatePeopleParams) WithTimeout(timeout time.Duration) *CreatePeopleParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the create people params
func (o *CreatePeopleParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the create people params
func (o *CreatePeopleParams) WithContext(ctx context.Context) *CreatePeopleParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the create people params
func (o *CreatePeopleParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the create people params
func (o *CreatePeopleParams) WithHTTPClient(client *http.Client) *CreatePeopleParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the create people params
func (o *CreatePeopleParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFormat adds the format to the create people params
func (o *CreatePeopleParams) WithFormat(format *string) *CreatePeopleParams {
	o.SetFormat(format)
	return o
}

// SetFormat adds the format to the create people params
func (o *CreatePeopleParams) SetFormat(format *string) {
	o.Format = format
}

// WithGroupLabel adds the groupLabel to the create people params
func (o *CreatePeopleParams) WithGroupLabel(groupLabel *string) *CreatePeopleParams {
	o.SetGroupLabel(groupLabel)
	return o
}

// SetGroupLabel adds the groupLabel to the create people params
func (o *CreatePeopleParams) SetGroupLabel(groupLabel *string) {
	o.GroupLabel = groupLabel
}

// WithPath adds the path to the create people params
func (o *CreatePeopleParams) WithPath(path string) *CreatePeopleParams {
	o.SetPath(path)
	return o
}

// SetPath adds the path to the create people params
func (o *CreatePeopleParams) SetPath(path string) {
	o.Path = path
}

// WithResourceType adds the resourceType to the create people params
func (o *CreatePeopleParams) WithResourceType(resourceType string) *CreatePeopleParams {
	o.SetResourceType(resourceType)
	return o
}

// SetResourceType adds the resourceType to the create people params
func (o *CreatePeopleParams) SetResourceType(resourceType string) {
	o.ResourceType = resourceType
}

// WithUserPass adds the userPass to the create people params
func (o *CreatePeopleParams) WithUserPass(userPass *string) *CreatePeopleParams {
	o.SetUserPass(userPass)
	return o
}

// SetUserPass adds the userPass to the create people params
func (o *CreatePeopleParams) SetUserPass(userPass *string) {
	o.UserPass = userPass
}

// WriteToRequest writes these params to a swagger request
func (o *CreatePeopleParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Format != nil {

		// query param format
		var qrFormat string
		if o.Format != nil {
			qrFormat = *o.Format
		}
		qFormat := qrFormat
		if qFormat != "" {
			if err := r.SetQueryParam("format", qFormat); err != nil {
				return err
			}
		}

	}

	if o.GroupLabel != nil {

		// form param groupLabel
		var frGroupLabel string
		if o.GroupLabel != nil {
			frGroupLabel = *o.GroupLabel
		}
		fGroupLabel := frGroupLabel
		if fGroupLabel != "" {
			if err := r.SetFormParam("groupLabel", fGroupLabel); err != nil {
				return err
			}
		}

	}

	// path param path
	if err := r.SetPathParam("path", o.Path); err != nil {
		return err
	}

	// form param resourceType
	frResourceType := o.ResourceType
	fResourceType := frResourceType
	if fResourceType != "" {
		if err := r.SetFormParam("resourceType", fResourceType); err != nil {
			return err
		}
	}

	if o.UserPass != nil {

		// form param userPass
		var frUserPass string
		if o.UserPass != nil {
			frUserPass = *o.UserPass
		}
		fUserPass := frUserPass
		if fUserPass != "" {
			if err := r.SetFormParam("userPass", fUserPass); err != nil {
				return err
			}
		}

	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
